/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _SERVICE_AREA_LIST_H_
#define _SERVICE_AREA_LIST_H_

#include <stdint.h>
#include "bstrlib.h"
#include "_5GSTrackingAreaIdentityList.h"
#include <stdbool.h>

#define SERVICE_AREA_LIST_MINIMUM_LENGTH 6
#define SERVICE_AREA_LIST_MAXIMUM_LENGTH 114

#define ALL_TAIS_BELONGING_TO_THE_PLMNS_IN_THE_REGISTRATION_AREA_ARE_IN_THE_ALLOWED_AREA \
  0b11

struct PartialServiceAreaList {
  bool is_allowed;
  uint8_t typeOfList;
  uint8_t numberOfElements;
  struct MccMnc* mcc_mnc;
  struct TrackingAreaIdentity* tai;
  struct PartialServiceAreaList* next;
};

typedef struct {
  int listSize;
  struct PartialServiceAreaList* partialServiceAreaList;
} ServiceAreaList;

int encode_service_area_list(
    ServiceAreaList servicearealist, uint8_t iei, uint8_t* buffer,
    uint32_t len);
int decode_service_area_list(
    ServiceAreaList* servicearealist, uint8_t iei, uint8_t* buffer,
    uint32_t len);

#endif
