/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef __5GSDRX_PARAMETERS_H_
#define __5GSDRX_PARAMETERS_H_

#include <stdint.h>
#include "bstrlib.h"

#define _5GSDRX_PARAMETERS_MINIMUM_LENGTH 3
#define _5GSDRX_PARAMETERS_MAXIMUM_LENGTH 3

#define DRX_VALUE_NOT_SPECIFIED 0b0000
#define DRX_CYCLE_PARAMETER_T_32 0b0001
#define DRX_CYCLE_PARAMETER_T_64 0b0010
#define DRX_CYCLE_PARAMETER_T_128 0b0011
#define DRX_CYCLE_PARAMETER_T_256 0b0100

typedef uint8_t _5GSDRXParameters;

int encode__5gsdrx_parameters(
    _5GSDRXParameters _5gsdrxparameters, uint8_t iei, uint8_t* buffer,
    uint32_t len);
int decode__5gsdrx_parameters(
    _5GSDRXParameters* _5gsdrxparameters, uint8_t iei, uint8_t* buffer,
    uint32_t len);

#endif
