/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef __5GS_IDENTITY_TYPE_H_
#define __5GS_IDENTITY_TYPE_H_

#include <stdint.h>
#include "bstrlib.h"

#define _5GS_IDENTITY_TYPE_MINIMUM_LENGTH 1
#define _5GS_IDENTITY_TYPE_MAXIMUM_LENGTH 1

#define IDENTITY_REQUEST_SUCI 0x01
#define IDENTITY_REQUEST_5G_GUTI 0x02
#define IDENTITY_REQUEST_IMEI 0x03
#define IDENTITY_REQUEST_5G_S_TMSI 0x04
#define IDENTITY_REQUEST_IMEISV 0x05

typedef struct {
  uint8_t typeOfIdentity : 3;
} _5GSIdentityType;

int encode__5gs_identity_type(
    _5GSIdentityType _5gsidentitytype, uint8_t iei, uint8_t* buffer,
    uint32_t len);
int decode__5gs_identity_type(
    _5GSIdentityType* _5gsidentitytype, uint8_t iei, uint8_t* buffer,
    uint32_t len);

#endif
