/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef __5GSMCAPABILITY_H_
#define __5GSMCAPABILITY_H_

#include <stdint.h>
#include <stdbool.h>
#include "bstrlib.h"

#define _5GSM_CAPABILITY_MINIMUM_LENGTH 3
#define _5GSM_CAPABILITY_MAXIMUM_LENGTH 15

#define _5GSM_CAPABILITY_MINIMUM_LENGTH_TLV 3
#define _5GSM_CAPABILITY_MAXIMUM_LENGTH_TLV 15

#define REFLECTIVE_QOS_NOT_SUPPORTED 0
#define REFLECTIVE_QOS_SUPPORTED 1
#define MULTI_HOMED_IPV6_PDU_SESSION_NOT_SUPPORTED 0
#define MULTI_HOMED_IPV6_PDU_SESSION_SUPPORTED 1
#define ETHERNET_PDN_TYPE_IN_S1_MODE_NOT_SUPPORTED 0
#define ETHERNET_PDN_TYPE_IN_S1_MODE_SUPPORTED 1
#define EATSSS_LOW_LAYER_FUNCTIONALITY_NOT_SUPPORTED 0
#define EATSSS_LOW_LAYER_FUNCTIONALITY_SUPPORTED 1
#define MPTCP_FUNCTIONALITY_NOT_SUPPORTED 0
#define MPTCP_FUNCTIONALITY_SUPPORTED 1

typedef struct {
  bool is_Rqos_supported;
  bool is_MH6PDU_supported;
  bool is_EPTS1_supported;
  bool is_ATSLL_supported;
  bool is_MPTCP_supported;
  // bstring _5GSMCapability_spare;
} _5GSMCapability;

int encode__5gsm_capability(
    _5GSMCapability _5gsmcapability, uint8_t iei, uint8_t* buffer,
    uint32_t len);
int decode__5gsm_capability(
    _5GSMCapability* _5gsmcapability, uint8_t iei, uint8_t* buffer,
    uint32_t len);

#endif
