/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#include "TLVEncoder.h"
#include "TLVDecoder.h"
#include "_5GSMCause.h"

int encode__5gsm_cause(
    _5GSMCause _5gsmcause, uint8_t iei, uint8_t* buffer, uint32_t len) {
  uint32_t encoded = 0;

  CHECK_PDU_POINTER_AND_LENGTH_ENCODER(
      buffer,
      ((iei > 0) ? _5GSM_CAUSE_MINIMUM_LENGTH_TV :
                   _5GSM_CAUSE_MINIMUM_LENGTH_V),
      len);

  if (iei > 0) {
    *buffer = iei;
    encoded++;
  }

  ENCODE_U8(buffer + encoded, _5gsmcause, encoded);

  return encoded;
}

int decode__5gsm_cause(
    _5GSMCause* _5gsmcause, uint8_t iei, uint8_t* buffer, uint32_t len) {
  int decoded = 0;

  if (iei > 0) {
    CHECK_IEI_DECODER(iei, *buffer);
    decoded++;
  }

  DECODE_U8(buffer + decoded, *_5gsmcause, decoded);

  return decoded;
}
