/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef __5GSMCONGESTIONREATTEMPTINDICATOR_H_
#define __5GSMCONGESTIONREATTEMPTINDICATOR_H_

#include <stdint.h>

#define _5GSM_CONGESTION_REATTEMPT_INDICATOR_MINIMUM_LENGTH 3
#define _5GSM_CONGESTION_REATTEMPT_INDICATOR_MAXIMUM_LENGTH 3

#define _5GSM_CONGESTION_REATTEMPT_INDICATOR_MINIMUM_LENGTH_TLV 3
#define _5GSM_CONGESTION_REATTEMPT_INDICATOR_MAXIMUM_LENGTH_TLV 3

#define THE_BACKOFF_TIMER_IS_APPLIED_IN_THE_REGISTERED_PLMN 0
#define THE_BACKOFF_TIMER_IS_APPLIED_IN_ALL_PLMNS 1

typedef struct {
  uint8_t abo : 1;
} _5GSMCongestionReattemptIndicator;

int encode__5gsm_congestion_reattempt_indicator(
    _5GSMCongestionReattemptIndicator _5gsmcongestionreattemptindicator,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode__5gsm_congestion_reattempt_indicator(
    _5GSMCongestionReattemptIndicator* _5gsmcongestionreattemptindicator,
    uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
