/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef __5GS_TRACKING_AREA_IDENTITY_H_
#define __5GS_TRACKING_AREA_IDENTITY_H_

#include <stdint.h>
#include "bstrlib.h"

#define _5GS_TRACKING_AREA_IDENTITY_MINIMUM_LENGTH 7
#define _5GS_TRACKING_AREA_IDENTITY_MAXIMUM_LENGTH 7

typedef struct {
  uint16_t mcc;
  uint16_t mnc;
  uint32_t tac;
} _5GSTrackingAreaIdentity;

int encode__5gs_tracking_area_identity(
    _5GSTrackingAreaIdentity _5gstrackingareaidentity, uint8_t iei,
    uint8_t* buffer, uint32_t len);
int decode__5gs_tracking_area_identity(
    _5GSTrackingAreaIdentity* _5gstrackingareaidentity, uint8_t iei,
    uint8_t* buffer, uint32_t len);

#endif
