/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef __5GS_UPDATE_TYPE_H_
#define __5GS_UPDATE_TYPE_H_

#include <stdint.h>
#include "bstrlib.h"

#define _5GS_UPDATE_TYPE_MINIMUM_LENGTH 3
#define _5GS_UPDATE_TYPE_MAXIMUM_LENGTH 3

#define SMS_OVER_NAS_NOT_SUPPORTED 0
#define SMS_OVER_NAS_SUPPORTED 1

#define NG_RAN_RADIO_CAPABILITY_UPDATE_NOT_NEEDED 0
#define NG_RAN_RADIO_CAPABILITY_UPDATE_NEEDED 1

typedef struct {
  uint8_t ng_ran_rcu;
  uint8_t sms_requested;
} _5GSUpdateType;

int encode__5gs_update_type(
    _5GSUpdateType _5gsupdatetype, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode__5gs_update_type(
    _5GSUpdateType* _5gsupdatetype, uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
