/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef SECURITY_MODE_COMPLETE_H_
#define SECURITY_MODE_COMPLETE_H_

#include <stdint.h>

#include "ExtendedProtocolDiscriminator.h"
#include "SecurityHeaderType.h"
#include "MessageType.h"
#include "_5GSMobileIdentity.h"
#include "NASMessageContainer.h"

/* Minimum length macro. Formed by minimum length of each mandatory field */
#define SECURITY_MODE_COMPLETE_MINIMUM_LENGTH                                  \
  (EXTENDED_PROTOCOL_DISCRIMINATOR_MINIMUM_LENGTH +                            \
   SECURITY_HEADER_TYPE_MINIMUM_LENGTH + MESSAGE_TYPE_MINIMUM_LENGTH +         \
   _5GS_MOBILE_IDENTITY_MINIMUM_LENGTH +                                       \
   NAS_MESSAGE_CONTAINER_MINIMUM_LENGTH + 0)

/* Maximum length macro. Formed by maximum length of each field */
#define SECURITY_MODE_COMPLETE_MAXIMUM_LENGTH                                  \
  (EXTENDED_PROTOCOL_DISCRIMINATOR_MAXIMUM_LENGTH +                            \
   SECURITY_HEADER_TYPE_MAXIMUM_LENGTH + MESSAGE_TYPE_MAXIMUM_LENGTH +         \
   _5GS_MOBILE_IDENTITY_MAXIMUM_LENGTH +                                       \
   NAS_MESSAGE_CONTAINER_MAXIMUM_LENGTH + 0)

#define SECURITY_MODE_COMPLETE_5G_MOBILE_IDENTITY_IEI 0x77
#define SECURITY_MODE_COMPLETE_5G_MOBILE_IDENTITY_PRESENT (1 << 0)
#define SECURITY_MODE_COMPLETE_NAS_MESSAGE_CONTAINER_IEI 0x71
#define SECURITY_MODE_COMPLETE_NAS_MESSAGE_CONTAINER_PRESENT (1 << 1)

typedef struct security_mode_complete_msg_tag {
  ExtendedProtocolDiscriminator extendedprotocoldiscriminator;
  SecurityHeaderType securityheadertype;
  MessageType messagetype;
  uint8_t presence;
  NASMessageContainer nasmessagecontainer;
} security_mode_complete_msg;

int decode_security_mode_complete(
    security_mode_complete_msg* securitymodecomplete, uint8_t* buffer,
    uint32_t len);
int encode_security_mode_complete(
    security_mode_complete_msg* securitymodecomplete, uint8_t* buffer,
    uint32_t len);

#endif
