/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef MM_MSG_DEF_H_
#define MM_MSG_DEF_H_

#include <stdint.h>
#include <asm/byteorder.h>

typedef struct {
#ifdef __LITTLE_ENDIAN_BITFIELD
  uint8_t extended_protocol_discriminator;
  uint8_t security_header_type : 4;
  uint8_t spare_half_octet : 4;
#endif
#ifdef __BIG_ENDIAN_BITFIELD
  uint8_t spare_half_octet : 4;
  uint8_t security_header_type : 4;
#endif
  uint8_t message_type;
} __attribute__((__packed__)) mm_msg_header_t;

#endif
