/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef FILE_SECU_DEFS_SEEN
#define FILE_SECU_DEFS_SEEN

#include "security_types.h"

#define SECU_DIRECTION_UPLINK 0
#define SECU_DIRECTION_DOWNLINK 1

void kdf(
    const uint8_t* key, const unsigned key_len, uint8_t* s,
    const unsigned s_len, uint8_t* out, const unsigned out_len);

int derive_keNB(
    const uint8_t* kasme_32, const uint32_t nas_count, uint8_t* keNB);

int derive_key_nas(
    algorithm_type_dist_t nas_alg_type, uint8_t nas_enc_alg_id,
    const uint8_t* kasme_32, uint8_t* knas);

#define derive_key_nas_enc(aLGiD, kASME, kNAS)                                 \
  derive_key_nas(NAS_ENC_ALG, aLGiD, kASME, kNAS)

#define derive_key_nas_int(aLGiD, kASME, kNAS)                                 \
  derive_key_nas(NAS_INT_ALG, aLGiD, kASME, kNAS)

#define derive_key_rrc_enc(aLGiD, kASME, kNAS)                                 \
  derive_key_nas(RRC_ENC_ALG, aLGiD, kASME, kNAS)

#define derive_key_rrc_int(aLGiD, kASME, kNAS)                                 \
  derive_key_nas(RRC_INT_ALG, aLGiD, kASME, kNAS)

#define derive_key_up_enc(aLGiD, kASME, kNAS)                                  \
  derive_key_nas(UP_ENC_ALG, aLGiD, kASME, kNAS)

#define derive_key_up_int(aLGiD, kASME, kNAS)                                  \
  derive_key_nas(UP_INT_ALG, aLGiD, kASME, kNAS)

#define SECU_DIRECTION_UPLINK 0
#define SECU_DIRECTION_DOWNLINK 1

typedef struct {
  uint8_t* key;
  uint32_t key_length;
  uint32_t count;
  uint8_t bearer;
  uint8_t direction;
  uint8_t* message;
  /* length in bits */
  uint32_t blength;
} nas_stream_cipher_t;

int nas_stream_encrypt_nea1(
    nas_stream_cipher_t* const stream_cipher, uint8_t* const out);

int nas_stream_encrypt_nia1(
    nas_stream_cipher_t* const stream_cipher, uint8_t const out[4]);

int nas_stream_encrypt_nea2(
    nas_stream_cipher_t* const stream_cipher, uint8_t* const out);

int nas_stream_encrypt_nia2(
    nas_stream_cipher_t* const stream_cipher, uint8_t const out[4]);

#undef SECU_DEBUG

#endif /* FILE_SECU_DEFS_SEEN */
