/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */



#ifndef FILE_SECURITYDEF_SEEN
#define FILE_SECURITYDEF_SEEN

/*
 * Index of the first byte of each fields of the AUTN parameter
 */
#define AUTH_SQN_INDEX 0
#define AUTH_AMF_INDEX (AUTH_SQN_INDEX + AUTH_SQN_SIZE)
#define AUTH_MAC_INDEX (AUTH_AMF_INDEX + AUTH_AMF_SIZE)

/*
 * Size of the authentication challenge parameters in bytes
 */
#define AUTH_SQN_SIZE 6 /* Sequence number:          48 bits  */
#define AUTH_AK_SIZE 6  /* Anonymity key:            48 bits  */
#define AUTH_AMF_SIZE 2 /* Authentication Management Field:  16 bits  */
#define AUTH_MAC_SIZE 8 /* Message Authentication Code:  64 bits  */
#define AUTH_AUTN_SIZE                                                         \
  16                          /* Authentication token:     128 bits            \
                   AUTN = (SQN ⊕ AK) || AMF || MAC        */
#define AUTH_MACS_SIZE 8      /* Re-synchronization MAC:       64 bits  */
#define AUTH_AUTS_SIZE 16     /* Re-synchronization AUT:       128 bits */
#define AUTH_RAND_SIZE 16     /* Random challenge:         128 bits     */
#define AUTH_CK_SIZE 16       /* Ciphering key:            128 bits     */
#define AUTH_IK_SIZE 16       /* Integrity key:            128 bits     */
#define AUTH_RES_SIZE 16      /* Authentication response:      128 bits */
#define AUTH_SNID_SIZE 3      /* Serving network's identity:   24 bits  */
#define AUTH_KASME_SIZE 32    /* KASME security key:        256 bits    */
#define AUTH_KNAS_INT_SIZE 16 /* NAS integrity key     */
#define AUTH_KNAS_ENC_SIZE 16 /* NAS cyphering key     */
#define AUTH_KENB_SIZE AUTH_KASME_SIZE /* eNodeB security key   */

/* "Separation bit" of AMF field */
#define AUTH_AMF_SEPARATION_BIT(a) ((a) &0x80)

/*
 * EPS authentication vector
 */
typedef struct {
  /* ASME security key                */
  uint8_t kasme[AUTH_KASME_SIZE];
  /* Random challenge parameter           */
  uint8_t rand[AUTH_RAND_SIZE];
  /* Authentication token parameter       */
  uint8_t autn[AUTH_AUTN_SIZE];
  /* Expected Authentication response parameter   */
#define AUTH_XRES_SIZE AUTH_RES_SIZE
  uint8_t xres_size;
  uint8_t xres[AUTH_XRES_SIZE];
} auth_vector_t;

#endif /* FILE_SECURITYDEF_SEEN*/
