/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */


#ifndef FILE_SMF_EVENT_HPP_SEEN
#define FILE_SMF_EVENT_HPP_SEEN

#include <boost/signals2.hpp>
namespace bs2 = boost::signals2;

#include "smf.h"
#include "smf_event_sig.hpp"

namespace smf {
class smf_event {
 public:
  smf_event(){};
  smf_event(smf_event const&) = delete;
  void operator=(smf_event const&) = delete;

  static smf_event& get_instance() {
    static smf_event instance;
    return instance;
  }

  // class register/handle event
  friend class smf_app;
  friend class smf_context;
  friend class smf_profile;

  /*
   * Subscribe to SM Context Status Notification signal
   * @param [const sm_context_status_sig_t::slot_type&] sig:  slot_type
   * parameter
   * @return boost::signals2::connection: the connection between the signal and
   * the slot
   */
  bs2::connection subscribe_sm_context_status(
      const sm_context_status_sig_t::slot_type& sig);

  /*
   * Subscribe to Event Exposure Event: PDU Session Release
   * @param [const ee_pdu_session_release_sig_t::slot_type&] sig:  slot_type
   * parameter
   * @return boost::signals2::connection: the connection between the signal and
   * the slot
   */
  bs2::connection subscribe_ee_pdu_session_release(
      const ee_pdu_session_release_sig_t::slot_type& sig);

 private:
  sm_context_status_sig_t
      sm_context_status;  // Signal for SM Context status update
  ee_pdu_session_release_sig_t
      ee_pdu_session_release;  // Signal for SM Context status update
};
}  // namespace smf
#endif /* FILE_SMF_EVENT_HPP_SEEN */
