/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */


#ifndef FILE_SMF_EVENT_SIG_HPP_SEEN
#define FILE_SMF_EVENT_SIG_HPP_SEEN

#include <boost/signals2.hpp>
#include <string>
#include "3gpp_24.007.h"

namespace bs2 = boost::signals2;

namespace smf {

// Signal for PDU session status
// SCID, PDU Session Status, HTTP version
typedef bs2::signal_type<
    void(scid_t, const std::string&, uint8_t),
    bs2::keywords::mutex_type<bs2::dummy_mutex>>::type sm_context_status_sig_t;

// Signal for Event exposure
// PDU session Release, SUPI, PDU SessionID, HTTP version
typedef bs2::signal_type<
    void(supi64_t, pdu_session_id_t, uint8_t),
    bs2::keywords::mutex_type<bs2::dummy_mutex>>::type
    ee_pdu_session_release_sig_t;

// TODO: ee_ue_ip_address_change_sig_t; //UI IP Address, UE ID
// TODO: Access Type Change
// TODO: UP Path Change
// TODO: PLMN Change
// TODO: Downlink data delivery status

}  // namespace smf
#endif /* FILE_SMF_EVENT_SIG_HPP_SEEN */
