/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */


#ifndef FILE_SMF_PCO_HPP_SEEN
#define FILE_SMF_PCO_HPP_SEEN

#include <stdint.h>

/**
 * protocol_configuration_options_ids_t
 *
 * Container for caching which protocol/container identifiers have been set in
 * the message sent by the UE.
 *
 * ID specifications based on 3GPP #24.008.
 */
typedef struct protocol_configuration_options_ids_s {
  // Protocol identifiers (from configuration protocol options list)
  uint8_t pi_ipcp : 1;

  // Container identifiers (from additional parameters list)
  uint8_t ci_dns_server_ipv4_address_request : 1;
  uint8_t ci_ip_address_allocation_via_nas_signalling : 1;
  uint8_t ci_ipv4_address_allocation_via_dhcpv4 : 1;
  uint8_t ci_ipv4_link_mtu_request : 1;
  uint8_t ci_dns_server_ipv6_address_request : 1;
} protocol_configuration_options_ids_t;

#endif
