/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */



#ifndef FILE_SMF_SUBSCRIPTION_HPP_SEEN
#define FILE_SMF_SUBSCRIPTION_HPP_SEEN

#include <map>
#include <memory>
#include <shared_mutex>
#include <utility>
#include <vector>

#include "3gpp_24.007.h"
#include "3gpp_29.508.h"
#include "common_root_types.h"
#include "itti.hpp"

namespace smf {

/*
 * Manage the Subscription Info
 */
class smf_subscription {
 public:
  smf_subscription() {}

 public:
  evsub_id_t sub_id;
  smf_event_t ev_type;
  supi64_t supi;
  std::string notif_id;
  std::string notif_uri;
  pdu_session_id_t pdu_session_id;
};

}  // namespace smf
#endif
