/**
 * Nsmf_EventExposure
 * Session Management Event Exposure Service. © 2019, 3GPP Organizational
 * Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

/*
 * IndividualSubscriptionDocumentApi.h
 *
 *
 */

#ifndef IndividualSubscriptionDocumentApi_H_
#define IndividualSubscriptionDocumentApi_H_

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>

#include "NsmfEventExposure.h"
#include "ProblemDetails.h"
#include <string>

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class IndividualSubscriptionDocumentApi {
 public:
  IndividualSubscriptionDocumentApi(std::shared_ptr<Pistache::Rest::Router>);
  virtual ~IndividualSubscriptionDocumentApi() {}
  void init();

  const std::string base = "/nsmf_event-exposure/";

 private:
  void setupRoutes();

  void delete_individual_subcription_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void get_individual_subcription_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void replace_individual_subcription_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void individual_subscription_document_api_default_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);

  std::shared_ptr<Pistache::Rest::Router> router;

  /// <summary>
  /// Delete an individual subscription for event notifications from the SMF
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="subId">Event Subscription ID</param>
  virtual void delete_individual_subcription(
      const std::string& subId, Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Read an individual subscription for event notifications from the SMF
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="subId">Event Subscription ID</param>
  virtual void get_individual_subcription(
      const std::string& subId, Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Replace an individual subscription for event notifications from the SMF
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="subId">Event Subscription ID</param>
  /// <param name="nsmfEventExposure"></param>
  virtual void replace_individual_subcription(
      const std::string& subId, const NsmfEventExposure& nsmfEventExposure,
      Pistache::Http::ResponseWriter& response) = 0;
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif /* IndividualSubscriptionDocumentApi_H_ */
