/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */
/*
 * PduSessionCreatedData.h
 *
 *
 */

#ifndef PduSessionCreatedData_H_
#define PduSessionCreatedData_H_

#include "Ambr.h"
#include "MaxIntegrityProtectedDataRate.h"
#include "RefToBinaryData.h"
#include <string>
#include "UpSecurity.h"
#include "QosFlowSetupItem.h"
#include "Snssai.h"
#include <vector>
#include "EpsPdnCnxInfo.h"
#include "EpsBearerInfo.h"
#include "PduSessionType.h"
#include "RoamingChargingProfile.h"
#include "TunnelInfo.h"
#include <nlohmann/json.hpp>

namespace oai {
namespace smf_server {
namespace model {

/// <summary>
///
/// </summary>
class PduSessionCreatedData {
 public:
  PduSessionCreatedData();
  virtual ~PduSessionCreatedData();

  void validate();

  /////////////////////////////////////////////
  /// PduSessionCreatedData members

  /// <summary>
  ///
  /// </summary>
  PduSessionType getPduSessionType() const;
  void setPduSessionType(PduSessionType const& value);
  /// <summary>
  ///
  /// </summary>
  std::string getSscMode() const;
  void setSscMode(std::string const& value);
  /// <summary>
  ///
  /// </summary>
  TunnelInfo getHcnTunnelInfo() const;
  void setHcnTunnelInfo(TunnelInfo const& value);
  bool hcnTunnelInfoIsSet() const;
  void unsetHcnTunnelInfo();
  /// <summary>
  ///
  /// </summary>
  Ambr getSessionAmbr() const;
  void setSessionAmbr(Ambr const& value);
  bool sessionAmbrIsSet() const;
  void unsetSessionAmbr();
  /// <summary>
  ///
  /// </summary>
  std::vector<QosFlowSetupItem>& getQosFlowsSetupList();
  bool qosFlowsSetupListIsSet() const;
  void unsetQosFlowsSetupList();
  /// <summary>
  ///
  /// </summary>
  std::string getHSmfInstanceId() const;
  void setHSmfInstanceId(std::string const& value);
  /// <summary>
  ///
  /// </summary>
  int32_t getPduSessionId() const;
  void setPduSessionId(int32_t const value);
  bool pduSessionIdIsSet() const;
  void unsetPduSessionId();
  /// <summary>
  ///
  /// </summary>
  Snssai getSNssai() const;
  void setSNssai(Snssai const& value);
  bool sNssaiIsSet() const;
  void unsetSNssai();
  /// <summary>
  ///
  /// </summary>
  bool isEnablePauseCharging() const;
  void setEnablePauseCharging(bool const value);
  bool enablePauseChargingIsSet() const;
  void unsetEnablePauseCharging();
  /// <summary>
  ///
  /// </summary>
  std::string getUeIpv4Address() const;
  void setUeIpv4Address(std::string const& value);
  bool ueIpv4AddressIsSet() const;
  void unsetUeIpv4Address();
  /// <summary>
  ///
  /// </summary>
  std::string getUeIpv6Prefix() const;
  void setUeIpv6Prefix(std::string const& value);
  bool ueIpv6PrefixIsSet() const;
  void unsetUeIpv6Prefix();
  /// <summary>
  ///
  /// </summary>
  RefToBinaryData getN1SmInfoToUe() const;
  void setN1SmInfoToUe(RefToBinaryData const& value);
  bool n1SmInfoToUeIsSet() const;
  void unsetN1SmInfoToUe();
  /// <summary>
  ///
  /// </summary>
  EpsPdnCnxInfo getEpsPdnCnxInfo() const;
  void setEpsPdnCnxInfo(EpsPdnCnxInfo const& value);
  bool epsPdnCnxInfoIsSet() const;
  void unsetEpsPdnCnxInfo();
  /// <summary>
  ///
  /// </summary>
  std::vector<EpsBearerInfo>& getEpsBearerInfo();
  bool epsBearerInfoIsSet() const;
  void unsetEpsBearerInfo();
  /// <summary>
  ///
  /// </summary>
  std::string getSupportedFeatures() const;
  void setSupportedFeatures(std::string const& value);
  bool supportedFeaturesIsSet() const;
  void unsetSupportedFeatures();
  /// <summary>
  ///
  /// </summary>
  MaxIntegrityProtectedDataRate getMaxIntegrityProtectedDataRate() const;
  void setMaxIntegrityProtectedDataRate(
      MaxIntegrityProtectedDataRate const& value);
  bool maxIntegrityProtectedDataRateIsSet() const;
  void unsetMaxIntegrityProtectedDataRate();
  /// <summary>
  ///
  /// </summary>
  bool isAlwaysOnGranted() const;
  void setAlwaysOnGranted(bool const value);
  bool alwaysOnGrantedIsSet() const;
  void unsetAlwaysOnGranted();
  /// <summary>
  ///
  /// </summary>
  std::string getGpsi() const;
  void setGpsi(std::string const& value);
  bool gpsiIsSet() const;
  void unsetGpsi();
  /// <summary>
  ///
  /// </summary>
  UpSecurity getUpSecurity() const;
  void setUpSecurity(UpSecurity const& value);
  bool upSecurityIsSet() const;
  void unsetUpSecurity();
  /// <summary>
  ///
  /// </summary>
  RoamingChargingProfile getRoamingChargingProfile() const;
  void setRoamingChargingProfile(RoamingChargingProfile const& value);
  bool roamingChargingProfileIsSet() const;
  void unsetRoamingChargingProfile();
  /// <summary>
  ///
  /// </summary>
  std::string getHSmfServiceInstanceId() const;
  void setHSmfServiceInstanceId(std::string const& value);
  bool hSmfServiceInstanceIdIsSet() const;
  void unsetHSmfServiceInstanceId();
  /// <summary>
  ///
  /// </summary>
  std::string getRecoveryTime() const;
  void setRecoveryTime(std::string const& value);
  bool recoveryTimeIsSet() const;
  void unsetRecoveryTime();

  friend void to_json(nlohmann::json& j, const PduSessionCreatedData& o);
  friend void from_json(const nlohmann::json& j, PduSessionCreatedData& o);

 protected:
  PduSessionType m_PduSessionType;

  std::string m_SscMode;

  TunnelInfo m_HcnTunnelInfo;
  bool m_HcnTunnelInfoIsSet;
  Ambr m_SessionAmbr;
  bool m_SessionAmbrIsSet;
  std::vector<QosFlowSetupItem> m_QosFlowsSetupList;
  bool m_QosFlowsSetupListIsSet;
  std::string m_HSmfInstanceId;

  int32_t m_PduSessionId;
  bool m_PduSessionIdIsSet;
  Snssai m_SNssai;
  bool m_SNssaiIsSet;
  bool m_EnablePauseCharging;
  bool m_EnablePauseChargingIsSet;
  std::string m_UeIpv4Address;
  bool m_UeIpv4AddressIsSet;
  std::string m_UeIpv6Prefix;
  bool m_UeIpv6PrefixIsSet;
  RefToBinaryData m_N1SmInfoToUe;
  bool m_N1SmInfoToUeIsSet;
  EpsPdnCnxInfo m_EpsPdnCnxInfo;
  bool m_EpsPdnCnxInfoIsSet;
  std::vector<EpsBearerInfo> m_EpsBearerInfo;
  bool m_EpsBearerInfoIsSet;
  std::string m_SupportedFeatures;
  bool m_SupportedFeaturesIsSet;
  MaxIntegrityProtectedDataRate m_MaxIntegrityProtectedDataRate;
  bool m_MaxIntegrityProtectedDataRateIsSet;
  bool m_AlwaysOnGranted;
  bool m_AlwaysOnGrantedIsSet;
  std::string m_Gpsi;
  bool m_GpsiIsSet;
  UpSecurity m_UpSecurity;
  bool m_UpSecurityIsSet;
  RoamingChargingProfile m_RoamingChargingProfile;
  bool m_RoamingChargingProfileIsSet;
  std::string m_HSmfServiceInstanceId;
  bool m_HSmfServiceInstanceIdIsSet;
  std::string m_RecoveryTime;
  bool m_RecoveryTimeIsSet;
};

}  // namespace model
}  // namespace smf_server
}  // namespace oai

#endif /* PduSessionCreatedData_H_ */
