/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

#include "PHY/CODING/nrPolar_tools/nr_polar_defs.h"

static const uint16_t Q_0_Nminus1_1[2] = {0, 1};
static const uint16_t Q_0_Nminus1_2[4] = {0, 1, 2, 3};
static const uint16_t Q_0_Nminus1_3[8] = {0, 1, 2, 4, 3, 5, 6, 7};
static const uint16_t Q_0_Nminus1_4[16] = {0, 1, 2, 4, 8, 3, 5, 9, 6, 10, 12, 7, 11, 13, 14, 15};
static const uint16_t Q_0_Nminus1_5[32] = {0, 1,  2,  4,  8,  16, 3,  5,  9,  6,  17, 10, 18, 12, 20, 24,
                                           7, 11, 19, 13, 14, 21, 26, 25, 22, 28, 15, 23, 27, 29, 30, 31};
static const uint16_t Q_0_Nminus1_6[64] = {0,  1,  2,  4,  8,  16, 32, 3,  5,  9,  6,  17, 10, 18, 12, 33, 20, 34, 24, 36, 7,  11,
                                           40, 19, 13, 48, 14, 21, 35, 26, 37, 25, 22, 38, 41, 28, 42, 49, 44, 50, 15, 52, 23, 56,
                                           27, 39, 29, 43, 30, 45, 51, 46, 53, 54, 57, 58, 60, 31, 47, 55, 59, 61, 62, 63};
static const uint16_t Q_0_Nminus1_7[128] = {
    0,  1,  2,   4,  8,   16, 32,  3,  5,   64,  9,   6,   17,  10,  18,  12, 33,  65,  20,  34,  24,  36,  7,   66,  11, 40,
    68, 19, 13,  48, 14,  72, 21,  35, 26,  80,  37,  25,  22,  38,  96,  67, 41,  28,  69,  42,  49,  74,  70,  44,  81, 50,
    73, 15, 52,  23, 76,  82, 56,  27, 97,  39,  84,  29,  43,  98,  88,  30, 71,  45,  100, 51,  46,  75,  104, 53,  77, 54,
    83, 57, 112, 78, 85,  58, 99,  86, 60,  89,  101, 31,  90,  102, 105, 92, 47,  106, 55,  113, 79,  108, 59,  114, 87, 116,
    61, 91, 120, 62, 103, 93, 107, 94, 109, 115, 110, 117, 118, 121, 122, 63, 124, 95,  111, 119, 123, 125, 126, 127};
static const uint16_t Q_0_Nminus1_8[256] = {
    0,   1,   2,   4,   8,   16,  32,  3,   5,   64,  9,   6,   17,  10,  18,  128, 12,  33,  65,  20,  34,  24,  36,  7,
    129, 66,  11,  40,  68,  130, 19,  13,  48,  14,  72,  21,  132, 35,  26,  80,  37,  25,  22,  136, 38,  96,  67,  41,
    144, 28,  69,  42,  49,  74,  160, 192, 70,  44,  131, 81,  50,  73,  15,  133, 52,  23,  134, 76,  137, 82,  56,  27,
    97,  39,  84,  138, 145, 29,  43,  98,  88,  140, 30,  146, 71,  161, 45,  100, 51,  148, 46,  75,  104, 162, 53,  193,
    152, 77,  164, 54,  83,  57,  112, 135, 78,  194, 85,  58,  168, 139, 99,  86,  60,  89,  196, 141, 101, 147, 176, 142,
    31,  200, 90,  149, 102, 105, 163, 92,  47,  208, 150, 153, 165, 106, 55,  113, 154, 79,  108, 224, 166, 195, 59,  169,
    114, 156, 87,  197, 116, 170, 61,  177, 91,  198, 172, 120, 201, 62,  143, 103, 178, 93,  202, 107, 180, 151, 209, 94,
    204, 155, 210, 109, 184, 115, 167, 225, 157, 110, 117, 212, 171, 226, 216, 158, 118, 173, 121, 199, 179, 228, 174, 122,
    203, 63,  181, 232, 124, 205, 182, 211, 185, 240, 206, 95,  213, 186, 227, 111, 214, 188, 217, 229, 159, 119, 218, 230,
    233, 175, 123, 220, 183, 234, 125, 241, 207, 187, 236, 126, 242, 244, 189, 215, 219, 231, 248, 190, 221, 235, 222, 237,
    243, 238, 245, 127, 191, 246, 249, 250, 252, 223, 239, 251, 247, 253, 254, 255};
static const uint16_t Q_0_Nminus1_9[512] = {
    0,   1,   2,   4,   8,   16,  32,  3,   5,   64,  9,   6,   17,  10,  18,  128, 12,  33,  65,  20,  256, 34,  24,  36,  7,
    129, 66,  11,  40,  68,  130, 19,  13,  48,  14,  72,  257, 21,  132, 35,  258, 26,  80,  37,  25,  22,  136, 260, 264, 38,
    96,  67,  41,  144, 28,  69,  42,  49,  74,  272, 160, 288, 192, 70,  44,  131, 81,  50,  73,  15,  320, 133, 52,  23,  134,
    384, 76,  137, 82,  56,  27,  97,  39,  259, 84,  138, 145, 261, 29,  43,  98,  88,  140, 30,  146, 71,  262, 265, 161, 45,
    100, 51,  148, 46,  75,  266, 273, 104, 162, 53,  193, 152, 77,  164, 268, 274, 54,  83,  57,  112, 135, 78,  289, 194, 85,
    276, 58,  168, 139, 99,  86,  60,  280, 89,  290, 196, 141, 101, 147, 176, 142, 321, 31,  200, 90,  292, 322, 263, 149, 102,
    105, 304, 296, 163, 92,  47,  267, 385, 324, 208, 386, 150, 153, 165, 106, 55,  328, 113, 154, 79,  269, 108, 224, 166, 195,
    270, 275, 291, 59,  169, 114, 277, 156, 87,  197, 116, 170, 61,  281, 278, 177, 293, 388, 91,  198, 172, 120, 201, 336, 62,
    282, 143, 103, 178, 294, 93,  202, 323, 392, 297, 107, 180, 151, 209, 284, 94,  204, 298, 400, 352, 325, 155, 210, 305, 300,
    109, 184, 115, 167, 225, 326, 306, 157, 329, 110, 117, 212, 171, 330, 226, 387, 308, 216, 416, 271, 279, 158, 337, 118, 332,
    389, 173, 121, 199, 179, 228, 338, 312, 390, 174, 393, 283, 122, 448, 353, 203, 63,  340, 394, 181, 295, 285, 232, 124, 205,
    182, 286, 299, 354, 211, 401, 185, 396, 344, 240, 206, 95,  327, 402, 356, 307, 301, 417, 213, 186, 404, 227, 418, 302, 360,
    111, 331, 214, 309, 188, 449, 217, 408, 229, 159, 420, 310, 333, 119, 339, 218, 368, 230, 391, 313, 450, 334, 233, 175, 123,
    341, 220, 314, 424, 395, 355, 287, 183, 234, 125, 342, 316, 241, 345, 452, 397, 403, 207, 432, 357, 187, 236, 126, 242, 398,
    346, 456, 358, 405, 303, 244, 189, 361, 215, 348, 419, 406, 464, 362, 409, 219, 311, 421, 410, 231, 248, 369, 190, 364, 335,
    480, 315, 221, 370, 422, 425, 451, 235, 412, 343, 372, 317, 222, 426, 453, 237, 433, 347, 243, 454, 318, 376, 428, 238, 359,
    457, 399, 434, 349, 245, 458, 363, 127, 191, 407, 436, 465, 246, 350, 460, 249, 411, 365, 440, 374, 423, 466, 250, 371, 481,
    413, 366, 468, 429, 252, 373, 482, 427, 414, 223, 472, 455, 377, 435, 319, 484, 430, 488, 239, 378, 459, 437, 380, 461, 496,
    351, 467, 438, 251, 462, 442, 441, 469, 247, 367, 253, 375, 444, 470, 483, 415, 485, 473, 474, 254, 379, 431, 489, 486, 476,
    439, 490, 463, 381, 497, 492, 443, 382, 498, 445, 471, 500, 446, 475, 487, 504, 255, 477, 491, 478, 383, 493, 499, 502, 494,
    501, 447, 505, 506, 479, 508, 495, 503, 507, 509, 510, 511};
static const uint16_t Q_0_Nminus1_10[1024] = {
    0,    1,    2,    4,    8,    16,   32,   3,    5,    64,   9,    6,    17,   10,  18,  128,  12,   33,   65,   20,   256,  34,
    24,   36,   7,    129,  66,   512,  11,   40,   68,   130,  19,   13,   48,   14,  72,  257,  21,   132,  35,   258,  26,   513,
    80,   37,   25,   22,   136,  260,  264,  38,   514,  96,   67,   41,   144,  28,  69,  42,   516,  49,   74,   272,  160,  520,
    288,  528,  192,  544,  70,   44,   131,  81,   50,   73,   15,   320,  133,  52,  23,  134,  384,  76,   137,  82,   56,   27,
    97,   39,   259,  84,   138,  145,  261,  29,   43,   98,   515,  88,   140,  30,  146, 71,   262,  265,  161,  576,  45,   100,
    640,  51,   148,  46,   75,   266,  273,  517,  104,  162,  53,   193,  152,  77,  164, 768,  268,  274,  518,  54,   83,   57,
    521,  112,  135,  78,   289,  194,  85,   276,  522,  58,   168,  139,  99,   86,  60,  280,  89,   290,  529,  524,  196,  141,
    101,  147,  176,  142,  530,  321,  31,   200,  90,   545,  292,  322,  532,  263, 149, 102,  105,  304,  296,  163,  92,   47,
    267,  385,  546,  324,  208,  386,  150,  153,  165,  106,  55,   328,  536,  577, 548, 113,  154,  79,   269,  108,  578,  224,
    166,  519,  552,  195,  270,  641,  523,  275,  580,  291,  59,   169,  560,  114, 277, 156,  87,   197,  116,  170,  61,   531,
    525,  642,  281,  278,  526,  177,  293,  388,  91,   584,  769,  198,  172,  120, 201, 336,  62,   282,  143,  103,  178,  294,
    93,   644,  202,  592,  323,  392,  297,  770,  107,  180,  151,  209,  284,  648, 94,  204,  298,  400,  608,  352,  325,  533,
    155,  210,  305,  547,  300,  109,  184,  534,  537,  115,  167,  225,  326,  306, 772, 157,  656,  329,  110,  117,  212,  171,
    776,  330,  226,  549,  538,  387,  308,  216,  416,  271,  279,  158,  337,  550, 672, 118,  332,  579,  540,  389,  173,  121,
    553,  199,  784,  179,  228,  338,  312,  704,  390,  174,  554,  581,  393,  283, 122, 448,  353,  561,  203,  63,   340,  394,
    527,  582,  556,  181,  295,  285,  232,  124,  205,  182,  643,  562,  286,  585, 299, 354,  211,  401,  185,  396,  344,  586,
    645,  593,  535,  240,  206,  95,   327,  564,  800,  402,  356,  307,  301,  417, 213, 568,  832,  588,  186,  646,  404,  227,
    896,  594,  418,  302,  649,  771,  360,  539,  111,  331,  214,  309,  188,  449, 217, 408,  609,  596,  551,  650,  229,  159,
    420,  310,  541,  773,  610,  657,  333,  119,  600,  339,  218,  368,  652,  230, 391, 313,  450,  542,  334,  233,  555,  774,
    175,  123,  658,  612,  341,  777,  220,  314,  424,  395,  673,  583,  355,  287, 183, 234,  125,  557,  660,  616,  342,  316,
    241,  778,  563,  345,  452,  397,  403,  207,  674,  558,  785,  432,  357,  187, 236, 664,  624,  587,  780,  705,  126,  242,
    565,  398,  346,  456,  358,  405,  303,  569,  244,  595,  189,  566,  676,  361, 706, 589,  215,  786,  647,  348,  419,  406,
    464,  680,  801,  362,  590,  409,  570,  788,  597,  572,  219,  311,  708,  598, 601, 651,  421,  792,  802,  611,  602,  410,
    231,  688,  653,  248,  369,  190,  364,  654,  659,  335,  480,  315,  221,  370, 613, 422,  425,  451,  614,  543,  235,  412,
    343,  372,  775,  317,  222,  426,  453,  237,  559,  833,  804,  712,  834,  661, 808, 779,  617,  604,  433,  720,  816,  836,
    347,  897,  243,  662,  454,  318,  675,  618,  898,  781,  376,  428,  665,  736, 567, 840,  625,  238,  359,  457,  399,  787,
    591,  678,  434,  677,  349,  245,  458,  666,  620,  363,  127,  191,  782,  407, 436, 626,  571,  465,  681,  246,  707,  350,
    599,  668,  790,  460,  249,  682,  573,  411,  803,  789,  709,  365,  440,  628, 689, 374,  423,  466,  793,  250,  371,  481,
    574,  413,  603,  366,  468,  655,  900,  805,  615,  684,  710,  429,  794,  252, 373, 605,  848,  690,  713,  632,  482,  806,
    427,  904,  414,  223,  663,  692,  835,  619,  472,  455,  796,  809,  714,  721, 837, 716,  864,  810,  606,  912,  722,  696,
    377,  435,  817,  319,  621,  812,  484,  430,  838,  667,  488,  239,  378,  459, 622, 627,  437,  380,  818,  461,  496,  669,
    679,  724,  841,  629,  351,  467,  438,  737,  251,  462,  442,  441,  469,  247, 683, 842,  738,  899,  670,  783,  849,  820,
    728,  928,  791,  367,  901,  630,  685,  844,  633,  711,  253,  691,  824,  902, 686, 740,  850,  375,  444,  470,  483,  415,
    485,  905,  795,  473,  634,  744,  852,  960,  865,  693,  797,  906,  715,  807, 474, 636,  694,  254,  717,  575,  913,  798,
    811,  379,  697,  431,  607,  489,  866,  723,  486,  908,  718,  813,  476,  856, 839, 725,  698,  914,  752,  868,  819,  814,
    439,  929,  490,  623,  671,  739,  916,  463,  843,  381,  497,  930,  821,  726, 961, 872,  492,  631,  729,  700,  443,  741,
    845,  920,  382,  822,  851,  730,  498,  880,  742,  445,  471,  635,  932,  687, 903, 825,  500,  846,  745,  826,  732,  446,
    962,  936,  475,  853,  867,  637,  907,  487,  695,  746,  828,  753,  854,  857, 504, 799,  255,  964,  909,  719,  477,  915,
    638,  748,  944,  869,  491,  699,  754,  858,  478,  968,  383,  910,  815,  976, 870, 917,  727,  493,  873,  701,  931,  756,
    860,  499,  731,  823,  922,  874,  918,  502,  933,  743,  760,  881,  494,  702, 921, 501,  876,  847,  992,  447,  733,  827,
    934,  882,  937,  963,  747,  505,  855,  924,  734,  829,  965,  938,  884,  506, 749, 945,  966,  755,  859,  940,  830,  911,
    871,  639,  888,  479,  946,  750,  969,  508,  861,  757,  970,  919,  875,  862, 758, 948,  977,  923,  972,  761,  877,  952,
    495,  703,  935,  978,  883,  762,  503,  925,  878,  735,  993,  885,  939,  994, 980, 926,  764,  941,  967,  886,  831,  947,
    507,  889,  984,  751,  942,  996,  971,  890,  509,  949,  973,  1000, 892,  950, 863, 759,  1008, 510,  979,  953,  763,  974,
    954,  879,  981,  982,  927,  995,  765,  956,  887,  985,  997,  986,  943,  891, 998, 766,  511,  988,  1001, 951,  1002, 893,
    975,  894,  1009, 955,  1004, 1010, 957,  983,  958,  987,  1012, 999,  1016, 767, 989, 1003, 990,  1005, 959,  1011, 1013, 895,
    1006, 1014, 1017, 1018, 991,  1020, 1007, 1015, 1019, 1021, 1022, 1023};

static const uint16_t* const Q_0_Nminus1[11] = {NULL,
                                                Q_0_Nminus1_1,
                                                Q_0_Nminus1_2,
                                                Q_0_Nminus1_3,
                                                Q_0_Nminus1_4,
                                                Q_0_Nminus1_5,
                                                Q_0_Nminus1_6,
                                                Q_0_Nminus1_7,
                                                Q_0_Nminus1_8,
                                                Q_0_Nminus1_9,
                                                Q_0_Nminus1_10};

const uint16_t* nr_polar_sequence_pattern(uint8_t n)
{
  return Q_0_Nminus1[n];
}
