/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/*! \file PHY/LTE_ESTIMATION/lte_sync_timefreq.c
* \brief Initial time frequency scan of entire LTE band
* \author R. Knopp
* \date 2014
* \version 0.1
* \company Eurecom
* \email: raymond.knopp@eurecom.fr
* \note
* \warning
*/
/* file: lte_sync_timefreq.c
   purpose: scan for likely cells over entire LTE band using PSS. Provides coarse frequency offset in addtition to 10 top likelihoods per PSS sequence
   author: raymond.knopp@eurecom.fr
   date: 23.01.2015
*/

static int16_t pss6144_0_0[512]__attribute__((aligned(16)))={339,1651,1632,539,-1,0,368,1752,1739,566,0,-1,403,1869,1864,595,-1,0,445,2005,2011,628,-1,-1,496,2167,2188,667,-1,0,561,2365,2407,712,-1,-1,642,2611,2683,769,-1,-1,748,2932,3048,847,0,-1,886,3376,3560,968,0,0,1062,4055,4354,1214,0,0,1223,5327,5884,1998,-1,0,414,9641,12973,10419,18918,-1,17465,-11210,4889,-21892,-15081,-11423,-6402,12224,16895,3030,6911,-17611,-7479,-9060,-1383,-6414,-13868,-12868,-24841,11733,3342,27523,18542,3748,1128,-4019,2553,10668,18077,5576,17671,-9600,7553,-18513,-9460,-16384,-13453,5018,9759,10824,14492,-12161,-4146,-14469,-1227,-5616,-4210,-18444,-29035,-7781,-17522,24181,11795,14790,1688,-4647,-8473,9811,8630,16834,17376,4290,16247,-6052,6911,-17611,-13487,-10002,-5902,14277,18077,5576,9039,-13140,1887,-3843,14492,-12161,-6394,-31667,-31431,-6687,-9460,16383,4073,-1997,-14069,-5414,-13868,12867,-710,15914,7254,14213,18542,3748,7489,-16693,-16715,-4892,-4210,18443,13167,6609,2112,1167,11795,14790,31826,-6357,7924,-31501,-15081,-11423,1351,2587,6532,-13717,-9460,-16384,-15007,-6419,-16995,1819,-9460,16383,13406,11258,9754,-14771,-15081,-11423,-11160,7387,-2981,10,-18707,2819,-10634,28961,20997,22672,18077,-5577,-1856,-1824,5866,12175,18542,3748,16247,-7714,10468,-15035,-4210,-18444,-15904,-797,1694,15599,18918,-1,6882,-13419,2815,-4015,14492,-12161,-2325,-31234,-28242,-13338,-13868,12867,6444,322,-8005,-13558,-18707,2819,-4182,12166,2711,2972,0,-1,1346,-3845,-8390,-9820,-18707,2819,-7612,13701,-3446,5304,-13868,12867,2697,31116,28266,13488,14492,-12161,-4757,-441,8235,12554,18918,-1,12790,-9278,8697,-13490,-4210,-18444,-18127,-1558,-1389,17811,18542,3748,7738,-11179,2562,-811,18077,-5577,9263,-29531,-19710,-23806,-18707,2819,1626,2566,-763,-13474,-15081,-11423,-17541,-1073,-16398,5865,-9460,16383,10200,13798,13117,-9903,-9460,-16384,-15018,1190,-2861,-240,-15081,-11423,-31115,8877,-10353,30625,11795,14790,82,-2423,-12253,7983,-4210,18443,4249,16911,10766,14717,18542,3748,8809,-13399,-13373,-8688,-13868,12867,2473,14880,-253,4410,-9460,16383,10051,30553,30676,10181,14492,-12161,-4145,276,6914,14282,18077,5576,15443,-2038,15460,-6795,6911,-17611,-13238,-11055,-12349,12788,8630,16834,12860,2422,3235,3670,11795,14790,29829,3073,21311,-21370,-4210,-18444,-4123,3860,14658,3529,14492,-12161,4622,-13874,2435,-14276,-9460,-16384,-19682,2704,-467,19988,18077,5576,8089,-7555,2972,2871,18542,3748,22292,-16666,2313,-27495,-13868,-12868,-4736,4394,11640,-2062,6911,-17611,-5696,-16157,-7331,-11772,-15081,-11423,-21276,6701,1030,20614,18918,0,2664,-16456,-8502,-4578,-1,-1,-1084,-6106,-5171,-1720,0,-1,-998,-4389,-3988,-1224,0,0,-814,-3578,-3313,-1036,0,0,-664,-3074,-2859,-934,0,0,-548,-2719,-2528,-865,-1,0,-459,-2451,-2274,-813,-1,0,-389,-2239,-2071,-770,-1,-1,-334,-2067,-1905,-733,0,-1,-289,-1922,-1765,-701,0,0,-252,-1800,-1647,-673,-1,-1,-222,-1694};
static int16_t pss6144_0_1[512]__attribute__((aligned(16)))={0,0,339,1651,1632,539,-1,0,368,1752,1739,566,0,-1,403,1869,1864,595,-1,0,445,2005,2011,628,-1,-1,496,2167,2188,667,-1,0,561,2365,2407,712,-1,-1,642,2611,2683,769,-1,-1,748,2932,3048,847,0,-1,886,3376,3560,968,0,0,1062,4055,4354,1214,0,0,1223,5327,5884,1998,-1,0,414,9641,12973,10419,18918,-1,17465,-11210,4889,-21892,-15081,-11423,-6402,12224,16895,3030,6911,-17611,-7479,-9060,-1383,-6414,-13868,-12868,-24841,11733,3342,27523,18542,3748,1128,-4019,2553,10668,18077,5576,17671,-9600,7553,-18513,-9460,-16384,-13453,5018,9759,10824,14492,-12161,-4146,-14469,-1227,-5616,-4210,-18444,-29035,-7781,-17522,24181,11795,14790,1688,-4647,-8473,9811,8630,16834,17376,4290,16247,-6052,6911,-17611,-13487,-10002,-5902,14277,18077,5576,9039,-13140,1887,-3843,14492,-12161,-6394,-31667,-31431,-6687,-9460,16383,4073,-1997,-14069,-5414,-13868,12867,-710,15914,7254,14213,18542,3748,7489,-16693,-16715,-4892,-4210,18443,13167,6609,2112,1167,11795,14790,31826,-6357,7924,-31501,-15081,-11423,1351,2587,6532,-13717,-9460,-16384,-15007,-6419,-16995,1819,-9460,16383,13406,11258,9754,-14771,-15081,-11423,-11160,7387,-2981,10,-18707,2819,-10634,28961,20997,22672,18077,-5577,-1856,-1824,5866,12175,18542,3748,16247,-7714,10468,-15035,-4210,-18444,-15904,-797,1694,15599,18918,-1,6882,-13419,2815,-4015,14492,-12161,-2325,-31234,-28242,-13338,-13868,12867,6444,322,-8005,-13558,-18707,2819,-4182,12166,2711,2972,0,-1,1346,-3845,-8390,-9820,-18707,2819,-7612,13701,-3446,5304,-13868,12867,2697,31116,28266,13488,14492,-12161,-4757,-441,8235,12554,18918,-1,12790,-9278,8697,-13490,-4210,-18444,-18127,-1558,-1389,17811,18542,3748,7738,-11179,2562,-811,18077,-5577,9263,-29531,-19710,-23806,-18707,2819,1626,2566,-763,-13474,-15081,-11423,-17541,-1073,-16398,5865,-9460,16383,10200,13798,13117,-9903,-9460,-16384,-15018,1190,-2861,-240,-15081,-11423,-31115,8877,-10353,30625,11795,14790,82,-2423,-12253,7983,-4210,18443,4249,16911,10766,14717,18542,3748,8809,-13399,-13373,-8688,-13868,12867,2473,14880,-253,4410,-9460,16383,10051,30553,30676,10181,14492,-12161,-4145,276,6914,14282,18077,5576,15443,-2038,15460,-6795,6911,-17611,-13238,-11055,-12349,12788,8630,16834,12860,2422,3235,3670,11795,14790,29829,3073,21311,-21370,-4210,-18444,-4123,3860,14658,3529,14492,-12161,4622,-13874,2435,-14276,-9460,-16384,-19682,2704,-467,19988,18077,5576,8089,-7555,2972,2871,18542,3748,22292,-16666,2313,-27495,-13868,-12868,-4736,4394,11640,-2062,6911,-17611,-5696,-16157,-7331,-11772,-15081,-11423,-21276,6701,1030,20614,18918,0,2664,-16456,-8502,-4578,-1,-1,-1084,-6106,-5171,-1720,0,-1,-998,-4389,-3988,-1224,0,0,-814,-3578,-3313,-1036,0,0,-664,-3074,-2859,-934,0,0,-548,-2719,-2528,-865,-1,0,-459,-2451,-2274,-813,-1,0,-389,-2239,-2071,-770,-1,-1,-334,-2067,-1905,-733,0,-1,-289,-1922,-1765,-701,0,0,-252,-1800,-1647,-673,-1,-1};
static int16_t pss6144_0_2[512]__attribute__((aligned(16)))={0,0,0,0,339,1651,1632,539,-1,0,368,1752,1739,566,0,-1,403,1869,1864,595,-1,0,445,2005,2011,628,-1,-1,496,2167,2188,667,-1,0,561,2365,2407,712,-1,-1,642,2611,2683,769,-1,-1,748,2932,3048,847,0,-1,886,3376,3560,968,0,0,1062,4055,4354,1214,0,0,1223,5327,5884,1998,-1,0,414,9641,12973,10419,18918,-1,17465,-11210,4889,-21892,-15081,-11423,-6402,12224,16895,3030,6911,-17611,-7479,-9060,-1383,-6414,-13868,-12868,-24841,11733,3342,27523,18542,3748,1128,-4019,2553,10668,18077,5576,17671,-9600,7553,-18513,-9460,-16384,-13453,5018,9759,10824,14492,-12161,-4146,-14469,-1227,-5616,-4210,-18444,-29035,-7781,-17522,24181,11795,14790,1688,-4647,-8473,9811,8630,16834,17376,4290,16247,-6052,6911,-17611,-13487,-10002,-5902,14277,18077,5576,9039,-13140,1887,-3843,14492,-12161,-6394,-31667,-31431,-6687,-9460,16383,4073,-1997,-14069,-5414,-13868,12867,-710,15914,7254,14213,18542,3748,7489,-16693,-16715,-4892,-4210,18443,13167,6609,2112,1167,11795,14790,31826,-6357,7924,-31501,-15081,-11423,1351,2587,6532,-13717,-9460,-16384,-15007,-6419,-16995,1819,-9460,16383,13406,11258,9754,-14771,-15081,-11423,-11160,7387,-2981,10,-18707,2819,-10634,28961,20997,22672,18077,-5577,-1856,-1824,5866,12175,18542,3748,16247,-7714,10468,-15035,-4210,-18444,-15904,-797,1694,15599,18918,-1,6882,-13419,2815,-4015,14492,-12161,-2325,-31234,-28242,-13338,-13868,12867,6444,322,-8005,-13558,-18707,2819,-4182,12166,2711,2972,0,-1,1346,-3845,-8390,-9820,-18707,2819,-7612,13701,-3446,5304,-13868,12867,2697,31116,28266,13488,14492,-12161,-4757,-441,8235,12554,18918,-1,12790,-9278,8697,-13490,-4210,-18444,-18127,-1558,-1389,17811,18542,3748,7738,-11179,2562,-811,18077,-5577,9263,-29531,-19710,-23806,-18707,2819,1626,2566,-763,-13474,-15081,-11423,-17541,-1073,-16398,5865,-9460,16383,10200,13798,13117,-9903,-9460,-16384,-15018,1190,-2861,-240,-15081,-11423,-31115,8877,-10353,30625,11795,14790,82,-2423,-12253,7983,-4210,18443,4249,16911,10766,14717,18542,3748,8809,-13399,-13373,-8688,-13868,12867,2473,14880,-253,4410,-9460,16383,10051,30553,30676,10181,14492,-12161,-4145,276,6914,14282,18077,5576,15443,-2038,15460,-6795,6911,-17611,-13238,-11055,-12349,12788,8630,16834,12860,2422,3235,3670,11795,14790,29829,3073,21311,-21370,-4210,-18444,-4123,3860,14658,3529,14492,-12161,4622,-13874,2435,-14276,-9460,-16384,-19682,2704,-467,19988,18077,5576,8089,-7555,2972,2871,18542,3748,22292,-16666,2313,-27495,-13868,-12868,-4736,4394,11640,-2062,6911,-17611,-5696,-16157,-7331,-11772,-15081,-11423,-21276,6701,1030,20614,18918,0,2664,-16456,-8502,-4578,-1,-1,-1084,-6106,-5171,-1720,0,-1,-998,-4389,-3988,-1224,0,0,-814,-3578,-3313,-1036,0,0,-664,-3074,-2859,-934,0,0,-548,-2719,-2528,-865,-1,0,-459,-2451,-2274,-813,-1,0,-389,-2239,-2071,-770,-1,-1,-334,-2067,-1905,-733,0,-1,-289,-1922,-1765,-701,0,0,-252,-1800,-1647,-673};
static int16_t pss6144_0_3[512]__attribute__((aligned(16)))={0,0,0,0,0,0,339,1651,1632,539,-1,0,368,1752,1739,566,0,-1,403,1869,1864,595,-1,0,445,2005,2011,628,-1,-1,496,2167,2188,667,-1,0,561,2365,2407,712,-1,-1,642,2611,2683,769,-1,-1,748,2932,3048,847,0,-1,886,3376,3560,968,0,0,1062,4055,4354,1214,0,0,1223,5327,5884,1998,-1,0,414,9641,12973,10419,18918,-1,17465,-11210,4889,-21892,-15081,-11423,-6402,12224,16895,3030,6911,-17611,-7479,-9060,-1383,-6414,-13868,-12868,-24841,11733,3342,27523,18542,3748,1128,-4019,2553,10668,18077,5576,17671,-9600,7553,-18513,-9460,-16384,-13453,5018,9759,10824,14492,-12161,-4146,-14469,-1227,-5616,-4210,-18444,-29035,-7781,-17522,24181,11795,14790,1688,-4647,-8473,9811,8630,16834,17376,4290,16247,-6052,6911,-17611,-13487,-10002,-5902,14277,18077,5576,9039,-13140,1887,-3843,14492,-12161,-6394,-31667,-31431,-6687,-9460,16383,4073,-1997,-14069,-5414,-13868,12867,-710,15914,7254,14213,18542,3748,7489,-16693,-16715,-4892,-4210,18443,13167,6609,2112,1167,11795,14790,31826,-6357,7924,-31501,-15081,-11423,1351,2587,6532,-13717,-9460,-16384,-15007,-6419,-16995,1819,-9460,16383,13406,11258,9754,-14771,-15081,-11423,-11160,7387,-2981,10,-18707,2819,-10634,28961,20997,22672,18077,-5577,-1856,-1824,5866,12175,18542,3748,16247,-7714,10468,-15035,-4210,-18444,-15904,-797,1694,15599,18918,-1,6882,-13419,2815,-4015,14492,-12161,-2325,-31234,-28242,-13338,-13868,12867,6444,322,-8005,-13558,-18707,2819,-4182,12166,2711,2972,0,-1,1346,-3845,-8390,-9820,-18707,2819,-7612,13701,-3446,5304,-13868,12867,2697,31116,28266,13488,14492,-12161,-4757,-441,8235,12554,18918,-1,12790,-9278,8697,-13490,-4210,-18444,-18127,-1558,-1389,17811,18542,3748,7738,-11179,2562,-811,18077,-5577,9263,-29531,-19710,-23806,-18707,2819,1626,2566,-763,-13474,-15081,-11423,-17541,-1073,-16398,5865,-9460,16383,10200,13798,13117,-9903,-9460,-16384,-15018,1190,-2861,-240,-15081,-11423,-31115,8877,-10353,30625,11795,14790,82,-2423,-12253,7983,-4210,18443,4249,16911,10766,14717,18542,3748,8809,-13399,-13373,-8688,-13868,12867,2473,14880,-253,4410,-9460,16383,10051,30553,30676,10181,14492,-12161,-4145,276,6914,14282,18077,5576,15443,-2038,15460,-6795,6911,-17611,-13238,-11055,-12349,12788,8630,16834,12860,2422,3235,3670,11795,14790,29829,3073,21311,-21370,-4210,-18444,-4123,3860,14658,3529,14492,-12161,4622,-13874,2435,-14276,-9460,-16384,-19682,2704,-467,19988,18077,5576,8089,-7555,2972,2871,18542,3748,22292,-16666,2313,-27495,-13868,-12868,-4736,4394,11640,-2062,6911,-17611,-5696,-16157,-7331,-11772,-15081,-11423,-21276,6701,1030,20614,18918,0,2664,-16456,-8502,-4578,-1,-1,-1084,-6106,-5171,-1720,0,-1,-998,-4389,-3988,-1224,0,0,-814,-3578,-3313,-1036,0,0,-664,-3074,-2859,-934,0,0,-548,-2719,-2528,-865,-1,0,-459,-2451,-2274,-813,-1,0,-389,-2239,-2071,-770,-1,-1,-334,-2067,-1905,-733,0,-1,-289,-1922,-1765,-701,0,0,-252,-1800};
static int16_t pss6144_1_0[512]__attribute__((aligned(16)))={-259,-1425,-1385,-495,0,0,-277,-1491,-1454,-512,-1,0,-298,-1565,-1531,-531,-1,-1,-323,-1647,-1618,-551,0,-1,-353,-1739,-1716,-571,-1,0,-388,-1840,-1825,-591,-1,0,-431,-1952,-1948,-609,-1,-1,-485,-2072,-2082,-618,-1,-1,-558,-2186,-2215,-598,-1,0,-675,-2248,-2299,-480,0,0,-942,-2027,-2066,132,0,0,-2464,594,2767,8277,18918,-1,12859,-24111,-12955,-24526,-18334,-4669,-6477,259,-4061,-8265,-13868,-12868,-26671,-3170,-21843,17772,1413,18865,4406,-1888,-13398,-3474,-15081,11422,-6580,16382,1531,18896,15630,10656,9038,-10860,-14655,-5233,-9460,16383,5535,12515,3196,9284,14492,12160,20281,-11337,-9050,-19817,-17045,8208,4042,11247,-2211,82,-4210,18443,25248,15629,22484,-18723,-7781,-17244,-4143,2536,5231,-8071,-13868,-12868,-21125,10827,-77,23699,15630,10656,9368,-2307,1221,4333,14492,12160,28427,-6570,11297,-27183,-9460,-16384,-2804,-1629,7011,-8340,1413,-18866,-12065,-20374,-23958,-7423,-15081,11422,4907,5607,-611,-12829,-17045,-8209,-16850,3715,-14109,9607,-4210,18443,13806,7453,2977,-14703,-18334,-4669,-10495,10811,-6204,6014,-9460,16383,14211,20816,20744,-10042,-9460,-16384,-11142,6723,1714,-1000,-18334,-4669,-17350,26395,18198,25430,18077,-5577,-2347,-2516,8320,8126,15630,-10657,-5810,-21341,-21524,-5274,-15081,11422,-2096,11292,-3570,1240,-17045,8208,-7939,29972,19264,24741,18918,-1,1172,-118,3257,12753,14492,12160,21185,4093,20647,-10914,1413,-18866,-11017,678,7999,12884,18077,-5577,1972,-13504,-3576,-2625,-1,0,-614,4412,10646,8572,18077,-5577,7030,-13367,4859,-9768,1413,-18866,-19903,-12421,-14200,16412,14492,12160,9288,-9196,-546,1186,18918,0,11666,-29052,-22049,-21749,-17045,8208,2731,2473,-8794,-7349,-15081,11422,6066,21279,21324,5750,15630,-10657,2749,-11266,3290,-662,18077,-5577,12796,-28473,-14246,-28111,-18334,-4669,-1851,-982,-314,-12899,-9460,-16384,-19197,-12942,-25195,2011,-9460,16383,8182,2368,-4177,-14382,-18334,-4669,-14350,4776,-13419,8342,-4210,18443,15246,7417,5146,-16338,-17045,-8209,-10933,6945,-7372,1558,-15081,11422,5423,24462,23615,-150,1413,-18866,-10856,-1900,2751,-1502,-9460,-16384,-29318,3810,-8586,28015,14492,12160,3013,-3222,-2749,9378,15630,10656,20434,-11781,1123,-23596,-13868,-12868,-9734,-492,-187,-4744,-7781,-17244,-27585,-10108,-26221,14163,-4210,18443,1049,1875,-11824,-2011,-17045,8208,-12765,17748,-385,23345,14492,12160,6314,-7408,-13668,-1352,-9460,16383,2668,15310,4824,13369,15630,10656,15471,-10772,-10960,-13777,-15081,11422,3562,13342,-630,4872,1413,18865,26184,10033,16019,-21401,-13868,-12868,-5255,7651,2952,-5626,-18334,-4669,-14890,23484,14389,23303,18918,0,5657,-6533,655,-2319,0,-1,1019,1725,2164,309,0,0,606,2233,2222,652,0,0,461,2220,2110,722,-1,0,378,2114,1974,728,0,-1,318,1994,1844,715,0,-1,272,1879,1725,696,-1,0,235,1774,1620,676,0,0,204,1679,1526,656,0,0,177,1594,1442,636,0,-1,155,1517,1368,618,0,-1,136,1449};
static int16_t pss6144_1_1[512]__attribute__((aligned(16)))={0,0-259,-1425,-1385,-495,0,0,-277,-1491,-1454,-512,-1,0,-298,-1565,-1531,-531,-1,-1,-323,-1647,-1618,-551,0,-1,-353,-1739,-1716,-571,-1,0,-388,-1840,-1825,-591,-1,0,-431,-1952,-1948,-609,-1,-1,-485,-2072,-2082,-618,-1,-1,-558,-2186,-2215,-598,-1,0,-675,-2248,-2299,-480,0,0,-942,-2027,-2066,132,0,0,-2464,594,2767,8277,18918,-1,12859,-24111,-12955,-24526,-18334,-4669,-6477,259,-4061,-8265,-13868,-12868,-26671,-3170,-21843,17772,1413,18865,4406,-1888,-13398,-3474,-15081,11422,-6580,16382,1531,18896,15630,10656,9038,-10860,-14655,-5233,-9460,16383,5535,12515,3196,9284,14492,12160,20281,-11337,-9050,-19817,-17045,8208,4042,11247,-2211,82,-4210,18443,25248,15629,22484,-18723,-7781,-17244,-4143,2536,5231,-8071,-13868,-12868,-21125,10827,-77,23699,15630,10656,9368,-2307,1221,4333,14492,12160,28427,-6570,11297,-27183,-9460,-16384,-2804,-1629,7011,-8340,1413,-18866,-12065,-20374,-23958,-7423,-15081,11422,4907,5607,-611,-12829,-17045,-8209,-16850,3715,-14109,9607,-4210,18443,13806,7453,2977,-14703,-18334,-4669,-10495,10811,-6204,6014,-9460,16383,14211,20816,20744,-10042,-9460,-16384,-11142,6723,1714,-1000,-18334,-4669,-17350,26395,18198,25430,18077,-5577,-2347,-2516,8320,8126,15630,-10657,-5810,-21341,-21524,-5274,-15081,11422,-2096,11292,-3570,1240,-17045,8208,-7939,29972,19264,24741,18918,-1,1172,-118,3257,12753,14492,12160,21185,4093,20647,-10914,1413,-18866,-11017,678,7999,12884,18077,-5577,1972,-13504,-3576,-2625,-1,0,-614,4412,10646,8572,18077,-5577,7030,-13367,4859,-9768,1413,-18866,-19903,-12421,-14200,16412,14492,12160,9288,-9196,-546,1186,18918,0,11666,-29052,-22049,-21749,-17045,8208,2731,2473,-8794,-7349,-15081,11422,6066,21279,21324,5750,15630,-10657,2749,-11266,3290,-662,18077,-5577,12796,-28473,-14246,-28111,-18334,-4669,-1851,-982,-314,-12899,-9460,-16384,-19197,-12942,-25195,2011,-9460,16383,8182,2368,-4177,-14382,-18334,-4669,-14350,4776,-13419,8342,-4210,18443,15246,7417,5146,-16338,-17045,-8209,-10933,6945,-7372,1558,-15081,11422,5423,24462,23615,-150,1413,-18866,-10856,-1900,2751,-1502,-9460,-16384,-29318,3810,-8586,28015,14492,12160,3013,-3222,-2749,9378,15630,10656,20434,-11781,1123,-23596,-13868,-12868,-9734,-492,-187,-4744,-7781,-17244,-27585,-10108,-26221,14163,-4210,18443,1049,1875,-11824,-2011,-17045,8208,-12765,17748,-385,23345,14492,12160,6314,-7408,-13668,-1352,-9460,16383,2668,15310,4824,13369,15630,10656,15471,-10772,-10960,-13777,-15081,11422,3562,13342,-630,4872,1413,18865,26184,10033,16019,-21401,-13868,-12868,-5255,7651,2952,-5626,-18334,-4669,-14890,23484,14389,23303,18918,0,5657,-6533,655,-2319,0,-1,1019,1725,2164,309,0,0,606,2233,2222,652,0,0,461,2220,2110,722,-1,0,378,2114,1974,728,0,-1,318,1994,1844,715,0,-1,272,1879,1725,696,-1,0,235,1774,1620,676,0,0,204,1679,1526,656,0,0,177,1594,1442,636,0,-1,155,1517,1368,618,0,-1};
static int16_t pss6144_1_2[512]__attribute__((aligned(16)))={0,0,0,0,-259,-1425,-1385,-495,0,0,-277,-1491,-1454,-512,-1,0,-298,-1565,-1531,-531,-1,-1,-323,-1647,-1618,-551,0,-1,-353,-1739,-1716,-571,-1,0,-388,-1840,-1825,-591,-1,0,-431,-1952,-1948,-609,-1,-1,-485,-2072,-2082,-618,-1,-1,-558,-2186,-2215,-598,-1,0,-675,-2248,-2299,-480,0,0,-942,-2027,-2066,132,0,0,-2464,594,2767,8277,18918,-1,12859,-24111,-12955,-24526,-18334,-4669,-6477,259,-4061,-8265,-13868,-12868,-26671,-3170,-21843,17772,1413,18865,4406,-1888,-13398,-3474,-15081,11422,-6580,16382,1531,18896,15630,10656,9038,-10860,-14655,-5233,-9460,16383,5535,12515,3196,9284,14492,12160,20281,-11337,-9050,-19817,-17045,8208,4042,11247,-2211,82,-4210,18443,25248,15629,22484,-18723,-7781,-17244,-4143,2536,5231,-8071,-13868,-12868,-21125,10827,-77,23699,15630,10656,9368,-2307,1221,4333,14492,12160,28427,-6570,11297,-27183,-9460,-16384,-2804,-1629,7011,-8340,1413,-18866,-12065,-20374,-23958,-7423,-15081,11422,4907,5607,-611,-12829,-17045,-8209,-16850,3715,-14109,9607,-4210,18443,13806,7453,2977,-14703,-18334,-4669,-10495,10811,-6204,6014,-9460,16383,14211,20816,20744,-10042,-9460,-16384,-11142,6723,1714,-1000,-18334,-4669,-17350,26395,18198,25430,18077,-5577,-2347,-2516,8320,8126,15630,-10657,-5810,-21341,-21524,-5274,-15081,11422,-2096,11292,-3570,1240,-17045,8208,-7939,29972,19264,24741,18918,-1,1172,-118,3257,12753,14492,12160,21185,4093,20647,-10914,1413,-18866,-11017,678,7999,12884,18077,-5577,1972,-13504,-3576,-2625,-1,0,-614,4412,10646,8572,18077,-5577,7030,-13367,4859,-9768,1413,-18866,-19903,-12421,-14200,16412,14492,12160,9288,-9196,-546,1186,18918,0,11666,-29052,-22049,-21749,-17045,8208,2731,2473,-8794,-7349,-15081,11422,6066,21279,21324,5750,15630,-10657,2749,-11266,3290,-662,18077,-5577,12796,-28473,-14246,-28111,-18334,-4669,-1851,-982,-314,-12899,-9460,-16384,-19197,-12942,-25195,2011,-9460,16383,8182,2368,-4177,-14382,-18334,-4669,-14350,4776,-13419,8342,-4210,18443,15246,7417,5146,-16338,-17045,-8209,-10933,6945,-7372,1558,-15081,11422,5423,24462,23615,-150,1413,-18866,-10856,-1900,2751,-1502,-9460,-16384,-29318,3810,-8586,28015,14492,12160,3013,-3222,-2749,9378,15630,10656,20434,-11781,1123,-23596,-13868,-12868,-9734,-492,-187,-4744,-7781,-17244,-27585,-10108,-26221,14163,-4210,18443,1049,1875,-11824,-2011,-17045,8208,-12765,17748,-385,23345,14492,12160,6314,-7408,-13668,-1352,-9460,16383,2668,15310,4824,13369,15630,10656,15471,-10772,-10960,-13777,-15081,11422,3562,13342,-630,4872,1413,18865,26184,10033,16019,-21401,-13868,-12868,-5255,7651,2952,-5626,-18334,-4669,-14890,23484,14389,23303,18918,0,5657,-6533,655,-2319,0,-1,1019,1725,2164,309,0,0,606,2233,2222,652,0,0,461,2220,2110,722,-1,0,378,2114,1974,728,0,-1,318,1994,1844,715,0,-1,272,1879,1725,696,-1,0,235,1774,1620,676,0,0,204,1679,1526,656,0,0,177,1594,1442,636,0,-1,155,1517,1368,618};
static int16_t pss6144_1_3[512]__attribute__((aligned(16)))={0,0,0,0,0,0,-259,-1425,-1385,-495,0,0,-277,-1491,-1454,-512,-1,0,-298,-1565,-1531,-531,-1,-1,-323,-1647,-1618,-551,0,-1,-353,-1739,-1716,-571,-1,0,-388,-1840,-1825,-591,-1,0,-431,-1952,-1948,-609,-1,-1,-485,-2072,-2082,-618,-1,-1,-558,-2186,-2215,-598,-1,0,-675,-2248,-2299,-480,0,0,-942,-2027,-2066,132,0,0,-2464,594,2767,8277,18918,-1,12859,-24111,-12955,-24526,-18334,-4669,-6477,259,-4061,-8265,-13868,-12868,-26671,-3170,-21843,17772,1413,18865,4406,-1888,-13398,-3474,-15081,11422,-6580,16382,1531,18896,15630,10656,9038,-10860,-14655,-5233,-9460,16383,5535,12515,3196,9284,14492,12160,20281,-11337,-9050,-19817,-17045,8208,4042,11247,-2211,82,-4210,18443,25248,15629,22484,-18723,-7781,-17244,-4143,2536,5231,-8071,-13868,-12868,-21125,10827,-77,23699,15630,10656,9368,-2307,1221,4333,14492,12160,28427,-6570,11297,-27183,-9460,-16384,-2804,-1629,7011,-8340,1413,-18866,-12065,-20374,-23958,-7423,-15081,11422,4907,5607,-611,-12829,-17045,-8209,-16850,3715,-14109,9607,-4210,18443,13806,7453,2977,-14703,-18334,-4669,-10495,10811,-6204,6014,-9460,16383,14211,20816,20744,-10042,-9460,-16384,-11142,6723,1714,-1000,-18334,-4669,-17350,26395,18198,25430,18077,-5577,-2347,-2516,8320,8126,15630,-10657,-5810,-21341,-21524,-5274,-15081,11422,-2096,11292,-3570,1240,-17045,8208,-7939,29972,19264,24741,18918,-1,1172,-118,3257,12753,14492,12160,21185,4093,20647,-10914,1413,-18866,-11017,678,7999,12884,18077,-5577,1972,-13504,-3576,-2625,-1,0,-614,4412,10646,8572,18077,-5577,7030,-13367,4859,-9768,1413,-18866,-19903,-12421,-14200,16412,14492,12160,9288,-9196,-546,1186,18918,0,11666,-29052,-22049,-21749,-17045,8208,2731,2473,-8794,-7349,-15081,11422,6066,21279,21324,5750,15630,-10657,2749,-11266,3290,-662,18077,-5577,12796,-28473,-14246,-28111,-18334,-4669,-1851,-982,-314,-12899,-9460,-16384,-19197,-12942,-25195,2011,-9460,16383,8182,2368,-4177,-14382,-18334,-4669,-14350,4776,-13419,8342,-4210,18443,15246,7417,5146,-16338,-17045,-8209,-10933,6945,-7372,1558,-15081,11422,5423,24462,23615,-150,1413,-18866,-10856,-1900,2751,-1502,-9460,-16384,-29318,3810,-8586,28015,14492,12160,3013,-3222,-2749,9378,15630,10656,20434,-11781,1123,-23596,-13868,-12868,-9734,-492,-187,-4744,-7781,-17244,-27585,-10108,-26221,14163,-4210,18443,1049,1875,-11824,-2011,-17045,8208,-12765,17748,-385,23345,14492,12160,6314,-7408,-13668,-1352,-9460,16383,2668,15310,4824,13369,15630,10656,15471,-10772,-10960,-13777,-15081,11422,3562,13342,-630,4872,1413,18865,26184,10033,16019,-21401,-13868,-12868,-5255,7651,2952,-5626,-18334,-4669,-14890,23484,14389,23303,18918,0,5657,-6533,655,-2319,0,-1,1019,1725,2164,309,0,0,606,2233,2222,652,0,0,461,2220,2110,722,-1,0,378,2114,1974,728,0,-1,318,1994,1844,715,0,-1,272,1879,1725,696,-1,0,235,1774,1620,676,0,0,204,1679,1526,656,0,0,177,1594,1442,636,0,-1,155,1517};
static int16_t pss6144_2_0[512]__attribute__((aligned(16)))={1301,-602,136,-1450,-1,-1,1368,-619,155,-1518,0,0,1442,-637,177,-1595,0,-1,1526,-657,204,-1680,0,-1,1620,-677,235,-1775,0,-1,1725,-697,272,-1880,0,0,1844,-716,318,-1995,-1,0,1974,-729,378,-2115,-1,-1,2110,-723,461,-2221,0,0,2222,-653,606,-2234,0,0,2164,-310,1019,-1726,0,0,655,2318,5657,6532,18918,0,14389,-23304,-14890,-23485,-18334,4668,2952,5625,-5255,-7652,-13868,12867,16019,21400,26184,-10034,1413,-18866,-630,-4873,3562,-13343,-15081,-11423,-10960,13776,15471,10771,15630,-10657,4824,-13370,2668,-15311,-9460,-16384,-13668,1351,6314,7407,14492,-12161,-385,-23346,-12765,-17749,-17045,-8209,-11824,2010,1049,-1876,-4210,-18444,-26221,-14164,-27585,10107,-7781,17243,-187,4743,-9734,491,-13868,12867,1123,23595,20434,11780,15630,-10657,-2749,-9379,3013,3221,14492,-12161,-8586,-28016,-29318,-3811,-9460,16383,2751,1501,-10856,1899,1413,18865,23615,149,5423,-24463,-15081,-11423,-7372,-1559,-10933,-6946,-17045,8208,5146,16337,15246,-7418,-4210,-18444,-13419,-8343,-14350,-4777,-18334,4668,-4177,14381,8182,-2369,-9460,-16384,-25195,-2012,-19197,12941,-9460,16383,-314,12898,-1851,981,-18334,4668,-14246,28110,12796,28472,18077,5576,3290,661,2749,11265,15630,10656,21324,-5751,6066,-21280,-15081,-11423,-8794,7348,2731,-2474,-17045,-8209,-22049,21748,11666,29051,18918,0,-546,-1187,9288,9195,14492,-12161,-14200,-16413,-19903,12420,1413,18865,4859,9767,7030,13366,18077,5576,10646,-8573,-614,-4413,0,0,-3576,2624,1972,13503,18077,5576,7999,-12885,-11017,-679,1413,18865,20647,10913,21185,-4094,14492,-12161,3257,-12754,1172,117,18918,0,19264,-24742,-7939,-29973,-17045,-8209,-3570,-1241,-2096,-11293,-15081,-11423,-21524,5273,-5810,21340,15630,10656,8320,-8127,-2347,2515,18077,5576,18198,-25431,-17350,-26396,-18334,4668,1714,999,-11142,-6724,-9460,16383,20744,10041,14211,-20817,-9460,-16384,-6204,-6015,-10495,-10812,-18334,4668,2977,14702,13806,-7454,-4210,-18444,-14109,-9608,-16850,-3716,-17045,8208,-611,12828,4907,-5608,-15081,-11423,-23958,7422,-12065,20373,1413,18865,7011,8339,-2804,1628,-9460,16383,11297,27182,28427,6569,14492,-12161,1221,-4334,9368,2306,15630,-10657,-77,-23700,-21125,-10828,-13868,12867,5231,8070,-4143,-2537,-7781,17243,22484,18722,25248,-15630,-4210,-18444,-2211,-83,4042,-11248,-17045,-8209,-9050,19816,20281,11336,14492,-12161,3196,-9285,5535,-12516,-9460,-16384,-14655,5232,9038,10859,15630,-10657,1531,-18897,-6580,-16383,-15081,-11423,-13398,3473,4406,1887,1413,-18866,-21843,-17773,-26671,3169,-13868,12867,-4061,8264,-6477,-260,-18334,4668,-12955,24525,12859,24110,18918,-1,2767,-8278,-2464,-595,-1,-1,-2066,-133,-942,2026,-1,-1,-2299,479,-675,2247,0,0,-2215,597,-558,2185,0,0,-2082,617,-485,2071,0,-1,-1948,608,-431,1951,0,-1,-1825,590,-388,1839,0,0,-1716,570,-353,1738,-1,-1,-1618,550,-323,1646,0,0,-1531,530,-298,1564,0,-1,-1454,511,-277,1490,0,0,-1385,494};
static int16_t pss6144_2_1[512]__attribute__((aligned(16)))={0,0,1301,-602,136,-1450,-1,-1,1368,-619,155,-1518,0,0,1442,-637,177,-1595,0,-1,1526,-657,204,-1680,0,-1,1620,-677,235,-1775,0,-1,1725,-697,272,-1880,0,0,1844,-716,318,-1995,-1,0,1974,-729,378,-2115,-1,-1,2110,-723,461,-2221,0,0,2222,-653,606,-2234,0,0,2164,-310,1019,-1726,0,0,655,2318,5657,6532,18918,0,14389,-23304,-14890,-23485,-18334,4668,2952,5625,-5255,-7652,-13868,12867,16019,21400,26184,-10034,1413,-18866,-630,-4873,3562,-13343,-15081,-11423,-10960,13776,15471,10771,15630,-10657,4824,-13370,2668,-15311,-9460,-16384,-13668,1351,6314,7407,14492,-12161,-385,-23346,-12765,-17749,-17045,-8209,-11824,2010,1049,-1876,-4210,-18444,-26221,-14164,-27585,10107,-7781,17243,-187,4743,-9734,491,-13868,12867,1123,23595,20434,11780,15630,-10657,-2749,-9379,3013,3221,14492,-12161,-8586,-28016,-29318,-3811,-9460,16383,2751,1501,-10856,1899,1413,18865,23615,149,5423,-24463,-15081,-11423,-7372,-1559,-10933,-6946,-17045,8208,5146,16337,15246,-7418,-4210,-18444,-13419,-8343,-14350,-4777,-18334,4668,-4177,14381,8182,-2369,-9460,-16384,-25195,-2012,-19197,12941,-9460,16383,-314,12898,-1851,981,-18334,4668,-14246,28110,12796,28472,18077,5576,3290,661,2749,11265,15630,10656,21324,-5751,6066,-21280,-15081,-11423,-8794,7348,2731,-2474,-17045,-8209,-22049,21748,11666,29051,18918,0,-546,-1187,9288,9195,14492,-12161,-14200,-16413,-19903,12420,1413,18865,4859,9767,7030,13366,18077,5576,10646,-8573,-614,-4413,0,0,-3576,2624,1972,13503,18077,5576,7999,-12885,-11017,-679,1413,18865,20647,10913,21185,-4094,14492,-12161,3257,-12754,1172,117,18918,0,19264,-24742,-7939,-29973,-17045,-8209,-3570,-1241,-2096,-11293,-15081,-11423,-21524,5273,-5810,21340,15630,10656,8320,-8127,-2347,2515,18077,5576,18198,-25431,-17350,-26396,-18334,4668,1714,999,-11142,-6724,-9460,16383,20744,10041,14211,-20817,-9460,-16384,-6204,-6015,-10495,-10812,-18334,4668,2977,14702,13806,-7454,-4210,-18444,-14109,-9608,-16850,-3716,-17045,8208,-611,12828,4907,-5608,-15081,-11423,-23958,7422,-12065,20373,1413,18865,7011,8339,-2804,1628,-9460,16383,11297,27182,28427,6569,14492,-12161,1221,-4334,9368,2306,15630,-10657,-77,-23700,-21125,-10828,-13868,12867,5231,8070,-4143,-2537,-7781,17243,22484,18722,25248,-15630,-4210,-18444,-2211,-83,4042,-11248,-17045,-8209,-9050,19816,20281,11336,14492,-12161,3196,-9285,5535,-12516,-9460,-16384,-14655,5232,9038,10859,15630,-10657,1531,-18897,-6580,-16383,-15081,-11423,-13398,3473,4406,1887,1413,-18866,-21843,-17773,-26671,3169,-13868,12867,-4061,8264,-6477,-260,-18334,4668,-12955,24525,12859,24110,18918,-1,2767,-8278,-2464,-595,-1,-1,-2066,-133,-942,2026,-1,-1,-2299,479,-675,2247,0,0,-2215,597,-558,2185,0,0,-2082,617,-485,2071,0,-1,-1948,608,-431,1951,0,-1,-1825,590,-388,1839,0,0,-1716,570,-353,1738,-1,-1,-1618,550,-323,1646,0,0,-1531,530,-298,1564,0,-1,-1454,511,-277,1490,0,0};
static int16_t pss6144_2_2[512]__attribute__((aligned(16)))={0,0,0,0,1301,-602,136,-1450,-1,-1,1368,-619,155,-1518,0,0,1442,-637,177,-1595,0,-1,1526,-657,204,-1680,0,-1,1620,-677,235,-1775,0,-1,1725,-697,272,-1880,0,0,1844,-716,318,-1995,-1,0,1974,-729,378,-2115,-1,-1,2110,-723,461,-2221,0,0,2222,-653,606,-2234,0,0,2164,-310,1019,-1726,0,0,655,2318,5657,6532,18918,0,14389,-23304,-14890,-23485,-18334,4668,2952,5625,-5255,-7652,-13868,12867,16019,21400,26184,-10034,1413,-18866,-630,-4873,3562,-13343,-15081,-11423,-10960,13776,15471,10771,15630,-10657,4824,-13370,2668,-15311,-9460,-16384,-13668,1351,6314,7407,14492,-12161,-385,-23346,-12765,-17749,-17045,-8209,-11824,2010,1049,-1876,-4210,-18444,-26221,-14164,-27585,10107,-7781,17243,-187,4743,-9734,491,-13868,12867,1123,23595,20434,11780,15630,-10657,-2749,-9379,3013,3221,14492,-12161,-8586,-28016,-29318,-3811,-9460,16383,2751,1501,-10856,1899,1413,18865,23615,149,5423,-24463,-15081,-11423,-7372,-1559,-10933,-6946,-17045,8208,5146,16337,15246,-7418,-4210,-18444,-13419,-8343,-14350,-4777,-18334,4668,-4177,14381,8182,-2369,-9460,-16384,-25195,-2012,-19197,12941,-9460,16383,-314,12898,-1851,981,-18334,4668,-14246,28110,12796,28472,18077,5576,3290,661,2749,11265,15630,10656,21324,-5751,6066,-21280,-15081,-11423,-8794,7348,2731,-2474,-17045,-8209,-22049,21748,11666,29051,18918,0,-546,-1187,9288,9195,14492,-12161,-14200,-16413,-19903,12420,1413,18865,4859,9767,7030,13366,18077,5576,10646,-8573,-614,-4413,0,0,-3576,2624,1972,13503,18077,5576,7999,-12885,-11017,-679,1413,18865,20647,10913,21185,-4094,14492,-12161,3257,-12754,1172,117,18918,0,19264,-24742,-7939,-29973,-17045,-8209,-3570,-1241,-2096,-11293,-15081,-11423,-21524,5273,-5810,21340,15630,10656,8320,-8127,-2347,2515,18077,5576,18198,-25431,-17350,-26396,-18334,4668,1714,999,-11142,-6724,-9460,16383,20744,10041,14211,-20817,-9460,-16384,-6204,-6015,-10495,-10812,-18334,4668,2977,14702,13806,-7454,-4210,-18444,-14109,-9608,-16850,-3716,-17045,8208,-611,12828,4907,-5608,-15081,-11423,-23958,7422,-12065,20373,1413,18865,7011,8339,-2804,1628,-9460,16383,11297,27182,28427,6569,14492,-12161,1221,-4334,9368,2306,15630,-10657,-77,-23700,-21125,-10828,-13868,12867,5231,8070,-4143,-2537,-7781,17243,22484,18722,25248,-15630,-4210,-18444,-2211,-83,4042,-11248,-17045,-8209,-9050,19816,20281,11336,14492,-12161,3196,-9285,5535,-12516,-9460,-16384,-14655,5232,9038,10859,15630,-10657,1531,-18897,-6580,-16383,-15081,-11423,-13398,3473,4406,1887,1413,-18866,-21843,-17773,-26671,3169,-13868,12867,-4061,8264,-6477,-260,-18334,4668,-12955,24525,12859,24110,18918,-1,2767,-8278,-2464,-595,-1,-1,-2066,-133,-942,2026,-1,-1,-2299,479,-675,2247,0,0,-2215,597,-558,2185,0,0,-2082,617,-485,2071,0,-1,-1948,608,-431,1951,0,-1,-1825,590,-388,1839,0,0,-1716,570,-353,1738,-1,-1,-1618,550,-323,1646,0,0,-1531,530,-298,1564,0,-1,-1454,511,-277,1490};
static int16_t pss6144_2_3[512]__attribute__((aligned(16)))={0,0,0,0,0,0,1301,-602,136,-1450,-1,-1,1368,-619,155,-1518,0,0,1442,-637,177,-1595,0,-1,1526,-657,204,-1680,0,-1,1620,-677,235,-1775,0,-1,1725,-697,272,-1880,0,0,1844,-716,318,-1995,-1,0,1974,-729,378,-2115,-1,-1,2110,-723,461,-2221,0,0,2222,-653,606,-2234,0,0,2164,-310,1019,-1726,0,0,655,2318,5657,6532,18918,0,14389,-23304,-14890,-23485,-18334,4668,2952,5625,-5255,-7652,-13868,12867,16019,21400,26184,-10034,1413,-18866,-630,-4873,3562,-13343,-15081,-11423,-10960,13776,15471,10771,15630,-10657,4824,-13370,2668,-15311,-9460,-16384,-13668,1351,6314,7407,14492,-12161,-385,-23346,-12765,-17749,-17045,-8209,-11824,2010,1049,-1876,-4210,-18444,-26221,-14164,-27585,10107,-7781,17243,-187,4743,-9734,491,-13868,12867,1123,23595,20434,11780,15630,-10657,-2749,-9379,3013,3221,14492,-12161,-8586,-28016,-29318,-3811,-9460,16383,2751,1501,-10856,1899,1413,18865,23615,149,5423,-24463,-15081,-11423,-7372,-1559,-10933,-6946,-17045,8208,5146,16337,15246,-7418,-4210,-18444,-13419,-8343,-14350,-4777,-18334,4668,-4177,14381,8182,-2369,-9460,-16384,-25195,-2012,-19197,12941,-9460,16383,-314,12898,-1851,981,-18334,4668,-14246,28110,12796,28472,18077,5576,3290,661,2749,11265,15630,10656,21324,-5751,6066,-21280,-15081,-11423,-8794,7348,2731,-2474,-17045,-8209,-22049,21748,11666,29051,18918,0,-546,-1187,9288,9195,14492,-12161,-14200,-16413,-19903,12420,1413,18865,4859,9767,7030,13366,18077,5576,10646,-8573,-614,-4413,0,0,-3576,2624,1972,13503,18077,5576,7999,-12885,-11017,-679,1413,18865,20647,10913,21185,-4094,14492,-12161,3257,-12754,1172,117,18918,0,19264,-24742,-7939,-29973,-17045,-8209,-3570,-1241,-2096,-11293,-15081,-11423,-21524,5273,-5810,21340,15630,10656,8320,-8127,-2347,2515,18077,5576,18198,-25431,-17350,-26396,-18334,4668,1714,999,-11142,-6724,-9460,16383,20744,10041,14211,-20817,-9460,-16384,-6204,-6015,-10495,-10812,-18334,4668,2977,14702,13806,-7454,-4210,-18444,-14109,-9608,-16850,-3716,-17045,8208,-611,12828,4907,-5608,-15081,-11423,-23958,7422,-12065,20373,1413,18865,7011,8339,-2804,1628,-9460,16383,11297,27182,28427,6569,14492,-12161,1221,-4334,9368,2306,15630,-10657,-77,-23700,-21125,-10828,-13868,12867,5231,8070,-4143,-2537,-7781,17243,22484,18722,25248,-15630,-4210,-18444,-2211,-83,4042,-11248,-17045,-8209,-9050,19816,20281,11336,14492,-12161,3196,-9285,5535,-12516,-9460,-16384,-14655,5232,9038,10859,15630,-10657,1531,-18897,-6580,-16383,-15081,-11423,-13398,3473,4406,1887,1413,-18866,-21843,-17773,-26671,3169,-13868,12867,-4061,8264,-6477,-260,-18334,4668,-12955,24525,12859,24110,18918,-1,2767,-8278,-2464,-595,-1,-1,-2066,-133,-942,2026,-1,-1,-2299,479,-675,2247,0,0,-2215,597,-558,2185,0,0,-2082,617,-485,2071,0,-1,-1948,608,-431,1951,0,-1,-1825,590,-388,1839,0,0,-1716,570,-353,1738,-1,-1,-1618,550,-323,1646,0,0,-1531,530,-298,1564,0,-1,-1454,511};
