# Find the native Nettle includes, library, and flags
#
# NETTLE_INCLUDE_DIR - where to find nettle.h, etc.
# NETTLE_LIBRARIES - List of libraries when using Nettle.
# NETTLE_FOUND - True if Nettle found.
IF (NETTLE_INCLUDE_DIR)
# Already in cache, be silent
    SET(NETTLE_FIND_QUIETLY TRUE)
ENDIF (NETTLE_INCLUDE_DIR)
FIND_PATH(NETTLE_INCLUDE_DIR nettle/nettle-meta.h)
SET(NETTLE_NAMES nettle)
FIND_LIBRARY(NETTLE_LIBRARY NAMES ${NETTLE_NAMES} )
# handle the QUIETLY and REQUIRED arguments and set NETTLE_FOUND to TRUE if
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(NETTLE DEFAULT_MSG NETTLE_LIBRARY NETTLE_INCLUDE_DIR)
IF(NETTLE_FOUND)
    SET(NETTLE_LIBRARIES ${NETTLE_LIBRARY})
ELSE(NETTLE_FOUND)
    SET(NETTLE_LIBRARIES )
ENDIF(NETTLE_FOUND)
MARK_AS_ADVANCED(NETTLE_LIBRARY NETTLE_INCLUDE_DIR)
