/***************************************************************************
                          nasRGdummy.c  -  description
                             -------------------
    copyright            : (C) 2005,  by Eurecom
    email                : michelle.wetterwald@eurecom.fr
 ***************************************************************************
 Dummy NAS for RG - Test interface with AR_RAL_UMTS
 ***************************************************************************/
#include <stdio.h>

#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include <netdb.h>
#include <sys/time.h>
#include <ctype.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#include "nas_rg_netlink.h"

//int state, cell_id;
//int rb_id;
/****************************************************************************/
// Constants to return to RAL 
/****************************************************************************/
#define CONF_MEAS_NUM_UES     2
#define CONF_MEAS_NUM_TOTAL_NUM_PRB  1000
int conf_rlcBufferOccupancy[CONF_MEAS_NUM_UES] = {60    , 70    };
int conf_scheduledPRB[CONF_MEAS_NUM_UES]       = {500   , 300    };
int conf_totalDataVolume[CONF_MEAS_NUM_UES]    = {640000, 800000 };

/****************************************************************************/
// Next part is used to receive the triggers
/****************************************************************************/
#ifdef MUSER_CONTROL

#define USER_IP_ADDRESS             "127.0.0.1"
#define USER_REMOTE_PORT            "0"
#define NAS_IP_ADDRESS              "127.0.0.1"
#define NAS_LISTENING_PORT_FOR_USER "22222"
#define INCREMENT_CONGESTION        40
#define RATIO_MODIF                  5  // percentage modification at each measure
#define MAX_MODIF                   30  // Max modif for measures

char        *g_mih_user_ip_address             = USER_IP_ADDRESS;
char        *g_mih_user_remote_port            = USER_REMOTE_PORT;
char        *g_nas_ip_address                  = NAS_IP_ADDRESS;
char        *g_nas_listening_port_for_mih_user = NAS_LISTENING_PORT_FOR_USER;
int          g_sockd_user;
signed int   g_user_congestion    = 0;
unsigned int g_ratio_modif        = 0;
//---------------------------------------------------------------------------
int NAS_user_connect(void){
//---------------------------------------------------------------------------
    struct addrinfo      hints;
    struct addrinfo     *result, *rp;
    int                  s, on;
    struct sockaddr_in  *addr  = NULL;
    struct sockaddr_in6 *addr6 = NULL;
    unsigned char        buf[sizeof(struct sockaddr_in6)];


    memset(&hints, 0, sizeof(struct addrinfo));
    hints.ai_family   = AF_UNSPEC;    /* Allow IPv4 or IPv6 */
    hints.ai_socktype = SOCK_DGRAM;   /* Datagram socket */
    hints.ai_flags    = 0;
    hints.ai_protocol = 0;            /* Any protocol */

    s = getaddrinfo(g_mih_user_ip_address, g_mih_user_remote_port, &hints, &result);
    if (s != 0) {
        printf("ERR getaddrinfo: %s\n", gai_strerror(s));
        return -1;
    }

    for (rp = result; rp != NULL; rp = rp->ai_next) {
        g_sockd_user = socket(rp->ai_family, rp->ai_socktype, rp->ai_protocol);
        if (g_sockd_user == -1)
            continue;

        on = 1;
        setsockopt( g_sockd_user, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on));

        if(rp->ai_family == AF_INET) {
            printf("Destination address  %s is an ipv4 address\n",g_mih_user_ip_address);
            addr             = (struct sockaddr_in *)(&buf[0]);
            addr->sin_port   = htons(atoi(g_nas_listening_port_for_mih_user));
            addr->sin_family = AF_INET;
            s = inet_pton(AF_INET, g_nas_ip_address, &addr->sin_addr);
            if (s <= 0) {
                if (s == 0) {
                    printf("ERR IP NAS address should be a IPv4 ADDR - But found not in presentation format : %s\n", g_nas_ip_address);
                } else {
                    printf("ERR %s - inet_pton(NAS IPv4 ADDR %s): %s\n", __FUNCTION__, g_nas_ip_address, strerror(s));
                }
                return -1;
            }

            s = bind(g_sockd_user, (const struct sockaddr *)addr, sizeof(struct sockaddr_in));
            if (s == -1) {
                printf("ERR NAS IPv4 Address Bind: %s\n", strerror(errno));
                return -1;
            }
            // sockd_mihf is of type SOCK_DGRAM, rp->ai_addr is the address to which datagrams are sent by default
            if (connect(g_sockd_user, rp->ai_addr, rp->ai_addrlen) != -1) {
                printf(" NAS is now UDP-CONNECTED to MIH-F\n");
                return 0;
            } else {
                close(g_sockd_user);
            }
        } else if (rp->ai_family == AF_INET6) {
            printf("Destination address  %s is an ipv6 address\n",g_mih_user_ip_address);
            addr6              = (struct sockaddr_in6 *)(&buf[0]);
            addr6->sin6_port   = htons(atoi(g_nas_listening_port_for_mih_user));
            addr6->sin6_family = AF_INET6;
            s = inet_pton(AF_INET, g_nas_ip_address, &addr6->sin6_addr);
            if (s <= 0) {
                if (s == 0) {
                    printf("ERR IP NAS address should be a IPv6 ADDR, But found not in presentation format : %s\n", g_nas_ip_address);
                } else {
                    printf("ERR %s - inet_pton(NAS IPv6 ADDR %s): %s\n", __FUNCTION__, g_nas_ip_address, strerror(s));
                }
                return -1;
            }

            s = bind(g_sockd_user, (const struct sockaddr *)addr6, sizeof(struct sockaddr_in));
            if (s == -1) {
                printf("ERR NAS IPv6 Address Bind: %s\n", strerror(errno));
                return -1;
            }
            if (connect(g_sockd_user, rp->ai_addr, rp->ai_addrlen) != -1) {
                printf(" NAS is now able to receive UDP control messages from MIH-User\n");
                return 0;
            } else {
                close(g_sockd_user);
            }
        } else {
            printf("ERR %s is an unknown address format %d\n",g_mih_user_ip_address,rp->ai_family);
        }
        close(g_sockd_user);
    }

    if (rp == NULL) {   /* No address succeeded */
        printf("ERR Could not establish socket to MIH-User\n");
        return -1;
    }
    return -1;
}

//---------------------------------------------------------------------------
int NAS_USERreceive(int sock){
//---------------------------------------------------------------------------
  unsigned char str[NAS_RG_NETL_MAXLEN];
  int  t, done;
    t=recv(sock, str, NAS_RG_NETL_MAXLEN, 0);
    if (t <= 0) {
        if (t < 0) perror("NAS_USERreceive : recv");
        done = 1;
    }
    printf("\nmessage from USER, length:  %d\n", t);
    switch (str[0]) {
        case 0xff:
            printf("USER ASK FOR STOPPING CONGESTION\n");
            g_user_congestion = 0;
            g_ratio_modif = 0;
            break;
/*        case 0x00:
            printf("USER ASK FOR NOT MODIFYING RSSI\n");
            g_user_congestion = 0;
            break;*/
        case 0x01:
            printf("USER ASK FOR STARTING CONGESTION\n");
            g_user_congestion = INCREMENT_CONGESTION;
            break;
        default:
            printf("received %hx\n", str[0]);
            return -1;
    }
    return 0;
}
#endif

/****************************************************************************/
//-----------------------------------------------------------------------------
int NAS_MIH_RAL_sock_connect(void){
//-----------------------------------------------------------------------------
    struct sockaddr_un remote;
    int len,s;

    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) {
        perror("NAS_MIH_RAL_sock_connect - socket");
        exit(1);
    }

    printf("Trying to connect...\n");
    remote.sun_family = AF_UNIX;
    strcpy(remote.sun_path, SOCK_RAL_NAS_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("NAS_MIH_RAL_sock_connect - connect() failed");
        exit(1);
    }

    printf("Connected to MIH_RAL.\n");
    return s;
}

//-----------------------------------------------------------------------------
int NAS_MIH_RALreceive(int s){
//-----------------------------------------------------------------------------
  char str1[NAS_RG_NETL_MAXLEN];
  char str2[NAS_RG_NETL_MAXLEN];
  int t, done, rc;
  int ix;
  struct nas_rg_netl_request *msgToRcve;
  struct nas_rg_netl_reply *msgToSend;

    done = 0;
    t = recv(s, str1, NAS_RG_NETL_MAXLEN, 0);
    if (t <= 0) {
        if (t < 0) perror("NAS_MIH_RALreceive : recv() failed");
        done = 1;
    }
    printf("\nmessage from MIH_RAL, length:  %d\n", t);

    msgToRcve = (struct nas_rg_netl_request *) str1;
    msgToSend = (struct nas_rg_netl_reply *) str2;
    memset(str2, 0, NAS_RG_NETL_MAXLEN);

    switch (msgToRcve->type){

      case NAS_RG_MSG_RB_ESTABLISH_REQUEST:
        printf("NAS_RG_MSG_RB_ESTABLISH_REQUEST received\n");
        msgToSend->type = NAS_RG_MSG_RB_ESTABLISH_REPLY;
        msgToSend->length = sizeof(struct nas_rg_netl_hdr)+sizeof(struct nas_rg_msg_rb_establish_reply);
        msgToSend->tqalNASPrimitive.rb_est_rep.cnxid = msgToRcve->tqalNASPrimitive.rb_est_req.cnxid;
        ix = (msgToRcve->tqalNASPrimitive.rb_est_req.cnxid-1) % 32;
        msgToSend->tqalNASPrimitive.rb_est_rep.ue_id = (msgToRcve->tqalNASPrimitive.rb_est_req.cnxid - ix - 1)/32;
        msgToSend->tqalNASPrimitive.rb_est_rep.RBParms.rbId = msgToRcve->tqalNASPrimitive.rb_est_req.RBParms.rbId;
        msgToSend->tqalNASPrimitive.rb_est_rep.RBParms.QoSclass = msgToRcve->tqalNASPrimitive.rb_est_req.RBParms.QoSclass;
        msgToSend->tqalNASPrimitive.rb_est_rep.RBParms.dscp = msgToRcve->tqalNASPrimitive.rb_est_req.RBParms.dscp;
        msgToSend->tqalNASPrimitive.rb_est_rep.result = NAS_CONNECTED;
        printf("Establishing Radio Bearer - cnx_id %d, Rb_id %d , QoSclass %d, dscp %d\n\n",
        msgToSend->tqalNASPrimitive.rb_est_rep.cnxid ,
        msgToSend->tqalNASPrimitive.rb_est_rep.RBParms.rbId ,
        msgToSend->tqalNASPrimitive.rb_est_rep.RBParms.QoSclass,
        msgToSend->tqalNASPrimitive.rb_est_rep.RBParms.dscp );
        break;

      case NAS_RG_MSG_RB_RELEASE_REQUEST:
        printf("NAS_RG_MSG_RB_RELEASE_REQUEST received\n");
        msgToSend->type = NAS_RG_MSG_RB_RELEASE_REPLY;
        msgToSend->length = sizeof(struct nas_rg_netl_hdr)+sizeof(struct nas_rg_msg_rb_release_reply);
        msgToSend->tqalNASPrimitive.rb_rel_rep.cnxid = msgToRcve->tqalNASPrimitive.rb_rel_req.cnxid;
        msgToSend->tqalNASPrimitive.rb_rel_rep.ue_id = msgToRcve->tqalNASPrimitive.rb_rel_req.ue_id;
        msgToSend->tqalNASPrimitive.rb_rel_rep.result = NAS_DISCONNECTED;
        printf("Releasing Radio Bearer - cnx_id %d, ue_id %d\n\n",
            msgToSend->tqalNASPrimitive.rb_rel_rep.cnxid,
            msgToSend->tqalNASPrimitive.rb_rel_rep.ue_id);
        break;

      case NAS_RG_MSG_MT_MCAST_JOIN:
        printf("NAS_RG_MSG_MT_MCAST_JOIN received\n");
        msgToSend->type = NAS_RG_MSG_MT_MCAST_JOIN_REP;
        msgToSend->length = sizeof(struct nas_rg_netl_hdr)+sizeof(struct nas_rg_msg_mt_mcast_join_rep);
        msgToSend->tqalNASPrimitive.mt_mc_join_rep.cnxid = msgToRcve->tqalNASPrimitive.mt_mcast_join.cnxid;
        msgToSend->tqalNASPrimitive.mt_mc_join_rep.ue_id = msgToRcve->tqalNASPrimitive.mt_mcast_join.ue_id;
        msgToSend->tqalNASPrimitive.mt_mc_join_rep.result = NAS_CONNECTED;
        printf("MT Joining Multicast - cnx_id %d, ue_id %d\n\n",
            msgToSend->tqalNASPrimitive.mt_mc_join_rep.cnxid,
            msgToSend->tqalNASPrimitive.mt_mc_join_rep.ue_id);
        break;

      case NAS_RG_MSG_MT_MCAST_LEAVE:
        printf("NAS_RG_MSG_MT_MCAST_LEAVE received\n");
        msgToSend->type = NAS_RG_MSG_MT_MCAST_LEAVE_REP;
        msgToSend->length = sizeof(struct nas_rg_netl_hdr)+sizeof(struct nas_rg_msg_mt_mcast_leave_rep);
        msgToSend->tqalNASPrimitive.mt_mc_leavce_rep.cnxid = msgToRcve->tqalNASPrimitive.mt_mcast_leave.cnxid;
        msgToSend->tqalNASPrimitive.mt_mc_leavce_rep.ue_id = msgToRcve->tqalNASPrimitive.mt_mcast_leave.ue_id;
        msgToSend->tqalNASPrimitive.mt_mc_leavce_rep.result = NAS_DISCONNECTED;
        printf("MT Leaving Multicast - cnx_id %d, ue_id %d\n\n",
            msgToSend->tqalNASPrimitive.mt_mc_leavce_rep.cnxid,
            msgToSend->tqalNASPrimitive.mt_mc_leavce_rep.ue_id);
        break;

      case NAS_RG_MSG_CNX_STATUS_REQUEST:
        printf("NAS_RG_MSG_CNX_STATUS_REQUEST received\n");
        break;
      case NAS_RG_MSG_RB_LIST_REQUEST:
        printf("NAS_RG_MSG_RB_LIST_REQUEST received\n");
        break;
      case NAS_RG_MSG_STATISTIC_REQUEST:
        printf("NAS_RG_MSG_STATISTIC_REQUEST received\n");
        break;
      case NAS_RG_MSG_MEASUREMENT_REQUEST:
        printf("NAS_RG_MSG_MEASUREMENT_REQUEST received\n");
        msgToSend->type = NAS_RG_MSG_MEASUREMENT_REPLY;
        msgToSend->length = sizeof(struct nas_rg_netl_hdr)+sizeof(struct nas_rg_msg_measure_reply);
        msgToSend->tqalNASPrimitive.meas_rep.cellid = msgToRcve->tqalNASPrimitive.meas_req.cellid;
        msgToSend->tqalNASPrimitive.meas_rep.num_UEs = CONF_MEAS_NUM_UES;
        msgToSend->tqalNASPrimitive.meas_rep.totalNumPRBs = CONF_MEAS_NUM_TOTAL_NUM_PRB;
        printf("Sending Measures - Current cell %d, Number of UEs %d, Total number of PRBs %d\n",
            msgToSend->tqalNASPrimitive.meas_rep.cellid,
            msgToSend->tqalNASPrimitive.meas_rep.num_UEs,
            msgToSend->tqalNASPrimitive.meas_rep.totalNumPRBs);
        for (ix=0; ix<CONF_MEAS_NUM_UES; ix++){
          msgToSend->tqalNASPrimitive.meas_rep.measures[ix].rlcBufferOccupancy = conf_rlcBufferOccupancy[ix];
          msgToSend->tqalNASPrimitive.meas_rep.measures[ix].scheduledPRB = conf_scheduledPRB[ix];
          msgToSend->tqalNASPrimitive.meas_rep.measures[ix].totalDataVolume = conf_totalDataVolume[ix];
          #ifdef MUSER_CONTROL
          if (ix == 0 && g_user_congestion){
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].rlcBufferOccupancy+=g_user_congestion;
            if (g_ratio_modif< MAX_MODIF) g_ratio_modif+= RATIO_MODIF;
            printf (" Congestion degradation is equal to %d \n", g_ratio_modif);
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].scheduledPRB= msgToSend->tqalNASPrimitive.meas_rep.measures[ix].scheduledPRB*(100-g_ratio_modif)/100;
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].totalDataVolume = msgToSend->tqalNASPrimitive.meas_rep.measures[ix].totalDataVolume * (100-g_ratio_modif)/100;
          } else  if (ix == 1 && g_user_congestion){
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].scheduledPRB= msgToSend->tqalNASPrimitive.meas_rep.measures[ix].scheduledPRB*(100+g_ratio_modif)/100;
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].totalDataVolume = msgToSend->tqalNASPrimitive.meas_rep.measures[ix].totalDataVolume * (100+g_ratio_modif)/100;
          }
          #endif
          printf("UE%d : RLC Buffers %d, scheduledPRB %d, totalDataVolume %d\n", ix,
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].rlcBufferOccupancy,
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].scheduledPRB,
            msgToSend->tqalNASPrimitive.meas_rep.measures[ix].totalDataVolume);
        }
        break;
      default:
        printf ("Invalid message Type %d\n",msgToRcve->type);
        break;
    }

    if ((rc = send(s, str2, msgToSend->length, 0)) < 0) {
        perror("NAS_MIH_RALreceive : send() failed");
        done = 1;
    } else {
        printf ("message (%d bytes) sent to MIH_RAL %d \n",msgToSend->length, rc);
    }

    return done;

}

//-----------------------------------------------------------------------------
int main(void){
//-----------------------------------------------------------------------------
    int s_ral, rc, done;
    fd_set readfds;
    struct timeval tv;

    /* Connect to the RAL-LTE */
    do {
      s_ral = NAS_MIH_RAL_sock_connect();
      if (s_ral <= 0) {
          sleep(2);
      }
    } while (s_ral < 0);

    /* Start listening to user commands */
    #ifdef MUSER_CONTROL
    NAS_user_connect();
    #endif

    done = 0;
    do {
        // Create fd_set and wait for input
        FD_ZERO(&readfds);
        FD_SET (s_ral, &readfds);
        #ifdef MUSER_CONTROL
        FD_SET (g_sockd_user, &readfds);
        #endif
        tv.tv_sec = 0;
        tv.tv_usec = 100000; // timeout select for 100ms and read FIFOs

        rc = select(FD_SETSIZE, &readfds, NULL, NULL, &tv);
        if (rc ==-1) {
            perror("main : select() failed");
            done = 1;
        }
        // something received !
        if (rc >= 0) {
            if (FD_ISSET(s_ral, &readfds)){
                done = NAS_MIH_RALreceive(s_ral);
            }
            #ifdef MUSER_CONTROL
            if (FD_ISSET(g_sockd_user,&readfds)){
                done = NAS_USERreceive(g_sockd_user);
            }
            #endif
        }

    } while (!done);

    close(s_ral);

    return 0;
}
