/*----------------------------------------------------------------------------*
 *                                                                            *
 *                              n w - g t p v 2 c                             *
 *    G P R S   T u n n e l i n g    P r o t o c o l   v 2 c    S t a c k     *
 *                                                                            *
 *                                                                            *
 * Copyright (c) 2010-2011 Amit Chawre                                        *
 * All rights reserved.                                                       *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 *                                                                            *
 * 1. Redistributions of source code must retain the above copyright          *
 *    notice, this list of conditions and the following disclaimer.           *
 * 2. Redistributions in binary form must reproduce the above copyright       *
 *    notice, this list of conditions and the following disclaimer in the     *
 *    documentation and/or other materials provided with the distribution.    *
 * 3. The name of the author may not be used to endorse or promote products   *
 *    derived from this software without specific prior written permission.   *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR       *
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,           *
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT   *
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,  *
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY      *
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT        *
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF   *
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.          *
 *----------------------------------------------------------------------------*/


#include <stdlib.h>
#include <stdint.h>

#ifndef __NW_TYPES_H__
#define __NW_TYPES_H__

/**
 * @file NwTypes.h
 * @brief This header file contains basic type definitions.
*/

#ifdef __cplusplus
extern "C" {
#endif

#define NW_IN                                   /**< An input argument          */
#define NW_OUT                                  /**< An output argument         */
#define NW_INOUT                                /**< An input and output argument */

#define NW_TRUE                 (1)             /**< Truth value                */
#define NW_FALSE                (0)             /**< False value                */

typedef unsigned char           NwU8T;          /**< Unsigned 1 byte            */
typedef unsigned short          NwU16T;         /**< Unsigned 2 byte            */
typedef unsigned int            NwU32T;         /**< Unsigned 4 byte            */
typedef unsigned long long      NwU64T;         /**< Unsigned 8 byte            */

typedef signed char             NwS8T;          /**< Signed 1 byte              */
typedef signed short            NwS16T;         /**< Signed 2 byte              */
typedef signed int              NwS32T;         /**< Signed 4 byte              */
typedef signed long long        NwS64T;         /**< Signed 8 byte              */

typedef char                    NwBoolT;        /**< Use this for booleans      */

typedef char                    NwCharT;        /**< Use this for strings       */

typedef signed int              NwFdT;          /**< Use this for file descriptor */

typedef uintptr_t               NwPtrT;         /**< Use this for generic pointers      */
typedef unsigned int            NwHandleT;      /**< Use this for generic handles       */


#ifdef __cplusplus
}
#endif

#endif /* __NW_TYPES_H__ */


