/*******************************************************************************
    OpenAirInterface
    Copyright(c) 1999 - 2014 Eurecom

    OpenAirInterface is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.


    OpenAirInterface is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with OpenAirInterface.The full GNU General Public License is
   included in this distribution in the file called "COPYING". If not,
   see <http://www.gnu.org/licenses/>.

  Contact Information
  OpenAirInterface Admin: openair_admin@eurecom.fr
  OpenAirInterface Tech : openair_tech@eurecom.fr
  OpenAirInterface Dev  : openair4g-devel@eurecom.fr

  Address      : Eurecom, Campus SophiaTech, 450 Route des Chappes, CS 50193 - 06904 Biot Sophia Antipolis cedex, FRANCE

 *******************************************************************************/
/******************************************************************************
 \file openair2_proc
# \brief print openair2 statistics
# \author Navid Nikaein
# \date 2013
# \version 0.1
# \email navid.nikaein@eurecom.fr
# @ingroup _mac
*/

#ifdef USER_MODE
# include <inttypes.h>
#else
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/proc_fs.h>

# ifndef PRIu64
#  if __WORDSIZE == 64
#     define PRIu64 "lu"
#   else
#     define PRIu64 "llu"
#   endif
# endif
#endif

#include "LAYER2/RLC/rlc.h"
#include "LAYER2/MAC/defs.h"
#include "LAYER2/MAC/extern.h"
#include "LAYER2/PDCP_v10.1.0/pdcp.h"
#include "UTIL/LOG/log.h"

static mapping rrc_status_names[] = {
  {"RRC_IDLE", 0},
  {"RRC_SI_RECEIVED",1},
  {"RRC_CONNECTED",2},
  {"RRC_RECONFIGURED",3},
  {NULL, -1}
};

int dump_eNB_l2_stats(char *buffer, int length)
{

  int eNB_id,UE_id,number_of_cards;
  int len= length;
  int CC_id=0;
  int i;

#ifdef EXMIMO
  number_of_cards=1;
#else
  number_of_cards=NB_eNB_INST;
#endif
  eNB_MAC_INST *eNB;
  UE_list_t *UE_list;

  for (eNB_id=0; eNB_id<number_of_cards; eNB_id++) {
    /* reset the values */
    eNB = &eNB_mac_inst[eNB_id];
    UE_list = &eNB->UE_list;

    for (CC_id=0 ; CC_id < MAX_NUM_CCs; CC_id++) {
      eNB->eNB_stats[CC_id].dlsch_bitrate= 0;

      len += sprintf(&buffer[len],"eNB %d CC %d Frame %d: Active UEs %d, Available PRBs %d, nCCE %d \n",
                     eNB_id, CC_id, eNB->frame,
                     eNB->eNB_stats[CC_id].num_dlactive_UEs,
                     eNB->eNB_stats[CC_id].available_prbs,
                     eNB->eNB_stats[CC_id].available_ncces);

      eNB->eNB_stats[CC_id].dlsch_bitrate=((eNB->eNB_stats[CC_id].dlsch_bytes_tx*8)/((eNB->frame + 1)*10));
      eNB->eNB_stats[CC_id].total_dlsch_pdus_tx+=eNB->eNB_stats[CC_id].dlsch_pdus_tx;
      eNB->eNB_stats[CC_id].total_dlsch_bytes_tx+=eNB->eNB_stats[CC_id].dlsch_bytes_tx;
      eNB->eNB_stats[CC_id].total_dlsch_bitrate=((eNB->eNB_stats[CC_id].total_dlsch_bytes_tx*8)/((eNB->frame + 1)*10));

      len += sprintf(&buffer[len],"DLSCH bitrate (TTI %u, avg %u) kbps, Transmitted bytes (TTI %u, total %u), Transmitted PDU (TTI %u, total %u) \n",
                     eNB->eNB_stats[CC_id].dlsch_bitrate,
                     eNB->eNB_stats[CC_id].total_dlsch_bitrate,
                     eNB->eNB_stats[CC_id].dlsch_bytes_tx,
                     eNB->eNB_stats[CC_id].total_dlsch_bytes_tx,
                     eNB->eNB_stats[CC_id].dlsch_pdus_tx,
                     eNB->eNB_stats[CC_id].total_dlsch_pdus_tx);
    }

    len += sprintf(&buffer[len],"\n");

    for (UE_id=UE_list->head; UE_id>=0; UE_id=UE_list->next[UE_id]) {
      for (i=0; i<UE_list->numactiveCCs[UE_id]; i++) {
        CC_id=UE_list->ordered_CCids[i][UE_id];
        UE_list->eNB_UE_stats[CC_id][UE_id].dlsch_bitrate=((UE_list->eNB_UE_stats[CC_id][UE_id].TBS*8)/((eNB->frame + 1)*10));
        UE_list->eNB_UE_stats[CC_id][UE_id].total_dlsch_bitrate= ((UE_list->eNB_UE_stats[CC_id][UE_id].total_pdu_bytes*8)/((eNB->frame + 1)*10));
        UE_list->eNB_UE_stats[CC_id][UE_id].total_overhead_bytes+=  UE_list->eNB_UE_stats[CC_id][UE_id].overhead_bytes;
        UE_list->eNB_UE_stats[CC_id][UE_id].avg_overhead_bytes=((UE_list->eNB_UE_stats[CC_id][UE_id].total_overhead_bytes*8)/((eNB->frame + 1)*10));

        len += sprintf(&buffer[len],"UE %d %s, RNTI %x : CQI %d, MCS1 %d, MCS2 %d, RB (tx %d, retx %d, total %d), ncce (tx %d, retx %d) \n",
                       UE_id,
                       map_int_to_str(rrc_status_names, UE_list->eNB_UE_stats[CC_id][UE_id].rrc_status),
                       UE_list->eNB_UE_stats[CC_id][UE_id].crnti,
                       UE_list->eNB_UE_stats[CC_id][UE_id].dl_cqi,
                       UE_list->eNB_UE_stats[CC_id][UE_id].dlsch_mcs1,
                       UE_list->eNB_UE_stats[CC_id][UE_id].dlsch_mcs2,
                       UE_list->eNB_UE_stats[CC_id][UE_id].rbs_used,
                       UE_list->eNB_UE_stats[CC_id][UE_id].rbs_used_retx,
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_rbs_used,
                       UE_list->eNB_UE_stats[CC_id][UE_id].ncce_used,
                       UE_list->eNB_UE_stats[CC_id][UE_id].ncce_used_retx
                      );

        len += sprintf(&buffer[len],
                       "[MAC] DLSCH bitrate (TTI %d, avg %d), Transmitted bytes "
                       "(TTI %d, total %"PRIu64"), Total Transmitted PDU %d, Overhead "
                       "(TTI %"PRIu64", total %"PRIu64", avg %"PRIu64")\n",
                       UE_list->eNB_UE_stats[CC_id][UE_id].dlsch_bitrate,
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_dlsch_bitrate,
                       UE_list->eNB_UE_stats[CC_id][UE_id].TBS,
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_pdu_bytes,
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_num_pdus,
                       UE_list->eNB_UE_stats[CC_id][UE_id].overhead_bytes,
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_overhead_bytes,
                       UE_list->eNB_UE_stats[CC_id][UE_id].avg_overhead_bytes
                      );
        len += sprintf(&buffer[len],
                       "[MAC] ULSCH received bytes (total %"PRIu64"),"
                       "Total received PDU %d, Total errors %d\n",
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_pdu_bytes_rx,
                       UE_list->eNB_UE_stats[CC_id][UE_id].total_num_pdus_rx,
                       UE_list->eNB_UE_stats[CC_id][UE_id].num_errors_rx);
        len+= sprintf(&buffer[len],"Received PHR PH = %d (db)\n", UE_list->UE_template[CC_id][UE_id].phr_info);
        len+= sprintf(&buffer[len],"Received BSR [0][1][2][3] = %d %d %d %d\n",
                      UE_list->UE_template[CC_id][UE_id].bsr_info[LCGID0],
                      UE_list->UE_template[CC_id][UE_id].bsr_info[LCGID1],
                      UE_list->UE_template[CC_id][UE_id].bsr_info[LCGID2],
                      UE_list->UE_template[CC_id][UE_id].bsr_info[LCGID3]
                     );
      }
    }
  }

  return len + 1 /* SR: for trailing \0 */;
}

#ifdef PROC
#ifndef USER_MODE
static int openair2_stats_read(char *buffer, char **my_buffer, off_t off, int length)
#else
int openair2_stats_read(char *buffer, char **my_buffer, off_t off, int length)
#endif
{

  int len = 0,fg,Overhead, Sign;
  unsigned int i,j,k,kk;
  unsigned int Mod_id = 0,CH_index;
  unsigned int tx_pdcp_sdu;
  unsigned int tx_pdcp_sdu_discarded;
  unsigned int tx_retransmit_pdu_unblock;
  unsigned int tx_retransmit_pdu_by_status;
  unsigned int tx_retransmit_pdu;
  unsigned int tx_data_pdu;
  unsigned int tx_control_pdu;
  unsigned int rx_sdu;
  unsigned int rx_error_pdu;
  unsigned int rx_data_pdu;
  unsigned int rx_data_pdu_out_of_window;
  unsigned int rx_control_pdu;

  //    if (mac_xface->is_cluster_head == 0) {
  for (k=0; k<NB_INST; k++) {



    if (Mac_rlc_xface->Is_cluster_head[k] == 0) {
#ifndef PHY_EMUL_ONE_MACHINE
      Mod_id=k-NB_CH_INST;

      len+=sprintf(&buffer[len],"UE TTI: %d\n",Mac_rlc_xface->frame);

      for (CH_index = 0; CH_index<NB_CNX_UE; CH_index++) {


        if (UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Active==1) {
          len+=sprintf(&buffer[len],"CH %d: Wideband SINR %d dB---\n",
                       CH_index,UE_mac_inst[Mod_id].Def_meas[CH_index].Wideband_sinr);
          len+=sprintf(&buffer[len],"CH %d: Subband SINR (dB) :",
                       CH_index);

          for (fg=0; fg<NUMBER_OF_MEASUREMENT_SUBBANDS; fg++) {
            len+=sprintf(&buffer[len],"%d ",UE_mac_inst[Mod_id].Def_meas[CH_index].Sinr_meas[0][fg]);
          }

          len+=sprintf(&buffer[len],"\n");


          len+=sprintf(&buffer[len],"BCCH %d, NB_RX_MAC = %d (%d errors)\n",
                       UE_mac_inst[Mod_id].Bcch_lchan[CH_index].Lchan_info.Lchan_id.Index,
                       UE_mac_inst[Mod_id].Bcch_lchan[CH_index].Lchan_info.NB_RX,
                       UE_mac_inst[Mod_id].Bcch_lchan[CH_index].Lchan_info.NB_RX_ERRORS);



          len+=sprintf(&buffer[len],"CCCH %d, NB_RX_MAC = %d (%d errors)\n",
                       UE_mac_inst[Mod_id].Ccch_lchan[CH_index].Lchan_info.Lchan_id.Index,
                       UE_mac_inst[Mod_id].Ccch_lchan[CH_index].Lchan_info.NB_RX,
                       UE_mac_inst[Mod_id].Ccch_lchan[CH_index].Lchan_info.NB_RX_ERRORS);


          len+=sprintf(&buffer[len],"LCHAN %d (DCCH), NB_TX_MAC = %d (%d bits/TTI, %d kbits/sec), NB_RX_MAC = %d (%d errors)\n",
                       UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Lchan_info.Lchan_id.Index,
                       UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Lchan_info.NB_TX,
                       UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Lchan_info.output_rate,
                       (10*UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Lchan_info.output_rate)>>5,
                       UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Lchan_info.NB_RX,
                       UE_mac_inst[Mod_id].Dcch_lchan[CH_index].Lchan_info.NB_RX_ERRORS);

          for(i=1; i<NB_RAB_MAX; i++) {
            if (UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Active==1) {
              Overhead=UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.output_rate - Pdcp_stats_tx_rate[k][CH_index][i];

              if(Overhead<0) {
                Overhead=-Overhead;
                Sign=-1;
              } else {
                Sign=1;
              }

              len+=sprintf(&buffer[len],
                           "[PDCP]LCHAN %d: NB_TX = %d ,Tx_rate =(%d bits/TTI ,%d Kbits/s), NB_RX = %d ,Rx_rate =(%d bits/TTI ,%d Kbits/s) , LAYER2 TX OVERHEAD: %d Kbits/s\n",
                           UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                           Pdcp_stats_tx[k][CH_index][i],
                           Pdcp_stats_tx_rate[k][CH_index][i],
                           (10*Pdcp_stats_tx_rate[k][CH_index][i])>>5,
                           Pdcp_stats_rx[k][CH_index][i],
                           Pdcp_stats_rx_rate[k][CH_index][i],
                           (10*Pdcp_stats_rx_rate[k][CH_index][i])>>5,
                           Sign*(10*Overhead)>>5);


              int status =  rlc_stat_req     (k,
                                              UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                                              &tx_pdcp_sdu,
                                              &tx_pdcp_sdu_discarded,
                                              &tx_retransmit_pdu_unblock,
                                              &tx_retransmit_pdu_by_status,
                                              &tx_retransmit_pdu,
                                              &tx_data_pdu,
                                              &tx_control_pdu,
                                              &rx_sdu,
                                              &rx_error_pdu,
                                              &rx_data_pdu,
                                              &rx_data_pdu_out_of_window,
                                              &rx_control_pdu) ;

              if (status == RLC_OP_STATUS_OK) {
                len+=sprintf(&buffer[len],"RLC LCHAN %d, NB_SDU_TO_TX = %d\tNB_SDU_DISC %d\tNB_RX_SDU %d\n",
                             UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                             tx_pdcp_sdu,
                             tx_pdcp_sdu_discarded,
                             rx_sdu);
                len+=sprintf(&buffer[len],"RLC LCHAN %d, NB_TB_TX_DATA = %d\tNB_TB_TX_CONTROL %d\tNB_TX_TB_RETRANS %d",
                             UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                             tx_data_pdu,
                             tx_control_pdu,
                             tx_retransmit_pdu);
                len+=sprintf(&buffer[len],"\tRLC LCHAN %d, NB_TX_TB_RETRANS_BY_STATUS = %d\tNB_TX_TB_RETRANS_PADD %d\n",
                             UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                             tx_retransmit_pdu_by_status,
                             tx_retransmit_pdu_unblock);
                len+=sprintf(&buffer[len],"RLC LCHAN %d, NB_RX_DATA = %d\tNB_RX_TB_OUT_WIN %d\tNB_RX_TB_CORRUPT %d\n",
                             UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                             rx_data_pdu,
                             rx_data_pdu_out_of_window,
                             rx_error_pdu);
              }

              len+=sprintf(&buffer[len],"[MAC]: LCHAN %d, NB_TX_MAC = %d (%d bits/TTI, %d kbits/s), NB_RX_MAC = %d (%d errors)\n",
                           UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.Lchan_id.Index,
                           UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.NB_TX,
                           UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.output_rate,
                           (10*UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.output_rate)>>5,
                           UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.NB_RX,
                           UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.NB_RX_ERRORS);
              len+=sprintf(&buffer[len],"        TX per TB: ");

              for(kk=0; kk<MAX_NUMBER_TB_PER_LCHAN/2; kk++) {
                len+=sprintf(&buffer[len],"%d . ",UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.NB_TX_TB[kk]);
              }

              len+=sprintf(&buffer[len],"\n");
              len+=sprintf(&buffer[len],"        RXerr per TB: ");

              for(kk=0; kk<MAX_NUMBER_TB_PER_LCHAN/2; kk++)
                len+=sprintf(&buffer[len],"%d/%d . ",UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.NB_RX_ERRORS_TB[kk],
                             UE_mac_inst[Mod_id].Dtch_lchan[i][CH_index].Lchan_info.NB_RX_TB[kk]);

              len+=sprintf(&buffer[len],"\n");



            }

          }
        }
      }

#endif //PHY_EMUL_ONE_MACHINE
    } else if(Mac_rlc_xface->Is_cluster_head[k] ==1) {

      Mod_id=k;
      len+=sprintf(&buffer[len],
                   "-------------------------------------------------------------------CH %d: TTI: %d------------------------------------------------------------------\n",
                   NODE_ID[Mod_id],Mac_rlc_xface->frame);

      for(i=1; i<=NB_CNX_CH; i++) {
        if (CH_mac_inst[Mod_id].Dcch_lchan[i].Active==1) {
          len+=sprintf(&buffer[len],"\nMR index %d: DL SINR (feedback) %d dB, CQI: %s\n\n",
                       i,//CH_rrc_inst[Mod_id].Info.UE_list[i].L2_id[0],
                       CH_mac_inst[Mod_id].Def_meas[i].Wideband_sinr,
                       print_cqi(CH_mac_inst[Mod_id].Def_meas[i].cqi));

          len+=sprintf(&buffer[len],
                       "[MAC] LCHAN %d (DCCH), NB_TX_MAC= %d (%d bits/TTI, %d kbits/s), NB_RX_MAC= %d (errors %d, sacch errors %d, sach errors %d, sach_missing %d)\n\n",
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.Lchan_id.Index,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.NB_TX,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.output_rate,
                       (10*CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.output_rate)>>5,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.NB_RX,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.NB_RX_ERRORS,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.NB_RX_SACCH_ERRORS,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.NB_RX_SACH_ERRORS,
                       CH_mac_inst[Mod_id].Dcch_lchan[i].Lchan_info.NB_RX_SACH_MISSING);

          for(j=0; j<NB_RAB_MAX; j++) {
            if (CH_mac_inst[Mod_id].Dtch_lchan[j][i].Active==1) {
              Overhead=CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.output_rate - Pdcp_stats_tx_rate[k][i][j];

              if(Overhead<0) {
                Overhead=-Overhead;
                Sign=-1;
              } else {
                Sign=1;
              }

              len+=sprintf(&buffer[len],
                           "[PDCP]LCHAN %d: NB_TX = %d ,Tx_rate =(%d bits/TTI ,%d Kbits/s), NB_RX = %d ,Rx_rate =(%d bits/TTI ,%d Kbits/s), LAYER2 TX OVERHEAD= %d Kbits/s\n",
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
                           Pdcp_stats_tx[k][i][j],
                           Pdcp_stats_tx_rate[k][i][j],
                           (10*Pdcp_stats_tx_rate[k][i][j])>>5,
                           Pdcp_stats_rx[k][i][j],
                           Pdcp_stats_rx_rate[k][i][j],
                           (10*Pdcp_stats_rx_rate[k][i][j])>>5,
                           Sign*(10*Overhead)>>5);
              int status =  rlc_stat_req     (k,
                                              CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
                                              &tx_pdcp_sdu,
                                              &tx_pdcp_sdu_discarded,
                                              &tx_retransmit_pdu_unblock,
                                              &tx_retransmit_pdu_by_status,
                                              &tx_retransmit_pdu,
                                              &tx_data_pdu,
                                              &tx_control_pdu,
                                              &rx_sdu,
                                              &rx_error_pdu,
                                              &rx_data_pdu,
                                              &rx_data_pdu_out_of_window,
                                              &rx_control_pdu) ;
              /*
              if (status == RLC_OP_STATUS_OK) {
              len+=sprintf(&buffer[len],"\t[RLC] LCHAN %d, NB_SDU_TO_TX = %d\tNB_SDU_DISC %d\tNB_RX_SDU %d\n",
                  CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
               tx_pdcp_sdu,
               tx_pdcp_sdu_discarded,
               rx_sdu);
              len+=sprintf(&buffer[len],"\t[RLC] LCHAN %d, NB_TB_TX_DATA = %d\tNB_TB_TX_CONTROL %d\tNB_TX_TB_RETRANS %\n",
                  CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
               tx_data_pdu,
               tx_control_pdu,
               tx_retransmit_pdu);
              len+=sprintf(&buffer[len],"\t[RLC] LCHAN %d, NB_TX_TB_RETRANS_BY_STATUS = %d\tNB_TX_TB_RETRANS_PADD %d\n",
                  CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
               tx_retransmit_pdu_by_status,
               tx_retransmit_pdu_unblock);
              len+=sprintf(&buffer[len],"\t[RLC] LCHAN %d, NB_RX_DATA = %d\tNB_RX_TB_OUT_WIN %d\tNB_RX_TB_CORRUPT %d\n",
                  CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
               rx_data_pdu,
               rx_data_pdu_out_of_window,
               rx_error_pdu);
              }
              */
              len+=sprintf(&buffer[len],
                           "[MAC]LCHAN %d (CNX %d,RAB %d), NB_TX_MAC= %d (%d bits/TTI, %d kbit/s), NB_RX_MAC= %d (errors %d, sacch_errors %d, sach_errors %d, sach_missing %d)\n",
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Lchan_id.Index,
                           i,j,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_TX,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.output_rate,
                           (10*CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.output_rate)>>5,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX_ERRORS,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX_SACCH_ERRORS,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX_SACH_ERRORS,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX_SACH_MISSING);
              len+=sprintf(&buffer[len],"[MAC][SCHEDULER] TX Arrival Rate %d, TX Service Rate %d, RX Arrival rate %d, RX Service rate %d, NB_BW_REQ_RX %d\n\n",
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Arrival_rate,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Tx_rate,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Req_rate,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.Rx_rate,
                           CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_BW_REQ_RX);

              /*
                      len+=sprintf(&buffer[len],"        TX per TB: ");
                      for(kk=0;kk<MAX_NUMBER_TB_PER_LCHAN/2;kk++)
                  len+=sprintf(&buffer[len],"%d.",CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_TX_TB[kk]);
                      len+=sprintf(&buffer[len],"\n");
                      len+=sprintf(&buffer[len],"        RXerr per TB: ");
                      for(kk=0;kk<MAX_NUMBER_TB_PER_LCHAN/2;kk++)
                  len+=sprintf(&buffer[len],"%d/%d . ",CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX_ERRORS_TB[kk],
                         CH_mac_inst[Mod_id].Dtch_lchan[j][i].Lchan_info.NB_RX_TB[kk]);
                      len+=sprintf(&buffer[len],"\n");
              */
            }
          }
        }
      }

    }
  }

  return len;
}

#ifndef USER_MODE
static struct proc_dir_entry *proc_openair2_root;
/*
 * Initialize the module and add the /proc file.
 */
int add_openair2_stats()
{
  struct proc_dir_entry *pde;

  proc_openair2_root = proc_mkdir("openair2",0);
  // pde = proc_create_entry("lchan_stats", S_IFREG | S_IRUGO, proc_openair2_root);
  pde = proc_create_data("lchan_stats", S_IFREG | S_IRUGO, proc_openair2_root, NULL,openair2_stats_read);

  if (!pde) {
    printk("[OPENAIR][ERROR] can't create proc entry !\n");
  }

  return 0;
}
/*
 * Unregister the file when the module is closed.
 */
void remove_openair_stats()
{

  if (proc_openair2_root) {
    printk("[OPENAIR][CLEANUP] Removing openair proc entry\n");
    remove_proc_entry("lchan_stats", proc_openair2_root);

  }
}
#endif
#endif
