/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.0  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

static short lookup_table[1025] = {0x7fff, 0x16a0, 0x1000, 0xd10, 0xb50, 0xa1e, 0x93c, 0x88d, 0x800, 0x78a, 0x727, 0x6d2, 0x688, 0x646, 0x60c, 0x5d7, 0x5a8, 0x57c, 0x555, 0x530, 0x50f, 0x4f0, 0x4d2, 0x4b7, 0x49e, 0x486, 0x470, 0x45a, 0x446, 0x433, 0x421, 0x410, 0x400, 0x3f0, 0x3e1, 0x3d3, 0x3c5, 0x3b8, 0x3ab, 0x39f, 0x393, 0x388, 0x37d, 0x373, 0x369, 0x35f, 0x356, 0x34c, 0x344, 0x33b, 0x333, 0x32b, 0x323, 0x31b, 0x314, 0x30d, 0x306, 0x2ff, 0x2f8, 0x2f2, 0x2eb, 0x2e5, 0x2df, 0x2d9, 0x2d4, 0x2ce, 0x2c9, 0x2c3, 0x2be, 0x2b9, 0x2b4, 0x2af, 0x2aa, 0x2a5, 0x2a1, 0x29c, 0x298, 0x294, 0x28f, 0x28b, 0x287, 0x283, 0x27f, 0x27b, 0x278, 0x274, 0x270, 0x26d, 0x269, 0x266, 0x262, 0x25f, 0x25b, 0x258, 0x255, 0x252, 0x24f, 0x24c, 0x249, 0x246, 0x243, 0x240, 0x23d, 0x23a, 0x238, 0x235, 0x232, 0x22f, 0x22d, 0x22a, 0x228, 0x225, 0x223, 0x220, 0x21e, 0x21c, 0x219, 0x217, 0x215, 0x213, 0x210, 0x20e, 0x20c, 0x20a, 0x208, 0x206, 0x204, 0x202, 0x200, 0x1fe, 0x1fc, 0x1fa, 0x1f8, 0x1f6, 0x1f4, 0x1f2, 0x1f0, 0x1ee, 0x1ed, 0x1eb, 0x1e9, 0x1e7, 0x1e6, 0x1e4, 0x1e2, 0x1e1, 0x1df, 0x1dd, 0x1dc, 0x1da, 0x1d8, 0x1d7, 0x1d5, 0x1d4, 0x1d2, 0x1d1, 0x1cf, 0x1ce, 0x1cc, 0x1cb, 0x1c9, 0x1c8, 0x1c7, 0x1c5, 0x1c4, 0x1c2, 0x1c1, 0x1c0, 0x1be, 0x1bd, 0x1bc, 0x1ba, 0x1b9, 0x1b8, 0x1b7, 0x1b5, 0x1b4, 0x1b3, 0x1b2, 0x1b0, 0x1af, 0x1ae, 0x1ad, 0x1ac, 0x1ab, 0x1a9, 0x1a8, 0x1a7, 0x1a6, 0x1a5, 0x1a4, 0x1a3, 0x1a2, 0x1a0, 0x19f, 0x19e, 0x19d, 0x19c, 0x19b, 0x19a, 0x199, 0x198, 0x197, 0x196, 0x195, 0x194, 0x193, 0x192, 0x191, 0x190, 0x18f, 0x18e, 0x18d, 0x18c, 0x18b, 0x18b, 0x18a, 0x189, 0x188, 0x187, 0x186, 0x185, 0x184, 0x183, 0x183, 0x182, 0x181, 0x180, 0x17f, 0x17e, 0x17d, 0x17d, 0x17c, 0x17b, 0x17a, 0x179, 0x179, 0x178, 0x177, 0x176, 0x175, 0x175, 0x174, 0x173, 0x172, 0x172, 0x171, 0x170, 0x16f, 0x16f, 0x16e, 0x16d, 0x16c, 0x16c, 0x16b, 0x16a, 0x16a, 0x169, 0x168, 0x167, 0x167, 0x166, 0x165, 0x165, 0x164, 0x163, 0x163, 0x162, 0x161, 0x161, 0x160, 0x15f, 0x15f, 0x15e, 0x15d, 0x15d, 0x15c, 0x15c, 0x15b, 0x15a, 0x15a, 0x159, 0x158, 0x158, 0x157, 0x157, 0x156, 0x155, 0x155, 0x154, 0x154, 0x153, 0x152, 0x152, 0x151, 0x151, 0x150, 0x150, 0x14f, 0x14e, 0x14e, 0x14d, 0x14d, 0x14c, 0x14c, 0x14b, 0x14b, 0x14a, 0x14a, 0x149, 0x148, 0x148, 0x147, 0x147, 0x146, 0x146, 0x145, 0x145, 0x144, 0x144, 0x143, 0x143, 0x142, 0x142, 0x141, 0x141, 0x140, 0x140, 0x13f, 0x13f, 0x13e, 0x13e, 0x13d, 0x13d, 0x13c, 0x13c, 0x13c, 0x13b, 0x13b, 0x13a, 0x13a, 0x139, 0x139, 0x138, 0x138, 0x137, 0x137, 0x136, 0x136, 0x136, 0x135, 0x135, 0x134, 0x134, 0x133, 0x133, 0x133, 0x132, 0x132, 0x131, 0x131, 0x130, 0x130, 0x130, 0x12f, 0x12f, 0x12e, 0x12e, 0x12d, 0x12d, 0x12d, 0x12c, 0x12c, 0x12b, 0x12b, 0x12b, 0x12a, 0x12a, 0x129, 0x129, 0x129, 0x128, 0x128, 0x127, 0x127, 0x127, 0x126, 0x126, 0x126, 0x125, 0x125, 0x124, 0x124, 0x124, 0x123, 0x123, 0x123, 0x122, 0x122, 0x121, 0x121, 0x121, 0x120, 0x120, 0x120, 0x11f, 0x11f, 0x11f, 0x11e, 0x11e, 0x11e, 0x11d, 0x11d, 0x11d, 0x11c, 0x11c, 0x11c, 0x11b, 0x11b, 0x11a, 0x11a, 0x11a, 0x119, 0x119, 0x119, 0x118, 0x118, 0x118, 0x117, 0x117, 0x117, 0x117, 0x116, 0x116, 0x116, 0x115, 0x115, 0x115, 0x114, 0x114, 0x114, 0x113, 0x113, 0x113, 0x112, 0x112, 0x112, 0x111, 0x111, 0x111, 0x111, 0x110, 0x110, 0x110, 0x10f, 0x10f, 0x10f, 0x10e, 0x10e, 0x10e, 0x10e, 0x10d, 0x10d, 0x10d, 0x10c, 0x10c, 0x10c, 0x10c, 0x10b, 0x10b, 0x10b, 0x10a, 0x10a, 0x10a, 0x10a, 0x109, 0x109, 0x109, 0x108, 0x108, 0x108, 0x108, 0x107, 0x107, 0x107, 0x107, 0x106, 0x106, 0x106, 0x105, 0x105, 0x105, 0x105, 0x104, 0x104, 0x104, 0x104, 0x103, 0x103, 0x103, 0x103, 0x102, 0x102, 0x102, 0x102, 0x101, 0x101, 0x101, 0x101, 0x100, 0x100, 0x100, 0x100, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd, 0xfd, 0xfd, 0xfc, 0xfc, 0xfc, 0xfc, 0xfb, 0xfb, 0xfb, 0xfb, 0xfa, 0xfa, 0xfa, 0xfa, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf8, 0xf8, 0xf8, 0xf8, 0xf7, 0xf7, 0xf7, 0xf7, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf5, 0xf5, 0xf5, 0xf5, 0xf5, 0xf4, 0xf4, 0xf4, 0xf4, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf2, 0xf2, 0xf2, 0xf2, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xef, 0xef, 0xef, 0xef, 0xef, 0xee, 0xee, 0xee, 0xee, 0xee, 0xed, 0xed, 0xed, 0xed, 0xed, 0xec, 0xec, 0xec, 0xec, 0xec, 0xeb, 0xeb, 0xeb, 0xeb, 0xeb, 0xea, 0xea, 0xea, 0xea, 0xea, 0xe9, 0xe9, 0xe9, 0xe9, 0xe9, 0xe9, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xe6, 0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe2, 0xe2, 0xe2, 0xe2, 0xe2, 0xe1, 0xe1, 0xe1, 0xe1, 0xe1, 0xe1, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xde, 0xde, 0xde, 0xde, 0xde, 0xde, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdc, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xdb, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xda, 0xd9, 0xd9, 0xd9, 0xd9, 0xd9, 0xd9, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd8, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd7, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd6, 0xd5, 0xd5, 0xd5, 0xd5, 0xd5, 0xd5, 0xd5, 0xd4, 0xd4, 0xd4, 0xd4, 0xd4, 0xd4, 0xd4, 0xd3, 0xd3, 0xd3, 0xd3, 0xd3, 0xd3, 0xd3, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd2, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xce, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcd, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcb, 0xcb, 0xcb, 0xcb, 0xcb, 0xcb, 0xcb, 0xcb, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xca, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9, 0xc9, 0xc8, 0xc8, 0xc8, 0xc8, 0xc8, 0xc8, 0xc8, 0xc8, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc5, 0xc5, 0xc5, 0xc5, 0xc5, 0xc5, 0xc5, 0xc5, 0xc5, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc3, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbe, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb9, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5};

short invSqrt(short x)
{
  short x1,x2,y1,y2;

  x1=x>>5;
  x2=x1+1;
  y1=lookup_table[x1];
  y2=lookup_table[x2];
  //printf("x1=%d,x2=%d,y1=%d,y2=%d\n",x1,x2,y1,y2);
  //printf("x-x1<<5=%d,y2-y1=%d\n",(x-(x1<<5)),(y2-y1));
  return(y1+(((x-(x1<<5))*(y2-y1))>>5));
}

#ifdef MAIN
#include <stdio.h>
void main(void)
{
  //short x[1024],y[1024];
  int i;

  for (i=0; i<32768; i++)
    printf("1/sqrt(%d) = %d\n",i,invSqrt(i));
}
#endif
