/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/* Twiddles generated with
twa = floor(32767*exp(-sqrt(-1)*2*pi*(0:1023)/4096));
twb = floor(32767*exp(-sqrt(-1)*2*pi*2*(0:1023)/4096));
twc = floor(32767*exp(-sqrt(-1)*2*pi*3*(0:1023)/4096));
twa2 = zeros(1,2*1024);
twb2 = zeros(1,2*1024);
twc2 = zeros(1,2*1024);
twa2(1:2:end) = real(twa);
twa2(2:2:end) = imag(twa);
twb2(1:2:end) = real(twb);
twb2(2:2:end) = imag(twb);
twc2(1:2:end) = real(twc);
twc2(2:2:end) = imag(twc);
fd=fopen("twiddle_tmp.txt","w");
fprintf(fd,"static int16_t tw4096[3*1024*2] = {");
fprintf(fd,"%d,",twa2);
fprintf(fd,"%d,",twb2);
fprintf(fd,"%d,",twc2(1:(1024*2)-1));
fprintf(fd,"%d};\n",twc2(end));
fclose(fd);
*/
static int16_t tw4096[3*1024*2] = {32767,0,32766,-51,32766,-101,32766,-151,32766,-202,32766,-252,32765,-302,32765,-352,32764,-403,32763,-453,32763,-503,32762,-553,32761,-604,32760,-654,32759,-704,32758,-754,32757,-805,32755,-855,32754,-905,32753,-955,32751,-1006,32750,-1056,32748,-1106,32746,-1156,32744,-1207,32742,-1257,32740,-1307,32738,-1357,32736,-1407,32734,-1458,32732,-1508,32729,-1558,32727,-1608,32725,-1659,32722,-1709,32719,-1759,32717,-1809,32714,-1859,32711,-1909,32708,-1960,32705,-2010,32702,-2060,32699,-2110,32695,-2160,32692,-2210,32688,-2261,32685,-2311,32681,-2361,32678,-2411,32674,-2461,32670,-2511,32666,-2561,32662,-2611,32658,-2662,32654,-2712,32650,-2762,32646,-2812,32641,-2862,32637,-2912,32632,-2962,32628,-3012,32623,-3062,32618,-3112,32614,-3162,32609,-3212,32604,-3262,32599,-3312,32594,-3362,32588,-3412,32583,-3462,32578,-3512,32572,-3562,32567,-3612,32561,-3662,32556,-3712,32550,-3762,32544,-3812,32538,-3862,32532,-3912,32526,-3962,32520,-4012,32514,-4061,32508,-4111,32501,-4161,32495,-4211,32488,-4261,32482,-4311,32475,-4360,32468,-4410,32462,-4460,32455,-4510,32448,-4560,32441,-4609,32434,-4659,32426,-4709,32419,-4759,32412,-4808,32404,-4858,32397,-4908,32389,-4958,32382,-5007,32374,-5057,32366,-5107,32358,-5156,32350,-5206,32342,-5255,32334,-5305,32326,-5355,32318,-5404,32310,-5454,32301,-5503,32293,-5553,32284,-5602,32275,-5652,32267,-5701,32258,-5751,32249,-5800,32240,-5850,32231,-5899,32222,-5949,32213,-5998,32204,-6048,32194,-6097,32185,-6146,32176,-6196,32166,-6245,32156,-6294,32147,-6344,32137,-6393,32127,-6442,32117,-6492,32107,-6541,32097,-6590,32087,-6639,32077,-6689,32066,-6738,32056,-6787,32046,-6836,32035,-6885,32024,-6934,32014,-6983,32003,-7033,31992,-7082,31981,-7131,31970,-7180,31959,-7229,31948,-7278,31937,-7327,31926,-7376,31914,-7425,31903,-7474,31891,-7523,31880,-7572,31868,-7620,31856,-7669,31845,-7718,31833,-7767,31821,-7816,31809,-7865,31797,-7913,31785,-7962,31772,-8011,31760,-8060,31748,-8108,31735,-8157,31723,-8206,31710,-8254,31697,-8303,31684,-8352,31672,-8400,31659,-8449,31646,-8497,31633,-8546,31619,-8594,31606,-8643,31593,-8691,31580,-8740,31566,-8788,31553,-8837,31539,-8885,31525,-8933,31512,-8982,31498,-9030,31484,-9078,31470,-9127,31456,-9175,31442,-9223,31428,-9271,31413,-9320,31399,-9368,31385,-9416,31370,-9464,31356,-9512,31341,-9560,31326,-9608,31311,-9656,31297,-9704,31282,-9752,31267,-9800,31252,-9848,31236,-9896,31221,-9944,31206,-9992,31191,-10040,31175,-10088,31160,-10136,31144,-10183,31128,-10231,31113,-10279,31097,-10327,31081,-10374,31065,-10422,31049,-10470,31033,-10517,31017,-10565,31001,-10612,30984,-10660,30968,-10707,30951,-10755,30935,-10802,30918,-10850,30902,-10897,30885,-10945,30868,-10992,30851,-11039,30834,-11087,30817,-11134,30800,-11181,30783,-11228,30766,-11276,30748,-11323,30731,-11370,30713,-11417,30696,-11464,30678,-11511,30660,-11558,30643,-11605,30625,-11652,30607,-11699,30589,-11746,30571,-11793,30553,-11840,30535,-11887,30516,-11934,30498,-11981,30480,-12027,30461,-12074,30442,-12121,30424,-12167,30405,-12214,30386,-12261,30368,-12307,30349,-12354,30330,-12400,30311,-12447,30291,-12493,30272,-12540,30253,-12586,30234,-12633,30214,-12679,30195,-12725,30175,-12772,30156,-12818,30136,-12864,30116,-12910,30096,-12957,30076,-13003,30056,-13049,30036,-13095,30016,-13141,29996,-13187,29976,-13233,29955,-13279,29935,-13325,29915,-13371,29894,-13417,29873,-13463,29853,-13508,29832,-13554,29811,-13600,29790,-13646,29769,-13691,29748,-13737,29727,-13783,29706,-13828,29685,-13874,29663,-13919,29642,-13965,29621,-14010,29599,-14056,29577,-14101,29556,-14146,29534,-14192,29512,-14237,29490,-14282,29468,-14327,29446,-14373,29424,-14418,29402,-14463,29380,-14508,29358,-14553,29335,-14598,29313,-14643,29290,-14688,29268,-14733,29245,-14778,29222,-14823,29200,-14867,29177,-14912,29154,-14957,29131,-15002,29108,-15046,29085,-15091,29062,-15136,29038,-15180,29015,-15225,28992,-15269,28968,-15314,28945,-15358,28921,-15402,28897,-15447,28874,-15491,28850,-15535,28826,-15580,28802,-15624,28778,-15668,28754,-15712,28730,-15756,28706,-15800,28681,-15844,28657,-15888,28633,-15932,28608,-15976,28584,-16020,28559,-16064,28534,-16108,28510,-16151,28485,-16195,28460,-16239,28435,-16282,28410,-16326,28385,-16369,28360,-16413,28335,-16456,28309,-16500,28284,-16543,28259,-16587,28233,-16630,28208,-16673,28182,-16717,28156,-16760,28131,-16803,28105,-16846,28079,-16889,28053,-16932,28027,-16975,28001,-17018,27975,-17061,27948,-17104,27922,-17147,27896,-17190,27869,-17233,27843,-17275,27816,-17318,27790,-17361,27763,-17403,27736,-17446,27710,-17488,27683,-17531,27656,-17573,27629,-17616,27602,-17658,27575,-17700,27548,-17743,27520,-17785,27493,-17827,27466,-17869,27438,-17911,27411,-17953,27383,-17995,27355,-18037,27328,-18079,27300,-18121,27272,-18163,27244,-18205,27216,-18247,27188,-18288,27160,-18330,27132,-18372,27104,-18413,27076,-18455,27047,-18496,27019,-18538,26990,-18579,26962,-18621,26933,-18662,26905,-18703,26876,-18745,26847,-18786,26818,-18827,26789,-18868,26760,-18909,26731,-18950,26702,-18991,26673,-19032,26644,-19073,26615,-19114,26585,-19155,26556,-19195,26526,-19236,26497,-19277,26467,-19317,26437,-19358,26408,-19398,26378,-19439,26348,-19479,26318,-19520,26288,-19560,26258,-19600,26228,-19641,26198,-19681,26168,-19721,26137,-19761,26107,-19801,26077,-19841,26046,-19881,26016,-19921,25985,-19961,25954,-20001,25924,-20041,25893,-20080,25862,-20120,25831,-20160,25800,-20199,25769,-20239,25738,-20278,25707,-20318,25676,-20357,25645,-20397,25613,-20436,25582,-20475,25550,-20514,25519,-20554,25487,-20593,25456,-20632,25424,-20671,25392,-20710,25361,-20749,25329,-20788,25297,-20826,25265,-20865,25233,-20904,25201,-20943,25169,-20981,25136,-21020,25104,-21058,25072,-21097,25039,-21135,25007,-21174,24974,-21212,24942,-21250,24909,-21289,24877,-21327,24844,-21365,24811,-21403,24778,-21441,24745,-21479,24712,-21517,24679,-21555,24646,-21593,24613,-21630,24580,-21668,24546,-21706,24513,-21744,24480,-21781,24446,-21819,24413,-21856,24379,-21894,24346,-21931,24312,-21968,24278,-22005,24244,-22043,24211,-22080,24177,-22117,24143,-22154,24109,-22191,24075,-22228,24041,-22265,24006,-22302,23972,-22339,23938,-22375,23903,-22412,23869,-22449,23835,-22485,23800,-22522,23766,-22558,23731,-22595,23696,-22631,23661,-22667,23627,-22704,23592,-22740,23557,-22776,23522,-22812,23487,-22848,23452,-22884,23417,-22920,23382,-22956,23346,-22992,23311,-23028,23276,-23063,23240,-23099,23205,-23135,23169,-23170,23134,-23206,23098,-23241,23062,-23277,23027,-23312,22991,-23347,22955,-23383,22919,-23418,22883,-23453,22847,-23488,22811,-23523,22775,-23558,22739,-23593,22703,-23628,22666,-23662,22630,-23697,22594,-23732,22557,-23767,22521,-23801,22484,-23836,22448,-23870,22411,-23904,22374,-23939,22338,-23973,22301,-24007,22264,-24042,22227,-24076,22190,-24110,22153,-24144,22116,-24178,22079,-24212,22042,-24245,22004,-24279,21967,-24313,21930,-24347,21893,-24380,21855,-24414,21818,-24447,21780,-24481,21743,-24514,21705,-24547,21667,-24581,21629,-24614,21592,-24647,21554,-24680,21516,-24713,21478,-24746,21440,-24779,21402,-24812,21364,-24845,21326,-24878,21288,-24910,21249,-24943,21211,-24975,21173,-25008,21134,-25040,21096,-25073,21057,-25105,21019,-25137,20980,-25170,20942,-25202,20903,-25234,20864,-25266,20825,-25298,20787,-25330,20748,-25362,20709,-25393,20670,-25425,20631,-25457,20592,-25488,20553,-25520,20513,-25551,20474,-25583,20435,-25614,20396,-25646,20356,-25677,20317,-25708,20277,-25739,20238,-25770,20198,-25801,20159,-25832,20119,-25863,20079,-25894,20040,-25925,20000,-25955,19960,-25986,19920,-26017,19880,-26047,19840,-26078,19800,-26108,19760,-26138,19720,-26169,19680,-26199,19640,-26229,19599,-26259,19559,-26289,19519,-26319,19478,-26349,19438,-26379,19397,-26409,19357,-26438,19316,-26468,19276,-26498,19235,-26527,19194,-26557,19154,-26586,19113,-26616,19072,-26645,19031,-26674,18990,-26703,18949,-26732,18908,-26761,18867,-26790,18826,-26819,18785,-26848,18744,-26877,18702,-26906,18661,-26934,18620,-26963,18578,-26991,18537,-27020,18495,-27048,18454,-27077,18412,-27105,18371,-27133,18329,-27161,18287,-27189,18246,-27217,18204,-27245,18162,-27273,18120,-27301,18078,-27329,18036,-27356,17994,-27384,17952,-27412,17910,-27439,17868,-27467,17826,-27494,17784,-27521,17742,-27549,17699,-27576,17657,-27603,17615,-27630,17572,-27657,17530,-27684,17487,-27711,17445,-27737,17402,-27764,17360,-27791,17317,-27817,17274,-27844,17232,-27870,17189,-27897,17146,-27923,17103,-27949,17060,-27976,17017,-28002,16974,-28028,16931,-28054,16888,-28080,16845,-28106,16802,-28132,16759,-28157,16716,-28183,16672,-28209,16629,-28234,16586,-28260,16542,-28285,16499,-28310,16455,-28336,16412,-28361,16368,-28386,16325,-28411,16281,-28436,16238,-28461,16194,-28486,16150,-28511,16107,-28535,16063,-28560,16019,-28585,15975,-28609,15931,-28634,15887,-28658,15843,-28682,15799,-28707,15755,-28731,15711,-28755,15667,-28779,15623,-28803,15579,-28827,15534,-28851,15490,-28875,15446,-28898,15401,-28922,15357,-28946,15313,-28969,15268,-28993,15224,-29016,15179,-29039,15135,-29063,15090,-29086,15045,-29109,15001,-29132,14956,-29155,14911,-29178,14866,-29201,14822,-29223,14777,-29246,14732,-29269,14687,-29291,14642,-29314,14597,-29336,14552,-29359,14507,-29381,14462,-29403,14417,-29425,14372,-29447,14326,-29469,14281,-29491,14236,-29513,14191,-29535,14145,-29557,14100,-29578,14055,-29600,14009,-29622,13964,-29643,13918,-29664,13873,-29686,13827,-29707,13782,-29728,13736,-29749,13690,-29770,13645,-29791,13599,-29812,13553,-29833,13507,-29854,13462,-29874,13416,-29895,13370,-29916,13324,-29936,13278,-29956,13232,-29977,13186,-29997,13140,-30017,13094,-30037,13048,-30057,13002,-30077,12956,-30097,12909,-30117,12863,-30137,12817,-30157,12771,-30176,12724,-30196,12678,-30215,12632,-30235,12585,-30254,12539,-30273,12492,-30292,12446,-30312,12399,-30331,12353,-30350,12306,-30369,12260,-30387,12213,-30406,12166,-30425,12120,-30443,12073,-30462,12026,-30481,11980,-30499,11933,-30517,11886,-30536,11839,-30554,11792,-30572,11745,-30590,11698,-30608,11651,-30626,11604,-30644,11557,-30661,11510,-30679,11463,-30697,11416,-30714,11369,-30732,11322,-30749,11275,-30767,11227,-30784,11180,-30801,11133,-30818,11086,-30835,11038,-30852,10991,-30869,10944,-30886,10896,-30903,10849,-30919,10801,-30936,10754,-30952,10706,-30969,10659,-30985,10611,-31002,10564,-31018,10516,-31034,10469,-31050,10421,-31066,10373,-31082,10326,-31098,10278,-31114,10230,-31129,10182,-31145,10135,-31161,10087,-31176,10039,-31192,9991,-31207,9943,-31222,9895,-31237,9847,-31253,9799,-31268,9751,-31283,9703,-31298,9655,-31312,9607,-31327,9559,-31342,9511,-31357,9463,-31371,9415,-31386,9367,-31400,9319,-31414,9270,-31429,9222,-31443,9174,-31457,9126,-31471,9077,-31485,9029,-31499,8981,-31513,8932,-31526,8884,-31540,8836,-31554,8787,-31567,8739,-31581,8690,-31594,8642,-31607,8593,-31620,8545,-31634,8496,-31647,8448,-31660,8399,-31673,8351,-31685,8302,-31698,8253,-31711,8205,-31724,8156,-31736,8107,-31749,8059,-31761,8010,-31773,7961,-31786,7912,-31798,7864,-31810,7815,-31822,7766,-31834,7717,-31846,7668,-31857,7619,-31869,7571,-31881,7522,-31892,7473,-31904,7424,-31915,7375,-31927,7326,-31938,7277,-31949,7228,-31960,7179,-31971,7130,-31982,7081,-31993,7032,-32004,6982,-32015,6933,-32025,6884,-32036,6835,-32047,6786,-32057,6737,-32067,6688,-32078,6638,-32088,6589,-32098,6540,-32108,6491,-32118,6441,-32128,6392,-32138,6343,-32148,6293,-32157,6244,-32167,6195,-32177,6145,-32186,6096,-32195,6047,-32205,5997,-32214,5948,-32223,5898,-32232,5849,-32241,5799,-32250,5750,-32259,5700,-32268,5651,-32276,5601,-32285,5552,-32294,5502,-32302,5453,-32311,5403,-32319,5354,-32327,5304,-32335,5254,-32343,5205,-32351,5155,-32359,5106,-32367,5056,-32375,5006,-32383,4957,-32390,4907,-32398,4857,-32405,4807,-32413,4758,-32420,4708,-32427,4658,-32435,4608,-32442,4559,-32449,4509,-32456,4459,-32463,4409,-32469,4359,-32476,4310,-32483,4260,-32489,4210,-32496,4160,-32502,4110,-32509,4060,-32515,4011,-32521,3961,-32527,3911,-32533,3861,-32539,3811,-32545,3761,-32551,3711,-32557,3661,-32562,3611,-32568,3561,-32573,3511,-32579,3461,-32584,3411,-32589,3361,-32595,3311,-32600,3261,-32605,3211,-32610,3161,-32615,3111,-32619,3061,-32624,3011,-32629,2961,-32633,2911,-32638,2861,-32642,2811,-32647,2761,-32651,2711,-32655,2661,-32659,2610,-32663,2560,-32667,2510,-32671,2460,-32675,2410,-32679,2360,-32682,2310,-32686,2260,-32689,2209,-32693,2159,-32696,2109,-32700,2059,-32703,2009,-32706,1959,-32709,1908,-32712,1858,-32715,1808,-32718,1758,-32720,1708,-32723,1658,-32726,1607,-32728,1557,-32730,1507,-32733,1457,-32735,1406,-32737,1356,-32739,1306,-32741,1256,-32743,1206,-32745,1155,-32747,1105,-32749,1055,-32751,1005,-32752,954,-32754,904,-32755,854,-32756,804,-32758,753,-32759,703,-32760,653,-32761,603,-32762,552,-32763,502,-32764,452,-32764,402,-32765,351,-32766,301,-32766,251,-32767,201,-32767,150,-32767,100,-32767,50,-32767,32767,0,32766,-101,32766,-202,32765,-302,32764,-403,32763,-503,32761,-604,32759,-704,32757,-805,32754,-905,32751,-1006,32748,-1106,32744,-1207,32740,-1307,32736,-1407,32732,-1508,32727,-1608,32722,-1709,32717,-1809,32711,-1909,32705,-2010,32699,-2110,32692,-2210,32685,-2311,32678,-2411,32670,-2511,32662,-2611,32654,-2712,32646,-2812,32637,-2912,32628,-3012,32618,-3112,32609,-3212,32599,-3312,32588,-3412,32578,-3512,32567,-3612,32556,-3712,32544,-3812,32532,-3912,32520,-4012,32508,-4111,32495,-4211,32482,-4311,32468,-4410,32455,-4510,32441,-4609,32426,-4709,32412,-4808,32397,-4908,32382,-5007,32366,-5107,32350,-5206,32334,-5305,32318,-5404,32301,-5503,32284,-5602,32267,-5701,32249,-5800,32231,-5899,32213,-5998,32194,-6097,32176,-6196,32156,-6294,32137,-6393,32117,-6492,32097,-6590,32077,-6689,32056,-6787,32035,-6885,32014,-6983,31992,-7082,31970,-7180,31948,-7278,31926,-7376,31903,-7474,31880,-7572,31856,-7669,31833,-7767,31809,-7865,31785,-7962,31760,-8060,31735,-8157,31710,-8254,31684,-8352,31659,-8449,31633,-8546,31606,-8643,31580,-8740,31553,-8837,31525,-8933,31498,-9030,31470,-9127,31442,-9223,31413,-9320,31385,-9416,31356,-9512,31326,-9608,31297,-9704,31267,-9800,31236,-9896,31206,-9992,31175,-10088,31144,-10183,31113,-10279,31081,-10374,31049,-10470,31017,-10565,30984,-10660,30951,-10755,30918,-10850,30885,-10945,30851,-11039,30817,-11134,30783,-11228,30748,-11323,30713,-11417,30678,-11511,30643,-11605,30607,-11699,30571,-11793,30535,-11887,30498,-11981,30461,-12074,30424,-12167,30386,-12261,30349,-12354,30311,-12447,30272,-12540,30234,-12633,30195,-12725,30156,-12818,30116,-12910,30076,-13003,30036,-13095,29996,-13187,29955,-13279,29915,-13371,29873,-13463,29832,-13554,29790,-13646,29748,-13737,29706,-13828,29663,-13919,29621,-14010,29577,-14101,29534,-14192,29490,-14282,29446,-14373,29402,-14463,29358,-14553,29313,-14643,29268,-14733,29222,-14823,29177,-14912,29131,-15002,29085,-15091,29038,-15180,28992,-15269,28945,-15358,28897,-15447,28850,-15535,28802,-15624,28754,-15712,28706,-15800,28657,-15888,28608,-15976,28559,-16064,28510,-16151,28460,-16239,28410,-16326,28360,-16413,28309,-16500,28259,-16587,28208,-16673,28156,-16760,28105,-16846,28053,-16932,28001,-17018,27948,-17104,27896,-17190,27843,-17275,27790,-17361,27736,-17446,27683,-17531,27629,-17616,27575,-17700,27520,-17785,27466,-17869,27411,-17953,27355,-18037,27300,-18121,27244,-18205,27188,-18288,27132,-18372,27076,-18455,27019,-18538,26962,-18621,26905,-18703,26847,-18786,26789,-18868,26731,-18950,26673,-19032,26615,-19114,26556,-19195,26497,-19277,26437,-19358,26378,-19439,26318,-19520,26258,-19600,26198,-19681,26137,-19761,26077,-19841,26016,-19921,25954,-20001,25893,-20080,25831,-20160,25769,-20239,25707,-20318,25645,-20397,25582,-20475,25519,-20554,25456,-20632,25392,-20710,25329,-20788,25265,-20865,25201,-20943,25136,-21020,25072,-21097,25007,-21174,24942,-21250,24877,-21327,24811,-21403,24745,-21479,24679,-21555,24613,-21630,24546,-21706,24480,-21781,24413,-21856,24346,-21931,24278,-22005,24211,-22080,24143,-22154,24075,-22228,24006,-22302,23938,-22375,23869,-22449,23800,-22522,23731,-22595,23661,-22667,23592,-22740,23522,-22812,23452,-22884,23382,-22956,23311,-23028,23240,-23099,23169,-23170,23098,-23241,23027,-23312,22955,-23383,22883,-23453,22811,-23523,22739,-23593,22666,-23662,22594,-23732,22521,-23801,22448,-23870,22374,-23939,22301,-24007,22227,-24076,22153,-24144,22079,-24212,22004,-24279,21930,-24347,21855,-24414,21780,-24481,21705,-24547,21629,-24614,21554,-24680,21478,-24746,21402,-24812,21326,-24878,21249,-24943,21173,-25008,21096,-25073,21019,-25137,20942,-25202,20864,-25266,20787,-25330,20709,-25393,20631,-25457,20553,-25520,20474,-25583,20396,-25646,20317,-25708,20238,-25770,20159,-25832,20079,-25894,20000,-25955,19920,-26017,19840,-26078,19760,-26138,19680,-26199,19599,-26259,19519,-26319,19438,-26379,19357,-26438,19276,-26498,19194,-26557,19113,-26616,19031,-26674,18949,-26732,18867,-26790,18785,-26848,18702,-26906,18620,-26963,18537,-27020,18454,-27077,18371,-27133,18287,-27189,18204,-27245,18120,-27301,18036,-27356,17952,-27412,17868,-27467,17784,-27521,17699,-27576,17615,-27630,17530,-27684,17445,-27737,17360,-27791,17274,-27844,17189,-27897,17103,-27949,17017,-28002,16931,-28054,16845,-28106,16759,-28157,16672,-28209,16586,-28260,16499,-28310,16412,-28361,16325,-28411,16238,-28461,16150,-28511,16063,-28560,15975,-28609,15887,-28658,15799,-28707,15711,-28755,15623,-28803,15534,-28851,15446,-28898,15357,-28946,15268,-28993,15179,-29039,15090,-29086,15001,-29132,14911,-29178,14822,-29223,14732,-29269,14642,-29314,14552,-29359,14462,-29403,14372,-29447,14281,-29491,14191,-29535,14100,-29578,14009,-29622,13918,-29664,13827,-29707,13736,-29749,13645,-29791,13553,-29833,13462,-29874,13370,-29916,13278,-29956,13186,-29997,13094,-30037,13002,-30077,12909,-30117,12817,-30157,12724,-30196,12632,-30235,12539,-30273,12446,-30312,12353,-30350,12260,-30387,12166,-30425,12073,-30462,11980,-30499,11886,-30536,11792,-30572,11698,-30608,11604,-30644,11510,-30679,11416,-30714,11322,-30749,11227,-30784,11133,-30818,11038,-30852,10944,-30886,10849,-30919,10754,-30952,10659,-30985,10564,-31018,10469,-31050,10373,-31082,10278,-31114,10182,-31145,10087,-31176,9991,-31207,9895,-31237,9799,-31268,9703,-31298,9607,-31327,9511,-31357,9415,-31386,9319,-31414,9222,-31443,9126,-31471,9029,-31499,8932,-31526,8836,-31554,8739,-31581,8642,-31607,8545,-31634,8448,-31660,8351,-31685,8253,-31711,8156,-31736,8059,-31761,7961,-31786,7864,-31810,7766,-31834,7668,-31857,7571,-31881,7473,-31904,7375,-31927,7277,-31949,7179,-31971,7081,-31993,6982,-32015,6884,-32036,6786,-32057,6688,-32078,6589,-32098,6491,-32118,6392,-32138,6293,-32157,6195,-32177,6096,-32195,5997,-32214,5898,-32232,5799,-32250,5700,-32268,5601,-32285,5502,-32302,5403,-32319,5304,-32335,5205,-32351,5106,-32367,5006,-32383,4907,-32398,4807,-32413,4708,-32427,4608,-32442,4509,-32456,4409,-32469,4310,-32483,4210,-32496,4110,-32509,4011,-32521,3911,-32533,3811,-32545,3711,-32557,3611,-32568,3511,-32579,3411,-32589,3311,-32600,3211,-32610,3111,-32619,3011,-32629,2911,-32638,2811,-32647,2711,-32655,2610,-32663,2510,-32671,2410,-32679,2310,-32686,2209,-32693,2109,-32700,2009,-32706,1908,-32712,1808,-32718,1708,-32723,1607,-32728,1507,-32733,1406,-32737,1306,-32741,1206,-32745,1105,-32749,1005,-32752,904,-32755,804,-32758,703,-32760,603,-32762,502,-32764,402,-32765,301,-32766,201,-32767,100,-32767,0,-32767,-101,-32767,-202,-32767,-302,-32766,-403,-32765,-503,-32764,-604,-32762,-704,-32760,-805,-32758,-905,-32755,-1006,-32752,-1106,-32749,-1207,-32745,-1307,-32741,-1407,-32737,-1508,-32733,-1608,-32728,-1709,-32723,-1809,-32718,-1909,-32712,-2010,-32706,-2110,-32700,-2210,-32693,-2311,-32686,-2411,-32679,-2511,-32671,-2611,-32663,-2712,-32655,-2812,-32647,-2912,-32638,-3012,-32629,-3112,-32619,-3212,-32610,-3312,-32600,-3412,-32589,-3512,-32579,-3612,-32568,-3712,-32557,-3812,-32545,-3912,-32533,-4012,-32521,-4111,-32509,-4211,-32496,-4311,-32483,-4410,-32469,-4510,-32456,-4609,-32442,-4709,-32427,-4808,-32413,-4908,-32398,-5007,-32383,-5107,-32367,-5206,-32351,-5305,-32335,-5404,-32319,-5503,-32302,-5602,-32285,-5701,-32268,-5800,-32250,-5899,-32232,-5998,-32214,-6097,-32195,-6196,-32177,-6294,-32157,-6393,-32138,-6492,-32118,-6590,-32098,-6689,-32078,-6787,-32057,-6885,-32036,-6983,-32015,-7082,-31993,-7180,-31971,-7278,-31949,-7376,-31927,-7474,-31904,-7572,-31881,-7669,-31857,-7767,-31834,-7865,-31810,-7962,-31786,-8060,-31761,-8157,-31736,-8254,-31711,-8352,-31685,-8449,-31660,-8546,-31634,-8643,-31607,-8740,-31581,-8837,-31554,-8933,-31526,-9030,-31499,-9127,-31471,-9223,-31443,-9320,-31414,-9416,-31386,-9512,-31357,-9608,-31327,-9704,-31298,-9800,-31268,-9896,-31237,-9992,-31207,-10088,-31176,-10183,-31145,-10279,-31114,-10374,-31082,-10470,-31050,-10565,-31018,-10660,-30985,-10755,-30952,-10850,-30919,-10945,-30886,-11039,-30852,-11134,-30818,-11228,-30784,-11323,-30749,-11417,-30714,-11511,-30679,-11605,-30644,-11699,-30608,-11793,-30572,-11887,-30536,-11981,-30499,-12074,-30462,-12167,-30425,-12261,-30387,-12354,-30350,-12447,-30312,-12540,-30273,-12633,-30235,-12725,-30196,-12818,-30157,-12910,-30117,-13003,-30077,-13095,-30037,-13187,-29997,-13279,-29956,-13371,-29916,-13463,-29874,-13554,-29833,-13646,-29791,-13737,-29749,-13828,-29707,-13919,-29664,-14010,-29622,-14101,-29578,-14192,-29535,-14282,-29491,-14373,-29447,-14463,-29403,-14553,-29359,-14643,-29314,-14733,-29269,-14823,-29223,-14912,-29178,-15002,-29132,-15091,-29086,-15180,-29039,-15269,-28993,-15358,-28946,-15447,-28898,-15535,-28851,-15624,-28803,-15712,-28755,-15800,-28707,-15888,-28658,-15976,-28609,-16064,-28560,-16151,-28511,-16239,-28461,-16326,-28411,-16413,-28361,-16500,-28310,-16587,-28260,-16673,-28209,-16760,-28157,-16846,-28106,-16932,-28054,-17018,-28002,-17104,-27949,-17190,-27897,-17275,-27844,-17361,-27791,-17446,-27737,-17531,-27684,-17616,-27630,-17700,-27576,-17785,-27521,-17869,-27467,-17953,-27412,-18037,-27356,-18121,-27301,-18205,-27245,-18288,-27189,-18372,-27133,-18455,-27077,-18538,-27020,-18621,-26963,-18703,-26906,-18786,-26848,-18868,-26790,-18950,-26732,-19032,-26674,-19114,-26616,-19195,-26557,-19277,-26498,-19358,-26438,-19439,-26379,-19520,-26319,-19600,-26259,-19681,-26199,-19761,-26138,-19841,-26078,-19921,-26017,-20001,-25955,-20080,-25894,-20160,-25832,-20239,-25770,-20318,-25708,-20397,-25646,-20475,-25583,-20554,-25520,-20632,-25457,-20710,-25393,-20788,-25330,-20865,-25266,-20943,-25202,-21020,-25137,-21097,-25073,-21174,-25008,-21250,-24943,-21327,-24878,-21403,-24812,-21479,-24746,-21555,-24680,-21630,-24614,-21706,-24547,-21781,-24481,-21856,-24414,-21931,-24347,-22005,-24279,-22080,-24212,-22154,-24144,-22228,-24076,-22302,-24007,-22375,-23939,-22449,-23870,-22522,-23801,-22595,-23732,-22667,-23662,-22740,-23593,-22812,-23523,-22884,-23453,-22956,-23383,-23028,-23312,-23099,-23241,-23170,-23170,-23241,-23099,-23312,-23028,-23383,-22956,-23453,-22884,-23523,-22812,-23593,-22740,-23662,-22667,-23732,-22595,-23801,-22522,-23870,-22449,-23939,-22375,-24007,-22302,-24076,-22228,-24144,-22154,-24212,-22080,-24279,-22005,-24347,-21931,-24414,-21856,-24481,-21781,-24547,-21706,-24614,-21630,-24680,-21555,-24746,-21479,-24812,-21403,-24878,-21327,-24943,-21250,-25008,-21174,-25073,-21097,-25137,-21020,-25202,-20943,-25266,-20865,-25330,-20788,-25393,-20710,-25457,-20632,-25520,-20554,-25583,-20475,-25646,-20397,-25708,-20318,-25770,-20239,-25832,-20160,-25894,-20080,-25955,-20001,-26017,-19921,-26078,-19841,-26138,-19761,-26199,-19681,-26259,-19600,-26319,-19520,-26379,-19439,-26438,-19358,-26498,-19277,-26557,-19195,-26616,-19114,-26674,-19032,-26732,-18950,-26790,-18868,-26848,-18786,-26906,-18703,-26963,-18621,-27020,-18538,-27077,-18455,-27133,-18372,-27189,-18288,-27245,-18205,-27301,-18121,-27356,-18037,-27412,-17953,-27467,-17869,-27521,-17785,-27576,-17700,-27630,-17616,-27684,-17531,-27737,-17446,-27791,-17361,-27844,-17275,-27897,-17190,-27949,-17104,-28002,-17018,-28054,-16932,-28106,-16846,-28157,-16760,-28209,-16673,-28260,-16587,-28310,-16500,-28361,-16413,-28411,-16326,-28461,-16239,-28511,-16151,-28560,-16064,-28609,-15976,-28658,-15888,-28707,-15800,-28755,-15712,-28803,-15624,-28851,-15535,-28898,-15447,-28946,-15358,-28993,-15269,-29039,-15180,-29086,-15091,-29132,-15002,-29178,-14912,-29223,-14823,-29269,-14733,-29314,-14643,-29359,-14553,-29403,-14463,-29447,-14373,-29491,-14282,-29535,-14192,-29578,-14101,-29622,-14010,-29664,-13919,-29707,-13828,-29749,-13737,-29791,-13646,-29833,-13554,-29874,-13463,-29916,-13371,-29956,-13279,-29997,-13187,-30037,-13095,-30077,-13003,-30117,-12910,-30157,-12818,-30196,-12725,-30235,-12633,-30273,-12540,-30312,-12447,-30350,-12354,-30387,-12261,-30425,-12167,-30462,-12074,-30499,-11981,-30536,-11887,-30572,-11793,-30608,-11699,-30644,-11605,-30679,-11511,-30714,-11417,-30749,-11323,-30784,-11228,-30818,-11134,-30852,-11039,-30886,-10945,-30919,-10850,-30952,-10755,-30985,-10660,-31018,-10565,-31050,-10470,-31082,-10374,-31114,-10279,-31145,-10183,-31176,-10088,-31207,-9992,-31237,-9896,-31268,-9800,-31298,-9704,-31327,-9608,-31357,-9512,-31386,-9416,-31414,-9320,-31443,-9223,-31471,-9127,-31499,-9030,-31526,-8933,-31554,-8837,-31581,-8740,-31607,-8643,-31634,-8546,-31660,-8449,-31685,-8352,-31711,-8254,-31736,-8157,-31761,-8060,-31786,-7962,-31810,-7865,-31834,-7767,-31857,-7669,-31881,-7572,-31904,-7474,-31927,-7376,-31949,-7278,-31971,-7180,-31993,-7082,-32015,-6983,-32036,-6885,-32057,-6787,-32078,-6689,-32098,-6590,-32118,-6492,-32138,-6393,-32157,-6294,-32177,-6196,-32195,-6097,-32214,-5998,-32232,-5899,-32250,-5800,-32268,-5701,-32285,-5602,-32302,-5503,-32319,-5404,-32335,-5305,-32351,-5206,-32367,-5107,-32383,-5007,-32398,-4908,-32413,-4808,-32427,-4709,-32442,-4609,-32456,-4510,-32469,-4410,-32483,-4311,-32496,-4211,-32509,-4111,-32521,-4012,-32533,-3912,-32545,-3812,-32557,-3712,-32568,-3612,-32579,-3512,-32589,-3412,-32600,-3312,-32610,-3212,-32619,-3112,-32629,-3012,-32638,-2912,-32647,-2812,-32655,-2712,-32663,-2611,-32671,-2511,-32679,-2411,-32686,-2311,-32693,-2210,-32700,-2110,-32706,-2010,-32712,-1909,-32718,-1809,-32723,-1709,-32728,-1608,-32733,-1508,-32737,-1407,-32741,-1307,-32745,-1207,-32749,-1106,-32752,-1006,-32755,-905,-32758,-805,-32760,-704,-32762,-604,-32764,-503,-32765,-403,-32766,-302,-32767,-202,-32767,-101,32767,0,32766,-151,32765,-302,32763,-453,32761,-604,32758,-754,32754,-905,32750,-1056,32744,-1207,32738,-1357,32732,-1508,32725,-1659,32717,-1809,32708,-1960,32699,-2110,32688,-2261,32678,-2411,32666,-2561,32654,-2712,32641,-2862,32628,-3012,32614,-3162,32599,-3312,32583,-3462,32567,-3612,32550,-3762,32532,-3912,32514,-4061,32495,-4211,32475,-4360,32455,-4510,32434,-4659,32412,-4808,32389,-4958,32366,-5107,32342,-5255,32318,-5404,32293,-5553,32267,-5701,32240,-5850,32213,-5998,32185,-6146,32156,-6294,32127,-6442,32097,-6590,32066,-6738,32035,-6885,32003,-7033,31970,-7180,31937,-7327,31903,-7474,31868,-7620,31833,-7767,31797,-7913,31760,-8060,31723,-8206,31684,-8352,31646,-8497,31606,-8643,31566,-8788,31525,-8933,31484,-9078,31442,-9223,31399,-9368,31356,-9512,31311,-9656,31267,-9800,31221,-9944,31175,-10088,31128,-10231,31081,-10374,31033,-10517,30984,-10660,30935,-10802,30885,-10945,30834,-11087,30783,-11228,30731,-11370,30678,-11511,30625,-11652,30571,-11793,30516,-11934,30461,-12074,30405,-12214,30349,-12354,30291,-12493,30234,-12633,30175,-12772,30116,-12910,30056,-13049,29996,-13187,29935,-13325,29873,-13463,29811,-13600,29748,-13737,29685,-13874,29621,-14010,29556,-14146,29490,-14282,29424,-14418,29358,-14553,29290,-14688,29222,-14823,29154,-14957,29085,-15091,29015,-15225,28945,-15358,28874,-15491,28802,-15624,28730,-15756,28657,-15888,28584,-16020,28510,-16151,28435,-16282,28360,-16413,28284,-16543,28208,-16673,28131,-16803,28053,-16932,27975,-17061,27896,-17190,27816,-17318,27736,-17446,27656,-17573,27575,-17700,27493,-17827,27411,-17953,27328,-18079,27244,-18205,27160,-18330,27076,-18455,26990,-18579,26905,-18703,26818,-18827,26731,-18950,26644,-19073,26556,-19195,26467,-19317,26378,-19439,26288,-19560,26198,-19681,26107,-19801,26016,-19921,25924,-20041,25831,-20160,25738,-20278,25645,-20397,25550,-20514,25456,-20632,25361,-20749,25265,-20865,25169,-20981,25072,-21097,24974,-21212,24877,-21327,24778,-21441,24679,-21555,24580,-21668,24480,-21781,24379,-21894,24278,-22005,24177,-22117,24075,-22228,23972,-22339,23869,-22449,23766,-22558,23661,-22667,23557,-22776,23452,-22884,23346,-22992,23240,-23099,23134,-23206,23027,-23312,22919,-23418,22811,-23523,22703,-23628,22594,-23732,22484,-23836,22374,-23939,22264,-24042,22153,-24144,22042,-24245,21930,-24347,21818,-24447,21705,-24547,21592,-24647,21478,-24746,21364,-24845,21249,-24943,21134,-25040,21019,-25137,20903,-25234,20787,-25330,20670,-25425,20553,-25520,20435,-25614,20317,-25708,20198,-25801,20079,-25894,19960,-25986,19840,-26078,19720,-26169,19599,-26259,19478,-26349,19357,-26438,19235,-26527,19113,-26616,18990,-26703,18867,-26790,18744,-26877,18620,-26963,18495,-27048,18371,-27133,18246,-27217,18120,-27301,17994,-27384,17868,-27467,17742,-27549,17615,-27630,17487,-27711,17360,-27791,17232,-27870,17103,-27949,16974,-28028,16845,-28106,16716,-28183,16586,-28260,16455,-28336,16325,-28411,16194,-28486,16063,-28560,15931,-28634,15799,-28707,15667,-28779,15534,-28851,15401,-28922,15268,-28993,15135,-29063,15001,-29132,14866,-29201,14732,-29269,14597,-29336,14462,-29403,14326,-29469,14191,-29535,14055,-29600,13918,-29664,13782,-29728,13645,-29791,13507,-29854,13370,-29916,13232,-29977,13094,-30037,12956,-30097,12817,-30157,12678,-30215,12539,-30273,12399,-30331,12260,-30387,12120,-30443,11980,-30499,11839,-30554,11698,-30608,11557,-30661,11416,-30714,11275,-30767,11133,-30818,10991,-30869,10849,-30919,10706,-30969,10564,-31018,10421,-31066,10278,-31114,10135,-31161,9991,-31207,9847,-31253,9703,-31298,9559,-31342,9415,-31386,9270,-31429,9126,-31471,8981,-31513,8836,-31554,8690,-31594,8545,-31634,8399,-31673,8253,-31711,8107,-31749,7961,-31786,7815,-31822,7668,-31857,7522,-31892,7375,-31927,7228,-31960,7081,-31993,6933,-32025,6786,-32057,6638,-32088,6491,-32118,6343,-32148,6195,-32177,6047,-32205,5898,-32232,5750,-32259,5601,-32285,5453,-32311,5304,-32335,5155,-32359,5006,-32383,4857,-32405,4708,-32427,4559,-32449,4409,-32469,4260,-32489,4110,-32509,3961,-32527,3811,-32545,3661,-32562,3511,-32579,3361,-32595,3211,-32610,3061,-32624,2911,-32638,2761,-32651,2610,-32663,2460,-32675,2310,-32686,2159,-32696,2009,-32706,1858,-32715,1708,-32723,1557,-32730,1406,-32737,1256,-32743,1105,-32749,954,-32754,804,-32758,653,-32761,502,-32764,351,-32766,201,-32767,50,-32767,-101,-32767,-252,-32767,-403,-32765,-553,-32763,-704,-32760,-855,-32756,-1006,-32752,-1156,-32747,-1307,-32741,-1458,-32735,-1608,-32728,-1759,-32720,-1909,-32712,-2060,-32703,-2210,-32693,-2361,-32682,-2511,-32671,-2662,-32659,-2812,-32647,-2962,-32633,-3112,-32619,-3262,-32605,-3412,-32589,-3562,-32573,-3712,-32557,-3862,-32539,-4012,-32521,-4161,-32502,-4311,-32483,-4460,-32463,-4609,-32442,-4759,-32420,-4908,-32398,-5057,-32375,-5206,-32351,-5355,-32327,-5503,-32302,-5652,-32276,-5800,-32250,-5949,-32223,-6097,-32195,-6245,-32167,-6393,-32138,-6541,-32108,-6689,-32078,-6836,-32047,-6983,-32015,-7131,-31982,-7278,-31949,-7425,-31915,-7572,-31881,-7718,-31846,-7865,-31810,-8011,-31773,-8157,-31736,-8303,-31698,-8449,-31660,-8594,-31620,-8740,-31581,-8885,-31540,-9030,-31499,-9175,-31457,-9320,-31414,-9464,-31371,-9608,-31327,-9752,-31283,-9896,-31237,-10040,-31192,-10183,-31145,-10327,-31098,-10470,-31050,-10612,-31002,-10755,-30952,-10897,-30903,-11039,-30852,-11181,-30801,-11323,-30749,-11464,-30697,-11605,-30644,-11746,-30590,-11887,-30536,-12027,-30481,-12167,-30425,-12307,-30369,-12447,-30312,-12586,-30254,-12725,-30196,-12864,-30137,-13003,-30077,-13141,-30017,-13279,-29956,-13417,-29895,-13554,-29833,-13691,-29770,-13828,-29707,-13965,-29643,-14101,-29578,-14237,-29513,-14373,-29447,-14508,-29381,-14643,-29314,-14778,-29246,-14912,-29178,-15046,-29109,-15180,-29039,-15314,-28969,-15447,-28898,-15580,-28827,-15712,-28755,-15844,-28682,-15976,-28609,-16108,-28535,-16239,-28461,-16369,-28386,-16500,-28310,-16630,-28234,-16760,-28157,-16889,-28080,-17018,-28002,-17147,-27923,-17275,-27844,-17403,-27764,-17531,-27684,-17658,-27603,-17785,-27521,-17911,-27439,-18037,-27356,-18163,-27273,-18288,-27189,-18413,-27105,-18538,-27020,-18662,-26934,-18786,-26848,-18909,-26761,-19032,-26674,-19155,-26586,-19277,-26498,-19398,-26409,-19520,-26319,-19641,-26229,-19761,-26138,-19881,-26047,-20001,-25955,-20120,-25863,-20239,-25770,-20357,-25677,-20475,-25583,-20593,-25488,-20710,-25393,-20826,-25298,-20943,-25202,-21058,-25105,-21174,-25008,-21289,-24910,-21403,-24812,-21517,-24713,-21630,-24614,-21744,-24514,-21856,-24414,-21968,-24313,-22080,-24212,-22191,-24110,-22302,-24007,-22412,-23904,-22522,-23801,-22631,-23697,-22740,-23593,-22848,-23488,-22956,-23383,-23063,-23277,-23170,-23170,-23277,-23063,-23383,-22956,-23488,-22848,-23593,-22740,-23697,-22631,-23801,-22522,-23904,-22412,-24007,-22302,-24110,-22191,-24212,-22080,-24313,-21968,-24414,-21856,-24514,-21744,-24614,-21630,-24713,-21517,-24812,-21403,-24910,-21289,-25008,-21174,-25105,-21058,-25202,-20943,-25298,-20826,-25393,-20710,-25488,-20593,-25583,-20475,-25677,-20357,-25770,-20239,-25863,-20120,-25955,-20001,-26047,-19881,-26138,-19761,-26229,-19641,-26319,-19520,-26409,-19398,-26498,-19277,-26586,-19155,-26674,-19032,-26761,-18909,-26848,-18786,-26934,-18662,-27020,-18538,-27105,-18413,-27189,-18288,-27273,-18163,-27356,-18037,-27439,-17911,-27521,-17785,-27603,-17658,-27684,-17531,-27764,-17403,-27844,-17275,-27923,-17147,-28002,-17018,-28080,-16889,-28157,-16760,-28234,-16630,-28310,-16500,-28386,-16369,-28461,-16239,-28535,-16108,-28609,-15976,-28682,-15844,-28755,-15712,-28827,-15580,-28898,-15447,-28969,-15314,-29039,-15180,-29109,-15046,-29178,-14912,-29246,-14778,-29314,-14643,-29381,-14508,-29447,-14373,-29513,-14237,-29578,-14101,-29643,-13965,-29707,-13828,-29770,-13691,-29833,-13554,-29895,-13417,-29956,-13279,-30017,-13141,-30077,-13003,-30137,-12864,-30196,-12725,-30254,-12586,-30312,-12447,-30369,-12307,-30425,-12167,-30481,-12027,-30536,-11887,-30590,-11746,-30644,-11605,-30697,-11464,-30749,-11323,-30801,-11181,-30852,-11039,-30903,-10897,-30952,-10755,-31002,-10612,-31050,-10470,-31098,-10327,-31145,-10183,-31192,-10040,-31237,-9896,-31283,-9752,-31327,-9608,-31371,-9464,-31414,-9320,-31457,-9175,-31499,-9030,-31540,-8885,-31581,-8740,-31620,-8594,-31660,-8449,-31698,-8303,-31736,-8157,-31773,-8011,-31810,-7865,-31846,-7718,-31881,-7572,-31915,-7425,-31949,-7278,-31982,-7131,-32015,-6983,-32047,-6836,-32078,-6689,-32108,-6541,-32138,-6393,-32167,-6245,-32195,-6097,-32223,-5949,-32250,-5800,-32276,-5652,-32302,-5503,-32327,-5355,-32351,-5206,-32375,-5057,-32398,-4908,-32420,-4759,-32442,-4609,-32463,-4460,-32483,-4311,-32502,-4161,-32521,-4012,-32539,-3862,-32557,-3712,-32573,-3562,-32589,-3412,-32605,-3262,-32619,-3112,-32633,-2962,-32647,-2812,-32659,-2662,-32671,-2511,-32682,-2361,-32693,-2210,-32703,-2060,-32712,-1909,-32720,-1759,-32728,-1608,-32735,-1458,-32741,-1307,-32747,-1156,-32752,-1006,-32756,-855,-32760,-704,-32763,-553,-32765,-403,-32767,-252,-32767,-101,-32767,50,-32767,201,-32766,351,-32764,502,-32761,653,-32758,804,-32754,954,-32749,1105,-32743,1256,-32737,1406,-32730,1557,-32723,1708,-32715,1858,-32706,2009,-32696,2159,-32686,2310,-32675,2460,-32663,2610,-32651,2761,-32638,2911,-32624,3061,-32610,3211,-32595,3361,-32579,3511,-32562,3661,-32545,3811,-32527,3961,-32509,4110,-32489,4260,-32469,4409,-32449,4559,-32427,4708,-32405,4857,-32383,5006,-32359,5155,-32335,5304,-32311,5453,-32285,5601,-32259,5750,-32232,5898,-32205,6047,-32177,6195,-32148,6343,-32118,6491,-32088,6638,-32057,6786,-32025,6933,-31993,7081,-31960,7228,-31927,7375,-31892,7522,-31857,7668,-31822,7815,-31786,7961,-31749,8107,-31711,8253,-31673,8399,-31634,8545,-31594,8690,-31554,8836,-31513,8981,-31471,9126,-31429,9270,-31386,9415,-31342,9559,-31298,9703,-31253,9847,-31207,9991,-31161,10135,-31114,10278,-31066,10421,-31018,10564,-30969,10706,-30919,10849,-30869,10991,-30818,11133,-30767,11275,-30714,11416,-30661,11557,-30608,11698,-30554,11839,-30499,11980,-30443,12120,-30387,12260,-30331,12399,-30273,12539,-30215,12678,-30157,12817,-30097,12956,-30037,13094,-29977,13232,-29916,13370,-29854,13507,-29791,13645,-29728,13782,-29664,13918,-29600,14055,-29535,14191,-29469,14326,-29403,14462,-29336,14597,-29269,14732,-29201,14866,-29132,15001,-29063,15135,-28993,15268,-28922,15401,-28851,15534,-28779,15667,-28707,15799,-28634,15931,-28560,16063,-28486,16194,-28411,16325,-28336,16455,-28260,16586,-28183,16716,-28106,16845,-28028,16974,-27949,17103,-27870,17232,-27791,17360,-27711,17487,-27630,17615,-27549,17742,-27467,17868,-27384,17994,-27301,18120,-27217,18246,-27133,18371,-27048,18495,-26963,18620,-26877,18744,-26790,18867,-26703,18990,-26616,19113,-26527,19235,-26438,19357,-26349,19478,-26259,19599,-26169,19720,-26078,19840,-25986,19960,-25894,20079,-25801,20198,-25708,20317,-25614,20435,-25520,20553,-25425,20670,-25330,20787,-25234,20903,-25137,21019,-25040,21134,-24943,21249,-24845,21364,-24746,21478,-24647,21592,-24547,21705,-24447,21818,-24347,21930,-24245,22042,-24144,22153,-24042,22264,-23939,22374,-23836,22484,-23732,22594,-23628,22703,-23523,22811,-23418,22919,-23312,23027,-23206,23134,-23099,23240,-22992,23346,-22884,23452,-22776,23557,-22667,23661,-22558,23766,-22449,23869,-22339,23972,-22228,24075,-22117,24177,-22005,24278,-21894,24379,-21781,24480,-21668,24580,-21555,24679,-21441,24778,-21327,24877,-21212,24974,-21097,25072,-20981,25169,-20865,25265,-20749,25361,-20632,25456,-20514,25550,-20397,25645,-20278,25738,-20160,25831,-20041,25924,-19921,26016,-19801,26107,-19681,26198,-19560,26288,-19439,26378,-19317,26467,-19195,26556,-19073,26644,-18950,26731,-18827,26818,-18703,26905,-18579,26990,-18455,27076,-18330,27160,-18205,27244,-18079,27328,-17953,27411,-17827,27493,-17700,27575,-17573,27656,-17446,27736,-17318,27816,-17190,27896,-17061,27975,-16932,28053,-16803,28131,-16673,28208,-16543,28284,-16413,28360,-16282,28435,-16151,28510,-16020,28584,-15888,28657,-15756,28730,-15624,28802,-15491,28874,-15358,28945,-15225,29015,-15091,29085,-14957,29154,-14823,29222,-14688,29290,-14553,29358,-14418,29424,-14282,29490,-14146,29556,-14010,29621,-13874,29685,-13737,29748,-13600,29811,-13463,29873,-13325,29935,-13187,29996,-13049,30056,-12910,30116,-12772,30175,-12633,30234,-12493,30291,-12354,30349,-12214,30405,-12074,30461,-11934,30516,-11793,30571,-11652,30625,-11511,30678,-11370,30731,-11228,30783,-11087,30834,-10945,30885,-10802,30935,-10660,30984,-10517,31033,-10374,31081,-10231,31128,-10088,31175,-9944,31221,-9800,31267,-9656,31311,-9512,31356,-9368,31399,-9223,31442,-9078,31484,-8933,31525,-8788,31566,-8643,31606,-8497,31646,-8352,31684,-8206,31723,-8060,31760,-7913,31797,-7767,31833,-7620,31868,-7474,31903,-7327,31937,-7180,31970,-7033,32003,-6885,32035,-6738,32066,-6590,32097,-6442,32127,-6294,32156,-6146,32185,-5998,32213,-5850,32240,-5701,32267,-5553,32293,-5404,32318,-5255,32342,-5107,32366,-4958,32389,-4808,32412,-4659,32434,-4510,32455,-4360,32475,-4211,32495,-4061,32514,-3912,32532,-3762,32550,-3612,32567,-3462,32583,-3312,32599,-3162,32614,-3012,32628,-2862,32641,-2712,32654,-2561,32666,-2411,32678,-2261,32688,-2110,32699,-1960,32708,-1809,32717,-1659,32725,-1508,32732,-1357,32738,-1207,32744,-1056,32750,-905,32754,-754,32758,-604,32761,-453,32763,-302,32765,-151,32766};
