/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/*!\file Gen_shift_value.h
 * \brief Defines the shift values for LDPC encoder
 * \author Florian Kaltenberger, Raymond Knopp, Kien le Trung (Eurecom)
 * \email openair_tech@eurecom.fr
 * \date 27-03-2018
 * \version 1.0
 * \note
 * \warning
 */

static const short no_shift_values_BG1[1012]= {4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,4,4,4,3,4,4,3,3,4,4,4,4,4,3,4,4,3,4,4,4,4,6,5,4,4,5,4,5,5,5,4,5,4,4,5,5,4,4,5,5,4,5,4,5,4,3,4,4,3,4,4,4,3,4,4,4,4,4,3,4,4,4,3,4,4,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,4,3,4,3,3,3,3,3,3,3,3,4,3,3,3,4,3,3,3,3,4,1,0,0,0,0,0,1,0,0,0,1,1,0,1,0,0,0,1,1,0,1,0,1,1,0,0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,11,9,7,8,8,7,8,8,8,7,8,7,8,8,8,7,8,8,8,8,8,8,1,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,1,1,0,1,0,0,1,1,0,1,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,10,8,7,7,6,7,7,6,6,7,7,7,8,7,6,7,8,6,7,7,7,8,1,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,1,0,0,0,6,4,4,5,3,4,4,4,3,4,4,4,4,4,3,4,4,3,4,4,5,4,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,0,1,6,5,3,4,4,3,4,4,4,3,5,4,4,5,4,3,4,4,5,3,4,4,4,4,3,4,3,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,5,3,3,4,3,3,3,3,3,4,3,4,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,5,3,3,4,4,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,5,5,3,4,4,3,4,4,4,3,4,4,4,4,5,3,4,4,5,3,4,4,7,5,4,4,5,4,5,5,5,4,6,4,4,6,5,4,4,5,5,4,5,4,9,8,6,7,7,6,7,8,7,6,7,7,7,7,7,6,7,7,7,6,7,7,7,5,4,4,5,4,5,5,5,4,5,4,5,5,6,4,4,5,5,4,5,4,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,4,4,3,3,3,3,4,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,5,5,4,4,3,4,4,3,3,4,4,4,4,5,3,4,4,3,4,4,4,4,1,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,7,5,4,4,6,4,5,5,5,4,5,4,4,5,5,4,4,5,5,4,5,4,5,5,3,4,4,3,4,4,4,3,4,4,4,4,4,3,5,4,5,3,4,4,5,3,3,3,3,3,3,4,3,4,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0};
static const short pointer_shift_values_BG1[1012]= {0,4,7,10,13,16,19,22,25,28,31,34,37,40,43,46,49,52,55,58,61,64,67,72,76,80,84,87,91,95,98,101,105,109,113,117,121,124,128,132,135,139,143,147,151,157,162,166,170,175,179,184,189,194,198,203,207,211,216,221,225,229,234,239,243,248,252,257,261,264,268,272,275,279,283,287,290,294,298,302,306,310,313,317,321,325,328,332,336,337,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,338,343,347,350,354,357,360,363,366,369,372,375,378,382,385,388,391,395,398,401,404,407,411,412,412,412,412,412,412,413,413,413,413,414,415,415,416,416,416,416,417,418,418,419,419,420,421,421,421,422,422,422,423,424,424,424,424,424,424,425,425,425,425,425,425,425,425,436,445,452,460,468,475,483,491,499,506,514,521,529,537,545,552,560,568,576,584,592,600,601,602,602,602,602,602,602,602,602,602,603,604,604,605,605,605,605,606,607,607,608,608,608,609,610,610,611,611,611,612,613,613,613,613,613,613,614,614,614,614,614,614,614,614,624,632,639,646,652,659,666,672,678,685,692,699,707,714,720,727,735,741,748,755,762,770,771,772,772,772,772,772,772,772,772,772,773,774,774,775,775,775,775,775,776,776,776,776,782,786,790,795,798,802,806,810,813,817,821,825,829,833,836,840,844,847,851,855,860,864,865,865,865,865,865,865,865,865,865,865,865,865,866,866,866,867,868,869,869,869,869,870,876,881,884,888,892,895,899,903,907,910,915,919,923,928,932,935,939,943,948,951,955,959,963,967,970,974,977,980,983,986,989,992,995,999,1002,1005,1008,1011,1014,1017,1020,1023,1027,1030,1031,1031,1031,1031,1031,1031,1031,1031,1031,1031,1031,1031,1031,1031,1032,1032,1033,1034,1034,1034,1034,1035,1035,1036,1036,1036,1036,1036,1036,1036,1036,1036,1036,1036,1037,1038,1038,1038,1038,1038,1039,1040,1040,1040,1041,1042,1042,1042,1042,1042,1042,1043,1044,1044,1045,1045,1045,1045,1045,1045,1045,1045,1045,1045,1045,1045,1050,1053,1056,1060,1063,1066,1069,1072,1075,1079,1082,1086,1089,1092,1095,1098,1101,1104,1107,1110,1113,1116,1116,1117,1117,1117,1117,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1119,1119,1119,1119,1120,1121,1122,1122,1122,1122,1122,1122,1122,1122,1122,1122,1122,1122,1123,1124,1124,1124,1124,1125,1125,1125,1125,1125,1125,1126,1127,1127,1127,1127,1127,1127,1127,1127,1128,1128,1128,1128,1128,1128,1128,1128,1129,1129,1129,1129,1134,1137,1140,1144,1148,1151,1154,1157,1160,1163,1166,1170,1173,1176,1179,1182,1185,1188,1191,1194,1197,1200,1200,1201,1201,1201,1201,1201,1202,1203,1203,1203,1203,1203,1203,1203,1204,1204,1204,1204,1204,1204,1204,1204,1205,1205,1206,1206,1207,1207,1207,1207,1207,1207,1207,1207,1207,1207,1207,1208,1208,1208,1208,1208,1208,1208,1208,1209,1209,1209,1209,1209,1210,1210,1211,1211,1211,1211,1211,1211,1211,1211,1211,1211,1211,1211,1211,1211,1212,1212,1212,1212,1213,1213,1213,1213,1213,1213,1213,1213,1213,1213,1213,1213,1213,1213,1213,1214,1214,1215,1220,1225,1228,1232,1236,1239,1243,1247,1251,1254,1258,1262,1266,1270,1275,1278,1282,1286,1291,1294,1298,1302,1309,1314,1318,1322,1327,1331,1336,1341,1346,1350,1356,1360,1364,1370,1375,1379,1383,1388,1393,1397,1402,1406,1415,1423,1429,1436,1443,1449,1456,1464,1471,1477,1484,1491,1498,1505,1512,1518,1525,1532,1539,1545,1552,1559,1566,1571,1575,1579,1584,1588,1593,1598,1603,1607,1612,1616,1621,1626,1632,1636,1640,1645,1650,1654,1659,1663,1663,1664,1665,1665,1665,1665,1665,1665,1665,1665,1665,1666,1666,1666,1666,1666,1666,1666,1666,1666,1666,1667,1668,1668,1668,1668,1668,1668,1668,1669,1669,1669,1669,1669,1669,1669,1669,1670,1670,1671,1671,1671,1671,1671,1675,1679,1682,1685,1688,1691,1695,1698,1701,1704,1707,1710,1714,1717,1720,1723,1726,1729,1732,1735,1738,1741,1742,1742,1742,1742,1742,1742,1742,1742,1742,1742,1742,1742,1742,1742,1743,1744,1744,1744,1745,1745,1745,1745,1750,1755,1759,1763,1766,1770,1774,1777,1780,1784,1788,1792,1796,1801,1804,1808,1812,1815,1819,1823,1827,1831,1832,1832,1832,1832,1832,1832,1832,1832,1832,1833,1834,1834,1835,1835,1835,1835,1835,1835,1835,1835,1835,1835,1835,1836,1836,1837,1837,1837,1837,1838,1838,1838,1838,1838,1838,1838,1838,1838,1838,1838,1838,1839,1839,1839,1840,1840,1840,1840,1840,1840,1840,1840,1841,1841,1841,1841,1841,1841,1841,1841,1841,1842,1842,1842,1842,1842,1842,1843,1843,1844,1844,1844,1844,1844,1844,1845,1845,1845,1845,1845,1845,1845,1845,1845,1846,1846,1846,1846,1853,1858,1862,1866,1872,1876,1881,1886,1891,1895,1900,1904,1908,1913,1918,1922,1926,1931,1936,1940,1945,1949,1954,1959,1962,1966,1970,1973,1977,1981,1985,1988,1992,1996,2000,2004,2008,2011,2016,2020,2025,2028,2032,2036,2041,2044,2047,2050,2053,2056,2059,2063,2066,2070,2073,2076,2079,2082,2085,2088,2091,2094,2097,2100,2103,2106,2106,2107,2107,2107,2107,2107,2108,2108,2108,2108,2109,2109,2109,2109,2109,2109,2109,2109,2109,2109,2109};


static const short Gen_shift_values_BG1_Z_2[2109]= {1,1,1,0,0,0,0,1,0,0,0,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,1,1,1,0,0,0,1,0,1,1,1,1,0,1,1,0,1,1,0,0,1,0,1,0,1,1,1,0,1,0,0,1,1,0,1,1,0,1,1,1,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,1,1,1,1,0,1,0,1,0,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,0,0,1,0,0,1,1,0,1,0,1,0,1,0,1,1,1,1,0,0,0,1,1,0,0,1,0,1,0,0,1,1,0,0,0,1,0,1,0,0,1,0,1,1,1,0,1,1,0,1,1,0,0,0,1,0,1,0,1,0,1,1,0,0,1,1,0,1,0,1,1,0,0,1,1,0,1,0,1,0,1,1,0,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,0,0,0,0,0,1,1,1,0,1,0,1,1,1,1,1,0,0,1,1,0,0,1,1,0,1,1,0,0,1,0,1,0,1,0,1,1,1,1,1,1,1,0,0,0,1,0,1,0,1,0,1,0,0,1,1,1,0,1,1,0,1,1,0,1,0,1,1,1,0,0,1,1,0,1,1,1,1,1,1,0,1,0,1,0,0,1,0,0,0,1,0,1,1,1,1,0,1,1,1,1,0,1,0,1,0,0,1,1,0,1,0,0,1,1,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,0,0,1,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,1,1,0,1,0,0,0,1,1,0,0,0,1,0,0,0,0,0,1,0,1,0,1,1,1,1,1,0,1,1,0,1,1,0,0,1,1,1,0,1,1,1,1,1,0,1,0,0,0,0,1,0,1,0,1,0,0,0,1,1,1,0,1,0,0,1,0,1,0,1,0,0,0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,1,1,1,1,1,0,1,1,1,1,0,1,0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,0,1,1,0,1,0,1,0,1,1,1,1,0,1,1,0,1,1,1,0,0,1,0,1,1,1,0,0,0,1,0,1,1,1,1,0,1,0,1,0,0,0,1,0,1,0,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,1,0,1,1,0,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,0,1,1,1,0,1,0,1,0,0,1,0,0,0,1,0,1,0,1,0,1,1,0,0,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,0,1,1,0,0,1,0,1,1,1,0,0,1,1,0,1,0,0,1,0,1,1,0,0,1,0,1,0,0,1,0,1,0,1,0,0,1,0,1,1,0,1,1,0,1,0,1,0,0,0,1,1,0,1,0,0,0,0,1,1,0,0,1,0,1,0,1,0,1,0,0,1,1,0,0,1,0,0,1,1,0,1,0,1,0,1,0,1,1,0,1,1,0,0,1,1,0,0,0,1,0,1,0,1,0,0,1,0,1,1,0,0,0,1,1,0,1,0,1,1,1,0,1,1,0,1,0,0,0,1,0,0,1,1,1,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,1,1,0,1,0,0,1,1,0,0,1,1,0,1,1,1,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,1,1,1,1,0,1,0,1,0,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,0,1,0,0,1,0,1,0,1,0,1,1,1,1,0,1,0,0,1,0,1,1,0,0,0,0,0,1,1,0,0,1,1,0,0,1,0,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,1,0,1,1,0,1,0,1,0,1,0,1,1,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,0,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,1,0,0,1,1,0,1,0,0,1,0,1,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,1,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,1,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,1,1,0,1,1,0,1,0,0,0,0,0,1,0,0,1,1,0,0,1,1,0,1,0,0,0,0,0,1,0,1,1,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,1,1,0,1,1,1,1,1,0,0,1,1,0,0,1,1,0,1,1,0,0,1,0,1,0,1,0,1,1,1,1,1,1,1,0,0,0,1,0,1,0,1,0,1,0,0,1,1,1,0,1,1,1,0,1,1,0,1,0,1,1,1,0,0,1,1,0,1,1,1,1,1,1,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,1,1,1,0,0,1,1,0,1,0,1,1,0,0,1,1,1,0,1,0,1,1,0,1,0,0,0,1,0,0,1,0,0,1,0,1,1,0,1,0,1,0,1,0,0,1,1,0,1,0,1,0,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,0,1,1,1,0,0,0,0,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,0,1,0,0,1,1,1,0,1,0,0,1,1,0,1,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,1,1,0,1,0,0,0,0,1,0,1,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,1,1,1,0,1,1,1,0,1,1,0,0,0,1,0,1,0,1,0,1,0,0,0,0,1,1,1,0,0,1,1,0,1,0,1,1,0,0,1,1,1,0,1,0,1,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,0,1,0,1,1,0,0,1,1,0,0,1,0,1,0,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,1,1,1,1,0,0,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,0,1,1,0,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0,1,1,0,0,0,1,0,1,1,1,1,1,0,1,1,0,1,1,0,0,1,0,1,0,1,1,1,0,1,0,0,1,1,0,1,1,0,1,1,1,0,1,1,0,1,0,0,0,0,1,0,0,0,1,0,1,1,1,1,1,0,1,0,1,0,1,0,0,1,1,0,1,0,1,0,0,1,1,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,1,0,1,0,1,0,1,0,0,0,0,1,1,1,0,0,1,0,1,0,1,0,1,1,0,0,1,1,1,0,1,0,1,1,0,1,0,0,0,1,0,0,1,0,0,1,1,1,0,1,0,1,0,1,0,0,1,1,0,0,1,0,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,1,0,1,1,1,1,1,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,1,1,0,0,1,0,0,1,1,0,1,0,1,0,1,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,1,0,1,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,1,0,1,1,1,0,1,1,1,1,0,0,1,0,0,1,1,0,1,0,0,1,1,0,0,1,1,1,1,1,0,1,1,0,0,0,0,1,0,0,1,0,1,1,1,1,1,0,1,1,0,0,1,1,0,0,1,0,1,1,1,1,1,0,1,0,0,0,0,0};
static const short Gen_shift_values_BG1_Z_3[2109]= {0,0,0,2,0,0,2,1,0,0,2,0,2,2,1,1,0,2,0,2,1,0,0,2,2,0,0,1,1,0,2,2,2,2,0,0,1,1,2,2,2,1,1,0,0,1,1,2,1,0,2,0,2,1,2,1,2,0,2,0,0,2,0,2,0,0,2,0,1,1,1,0,0,1,1,0,1,2,1,1,2,0,1,0,0,2,2,0,1,0,1,2,0,2,1,1,0,0,1,1,2,1,2,1,0,2,0,0,0,0,1,1,2,1,2,0,0,2,0,2,2,1,1,2,1,2,0,2,0,1,0,1,0,2,0,1,2,0,1,2,0,1,1,2,0,1,0,0,1,1,0,1,1,0,1,2,0,1,0,1,2,0,2,1,0,1,0,1,2,0,0,1,2,1,2,1,0,0,1,0,1,2,0,1,1,2,0,2,0,1,0,1,1,2,2,1,2,0,0,2,0,2,0,1,1,1,2,2,0,2,0,0,1,2,1,2,1,0,1,1,2,2,0,1,2,1,0,0,1,0,1,2,2,0,2,2,0,0,1,0,1,0,1,0,0,1,2,0,1,1,2,0,1,1,1,2,0,1,1,2,0,2,1,1,0,1,2,0,0,2,1,2,1,0,1,0,2,0,1,1,0,2,0,1,1,1,2,2,1,0,0,0,2,0,1,1,1,2,2,0,2,0,0,2,1,2,1,1,1,2,2,0,2,1,0,0,1,0,2,2,0,2,0,0,1,0,1,1,0,1,2,0,1,1,2,0,1,0,1,1,1,0,2,1,1,0,1,2,1,1,0,1,0,0,0,2,2,1,0,1,0,2,1,1,0,0,1,1,2,2,1,0,0,0,0,1,1,2,2,0,0,0,0,2,2,1,1,2,2,0,2,1,0,1,0,0,2,0,2,0,1,0,1,1,0,1,0,1,1,0,2,1,1,0,2,1,0,2,2,2,1,0,2,1,2,1,0,1,0,1,2,0,0,1,2,0,1,0,1,2,0,0,1,2,1,2,1,1,0,1,2,0,0,2,1,0,0,1,2,2,0,2,2,0,1,2,0,1,1,0,0,2,1,2,0,0,2,2,0,1,1,2,0,1,0,0,1,2,0,1,2,1,0,1,2,0,2,0,1,2,1,1,0,0,1,2,0,2,0,1,2,0,1,2,1,0,1,0,2,0,1,2,1,0,2,0,1,2,2,0,2,2,0,1,2,0,1,1,0,1,2,0,2,0,1,2,1,0,2,2,0,1,1,0,0,2,1,2,0,2,0,2,2,0,1,0,1,2,2,1,0,1,2,1,2,0,0,2,1,0,1,2,0,1,0,2,1,2,0,0,1,2,1,0,1,0,0,1,2,1,2,0,2,0,2,2,2,0,1,2,0,2,1,2,1,1,2,1,2,1,2,0,1,2,1,1,2,1,2,0,1,2,2,2,0,1,2,1,2,0,0,1,1,2,0,1,0,1,2,0,2,0,1,1,2,0,1,1,2,0,0,1,2,0,1,2,1,2,0,1,0,1,1,2,1,2,2,0,2,2,0,1,2,0,1,0,0,1,0,1,0,1,1,1,2,1,2,2,0,2,2,0,0,1,0,1,1,0,0,1,2,0,2,0,1,2,1,2,2,0,2,2,0,0,1,2,0,1,1,2,0,1,1,2,1,0,1,2,0,0,1,2,2,0,0,1,1,2,0,0,1,1,2,1,2,0,0,1,1,2,0,1,1,1,2,1,2,0,1,1,1,2,2,0,1,1,1,2,2,2,1,0,1,2,2,1,2,0,2,2,0,1,2,1,2,1,0,0,1,2,1,2,0,1,0,2,2,1,1,1,2,2,0,2,0,2,1,0,1,1,1,1,2,2,0,2,0,1,1,0,1,0,0,2,2,0,2,0,1,0,1,2,1,2,1,0,1,2,0,1,2,0,1,2,2,0,1,2,1,0,1,2,2,1,0,1,1,1,1,2,0,0,0,1,2,0,0,0,1,2,1,1,0,0,2,0,1,2,2,1,0,1,0,2,0,2,1,2,0,0,2,1,2,0,0,0,1,1,0,2,2,2,1,2,2,0,0,0,1,1,2,1,2,2,1,0,1,2,0,0,0,1,1,2,1,0,2,2,0,2,1,1,2,1,2,2,0,0,2,0,0,2,0,1,2,0,0,1,2,0,0,0,2,0,0,2,0,1,0,0,2,0,2,1,2,1,1,0,2,0,2,1,0,0,2,2,0,0,1,1,0,2,2,2,2,0,0,1,2,1,2,2,2,1,1,0,0,1,1,2,1,0,2,0,2,1,2,1,2,0,2,0,0,2,0,2,0,0,0,2,1,2,2,0,2,0,0,0,2,0,0,2,1,1,1,2,2,2,1,0,2,2,1,0,2,2,1,2,1,1,1,0,0,2,1,2,1,0,2,2,1,1,2,2,0,0,2,1,2,1,1,1,2,2,0,1,0,1,1,1,0,0,2,2,0,0,1,0,2,1,2,1,0,1,0,1,2,1,2,2,1,2,1,2,2,1,0,2,0,2,0,2,1,1,0,2,1,0,2,0,0,0,2,0,0,0,2,1,0,0,2,0,2,1,2,1,1,0,0,2,0,2,1,0,0,2,2,0,0,1,1,0,2,2,2,2,0,0,1,2,1,2,2,2,1,1,0,0,1,1,2,1,0,2,0,2,1,2,1,2,0,2,0,0,2,0,2,0,0,2,2,1,1,2,1,2,0,0,1,1,1,2,0,0,0,1,1,1,2,0,1,1,2,0,2,2,1,1,0,1,2,0,0,2,1,2,1,0,1,0,2,0,1,1,0,2,0,1,1,1,2,2,1,0,0,0,2,0,1,1,1,2,2,0,2,0,0,2,1,2,1,1,1,2,1,2,0,2,1,0,0,1,0,2,2,0,2,0,0,1,2,0,1,1,0,1,2,0,1,1,2,0,1,1,0,1,2,0,2,1,0,1,2,0,2,1,0,1,0,1,2,0,0,1,2,1,2,1,0,0,1,0,1,2,0,1,1,2,0,2,0,1,0,1,1,2,2,1,2,0,0,2,0,2,0,0,1,1,1,2,2,0,2,0,0,1,2,1,2,1,1,0,1,1,2,2,0,1,2,1,0,0,1,0,1,2,2,0,2,2,0,0,1,0,1,0,1,0,0,1,2,0,1,1,2,0,0,2,0,2,0,2,2,0,1,0,2,0,2,2,0,1,0,1,0,0,2,0,2,2,1,0,2,2,0,1,2,1,1,0,1,2,0,0,2,2,1,0,2,2,1,1,0,0,1,2,0,2,2,1,2,0,1,1,0,2,0,2,1,2,0,1,0,0,2,2,1,2,1,2,1,2,0,1,0,2,0,2,1,2,0,1,0,2,1,2,0,1,2,1,1,0,1,2,0,0,2,0,2,1,2,0,1,0,2,1,1,0,0,2,2,1,0,1,2,2,1,1,0,2,0,1,1,0,2,1,0,1,2,2,1,0,2,0,2,2,1,0,2,2,0,1,0,2,0,2,2,0,1,0,0,2,0,1,2,2,0,2,0,1,2,1,0,2,0,2,0,1,2,2,0,1,0,1,0,2,2,0,2,0,1,2,0,0,1,2,1,2,0,2,0,0,1,1,0,1,2,2,1,2,1,2,0,0,0,1,1,2,1,2,2,2,0,1,0,1,0,2,0,0,1,0,1,2,0,1,0,2,2,0,2,0,1,1,2,1,1,2,2,0,2,0,2,0,2,2,0,1,2,0,0,1,2,1,1,0,2,1,0,0,2,2,2,2,1,2,2,1,1,0,2,2,1,2,1,1,0,0,2,1,2,1,0,2,1,2,1,1,2,2,0,0,2,1,1,1,1,2,2,0,0,1,1,1,1,0,0,2,2,0,0,1,0,2,1,2,1,0,1,0,1,2,1,2,2,1,2,1,2,2,1,2,0,2,2,1,2,2,2,1,1,2,2,1,1,2,0,2,2,0,1,2,1,1,0,0,1,2,1,2,0,1,0,2,2,1,1,2,2,0,2,0,2,1,0,1,1,1,1,2,2,0,2,0,1,1,0,1,0,0,0,2,2,0,2,0,1,0,1,2,1,2,1,0,1,2,0,1,2,0,1,2,2,0,1,2,1,1,2,2,1,1,2,0,0,2,2,0,2,0,0,2,0,1,0,2,0,0,2,0,1,2,1,0,2,0,1,2,1,0,2,0,2,0,1,2,2,0,1,0,1,1,0,2,2,0,2,0,1,2,0,0,1,2,1,2,0,2,0,0,1,1,0,1,2,2,1,2,1,2,0,0,0,1,1,2,1,2,2,0,1,0,1,0,2,0,0,1,1,2,0,1,0,2,2,0,2,0,1,1,2,1,1,2,2,0,2,0,2,0,2,2,0,1,2,0,0,1,2,1,1,1,2,0,1,1,2,0,1,2,1,1,0,1,2,0,0,2,1,2,1,0,1,0,2,0,1,1,0,2,0,1,1,1,2,2,1,0,0,0,2,0,1,1,1,2,2,0,2,0,0,2,1,2,1,1,1,2,2,0,2,1,0,0,1,2,0,2,2,0,2,0,0,1,2,0,1,1,0,1,2,0,1,1,2,0,1,1,1,0,1,1,1,0,2,1,1,0,1,0,0,2,2,1,0,1,0,2,1,1,0,0,2,1,1,2,2,1,0,0,0,0,0,1,1,2,2,0,0,0,2,2,1,1,2,2,0,2,1,0,1,0,2,0,2,0,1,0,1,1,0,1,0,1,1,0,2,1,2};
static const short Gen_shift_values_BG1_Z_4[2109]= {1,1,1,0,0,2,0,1,2,0,2,0,3,3,2,3,3,2,0,1,0,1,1,0,2,3,0,2,2,0,2,0,2,3,1,3,1,2,1,1,0,1,2,0,0,2,2,3,0,2,1,3,2,0,3,1,0,3,2,2,2,2,0,3,2,3,3,1,2,2,2,1,0,1,3,1,1,2,3,1,2,3,1,0,0,3,0,3,0,3,1,1,2,1,2,2,1,3,0,1,3,2,3,1,3,0,1,3,0,1,2,0,2,2,3,2,2,0,1,2,3,1,1,3,2,3,0,1,2,3,2,0,3,1,0,1,2,1,0,2,3,3,3,2,3,1,0,2,3,0,0,2,2,1,2,0,1,1,2,3,0,1,2,3,0,1,3,1,3,0,0,2,3,3,0,0,3,0,1,2,0,1,1,2,2,0,1,2,3,0,0,1,2,3,3,1,2,3,1,2,3,3,0,2,0,1,2,3,2,1,2,1,1,2,2,3,1,0,1,2,3,3,0,0,1,3,2,3,0,3,0,1,3,0,2,0,1,3,0,3,3,2,3,3,0,1,3,0,3,0,3,0,2,2,2,0,1,1,3,0,1,2,3,1,3,1,3,0,0,3,3,0,0,3,1,2,1,1,2,2,1,2,3,0,1,2,3,3,1,3,1,3,3,0,2,0,1,2,3,2,1,2,1,2,2,3,1,1,2,3,3,0,1,3,2,3,0,3,1,3,0,2,1,3,0,3,3,3,3,1,3,0,3,0,3,0,0,1,0,0,0,3,0,3,1,3,3,0,1,3,1,3,2,1,2,1,2,2,1,3,0,3,0,0,3,1,2,3,1,1,3,1,3,1,2,0,2,0,1,0,0,2,3,0,1,3,3,1,1,2,3,1,0,2,3,1,3,2,0,3,2,1,1,1,1,3,2,1,2,2,2,2,1,3,2,3,2,0,2,3,3,2,2,2,3,2,0,2,0,2,3,0,1,2,3,3,1,3,3,0,1,1,2,3,3,2,0,3,1,1,2,3,3,1,1,3,0,1,2,2,0,2,3,0,1,0,1,2,0,2,3,1,1,2,3,2,0,1,2,3,2,3,0,2,0,1,2,3,3,0,1,0,2,1,2,3,3,0,1,3,1,1,3,3,0,1,1,3,3,0,1,0,1,2,2,0,0,2,2,3,0,3,1,2,0,2,3,0,2,1,3,2,3,0,3,0,1,1,3,1,2,3,3,0,1,3,1,0,2,1,2,3,3,1,2,0,0,1,2,1,3,1,1,2,3,0,1,2,2,0,1,2,3,0,1,2,3,1,3,1,3,0,1,3,3,1,1,2,3,0,1,2,3,1,0,2,0,1,2,0,2,1,0,0,1,1,0,3,1,0,2,3,0,1,1,3,0,1,0,1,0,0,3,0,0,2,3,2,1,0,3,0,1,3,0,2,1,0,3,2,0,1,0,3,3,2,3,2,2,1,3,2,3,1,2,2,1,0,3,1,3,0,0,3,1,0,1,0,0,3,2,1,3,2,0,3,2,1,2,0,1,0,3,2,1,0,2,3,2,1,3,2,1,3,0,3,2,1,0,2,0,1,1,0,1,0,2,0,2,3,1,0,2,1,0,3,0,3,2,1,2,0,1,3,2,0,3,2,0,1,1,0,3,2,1,2,1,0,3,3,2,1,3,0,0,3,3,2,2,0,1,2,1,2,1,2,0,1,0,3,3,2,2,0,1,3,2,3,2,1,3,1,0,3,1,2,3,0,0,0,3,0,2,3,1,3,3,0,1,3,0,1,3,2,3,2,1,2,1,2,1,3,3,0,3,0,0,3,1,2,2,3,1,0,1,3,1,2,3,1,2,3,0,2,0,0,1,0,0,2,3,0,1,3,3,1,0,1,2,3,0,1,0,2,1,3,2,3,0,3,2,0,1,1,1,0,1,3,2,0,0,1,2,2,1,2,1,2,3,0,1,1,1,3,0,3,0,2,3,0,3,1,2,0,2,0,2,3,3,2,2,3,3,2,0,1,0,0,1,1,0,1,2,3,0,1,2,2,0,2,0,2,2,3,0,1,3,0,1,2,1,0,1,0,1,1,2,2,0,0,1,2,2,3,0,2,1,2,3,2,0,2,3,1,0,2,3,2,2,2,2,2,0,2,3,2,3,2,3,3,3,3,2,2,0,2,3,3,0,2,0,2,1,0,1,0,1,1,0,2,3,2,3,3,2,0,1,2,0,0,2,0,2,0,1,3,1,3,0,0,3,3,2,3,0,2,2,0,0,1,2,0,3,1,0,2,1,3,2,1,0,0,0,0,2,1,2,0,1,1,2,3,2,0,3,1,0,3,2,2,3,0,3,2,3,1,1,1,0,2,0,2,0,1,2,0,2,0,3,1,3,2,3,3,2,0,1,0,1,1,0,2,3,0,2,2,0,2,0,0,2,3,1,3,1,2,2,1,1,0,1,2,0,0,2,2,3,0,2,1,3,2,0,3,1,0,3,2,2,2,2,0,3,2,3,3,0,0,0,2,2,3,1,3,1,3,2,1,3,3,3,3,2,3,2,0,2,3,0,2,0,2,1,1,1,0,1,3,1,0,2,3,2,3,3,2,0,1,2,0,0,2,0,2,0,1,3,1,3,3,0,3,3,2,3,0,2,2,0,0,1,2,0,3,1,0,2,1,3,2,1,0,0,0,0,2,1,0,1,1,2,3,3,1,2,2,2,0,0,3,1,3,0,0,2,0,0,0,2,3,3,1,2,3,1,0,1,3,1,3,1,2,2,1,1,2,2,1,3,0,3,3,0,0,3,0,1,2,3,0,1,1,3,1,3,1,1,2,0,2,3,0,1,0,3,0,3,0,0,1,3,3,0,1,3,1,2,3,1,0,1,2,1,3,1,2,0,3,1,2,3,1,1,1,1,3,1,2,1,2,1,2,3,3,2,3,1,2,3,2,3,0,1,2,3,0,1,2,0,2,0,1,1,3,0,0,1,1,0,1,2,3,1,2,2,3,3,1,2,3,0,1,1,2,3,0,0,2,3,0,2,3,0,0,1,0,3,1,2,3,0,3,2,3,2,2,3,3,0,3,2,1,2,3,0,0,1,1,2,0,3,0,1,0,1,2,0,1,3,1,2,0,1,0,0,3,0,0,1,2,0,1,0,1,0,1,1,3,1,3,1,3,0,1,2,0,2,2,0,0,1,2,2,1,3,2,0,0,2,2,0,0,2,3,0,1,3,1,2,0,3,0,1,3,1,2,0,0,2,1,3,0,2,1,2,3,1,3,0,2,2,3,0,0,3,1,0,2,2,3,0,2,0,0,2,2,0,0,2,2,0,3,0,1,1,3,3,1,1,2,3,2,0,1,3,1,2,3,0,2,1,3,2,3,0,0,2,0,2,2,3,0,2,0,3,1,0,2,2,0,1,3,3,0,1,2,0,0,2,3,0,1,1,3,0,2,3,0,1,2,0,2,0,2,0,2,0,0,2,3,0,1,2,0,3,1,3,0,1,3,3,2,3,1,2,0,2,3,0,1,2,3,0,1,2,0,2,0,1,1,3,0,0,1,1,0,1,2,3,1,2,2,3,3,1,2,3,0,1,1,2,3,0,0,2,3,0,2,3,0,0,1,3,1,2,3,0,3,2,3,3,2,2,3,3,0,2,1,2,3,0,2,0,1,1,2,0,3,0,1,0,1,2,0,1,3,1,2,0,1,0,0,3,0,0,1,2,0,1,0,1,0,1,1,2,0,2,2,2,3,2,0,0,0,3,3,1,3,0,0,1,3,1,3,2,2,1,2,2,1,3,0,3,0,0,0,3,1,2,3,1,1,3,1,3,1,2,0,2,0,1,0,0,2,3,0,1,3,3,1,1,2,3,1,0,2,1,3,2,0,3,2,1,1,1,1,3,2,1,2,2,0,0,2,3,3,0,0,0,3,2,3,1,3,1,3,0,1,3,0,1,3,2,2,1,2,1,2,1,3,3,0,3,0,0,3,1,2,3,1,0,1,3,1,2,3,1,2,3,0,2,0,0,1,0,0,2,3,0,1,3,3,3,1,0,1,2,3,0,1,0,2,1,3,2,3,0,3,2,0,1,1,1,0,1,3,2,0,1,2,2,2,2,0,2,0,2,0,3,0,0,0,2,0,2,2,3,3,2,3,1,2,0,2,3,0,1,2,3,0,1,2,0,2,0,1,1,3,0,0,1,0,1,0,1,2,3,1,2,2,3,3,1,2,3,0,1,1,2,3,0,0,2,3,0,2,3,0,0,1,3,1,2,3,0,3,2,3,2,2,3,3,0,2,1,2,3,0,0,1,1,2,0,3,0,1,0,1,2,0,1,3,1,2,0,1,0,0,3,0,0,1,2,0,1,0,1,0,1,1,1,1,3,0,0,2,3,0,2,1,2,0,2,0,2,3,3,2,2,3,3,2,0,1,0,0,1,1,0,1,2,3,0,1,2,2,0,2,0,2,2,3,1,3,0,1,2,1,0,1,0,1,1,2,0,0,1,2,2,3,0,2,1,2,3,2,2,0,2,3,1,0,2,3,0,2,2,2,2,0,2,3,2,3,2,3,2,2,2,1,2,1,3,1,2,3,1,3,1,0,0,3,0,0,3,1,2,1,2,2,1,3,0,0,1,3,3,1,3,2,1,3,0,2,0,2,3,2,2,1,2,3,1,1,3,3,0,1,3,2,0,3,1,0,2,1,0,3,3,3,3,1,0,3,0,0,0,2,2};
static const short Gen_shift_values_BG1_Z_5[2109]= {2,2,2,4,4,1,2,2,3,4,3,1,4,0,4,1,4,0,2,3,1,0,2,1,4,3,4,3,4,4,0,1,0,0,4,3,2,3,4,2,2,4,3,0,2,2,2,0,0,4,1,3,2,3,2,2,0,1,0,4,4,3,0,3,1,0,2,2,3,3,3,0,4,0,2,3,2,3,4,0,3,4,2,0,1,0,2,4,0,1,3,3,4,2,1,3,2,0,4,0,4,4,0,0,1,1,2,1,1,4,0,4,3,3,4,0,3,2,3,0,4,1,3,3,2,3,1,1,4,0,2,4,3,4,3,2,3,1,2,0,1,0,0,3,4,1,4,1,2,1,3,3,3,2,3,4,0,0,1,2,2,3,3,4,4,0,4,2,4,0,1,4,0,1,2,0,1,2,3,4,1,2,0,1,3,1,2,4,0,4,4,0,3,4,0,0,0,1,2,0,1,0,1,0,4,2,3,4,0,2,3,3,4,0,3,4,1,2,3,2,3,3,1,0,1,0,2,3,4,3,3,4,2,3,3,0,1,1,2,1,0,4,0,4,0,1,3,4,2,1,2,3,3,3,3,4,0,0,2,2,3,3,4,0,4,2,4,0,1,0,1,2,0,1,3,4,2,0,1,3,2,4,0,4,0,3,4,0,0,1,2,1,0,1,0,4,2,3,4,0,2,3,3,0,3,4,1,3,2,3,3,1,1,0,2,3,4,3,4,2,3,3,1,1,2,1,0,0,4,1,3,4,2,1,2,3,2,4,1,1,1,3,2,3,0,1,1,1,2,3,2,0,3,4,4,3,0,3,4,1,2,0,4,1,0,3,2,3,2,3,3,4,0,4,4,3,2,1,2,3,1,2,1,3,2,4,1,1,1,4,4,3,0,2,0,1,2,1,1,4,0,4,3,3,2,4,2,0,4,1,1,3,0,2,2,1,1,2,4,1,2,1,4,4,0,2,2,2,2,2,1,2,4,3,4,4,4,4,1,0,1,2,1,2,2,2,2,3,3,4,3,4,3,3,1,1,4,3,4,4,0,0,4,3,4,1,0,1,4,4,0,0,2,1,2,3,3,1,0,1,0,4,0,2,2,1,0,1,4,3,4,3,3,4,3,4,3,2,3,4,4,4,4,0,4,0,1,1,0,4,0,0,4,0,4,4,3,3,2,1,2,3,3,4,4,2,1,2,0,2,2,4,3,4,3,2,3,0,0,2,1,2,2,1,2,2,2,0,0,0,4,0,4,4,1,1,3,2,3,0,2,2,3,2,3,2,1,2,2,2,0,4,0,1,0,1,0,0,4,4,4,3,4,4,3,3,0,4,0,3,2,3,1,1,0,0,2,1,2,3,3,3,0,0,0,1,4,3,3,4,0,4,0,0,0,2,3,0,3,0,3,2,0,0,2,4,0,4,2,0,3,1,0,2,3,1,4,2,0,1,3,4,4,2,2,0,3,1,2,0,4,2,2,4,0,3,1,0,3,1,3,4,4,2,3,1,0,3,4,2,2,0,1,4,2,0,1,4,2,4,0,2,0,3,1,4,1,2,3,1,3,1,2,4,0,1,4,0,3,1,3,4,2,0,0,3,4,0,2,3,2,0,1,4,3,1,0,3,0,3,0,2,3,3,1,3,1,2,4,0,4,2,1,4,3,0,3,1,4,0,3,0,2,3,3,1,4,2,3,0,1,2,0,2,0,1,3,4,3,1,1,4,4,1,2,3,1,0,3,1,3,4,3,2,4,1,4,0,0,0,2,3,1,2,4,0,4,0,1,2,0,1,4,2,1,3,2,4,1,2,3,0,0,1,4,3,0,4,2,2,1,2,1,1,2,2,3,3,4,3,3,1,2,1,0,0,1,2,0,4,0,2,1,3,0,0,4,0,3,3,1,2,4,1,0,1,0,4,0,3,4,2,3,2,2,0,1,3,1,4,3,4,3,0,2,3,3,0,3,2,4,4,4,0,1,3,1,3,3,4,4,4,0,1,0,3,0,1,2,1,2,3,1,2,4,0,3,1,2,4,3,0,1,0,1,4,0,1,1,2,3,2,1,2,4,1,0,3,4,0,1,3,4,4,1,4,0,4,2,4,3,4,4,2,2,1,3,4,0,4,0,3,4,4,2,2,3,3,2,1,1,0,2,4,0,3,2,3,4,2,2,2,4,4,1,2,3,2,3,4,3,1,4,4,0,4,1,4,0,2,3,1,0,2,1,4,3,4,3,4,4,0,1,0,0,4,3,2,4,3,4,2,2,4,3,0,2,2,2,0,0,4,1,3,2,3,2,2,0,1,0,4,4,3,0,3,4,1,0,2,1,1,2,0,2,4,3,0,0,4,3,0,0,4,0,2,2,2,4,0,4,1,2,2,3,4,3,1,4,1,0,4,1,4,0,2,3,1,0,2,1,4,3,4,3,4,4,0,4,1,0,0,4,3,2,4,3,4,2,2,4,3,0,2,2,2,0,0,4,1,3,2,3,2,2,0,1,0,4,4,3,0,3,1,0,2,3,4,1,2,2,1,4,4,0,3,4,2,4,3,3,3,0,3,0,2,3,3,4,0,4,2,0,4,1,0,2,4,0,1,3,4,2,1,3,2,0,4,0,4,0,0,1,2,1,1,0,4,3,1,4,0,3,3,0,4,1,3,3,3,1,1,0,2,4,3,4,3,3,1,2,1,0,0,4,1,4,2,1,3,1,4,0,0,4,4,2,1,4,3,3,0,2,4,3,2,2,2,3,4,4,1,1,2,1,2,3,4,3,1,3,4,0,4,0,1,4,0,2,3,1,4,0,2,1,3,4,3,4,2,3,4,4,0,1,0,4,0,4,3,1,2,3,4,1,2,2,4,2,3,0,2,1,2,2,2,0,0,4,1,2,3,2,3,1,2,2,0,0,1,1,0,4,4,3,0,2,3,1,0,1,2,3,3,2,3,4,0,0,0,1,2,2,3,3,4,4,0,4,2,4,0,1,4,0,1,2,0,1,2,3,4,1,2,0,1,3,1,2,4,0,4,4,0,3,4,0,0,0,1,2,0,1,0,1,2,0,4,2,3,4,0,2,3,3,4,0,3,4,4,1,2,3,2,3,3,1,0,1,0,2,3,4,3,3,4,2,3,3,0,1,1,2,1,0,4,0,4,0,1,3,4,2,1,2,3,3,0,3,0,3,0,0,1,2,0,2,2,4,3,4,0,1,3,0,4,1,0,2,4,1,2,4,0,1,2,1,3,0,2,2,3,4,0,2,1,3,3,0,4,1,2,4,1,2,3,3,0,2,4,0,1,2,2,4,1,0,2,4,0,1,0,2,0,2,1,3,2,4,1,3,1,2,3,0,2,4,1,3,4,0,4,1,0,2,3,4,0,3,0,0,2,4,0,1,1,3,3,0,3,4,0,3,0,1,3,1,3,0,2,2,4,4,0,1,3,0,4,1,3,4,0,3,0,1,3,2,3,4,1,3,0,2,0,2,4,1,1,3,4,0,1,2,4,1,3,3,4,0,0,0,4,0,1,2,4,2,3,4,4,0,0,1,1,2,1,4,1,2,3,1,2,3,4,2,3,4,0,1,3,4,2,3,0,3,4,1,2,1,1,2,0,1,2,2,2,3,4,2,3,2,3,2,1,4,0,1,2,4,0,1,0,1,2,0,1,3,4,0,4,0,0,0,3,2,3,2,4,0,1,0,0,1,4,0,0,2,3,3,4,3,2,1,2,1,2,3,0,1,4,3,4,0,4,4,4,2,1,0,4,3,2,2,2,4,4,1,2,1,2,3,4,3,1,4,0,4,1,4,0,2,3,1,0,2,2,1,4,3,4,3,4,4,0,1,0,0,4,3,2,3,4,2,4,2,4,3,0,2,2,2,0,0,4,1,3,2,3,2,2,0,1,0,4,4,3,0,3,1,0,2,3,3,2,4,2,3,3,3,0,4,0,2,3,2,2,3,4,0,3,4,2,0,1,0,2,4,0,1,3,3,4,2,1,3,2,0,4,0,4,4,0,0,1,1,2,1,1,4,0,4,3,3,4,0,3,2,3,0,4,4,1,3,3,2,3,1,1,4,0,2,4,3,4,3,2,3,1,2,0,1,0,0,3,4,1,4,1,2,1,3,0,3,3,0,1,1,1,2,1,4,1,3,1,3,1,4,4,3,4,0,1,0,1,2,3,3,4,4,0,0,1,0,3,0,1,2,0,1,2,3,4,1,2,3,4,0,2,3,1,2,4,2,3,0,1,0,0,1,4,0,1,1,1,2,3,1,2,1,2,1,0,3,4,0,1,3,4,4,0,1,4,0,2,3,4,3,4,4,2,1,2,1,3,4,0,4,4,0,3,4,4,1,2,2,3,2,1,0,1,0,1,2,4,0,3,2,3,4,0,0,0,1,2,2,4,4,0,2,0,1,2,1,4,1,2,3,2,3,4,2,3,0,1,4,2,3,0,4,1,2,1,2,0,1,2,2,3,4,3,2,3,2,1,4,0,1,2,4,0,0,2,0,1,3,0,4,0,0,3,3,2,4,0,1,3,0,1,4,0,0,3,3,4,0,3,2,2,1,3,0,1,4,3,4,0,2,2,2,4,3,4,1,2,2,3,4,3,1,4,0,4,1,4,0,2,3,1,0,2,1,4,1,3,4,3,4,4,0,3,1,0,0,4,3,2,3,4,2,2,4,3,0,2,2,2,0,0,4,1,3,2,3,2,2,0,1,0,4,4,3,0,3,1,0,2,0,2,0};
static const short Gen_shift_values_BG1_Z_6[2109]= {0,3,0,5,0,3,2,1,3,3,2,0,5,5,1,4,0,5,3,5,4,0,0,2,2,0,3,1,4,3,2,5,2,5,0,0,4,4,5,2,2,1,4,0,3,1,4,2,4,3,5,3,5,4,5,1,5,0,5,0,0,5,0,2,3,3,2,0,1,4,1,0,0,1,4,3,1,2,4,4,2,3,1,0,0,2,5,0,1,0,4,5,0,5,1,1,3,3,1,4,2,4,5,4,3,5,0,3,0,0,1,1,5,4,5,0,3,2,3,2,5,1,4,2,4,5,3,5,3,4,0,4,0,5,0,1,2,0,1,5,0,1,1,5,0,1,3,3,4,4,3,1,4,0,1,5,0,1,3,4,2,3,2,4,3,4,3,1,5,0,0,1,2,4,5,1,0,3,4,0,4,5,0,1,1,2,3,2,3,1,3,4,1,2,5,4,2,3,0,2,3,5,0,1,1,4,5,5,0,2,3,3,1,2,4,5,1,3,4,1,2,5,3,4,5,4,0,3,4,0,4,5,5,0,2,5,0,0,1,0,1,0,1,0,0,1,2,3,4,4,2,3,1,4,1,5,0,1,4,2,3,2,4,4,3,1,5,0,0,2,4,5,1,0,4,0,5,0,1,1,3,2,3,1,4,1,2,5,4,3,0,3,5,0,1,1,4,5,5,0,2,3,3,2,4,5,1,4,1,2,5,3,5,4,0,3,4,0,5,5,0,2,0,0,1,0,1,1,0,1,2,3,4,4,2,3,1,0,1,4,1,0,2,1,4,3,1,2,4,4,3,1,0,0,0,2,5,1,0,4,0,5,1,1,3,3,1,4,2,5,4,3,0,3,0,1,1,5,5,0,3,3,3,2,5,1,4,2,5,3,5,4,0,4,0,0,5,0,2,0,1,0,1,1,0,1,3,4,4,3,2,1,4,0,2,1,0,5,2,2,1,3,2,1,5,1,3,4,0,1,2,3,0,1,2,0,1,3,4,5,0,3,4,5,4,2,4,4,0,4,5,0,3,5,1,3,0,1,2,2,0,2,2,3,4,5,0,1,1,3,0,2,4,5,0,0,2,5,0,1,1,2,3,1,3,3,4,5,3,4,5,1,3,4,5,0,2,3,4,5,1,4,0,3,4,5,0,2,3,4,5,0,1,2,1,3,1,3,5,0,1,5,1,0,2,3,4,5,5,3,5,2,3,4,5,0,1,1,3,4,5,0,2,3,4,5,1,3,5,5,0,1,4,0,0,2,4,5,0,2,0,2,5,0,1,0,1,2,2,4,0,1,2,1,2,3,0,2,1,3,1,2,3,1,0,2,1,2,3,3,4,5,4,0,4,0,3,4,5,1,5,3,2,0,2,2,2,3,4,2,3,2,4,5,4,1,2,1,5,4,2,3,1,5,4,1,2,1,5,0,4,5,5,2,3,1,5,1,5,0,3,4,4,2,3,1,3,1,5,3,2,0,4,1,2,3,1,1,5,3,0,1,2,0,4,2,4,2,0,4,0,4,4,2,1,5,5,3,2,5,0,1,5,0,4,3,0,1,0,4,3,1,4,1,2,4,2,2,0,2,5,0,3,1,0,4,1,0,3,4,5,3,2,0,4,2,1,5,5,3,2,5,0,0,4,2,0,1,4,5,3,1,1,5,4,3,1,2,0,3,1,5,2,3,3,1,4,2,3,0,1,4,2,4,2,3,0,1,4,2,0,4,1,4,5,1,5,0,4,1,4,5,5,3,1,1,4,5,2,5,4,0,4,5,2,1,5,0,2,2,0,1,5,4,2,4,0,3,4,5,4,2,3,4,3,5,5,1,1,1,5,2,0,2,3,2,1,3,4,1,4,4,5,5,3,2,3,4,1,0,1,0,3,5,2,0,2,3,1,3,1,2,4,2,4,3,4,5,0,4,5,3,4,5,5,3,4,5,1,0,1,2,2,1,3,1,4,4,4,5,0,3,0,4,5,0,0,3,1,2,1,1,3,3,2,0,4,5,5,1,3,4,0,5,3,5,4,5,0,0,2,1,2,0,3,0,1,4,3,2,5,2,4,5,5,0,0,3,4,4,5,1,2,2,1,3,4,5,0,3,0,1,4,2,4,3,5,2,3,5,4,4,5,1,5,5,0,0,5,0,0,5,0,1,2,3,3,1,2,3,0,3,2,3,0,5,0,4,0,0,5,3,2,1,2,4,1,3,2,0,2,1,3,3,5,5,3,0,4,1,0,5,2,5,2,3,3,1,2,1,2,5,5,4,1,3,0,4,1,5,1,0,2,0,2,1,2,4,2,3,2,3,3,2,3,5,0,0,0,5,1,2,2,3,2,3,0,3,5,3,0,2,1,1,4,5,2,5,4,0,5,2,1,0,2,2,1,5,4,1,4,0,3,5,4,2,4,3,5,5,1,1,5,2,0,3,2,1,5,4,1,4,5,5,3,4,3,4,1,1,0,3,5,2,0,3,1,3,2,4,2,4,3,4,0,4,5,4,5,5,4,5,1,2,2,1,0,5,3,2,0,5,4,4,3,5,4,0,2,0,3,0,5,3,0,3,2,1,3,3,2,0,5,1,5,1,4,0,0,5,3,5,4,0,0,2,2,0,3,1,4,3,2,5,2,5,0,0,4,2,4,5,2,2,1,4,0,3,1,4,2,4,3,5,3,5,4,5,1,5,0,5,0,0,5,0,2,3,3,2,5,4,4,5,4,2,3,3,1,1,4,5,0,3,3,1,4,1,5,0,1,4,2,3,5,2,4,4,3,1,5,0,0,2,4,5,1,0,4,0,5,0,1,1,3,2,3,1,4,1,2,5,4,3,0,3,5,0,1,1,4,5,5,0,2,3,3,2,4,5,1,4,1,2,4,5,3,5,4,0,3,4,0,5,5,0,2,0,0,1,2,0,1,1,0,1,2,3,4,4,2,3,1,4,0,1,5,0,2,1,3,4,2,3,2,4,3,4,3,1,5,0,0,1,2,4,5,1,0,3,4,0,4,5,0,1,1,2,3,2,3,1,3,4,1,2,5,4,2,3,0,2,3,5,0,0,1,1,4,5,5,0,2,3,3,1,2,4,5,1,1,3,4,1,2,5,3,4,5,4,0,3,4,0,4,5,5,0,2,5,0,0,1,0,1,0,1,0,0,1,2,3,4,4,2,3,0,5,3,2,0,5,5,3,4,0,5,3,2,2,0,1,3,1,0,3,2,3,2,2,1,0,5,5,3,4,5,4,1,0,4,2,3,0,5,5,4,3,2,5,4,4,3,0,4,5,0,5,2,1,2,0,1,4,0,5,3,2,1,5,0,4,3,3,2,2,1,5,4,2,1,5,3,4,0,5,0,5,4,2,3,4,3,5,4,2,0,1,2,1,1,0,4,2,3,0,5,3,2,1,5,0,4,3,2,1,4,3,3,2,5,4,3,1,2,5,4,4,3,5,3,4,1,0,5,4,0,4,5,5,4,0,5,0,5,5,4,0,5,2,0,1,3,2,3,2,2,0,1,0,3,5,0,4,5,5,0,2,3,1,2,1,3,2,3,2,0,4,5,5,0,1,3,4,0,5,2,3,5,3,4,5,0,0,1,2,1,2,0,2,3,0,1,4,3,1,2,5,1,2,4,5,0,0,3,4,4,5,1,2,2,2,0,1,3,4,0,2,3,0,1,0,4,2,3,4,3,5,2,3,5,3,4,4,5,1,4,5,5,0,5,0,5,0,5,5,0,1,2,3,3,1,2,4,1,0,2,1,3,3,5,2,5,2,1,2,5,4,1,3,5,5,4,2,1,1,3,0,2,1,5,1,0,2,4,2,4,4,2,5,3,0,5,4,1,4,1,2,2,0,0,1,4,1,4,3,0,2,5,3,0,4,0,5,1,5,1,0,1,3,1,2,1,2,2,1,2,4,5,5,4,5,0,2,2,1,2,5,2,1,1,2,5,4,4,2,3,5,5,3,4,2,1,1,3,0,1,2,1,5,0,1,0,2,2,4,4,2,5,3,5,0,5,4,0,1,4,1,1,2,2,0,5,0,1,4,3,4,3,0,3,2,5,3,5,0,4,0,4,5,1,5,1,0,1,2,3,1,2,0,1,2,2,0,1,2,4,4,5,5,4,4,2,0,3,5,2,3,2,0,0,5,3,1,0,5,3,0,2,3,1,2,4,3,5,0,4,5,4,0,5,0,5,3,1,2,2,3,4,0,1,1,3,2,5,0,2,0,1,2,3,3,4,5,4,5,3,5,0,3,4,1,0,4,5,2,4,5,1,2,3,3,0,1,1,2,4,5,5,3,4,0,1,3,5,0,3,4,1,5,0,1,0,2,5,0,2,0,1,1,2,4,1,2,2,3,2,3,2,3,2,2,3,4,5,0,0,4,5,1,4,1,5,0,1,4,2,3,4,2,4,4,3,1,5,0,0,2,4,5,1,0,4,0,5,0,1,1,3,2,3,1,4,1,2,5,4,3,0,3,5,0,1,1,4,5,5,0,2,3,3,2,4,5,1,4,1,2,5,3,5,4,0,3,4,5,0,5,5,0,2,0,0,1,5,0,1,1,0,1,2,3,4,4,2,3,4,1,4,3,1,4,1,0,5,1,1,0,4,3,3,5,2,4,3,1,3,2,4,4,0,0,5,4,1,5,2,1,0,0,3,0,3,4,4,2,2,3,0,0,5,2,4,1,5,2,0,2,1,3,1,3,2,3,5,3,4,3,4,4,3,4,0,1,1,0,2,4,2};
static const short Gen_shift_values_BG1_Z_7[2109]= {5,0,3,4,1,6,3,2,2,2,6,3,3,3,0,4,3,6,4,2,3,2,2,3,1,6,5,1,6,2,1,1,6,5,5,2,0,6,1,2,4,6,6,1,3,5,6,1,6,6,5,4,4,1,3,0,4,0,1,2,5,5,5,1,3,4,3,5,6,1,4,5,1,2,0,4,2,3,3,3,6,0,4,4,4,1,5,3,4,0,5,2,3,4,3,3,4,2,0,6,2,6,0,3,2,1,2,0,6,5,6,3,1,6,0,2,3,4,5,0,0,2,4,6,6,0,2,0,6,0,6,5,5,2,4,0,1,5,1,1,2,3,6,5,6,6,2,3,4,5,4,6,1,3,4,4,5,2,6,0,3,4,3,3,2,3,0,4,3,4,4,0,1,4,5,4,0,4,5,3,3,4,2,3,3,3,4,1,2,0,5,6,1,2,0,3,1,2,2,6,0,5,6,6,3,0,1,0,2,2,3,5,6,0,6,0,2,3,4,5,6,0,2,6,0,0,6,4,5,5,1,2,3,4,1,4,5,0,1,2,3,5,6,6,5,6,1,2,4,5,3,4,6,1,4,4,5,2,0,3,4,3,3,3,0,4,3,4,4,1,4,5,4,0,5,3,4,2,3,3,4,1,2,0,6,1,2,0,3,2,2,0,5,6,6,3,0,1,0,2,2,3,5,0,6,0,2,4,5,6,0,2,0,0,6,4,5,5,2,3,4,1,5,0,1,2,3,6,6,6,1,2,4,5,3,4,1,2,4,6,2,3,2,0,5,2,2,1,1,1,5,2,2,1,2,6,3,2,5,3,1,2,1,1,2,0,5,4,0,5,1,0,0,5,4,4,1,6,5,0,1,2,3,5,5,0,2,4,5,0,5,5,4,3,6,3,0,2,6,3,6,0,1,4,4,4,0,2,3,2,3,3,6,0,6,6,1,2,3,2,5,5,1,2,3,0,4,2,6,5,1,2,6,2,3,4,3,0,1,4,5,5,1,2,3,4,1,4,1,4,0,1,1,5,5,2,5,1,2,3,5,2,2,5,6,6,2,3,5,2,1,5,6,2,3,4,1,5,1,2,4,0,1,4,1,5,1,2,3,6,0,1,5,0,3,4,3,6,0,1,5,4,1,3,6,0,3,0,1,4,5,0,3,4,0,4,4,1,2,5,6,1,5,3,0,4,0,1,6,6,3,1,4,5,1,4,5,3,0,5,1,2,0,3,4,1,5,3,0,1,4,5,1,5,0,4,6,2,3,0,6,3,3,6,0,5,1,2,2,6,6,2,3,2,5,6,3,0,4,1,0,3,4,3,0,4,0,3,4,3,6,0,5,2,6,3,5,1,2,1,1,1,2,6,4,2,3,0,4,3,5,4,4,4,5,3,4,0,6,3,2,4,3,2,1,6,0,6,5,3,2,3,2,0,1,2,1,2,1,6,4,5,3,2,3,2,3,2,0,6,4,3,3,1,2,6,5,4,3,2,0,1,3,2,2,1,2,1,3,2,1,0,6,5,5,4,1,0,6,4,5,2,1,1,0,1,6,0,6,5,5,4,5,3,4,2,1,0,6,6,4,5,1,0,2,1,1,4,2,3,6,5,6,5,1,0,3,2,5,4,6,4,5,1,0,6,5,6,4,5,5,4,4,3,6,4,3,1,0,3,2,0,5,6,4,3,0,6,1,6,0,2,1,5,4,5,3,4,5,4,1,0,3,1,2,4,3,3,2,3,1,6,2,2,6,6,6,0,2,5,6,3,2,3,1,5,3,4,4,4,0,1,5,5,6,5,2,6,4,5,1,6,3,4,5,4,4,5,3,1,1,0,3,0,1,4,3,2,3,1,0,6,0,4,2,0,1,3,4,5,6,1,1,3,5,0,0,1,3,1,0,1,0,6,6,3,5,1,2,6,2,2,3,4,0,6,0,0,3,6,4,5,6,5,6,6,0,1,1,0,3,5,1,1,2,5,6,4,0,1,0,0,0,0,4,1,0,1,1,5,1,2,1,4,2,0,1,6,0,0,1,5,6,4,3,5,6,4,0,6,6,4,2,3,4,3,0,4,5,4,6,6,0,2,4,3,4,5,6,1,2,3,4,6,4,4,3,1,2,2,6,0,1,5,2,4,5,5,6,0,3,3,3,5,6,1,2,0,1,1,3,6,0,4,2,6,6,5,5,5,2,6,6,2,6,3,0,6,2,0,5,6,5,5,6,4,2,1,4,2,5,4,4,2,1,1,5,3,0,2,4,5,0,2,2,4,6,1,2,4,2,2,1,0,0,4,6,3,0,3,4,5,1,1,1,4,6,6,0,6,6,4,3,6,3,2,4,3,2,3,0,5,4,1,0,6,1,4,5,6,2,0,4,3,3,3,0,4,4,6,4,1,5,4,0,5,3,4,3,3,4,2,0,6,2,0,3,2,1,2,0,6,6,3,1,3,0,2,3,5,0,0,2,4,6,0,2,0,0,6,5,5,2,4,1,5,1,2,3,6,6,6,2,4,5,4,2,4,2,0,0,3,6,2,0,3,6,6,2,3,5,1,2,6,6,4,1,0,0,0,4,1,1,2,1,5,2,0,1,4,2,0,1,0,0,1,6,4,3,6,4,0,6,6,4,3,3,0,5,3,4,6,0,2,4,4,6,1,3,4,6,4,4,3,2,2,6,1,5,2,5,6,0,3,3,3,6,1,2,1,0,4,1,3,1,0,1,0,4,0,5,5,5,6,1,4,6,2,2,3,0,5,1,2,2,1,1,1,5,2,1,2,2,6,2,3,2,5,3,1,2,0,1,1,2,6,0,5,4,6,0,5,1,0,0,5,3,4,4,1,5,6,5,0,0,1,3,5,4,5,0,2,3,4,3,5,0,5,5,4,2,3,3,0,1,2,6,3,5,6,3,0,1,4,4,4,6,0,2,3,1,2,3,5,0,1,1,2,5,6,3,4,0,1,0,0,6,0,4,1,0,1,1,4,5,1,2,1,4,1,2,0,0,1,6,0,0,0,1,5,6,4,2,3,5,6,4,0,5,6,6,3,4,2,3,3,3,0,4,5,4,6,6,0,2,3,4,3,4,6,6,0,1,2,3,4,6,3,4,4,3,1,2,2,5,6,0,1,5,1,2,4,5,6,0,2,3,3,2,3,5,6,1,2,0,1,0,1,2,3,5,6,6,6,0,3,4,1,2,5,5,6,6,4,5,4,5,4,5,1,2,5,6,5,5,6,5,6,2,3,6,6,0,5,6,1,2,6,0,4,5,5,6,4,4,5,4,5,5,6,3,3,4,6,1,2,0,1,3,3,4,1,2,4,5,3,4,3,4,1,2,0,0,1,0,1,4,5,2,2,3,1,2,3,4,4,4,5,6,0,1,2,1,1,2,3,4,5,6,0,0,1,1,2,3,4,1,2,1,2,0,1,6,6,0,6,0,3,4,5,5,6,2,3,6,0,2,2,3,3,4,4,5,0,1,0,1,0,1,3,3,4,5,6,6,0,5,5,6,1,3,5,6,6,0,2,4,1,2,5,6,5,5,4,5,2,6,5,6,6,2,3,6,0,6,2,6,0,5,5,6,4,5,5,5,6,3,4,2,0,1,3,4,2,5,3,4,4,1,2,0,1,1,5,2,3,2,4,4,5,5,0,1,2,1,2,4,5,6,0,1,1,2,4,1,2,2,1,6,0,0,3,4,5,6,3,6,0,2,3,4,5,0,1,1,0,1,3,4,6,0,5,6,1,6,6,3,4,3,4,2,3,5,1,2,6,4,1,2,0,0,0,4,1,1,1,5,2,1,4,2,0,1,0,4,0,1,6,4,3,6,4,0,6,6,4,3,3,0,5,4,6,0,4,2,4,4,6,1,3,4,6,4,4,3,2,2,6,1,5,2,5,6,0,3,3,3,6,1,2,1,4,2,6,5,3,4,6,2,3,6,0,5,2,3,0,1,1,1,4,5,2,2,2,6,3,1,2,5,3,0,1,2,1,1,2,0,5,4,0,4,5,1,0,6,0,5,4,3,4,1,6,4,5,0,1,2,3,5,5,5,0,2,4,4,5,0,5,4,5,4,3,3,0,2,5,6,3,6,6,0,1,4,3,4,4,0,1,2,3,2,3,5,2,2,4,6,6,1,3,2,4,1,4,3,5,0,2,4,5,5,6,1,3,0,1,4,5,4,4,3,4,1,5,4,5,5,1,2,5,6,6,5,1,5,6,4,4,5,3,4,4,4,5,2,3,1,6,0,2,3,1,4,2,3,3,0,1,6,0,0,4,1,2,1,3,3,4,6,0,1,0,1,3,4,5,6,0,1,3,0,1,1,0,5,6,6,2,3,4,5,2,5,6,1,2,3,4,6,0,0,6,0,2,3,5,6,4,5,6,1,4,4,5,2,0,3,4,2,3,3,3,0,4,3,4,4,1,4,5,4,0,5,3,4,2,3,3,4,1,2,0,6,1,2,0,3,2,2,0,5,6,6,3,0,1,0,2,2,3,5,0,6,0,2,4,5,6,0,2,0,0,6,4,5,0,5,2,3,4,1,5,0,1,0,2,3,6,6,6,1,2,4,5,3,4,3,5,1,2,6,6,4,1,0,0,0,4,1,1,1,5,2,1,4,2,0,1,0,0,1,6,3,4,3,6,4,0,6,1,6,4,3,3,0,5,4,6,0,2,4,4,6,1,3,4,6,4,4,3,2,2,6,1,5,2,5,6,0,3,3,3,6,1,2,1,1,1,0};
static const short Gen_shift_values_BG1_Z_8[2109]= {1,1,1,0,4,6,0,1,6,0,6,4,3,3,6,3,3,6,4,1,4,5,5,4,2,7,0,2,2,4,6,4,6,7,5,3,5,6,5,5,0,5,2,4,0,2,2,3,0,6,5,7,2,4,3,5,4,3,2,6,2,6,4,7,6,3,3,1,2,2,2,1,4,5,7,1,1,2,7,1,6,7,5,4,4,7,4,3,4,7,5,1,2,5,6,6,5,3,0,1,3,2,3,5,7,4,5,7,0,5,6,4,6,6,7,6,6,0,1,6,3,5,1,3,2,3,4,1,6,7,6,0,3,5,4,5,6,5,4,2,3,7,3,6,7,5,0,6,7,4,4,2,2,1,2,0,1,5,6,7,0,1,2,7,0,1,7,5,3,4,4,6,7,3,4,4,7,4,5,2,4,5,5,6,6,4,5,2,3,0,0,1,2,3,3,5,6,7,5,6,7,7,0,6,4,5,6,7,6,5,6,1,5,6,2,3,5,0,1,2,3,3,4,0,1,7,6,7,0,3,4,5,3,4,6,4,5,3,4,3,7,2,3,7,4,5,7,0,7,4,3,4,2,2,2,0,1,5,7,0,1,2,7,1,7,5,3,4,4,7,3,4,4,7,5,2,5,5,6,6,5,2,3,0,1,2,3,3,5,7,5,7,7,0,6,4,5,6,7,6,5,6,1,6,2,3,5,1,2,3,3,4,1,7,6,7,0,3,5,3,4,6,5,3,4,3,7,3,7,5,7,0,7,4,3,4,4,5,4,4,4,3,4,7,1,3,3,4,1,3,1,7,6,1,6,1,6,6,1,7,4,7,0,0,7,5,2,3,5,5,7,1,7,1,2,0,6,0,1,0,0,6,3,0,5,7,3,5,5,6,3,1,0,2,3,5,7,6,0,7,6,5,1,5,1,7,2,1,6,6,2,6,5,3,2,3,2,4,2,3,3,6,6,6,7,2,4,2,4,2,3,4,1,2,3,7,5,7,7,0,1,1,2,3,3,2,4,7,1,1,2,3,7,1,5,7,4,5,6,6,4,6,7,0,1,4,5,6,4,6,7,1,5,6,7,2,4,5,6,7,6,7,0,6,0,5,6,7,3,4,5,0,2,1,2,3,3,4,5,3,5,5,7,7,0,1,5,7,7,0,1,0,1,2,6,0,4,6,6,7,0,7,1,6,0,6,7,0,2,1,3,6,7,0,3,4,5,5,7,1,2,3,3,4,5,3,5,4,6,1,2,3,7,1,6,0,0,1,2,5,3,5,5,6,7,4,5,6,6,0,5,6,7,4,5,6,3,5,7,1,3,4,5,3,7,1,5,6,7,0,1,2,7,1,4,6,4,5,6,4,6,5,4,4,5,5,4,7,1,4,6,7,0,1,5,7,0,5,0,5,0,4,7,4,0,2,3,2,5,4,7,0,5,7,0,2,5,4,7,2,4,5,0,3,7,2,7,2,2,5,7,2,7,1,2,2,5,0,3,5,7,0,0,3,1,4,1,4,0,3,6,1,3,6,4,7,6,1,6,0,1,0,3,2,5,0,2,3,2,5,3,6,1,3,4,7,2,1,4,2,4,5,1,4,1,4,2,4,6,7,1,4,6,1,0,3,4,7,6,1,6,0,1,7,2,4,7,2,4,5,1,4,3,6,5,6,1,0,3,7,2,1,3,4,0,3,7,2,6,0,1,2,5,6,1,2,4,5,0,3,3,6,2,4,5,7,2,7,2,5,7,1,4,7,1,6,7,0,0,0,7,0,2,3,5,7,7,0,5,7,4,5,3,2,7,2,5,2,1,2,5,3,7,0,3,4,4,3,1,6,6,7,1,0,1,3,5,2,3,5,6,3,4,2,4,4,5,4,4,6,7,4,1,3,7,1,0,1,2,7,4,5,4,6,1,3,2,3,4,3,2,0,1,5,1,4,5,3,6,0,4,5,2,2,5,6,5,6,7,4,5,5,5,3,4,7,0,2,3,4,7,5,2,4,2,0,6,7,7,2,6,7,7,2,0,5,0,0,1,1,0,5,6,3,4,5,6,6,0,2,0,2,2,3,0,1,7,0,1,2,1,0,1,4,1,5,6,6,0,4,5,6,6,7,4,2,1,2,3,6,0,6,7,1,0,6,7,2,6,2,6,2,0,2,3,2,7,6,7,3,3,3,2,6,0,2,7,3,0,2,0,6,5,0,5,0,5,5,0,6,3,6,7,7,6,4,1,2,4,4,6,0,6,0,1,7,5,7,0,0,7,7,2,7,4,6,2,4,4,5,2,0,7,1,4,6,5,7,6,5,4,0,4,0,6,1,2,0,5,5,6,3,2,0,7,1,0,7,2,2,3,0,7,6,7,1,1,1,0,6,4,6,0,1,6,0,6,4,3,1,3,6,3,3,6,4,1,4,5,5,4,2,7,0,2,2,4,6,0,4,6,7,5,3,5,6,6,5,5,0,5,2,4,0,2,2,3,0,6,5,7,2,4,3,5,4,3,2,6,2,6,4,7,6,3,3,0,0,4,2,2,7,5,3,5,3,2,1,7,7,7,7,6,7,2,4,6,7,4,6,4,2,1,5,1,4,1,3,1,4,2,7,2,3,3,2,0,5,6,0,0,2,4,2,4,5,3,1,3,3,4,3,3,6,3,0,2,6,0,0,1,6,4,3,5,0,2,1,3,2,1,0,4,0,4,2,5,4,1,1,6,7,3,5,2,2,6,4,0,7,1,7,4,4,6,0,0,0,6,7,3,5,6,7,5,0,5,7,5,3,1,2,2,5,1,2,2,5,3,0,3,3,4,4,3,0,1,6,7,0,1,1,3,5,3,5,5,6,4,2,3,4,5,4,3,4,7,4,0,1,3,7,0,1,3,1,2,7,5,4,5,6,1,3,1,2,4,3,1,2,3,1,5,1,5,3,5,6,5,2,1,2,3,3,2,3,1,2,7,6,7,0,1,2,3,0,1,2,0,6,4,5,5,7,0,4,5,5,0,5,6,3,5,6,6,7,7,5,6,3,4,1,1,2,3,4,4,6,7,0,6,7,0,0,1,0,7,5,6,7,0,7,6,7,2,6,7,3,4,7,6,1,2,3,4,4,5,1,2,0,7,0,1,4,5,6,4,5,7,5,6,4,5,4,0,3,4,0,5,6,0,1,0,5,4,5,5,7,5,7,5,7,4,5,6,0,2,2,4,4,5,6,6,5,7,2,4,4,6,2,4,0,2,7,0,1,7,1,2,4,7,0,1,7,1,2,4,0,2,5,7,0,2,1,2,3,1,3,0,2,6,7,0,0,3,5,4,6,6,7,0,6,0,0,2,2,4,0,2,2,4,3,4,5,1,3,7,1,1,2,3,2,4,1,3,1,2,3,4,6,1,3,6,7,0,0,2,4,6,6,7,0,6,0,7,1,4,6,2,4,1,3,3,4,5,6,0,0,2,7,0,1,1,3,0,2,7,0,1,6,0,2,4,6,0,2,4,0,2,3,4,5,2,4,7,1,7,0,1,3,3,2,3,1,2,4,6,7,0,1,2,3,0,1,2,0,6,4,5,5,7,0,4,5,5,0,5,6,3,5,6,6,7,7,5,6,3,4,1,1,2,3,4,4,6,7,0,6,7,0,0,1,7,5,6,7,0,7,6,7,7,2,6,7,3,4,6,1,2,3,4,6,4,5,1,2,0,7,0,1,4,5,6,4,5,7,5,6,4,5,4,0,3,4,0,5,6,0,1,0,5,4,5,1,2,0,2,6,6,3,6,0,0,0,7,3,5,7,0,0,5,7,5,3,2,2,5,2,2,5,3,0,3,4,4,4,3,1,6,7,1,1,3,5,3,5,6,4,2,4,5,4,4,6,7,4,1,3,7,1,1,2,7,5,4,6,1,3,2,4,3,2,1,5,1,5,3,6,5,2,2,4,0,2,7,3,4,4,4,3,6,7,1,3,5,3,4,1,3,0,1,7,6,6,1,6,5,6,1,7,3,4,7,0,0,7,5,2,3,5,4,5,7,1,6,7,1,2,7,0,6,0,0,1,0,0,2,3,0,5,3,7,3,5,4,5,6,3,0,1,0,2,5,7,6,7,0,7,6,4,5,1,5,0,1,7,2,0,1,6,6,6,6,4,2,4,2,4,7,4,0,4,6,4,2,6,3,3,2,3,1,2,4,6,7,0,1,2,3,0,1,2,0,6,4,5,5,7,0,4,5,4,5,0,5,6,3,5,6,6,7,7,5,6,3,4,1,1,2,3,4,4,6,7,0,6,7,0,0,1,7,5,6,7,0,7,6,7,2,6,7,3,4,6,1,2,3,4,4,5,1,2,0,7,0,1,4,5,6,4,5,7,5,6,4,5,4,0,3,4,0,5,6,0,1,0,5,4,5,5,5,5,3,4,0,2,3,4,6,5,2,4,2,0,6,7,7,2,6,7,7,2,0,5,0,0,1,1,0,5,6,3,4,5,6,6,0,2,0,2,2,3,1,7,0,1,2,1,0,1,4,1,5,6,0,4,5,6,6,7,4,2,1,2,3,2,6,0,6,7,1,0,6,7,4,6,2,6,2,0,2,3,2,7,6,7,6,6,6,5,2,1,3,5,6,3,5,3,1,0,0,3,0,0,3,1,6,1,2,2,1,7,4,4,5,7,7,1,3,2,1,3,4,2,0,2,3,2,2,5,2,7,1,5,7,7,0,5,3,2,4,7,1,0,2,1,0,7,3,7,3,1,4,3,0,0,4,6,6};
static const short Gen_shift_values_BG1_Z_9[2109]= {3,7,5,6,8,4,0,7,8,3,5,6,3,3,6,8,2,6,8,3,3,0,3,1,5,3,8,7,1,8,8,8,2,4,7,0,8,8,5,2,6,1,8,8,3,6,7,7,8,8,4,7,2,8,2,4,7,8,8,2,1,0,8,4,8,1,8,3,4,8,6,7,8,0,5,1,7,8,0,4,5,6,7,4,4,7,0,2,3,7,0,3,4,4,1,4,2,6,4,0,8,1,2,0,0,8,0,3,5,7,8,1,0,8,0,6,3,6,7,2,0,0,4,7,7,8,8,0,8,0,5,8,3,0,3,4,5,8,0,8,0,3,2,0,1,0,5,8,0,2,0,4,8,5,6,6,7,0,4,5,0,1,8,0,3,4,6,7,3,4,4,6,7,8,0,3,7,8,0,4,3,4,0,1,4,1,2,5,6,4,8,0,7,8,2,0,8,0,0,2,3,4,5,8,1,8,0,0,6,2,3,7,1,2,8,0,0,3,4,6,7,8,8,8,0,0,5,7,8,3,8,0,2,3,5,7,8,8,0,0,3,1,2,1,8,0,4,5,0,2,8,0,4,8,6,6,7,0,5,0,1,8,0,4,6,7,3,4,4,7,8,0,3,7,0,4,4,0,1,4,2,5,6,4,0,7,8,2,0,0,0,3,4,5,8,1,8,0,0,6,2,3,7,2,8,0,0,4,6,7,8,8,0,0,5,7,8,3,0,2,3,5,8,8,0,0,3,2,1,0,4,5,0,2,8,0,2,0,3,7,5,6,8,8,4,0,0,7,8,3,5,6,3,8,3,6,8,2,6,8,3,3,0,3,1,5,3,8,7,1,8,8,8,2,4,7,0,8,8,5,2,3,6,1,8,8,3,6,7,7,8,8,4,7,1,2,8,2,4,7,8,8,2,1,0,8,4,8,1,8,6,7,8,6,8,4,5,6,8,6,8,0,3,4,1,8,4,3,8,1,5,6,2,6,7,8,4,0,0,4,5,5,0,1,8,3,8,4,0,8,3,4,1,6,2,7,8,3,4,8,8,4,2,6,7,4,8,0,7,3,2,7,4,8,0,8,4,8,3,4,5,0,1,8,4,6,1,2,1,5,6,8,4,4,8,0,3,7,8,6,2,4,0,4,8,0,4,0,7,2,3,0,4,5,3,8,5,1,4,8,0,4,0,1,6,7,2,3,4,2,7,6,1,2,4,8,0,4,0,8,3,4,2,6,7,3,8,3,8,4,8,0,4,0,0,5,3,7,8,7,7,3,4,8,0,7,2,3,0,5,3,7,8,4,8,0,4,0,7,3,6,1,2,0,5,1,4,8,0,0,4,5,4,0,6,2,4,8,0,5,8,5,2,7,8,5,3,1,6,0,0,5,8,2,6,2,3,1,7,8,5,0,6,0,2,7,8,7,4,3,0,4,1,6,7,2,8,6,3,8,4,5,0,6,6,3,6,3,0,6,2,8,5,1,2,0,6,2,8,6,2,3,6,3,3,0,6,3,4,1,8,5,6,3,2,8,1,7,4,0,1,2,8,2,8,2,7,8,5,2,7,4,1,6,7,3,0,2,8,2,7,8,8,5,5,2,3,0,5,6,4,1,2,8,2,8,6,3,0,6,1,6,7,1,7,2,8,2,7,8,7,4,1,7,0,5,2,2,8,5,2,7,3,4,1,7,2,8,2,7,8,5,2,4,1,3,8,0,2,8,7,4,2,7,8,4,1,2,8,2,8,8,0,6,3,8,3,4,8,6,7,5,8,0,5,1,7,8,0,4,5,6,7,4,8,4,7,0,2,3,7,0,3,4,4,1,4,2,6,8,4,0,8,1,2,0,0,8,0,3,5,7,8,1,0,8,0,6,3,6,7,2,0,0,4,7,7,8,8,0,8,0,5,8,3,0,3,4,5,8,0,8,0,3,2,0,1,0,5,1,8,0,2,0,8,5,0,6,8,6,5,0,7,7,8,7,1,6,1,2,8,0,1,5,7,8,4,5,5,8,0,1,4,8,1,5,5,1,2,5,3,6,7,5,1,8,0,3,1,1,1,4,5,6,2,0,2,0,1,1,7,3,4,8,3,0,1,8,1,5,7,8,0,0,1,1,6,8,0,4,1,3,4,6,0,0,1,4,1,4,3,2,1,5,6,1,3,0,1,3,7,5,6,8,4,0,8,7,8,3,5,6,3,3,3,6,8,2,6,8,3,3,0,3,1,5,3,8,7,1,8,8,8,2,4,7,0,8,8,8,5,2,6,1,8,8,3,6,7,7,8,8,4,7,2,8,2,4,7,8,8,2,1,0,8,4,8,8,1,8,8,1,8,8,8,7,6,8,6,8,8,8,0,8,8,6,1,8,0,3,2,7,3,1,2,6,8,0,6,8,6,0,2,5,0,2,6,6,3,6,4,8,6,2,1,4,2,2,8,2,5,7,1,3,2,8,2,8,5,0,4,2,2,6,0,1,1,2,2,7,1,5,2,5,7,1,2,2,5,4,3,2,7,2,4,2,0,0,4,8,8,8,8,8,4,8,8,8,2,3,7,5,6,1,8,4,0,7,8,3,5,6,3,0,3,6,8,8,2,6,8,3,3,0,3,1,5,3,8,7,1,8,8,8,2,4,7,0,8,4,8,5,2,6,1,8,8,3,6,7,7,8,8,4,7,2,8,2,4,7,8,8,2,1,0,8,4,8,1,8,6,8,8,2,8,8,8,6,8,8,8,4,8,1,7,1,5,3,3,4,6,2,6,7,8,5,6,1,3,4,0,1,1,4,5,6,0,4,6,1,1,6,7,1,8,2,3,1,6,4,5,8,6,6,6,0,1,2,5,7,5,6,6,3,8,0,4,8,5,6,6,1,3,4,8,5,5,6,6,2,4,5,0,6,8,0,2,5,5,6,8,6,0,8,7,6,1,2,6,8,5,6,6,1,7,8,8,0,8,2,6,7,2,3,1,2,5,6,8,0,5,6,6,8,0,1,2,5,0,1,2,6,5,6,2,3,6,3,4,7,8,6,1,2,0,1,4,2,1,2,2,4,5,6,7,8,1,3,1,2,2,8,4,5,0,3,4,1,2,8,2,5,6,8,0,1,1,1,2,2,7,0,1,5,1,2,4,5,7,0,1,1,2,2,5,3,4,3,1,2,6,7,2,4,1,2,7,5,2,0,0,7,1,7,8,3,1,8,6,4,1,2,8,2,0,3,1,7,5,0,7,1,8,7,4,5,7,5,1,8,3,0,1,6,4,1,8,3,1,7,5,7,5,4,1,2,7,5,5,3,0,6,7,8,7,5,3,1,2,8,0,5,3,3,1,3,1,3,1,6,4,8,5,6,2,0,4,2,3,0,1,3,1,0,7,6,3,4,1,8,5,3,3,0,1,3,1,7,5,1,7,8,2,0,2,0,3,1,3,1,8,6,2,8,0,6,4,3,1,6,3,4,8,6,2,0,3,0,1,3,1,6,4,5,3,4,2,3,1,8,5,6,3,1,5,3,3,0,1,4,8,5,6,6,7,8,0,4,5,0,1,8,0,3,4,6,7,3,4,4,6,7,8,0,3,7,8,0,4,3,4,0,1,4,1,2,5,6,4,8,0,7,8,2,0,8,0,0,2,3,4,5,8,1,8,0,0,6,2,3,3,7,1,2,8,0,0,3,4,6,7,8,8,8,8,0,0,5,7,8,3,8,0,2,3,5,7,8,8,0,0,3,1,2,1,8,0,4,5,0,2,8,0,8,8,3,8,7,8,8,8,1,5,3,4,6,2,7,0,5,6,1,3,4,1,1,4,6,0,4,6,1,1,7,7,1,8,3,1,6,5,8,6,6,6,0,2,5,7,6,6,3,0,8,4,8,6,6,1,4,5,5,6,6,2,5,0,6,0,2,5,6,6,0,8,7,6,2,6,8,6,8,6,8,8,3,4,8,6,7,8,0,5,1,8,7,8,0,4,5,6,7,4,4,7,0,2,3,7,0,3,4,4,1,4,2,6,4,0,8,1,2,0,0,8,0,3,5,7,8,1,0,8,0,6,3,6,7,2,0,8,0,4,7,7,8,8,0,8,0,5,8,3,0,3,4,5,8,0,8,0,3,2,0,1,0,5,8,0,2,0,0,8,8,8,8,8,2,8,8,8,1,8,8,8,2,3,7,4,5,5,6,8,8,3,4,8,0,7,8,2,3,5,6,2,3,3,5,6,7,8,8,2,6,7,8,3,2,3,8,0,3,0,1,4,5,3,7,8,6,7,1,8,7,8,8,1,2,3,4,7,0,7,8,8,5,1,2,6,0,1,7,8,8,2,3,5,6,7,7,7,8,8,4,6,7,2,7,8,1,2,4,6,7,7,8,8,2,0,1,0,7,8,3,4,8,1,7,8,4,8,6,6,7,0,5,0,1,6,8,0,4,6,7,3,4,4,7,8,0,3,7,0,4,4,0,1,4,2,5,6,4,0,7,8,2,0,0,0,3,4,5,8,1,8,0,0,6,2,3,7,2,8,0,0,4,6,7,8,8,0,0,5,7,8,8,3,0,2,3,5,8,8,0,8,0,3,2,1,0,4,5,0,2,8,0,6,1,8,0,8,2,7,3,1,2,6,8,0,6,6,0,2,5,0,2,6,6,3,6,4,8,8,6,2,1,4,2,2,8,2,5,7,1,3,2,2,8,5,0,4,2,2,6,0,1,1,2,2,7,1,5,2,5,7,1,2,2,5,4,3,2,7,2,4,2,5,8,8};
static const short Gen_shift_values_BG1_Z_10[2109]= {2,2,7,9,4,6,7,2,3,9,8,6,9,0,9,6,9,0,7,8,6,0,2,1,4,3,9,8,4,9,0,1,5,0,4,8,2,3,9,2,2,4,3,5,2,2,7,5,0,9,1,3,2,3,7,2,5,6,5,9,9,8,5,8,1,0,7,2,3,3,8,0,4,5,7,8,2,3,4,0,8,9,7,0,1,0,7,9,0,1,8,8,9,7,1,3,2,5,4,0,9,4,5,0,1,1,2,6,1,4,5,9,3,3,4,0,3,2,3,5,4,6,3,3,7,8,6,1,9,0,2,4,3,4,8,2,3,6,7,5,6,0,0,8,9,6,9,1,2,1,8,3,3,7,8,9,0,5,6,7,7,8,3,4,9,0,9,7,9,0,1,9,0,6,7,0,1,7,8,9,6,7,0,1,3,1,2,4,5,4,9,0,8,9,5,0,0,1,2,5,6,0,1,5,9,2,3,4,0,2,3,3,4,5,3,4,6,2,3,2,3,8,6,0,1,0,2,3,4,3,3,4,7,8,3,5,6,6,7,6,0,9,0,9,5,6,8,9,2,1,7,8,3,3,8,9,0,5,7,7,8,3,4,0,9,7,9,0,1,0,6,7,0,1,8,9,7,0,1,3,2,4,5,4,0,8,9,5,0,1,2,6,0,1,5,9,2,3,4,0,2,3,3,5,3,4,6,3,2,3,8,6,1,0,2,3,4,3,4,7,8,3,6,6,7,6,0,0,9,6,8,9,2,1,7,8,2,4,1,1,6,8,2,3,5,6,1,1,2,8,7,5,8,9,9,8,5,8,9,6,7,5,9,1,0,3,2,8,7,3,8,9,0,4,9,3,7,1,2,8,1,7,1,3,2,4,1,1,6,4,9,8,0,2,0,1,2,6,1,4,5,4,8,8,7,4,7,0,9,6,6,8,0,2,2,1,1,7,4,1,7,6,9,4,5,7,7,7,7,2,1,2,4,3,4,4,9,9,1,0,1,2,1,2,2,7,7,8,8,4,3,4,3,3,1,1,4,3,4,9,5,5,4,3,4,1,0,1,4,4,5,5,2,1,2,3,3,1,0,1,5,4,5,7,7,6,5,6,9,8,9,8,8,4,3,4,3,2,3,9,9,4,4,5,4,5,6,6,0,9,0,5,4,5,9,9,3,3,7,6,7,8,8,4,4,7,6,7,0,7,7,9,8,9,8,7,8,0,0,7,6,7,7,6,7,2,2,0,0,5,4,5,4,4,6,6,8,7,8,5,7,7,8,7,8,2,1,2,7,7,0,9,0,1,0,1,0,0,4,4,4,3,4,9,3,3,0,9,0,3,2,3,6,6,5,5,2,1,2,8,8,3,5,5,0,6,4,8,3,9,0,4,0,0,5,2,3,5,3,0,8,2,0,5,7,4,5,9,7,0,8,6,5,2,3,6,4,2,0,1,8,9,9,7,2,0,3,1,2,0,9,7,2,9,0,3,1,0,8,1,8,9,9,7,3,1,5,3,4,2,7,5,6,4,2,0,1,9,7,4,5,2,0,3,1,4,1,2,8,6,3,1,7,4,5,1,9,5,3,6,3,4,2,0,5,3,9,5,2,3,7,5,6,4,8,6,5,3,5,3,0,7,8,8,6,3,1,2,9,0,4,2,6,4,8,5,3,6,4,0,8,5,2,3,8,6,9,7,8,5,6,2,0,2,0,1,8,9,8,6,1,9,4,1,2,3,1,0,8,6,8,4,8,7,4,1,9,0,0,5,7,8,1,2,4,5,9,0,1,7,5,6,4,7,1,8,7,4,6,7,8,5,5,6,4,8,0,9,2,2,1,7,6,1,2,7,8,8,9,3,8,1,2,6,0,0,1,7,0,9,0,2,1,3,0,0,4,5,3,8,6,7,9,1,0,1,5,9,0,3,4,2,3,7,7,5,6,3,6,9,8,9,8,5,7,8,3,0,8,7,4,4,9,0,1,8,6,8,8,9,9,4,5,1,0,8,0,1,2,1,7,8,1,2,9,0,8,1,2,4,3,5,6,5,1,9,0,6,1,2,3,7,1,2,9,6,0,3,4,5,1,3,4,4,6,4,5,9,7,4,3,4,9,7,2,1,3,4,5,4,5,8,9,4,7,7,8,3,7,1,1,0,7,9,0,3,2,8,9,2,2,7,9,4,6,7,8,2,3,9,8,6,9,9,0,9,6,9,0,7,8,6,0,2,1,4,3,9,8,4,9,0,1,5,0,4,8,2,4,3,9,2,2,4,3,5,2,2,7,5,0,9,1,3,2,3,7,2,5,6,5,9,9,8,5,8,4,1,0,7,6,6,7,0,7,9,3,0,0,4,3,0,0,9,0,2,2,7,9,0,4,6,7,2,3,9,8,6,9,1,0,9,6,9,0,7,8,6,0,2,1,4,3,9,8,4,9,0,9,1,5,0,4,8,2,9,3,9,2,2,4,3,5,2,2,7,5,0,9,1,3,2,3,7,2,5,6,5,9,9,8,5,8,1,0,7,8,4,1,2,2,6,9,4,5,8,9,2,4,3,3,8,0,8,5,7,8,3,4,0,9,7,0,9,1,0,7,9,0,1,8,9,7,1,3,2,5,4,0,9,5,0,1,2,6,1,5,9,3,6,4,0,3,3,5,4,6,3,3,8,6,1,0,2,4,3,4,8,3,6,7,6,0,0,9,6,9,2,1,8,1,4,5,5,9,9,7,6,9,8,3,0,2,9,3,2,2,7,8,9,4,6,6,7,6,2,3,9,8,6,8,9,0,9,5,6,9,0,7,8,6,9,0,2,1,3,4,3,9,7,8,4,9,0,1,5,9,0,4,8,1,2,3,9,1,2,2,4,2,3,5,2,1,2,7,7,5,0,9,1,2,3,2,3,6,7,2,5,5,6,6,5,9,9,8,5,7,8,1,0,6,7,8,8,2,3,4,5,0,0,1,2,2,3,8,9,4,5,4,2,4,5,6,4,5,1,2,5,6,2,3,4,1,2,5,6,8,6,7,9,0,9,4,5,3,4,0,5,5,6,7,0,1,5,6,2,0,4,7,8,9,5,7,8,8,9,0,8,9,4,1,7,8,7,8,3,1,5,6,5,7,8,9,8,8,9,2,3,8,0,1,1,2,1,5,4,5,4,0,1,3,4,7,6,2,3,8,5,8,5,3,0,5,1,2,0,7,2,9,3,9,0,1,8,5,9,6,5,2,4,1,2,9,5,1,2,6,3,5,2,2,8,9,5,2,6,3,3,0,4,1,2,9,6,2,3,8,5,7,4,0,6,7,7,9,6,5,2,4,0,1,0,7,5,2,6,3,7,4,1,8,6,2,3,0,7,4,1,8,4,5,9,6,5,2,8,4,5,8,5,0,7,9,5,6,1,8,8,5,8,4,5,3,0,1,8,6,3,5,2,7,4,9,5,6,8,5,9,6,3,9,0,8,5,1,8,2,8,9,1,8,5,2,5,2,4,1,1,8,4,0,1,7,4,6,3,3,9,0,0,0,4,5,6,7,9,2,3,4,4,5,0,1,6,7,6,4,6,7,8,6,7,3,4,7,8,4,5,6,3,4,7,8,0,8,9,1,2,1,6,7,5,6,2,7,7,8,9,2,3,7,8,2,6,9,0,1,7,9,0,1,0,1,2,0,1,3,9,0,9,0,0,5,3,7,8,7,9,0,1,0,0,1,4,5,0,2,3,3,4,3,7,6,7,6,2,3,5,6,9,8,4,5,9,9,9,2,6,5,4,3,7,7,2,4,9,1,2,6,7,8,4,3,1,4,5,4,1,4,5,2,3,1,5,7,7,6,9,8,4,3,9,4,5,6,0,5,9,3,7,8,4,7,4,7,9,8,0,7,7,2,0,5,4,6,8,7,8,2,7,0,1,0,4,4,3,0,3,6,5,2,8,8,7,9,7,8,8,3,5,9,0,2,3,7,7,8,9,5,3,4,2,5,6,5,2,4,5,6,3,3,4,2,6,8,7,0,9,5,4,9,0,5,6,6,7,1,6,9,0,4,8,8,9,5,8,7,8,0,9,4,1,8,8,2,3,1,6,4,5,7,9,8,9,3,7,8,1,2,0,1,5,5,3,4,1,4,6,7,6,3,0,8,3,0,1,6,1,7,1,9,6,3,6,3,6,9,9,3,4,5,6,5,1,2,3,3,4,9,0,5,6,5,3,5,6,7,5,6,2,3,4,6,7,3,4,5,2,3,6,7,9,7,8,0,1,0,5,6,4,5,1,6,6,7,8,1,2,6,7,1,5,8,9,0,6,8,9,9,0,1,9,0,2,8,9,8,9,4,2,6,7,6,8,9,0,9,9,0,3,4,9,1,2,2,3,2,6,5,6,5,1,2,4,5,8,7,3,4,5,5,0,1,2,7,9,9,0,7,5,6,2,1,9,1,2,3,2,8,9,2,3,0,1,9,2,3,5,4,6,7,6,2,0,1,7,2,3,4,8,2,3,7,1,4,5,6,2,4,5,5,7,5,6,8,5,4,5,0,8,3,2,4,5,6,8,5,6,9,0,5,8,8,9,5,8,2,2,1,8,0,1,4,3,9,0,2,2,7,9,3,4,6,7,2,3,9,8,6,9,0,9,6,9,0,7,8,6,0,2,1,4,6,3,9,8,4,9,0,8,1,5,0,4,8,2,3,9,2,2,4,3,5,2,2,7,5,0,9,1,3,2,3,7,2,5,6,5,9,9,8,5,8,1,0,7,0,7,5};
static const short Gen_shift_values_BG1_Z_11[2109]= {7,10,5,8,7,1,5,1,4,3,10,7,4,7,4,3,8,3,0,10,0,6,1,6,0,4,5,2,0,5,7,7,5,6,0,1,3,8,10,3,2,10,4,3,10,8,8,10,3,5,3,6,0,9,5,6,8,10,1,8,0,2,6,10,0,4,10,7,8,0,6,9,7,8,2,6,1,2,5,4,10,0,8,5,8,5,4,8,9,4,1,10,0,1,7,2,7,1,5,6,3,0,1,6,8,7,8,6,7,0,1,2,4,8,9,0,4,2,3,0,5,4,0,9,8,9,0,4,5,6,4,7,1,10,6,6,7,9,0,1,2,9,1,2,3,7,0,0,1,5,0,8,0,5,6,8,9,8,1,2,5,6,2,5,3,4,0,8,4,5,8,4,5,3,4,9,4,0,1,0,0,1,6,7,2,6,7,0,1,5,5,6,2,3,1,6,7,8,8,5,6,6,7,1,2,3,4,9,0,3,4,3,10,0,4,5,4,10,0,8,9,9,0,3,4,6,4,6,7,1,9,10,5,6,7,8,9,10,0,2,9,0,1,3,6,7,10,0,1,5,10,0,8,0,6,8,9,8,2,5,6,2,5,4,0,8,4,5,8,5,3,4,9,4,1,0,1,6,7,2,7,0,1,5,6,2,3,1,6,8,8,6,6,7,1,2,3,4,9,0,3,4,3,0,4,5,4,0,8,9,9,0,4,6,4,6,7,1,10,5,6,7,9,10,0,2,9,1,3,7,10,0,1,5,10,0,8,2,4,7,2,5,9,4,9,2,8,9,1,0,7,4,1,8,4,1,0,5,0,8,7,8,3,9,3,8,1,2,10,8,2,4,4,2,3,8,9,0,5,7,0,2,10,7,1,0,7,5,5,7,0,2,0,3,8,8,6,2,3,5,7,9,5,8,10,3,7,8,1,7,4,7,6,10,10,6,6,8,7,2,3,3,10,5,5,2,10,5,2,0,7,8,3,10,0,6,2,10,7,3,4,0,7,8,8,7,4,10,7,9,5,6,5,2,2,10,10,6,7,10,2,10,10,6,7,9,5,6,3,0,9,6,6,2,3,5,2,6,2,3,1,8,9,7,4,1,8,9,6,2,3,10,7,0,7,8,8,4,5,6,3,0,8,2,9,10,2,10,0,7,8,1,8,9,6,3,7,4,9,5,6,3,0,5,2,9,5,6,3,8,5,5,1,2,10,6,7,9,6,5,1,2,3,10,0,3,0,5,2,9,5,6,0,8,9,6,1,8,9,3,6,3,4,0,1,0,7,8,1,9,3,10,0,5,1,2,7,4,3,0,6,2,3,5,8,5,1,8,9,5,1,2,6,3,10,7,5,1,2,3,1,10,6,0,3,8,0,6,9,10,4,10,4,2,4,1,2,7,5,2,0,5,3,2,4,1,2,9,7,2,0,2,9,6,7,1,10,0,9,7,4,5,4,2,1,10,4,2,1,10,0,9,5,2,3,0,9,8,6,7,4,5,8,6,3,1,9,7,3,1,8,6,1,10,2,0,10,8,8,5,6,2,0,4,2,4,1,2,2,0,3,1,8,5,6,9,7,0,9,5,2,3,7,5,0,9,1,10,7,8,7,5,1,10,0,9,7,5,5,3,5,2,3,7,5,0,9,2,10,0,0,9,3,1,9,8,6,6,4,2,0,3,0,1,5,3,7,5,9,6,7,5,3,8,6,10,7,8,3,1,7,5,8,5,6,1,10,7,5,0,1,7,9,10,10,9,0,1,4,10,2,2,0,1,6,10,5,6,9,8,3,4,1,9,8,1,9,8,1,2,8,5,3,4,5,0,6,0,5,0,9,10,7,4,5,10,1,0,1,10,0,4,5,6,8,1,2,4,8,6,7,4,9,8,4,2,1,2,4,8,9,10,8,0,5,3,10,10,0,2,4,5,6,2,5,6,7,0,4,5,4,5,9,4,10,2,1,1,10,0,0,3,9,0,1,10,0,5,8,9,6,5,8,7,3,0,7,8,0,8,6,7,1,7,4,3,4,9,10,5,10,3,4,8,9,5,6,4,9,0,0,9,9,10,3,4,5,6,7,1,3,6,7,6,3,7,8,3,7,3,0,1,1,3,7,9,7,9,10,4,2,8,9,10,1,2,3,10,5,1,4,6,10,2,3,4,8,2,3,0,3,9,1,0,5,9,2,5,8,7,3,0,8,6,0,8,7,1,7,4,3,4,10,5,10,4,8,9,6,4,9,0,0,9,10,4,5,7,1,1,3,7,6,3,8,7,3,1,1,3,7,9,7,10,4,2,9,10,1,3,5,1,4,6,10,3,0,4,8,3,10,7,4,5,2,2,10,3,4,6,9,10,3,4,5,4,7,2,5,0,4,9,2,9,1,0,7,4,1,9,4,1,0,5,0,8,7,8,3,9,3,8,1,2,10,8,2,4,0,4,2,3,8,9,0,1,5,7,0,10,7,1,0,7,5,5,7,0,2,0,3,8,6,2,3,5,7,9,5,8,10,3,7,8,1,7,7,10,4,10,9,4,2,4,2,6,5,4,6,3,6,1,4,4,3,8,1,8,0,10,6,3,0,4,3,0,10,6,4,10,7,6,7,2,8,2,7,0,1,9,7,1,3,3,1,2,7,8,10,1,4,6,10,9,6,0,10,6,4,4,6,10,1,10,2,7,5,1,2,4,6,8,4,7,9,2,6,7,0,6,3,1,0,9,5,6,5,10,2,6,3,2,0,6,1,5,8,3,5,6,5,10,2,3,8,10,2,1,8,5,1,2,5,2,0,1,6,1,9,8,9,3,4,10,4,8,9,2,3,10,0,9,3,5,5,3,3,4,9,10,0,1,6,8,0,1,0,8,1,2,1,8,5,6,4,6,8,1,3,1,3,4,9,7,2,3,4,6,7,8,0,10,6,9,0,4,7,8,9,2,7,8,0,3,8,9,0,1,5,0,4,5,8,9,5,8,6,7,3,0,7,8,0,7,8,6,7,1,7,3,4,3,3,4,9,10,5,9,10,3,4,8,8,9,5,6,4,9,10,0,0,8,9,9,10,4,4,5,6,7,1,3,6,7,6,2,3,7,8,6,7,2,3,0,1,1,3,6,7,9,7,9,10,4,1,2,8,9,10,0,1,2,3,5,1,3,4,6,9,10,2,3,4,8,2,3,0,10,3,2,9,8,1,10,0,0,10,5,4,9,7,8,1,5,4,8,7,7,6,3,2,0,10,8,6,7,0,10,8,7,7,5,6,1,0,7,6,4,3,3,2,4,3,10,8,9,5,4,10,9,4,2,3,10,8,7,9,8,6,4,5,4,3,9,8,0,10,0,10,9,8,10,8,9,4,3,5,4,7,5,6,1,0,3,2,7,5,6,6,5,3,2,8,6,7,7,6,3,2,1,10,0,1,0,3,2,7,6,9,8,7,6,10,8,9,4,3,2,1,9,7,8,10,9,1,0,3,1,2,5,4,1,0,4,3,6,5,10,9,3,1,2,4,3,8,7,3,1,2,3,6,0,1,3,4,9,3,7,8,0,1,8,0,9,10,6,3,10,0,3,10,0,9,10,4,10,6,7,6,6,7,1,2,8,1,2,6,7,0,0,1,8,9,7,1,2,3,3,0,1,1,2,7,8,9,10,4,6,9,10,0,9,5,6,10,0,10,5,6,3,4,7,4,6,9,10,1,10,1,2,7,4,5,0,1,2,3,4,5,6,8,4,6,7,9,1,2,5,6,7,0,5,6,0,6,8,1,4,0,1,9,0,3,9,1,0,5,9,0,5,8,7,3,0,8,0,8,7,1,7,4,3,4,10,0,5,10,4,8,9,6,4,9,0,0,9,10,4,5,7,1,3,7,7,6,3,8,7,3,1,1,3,7,9,7,10,4,2,9,10,1,3,5,1,4,6,10,3,4,8,3,2,3,1,0,4,5,8,3,6,4,5,10,3,10,9,10,2,1,7,8,5,2,5,2,1,5,6,1,9,7,8,9,4,10,4,9,2,3,0,8,9,3,5,4,5,3,4,8,9,10,1,5,6,8,1,10,0,8,2,4,1,8,6,5,6,8,1,2,3,1,4,9,7,3,3,4,6,8,9,10,6,9,10,0,4,8,8,9,2,8,9,8,10,3,4,10,3,7,6,5,2,1,10,2,7,3,6,0,1,3,4,1,3,7,8,0,1,8,0,9,10,6,3,10,0,3,10,0,9,10,5,4,10,6,7,6,6,7,1,2,8,1,2,6,7,0,0,1,8,9,7,1,2,3,3,0,1,1,2,7,8,9,10,4,6,9,10,9,5,6,10,0,10,5,6,3,4,4,6,9,10,1,10,1,2,7,4,5,0,1,2,3,4,5,6,8,4,6,7,9,1,2,5,6,7,0,5,6,10,2,8,10,0,10,4,7,8,0,4,7,6,2,10,6,7,10,7,5,6,0,6,3,2,3,8,9,4,9,2,3,7,8,4,5,3,8,10,10,8,8,9,3,4,5,6,0,2,5,6,5,2,6,7,6,2,10,0,0,2,6,8,6,8,9,2,3,1,7,8,9,0,1,2,8,4,0,3,5,9,1,2,3,7,1,2,4,7,2,5,1,4,9,2,9,1,0,7,4,1,4,1,0,5,0,8,7,8,3,9,3,8,1,1,2,10,8,2,4,6,4,2,3,8,9,0,5,7,0,10,7,1,0,7,5,5,7,0,2,0,3,8,6,2,3,5,7,9,5,8,10,3,7,8,1,7,4,0,3};
static const short Gen_shift_values_BG1_Z_12[2109]= {6,3,0,11,6,9,2,1,3,3,8,0,11,11,7,10,0,11,3,11,4,6,6,2,8,6,3,7,4,9,2,11,8,11,0,6,4,4,5,2,8,7,4,0,3,7,10,2,4,9,5,3,5,10,11,1,11,6,11,6,0,5,0,2,9,3,8,6,7,4,1,0,6,7,10,3,1,2,4,4,8,9,1,0,0,8,11,0,1,0,4,11,0,5,7,7,3,9,7,4,8,4,5,10,3,11,0,9,0,0,1,7,5,4,5,6,3,8,9,8,5,1,4,8,10,11,3,5,9,10,6,4,6,11,0,1,2,0,7,11,0,7,1,5,6,1,3,9,10,4,9,7,4,0,1,11,0,7,9,10,2,3,2,4,3,4,9,1,11,0,0,7,8,10,11,1,0,3,4,0,4,5,6,7,7,2,3,8,9,7,3,4,7,8,5,10,2,3,0,8,9,11,0,1,7,4,5,5,6,2,3,9,7,8,4,5,1,3,4,7,8,11,3,4,5,10,6,3,4,6,10,11,11,0,2,11,0,6,7,0,7,0,1,6,0,1,2,3,10,4,8,9,7,4,1,11,0,7,10,2,3,2,4,4,9,1,11,0,0,8,10,11,1,0,4,0,5,6,7,7,3,8,9,7,4,7,8,5,10,3,0,9,11,0,1,7,4,5,5,6,2,3,9,8,4,5,1,4,7,8,11,3,5,10,6,3,4,6,11,11,0,2,0,6,7,0,7,1,6,1,2,3,10,4,8,9,7,0,7,4,1,0,2,7,10,3,1,2,4,4,9,1,0,6,0,8,11,1,0,4,0,5,7,7,3,9,7,4,8,5,10,3,0,9,0,1,7,5,5,6,3,9,9,8,5,1,4,8,11,3,5,10,6,4,0,6,11,0,2,0,7,0,7,1,6,1,3,10,4,9,2,1,4,0,2,7,0,5,8,8,1,3,8,1,5,1,9,10,6,7,2,3,6,1,2,6,1,9,4,11,0,9,4,5,10,8,4,10,6,10,5,6,3,11,7,3,6,1,2,8,6,2,2,9,10,5,0,1,7,3,6,2,10,5,6,6,2,11,6,7,1,8,9,1,9,9,4,5,3,10,11,1,9,10,5,6,2,9,10,11,7,4,0,9,4,5,6,2,3,10,11,6,1,2,7,3,1,9,11,6,7,11,7,0,8,9,4,5,5,3,11,2,9,10,11,6,7,7,3,10,5,6,2,9,10,5,1,9,5,11,6,7,4,0,0,8,10,5,6,2,0,8,5,0,1,6,1,2,8,4,6,1,2,1,8,9,6,2,1,9,7,2,3,7,0,8,7,2,3,9,4,5,4,0,10,6,3,10,11,7,5,3,8,0,8,2,2,9,4,2,9,2,10,5,4,1,2,1,11,10,8,9,7,11,4,1,2,7,5,0,10,5,11,8,9,1,11,1,11,6,3,4,10,8,9,7,9,7,5,3,8,6,10,7,8,9,7,1,11,9,6,7,2,0,4,2,4,2,0,10,6,4,4,2,1,11,5,3,2,11,0,7,5,0,10,9,6,7,6,4,9,7,10,7,8,4,2,2,0,2,11,0,3,1,0,10,7,6,3,4,5,3,2,0,10,8,1,11,5,3,8,5,6,0,10,2,0,7,4,5,3,1,1,11,10,3,1,8,6,9,7,11,8,9,9,7,4,2,9,6,7,4,2,10,8,3,0,1,10,8,0,10,7,4,5,1,11,6,4,7,4,5,5,3,1,1,4,5,2,11,10,0,4,5,8,1,11,0,2,2,6,7,11,10,8,10,6,9,10,11,10,2,9,10,3,5,5,1,7,1,5,2,6,2,3,8,1,9,10,7,10,10,11,5,3,2,3,4,1,6,7,6,3,11,2,6,8,9,1,3,7,8,4,2,4,9,10,11,0,10,5,9,10,5,11,3,4,11,1,6,7,8,2,7,9,7,4,4,10,11,0,9,6,4,5,0,0,3,7,8,1,7,9,9,2,6,4,5,5,1,3,4,6,5,9,5,10,11,0,0,8,1,2,0,9,0,1,10,3,8,5,2,4,5,5,6,0,9,10,10,11,7,8,2,1,9,10,5,6,9,0,1,4,8,10,3,11,8,9,11,4,4,5,7,5,11,0,6,5,0,6,11,6,7,8,3,9,1,2,3,0,9,8,3,6,11,0,10,0,0,5,9,8,1,8,4,7,9,8,0,8,1,3,3,11,5,3,0,4,1,6,11,8,5,8,9,3,1,8,1,2,11,5,4,1,9,0,4,7,11,1,6,2,0,2,7,8,10,8,3,8,3,9,2,9,11,0,6,0,5,7,2,8,9,2,9,6,3,11,3,0,8,7,1,4,5,2,11,10,6,5,8,1,0,2,2,7,11,10,1,10,6,9,11,10,2,10,3,5,5,1,7,5,2,6,3,8,1,11,10,7,10,11,5,3,4,3,4,1,7,6,3,11,2,6,9,1,3,8,4,2,4,9,10,0,10,5,10,5,11,4,11,1,8,2,7,0,5,3,8,0,5,10,4,9,11,4,0,2,0,9,6,5,9,0,3,8,7,9,9,2,6,5,1,5,1,4,6,6,5,9,5,10,0,0,8,2,0,9,1,10,3,8,5,2,5,6,0,10,2,10,11,8,2,1,10,6,9,1,4,8,10,3,11,9,11,4,5,7,5,0,5,0,6,11,6,8,3,9,2,11,4,10,11,10,8,3,3,1,1,4,5,6,3,9,1,10,7,5,6,1,4,8,9,11,8,10,10,3,7,5,6,6,2,4,5,7,6,10,6,11,0,1,1,9,2,3,1,10,1,2,11,4,9,6,3,5,6,7,1,10,11,11,0,8,9,3,2,10,11,7,10,1,2,4,5,9,11,4,0,9,10,0,5,5,6,8,6,0,1,2,6,1,7,0,7,8,9,4,10,2,3,1,10,6,7,5,6,2,1,3,4,8,9,8,10,9,10,3,7,5,6,6,1,2,4,5,7,6,9,10,6,10,11,0,1,1,8,9,2,3,1,9,10,1,2,11,4,8,9,6,2,3,5,6,0,7,1,10,11,11,0,8,9,3,1,2,10,11,7,7,9,10,1,2,5,9,10,11,4,0,9,10,0,4,5,5,6,8,5,6,0,1,6,1,6,7,0,6,7,8,9,4,10,2,3,0,11,9,8,6,5,5,3,4,0,11,3,2,8,6,7,3,7,6,9,8,9,8,2,1,6,5,5,3,4,5,4,1,0,4,2,3,6,5,5,4,9,8,5,4,10,9,0,10,11,0,11,8,7,2,0,1,10,0,11,9,8,1,11,0,10,9,3,2,8,7,5,4,2,1,5,3,4,6,5,0,11,10,8,9,10,9,11,10,8,6,7,2,1,1,0,10,8,9,6,5,9,8,1,11,0,4,3,8,7,10,9,3,2,11,10,9,7,8,11,10,4,3,5,3,4,7,6,5,4,0,10,11,5,4,0,11,6,5,11,10,6,5,8,6,7,3,2,9,8,2,0,1,6,3,11,0,10,11,5,6,8,9,1,2,1,3,2,3,8,0,10,11,11,6,7,9,10,0,11,2,3,11,3,4,5,6,6,1,2,7,8,6,2,3,6,7,4,9,1,2,11,7,8,10,11,0,6,3,4,4,5,1,2,8,8,6,7,3,4,0,2,3,6,7,6,10,2,3,4,9,5,2,3,5,9,10,10,11,1,10,11,5,6,11,6,11,0,5,11,0,1,2,9,3,7,8,10,7,0,8,1,3,9,11,8,5,2,1,8,11,4,7,3,5,5,10,2,1,1,9,0,2,1,5,1,6,8,10,8,4,10,8,5,9,6,11,4,1,10,1,2,8,6,6,7,4,1,10,9,6,2,5,9,0,4,6,11,7,5,7,0,1,3,1,8,1,8,2,7,2,4,11,5,10,5,0,8,8,1,2,11,8,7,1,2,5,10,4,8,9,11,11,3,4,8,7,7,3,6,7,8,7,11,6,7,0,2,2,10,4,2,11,3,11,0,5,10,6,7,4,7,7,8,2,0,11,0,1,10,3,4,3,0,9,8,11,3,5,6,10,0,4,5,1,11,1,6,7,8,9,7,2,6,7,2,8,0,1,8,10,4,5,11,4,4,8,0,9,5,8,9,8,6,0,11,3,1,6,11,9,6,2,3,1,2,4,9,11,0,4,5,4,6,5,6,11,3,1,2,2,9,10,0,1,1,3,2,5,6,2,6,7,8,9,9,4,5,10,11,9,5,6,9,10,7,0,4,5,2,10,11,1,2,3,9,6,7,7,8,4,5,11,9,10,6,7,3,5,6,9,10,1,5,6,7,0,8,5,6,8,0,1,1,2,4,1,2,8,9,2,9,2,3,8,2,3,4,5,0,6,10,11,7,4,1,11,0,7,10,2,3,4,2,4,4,9,1,11,0,0,8,10,11,1,0,4,0,5,6,7,7,3,8,9,7,4,7,8,5,10,3,0,9,11,0,1,7,4,5,5,6,2,3,9,8,4,5,1,4,7,8,11,3,5,10,6,3,4,11,6,11,11,0,2,0,6,7,5,0,7,1,6,1,2,3,10,4,8,9,4,1,10,9,7,4,7,0,11,1,1,6,10,9,9,5,8,10,9,1,9,2,4,4,0,6,5,4,1,5,2,7,0,6,9,6,9,10,4,2,2,3,0,6,5,2,10,1,5,8,0,2,7,3,1,3,8,9,11,9,4,9,4,10,3,10,0,7,1,6,2,4,2};
static const short Gen_shift_values_BG1_Z_13[2109]= {11,7,0,2,11,9,4,11,9,6,11,5,5,11,9,7,11,8,2,11,4,8,11,7,6,11,10,4,11,0,3,11,11,6,11,1,3,11,6,9,11,10,7,11,0,3,11,4,5,11,2,12,11,6,2,11,8,1,11,10,1,11,12,0,11,3,10,12,11,7,0,2,12,11,9,4,12,11,9,6,12,11,5,5,11,9,7,12,11,8,2,12,11,4,8,11,7,6,11,10,4,12,11,0,3,12,11,11,6,12,11,1,3,12,11,6,9,12,11,10,7,11,0,3,12,11,4,5,12,11,2,12,11,6,2,12,11,8,1,12,11,10,1,12,11,12,0,12,11,3,10,11,7,1,0,3,2,11,10,9,5,4,11,9,7,6,11,5,6,5,11,10,9,8,7,11,8,3,2,11,5,4,9,8,11,8,7,7,6,11,11,10,5,4,11,0,4,3,11,12,11,7,6,11,1,4,3,11,6,10,9,11,11,10,8,7,11,1,0,4,3,11,4,6,5,11,2,0,12,11,7,6,3,2,11,9,8,2,1,11,10,2,1,11,0,12,1,0,11,3,11,10,11,7,0,3,2,11,9,5,4,11,9,6,11,5,6,5,11,9,8,7,11,8,2,11,4,9,8,11,7,7,6,11,10,5,4,11,0,3,11,11,7,6,11,1,4,3,11,6,10,9,11,10,8,7,11,0,4,3,11,4,5,11,2,0,12,11,6,3,2,11,8,2,1,11,10,1,11,12,1,0,11,3,11,10,10,8,5,1,7,9,2,5,3,11,8,5,3,0,5,12,12,10,5,3,1,5,2,9,5,11,2,5,1,0,5,4,11,5,7,10,5,5,0,5,8,10,5,0,3,12,5,4,1,5,7,10,5,11,12,5,9,6,11,5,0,9,5,2,8,5,4,8,5,6,7,5,10,4,4,5,0,6,10,8,10,11,12,1,9,7,9,2,10,7,10,3,6,9,0,12,11,2,1,2,7,10,5,9,8,0,4,3,1,7,10,5,8,2,6,5,7,10,1,4,1,5,4,0,7,10,5,9,8,3,7,6,7,10,4,7,11,2,1,7,10,0,4,3,4,8,7,7,10,3,7,6,2,6,5,7,10,6,10,9,0,4,3,7,10,9,12,12,3,2,7,10,7,11,10,2,6,5,7,10,10,0,12,3,2,7,10,2,5,5,9,8,10,7,10,6,10,9,3,7,6,7,10,9,0,12,12,3,2,7,10,0,3,1,5,4,7,10,11,1,8,12,11,4,7,10,2,6,5,11,2,1,7,10,4,8,7,10,1,0,7,10,6,9,10,1,0,7,7,10,8,12,11,9,0,12,7,10,12,2,6,10,9,9,5,9,1,0,5,3,7,3,8,11,12,2,11,4,3,6,5,12,1,5,7,7,9,1,3,6,5,1,3,9,11,11,3,6,5,1,3,11,0,3,6,5,10,12,10,12,3,5,1,3,12,1,3,6,5,0,2,7,9,3,6,5,9,11,0,2,3,5,12,1,11,0,3,5,2,4,9,11,3,6,5,5,7,8,10,3,6,5,3,5,11,0,3,6,5,6,8,8,10,3,6,5,11,0,1,3,5,3,6,5,2,4,12,1,3,5,5,7,8,10,3,6,5,9,11,10,12,3,6,5,7,9,4,6,2,3,5,11,0,7,9,3,6,5,0,2,6,8,3,6,5,2,4,6,8,3,6,5,4,6,5,7,3,6,5,8,10,2,4,12,5,6,7,9,12,11,6,5,1,7,9,12,6,5,3,11,6,5,3,0,6,5,12,12,3,5,3,1,6,5,2,9,6,5,11,2,5,1,0,0,5,4,11,6,5,7,10,6,5,5,0,6,5,8,10,6,5,0,3,6,5,4,1,5,7,10,6,5,11,12,6,5,9,6,5,0,9,6,5,2,8,6,5,4,8,6,5,6,7,2,6,5,10,4,0,6,0,12,0,1,5,1,7,10,9,3,5,3,12,11,5,5,3,0,5,12,0,12,5,3,2,1,5,2,9,5,11,3,2,5,1,1,0,5,4,12,11,5,7,10,5,5,1,0,2,5,8,11,10,5,0,4,3,5,4,2,1,12,5,7,11,10,5,11,12,5,9,7,6,5,0,10,9,5,2,9,8,0,5,4,8,5,6,8,7,5,10,5,4,11,7,0,2,11,9,4,9,11,9,6,11,5,5,2,11,9,7,11,8,2,11,4,8,11,7,6,11,10,4,11,0,3,11,11,6,11,1,3,3,11,6,9,11,10,7,11,0,3,11,4,5,11,2,12,11,6,2,11,8,1,11,10,1,11,12,0,4,11,3,10,12,1,3,2,11,0,1,10,2,4,11,5,9,1,8,2,11,4,6,5,2,0,8,2,0,10,2,9,9,11,2,0,11,2,12,6,2,8,12,2,11,10,2,1,8,2,4,7,1,2,2,10,2,5,7,4,2,10,0,2,1,11,2,4,7,2,8,9,2,6,3,2,10,6,2,12,5,2,1,5,2,3,4,2,7,1,5,7,4,2,3,4,5,12,0,5,4,1,8,4,0,6,8,8,4,2,10,4,2,12,4,11,11,7,4,2,0,8,4,1,8,4,10,1,4,0,12,4,3,10,4,6,9,4,4,12,4,7,9,1,4,12,2,4,3,0,4,6,9,4,10,11,4,8,5,4,12,8,4,1,7,4,3,7,4,5,6,4,9,3,3,8,2,1,7,11,9,1,6,9,8,3,0,0,1,4,0,6,9,8,4,2,11,10,0,4,2,12,4,11,12,11,4,2,1,0,4,1,8,4,10,2,1,4,0,0,12,4,3,11,10,4,6,9,4,4,0,12,4,7,10,9,4,12,3,2,4,3,1,0,4,6,10,9,5,4,10,11,4,8,6,5,4,12,9,8,4,1,8,7,1,4,3,7,4,5,7,6,4,9,4,3,5,1,8,7,10,9,1,5,4,3,12,11,5,3,1,0,5,12,0,12,5,4,3,2,1,5,2,10,9,5,12,11,3,2,5,2,1,1,0,5,5,4,12,11,5,7,11,10,5,6,5,1,0,9,5,8,11,10,5,0,4,3,5,5,4,2,1,7,5,8,7,11,10,5,11,0,12,5,9,7,6,5,1,0,10,9,5,3,2,9,8,5,4,9,8,5,7,6,8,7,5,10,5,4,6,10,2,6,8,12,10,2,1,6,10,4,8,12,4,3,3,6,10,4,8,1,5,6,10,0,4,0,5,4,6,10,4,8,2,7,6,6,10,3,7,10,1,6,10,12,3,3,8,7,6,10,2,6,1,6,5,9,6,10,5,9,12,4,3,6,10,8,12,11,2,6,10,6,10,1,6,5,6,10,9,0,11,3,2,6,10,1,5,4,9,8,6,10,5,9,2,7,6,6,10,8,12,11,3,2,6,10,12,3,0,4,6,10,10,1,7,12,11,6,10,1,5,10,2,1,6,10,3,7,9,1,0,6,10,5,9,9,0,6,10,7,11,8,0,12,6,10,11,2,5,10,9,5,1,8,7,10,9,5,5,4,3,12,11,5,3,1,0,5,12,0,12,5,4,3,2,1,5,2,10,9,5,12,11,3,2,5,2,1,1,0,5,5,4,12,11,5,7,11,10,5,6,5,1,0,5,8,11,10,5,0,4,3,8,5,5,4,2,1,5,8,7,11,10,10,5,11,0,12,5,9,7,6,5,1,0,10,9,5,3,2,9,8,5,4,9,8,5,7,6,8,7,5,10,5,4,9,3,5,0,3,9,1,11,1,10,3,5,1,12,7,3,1,12,9,1,8,8,1,12,10,1,11,5,1,7,11,5,1,10,9,1,0,7,1,3,6,1,1,9,1,4,6,1,9,12,11,1,0,10,1,3,6,1,7,8,1,5,2,1,9,5,1,11,4,1,0,4,1,2,3,1,6,0,5,4,7,3,4,3,12,5,7,4,3,1,9,3,4,3,1,11,4,3,10,10,3,1,12,4,3,0,7,4,3,9,0,3,12,11,3,2,9,4,3,5,8,4,3,3,11,4,3,6,8,4,3,11,1,4,3,2,12,1,3,5,8,4,3,9,10,4,3,7,4,3,11,7,4,3,0,6,4,3,2,6,4,3,4,5,4,3,8,2,12,11,2,8,3,1,4,5,9,5,11,1,9,11,10,4,0,7,6,9,8,6,4,3,2,11,10,4,2,0,12,4,11,12,11,4,3,2,1,0,9,4,1,9,8,4,11,10,2,1,4,1,0,0,12,4,4,3,11,10,4,6,10,9,4,5,4,0,12,4,7,10,9,4,12,3,2,4,4,3,1,0,4,7,6,10,9,4,10,12,11,4,8,6,5,4,0,12,9,8,4,2,1,8,7,4,3,8,7,4,6,5,7,6,4,9,4,3,5,1,7,10,9,5,3,12,11,0,5,3,0,5,12,0,12,5,3,2,1,5,2,9,5,11,3,2,5,1,1,0,5,4,12,11,5,7,10,5,5,1,0,5,8,11,10,5,0,4,3,5,4,2,1,5,7,11,10,5,11,12,5,9,7,6,6,5,0,10,9,5,2,9,8,7,5,4,8,5,6,8,7,5,10,5,4,1,10,3,5,3,1,12,7,1,12,9,1,8,8,1,12,10,1,11,5,1,7,11,1,10,9,5,1,0,7,1,3,6,11,1,1,9,1,4,6,1,9,12,1,0,10,1,3,6,1,7,8,1,5,2,1,9,5,1,11,4,1,0,4,1,2,3,1,6,0,11,5,9};
static const short Gen_shift_values_BG1_Z_14[2109]= {12,0,10,4,1,6,3,9,2,2,6,10,10,3,7,4,3,6,11,9,3,2,2,10,1,6,12,1,13,2,8,8,13,5,5,9,0,6,8,2,4,6,6,8,3,12,13,8,6,13,5,11,11,1,3,0,4,0,1,2,12,5,5,1,10,4,3,12,13,1,11,5,1,2,7,4,9,10,3,3,6,7,11,11,4,8,5,3,4,7,12,9,10,4,3,3,11,2,7,13,2,13,0,3,9,8,9,0,6,5,6,10,1,6,7,9,3,4,5,7,7,9,4,13,13,0,9,7,13,0,6,12,12,2,4,0,1,5,1,1,2,3,13,5,6,6,2,10,11,5,4,13,1,10,11,4,5,2,6,7,3,4,10,3,2,3,7,11,10,11,4,7,8,4,5,4,7,11,12,10,3,4,2,3,3,10,11,1,2,7,12,13,1,2,0,3,8,9,9,13,0,5,6,6,10,0,1,7,9,2,3,5,6,7,6,7,9,3,4,12,13,0,9,6,7,0,6,11,12,12,1,2,3,4,1,4,5,0,1,2,3,12,13,6,5,6,1,2,11,5,3,4,13,1,11,4,5,2,7,3,4,10,3,3,7,11,10,11,4,8,4,5,4,7,12,10,4,2,3,3,11,1,2,7,13,1,2,0,3,9,9,0,5,6,6,10,0,1,7,9,2,3,5,7,6,7,9,4,12,13,0,9,7,0,6,11,12,12,2,3,4,1,5,0,1,2,3,13,6,6,1,2,11,5,3,4,1,9,11,13,9,3,9,0,5,2,2,8,1,1,5,9,9,1,2,6,3,2,5,10,8,2,1,1,9,0,5,11,0,12,1,7,7,12,4,4,8,13,5,7,1,9,3,5,5,7,2,11,12,7,5,12,4,10,13,10,0,2,13,3,13,0,1,11,4,4,0,9,3,2,3,3,6,0,6,6,8,9,3,2,5,5,1,9,3,0,4,2,6,12,1,2,6,9,10,4,3,7,8,11,12,5,8,9,10,11,1,4,8,4,7,8,8,12,12,2,12,1,2,3,5,9,9,12,13,6,9,10,5,9,8,12,13,2,3,11,1,5,8,9,4,7,8,4,8,12,1,2,3,6,7,8,12,0,3,4,3,6,7,1,5,4,8,10,13,0,10,0,1,4,5,7,10,11,7,11,11,1,2,5,6,8,12,10,0,4,7,8,6,6,10,8,11,12,8,11,12,10,0,5,8,9,0,3,4,1,5,10,0,8,11,12,1,5,7,11,13,2,3,7,13,3,3,6,7,5,8,9,2,6,6,9,10,2,5,6,3,7,4,8,0,3,4,10,7,11,7,10,11,3,6,7,12,2,6,10,5,8,9,1,8,8,2,6,4,2,10,7,11,10,5,4,11,4,12,3,4,0,6,10,2,4,10,9,1,6,7,6,12,3,9,10,9,0,1,2,8,2,8,6,11,12,10,2,10,2,3,9,7,13,4,10,3,8,9,6,12,11,3,9,0,1,3,9,2,8,2,8,10,2,1,7,6,12,12,4,1,7,13,4,5,2,8,8,0,8,13,0,13,5,5,11,5,10,11,9,1,0,6,6,11,12,8,0,2,8,1,4,9,10,6,12,6,12,8,0,3,9,12,4,13,4,5,8,0,6,12,13,4,5,5,11,11,3,6,11,3,1,7,3,9,0,5,6,4,10,0,6,1,6,7,2,8,12,4,5,10,11,5,11,1,7,10,1,2,4,10,3,9,3,1,6,9,2,13,13,6,7,9,5,13,10,9,10,1,12,3,4,11,11,0,1,5,5,13,12,2,13,11,12,1,6,3,4,12,11,11,5,10,1,1,7,10,7,8,11,3,2,3,8,0,13,0,4,9,0,1,3,11,12,13,1,1,3,12,7,7,8,3,1,7,8,0,6,6,10,12,8,9,13,9,9,10,11,7,13,0,0,10,6,4,5,13,12,13,6,0,8,8,0,10,12,8,1,2,5,13,4,0,1,7,7,0,0,4,8,7,8,1,5,1,2,1,4,9,7,1,13,0,0,8,12,13,4,10,12,13,11,0,6,6,11,2,3,4,3,7,11,12,4,6,13,0,2,4,3,4,12,6,1,9,10,11,6,4,11,3,8,9,9,13,0,1,12,2,11,12,12,13,0,10,3,3,12,13,8,2,0,1,1,3,13,7,4,9,6,13,12,5,5,9,13,13,9,6,10,7,6,9,0,12,6,5,5,13,4,9,1,4,2,5,11,11,2,8,8,12,3,0,9,11,5,7,9,9,11,6,1,2,11,9,2,8,0,0,4,6,3,7,3,4,5,1,8,8,4,6,13,7,6,13,11,3,6,3,2,11,3,2,3,7,5,4,1,7,13,1,11,5,6,2,7,4,10,3,3,7,11,11,13,4,8,5,4,7,12,10,4,3,3,11,2,7,13,2,0,3,9,8,9,0,6,6,10,1,3,7,9,3,5,7,7,9,4,13,0,9,7,0,6,12,12,2,4,1,5,1,2,3,13,6,6,2,11,5,4,9,4,9,7,7,10,13,2,7,3,6,13,9,10,12,8,2,6,13,4,1,7,0,0,4,8,8,2,1,5,2,7,1,4,9,7,1,0,0,8,13,4,10,13,11,0,6,6,11,3,3,7,12,10,4,6,0,2,4,4,6,1,10,11,6,4,11,3,9,9,13,1,12,2,12,13,0,10,3,3,13,8,2,1,0,11,8,10,8,7,1,0,11,0,5,5,12,6,1,11,13,9,2,3,0,5,1,2,9,8,1,1,5,9,8,9,2,6,2,3,2,5,10,8,2,0,1,1,9,13,0,5,11,13,0,12,1,7,7,12,3,4,4,8,12,13,5,7,0,1,3,5,4,5,7,2,10,11,10,12,7,5,12,4,9,10,10,0,1,2,13,3,12,13,10,0,1,11,4,4,13,0,9,3,1,2,10,12,7,8,1,2,5,13,3,4,0,1,7,0,13,0,4,8,7,8,1,4,5,1,2,1,4,8,9,7,0,1,13,0,0,7,8,12,13,4,9,10,12,13,11,0,5,6,6,10,11,2,3,3,3,7,11,12,4,6,13,0,2,3,4,3,4,13,6,0,1,9,10,11,6,3,4,11,3,8,9,9,12,13,0,1,12,1,2,11,12,13,0,9,10,3,2,3,12,13,8,2,0,1,7,1,9,3,5,13,13,6,7,10,4,1,9,12,5,6,6,4,12,11,5,11,5,1,9,5,13,5,12,13,12,6,2,10,13,6,7,12,6,1,9,6,0,4,12,12,6,11,4,5,11,5,5,13,10,3,4,6,1,9,7,1,10,3,4,8,2,11,5,3,11,3,11,8,2,0,7,8,0,8,4,12,9,2,3,1,9,3,11,11,4,5,13,7,1,9,1,8,9,3,11,12,6,7,0,1,8,2,3,11,1,9,8,2,0,8,6,13,0,6,0,10,4,12,5,6,9,3,13,7,9,2,3,10,4,11,5,7,1,0,8,0,8,10,3,4,5,13,13,7,12,5,6,1,3,12,13,6,7,9,4,8,9,5,6,12,5,4,5,9,13,12,13,6,9,10,6,7,6,9,13,0,12,5,6,4,5,5,12,13,3,4,9,0,1,3,4,2,5,10,11,11,1,2,7,8,8,12,2,3,9,11,4,5,12,7,8,9,8,9,11,5,6,0,1,1,2,11,8,9,2,8,13,0,0,3,4,5,6,3,6,7,2,3,4,5,0,1,8,7,8,3,4,13,7,5,6,1,6,6,10,11,3,11,9,3,5,1,9,6,11,8,9,0,7,7,11,1,1,8,12,9,8,11,2,0,8,7,4,7,1,6,11,3,6,4,7,13,13,4,10,10,0,5,11,13,7,11,9,11,11,13,8,3,4,13,11,4,10,2,2,6,8,5,9,5,6,7,3,10,10,6,1,9,8,11,2,13,5,10,11,13,9,3,13,0,5,2,10,7,8,1,1,4,5,9,9,2,6,3,1,2,5,10,7,8,2,1,1,9,0,5,11,0,11,12,1,7,6,7,12,4,3,4,8,13,4,5,7,1,2,3,5,5,12,7,2,11,11,12,7,5,11,12,4,10,10,0,2,12,13,3,13,13,0,1,11,3,4,4,0,8,9,3,2,10,5,2,9,11,6,6,1,10,2,11,8,4,3,12,7,9,4,5,12,13,1,10,0,1,11,12,4,11,10,11,1,5,4,5,12,1,2,12,13,6,12,1,5,6,4,11,12,10,11,11,4,5,9,10,1,6,7,9,10,8,11,2,3,3,7,8,13,0,0,4,8,9,1,3,10,11,13,0,1,0,1,3,11,12,6,7,8,3,0,1,8,0,5,6,6,9,10,11,12,9,12,13,8,9,10,11,6,7,0,13,0,9,10,5,13,11,12,6,8,4,11,12,9,0,10,11,9,3,10,10,0,4,3,4,11,1,11,12,11,0,5,3,11,9,10,10,4,8,9,0,6,8,9,7,10,2,2,7,12,13,13,3,7,8,0,2,9,10,12,0,13,0,2,11,5,6,7,2,0,7,13,4,5,7,5,9,10,11,8,12,7,8,7,9,10,6,13,13,8,9,4,12,10,11,10,12,8,2,13,13,4,1,7,0,0,4,8,8,1,5,2,1,4,9,7,1,0,0,8,13,3,4,10,13,11,0,6,8,6,11,3,3,7,12,4,6,0,2,4,4,6,1,10,11,6,4,11,3,9,9,13,1,12,2,12,13,0,10,3,3,13,8,2,1,1,8,0};
static const short Gen_shift_values_BG1_Z_15[2109]= {14,5,8,7,1,3,7,5,10,14,13,0,11,10,0,9,8,7,10,7,11,12,1,13,5,6,1,5,7,10,8,14,7,0,9,10,5,7,8,6,14,5,8,4,10,1,14,9,2,6,2,4,11,5,1,9,4,9,14,12,6,14,4,6,1,5,8,14,0,6,9,8,1,2,4,8,5,6,11,0,13,14,1,12,11,1,10,8,9,8,11,7,8,12,13,2,14,6,7,2,6,7,8,11,9,14,0,8,1,9,10,11,6,7,8,9,7,14,0,6,9,5,11,2,14,0,10,3,6,7,3,5,12,6,2,9,10,5,10,14,0,13,7,14,0,5,7,1,2,6,9,0,6,8,9,7,8,2,3,4,7,8,6,11,14,0,14,1,11,12,11,0,1,9,10,9,8,10,11,8,11,12,12,13,2,13,14,5,6,7,1,2,5,6,8,11,8,9,0,7,8,0,1,10,11,5,6,8,9,6,7,0,5,6,8,9,5,10,11,1,2,0,10,2,3,7,3,4,5,12,5,6,1,2,10,4,5,9,10,0,13,6,7,0,4,5,6,7,2,6,8,9,0,6,9,7,8,2,4,7,8,6,11,0,14,1,11,12,11,1,9,10,9,8,11,8,12,12,13,2,14,5,6,7,2,5,6,8,11,9,0,8,0,1,10,11,5,6,8,9,6,7,0,6,8,9,5,11,1,2,0,10,3,7,3,4,5,12,6,1,2,10,5,9,10,0,13,7,0,5,6,7,2,6,8,9,3,0,14,5,8,7,1,1,3,7,5,5,10,14,13,0,11,1,10,0,9,8,7,10,7,11,12,1,13,5,6,1,5,7,10,8,14,7,0,9,10,5,7,8,6,7,14,5,8,4,10,1,14,9,2,6,2,4,14,11,5,1,9,4,9,14,12,6,14,4,6,1,5,8,14,3,6,7,9,1,11,6,12,1,10,13,1,0,2,2,8,8,14,11,1,2,10,0,1,0,4,10,6,11,12,10,0,1,14,8,14,13,4,2,7,8,1,7,3,9,14,4,5,5,13,4,3,8,9,12,2,3,11,2,10,1,13,3,4,10,1,14,4,5,0,5,6,4,10,1,6,7,8,13,14,9,0,4,9,10,8,13,14,10,1,13,4,11,1,2,2,8,10,0,1,3,8,9,12,3,13,4,8,13,14,10,1,11,2,9,14,0,12,2,8,8,13,14,11,1,2,7,13,13,3,4,4,9,10,2,8,12,3,5,10,11,9,0,5,11,7,12,13,11,14,5,8,13,14,4,9,10,12,3,7,12,13,12,2,3,2,8,0,6,9,14,0,9,2,8,7,12,13,9,14,0,4,10,8,14,11,1,2,3,3,11,10,10,1,1,1,9,10,0,9,4,9,8,14,1,2,5,8,8,11,7,10,14,1,3,4,3,6,7,10,9,5,7,8,10,13,14,2,13,0,1,0,3,11,14,10,13,0,3,9,12,8,10,11,7,10,10,13,7,9,10,11,14,12,0,1,4,13,1,5,8,6,9,1,4,5,8,7,9,10,10,13,8,11,14,1,2,7,10,0,3,9,11,12,10,13,5,8,7,9,10,8,11,6,9,13,14,1,2,5,8,8,11,4,7,10,13,1,4,14,1,2,9,12,2,5,6,8,9,2,5,4,7,0,11,14,5,8,1,4,9,11,12,4,7,9,12,14,1,2,12,0,6,9,14,1,2,4,7,6,9,1,3,4,5,8,8,11,1,5,4,3,14,7,4,14,0,6,9,8,9,1,2,4,8,5,6,11,0,13,14,1,12,4,11,1,10,8,9,8,11,7,8,12,13,2,14,6,3,7,2,6,7,8,11,9,14,0,8,1,9,10,11,6,7,8,9,7,14,0,6,9,5,11,2,14,0,10,3,6,7,3,5,12,6,2,9,10,5,10,14,0,13,7,14,0,5,7,12,1,2,6,9,3,8,1,4,11,0,4,10,13,11,12,8,6,8,11,12,2,10,0,4,3,5,0,1,0,5,13,14,13,12,0,12,1,1,2,6,3,9,10,11,6,9,10,12,0,13,4,12,4,5,9,14,0,9,10,12,13,10,11,4,10,12,13,7,9,0,5,6,4,14,7,11,7,8,9,1,10,5,6,14,9,13,14,6,4,2,11,4,9,10,11,6,10,12,13,9,0,3,2,11,13,2,2,0,5,9,8,10,6,1,5,10,4,3,2,5,2,6,7,11,8,0,1,11,0,2,5,3,9,2,10,4,5,0,8,2,3,1,9,0,3,14,5,11,9,4,12,1,12,14,6,0,11,4,14,4,9,7,1,9,14,1,4,11,0,3,2,6,0,8,8,2,4,14,7,13,13,2,8,2,0,9,0,3,2,1,11,13,2,0,5,9,8,10,6,6,5,10,4,3,2,5,2,6,7,11,8,0,1,11,0,2,5,3,7,9,2,10,4,5,0,1,2,3,1,9,0,3,14,5,11,9,4,12,1,12,14,6,0,11,4,14,4,9,7,1,9,14,1,11,0,3,1,1,4,4,5,9,1,5,12,4,6,11,3,12,3,6,5,1,14,1,5,3,8,12,11,13,9,12,8,13,7,1,6,5,8,5,9,10,14,11,3,4,14,3,5,8,6,12,5,13,7,8,3,5,5,6,4,12,3,6,2,8,14,12,7,0,4,0,2,9,3,14,7,2,7,12,10,4,12,2,4,14,3,6,11,5,10,0,12,10,3,7,14,6,8,1,12,4,9,13,4,7,5,6,0,2,5,6,6,4,9,13,12,14,9,10,9,14,7,8,7,6,9,6,10,10,11,0,12,3,4,5,0,3,4,6,9,7,13,6,13,14,8,9,3,4,6,7,4,5,13,4,6,7,3,9,14,0,1,13,8,1,5,1,2,3,10,4,14,0,8,3,7,8,12,13,11,5,13,3,4,5,0,4,6,7,0,6,8,9,7,8,4,2,3,4,7,8,6,11,14,0,14,1,11,12,11,0,1,9,10,9,8,10,11,8,11,12,12,13,2,13,14,5,6,7,1,2,5,6,8,11,8,9,0,7,8,0,1,3,10,11,5,6,8,9,6,7,0,5,6,8,9,10,5,10,11,1,2,0,10,2,3,7,3,4,5,12,5,6,1,2,10,4,5,9,10,0,13,6,7,0,4,5,6,7,2,6,8,9,9,3,0,9,3,12,2,10,11,11,5,13,7,2,10,11,12,0,9,5,14,9,3,8,2,10,4,6,14,0,5,14,10,4,4,12,13,3,12,2,11,5,14,2,11,6,0,7,0,1,11,5,8,2,0,8,9,13,1,10,11,5,0,8,9,2,11,5,14,3,12,9,3,2,11,10,3,4,4,13,5,14,0,8,9,2,11,3,12,1,9,10,9,3,0,9,3,11,12,14,8,5,14,11,4,5,9,3,4,13,12,6,1,10,12,6,14,7,8,6,0,0,9,11,4,5,4,13,14,8,4,12,13,9,3,7,1,1,10,9,3,14,8,1,9,10,11,5,0,9,3,11,12,1,7,9,10,8,9,12,3,4,5,8,9,7,12,0,1,0,2,12,13,12,1,2,10,11,10,9,11,12,9,12,13,13,14,3,14,0,6,7,8,2,3,6,7,9,12,9,10,1,8,9,1,2,11,12,6,7,9,10,7,8,4,1,6,7,9,10,6,11,12,2,3,0,1,11,3,4,8,4,5,6,13,6,7,2,3,11,5,6,10,11,1,14,7,8,1,5,6,7,8,3,7,9,10,3,11,6,4,10,11,6,14,9,0,3,2,11,13,2,5,0,5,9,8,10,6,5,10,4,3,2,5,2,6,7,8,11,8,0,1,11,0,2,5,3,9,2,10,4,5,0,2,3,1,9,9,0,3,14,5,11,9,4,12,1,12,14,6,0,11,4,14,4,9,7,1,9,14,1,11,0,3,10,11,11,9,10,11,2,5,4,12,13,0,4,13,1,2,7,11,9,10,12,8,7,12,6,4,5,4,7,3,4,8,9,13,10,2,3,13,2,3,4,7,5,10,11,4,12,5,6,7,2,3,4,5,3,10,11,2,5,8,1,7,13,10,11,6,14,2,3,14,1,8,2,13,5,6,1,6,10,11,9,3,10,11,1,3,12,13,2,5,0,14,10,4,9,7,2,6,3,12,14,7,8,4,8,11,2,4,5,3,4,11,13,14,0,3,4,2,7,10,11,10,12,7,8,7,11,12,5,6,4,5,4,6,7,4,7,8,8,9,13,9,10,1,2,3,12,13,1,2,4,7,4,5,11,3,4,11,12,6,7,1,2,4,5,2,3,11,1,2,4,5,1,6,7,12,13,11,6,13,14,3,14,0,1,8,1,2,12,13,6,0,1,5,6,11,9,2,3,11,0,1,2,3,13,2,4,5,5,11,14,12,13,7,9,12,13,6,11,1,5,4,6,1,2,1,6,14,0,14,13,1,13,2,2,3,7,4,10,11,12,7,10,11,13,1,14,5,13,5,6,0,1,10,11,13,14,11,12,5,11,13,14,10,1,6,7,5,0,8,12,8,9,10,6,2,11,6,7,0,10,14,0,3,5,3,12,5,10,11,12,7,11,13,14,12,3,6,5,10,14,1,5,3,8,12,11,13,9,8,13,7,6,5,8,5,9,10,14,11,3,0,4,14,3,5,8,6,6,12,5,13,7,8,3,5,6,4,12,3,6,2,8,14,12,7,0,4,0,2,9,3,14,7,2,7,12,10,4,12,2,4,14,3,6,11,8,2};
static const short Gen_shift_values_BG1_Z_16[2109]= {9,1,9,8,4,14,8,1,14,8,14,4,3,11,14,3,3,6,4,9,12,5,13,4,2,7,0,2,10,12,14,4,6,7,13,11,5,14,5,5,8,13,10,12,0,2,2,3,0,6,13,15,10,4,11,13,12,3,2,14,10,14,4,15,14,11,11,9,10,2,10,9,4,5,15,9,1,2,15,9,14,15,5,4,12,15,4,3,4,7,5,9,10,13,6,14,5,3,8,1,3,10,11,13,15,4,5,7,8,13,14,12,6,14,15,6,6,8,9,14,11,13,1,3,2,3,4,1,6,7,14,0,11,5,12,13,14,13,4,2,3,15,11,14,15,5,0,14,15,12,12,10,2,9,10,8,9,5,14,15,8,9,2,15,8,9,15,5,3,4,12,14,15,3,4,4,7,4,5,10,12,13,5,6,14,4,5,2,3,8,0,1,2,3,11,13,14,15,5,6,7,7,8,14,12,5,6,15,6,5,6,9,13,14,10,11,13,0,1,2,3,3,4,0,1,7,14,15,0,11,4,5,11,12,14,12,13,3,4,3,15,10,11,15,4,5,15,0,15,12,11,12,10,2,10,8,9,5,15,8,9,2,15,9,15,5,3,4,12,15,3,4,4,7,5,10,13,5,6,14,5,2,3,8,1,2,3,11,13,15,5,7,7,8,14,12,5,6,15,6,5,6,9,14,10,11,13,1,2,3,3,4,1,7,14,15,0,11,5,11,12,14,13,3,4,3,15,11,15,5,15,0,15,12,11,12,12,5,12,4,12,11,12,7,1,11,11,4,1,11,1,7,6,1,14,1,6,6,9,7,12,15,8,0,7,5,10,3,5,13,15,1,7,9,10,0,14,8,1,8,8,6,11,0,13,15,3,5,5,6,3,9,0,2,11,13,7,14,0,15,6,5,1,13,1,7,2,1,14,14,10,6,5,11,2,3,10,12,2,11,11,14,14,6,7,10,4,2,12,10,3,4,9,2,3,15,5,15,15,8,9,9,2,3,3,2,12,15,9,9,2,3,15,9,5,15,4,13,14,6,12,6,15,8,9,4,13,14,4,14,7,1,5,14,15,10,4,13,6,7,6,15,0,14,8,5,14,15,3,12,13,8,2,1,10,11,3,12,13,11,5,13,7,15,8,9,5,15,7,0,1,8,1,2,14,8,12,6,6,15,0,15,9,6,0,6,15,0,2,9,3,14,7,8,11,4,5,13,7,1,10,11,3,12,13,3,13,4,14,1,10,11,7,1,14,8,0,9,10,5,11,5,5,14,15,12,5,6,14,8,13,6,7,4,13,14,3,13,15,9,11,4,5,3,15,9,5,14,15,0,9,10,15,9,12,6,12,5,6,12,6,5,12,4,13,13,12,7,1,4,6,15,0,9,5,15,0,13,8,5,0,4,15,12,0,10,11,10,5,4,15,8,13,7,8,10,5,4,15,10,4,5,0,11,15,10,7,2,10,5,15,10,15,9,10,2,13,0,11,5,15,0,8,3,1,12,9,4,0,11,14,9,3,14,12,7,14,9,6,0,1,8,3,10,5,0,10,11,2,13,3,14,9,3,4,7,2,1,12,10,4,5,1,12,1,12,2,4,14,15,9,4,6,1,8,3,12,7,14,9,14,8,9,15,10,12,7,2,12,13,9,4,11,6,5,6,1,0,11,7,2,9,3,4,8,3,15,10,14,8,9,10,5,6,1,10,4,5,0,11,11,6,10,4,5,7,2,7,2,13,15,9,4,15,9,6,7,8,0,8,7,0,2,3,13,7,15,0,13,7,12,13,3,2,7,10,13,2,1,2,5,3,7,8,11,4,12,3,1,6,6,15,1,8,9,11,13,2,3,5,6,11,12,10,4,12,13,4,4,6,7,12,9,11,15,1,0,1,2,15,4,5,12,14,9,3,10,11,12,11,2,0,1,13,9,12,13,3,14,8,12,13,10,10,13,6,13,14,15,4,13,5,13,11,12,7,8,2,11,12,15,5,2,12,2,8,6,7,15,2,6,7,7,10,8,13,0,8,9,1,8,5,6,11,4,5,6,14,0,2,8,10,10,11,0,1,15,8,9,2,9,8,9,12,1,13,14,14,0,4,5,6,6,7,4,10,1,2,3,14,8,14,15,1,0,6,7,10,6,2,14,2,8,2,3,2,15,14,15,3,11,3,2,14,8,2,15,11,8,2,8,14,13,0,5,8,13,13,0,14,3,6,15,7,14,12,1,10,12,4,6,8,14,0,1,7,5,15,0,8,15,15,2,7,4,6,10,12,12,13,10,0,7,9,4,14,5,7,6,13,12,8,4,8,14,9,2,8,5,5,6,3,10,0,15,9,8,7,10,2,11,8,7,14,15,9,1,9,8,6,4,14,8,1,14,8,14,4,3,9,11,14,3,3,6,4,9,12,5,13,4,2,7,0,2,10,12,14,8,4,6,7,13,11,5,14,14,5,5,8,13,10,12,0,2,2,3,0,6,13,15,10,4,11,13,12,3,2,14,10,14,4,15,14,11,11,8,8,12,2,10,15,13,11,13,11,2,9,7,7,15,7,6,15,2,12,6,15,12,6,12,2,1,5,9,12,1,11,1,4,2,7,10,3,11,2,0,5,14,0,8,10,12,2,4,5,11,9,3,3,12,3,3,6,11,8,10,14,0,0,1,14,4,11,13,8,2,9,11,10,1,0,12,8,12,2,13,12,9,9,6,7,3,5,2,2,6,12,8,7,1,15,4,4,14,0,8,0,14,15,11,5,14,15,5,8,5,15,5,11,9,10,2,5,9,10,10,13,11,0,3,11,12,4,11,8,9,14,7,8,9,1,3,5,11,13,13,14,4,2,11,12,5,12,11,12,15,4,0,1,3,7,8,9,11,9,10,7,13,4,5,6,1,11,1,2,4,3,9,10,3,9,5,1,5,11,5,6,5,2,1,2,3,11,2,3,1,2,7,14,7,8,1,2,11,8,1,2,8,14,12,13,5,7,8,12,13,13,0,13,14,3,5,6,14,15,7,13,14,11,12,1,9,10,11,12,4,6,7,8,14,15,0,0,1,8,7,5,14,15,8,15,14,15,2,6,7,3,4,7,6,9,10,11,12,12,13,9,10,0,7,8,9,4,13,14,4,5,7,5,6,12,13,12,8,3,4,8,13,14,8,9,8,5,4,5,5,7,13,15,5,7,4,5,6,0,2,10,12,4,5,6,14,13,15,10,12,4,6,10,12,0,2,15,0,1,7,9,10,12,15,0,1,15,1,2,4,0,2,5,7,8,10,1,2,3,9,11,0,2,14,15,0,0,3,5,12,14,14,15,0,6,8,8,10,10,12,0,2,2,4,3,4,5,9,11,7,9,1,2,3,10,12,1,3,1,2,3,4,6,9,11,6,7,8,8,10,12,14,14,15,0,14,0,15,1,12,14,2,4,9,11,11,12,13,6,8,0,2,7,8,9,9,11,8,10,15,0,1,14,0,10,12,6,8,10,12,0,2,11,12,13,10,12,7,9,7,8,9,3,11,2,3,1,2,12,14,7,8,1,2,11,8,1,2,8,14,12,13,5,7,8,12,13,13,0,13,14,3,5,6,14,15,7,13,14,11,12,1,9,10,11,12,4,6,7,8,14,15,0,0,1,7,5,14,15,8,15,14,15,15,2,6,7,3,4,6,9,10,11,12,6,12,13,9,10,0,7,8,9,4,13,14,4,5,7,5,6,12,13,12,8,3,4,8,13,14,8,9,8,5,4,5,1,10,8,2,14,6,3,14,0,8,0,15,11,5,15,0,8,5,15,5,11,10,2,5,10,10,13,11,0,3,12,4,4,11,9,14,7,9,1,3,5,11,13,14,4,2,12,5,12,12,14,15,4,1,3,7,9,9,10,7,13,4,6,1,11,2,4,3,10,9,5,1,5,11,6,5,2,2,4,8,2,7,3,4,12,4,3,14,15,9,3,5,11,12,9,3,8,9,15,14,6,9,14,13,14,1,15,3,4,7,0,8,15,13,2,11,13,4,5,7,9,14,15,1,2,7,8,6,0,8,9,0,0,2,3,8,5,11,7,11,13,12,13,14,11,0,1,8,10,5,15,6,7,8,7,14,12,13,9,5,8,9,15,10,8,9,6,6,6,6,12,2,12,10,4,15,12,8,4,6,12,10,6,3,11,2,3,1,2,4,14,7,8,1,2,11,8,1,2,8,14,12,13,5,7,8,12,13,12,13,0,13,14,3,5,6,14,15,7,13,14,11,12,1,9,10,11,12,4,6,7,8,14,15,0,0,1,7,5,14,15,8,15,14,15,2,6,7,3,4,6,9,10,11,12,12,13,9,10,0,7,8,9,4,13,14,4,5,7,5,6,12,13,12,8,3,4,8,13,14,8,9,8,5,4,5,5,13,5,3,4,0,10,3,4,6,13,10,4,10,0,14,15,7,10,14,15,15,2,0,5,8,0,1,9,0,13,14,3,12,13,14,6,8,10,0,2,2,3,9,7,0,1,10,1,0,1,4,9,5,6,8,12,13,14,14,15,12,2,9,10,11,2,6,0,6,7,9,8,14,15,12,14,10,6,10,0,10,11,10,7,6,7,6,14,6,5,10,1,11,5,14,11,5,11,1,0,8,11,0,0,3,1,6,9,2,10,1,15,12,4,13,15,7,9,11,2,1,3,4,10,8,2,11,2,2,5,10,7,9,13,15,15,0,13,3,10,12,7,1,8,10,9,0,15,11,7,11,1,12,11,8,8,4,6,6};
static const short Gen_shift_values_BG1_Z_18[2109]= {12,16,5,6,17,4,0,7,17,3,5,6,3,3,6,17,2,15,8,3,3,9,3,1,5,3,8,16,10,8,17,17,2,4,7,0,17,17,14,2,6,1,17,17,12,6,16,7,17,17,13,7,2,17,2,4,16,17,17,11,1,0,17,4,8,10,17,12,13,17,6,7,17,0,5,1,7,8,0,4,5,6,7,4,4,7,0,2,3,16,9,3,4,4,10,4,2,6,4,9,17,10,11,9,0,17,0,3,5,7,8,1,0,17,0,15,3,6,7,2,0,0,13,7,16,17,8,0,17,0,14,8,3,0,3,4,5,17,0,17,0,12,2,0,1,0,5,8,9,11,0,13,17,5,6,6,7,0,4,5,0,1,8,0,3,4,6,7,3,4,4,6,7,17,0,3,16,8,9,4,3,4,9,10,4,1,2,5,6,4,8,9,16,17,11,9,17,0,0,2,3,4,5,8,1,17,0,0,15,2,3,7,1,2,17,0,0,12,13,6,7,17,8,17,0,0,14,7,8,3,17,0,2,3,5,16,17,17,0,0,12,1,2,1,17,0,4,5,9,11,17,0,13,17,6,6,7,0,5,0,1,8,0,4,6,7,3,4,4,7,17,0,3,16,9,4,4,9,10,4,2,5,6,4,9,16,17,11,9,0,0,3,4,5,8,1,17,0,0,15,2,3,7,2,17,0,0,13,6,7,17,8,0,0,14,7,8,3,0,2,3,5,17,17,0,0,12,2,1,0,4,5,9,11,17,0,11,0,12,16,5,6,8,17,4,0,0,7,17,3,5,6,3,17,3,6,17,2,15,8,3,3,9,3,1,5,3,8,16,10,8,17,17,2,4,7,0,17,17,14,2,12,6,1,17,17,12,6,16,7,17,17,13,7,1,2,17,2,4,16,17,17,11,1,0,17,4,8,10,17,6,7,17,6,17,4,14,6,17,6,8,9,3,13,1,8,13,12,17,1,5,6,2,6,7,17,13,0,0,4,5,14,0,1,17,3,8,13,0,17,3,4,1,6,2,7,17,3,4,17,17,4,2,6,7,13,17,0,16,3,11,16,4,8,9,17,4,17,3,4,5,9,10,17,4,15,1,2,1,5,6,17,4,4,8,9,12,16,17,6,11,4,9,13,17,0,13,0,16,2,3,0,4,5,3,8,14,1,13,17,0,13,0,10,15,16,2,3,4,2,7,15,1,2,13,17,0,13,0,8,12,13,2,6,7,12,17,3,8,13,17,0,13,0,9,14,3,7,8,7,16,3,13,17,0,16,2,3,0,5,12,16,17,13,17,0,13,0,7,12,15,1,2,9,14,1,13,17,0,0,4,5,4,9,6,11,13,17,0,14,17,14,2,7,8,5,3,10,15,0,9,14,17,2,15,2,3,1,7,8,14,9,15,0,2,7,8,7,13,3,9,4,10,15,16,2,8,6,12,8,13,14,9,15,6,12,6,12,9,15,2,8,5,10,11,0,6,11,17,6,11,12,6,12,12,0,6,12,4,10,8,14,6,12,11,17,1,7,13,0,1,11,17,2,8,2,7,8,5,11,7,13,10,15,16,3,9,2,8,2,7,8,17,5,5,11,3,9,14,15,4,10,2,8,2,8,15,3,9,15,1,6,7,10,16,2,8,2,7,8,16,4,10,16,0,5,11,2,8,5,11,7,12,13,1,7,2,8,2,7,8,14,2,4,10,3,8,9,2,8,7,13,11,16,17,13,1,2,8,2,8,17,9,6,3,8,12,13,17,6,7,14,17,0,5,1,7,8,0,4,5,6,7,4,17,4,7,0,2,3,16,9,3,4,4,10,4,2,6,17,4,9,17,10,11,9,0,17,0,3,5,7,8,1,0,17,0,15,3,6,7,2,0,0,13,7,16,17,8,0,17,0,14,8,3,0,3,4,5,17,0,17,0,12,2,0,1,0,5,10,8,9,11,0,17,5,0,15,17,6,5,9,16,16,17,7,10,15,10,11,17,0,10,14,16,17,13,14,14,17,9,10,13,8,1,14,14,1,2,14,12,15,16,14,1,8,9,3,1,10,10,13,14,15,2,0,11,9,10,10,7,12,13,17,12,9,10,17,10,5,16,17,9,0,10,10,6,17,0,13,10,12,13,15,9,9,10,13,10,4,12,11,10,14,15,1,3,9,10,12,16,5,6,17,4,0,17,7,17,3,5,6,3,12,3,6,17,2,15,8,3,3,9,3,1,5,3,8,16,10,8,17,17,2,4,7,0,17,8,17,14,2,6,1,17,17,12,6,16,7,17,17,13,7,2,17,2,4,16,17,17,11,1,0,17,4,17,8,10,17,8,10,17,17,17,16,6,17,6,17,17,17,9,17,17,6,10,17,0,12,11,16,12,1,11,15,17,0,15,8,15,0,11,14,9,2,15,15,3,15,13,17,15,2,10,4,2,11,17,11,14,16,1,12,11,17,11,8,14,0,13,11,11,6,0,10,1,11,11,7,1,14,11,14,16,10,11,11,5,13,12,11,16,2,4,11,9,9,13,8,17,17,8,17,4,17,17,17,2,12,16,5,6,1,17,4,0,7,17,3,5,6,3,0,3,6,17,17,2,15,8,3,3,9,3,1,5,3,8,16,10,8,17,17,2,4,7,0,17,13,17,14,2,6,1,17,17,12,6,16,7,17,17,13,7,2,17,2,4,16,17,17,11,1,0,17,4,8,10,17,6,17,17,2,17,17,17,6,8,17,17,4,17,10,7,1,5,12,12,13,6,11,6,7,17,14,6,10,12,13,9,10,10,13,5,6,9,4,15,10,10,15,16,10,8,11,12,10,15,4,5,17,15,6,6,9,10,11,14,7,5,6,6,3,8,9,13,8,5,6,6,1,12,13,17,5,14,6,6,2,13,14,9,6,8,9,11,5,5,6,17,6,0,8,7,6,10,11,15,17,5,6,6,10,16,17,17,0,17,11,15,16,11,12,1,11,14,15,17,0,14,15,15,17,0,10,11,14,9,1,2,15,14,15,2,3,15,12,13,16,17,15,1,2,9,10,4,2,10,11,11,13,14,15,16,17,1,12,10,11,11,8,13,14,0,12,13,10,11,17,11,5,6,17,0,10,1,10,11,11,7,0,1,14,10,11,13,14,16,9,10,10,11,11,5,12,13,12,10,11,15,16,2,4,10,11,16,14,2,0,9,7,10,7,8,3,1,8,6,4,1,2,17,11,9,3,1,7,5,9,7,10,8,7,4,5,7,5,10,8,3,0,1,6,4,1,17,12,10,7,5,7,5,13,10,11,7,5,5,3,9,6,7,17,7,5,12,10,2,17,0,14,12,12,10,3,1,3,1,6,4,8,5,6,11,9,4,2,3,0,1,3,1,0,16,6,3,4,10,8,5,3,3,0,1,3,1,16,14,10,7,8,2,0,11,9,3,1,3,1,17,15,11,8,9,6,4,3,1,6,3,4,8,6,2,0,3,0,1,3,1,15,13,5,3,4,2,3,1,8,5,6,12,10,14,12,3,0,1,13,17,5,6,6,7,17,0,4,5,0,1,8,0,3,4,6,7,3,4,4,6,7,17,0,3,16,8,9,4,3,4,9,10,4,1,2,5,6,4,8,9,16,17,11,9,17,0,0,2,3,4,5,8,1,17,0,0,15,2,3,12,7,1,2,17,0,0,12,13,6,7,17,17,8,17,0,0,14,7,8,3,17,0,2,3,5,16,17,17,0,0,12,1,2,1,17,0,4,5,9,11,17,0,17,17,3,17,16,17,17,17,1,5,12,13,6,11,7,0,14,6,10,12,13,10,10,13,6,9,4,15,10,10,16,7,10,8,12,10,15,5,17,15,6,6,9,11,14,7,6,6,3,9,17,13,8,6,6,1,13,5,14,6,6,2,14,9,6,9,11,5,6,6,0,8,7,6,11,15,17,6,17,15,17,17,12,13,17,6,7,17,0,5,1,17,7,8,0,4,5,6,7,4,4,7,0,2,3,16,9,3,4,4,10,4,2,6,4,9,17,10,11,9,0,17,0,3,5,7,8,1,0,17,0,15,3,6,7,2,0,17,0,13,7,16,17,8,0,17,0,14,8,3,0,3,4,5,17,0,17,0,12,2,0,1,0,5,8,9,11,0,9,17,17,17,8,17,2,8,17,17,1,17,17,17,2,12,16,4,5,5,6,8,17,3,4,17,0,7,17,2,3,5,6,2,3,3,5,6,16,17,17,2,15,7,8,3,2,3,8,9,3,0,1,4,5,3,7,8,15,16,10,8,16,17,17,1,2,3,4,7,0,16,17,17,14,1,2,6,0,1,16,17,17,11,12,5,6,16,7,16,17,17,13,6,7,2,16,17,1,2,4,15,16,16,17,17,11,0,1,0,16,17,3,4,8,10,16,17,13,17,6,6,7,0,5,0,1,15,8,0,4,6,7,3,4,4,7,17,0,3,16,9,4,4,9,10,4,2,5,6,4,9,16,17,11,9,0,0,3,4,5,8,1,17,0,0,15,2,3,7,2,17,0,0,13,6,7,17,8,0,0,14,7,8,8,3,0,2,3,5,17,17,0,17,0,12,2,1,0,4,5,9,11,17,0,15,1,8,9,17,2,7,3,10,2,6,8,9,6,6,9,2,5,0,11,6,6,12,6,4,8,17,6,11,1,13,11,2,17,2,5,7,10,3,2,2,17,5,9,4,2,2,15,9,1,10,2,2,16,10,5,2,5,7,1,2,2,14,4,3,2,7,11,13,2,5,17,17};
static const short Gen_shift_values_BG1_Z_20[2109]= {12,2,7,19,14,6,7,2,13,19,8,6,9,0,19,16,19,0,17,18,6,0,12,1,14,3,19,18,14,19,10,1,5,0,14,8,2,3,19,12,12,14,3,15,2,12,17,5,0,9,11,3,2,3,7,12,5,16,15,19,9,8,15,18,11,0,7,12,13,3,8,0,14,15,7,8,2,3,14,0,8,9,7,10,1,0,17,19,0,1,18,18,19,7,1,13,2,15,4,0,19,14,15,0,11,1,2,6,1,14,15,9,3,3,4,0,13,12,13,15,4,16,3,13,17,18,6,1,9,10,12,4,3,4,8,12,13,6,17,15,16,0,10,8,9,16,19,11,12,1,8,13,3,7,8,19,0,15,6,7,7,8,3,14,19,0,9,7,9,10,1,19,0,16,17,0,1,17,18,19,6,7,0,1,13,1,2,14,15,4,19,0,18,19,15,0,10,11,2,5,6,0,1,15,9,2,3,4,0,12,13,13,14,15,3,4,16,2,3,12,13,18,6,0,1,10,12,3,4,3,3,4,7,8,13,5,6,16,17,16,0,9,10,9,15,16,18,19,12,1,7,8,13,3,8,19,0,15,7,7,8,3,14,0,9,7,9,10,1,0,16,17,0,1,18,19,7,0,1,13,2,14,15,4,0,18,19,15,0,11,2,6,0,1,15,9,2,3,4,0,12,13,13,15,3,4,16,3,12,13,18,6,1,10,12,3,4,3,4,7,8,13,6,16,17,16,0,10,9,16,18,19,12,1,7,8,12,4,11,1,6,18,2,13,5,6,11,1,12,18,7,5,8,9,19,18,15,18,19,16,17,5,19,11,0,13,2,18,17,13,18,9,0,4,19,13,7,1,2,18,11,17,11,13,2,14,1,11,16,4,19,8,10,2,0,1,2,6,11,4,15,14,18,8,7,14,17,10,19,6,6,8,0,12,12,11,1,17,14,11,7,6,9,4,15,17,7,7,17,12,1,2,4,13,14,14,19,9,11,0,1,12,1,2,12,7,17,18,8,4,13,14,13,3,11,1,14,3,4,9,5,15,4,13,14,1,10,11,4,14,5,15,2,11,12,3,13,11,0,1,5,14,15,17,7,6,15,16,19,8,9,8,18,4,13,14,3,12,13,19,9,4,14,15,4,5,6,16,10,19,0,5,14,15,19,9,13,3,7,16,17,8,18,4,14,17,6,7,10,17,7,19,8,9,8,17,18,0,10,7,16,17,17,6,7,2,12,10,0,5,14,15,14,4,16,6,8,17,18,15,7,17,8,17,18,12,1,2,17,7,10,19,0,1,10,11,0,10,4,14,14,3,4,9,13,3,0,9,10,3,12,13,16,6,5,15,12,1,2,8,8,3,15,5,10,6,14,8,13,19,10,14,0,10,15,12,13,5,3,10,8,2,0,15,17,14,15,9,7,10,8,6,5,2,3,16,14,2,0,11,8,9,9,7,12,10,3,1,2,0,19,17,2,19,0,3,1,0,18,1,18,19,9,7,3,1,15,13,4,2,17,15,6,4,2,0,1,19,17,14,15,2,0,13,11,4,1,2,8,6,3,1,17,14,15,11,9,5,3,6,3,4,2,0,15,13,9,15,12,13,17,15,6,4,18,16,5,3,15,13,0,17,18,8,6,3,1,12,9,10,14,12,6,4,8,5,3,6,4,10,8,15,12,13,8,6,19,17,18,15,16,2,0,12,10,11,8,9,18,16,1,19,14,11,12,3,1,10,8,16,8,14,8,7,4,11,9,10,0,5,17,18,11,12,4,5,19,0,11,17,5,6,4,7,1,18,17,14,16,17,18,15,15,16,4,18,10,19,12,2,1,17,16,11,12,17,8,18,19,3,18,11,12,6,0,0,1,17,10,9,10,12,1,13,0,10,14,15,3,18,6,7,9,1,0,1,5,9,10,3,14,12,13,17,7,5,6,13,16,19,8,9,18,5,17,18,13,0,18,17,4,14,19,10,11,8,6,18,18,19,9,14,5,11,0,18,0,1,12,11,7,8,11,12,9,10,18,11,12,4,13,5,6,15,11,9,10,6,11,2,13,17,11,12,19,6,0,13,14,15,11,3,4,4,6,14,15,9,7,14,3,4,9,17,12,1,3,14,15,14,15,18,19,4,17,7,8,3,7,11,1,0,7,9,10,3,12,18,19,12,2,7,19,14,6,7,8,2,13,19,8,6,9,19,0,19,16,19,0,17,18,6,0,12,1,14,3,19,18,14,19,10,1,5,0,14,8,2,4,3,19,12,12,14,3,15,2,12,17,5,0,9,11,3,2,3,7,12,5,16,15,19,9,8,15,18,14,11,0,7,16,6,7,10,7,19,13,10,0,14,3,0,0,9,0,2,12,17,9,0,4,16,17,12,3,9,18,16,19,1,10,9,6,9,10,7,8,16,10,2,11,4,13,9,8,4,9,0,19,11,15,10,4,18,12,9,13,9,2,2,4,13,5,12,2,7,15,10,19,1,13,12,13,17,2,15,6,5,9,19,18,5,8,1,10,17,18,14,11,2,2,16,19,14,15,8,9,12,4,13,3,8,0,8,15,7,8,3,14,0,9,7,10,19,1,0,17,9,0,1,18,19,7,1,13,2,15,4,0,19,15,0,11,2,6,1,15,9,3,6,4,0,13,13,15,4,16,3,13,18,6,1,10,12,4,3,4,8,13,6,17,16,0,10,9,16,19,12,1,8,11,14,15,5,9,9,17,6,9,8,3,10,12,9,13,2,12,17,8,9,4,16,16,17,6,12,3,9,18,16,18,19,10,9,5,6,9,10,7,8,16,9,10,2,11,3,4,13,9,7,8,4,9,0,11,15,9,10,4,18,11,12,13,9,1,2,2,4,12,13,5,12,1,2,7,7,15,10,19,1,12,13,12,13,16,17,2,15,5,6,16,5,9,19,18,5,7,8,1,10,16,17,8,18,2,3,14,15,10,10,1,2,2,3,18,9,14,15,4,2,4,5,16,14,15,11,12,15,16,12,13,14,1,2,15,16,8,16,17,9,10,19,14,15,13,14,10,15,5,6,17,0,1,15,16,2,10,4,17,18,19,15,7,8,8,9,10,18,19,4,11,17,18,7,8,13,1,15,16,5,7,18,19,18,18,19,2,3,8,0,1,11,12,11,15,4,5,4,10,11,13,14,7,16,2,3,18,15,8,5,13,10,5,1,2,0,17,12,9,13,9,10,1,8,5,19,16,5,2,14,11,12,9,15,11,12,6,3,5,2,2,18,19,5,2,6,3,3,0,4,1,12,9,6,2,3,18,15,7,4,0,16,17,7,9,6,5,2,4,0,1,0,17,5,2,16,13,7,4,11,8,6,2,3,0,17,14,11,8,4,5,9,6,5,2,18,14,15,18,15,0,17,9,5,6,1,18,8,5,18,14,15,3,0,11,8,6,3,15,12,17,14,9,5,6,8,5,9,6,13,9,10,18,15,11,8,2,18,19,1,18,5,2,15,12,14,11,1,18,4,0,1,17,14,6,3,13,9,10,10,0,4,5,16,17,9,12,3,4,4,5,0,11,16,17,6,4,6,7,18,16,17,13,14,17,18,14,15,16,3,4,17,18,10,18,19,11,12,1,16,17,15,16,12,17,7,8,19,2,3,17,18,12,6,19,0,1,17,9,10,1,10,11,12,0,1,13,19,0,9,10,10,15,3,17,18,7,9,0,1,0,0,1,4,5,10,2,3,13,14,13,17,6,7,6,12,13,15,16,9,18,4,5,9,19,19,12,6,15,4,3,17,7,12,4,19,11,12,6,7,18,4,13,11,14,5,4,1,4,5,2,3,11,5,17,17,6,19,8,4,3,19,4,15,6,10,5,19,13,7,8,4,17,14,17,19,8,0,7,17,2,10,5,14,16,8,7,8,12,17,10,1,0,4,14,13,0,3,16,5,12,18,18,17,19,7,8,18,3,15,9,10,2,3,17,17,18,9,15,3,4,2,5,16,15,12,14,15,16,13,13,14,2,16,8,17,10,19,15,14,9,10,15,6,16,17,1,16,9,10,4,18,18,19,15,8,7,8,10,19,14,11,18,8,12,13,1,16,4,5,7,19,18,19,3,7,8,1,12,10,11,15,5,3,4,11,14,6,7,16,3,10,18,3,0,1,16,11,7,11,19,16,13,6,3,6,19,9,13,14,5,6,5,1,12,13,13,14,9,0,5,6,15,13,15,16,7,5,6,2,3,4,6,7,3,4,5,12,13,6,7,19,7,8,0,1,10,5,6,4,5,1,6,16,17,8,11,12,6,7,1,15,8,9,10,6,18,19,19,0,1,9,10,2,8,9,18,19,4,12,6,7,16,18,9,10,9,9,10,13,14,19,11,12,2,3,2,6,15,16,15,1,2,4,5,18,7,13,14,15,5,10,1,2,17,9,9,10,7,5,16,2,11,9,11,12,3,2,18,19,2,3,0,1,9,2,3,15,4,16,17,6,2,0,1,17,2,13,4,8,2,3,17,11,4,5,6,2,14,15,15,17,5,6,18,5,14,15,0,8,3,12,14,5,6,8,5,6,9,10,15,8,18,19,15,18,2,12,11,18,0,1,14,3,9,10,12,2,7,19,13,14,6,7,2,13,19,8,6,9,0,19,16,19,0,17,18,6,0,12,1,14,6,3,19,18,14,19,10,18,1,5,0,14,8,2,3,19,12,12,14,3,15,2,12,17,5,0,9,11,3,2,3,7,12,5,16,15,19,9,8,15,18,11,0,7,0,7,5};
static const short Gen_shift_values_BG1_Z_22[2109]= {7,10,5,8,7,12,5,12,4,14,21,7,4,7,15,14,8,3,0,10,0,6,1,17,11,15,16,2,0,5,7,7,16,17,0,12,3,8,10,14,2,21,4,3,21,8,8,21,14,16,14,6,0,20,16,17,8,10,12,8,11,2,6,10,11,15,10,7,8,11,6,9,7,8,13,6,12,13,5,15,21,0,8,5,8,16,15,8,9,4,1,10,11,1,7,2,18,12,16,17,3,0,1,6,8,7,8,17,18,0,1,13,4,8,9,11,15,2,3,0,5,4,0,9,8,9,0,15,16,17,15,7,1,21,17,17,18,9,11,12,13,9,12,2,3,7,11,11,12,16,11,8,11,5,6,8,9,8,12,13,5,6,13,5,14,15,0,8,4,5,8,15,16,14,15,9,4,0,1,11,0,1,6,7,2,17,18,11,12,16,16,17,2,3,1,6,7,8,8,16,17,17,18,1,13,3,4,9,11,14,15,3,21,0,4,5,4,21,0,8,9,9,0,14,15,17,15,6,7,1,20,21,16,17,18,8,9,10,11,13,9,11,12,3,6,7,10,11,12,16,10,11,8,11,6,8,9,8,13,5,6,13,5,15,0,8,4,5,8,16,14,15,9,4,1,11,1,6,7,2,18,11,12,16,17,2,3,1,6,8,8,17,17,18,1,13,3,4,9,11,14,15,3,0,4,5,4,0,8,9,9,0,15,17,15,6,7,1,21,16,17,18,9,10,11,13,9,12,3,7,10,11,12,16,10,11,19,13,4,7,2,5,20,4,9,2,19,9,1,11,18,4,1,8,4,12,11,5,0,19,7,19,3,20,14,8,12,13,21,19,2,4,4,13,14,19,9,0,5,7,11,13,21,18,1,0,18,5,5,18,11,13,11,3,8,19,17,13,14,5,7,9,5,8,21,3,7,8,12,7,15,7,6,21,10,17,17,19,18,2,14,3,10,16,16,13,10,16,13,11,7,8,14,10,11,17,13,10,18,14,15,11,7,8,8,18,15,10,7,20,16,17,5,2,13,10,10,6,7,21,13,10,21,17,18,20,16,17,14,11,9,6,6,2,3,16,13,6,2,3,12,8,9,7,4,1,19,20,17,13,14,21,18,0,18,19,8,4,5,6,3,11,8,13,9,10,13,10,0,18,19,1,19,20,6,3,18,15,9,5,6,14,11,16,13,20,16,17,3,8,5,5,1,2,10,6,7,9,6,5,1,2,14,10,11,14,11,5,2,20,16,17,0,19,20,17,12,8,9,3,6,3,4,0,1,0,18,19,1,20,14,10,11,16,12,13,18,15,14,11,17,13,14,16,8,5,12,8,9,16,12,13,17,14,21,18,16,12,13,14,1,21,6,0,3,19,0,6,20,10,4,10,4,2,15,1,2,18,5,13,0,16,3,2,15,1,2,20,7,13,0,13,20,6,7,12,21,0,9,7,15,16,15,2,12,21,15,2,1,10,0,9,16,2,3,11,20,8,17,18,4,5,8,17,14,1,9,18,3,12,19,6,1,10,2,11,10,19,8,16,17,13,0,15,2,15,1,2,2,11,3,12,8,16,17,20,7,11,20,16,2,3,18,5,0,9,1,10,18,19,7,16,12,21,11,20,7,16,16,3,16,2,3,7,16,0,9,2,10,11,0,9,14,1,20,8,17,6,15,2,11,3,11,12,16,3,18,5,20,6,7,16,3,19,6,10,18,19,14,1,18,5,19,5,6,1,10,18,5,11,12,18,9,21,21,9,0,1,4,21,2,2,0,1,6,21,5,6,20,8,14,15,1,20,8,1,9,8,1,2,19,16,3,4,16,0,17,11,5,0,9,10,18,15,16,21,1,0,1,10,11,15,16,6,19,1,2,4,8,17,18,15,20,19,15,2,1,2,15,8,9,10,8,0,16,14,10,10,11,2,4,5,6,2,5,17,18,0,4,5,4,5,9,4,21,13,12,1,21,11,11,14,9,11,12,21,11,16,8,9,17,16,8,18,3,11,7,8,11,19,17,18,12,7,4,14,4,9,10,5,21,14,15,19,20,5,6,4,9,11,11,20,20,21,14,4,16,6,7,12,14,17,18,6,3,7,8,14,7,3,11,12,12,3,18,20,18,9,10,4,2,19,20,21,12,13,14,21,16,12,15,6,10,13,14,15,19,13,14,11,14,9,12,11,16,9,13,16,8,18,3,11,8,6,11,19,18,12,7,4,14,4,10,5,21,15,19,20,6,4,9,11,11,20,21,4,16,7,1,12,14,18,6,3,8,7,3,12,12,3,18,20,18,10,4,2,20,21,12,14,16,12,15,6,10,14,0,15,19,14,21,7,4,5,13,2,21,3,4,6,20,21,14,15,5,15,18,13,16,0,15,20,13,20,12,0,7,15,12,20,15,1,0,16,11,8,18,8,14,9,3,19,1,2,10,8,13,15,0,15,2,3,8,20,11,1,16,18,0,10,7,12,11,7,16,16,7,0,2,0,14,8,6,2,3,16,18,20,16,19,10,14,18,19,1,18,7,21,15,10,20,15,2,15,2,17,5,4,17,3,6,1,4,15,3,8,1,8,0,10,17,3,0,15,3,11,10,6,4,21,18,6,18,2,19,13,7,11,12,20,18,1,3,3,12,13,18,8,21,1,4,6,10,20,17,0,21,17,4,4,17,10,12,10,2,18,16,12,13,4,6,8,4,7,20,2,6,7,11,6,14,12,0,9,16,17,5,10,2,17,3,13,0,17,12,5,8,3,5,6,5,10,2,3,8,10,2,12,19,5,1,2,5,13,11,12,6,1,20,8,20,3,4,21,15,8,9,13,14,21,0,20,3,5,5,14,14,15,20,10,0,1,6,8,11,12,0,19,1,2,1,19,5,6,15,6,19,12,14,12,3,4,20,18,13,14,15,6,7,8,0,10,6,9,0,4,7,8,9,13,7,8,0,3,19,20,0,1,16,0,4,5,19,20,5,19,6,7,14,0,18,19,0,7,8,6,7,1,18,14,15,3,14,15,20,21,16,9,10,3,4,8,8,9,16,17,15,20,21,0,0,8,9,9,10,15,15,5,17,18,1,3,6,7,17,13,14,18,19,6,18,13,14,0,1,1,14,6,7,9,7,20,21,15,12,13,8,9,10,0,1,2,3,5,1,3,4,17,20,21,2,3,4,8,2,3,0,10,3,13,20,8,1,10,11,0,10,5,15,20,7,8,12,5,15,19,7,7,17,14,2,0,10,19,6,7,0,10,8,18,7,16,17,1,11,18,6,15,3,3,13,15,3,21,8,9,16,4,10,20,4,13,14,10,8,18,9,19,17,4,5,15,3,20,8,0,10,0,10,9,19,10,19,20,15,3,5,15,18,5,6,1,11,3,13,7,16,17,17,5,14,2,19,6,7,18,6,14,2,1,10,11,1,11,14,2,7,17,9,19,7,17,21,8,9,15,3,13,1,9,18,19,10,20,1,11,3,12,13,5,15,1,11,4,14,17,5,21,9,3,12,13,4,14,8,18,3,12,13,3,6,0,1,3,4,20,3,7,8,0,1,8,0,9,10,17,3,21,0,3,10,11,9,10,4,21,17,18,6,17,18,1,2,19,12,13,6,7,11,11,12,19,20,18,1,2,3,3,11,12,12,13,18,8,20,21,4,6,9,10,0,20,16,17,21,0,21,16,17,3,4,7,4,17,9,10,12,10,1,2,18,15,16,11,12,13,3,4,5,6,8,4,6,7,20,1,2,5,6,7,11,5,6,11,17,8,12,15,11,1,9,11,14,9,12,11,16,9,11,16,8,18,3,11,8,11,19,18,12,7,4,14,4,10,11,5,21,15,19,20,6,4,9,11,11,20,21,4,16,7,12,14,18,18,6,3,8,7,3,12,12,3,18,20,18,10,4,2,20,21,12,14,16,12,15,6,10,14,15,19,14,2,14,12,11,4,5,8,3,6,4,5,10,3,10,9,10,2,12,18,19,5,2,5,13,12,5,6,1,20,7,8,20,4,21,15,9,13,14,0,19,20,3,5,4,5,14,15,19,20,10,1,5,6,8,12,21,0,19,2,15,1,19,6,5,6,19,12,13,14,12,4,20,18,14,14,15,6,8,9,10,6,9,21,0,4,8,8,9,13,8,9,19,10,3,15,21,14,7,17,16,2,12,10,2,7,3,6,0,1,3,4,1,3,7,8,0,1,8,0,9,10,17,3,21,0,3,10,11,9,10,16,4,21,17,18,6,17,18,1,2,19,12,13,6,7,11,11,12,19,20,18,1,2,3,3,11,12,12,13,18,8,20,21,4,6,9,10,20,16,17,21,0,21,16,17,3,4,4,17,9,10,12,10,1,2,18,15,16,11,12,13,3,4,5,6,8,4,6,7,20,1,2,5,6,7,11,5,6,21,2,19,21,0,21,4,18,19,11,4,18,6,13,21,17,18,21,7,5,6,0,17,14,2,14,19,20,15,9,2,3,7,8,15,16,14,19,21,21,8,8,9,14,4,16,17,0,2,5,6,16,13,17,18,17,13,21,0,0,13,6,8,6,19,20,2,14,12,7,8,9,0,1,2,8,4,0,3,16,20,1,2,3,7,1,2,15,18,13,16,12,15,20,13,20,12,0,7,15,12,15,1,0,16,11,8,18,8,14,9,3,19,1,1,2,10,8,13,15,6,15,2,3,8,20,11,16,18,0,10,7,12,11,7,16,16,7,0,2,0,14,8,6,2,3,16,18,20,16,19,10,14,18,19,1,18,15,0,14};
static const short Gen_shift_values_BG1_Z_24[2109]= {18,3,12,11,18,9,14,1,3,15,8,0,23,23,19,10,12,23,15,23,16,6,18,2,8,18,15,7,4,9,14,23,8,11,12,6,16,16,5,14,20,7,4,0,15,19,22,2,4,9,17,15,17,10,11,1,23,6,11,18,12,17,12,14,9,15,20,18,19,4,13,12,18,19,10,15,1,2,4,16,8,9,1,0,0,20,11,12,13,0,16,23,0,17,7,19,3,9,19,16,8,4,5,10,15,23,0,9,12,12,13,7,17,16,17,6,15,20,21,8,5,1,16,20,22,23,3,5,9,10,18,16,18,11,12,1,2,0,7,11,12,19,13,17,18,13,15,9,10,16,21,19,4,12,13,11,12,19,9,10,14,15,2,4,15,16,9,1,23,0,0,19,20,10,11,13,0,15,16,0,16,17,6,7,19,2,3,8,9,19,15,16,7,8,5,10,14,15,0,8,9,11,12,13,7,16,17,17,6,14,15,21,7,8,4,5,1,15,16,19,20,23,3,4,5,10,18,15,16,18,10,11,11,12,2,23,0,6,7,12,19,12,13,18,12,13,14,15,10,16,20,21,19,4,13,11,12,19,10,14,15,2,4,16,9,1,23,0,0,20,10,11,13,0,16,0,17,6,7,19,3,8,9,19,16,7,8,5,10,15,0,9,11,12,13,7,16,17,17,6,14,15,21,8,4,5,1,16,19,20,23,3,5,10,18,15,16,18,11,11,12,2,0,6,7,12,19,13,18,13,14,15,10,16,20,21,19,12,7,16,1,0,2,7,22,3,13,14,16,4,21,13,12,18,12,8,23,1,12,4,12,5,19,7,15,21,7,4,20,17,22,3,12,21,0,1,19,5,5,18,3,21,9,20,17,13,4,8,11,15,17,22,6,4,0,6,23,0,14,12,19,0,7,1,6,1,3,22,4,9,2,13,16,0,14,19,12,17,8,8,13,3,20,1,17,13,21,22,6,7,14,15,6,13,14,18,13,21,4,11,12,9,16,17,10,20,4,22,6,10,17,18,3,11,19,3,18,1,2,20,18,2,14,21,22,5,12,13,7,15,18,2,10,17,18,18,2,11,18,19,1,8,9,13,21,21,4,5,3,10,11,13,21,10,17,18,2,9,10,23,7,4,12,9,16,17,18,2,3,10,11,6,13,14,7,15,1,9,11,18,19,11,19,0,8,9,16,17,17,15,23,2,9,10,23,6,7,19,3,10,17,18,14,21,22,17,1,21,5,23,6,7,4,12,12,20,10,17,18,14,12,20,5,12,13,6,13,14,20,4,18,1,2,1,8,9,6,14,13,21,7,14,15,7,12,20,7,14,15,9,16,17,4,12,10,18,15,22,23,7,5,15,8,12,8,14,14,9,4,2,9,14,22,17,16,13,14,1,23,10,8,9,7,23,16,13,14,7,5,12,10,5,23,20,21,1,23,13,11,6,3,4,22,20,21,19,21,19,17,15,8,6,10,7,8,21,19,13,11,21,18,19,14,12,4,2,16,14,0,22,6,4,16,14,13,11,5,3,2,23,0,7,5,12,10,21,18,19,6,4,9,7,10,7,8,4,2,14,12,14,11,12,3,1,12,10,7,18,15,16,5,3,2,0,22,20,13,11,17,15,20,17,18,0,22,2,0,7,4,5,15,13,13,11,22,15,13,8,6,9,7,23,20,21,21,19,4,2,9,6,7,16,14,10,8,15,12,13,10,8,12,10,7,4,5,13,11,18,16,19,4,17,5,15,1,1,4,5,14,23,22,0,4,5,20,1,11,12,14,2,18,19,11,10,8,10,6,21,22,23,10,2,9,10,3,17,5,13,19,1,5,2,18,14,15,20,1,9,10,19,22,22,23,17,3,2,3,16,1,6,7,18,15,11,2,6,8,9,13,15,19,20,4,2,4,21,22,11,12,10,17,21,22,5,23,3,4,23,1,18,19,20,2,7,21,7,16,16,10,11,0,9,18,16,17,0,0,15,19,20,1,7,9,21,14,6,4,5,5,1,15,16,18,5,21,5,22,11,12,0,8,13,14,0,21,12,13,10,15,20,5,14,16,17,17,18,12,21,22,22,11,19,20,2,13,9,10,5,6,21,0,1,4,8,10,15,23,20,21,23,16,16,17,7,5,11,12,6,17,0,18,23,18,19,20,15,21,1,2,3,12,21,20,3,18,23,12,10,12,0,17,9,8,1,8,4,19,21,8,0,8,1,15,3,11,17,3,0,16,13,18,23,8,17,20,21,15,1,8,1,14,23,5,16,13,9,0,4,7,11,13,18,2,0,2,19,20,10,8,15,20,3,21,2,21,23,0,18,0,5,19,14,8,21,14,9,18,15,11,3,0,20,7,1,4,5,14,23,22,18,5,20,1,12,14,2,19,11,10,13,10,6,21,23,10,2,10,3,17,5,13,19,5,2,18,15,20,1,23,10,19,22,23,17,3,4,3,16,1,7,18,15,11,2,6,9,13,15,20,4,2,4,21,22,12,10,17,22,5,23,4,23,1,20,2,7,12,5,15,20,0,5,10,16,21,23,16,12,2,12,21,6,5,9,12,3,8,19,21,9,2,18,17,13,17,13,4,18,6,17,9,17,10,0,12,20,2,12,9,1,22,3,8,17,2,5,6,0,10,2,10,23,8,14,1,22,18,9,13,16,20,22,3,11,9,11,4,5,19,17,0,5,12,6,11,6,8,3,9,14,23,16,22,23,22,8,3,15,1,1,4,5,18,3,9,1,10,19,17,18,1,16,20,21,11,8,10,22,15,7,5,6,6,2,16,17,19,6,22,6,23,12,13,1,9,14,15,1,22,13,14,11,16,21,6,15,17,18,19,13,22,23,23,12,20,21,3,14,10,11,7,22,1,2,4,5,9,11,16,0,21,22,0,17,17,18,8,6,12,13,2,18,1,19,0,19,20,21,16,22,2,3,13,22,6,7,5,6,14,13,3,4,8,9,20,22,9,10,3,19,17,18,18,13,14,4,5,7,18,9,10,18,10,11,0,1,13,20,21,2,3,13,9,10,1,2,23,4,8,9,18,2,3,5,6,12,7,1,10,11,11,0,8,9,15,1,2,22,23,19,19,9,10,13,14,17,21,22,23,4,12,9,10,12,4,5,5,6,20,17,18,0,1,6,13,6,7,12,6,7,8,9,4,10,14,15,12,11,21,20,6,5,5,3,4,12,11,3,2,8,6,7,3,19,18,21,20,9,8,2,1,18,17,17,15,16,17,16,13,12,4,2,3,6,5,17,16,9,8,17,16,10,9,0,22,23,12,11,20,19,2,0,1,22,12,11,9,8,1,23,0,22,21,3,2,8,7,17,16,2,1,5,3,4,6,5,0,23,10,8,9,10,9,23,22,8,6,7,14,13,1,0,22,20,21,18,17,9,8,13,11,12,16,15,20,19,22,21,3,2,11,10,9,7,8,11,10,4,3,5,3,4,19,18,17,16,0,22,23,5,4,12,11,6,5,11,10,6,5,8,6,7,3,2,9,8,14,12,13,18,3,11,12,10,11,5,18,8,9,13,14,1,3,14,15,8,0,22,23,23,18,19,9,10,12,23,14,15,23,15,16,5,6,18,1,2,7,8,18,14,15,6,7,4,9,13,14,23,7,8,10,11,12,6,15,16,16,5,13,14,8,20,6,7,3,4,0,14,15,18,19,6,22,2,3,4,9,17,14,15,17,9,10,10,11,1,22,23,5,6,11,18,11,12,17,11,12,13,14,9,15,19,20,10,7,0,8,13,3,9,23,20,5,14,13,20,11,16,7,3,5,17,10,2,1,1,21,12,14,1,17,1,18,8,22,20,4,10,20,17,9,6,11,16,1,10,13,14,8,18,18,7,16,1,22,9,6,2,17,21,0,4,6,11,19,17,19,12,13,3,1,8,13,20,14,19,14,16,11,17,22,17,0,8,20,13,14,23,8,7,13,14,5,10,4,20,21,23,11,3,4,20,19,19,15,6,7,8,19,11,18,19,12,2,14,22,4,14,11,3,23,0,5,10,18,19,4,7,7,8,2,12,11,12,1,10,15,16,3,0,9,20,11,15,17,18,22,0,4,5,13,11,13,6,7,20,21,19,2,6,7,14,8,12,13,8,10,4,5,11,16,16,8,0,21,17,20,9,8,6,12,23,3,1,18,23,21,6,14,15,13,14,16,21,11,12,16,17,4,6,17,18,11,3,1,2,2,21,22,12,13,13,15,2,17,18,2,18,19,8,9,21,4,5,10,11,21,17,18,9,10,7,12,16,17,2,10,11,13,14,15,9,18,19,19,8,16,17,23,9,10,6,7,3,17,18,21,22,1,5,6,7,12,20,17,18,20,12,13,13,14,4,1,2,8,9,14,21,14,15,20,14,15,16,17,12,18,22,23,19,4,13,11,12,19,10,14,15,16,2,4,16,9,1,23,0,0,20,10,11,13,0,16,0,17,6,7,19,3,8,9,19,16,7,8,5,10,15,0,9,11,12,13,7,16,17,17,6,14,15,21,8,4,5,1,16,19,20,23,3,5,10,18,15,16,11,18,11,11,12,2,0,6,7,17,12,19,13,18,13,14,15,10,16,20,21,4,13,22,21,7,4,19,0,11,13,1,18,10,9,9,5,20,22,9,1,9,2,16,4,12,18,5,4,1,17,14,19,0,18,9,18,21,22,16,2,2,15,0,6,17,14,10,1,5,8,12,14,19,3,1,3,20,21,11,9,16,21,4,22,3,22,0,19,1,6,14,4,14};
static const short Gen_shift_values_BG1_Z_26[2109]= {24,20,0,2,24,9,4,24,9,19,24,18,5,24,22,7,24,8,2,24,17,21,24,20,19,24,10,4,24,0,16,24,11,19,24,14,3,24,6,22,24,23,7,24,0,3,24,4,5,24,2,12,24,19,15,24,21,14,24,10,14,24,12,0,24,3,10,25,24,20,0,2,25,24,9,4,25,24,9,19,25,24,18,5,24,22,7,25,24,8,2,25,24,17,21,24,20,19,24,10,4,25,24,0,16,25,24,11,19,25,24,14,3,25,24,6,22,25,24,23,7,24,0,3,25,24,4,5,25,24,2,12,24,19,15,25,24,21,14,25,24,10,14,25,24,12,0,25,24,3,10,24,20,1,0,3,2,24,10,9,5,4,24,9,20,19,24,18,6,5,24,23,22,8,7,24,8,3,2,24,18,17,22,21,24,21,20,20,19,24,11,10,5,4,24,0,17,16,24,12,11,20,19,24,14,4,3,24,6,23,22,24,24,23,8,7,24,1,0,4,3,24,4,6,5,24,2,13,12,24,20,19,16,15,24,22,21,15,14,24,10,15,14,24,13,12,1,0,24,3,11,10,24,20,0,3,2,24,9,5,4,24,9,19,24,18,6,5,24,22,8,7,24,8,2,24,17,22,21,24,20,20,19,24,10,5,4,24,0,16,24,11,20,19,24,14,4,3,24,6,23,22,24,23,8,7,24,0,4,3,24,4,5,24,2,13,12,24,19,16,15,24,21,15,14,24,10,14,24,12,1,0,24,3,11,10,23,21,18,14,20,22,2,18,3,24,21,18,3,13,18,12,25,23,18,16,1,18,2,22,18,11,15,18,14,13,18,4,24,18,20,10,18,5,13,18,8,23,18,0,16,12,18,17,1,18,20,23,18,24,25,18,22,6,24,18,13,9,18,15,8,18,4,8,18,6,20,18,23,4,4,5,0,6,23,21,23,11,12,14,9,7,22,2,23,7,10,3,6,9,13,12,11,15,14,15,7,10,18,22,21,13,17,16,1,7,10,18,21,2,6,5,7,10,1,4,14,18,17,0,7,10,5,9,8,16,20,19,7,10,17,20,11,15,14,7,10,0,4,3,4,8,7,7,10,3,7,6,2,6,5,7,10,19,23,22,13,17,16,7,10,9,12,25,3,2,7,10,20,24,23,2,6,5,7,10,23,0,12,16,15,7,10,15,18,5,9,8,10,7,10,6,10,9,16,20,19,7,10,9,13,12,12,16,15,7,10,13,16,14,18,17,7,10,11,14,21,25,24,17,7,10,2,6,5,24,2,1,7,10,4,8,7,23,1,0,7,10,19,22,23,1,0,20,7,10,21,25,24,9,13,12,7,10,12,15,19,23,22,22,5,9,14,0,18,3,7,16,21,24,25,15,11,17,3,19,18,25,14,5,20,7,22,1,3,19,18,14,3,9,24,11,3,19,18,14,3,24,13,3,19,18,23,12,10,25,3,18,1,16,12,1,3,19,18,13,2,7,22,3,19,18,22,11,0,15,3,18,25,14,24,13,3,18,15,4,9,24,3,19,18,5,20,21,10,3,19,18,16,5,24,13,3,19,18,19,8,8,23,3,19,18,11,0,1,16,18,3,19,18,2,17,12,1,3,18,5,20,8,23,3,19,18,9,24,10,25,3,19,18,7,22,17,6,15,3,18,24,13,20,9,3,19,18,0,15,19,8,3,19,18,15,4,19,8,3,19,18,17,6,5,20,3,19,18,8,23,15,4,25,5,19,20,22,25,24,19,18,14,20,22,25,19,18,3,24,19,18,3,13,19,18,12,25,16,18,16,1,19,18,2,22,19,18,11,15,18,14,13,0,18,4,24,19,18,20,10,19,18,5,13,19,18,8,23,19,18,0,16,19,18,17,1,18,20,23,19,18,24,25,19,18,22,6,18,13,9,19,18,15,8,19,18,4,8,19,18,6,20,15,19,18,23,4,0,19,13,25,0,1,18,14,20,23,22,16,18,3,25,24,5,18,3,13,18,12,0,25,18,16,2,1,18,2,22,18,11,16,15,18,14,14,13,18,4,25,24,18,20,10,18,5,14,13,2,18,8,24,23,18,0,17,16,18,17,2,1,25,18,20,24,23,18,24,25,18,22,7,6,18,13,10,9,18,15,9,8,0,18,4,8,18,6,21,20,18,23,5,4,24,20,0,2,24,9,4,9,24,9,19,24,18,5,15,24,22,7,24,8,2,24,17,21,24,20,19,24,10,4,24,0,16,24,11,19,24,14,3,3,24,6,22,24,23,7,24,0,3,24,4,5,24,2,12,24,19,15,24,21,14,24,10,14,24,12,0,17,24,3,10,12,1,3,2,24,0,14,10,15,17,11,5,9,1,8,2,24,4,6,5,2,13,8,2,13,23,2,22,9,11,2,0,11,2,12,6,2,21,25,2,24,23,2,14,8,2,4,20,14,2,15,23,2,18,7,4,2,10,0,2,1,11,2,4,7,2,8,9,2,6,16,2,23,19,2,25,18,2,14,18,2,16,4,2,7,14,5,7,17,15,16,17,5,25,0,18,17,1,21,4,0,6,8,8,4,15,10,4,15,25,4,24,11,20,4,2,13,8,4,14,8,4,23,1,4,0,25,4,16,10,4,6,22,4,17,25,4,20,9,1,4,12,2,4,3,13,4,6,9,4,10,11,4,8,18,4,25,21,4,1,20,4,16,20,4,18,6,4,9,16,3,21,15,1,20,11,9,14,19,9,21,3,0,13,14,4,0,6,9,8,4,15,11,10,13,4,15,25,4,24,12,11,4,2,14,13,4,14,8,4,23,2,1,4,0,0,25,4,16,11,10,4,6,22,4,17,0,25,4,20,10,9,4,12,3,2,4,3,14,13,4,6,10,9,5,4,10,11,4,8,19,18,4,25,22,21,4,1,21,20,1,4,16,20,4,18,7,6,4,9,17,16,18,14,21,20,23,22,1,18,4,3,25,24,18,3,14,13,18,12,0,25,18,17,16,2,1,18,2,23,22,18,12,11,16,15,18,15,14,14,13,18,5,4,25,24,18,20,11,10,18,6,5,14,13,9,18,8,24,23,18,0,17,16,18,18,17,2,1,7,18,21,20,24,23,18,24,0,25,18,22,7,6,18,14,13,10,9,18,16,15,9,8,18,4,9,8,18,7,6,21,20,18,23,5,4,19,10,15,6,21,12,23,15,14,19,10,4,21,25,17,16,3,19,10,4,21,14,5,19,10,13,4,0,18,17,19,10,17,8,2,20,19,19,10,3,20,23,14,19,10,12,3,16,8,7,19,10,15,6,14,6,5,22,19,10,5,22,25,17,16,19,10,21,12,11,2,19,10,6,23,14,6,5,19,10,9,0,24,16,15,19,10,1,18,17,9,8,19,10,18,9,2,20,19,19,10,21,12,24,16,15,19,10,25,16,0,17,19,10,23,14,7,25,24,19,10,14,5,10,2,1,19,10,16,7,9,1,0,19,10,5,22,9,0,19,10,7,24,21,13,12,19,10,24,15,5,23,22,18,14,21,20,23,22,5,18,4,3,25,24,18,3,14,13,18,12,0,25,18,17,16,2,1,18,2,23,22,18,12,11,16,15,18,15,14,14,13,18,5,4,25,24,18,20,11,10,18,6,5,14,13,18,8,24,23,18,0,17,16,21,18,18,17,2,1,18,21,20,24,23,10,18,24,0,25,18,22,7,6,18,14,13,10,9,18,16,15,9,8,18,4,9,8,18,7,6,21,20,18,23,5,4,9,3,5,13,3,22,14,24,1,23,3,5,1,12,7,3,1,12,22,1,21,8,1,25,10,1,11,5,1,20,24,18,1,23,22,1,13,7,1,3,19,1,14,22,1,17,6,1,9,25,11,1,0,10,1,3,6,1,7,8,1,5,15,1,22,18,1,24,17,1,13,17,1,15,3,1,6,13,5,17,20,16,4,3,25,5,7,4,3,14,9,3,4,3,14,24,4,3,23,10,3,1,12,4,3,13,7,4,3,22,0,3,25,24,3,15,9,4,3,5,21,4,3,16,24,4,3,19,8,4,3,11,1,4,3,2,12,1,3,5,8,4,3,9,10,4,3,7,17,3,24,20,4,3,0,19,4,3,15,19,4,3,17,5,4,3,8,15,12,11,15,21,3,1,4,5,9,5,11,1,22,11,23,4,0,7,6,9,8,6,4,16,15,11,10,4,15,0,25,4,24,12,11,4,3,2,14,13,9,4,14,9,8,4,24,23,2,1,4,1,0,0,25,4,17,16,11,10,4,6,23,22,4,18,17,0,25,4,20,10,9,4,12,3,2,4,4,3,14,13,4,7,6,10,9,4,10,12,11,4,8,19,18,4,0,25,22,21,4,2,1,21,20,4,16,21,20,4,19,18,7,6,4,9,17,16,18,14,20,23,22,18,3,25,24,0,18,3,13,18,12,0,25,18,16,2,1,18,2,22,18,11,16,15,18,14,14,13,18,4,25,24,18,20,10,18,5,14,13,18,8,24,23,18,0,17,16,18,17,2,1,18,20,24,23,18,24,25,18,22,7,6,6,18,13,10,9,18,15,9,8,20,18,4,8,18,6,21,20,18,23,5,4,1,23,3,5,3,1,12,7,1,12,22,1,21,8,1,25,10,1,11,5,1,20,24,1,23,22,5,1,13,7,1,3,19,11,1,14,22,1,17,6,1,9,25,1,0,10,1,3,6,1,7,8,1,5,15,1,22,18,1,24,17,1,13,17,1,15,3,1,6,13,24,18,22};
static const short Gen_shift_values_BG1_Z_28[2109]= {26,0,10,4,15,6,17,9,16,2,6,10,24,17,7,4,17,6,11,9,17,16,16,10,1,20,12,15,27,2,8,8,13,5,19,9,14,20,8,16,18,20,6,22,17,12,13,8,20,13,5,11,25,1,17,0,4,14,1,2,26,19,5,1,24,18,17,26,27,1,11,5,15,16,7,18,9,10,17,3,6,7,11,25,18,8,5,17,18,7,12,9,10,18,17,17,11,2,21,13,16,27,0,3,9,8,9,14,6,19,20,10,15,20,21,9,17,18,19,21,7,23,18,13,13,14,9,21,13,14,6,12,26,2,18,0,1,5,15,1,2,3,27,19,20,6,2,24,25,19,18,27,1,10,11,4,5,16,6,7,17,18,10,17,2,3,7,11,24,25,18,7,8,4,5,18,7,11,12,10,17,18,16,17,17,10,11,1,2,21,12,13,15,16,0,3,8,9,9,13,14,5,6,20,10,14,15,21,9,16,17,19,20,21,6,7,23,17,18,12,13,14,9,20,21,14,6,11,12,26,1,2,17,18,1,4,5,14,15,2,3,26,27,20,5,6,1,2,25,19,17,18,27,1,11,4,5,16,7,17,18,10,17,3,7,11,24,25,18,8,4,5,18,7,12,10,18,16,17,17,11,1,2,21,13,15,16,0,3,9,9,14,5,6,20,10,14,15,21,9,16,17,19,21,6,7,23,18,12,13,14,9,21,14,6,11,12,26,2,17,18,1,5,14,15,2,3,27,20,6,1,2,25,19,17,18,1,9,11,13,23,17,23,0,19,2,2,22,1,15,19,23,9,1,2,20,17,2,19,24,22,2,1,1,23,14,5,25,0,12,15,21,21,26,18,4,22,27,5,21,1,23,3,5,19,7,2,25,26,21,5,26,18,24,13,10,14,2,13,17,27,14,15,11,4,18,14,9,3,2,17,17,6,0,20,6,22,23,3,16,19,19,15,9,17,14,4,16,6,26,15,16,20,9,10,4,3,21,22,11,12,5,22,23,10,25,15,4,22,18,7,8,22,12,26,16,12,1,2,3,5,23,23,12,13,20,9,10,5,23,22,12,27,16,17,25,15,5,22,23,4,21,22,4,22,26,15,16,17,6,7,8,26,0,17,18,3,20,21,15,5,18,8,24,13,14,24,14,1,18,19,21,10,11,7,25,25,15,2,19,20,8,26,24,14,4,21,22,20,6,24,8,25,26,22,11,12,10,0,5,22,23,0,17,18,1,19,24,14,8,25,26,1,19,21,11,27,16,17,7,13,3,17,6,7,5,22,23,16,6,20,9,10,2,19,20,17,7,18,8,14,3,4,10,7,25,21,10,11,17,6,7,12,2,6,24,5,22,23,1,8,8,16,20,4,16,24,21,25,24,5,18,25,18,26,3,4,0,6,10,16,4,10,23,15,20,21,6,12,17,23,10,9,14,15,16,22,2,8,6,11,12,10,16,24,2,17,23,7,13,4,10,17,22,23,6,12,11,17,9,14,15,17,23,16,22,16,22,10,16,1,7,20,26,12,18,15,21,27,4,5,2,8,8,14,8,13,14,13,19,5,11,19,24,25,9,15,14,20,20,25,26,8,14,16,22,1,18,23,24,20,26,6,12,22,0,17,23,12,18,13,18,19,8,14,20,26,13,18,19,5,11,11,17,6,25,3,1,7,17,23,0,5,6,4,10,14,20,1,6,7,2,8,26,4,19,24,25,5,11,1,7,24,1,2,18,24,17,23,3,1,6,23,2,27,13,20,21,23,5,27,24,9,10,1,12,3,4,11,25,0,1,5,19,27,12,2,27,11,12,1,6,3,4,12,11,11,5,24,15,15,7,10,21,22,25,3,2,3,8,0,13,14,4,9,14,15,3,11,12,13,15,1,17,12,7,7,8,3,15,7,8,0,6,20,24,12,22,23,27,9,23,24,25,21,13,14,0,24,20,18,19,13,12,13,6,14,22,22,14,24,26,8,1,2,5,13,4,14,15,7,7,14,0,4,8,21,22,15,5,1,2,15,4,9,7,15,13,14,14,8,26,27,18,10,12,13,25,0,6,6,11,2,3,18,17,7,11,12,18,6,13,14,16,18,3,4,12,20,15,9,10,11,6,18,11,3,8,9,23,27,14,15,26,2,11,12,12,27,0,24,17,3,26,27,22,16,14,15,15,17,27,21,4,23,6,13,26,5,19,23,27,13,23,6,24,21,6,23,0,26,6,5,5,27,18,9,1,4,16,19,25,25,2,22,8,26,3,14,9,25,5,7,9,23,11,6,1,2,25,9,2,22,0,14,18,6,17,21,3,18,19,15,8,22,18,20,13,7,6,27,25,3,6,3,2,25,3,2,17,7,5,18,1,7,13,15,25,19,20,2,21,4,24,3,17,21,25,11,13,4,22,19,4,21,26,24,4,3,3,25,16,7,27,2,14,17,23,8,23,0,20,6,24,1,17,7,23,3,5,7,21,9,4,27,0,23,7,0,20,26,12,16,4,15,19,1,16,17,13,6,20,16,11,5,4,23,18,23,21,21,24,27,2,7,3,6,27,9,10,12,22,16,20,27,18,1,21,0,14,18,22,8,16,1,19,16,7,1,18,23,21,1,0,0,22,13,4,24,27,11,14,20,20,25,17,3,21,26,24,4,20,0,2,4,18,6,1,24,25,20,4,25,17,23,9,13,1,12,16,26,13,14,10,3,17,13,8,2,1,0,25,8,24,22,7,15,14,11,0,5,5,12,20,1,11,13,23,16,17,0,19,1,2,9,22,1,15,19,23,8,9,2,20,16,17,2,19,24,22,2,0,1,1,23,13,14,5,25,27,0,12,15,21,21,26,17,18,4,22,26,27,5,21,0,1,3,5,18,19,7,2,24,25,10,26,21,5,26,18,23,24,10,14,1,2,13,17,26,27,24,14,15,11,4,18,13,14,9,3,1,2,10,12,21,22,15,16,5,27,17,18,0,1,21,0,13,14,18,22,7,8,1,18,19,15,16,1,18,22,23,21,0,1,27,0,0,21,22,12,13,4,23,24,26,27,11,14,19,20,20,24,25,16,17,17,3,21,25,26,4,20,27,0,2,3,4,17,18,13,6,0,1,23,24,25,20,3,4,25,17,22,23,9,12,13,0,1,12,15,16,25,26,13,14,9,10,3,16,17,12,13,8,2,0,1,7,15,9,17,19,27,13,20,21,24,4,15,23,26,5,6,6,18,26,25,5,11,19,15,23,19,27,5,12,13,26,6,16,24,13,20,21,26,6,15,23,20,0,18,26,26,6,25,4,5,25,5,19,27,10,17,18,20,1,9,21,1,24,3,4,8,16,11,19,17,25,17,25,22,2,14,21,22,0,8,18,26,23,2,3,1,9,17,25,25,4,5,27,7,1,9,15,22,23,3,11,26,6,21,0,1,22,2,17,25,1,9,22,2,14,22,20,27,0,6,14,10,18,26,5,6,9,17,13,21,23,2,3,10,18,11,19,7,15,0,8,14,22,10,17,18,5,13,27,7,26,5,6,1,3,12,13,6,7,23,18,8,9,19,20,12,19,4,5,9,13,26,27,20,9,10,6,7,20,9,13,14,12,19,20,18,19,19,12,13,3,4,23,14,15,17,18,2,5,10,11,11,15,16,7,8,22,12,16,17,23,11,18,19,12,21,22,23,8,9,25,19,20,14,15,1,16,11,22,23,16,8,13,14,0,3,4,19,20,3,6,7,16,17,4,5,0,1,22,7,8,3,4,27,21,19,20,1,20,20,24,25,17,11,9,17,19,1,23,6,25,8,23,0,7,21,25,1,15,8,26,23,8,25,2,0,8,7,4,7,1,20,11,3,6,18,21,27,27,4,24,10,0,5,11,27,7,25,9,11,25,13,8,3,4,27,11,4,24,2,16,20,8,19,23,5,20,21,17,10,24,20,15,9,8,25,16,27,5,24,25,27,9,3,13,14,5,16,24,7,8,15,1,4,5,9,23,16,6,3,15,16,5,10,7,8,16,15,15,9,0,19,11,14,25,26,1,7,6,7,12,4,17,18,8,13,18,19,7,15,16,17,19,5,26,21,16,11,11,12,7,19,11,12,4,10,24,0,16,26,27,3,13,27,0,1,25,17,18,4,0,22,23,17,16,10,5,16,9,11,20,20,1,10,16,11,22,18,3,26,21,23,4,5,26,27,1,10,0,1,11,12,4,11,24,25,1,5,18,19,12,1,2,26,27,6,12,1,5,6,4,11,12,10,11,11,4,5,23,24,15,6,7,9,10,22,25,2,3,3,7,8,27,0,14,4,8,9,15,3,10,11,13,14,15,0,1,17,11,12,6,7,8,3,14,15,8,0,5,6,20,23,24,11,12,23,26,27,8,9,24,25,20,21,14,27,0,23,24,19,13,11,12,20,22,4,25,26,9,0,10,11,9,3,10,24,0,4,17,18,11,1,25,26,11,0,5,3,11,9,10,10,4,22,23,14,6,8,9,21,24,2,2,7,26,27,13,3,7,8,14,2,9,10,12,14,27,0,16,11,5,6,7,2,14,7,27,4,5,21,19,23,10,11,22,26,7,8,21,23,24,20,13,27,22,23,18,12,10,11,10,12,22,16,27,27,18,1,21,0,14,18,22,8,1,19,16,1,18,23,21,1,0,0,22,13,3,4,24,27,11,14,20,8,20,25,17,3,21,26,4,20,0,2,4,18,6,1,24,25,20,4,25,17,23,9,13,1,12,16,26,13,14,10,3,17,13,8,2,1,15,8,0};
static const short Gen_shift_values_BG1_Z_30[2109]= {14,5,8,7,16,3,22,5,25,14,13,15,11,10,0,9,23,7,25,22,26,12,1,28,5,21,1,5,22,25,23,14,7,0,24,10,5,7,8,21,14,5,23,4,10,16,14,24,2,6,2,19,26,5,1,9,4,24,29,12,6,14,19,21,16,5,8,14,15,6,9,8,16,17,4,23,5,6,26,15,13,14,16,12,11,1,10,23,24,8,26,22,23,27,13,2,29,6,22,2,6,22,23,26,24,14,15,8,1,24,25,11,6,7,8,9,22,14,15,6,24,5,11,17,14,15,25,3,6,7,3,20,27,6,2,9,10,5,25,29,0,13,7,14,15,20,22,16,17,6,9,15,6,8,9,7,8,17,3,4,22,23,6,26,14,15,14,16,11,12,11,0,1,9,10,24,8,25,26,23,26,27,12,13,2,28,29,5,6,22,1,2,5,6,23,26,23,24,15,7,8,0,1,25,11,5,6,8,9,21,22,15,5,6,23,24,5,10,11,16,17,15,25,2,3,7,3,19,20,27,5,6,1,2,10,4,5,24,25,0,13,6,7,15,19,20,21,22,17,6,8,9,15,6,9,7,8,17,4,22,23,6,26,15,14,16,11,12,11,1,9,10,24,8,26,23,27,12,13,2,29,5,6,22,2,5,6,23,26,24,15,8,0,1,25,11,5,6,8,9,21,22,15,6,23,24,5,11,16,17,15,25,3,7,3,19,20,27,6,1,2,10,5,24,25,0,13,7,15,20,21,22,17,6,8,9,3,0,14,5,8,7,1,16,3,22,20,5,25,14,13,15,11,16,10,0,9,23,7,25,22,26,12,1,28,5,21,1,5,22,25,23,14,7,0,24,10,5,7,8,21,22,14,5,23,4,10,16,14,24,2,6,2,19,29,26,5,1,9,4,24,29,12,6,14,19,21,16,5,8,29,18,21,22,9,1,26,21,12,16,25,28,1,15,17,17,23,8,14,11,16,17,10,15,16,0,19,25,6,11,12,25,0,1,14,8,14,28,4,17,22,23,16,22,18,24,14,19,20,20,13,19,3,8,9,12,17,18,26,2,10,16,28,3,4,25,1,29,4,5,15,20,21,4,10,1,6,7,8,13,14,24,0,4,9,10,8,13,14,25,1,28,4,26,1,2,17,23,10,15,16,3,8,9,27,3,13,19,8,13,14,10,16,11,17,24,29,0,12,17,23,8,13,14,26,1,2,7,13,13,18,19,19,24,25,17,23,27,3,5,10,11,9,15,5,11,22,27,28,26,29,5,8,13,14,4,9,10,12,18,7,12,13,27,2,3,2,8,15,21,9,14,15,24,17,23,22,27,28,24,29,0,19,25,8,14,11,16,17,18,18,11,25,10,16,1,1,24,25,0,9,19,24,23,29,1,2,20,23,23,26,22,25,14,1,3,4,18,21,7,10,24,20,22,23,10,13,29,2,28,0,1,0,3,26,29,25,28,15,18,24,27,8,10,11,22,25,10,13,7,9,10,11,14,27,0,16,19,13,16,20,23,6,9,16,19,20,23,7,9,10,10,13,8,11,29,1,2,22,25,15,18,9,11,12,25,28,20,23,22,24,25,23,26,6,9,13,29,1,2,20,23,8,11,19,22,25,28,1,4,29,1,2,9,12,17,20,21,23,24,17,20,4,7,0,11,14,20,23,16,19,24,26,27,19,22,9,12,14,16,17,27,0,21,24,29,1,2,4,7,6,9,1,3,4,20,23,23,26,1,5,4,3,29,7,19,14,15,6,9,8,9,16,17,4,23,5,6,26,15,13,14,16,12,4,11,1,10,23,24,8,26,22,23,27,13,2,29,6,3,22,2,6,22,23,26,24,14,15,8,1,24,25,11,6,7,8,9,22,14,15,6,24,5,11,17,14,15,25,3,6,7,3,20,27,6,2,9,10,5,25,29,0,13,7,14,15,20,22,27,16,17,6,9,3,23,1,4,11,15,4,25,28,26,27,8,6,23,11,12,17,25,15,4,3,5,0,1,0,20,28,29,13,27,15,12,16,1,2,21,18,24,25,11,21,24,25,12,15,13,4,27,19,20,9,14,0,24,25,27,28,10,11,4,25,12,13,22,24,0,5,6,4,14,22,26,22,8,9,16,25,20,21,29,24,13,14,21,19,2,26,4,9,10,11,6,25,27,28,9,0,3,2,11,28,17,17,0,20,9,8,10,6,1,5,25,4,18,2,20,17,21,7,26,23,0,16,26,0,17,20,18,9,2,25,19,5,0,23,2,3,16,9,0,18,29,5,11,9,19,27,1,27,14,21,0,26,4,29,19,24,7,1,9,14,16,4,11,0,3,2,21,15,8,8,2,4,29,22,13,28,17,8,17,15,24,15,18,17,16,26,13,2,15,5,24,23,25,21,6,20,10,19,3,17,5,2,6,22,11,8,15,1,11,15,2,5,3,22,24,17,10,4,20,15,16,17,18,1,24,15,3,14,20,26,24,4,12,16,12,29,6,15,11,19,14,4,9,22,16,24,29,1,26,15,18,16,1,4,4,5,24,16,5,27,4,6,26,18,12,3,6,5,1,14,1,20,3,23,12,11,13,9,27,8,28,7,1,21,5,23,20,24,10,29,26,3,19,29,3,20,23,21,12,5,28,22,8,3,5,5,6,19,12,3,21,2,8,14,12,22,0,4,0,17,24,3,29,7,2,22,27,10,4,12,17,19,14,3,6,26,20,10,0,12,10,18,7,14,21,8,1,12,19,24,28,19,22,20,21,0,17,5,6,21,19,9,28,27,29,24,25,24,14,22,23,7,21,9,6,10,25,26,15,12,18,19,5,15,18,19,6,9,7,28,21,13,14,8,24,18,19,21,22,4,5,28,19,6,7,18,24,29,0,1,28,8,16,20,16,2,3,10,19,14,15,23,18,7,8,27,13,26,20,28,3,4,5,0,19,21,22,0,21,23,24,22,23,19,2,18,19,7,8,21,11,29,0,29,1,26,27,26,15,16,24,25,9,23,10,11,8,11,12,27,28,17,13,14,20,21,7,16,17,20,21,8,11,8,9,0,22,23,15,16,18,10,26,20,21,23,24,6,7,0,20,21,8,9,25,20,25,26,1,2,0,10,17,18,22,18,4,5,12,20,21,16,17,25,19,20,9,10,15,28,21,22,0,4,5,6,7,2,21,23,24,9,3,0,24,3,27,2,25,26,11,5,28,22,17,10,11,12,0,24,20,14,9,3,8,2,10,4,6,29,0,5,29,25,19,4,27,28,18,12,2,26,20,14,17,11,21,15,7,0,1,26,20,23,17,0,23,24,28,16,10,26,20,0,23,24,17,11,20,14,18,12,9,3,2,26,25,18,19,19,13,5,29,0,23,24,2,26,3,27,16,9,10,9,3,0,24,18,11,12,29,23,5,29,11,4,5,9,3,19,13,27,21,1,25,27,21,14,7,8,21,15,0,24,26,19,20,4,28,29,23,19,12,13,24,18,7,1,1,25,9,3,14,8,16,9,10,11,5,0,24,3,26,27,16,7,9,10,8,9,12,18,4,5,23,24,7,27,15,16,15,17,12,13,12,1,2,10,11,25,9,26,27,24,27,28,13,14,3,29,0,6,7,23,2,3,6,7,24,27,24,25,16,8,9,1,2,26,12,6,7,9,10,22,23,19,16,6,7,24,25,6,11,12,17,18,0,16,26,3,4,8,4,20,21,28,6,7,2,3,11,5,6,25,26,1,14,7,8,16,20,21,22,23,18,7,9,10,18,11,21,4,10,26,21,29,24,15,18,17,26,13,2,20,15,5,24,23,25,21,20,10,19,3,17,5,2,6,22,23,11,8,15,1,11,15,2,5,3,24,17,10,4,20,15,17,18,1,24,24,15,3,14,20,26,24,4,12,16,12,29,6,15,11,19,14,4,9,22,16,24,29,1,26,15,18,10,26,11,9,25,26,17,20,19,27,28,15,4,28,16,17,7,26,24,25,27,23,22,12,21,4,5,19,7,3,4,8,24,13,10,17,3,13,17,3,4,7,5,25,26,19,12,5,6,22,17,18,19,20,3,25,26,17,5,23,16,22,28,25,26,6,14,17,18,14,1,8,17,13,20,21,16,6,10,11,24,18,25,26,1,3,27,28,17,20,0,29,25,19,24,7,17,21,3,12,29,22,8,4,23,26,17,19,20,18,19,11,28,14,15,3,4,17,7,25,26,25,27,22,23,22,11,12,20,21,19,5,19,6,7,4,7,8,23,24,13,9,10,16,17,3,12,13,16,17,4,7,4,5,26,18,19,11,12,6,22,16,17,19,20,2,3,26,16,17,4,5,16,21,22,27,28,26,6,13,14,18,14,0,1,8,16,17,12,13,21,15,16,5,6,11,24,17,18,26,0,1,2,3,28,17,19,20,20,11,14,12,13,22,9,27,28,21,11,1,20,19,21,16,17,16,6,14,15,29,13,1,28,2,17,18,7,4,10,11,27,7,10,11,28,1,29,20,13,5,6,0,16,10,11,13,14,26,27,20,11,28,29,10,16,21,22,20,0,8,12,8,24,25,6,2,11,6,7,15,10,29,0,18,5,18,12,20,25,26,27,22,11,13,14,12,3,6,5,10,14,1,20,3,23,12,11,13,9,8,28,7,21,5,23,20,24,10,29,26,3,0,19,29,3,20,23,21,6,12,5,28,22,8,3,5,6,19,12,3,21,2,8,14,12,22,0,4,0,17,24,3,29,7,2,22,27,10,4,12,17,19,14,3,6,26,23,2};
static const short Gen_shift_values_BG1_Z_32[2109]= {25,1,9,24,4,14,24,1,14,24,30,20,19,27,30,19,3,6,20,9,28,21,29,4,2,7,16,18,26,12,30,4,6,7,13,27,21,30,5,21,8,13,26,12,0,18,2,3,0,22,13,15,26,20,11,29,12,19,2,30,26,14,20,15,30,27,11,25,26,2,10,25,4,5,15,25,1,2,15,25,30,31,21,20,28,31,20,3,4,7,21,9,10,29,22,30,5,3,8,17,19,26,27,13,31,4,5,7,8,13,14,28,22,30,31,6,22,8,9,14,27,13,1,19,2,3,4,1,22,23,14,16,27,21,12,29,30,13,20,2,3,31,27,14,15,21,16,30,31,28,12,26,2,9,10,24,25,5,14,15,24,25,2,15,24,25,31,21,19,20,28,30,31,19,20,4,7,20,21,10,28,29,21,22,30,4,5,2,3,8,16,17,18,19,27,13,30,31,5,6,7,7,8,14,28,21,22,31,6,21,22,9,13,14,26,27,13,0,1,18,19,3,4,0,1,23,14,15,16,27,20,21,11,12,30,12,13,19,20,3,31,26,27,15,20,21,15,16,31,28,11,12,26,2,10,24,25,5,15,24,25,2,15,25,31,21,19,20,28,31,19,20,4,7,21,10,29,21,22,30,5,2,3,8,17,18,19,27,13,31,5,7,7,8,14,28,21,22,31,6,21,22,9,14,26,27,13,1,18,19,3,4,1,23,14,15,16,27,21,11,12,30,13,19,20,3,31,27,15,21,15,16,31,28,11,12,28,5,12,20,28,11,12,23,1,11,11,20,1,11,17,7,6,1,14,17,6,22,25,7,28,15,8,16,23,21,26,3,5,13,31,17,23,25,26,0,14,8,17,24,8,6,27,0,13,31,19,5,21,22,19,9,0,2,27,13,7,30,16,31,6,21,17,13,1,7,2,17,14,30,26,22,21,27,2,19,10,28,18,27,11,30,30,6,7,10,20,18,28,26,3,4,9,18,19,15,21,31,31,8,9,9,18,19,3,18,28,31,9,9,18,19,15,25,5,15,4,13,14,6,12,22,15,24,25,4,13,14,20,30,23,1,5,14,15,26,4,13,22,23,6,15,16,14,24,21,30,31,19,28,29,24,2,1,10,11,3,12,13,11,21,29,7,15,24,25,21,31,23,0,1,24,1,2,30,8,12,22,6,15,16,15,25,22,0,6,15,16,18,25,3,30,7,8,11,20,21,29,7,17,26,27,3,12,13,19,29,20,30,17,26,27,7,17,30,8,0,9,10,5,11,21,5,14,15,28,5,6,14,24,29,6,7,4,13,14,19,29,15,25,11,20,21,3,31,9,5,14,15,0,9,10,15,25,12,22,28,5,6,12,6,21,12,20,13,13,28,23,1,20,6,31,16,25,21,15,16,29,24,5,0,20,15,12,0,26,27,10,5,20,15,8,29,23,24,10,5,20,15,26,20,21,16,11,15,10,23,18,26,21,15,10,31,25,26,2,29,16,11,5,31,0,24,19,17,12,25,20,0,27,30,25,3,30,12,7,14,9,22,16,17,8,3,26,21,0,26,27,2,29,3,30,9,3,4,23,18,17,12,26,20,21,1,28,17,12,18,4,30,31,9,4,22,17,8,3,28,23,14,9,30,24,25,31,26,28,23,18,12,13,9,4,11,6,21,22,17,16,11,7,2,25,19,20,8,3,15,10,30,24,25,26,21,22,17,10,4,5,16,11,11,6,26,20,21,23,18,7,2,13,31,9,20,31,9,6,23,24,0,8,23,16,2,3,13,23,31,0,13,23,28,29,19,18,23,26,29,18,1,2,5,19,7,8,27,20,28,3,1,22,6,15,17,24,25,11,29,2,3,5,6,11,12,26,20,28,29,4,20,6,7,12,25,11,31,17,0,1,2,31,20,21,12,14,25,19,10,27,28,11,18,0,1,29,25,12,13,19,14,24,28,29,26,10,13,22,13,30,15,4,13,21,29,11,12,7,24,2,11,12,31,21,2,12,18,8,6,7,15,18,6,7,23,26,8,29,16,8,9,17,24,21,22,27,4,5,6,14,0,18,24,26,26,27,0,1,15,8,9,18,25,8,9,28,1,13,14,30,0,20,5,6,22,23,20,10,1,2,3,14,8,30,31,17,0,6,7,10,22,18,14,2,8,2,3,18,15,30,31,19,27,3,18,30,8,18,31,27,8,18,24,14,13,16,21,24,13,29,0,14,3,22,15,23,30,28,1,10,12,20,6,24,30,0,1,7,21,15,16,24,31,15,2,7,20,6,26,12,28,29,26,16,7,9,20,14,5,23,6,13,28,24,20,8,14,9,18,24,21,5,6,3,26,0,15,9,8,7,26,18,27,8,7,30,31,25,1,9,24,22,4,14,24,1,14,24,30,20,19,25,27,30,19,3,6,20,9,28,21,29,4,2,7,16,18,26,12,30,24,4,6,7,13,27,21,14,30,5,21,8,13,26,12,0,18,2,3,0,22,13,15,26,20,11,29,12,19,2,30,26,14,20,15,30,27,11,24,24,12,2,10,31,13,27,29,27,18,9,23,23,31,7,22,15,2,12,22,31,12,22,28,18,17,21,25,28,17,11,1,4,18,7,26,19,27,2,0,5,14,16,24,10,28,2,4,5,11,25,19,19,28,3,19,6,11,24,10,30,16,0,1,30,20,11,13,24,18,9,27,10,17,0,28,24,12,18,13,28,25,9,22,7,19,21,2,18,22,28,24,7,1,31,4,20,30,0,8,16,30,31,11,21,30,31,21,8,21,31,5,27,25,26,2,5,25,26,10,13,27,16,3,27,28,4,11,8,9,14,23,24,25,1,19,5,11,13,13,14,20,2,27,28,5,12,27,28,15,20,0,1,19,7,24,25,11,9,10,7,29,20,21,22,1,27,17,18,4,19,25,26,19,9,5,1,21,27,21,22,5,2,17,18,3,11,18,19,1,2,23,14,23,24,1,2,11,24,1,2,8,30,28,29,5,7,8,28,29,13,16,29,30,19,5,6,30,31,7,13,14,11,12,17,25,26,27,28,4,22,7,8,14,15,16,16,17,8,23,5,30,31,8,15,30,31,18,22,23,3,4,23,22,9,10,27,28,12,13,9,10,0,23,24,25,4,29,30,20,21,7,21,22,28,29,12,8,3,4,24,29,30,24,25,8,5,20,21,5,23,13,31,21,7,4,21,22,16,2,26,12,4,21,22,30,13,31,26,12,4,22,10,28,0,18,31,16,17,7,25,10,28,31,16,17,15,1,18,4,0,18,21,7,8,26,1,18,19,9,27,16,2,14,31,0,16,19,5,28,14,30,15,16,6,24,24,10,10,28,16,2,18,4,19,4,5,25,11,7,25,1,18,19,10,28,17,3,1,18,19,20,6,25,11,6,23,24,24,10,12,30,30,15,16,14,0,15,1,12,30,2,20,25,11,27,12,13,6,24,0,18,23,8,9,9,27,24,10,31,16,17,14,0,10,28,6,24,26,12,0,18,27,12,13,10,28,7,25,23,8,9,19,27,2,3,17,18,28,30,7,8,17,18,27,8,17,18,24,14,12,13,21,23,24,12,13,29,0,13,14,3,21,22,14,15,23,29,30,27,28,1,9,10,11,12,20,6,23,24,30,31,0,0,1,7,21,14,15,24,31,14,15,15,2,6,7,19,20,6,25,26,11,12,6,28,29,25,26,16,7,8,9,20,13,14,4,5,23,5,6,12,13,28,24,19,20,8,13,14,8,9,24,21,4,5,1,26,8,18,30,6,3,30,0,8,16,31,11,21,31,0,8,21,31,5,27,26,2,5,26,10,13,27,16,3,28,4,4,11,9,14,23,25,1,19,5,11,13,14,20,2,28,5,12,28,14,15,20,1,19,7,25,9,10,7,29,20,22,1,27,18,4,19,26,9,5,1,21,27,22,5,2,18,4,8,18,23,19,20,28,4,19,30,31,9,19,5,27,28,9,19,24,25,15,14,22,25,14,29,30,1,15,3,4,23,16,24,31,29,2,11,13,20,21,7,25,30,31,1,2,7,8,22,16,24,25,0,16,2,3,8,21,27,7,27,13,28,29,30,27,16,17,8,10,21,15,6,23,24,7,14,28,29,25,21,8,9,15,10,24,25,22,6,6,22,28,2,12,10,20,31,28,8,20,6,12,10,22,3,11,18,19,1,2,20,14,23,24,1,2,11,24,1,2,8,30,28,29,5,7,8,28,29,28,13,16,29,30,19,5,6,30,31,7,13,14,11,12,17,25,26,27,28,4,22,7,8,14,15,16,16,17,23,5,30,31,8,15,30,31,18,22,23,3,4,22,9,10,27,28,12,13,9,10,0,23,24,25,4,29,30,20,21,7,21,22,28,29,12,8,3,4,24,29,30,24,25,8,5,20,21,5,13,21,3,4,16,26,3,4,22,13,26,4,10,0,30,31,7,10,30,31,15,18,0,21,8,0,1,9,16,13,14,19,28,29,30,6,24,10,16,18,18,19,25,7,0,1,10,17,0,1,20,25,5,6,24,12,29,30,14,15,12,2,25,26,27,2,6,0,22,23,9,24,30,31,12,14,10,6,26,0,26,27,10,7,22,23,6,14,22,5,10,17,27,5,14,27,5,11,1,0,8,11,0,16,19,1,22,9,2,10,17,15,28,20,29,31,7,25,11,2,17,19,20,26,8,2,11,18,2,21,26,7,25,13,31,15,16,13,3,26,28,7,1,24,10,25,0,15,11,7,27,1,28,11,8,24,20,22,6};
static const short Gen_shift_values_BG1_Z_36[2109]= {30,34,5,6,17,22,0,7,17,3,5,6,21,3,24,35,2,15,26,3,21,9,3,1,23,21,26,16,28,8,35,35,2,4,7,0,17,35,14,20,6,1,35,35,12,6,16,7,35,35,13,25,2,35,20,22,16,35,35,11,19,0,17,4,8,10,35,30,31,35,6,7,17,18,23,1,7,8,18,4,5,6,7,22,4,25,0,2,3,16,27,3,4,22,10,4,2,24,22,27,17,28,29,9,0,35,0,3,5,7,8,1,18,35,0,15,21,6,7,2,0,0,13,7,16,17,8,0,35,0,14,26,3,0,21,22,23,17,0,35,0,12,20,0,1,18,5,8,9,11,0,31,35,5,6,6,7,18,22,23,0,1,8,18,3,4,6,7,21,22,4,24,25,35,0,3,16,26,27,4,21,22,9,10,4,1,2,23,24,22,26,27,16,17,29,9,35,0,0,2,3,4,5,8,1,17,18,0,15,20,21,7,1,2,35,0,0,12,13,6,7,17,8,35,0,0,14,25,26,3,35,0,20,21,23,16,17,35,0,0,12,19,20,1,17,18,4,5,9,11,35,0,31,35,6,6,7,18,23,0,1,8,18,4,6,7,21,22,4,25,35,0,3,16,27,4,22,9,10,4,2,23,24,22,27,16,17,29,9,0,0,3,4,5,8,1,17,18,0,15,20,21,7,2,35,0,0,13,6,7,17,8,0,0,14,25,26,3,0,20,21,23,17,35,0,0,12,20,1,18,4,5,9,11,35,0,29,18,30,34,5,6,8,17,22,0,0,7,17,3,5,6,21,35,3,24,35,2,15,26,3,21,9,3,1,23,21,26,16,28,8,35,35,2,4,7,0,17,35,14,20,30,6,1,35,35,12,6,16,7,35,35,13,25,1,2,35,20,22,16,35,35,11,19,0,17,4,8,10,35,6,7,35,24,17,22,32,6,35,24,8,9,3,31,19,8,13,12,17,19,23,24,20,24,25,17,31,0,0,4,5,14,18,19,35,21,26,31,0,17,21,22,19,24,20,25,35,3,4,35,17,22,2,6,7,13,17,18,16,21,29,34,4,8,9,17,22,35,3,4,23,27,28,17,22,15,19,20,1,5,6,35,4,4,8,9,30,34,35,6,11,22,27,13,17,18,13,18,16,20,21,18,22,23,21,26,14,19,31,35,0,13,18,28,33,34,2,3,4,20,25,15,19,20,13,17,18,13,18,26,30,31,20,24,25,30,35,21,26,13,17,18,13,18,27,32,3,7,8,25,16,21,13,17,18,34,2,3,0,5,30,34,35,13,17,18,13,18,25,30,33,1,2,9,14,19,31,35,0,18,22,23,22,27,24,29,13,17,18,14,17,14,20,25,8,23,3,28,33,0,27,14,17,20,33,20,21,1,25,8,32,9,33,18,20,7,8,25,13,3,27,22,10,33,34,20,8,6,30,8,31,32,9,33,24,12,6,30,27,15,2,26,5,28,29,18,6,29,17,6,29,30,24,12,12,0,6,30,4,28,26,14,24,12,29,17,19,7,31,18,19,11,35,2,26,2,25,26,5,29,7,31,10,33,34,3,27,20,8,2,25,26,17,5,23,11,21,9,32,33,4,28,2,26,2,26,15,3,9,33,19,6,7,10,34,2,26,2,25,26,16,4,28,16,0,5,29,2,26,23,11,25,12,13,19,7,2,26,2,25,26,14,2,22,10,3,26,27,20,8,7,31,11,34,35,13,1,2,26,20,8,17,27,6,21,26,30,31,35,6,7,14,17,18,23,1,7,8,18,4,5,6,7,22,35,4,25,0,2,3,16,27,3,4,22,10,4,2,24,35,22,27,17,28,29,9,0,35,0,3,5,7,8,1,18,35,0,15,21,6,7,2,0,0,13,7,16,17,8,0,35,0,14,26,3,0,21,22,23,17,0,35,0,12,20,0,1,18,5,10,8,9,11,0,35,5,0,15,35,6,23,27,34,34,35,25,10,15,28,29,35,0,10,32,34,35,13,14,32,17,27,28,31,8,19,32,14,1,2,32,30,15,16,14,19,8,9,21,1,28,28,31,32,33,2,0,29,9,10,28,7,12,13,35,30,27,28,35,28,5,34,35,9,0,28,28,6,17,18,31,28,12,13,15,9,27,28,31,28,4,12,29,10,32,33,1,3,27,28,30,34,5,6,17,22,0,17,7,17,3,5,6,21,12,3,24,35,2,15,26,3,21,9,3,1,23,21,26,16,28,8,35,35,2,4,7,0,17,26,35,14,20,6,1,35,35,12,6,16,7,35,35,13,25,2,35,20,22,16,35,35,11,19,0,17,4,17,8,10,35,8,28,35,35,17,16,6,35,24,35,35,35,9,35,35,6,10,17,18,12,29,34,12,19,29,15,17,18,33,8,15,0,11,14,27,2,15,33,21,15,13,35,33,2,28,4,20,11,17,11,14,16,19,12,29,35,11,26,32,18,13,11,11,24,18,28,19,11,11,25,1,14,11,32,34,28,11,11,23,31,12,29,16,20,22,11,27,9,13,8,17,35,8,35,4,35,35,35,20,30,34,5,6,19,17,22,0,7,17,3,5,6,21,18,3,24,35,35,2,15,26,3,21,9,3,1,23,21,26,16,28,8,35,35,2,4,7,0,17,13,35,14,20,6,1,35,35,12,6,16,7,35,35,13,25,2,35,20,22,16,35,35,11,19,0,17,4,8,10,35,24,35,35,2,35,35,35,24,8,35,35,22,35,10,25,1,5,12,12,13,24,29,6,7,35,14,24,10,12,13,27,28,10,31,5,6,9,22,33,10,28,15,16,10,8,29,30,28,33,22,23,35,15,6,6,9,10,11,14,7,23,24,6,21,26,27,13,8,5,6,6,19,12,13,35,23,14,6,6,20,31,32,9,6,26,27,29,23,5,6,35,6,18,26,7,24,10,11,15,17,5,6,24,28,34,35,35,0,35,11,15,16,29,30,1,11,32,33,35,0,14,15,33,17,18,28,29,32,9,19,20,33,14,15,2,3,33,30,31,16,17,15,19,20,9,10,22,2,28,29,29,31,32,33,34,17,1,30,10,11,29,8,13,14,0,30,31,28,29,35,29,5,6,35,0,10,1,28,29,29,7,18,19,32,28,29,13,14,16,9,10,28,29,29,5,12,13,30,10,11,33,34,2,4,28,29,16,14,20,18,27,25,28,25,26,3,1,8,6,22,19,20,35,29,27,3,1,25,23,27,25,28,26,7,4,5,25,23,10,8,21,18,19,24,22,1,35,12,10,25,23,7,5,31,28,29,25,23,23,21,9,6,7,35,7,5,12,10,2,35,0,14,12,30,28,21,19,21,19,24,22,26,23,24,29,27,22,20,3,0,1,21,19,0,34,6,3,4,28,26,23,21,21,18,19,21,19,34,32,28,25,26,2,0,29,27,21,19,21,19,35,33,11,8,9,24,22,21,19,6,3,4,8,6,2,0,21,18,19,21,19,33,31,5,3,22,20,3,1,26,23,24,30,28,32,30,21,18,19,13,17,23,24,24,25,35,0,4,5,18,19,26,0,21,22,24,25,3,4,22,6,7,17,18,21,34,8,9,22,3,4,27,28,22,19,20,5,6,4,8,9,34,35,11,27,17,18,18,20,21,22,23,26,19,35,0,18,33,2,3,30,25,19,20,17,18,18,30,31,24,25,35,35,26,17,18,18,32,7,8,21,17,18,2,3,5,34,35,17,18,18,30,1,2,19,35,0,22,23,27,29,17,18,35,35,3,17,16,35,35,35,19,23,30,31,6,11,25,18,32,6,28,30,31,10,28,13,24,27,4,15,28,10,34,25,28,26,12,10,15,5,17,33,24,24,27,29,32,25,6,24,3,9,35,31,26,24,24,1,31,5,32,24,24,2,14,27,24,9,11,5,24,24,0,8,25,6,29,33,35,24,35,15,35,35,30,31,35,6,7,17,18,23,1,35,7,8,18,4,5,6,7,22,4,25,0,2,3,16,27,3,4,22,10,4,2,24,22,27,17,28,29,9,0,35,0,3,5,7,8,1,18,35,0,15,21,6,7,2,0,35,0,13,7,16,17,8,0,35,0,14,26,3,0,21,22,23,17,0,35,0,12,20,0,1,18,5,8,9,11,0,9,35,35,35,8,35,20,8,35,35,1,35,35,35,2,30,34,4,5,5,6,26,17,21,22,35,0,7,17,2,3,5,6,20,21,3,23,24,34,35,35,2,15,25,26,3,20,21,8,9,3,0,1,22,23,21,25,26,15,16,28,8,34,35,35,1,2,3,4,7,0,16,17,35,14,19,20,6,0,1,34,35,35,11,12,5,6,16,7,34,35,35,13,24,25,2,34,35,19,20,22,15,16,34,35,35,11,18,19,0,16,17,3,4,8,10,34,35,13,17,24,24,25,0,5,18,19,15,26,0,22,24,25,3,4,22,7,17,18,21,34,9,22,4,27,28,22,20,5,6,4,9,34,35,11,27,18,18,21,22,23,26,19,35,0,18,33,2,3,25,20,17,18,18,31,24,25,35,26,18,18,32,7,8,26,21,18,2,3,5,35,17,18,35,18,30,2,19,0,22,23,27,29,17,18,15,19,26,27,17,2,7,21,28,2,24,26,27,6,24,9,20,23,0,11,24,6,30,24,22,8,35,6,11,1,13,29,20,35,20,23,25,28,21,2,20,35,5,27,22,20,20,33,27,1,28,20,20,34,10,23,20,5,7,1,20,20,32,4,21,2,25,29,31,20,23,35,35};
static const short Gen_shift_values_BG1_Z_40[2109]= {32,22,27,19,14,6,7,22,13,39,8,26,29,20,39,36,39,0,37,38,26,20,12,1,14,3,39,38,14,39,30,1,25,0,14,8,22,3,19,12,12,14,3,35,2,12,17,25,20,29,31,3,2,23,27,32,5,36,15,19,29,28,35,38,31,20,27,32,33,23,28,20,14,15,7,8,22,23,14,0,8,9,27,30,21,0,37,39,0,1,38,38,39,27,21,13,2,15,4,0,39,14,15,0,31,1,2,26,1,14,15,9,23,3,4,20,13,12,13,15,4,36,3,13,17,18,26,21,29,30,32,4,3,24,28,32,33,6,37,15,16,20,30,28,29,36,39,31,32,21,28,33,23,27,28,19,20,15,6,7,7,8,23,14,39,0,9,27,29,30,21,39,0,36,37,0,1,37,38,39,26,27,20,21,13,1,2,14,15,4,39,0,38,39,15,0,30,31,2,25,26,0,1,15,9,22,23,4,20,12,13,13,14,15,3,4,36,2,3,12,13,18,26,20,21,30,32,3,4,3,23,24,27,28,33,5,6,36,37,16,20,29,30,29,35,36,38,39,32,21,27,28,33,23,28,19,20,15,7,7,8,23,14,0,9,27,29,30,21,0,36,37,0,1,38,39,27,20,21,13,2,14,15,4,0,38,39,15,0,31,2,26,0,1,15,9,22,23,4,20,12,13,13,15,3,4,36,3,12,13,18,26,21,30,32,3,4,3,24,27,28,33,6,36,37,16,20,30,29,36,38,39,32,21,27,28,32,4,31,21,26,18,2,13,5,6,11,21,12,38,7,25,28,9,19,38,35,38,39,36,37,25,19,11,0,13,2,38,37,13,38,29,0,24,39,13,7,21,2,18,11,37,11,13,2,34,1,11,16,24,19,28,30,2,0,1,22,26,31,4,35,14,18,28,27,34,37,30,19,26,26,8,20,12,12,31,21,17,34,11,7,6,9,24,35,37,27,27,17,32,21,22,24,13,14,14,19,9,11,0,1,12,1,2,12,27,17,18,8,4,33,34,13,3,31,21,34,23,24,9,25,15,4,33,34,1,30,31,4,34,5,35,2,31,32,3,33,31,20,21,25,14,15,17,7,6,35,36,19,8,9,8,38,4,33,34,3,32,33,19,9,4,34,35,24,25,6,36,30,19,20,5,34,35,19,9,13,3,27,16,17,8,38,24,14,17,6,7,30,17,7,19,8,9,8,37,38,0,30,7,36,37,17,6,7,22,12,30,20,25,14,15,34,24,36,26,8,37,38,15,7,37,28,17,18,32,21,22,37,27,10,39,0,1,30,31,20,10,24,14,34,23,24,29,33,23,0,29,30,3,32,33,36,26,25,15,32,21,22,28,28,3,35,5,30,26,14,8,13,39,10,34,0,30,35,32,33,25,23,30,28,22,20,15,17,14,15,9,7,10,8,26,25,22,23,16,14,2,0,11,8,9,29,27,32,30,23,21,2,0,39,37,2,39,0,3,1,0,38,1,38,39,29,27,23,21,15,13,4,2,17,15,6,4,2,0,1,39,17,14,15,2,0,33,31,4,1,2,28,26,3,1,17,14,15,11,9,25,23,6,3,4,22,20,15,13,9,15,12,13,17,15,6,4,38,36,5,3,15,13,20,17,18,28,26,23,21,32,29,30,34,32,6,4,8,5,3,26,24,30,28,35,32,33,8,6,39,37,18,15,16,22,20,32,30,31,28,29,38,36,1,39,34,31,32,23,21,30,28,16,28,34,8,7,24,11,29,30,20,25,17,38,11,12,4,5,19,20,11,37,5,6,24,27,21,18,37,34,36,37,38,35,35,36,24,18,10,39,12,22,1,37,36,11,12,37,28,38,39,23,38,11,12,6,20,0,1,17,10,9,10,12,1,33,0,10,14,15,23,18,26,27,29,1,0,21,25,29,30,3,34,12,13,17,27,25,26,33,36,39,28,29,18,25,37,18,13,20,18,17,4,34,39,30,31,28,26,18,18,19,9,34,25,11,20,38,0,1,32,11,7,8,11,12,9,10,38,31,32,24,13,25,26,15,11,9,10,26,11,2,13,37,11,12,19,26,20,33,34,15,31,23,24,24,26,14,15,9,7,14,23,24,29,37,32,1,3,14,15,14,35,38,39,4,17,7,8,23,27,31,1,0,7,9,10,3,32,38,39,12,2,7,39,34,26,27,28,2,33,19,28,6,9,19,0,19,16,19,20,17,18,6,0,32,21,34,23,19,18,34,19,10,21,5,20,34,28,2,4,23,39,32,32,34,23,15,22,32,37,5,0,9,11,23,22,3,7,12,25,16,35,39,9,8,15,18,34,11,0,7,16,26,7,10,27,19,13,10,20,14,23,20,20,29,0,2,32,37,29,20,24,16,17,32,23,9,18,36,39,1,30,9,6,9,10,7,8,36,30,22,11,24,13,9,8,24,9,0,39,11,35,10,24,18,32,9,13,29,22,22,24,13,5,12,22,27,35,30,39,1,13,12,33,37,2,15,6,25,29,39,38,5,8,1,30,37,38,14,11,2,22,16,19,14,35,8,9,12,24,33,23,28,20,8,15,7,8,23,14,0,9,27,30,39,21,0,37,29,0,1,38,39,27,21,13,2,15,4,0,39,15,0,31,2,26,1,15,9,23,26,4,20,13,13,15,4,36,3,13,18,26,21,30,32,4,3,24,28,33,6,37,16,20,30,29,36,39,32,21,28,11,14,15,5,29,29,37,26,9,28,23,10,12,9,33,22,12,17,8,9,4,36,36,37,26,12,3,29,38,16,18,19,10,29,25,26,29,30,27,28,16,9,10,2,31,3,4,33,29,27,28,4,29,20,31,15,29,30,4,38,11,12,33,9,1,2,2,4,32,33,25,32,1,2,27,7,15,10,19,21,32,33,32,13,16,17,22,35,25,26,36,5,9,19,18,25,27,28,21,10,16,17,8,38,2,3,34,35,10,30,21,22,22,23,38,29,14,15,24,2,4,5,36,14,15,11,12,15,16,12,13,14,1,2,35,36,28,16,17,29,30,19,14,15,13,14,30,15,5,6,17,0,1,15,16,22,30,24,37,38,19,35,27,28,28,29,30,18,19,24,11,17,18,27,28,33,1,35,36,5,7,18,19,18,38,39,2,3,8,20,21,11,12,31,35,4,5,4,10,11,13,14,7,36,2,3,18,35,8,25,13,30,5,21,22,0,17,32,9,33,9,10,21,8,25,39,16,25,2,34,11,12,29,15,31,32,6,23,25,2,22,38,39,25,2,26,3,23,0,24,1,12,29,6,22,23,38,15,27,4,0,16,17,27,29,6,25,2,24,0,1,0,17,25,2,16,33,27,4,11,28,26,2,3,0,17,34,11,8,24,25,29,6,5,22,38,14,15,38,15,0,17,29,5,6,21,38,28,5,38,14,15,3,20,11,28,6,23,15,32,17,34,29,5,6,28,5,9,26,13,29,30,18,35,31,8,22,38,39,1,18,5,22,15,32,14,31,21,38,24,0,1,17,34,6,23,13,29,30,10,0,4,5,36,37,9,32,23,24,24,25,0,31,16,17,26,4,6,7,38,16,17,13,14,17,18,14,15,16,3,4,37,38,30,18,19,31,32,21,16,17,15,16,32,17,7,8,19,2,3,17,18,32,26,39,0,21,37,29,30,21,30,31,32,20,21,13,19,20,29,30,30,35,3,37,38,7,9,20,21,20,0,1,4,5,10,22,23,13,14,33,37,6,7,6,12,13,15,16,9,38,4,5,9,19,19,32,26,15,4,3,37,27,32,24,19,11,12,6,27,18,4,13,31,34,25,4,1,4,5,2,3,31,25,37,17,6,19,8,4,3,19,4,35,6,30,5,19,13,27,8,24,17,14,17,19,8,0,7,17,22,30,25,34,36,8,7,28,32,37,10,1,20,24,34,33,0,3,36,25,32,18,18,17,39,27,28,18,23,15,9,10,2,3,17,17,18,9,35,3,4,22,25,16,35,32,34,35,36,33,33,34,22,16,8,37,10,39,35,34,9,10,35,26,36,37,21,36,9,10,4,18,38,39,15,8,7,8,10,39,14,31,38,8,12,13,21,16,24,25,27,39,38,19,23,27,28,1,32,10,11,15,25,23,24,31,34,26,27,16,23,30,18,23,20,21,36,31,7,31,39,36,33,6,3,6,39,29,33,34,25,26,25,21,12,13,13,14,29,20,5,6,15,33,35,36,27,5,6,2,3,24,6,7,3,4,5,32,33,26,27,19,7,8,20,21,10,5,6,4,5,21,6,36,37,8,31,32,6,7,21,15,28,29,10,26,18,19,19,20,21,9,10,2,8,9,18,19,24,32,26,27,36,38,9,10,9,29,30,33,34,39,11,12,2,3,22,26,35,36,35,1,2,4,5,38,27,33,34,15,5,10,1,2,37,29,29,30,27,5,36,22,31,9,11,12,3,22,18,19,22,23,20,21,9,2,3,35,24,36,37,26,22,20,21,37,22,13,24,8,22,23,37,31,4,5,26,2,34,35,35,37,25,26,18,25,34,35,0,8,3,12,14,25,26,28,25,6,9,10,15,28,18,19,15,38,2,12,11,18,20,21,14,3,9,10,12,2,7,39,33,34,26,27,2,33,19,28,6,9,0,19,16,19,20,17,18,6,0,32,21,34,26,23,19,18,34,19,10,18,21,5,20,34,28,2,23,39,32,32,34,23,15,22,32,37,5,0,9,11,23,22,3,7,12,25,16,35,39,9,8,15,18,11,0,7,20,27,5};
static const short Gen_shift_values_BG1_Z_44[2109]= {29,32,5,8,29,34,5,34,4,36,21,7,4,29,37,14,30,3,22,32,0,6,23,39,33,37,16,2,22,5,29,29,38,17,0,34,25,30,32,36,24,21,4,25,21,8,8,21,36,38,36,28,0,42,38,39,30,10,34,8,33,2,6,32,11,37,32,29,30,33,6,9,29,30,35,6,34,35,5,37,21,22,8,5,30,38,15,30,31,4,23,32,33,1,7,24,40,34,38,17,3,22,23,6,30,29,30,39,18,0,1,35,26,30,31,33,37,24,25,22,5,26,22,9,8,9,22,37,38,39,37,29,1,43,39,39,40,31,11,34,35,9,34,2,3,7,33,11,12,38,33,30,33,5,6,8,9,30,34,35,5,6,35,5,36,37,22,8,4,5,30,37,38,14,15,31,4,22,23,33,0,1,6,7,24,39,40,33,34,38,16,17,2,3,23,6,29,30,30,38,39,17,18,1,35,25,26,31,33,36,37,25,21,22,4,5,26,21,22,8,9,9,22,36,37,39,37,28,29,1,42,43,38,39,40,30,31,10,11,35,9,33,34,3,6,7,32,33,12,38,32,33,30,33,6,8,9,30,35,5,6,35,5,37,22,8,4,5,30,38,14,15,31,4,23,33,1,6,7,24,40,33,34,38,17,2,3,23,6,30,30,39,17,18,1,35,25,26,31,33,36,37,25,22,4,5,26,22,8,9,9,22,37,39,37,28,29,1,43,38,39,40,31,10,11,35,9,34,3,7,32,33,12,38,32,33,41,35,4,7,24,27,42,4,9,24,41,9,23,11,40,26,23,30,4,12,33,5,22,41,7,19,25,42,14,8,12,35,21,41,24,4,4,13,36,19,9,0,5,7,11,13,43,40,23,0,40,27,27,40,11,13,11,3,30,19,17,13,14,5,29,9,27,8,21,25,7,30,12,7,37,29,28,21,10,39,17,19,40,2,14,3,32,38,38,35,10,38,13,11,29,30,14,32,33,39,35,10,40,14,15,11,29,30,30,40,15,10,29,42,16,17,27,2,13,32,10,28,29,21,35,10,43,17,18,20,38,39,36,11,9,28,28,2,3,38,13,6,24,25,12,30,31,29,4,1,19,20,39,13,14,43,18,22,40,41,8,26,27,28,3,11,30,35,9,10,35,10,0,18,19,23,41,42,6,25,40,15,31,5,6,36,11,38,13,42,16,17,3,30,5,27,1,2,10,28,29,31,6,27,1,2,14,32,33,14,33,27,2,42,16,17,0,19,42,17,34,8,9,3,6,25,4,22,23,0,18,19,1,20,36,10,11,16,34,35,40,15,14,33,39,13,14,16,8,27,12,30,31,38,12,13,17,36,43,18,38,12,13,14,23,43,28,22,3,19,22,28,42,32,26,10,4,2,15,1,2,18,5,35,22,38,25,24,15,1,2,20,7,35,22,13,20,6,7,34,21,22,9,7,37,38,37,24,34,21,15,2,23,10,0,31,16,2,3,33,20,8,39,18,4,5,30,17,36,23,9,40,25,12,19,6,23,10,2,33,32,19,8,38,39,35,22,15,2,15,1,2,24,11,3,34,30,16,17,20,7,11,42,16,2,3,18,5,22,9,23,10,40,41,7,38,34,21,11,42,7,38,38,25,38,24,25,7,38,22,9,24,10,11,22,9,14,1,42,30,17,28,15,24,11,25,11,12,16,3,40,27,20,6,7,38,25,19,6,32,18,19,36,23,18,5,41,27,28,23,10,18,5,33,34,40,9,21,43,31,22,23,26,43,2,2,22,23,28,43,27,28,42,30,14,15,1,42,30,23,31,8,23,24,41,16,25,26,38,0,17,33,27,0,31,10,40,15,16,43,23,22,23,32,11,37,38,28,19,23,24,26,30,17,18,15,42,19,15,2,1,2,15,30,31,32,30,22,38,36,32,32,33,24,4,27,28,2,27,39,40,0,26,5,4,5,31,26,21,13,12,23,21,33,11,14,31,33,34,43,11,16,30,31,39,16,30,18,3,33,29,30,11,19,39,40,12,29,4,14,26,31,32,5,21,14,15,19,42,27,28,4,31,11,11,20,42,43,14,26,16,6,7,12,14,17,18,6,3,29,30,36,7,3,33,34,34,3,18,20,18,9,10,26,24,19,20,21,12,35,36,43,16,34,15,28,32,13,14,37,19,13,14,11,14,31,34,11,16,31,13,16,30,18,3,33,30,28,11,19,40,12,29,4,14,26,32,5,21,15,19,42,28,4,31,11,11,20,43,26,16,7,23,12,14,18,6,3,30,7,3,34,34,3,18,20,18,10,26,24,20,21,12,36,16,34,15,28,32,14,22,37,19,14,21,7,26,27,13,2,21,25,4,28,42,21,14,37,27,15,18,35,38,0,15,20,35,20,34,22,7,37,34,20,15,23,0,16,33,8,18,30,36,9,25,19,23,2,32,8,35,15,22,15,24,3,30,20,11,23,16,18,22,10,7,34,11,7,38,38,7,22,24,22,14,30,28,24,25,16,40,20,38,19,32,36,18,41,23,18,29,43,37,10,20,15,24,15,24,17,5,4,39,3,6,23,26,37,3,8,23,8,22,10,39,25,22,37,3,11,32,28,4,21,40,6,18,24,41,13,7,11,34,20,40,23,3,3,12,35,18,8,43,23,4,6,10,42,39,22,43,39,26,26,39,10,12,10,2,18,16,12,13,4,28,8,26,7,20,24,6,29,11,6,14,34,22,9,16,17,5,10,2,17,3,13,0,39,34,5,8,25,27,28,5,10,24,25,8,10,24,12,41,27,23,24,5,13,33,34,6,23,42,8,20,25,26,43,15,8,9,13,36,21,22,42,25,5,5,14,36,37,20,10,0,1,6,8,11,12,0,41,23,24,1,41,27,28,15,28,41,12,14,12,3,4,20,18,13,14,15,6,29,30,22,10,28,9,22,26,7,8,31,13,7,8,22,25,41,42,0,1,38,22,26,27,41,42,27,41,28,29,14,0,40,41,22,29,30,6,7,23,40,14,15,25,36,37,42,43,16,31,32,25,26,30,8,9,38,39,15,42,21,22,22,30,31,9,10,15,37,27,17,18,23,25,28,29,17,13,14,40,41,6,18,13,14,0,1,1,14,28,29,31,29,20,21,37,34,35,30,31,32,22,23,2,3,27,1,25,26,39,42,43,24,25,4,30,24,25,0,32,3,35,20,8,23,10,11,0,32,5,37,20,7,8,12,5,37,19,7,7,39,36,24,22,10,19,6,7,0,32,8,40,29,16,17,1,33,18,6,37,25,3,35,15,3,21,8,9,38,26,10,42,4,35,36,32,8,40,31,19,17,4,5,37,25,20,8,0,32,0,32,9,41,32,19,20,15,3,5,37,40,27,28,1,33,3,35,7,38,39,39,27,36,24,19,6,7,40,28,36,24,23,10,11,23,11,36,24,7,39,9,41,7,39,43,30,31,15,3,13,1,9,40,41,10,42,1,33,25,12,13,5,37,23,11,4,36,17,5,21,9,3,34,35,26,14,8,40,3,34,35,25,28,0,1,3,4,42,25,29,30,0,1,30,0,31,32,17,3,43,0,25,32,33,9,10,26,43,17,18,28,39,40,1,2,19,34,35,28,29,33,11,12,41,42,18,1,24,25,25,33,34,12,13,40,30,20,21,26,28,31,32,0,20,16,17,43,0,21,16,17,3,4,29,4,17,31,32,34,32,23,24,40,37,38,33,34,35,25,26,5,6,30,4,28,29,42,1,2,27,28,7,33,27,28,11,39,8,12,15,11,23,9,33,36,9,12,33,38,9,11,38,8,40,25,11,8,33,41,18,34,7,26,36,4,10,33,27,43,37,41,20,6,26,9,33,33,42,21,4,38,29,34,36,40,18,28,25,8,29,25,12,12,25,40,42,40,32,4,2,42,43,34,14,38,12,37,6,10,36,15,41,36,2,14,34,11,26,27,30,3,6,26,27,32,3,10,31,32,2,34,18,19,5,2,27,35,12,27,28,1,20,29,30,42,4,21,37,31,35,14,0,19,20,3,27,26,27,36,15,41,42,32,23,27,28,30,34,21,22,19,2,15,23,19,6,5,6,19,34,35,36,34,26,42,40,36,36,37,28,8,31,32,6,31,43,0,4,30,8,9,35,30,31,19,32,25,15,43,36,7,39,16,2,34,32,24,7,3,6,22,23,25,26,23,3,7,8,22,23,8,22,9,10,39,25,21,22,3,10,11,31,32,38,4,21,39,40,6,17,18,23,24,41,12,13,6,7,11,33,34,19,20,40,23,2,3,3,11,12,34,35,18,8,42,43,4,6,9,10,42,38,39,21,22,43,38,39,25,26,26,39,9,10,12,10,1,2,18,15,16,11,12,13,3,4,27,28,8,26,6,7,20,23,24,5,6,29,11,5,6,21,24,41,43,0,21,26,40,41,33,26,40,28,13,43,39,40,21,29,5,6,22,39,14,24,36,41,42,15,31,24,25,29,8,37,38,14,41,21,21,30,8,9,36,26,16,17,22,24,27,28,16,13,39,40,17,13,43,0,0,13,28,30,28,19,20,2,36,34,29,30,31,22,1,2,8,26,0,25,38,42,23,24,3,29,23,24,37,40,13,16,34,37,42,13,42,12,0,29,15,12,37,1,22,38,11,30,40,8,14,31,3,41,23,1,24,10,30,13,37,28,37,2,25,8,42,33,38,40,0,32,29,12,33,29,16,16,29,0,2,0,36,8,6,2,3,38,18,42,16,41,10,14,40,19,1,40,37,22,14};
static const short Gen_shift_values_BG1_Z_48[2109]= {18,27,12,35,18,9,38,1,27,39,32,24,47,47,43,34,36,47,15,23,16,6,42,26,8,42,15,7,28,33,14,47,32,35,12,6,16,16,5,38,20,7,4,24,39,19,22,2,4,9,17,15,17,34,11,1,47,30,35,42,12,41,12,38,9,15,20,18,19,28,13,36,18,19,10,39,1,2,28,40,32,33,25,0,0,44,35,36,37,0,16,23,24,17,7,43,27,9,43,16,8,28,29,34,15,47,0,33,36,12,13,7,17,16,17,6,39,20,21,8,5,25,40,20,22,23,3,5,9,10,18,16,18,35,12,1,2,0,31,35,36,43,13,41,42,13,39,9,10,16,21,19,28,12,13,35,36,19,9,10,38,39,2,28,39,40,33,25,47,0,0,43,44,34,35,37,0,15,16,24,16,17,6,7,43,26,27,8,9,43,15,16,7,8,29,34,14,15,0,32,33,35,36,13,7,16,17,17,6,38,39,21,7,8,4,5,25,39,40,19,20,23,3,4,5,10,18,15,16,18,34,35,11,12,2,47,0,30,31,36,43,12,13,42,12,13,38,39,10,16,20,21,19,28,13,35,36,19,10,38,39,2,28,40,33,25,47,0,0,44,34,35,37,0,16,24,17,6,7,43,27,8,9,43,16,7,8,29,34,15,0,33,35,36,13,7,16,17,17,6,38,39,21,8,4,5,25,40,19,20,23,3,5,10,18,15,16,18,35,11,12,2,0,30,31,36,43,13,42,13,38,39,10,16,20,21,43,36,31,40,25,0,2,31,22,3,13,14,40,4,45,37,12,18,12,8,47,1,12,28,36,29,19,7,39,21,7,28,20,41,46,27,12,45,0,25,19,29,29,18,3,21,33,20,17,37,4,32,35,15,17,22,30,28,0,30,47,24,14,12,43,0,7,25,6,25,3,22,28,33,2,37,16,0,14,43,12,17,32,8,13,27,44,1,17,37,45,46,6,31,38,39,6,13,14,18,37,45,28,35,36,9,16,17,34,20,28,46,6,10,17,18,3,11,43,3,18,25,26,20,18,26,14,21,22,5,12,13,7,15,18,26,34,41,42,42,2,35,42,43,25,32,33,13,21,45,4,5,27,34,35,13,21,34,41,42,26,33,34,47,7,4,12,33,40,41,18,26,3,10,11,6,13,14,31,39,25,33,35,42,43,35,43,24,32,9,16,17,17,39,47,26,33,34,23,30,31,43,3,10,17,18,38,45,46,41,1,21,29,23,30,31,28,36,36,44,34,41,42,38,36,44,5,12,13,30,37,38,20,28,18,25,26,1,8,9,6,14,13,21,31,38,39,31,12,20,31,38,39,9,16,17,28,36,34,42,39,46,47,31,29,39,32,36,8,14,14,33,4,2,33,14,46,17,16,37,38,25,47,10,32,33,7,47,16,37,38,7,29,36,10,5,47,20,21,25,47,37,11,30,3,4,22,44,45,19,45,19,41,15,32,6,34,7,8,45,19,13,35,21,42,43,14,36,4,26,40,14,24,46,6,28,40,14,13,35,5,27,26,47,0,31,5,12,34,45,18,19,30,4,33,7,10,31,32,4,26,14,36,14,35,36,3,25,36,10,7,18,39,40,5,27,2,24,22,44,37,11,17,39,20,41,42,0,22,2,24,7,28,29,15,37,13,35,46,15,37,32,6,9,31,47,20,21,45,19,28,2,33,6,7,40,14,10,32,39,12,13,10,32,36,10,7,28,29,13,35,18,40,43,28,41,29,39,1,25,4,5,14,47,22,24,4,5,44,25,35,36,14,26,18,19,11,34,32,34,30,21,22,23,34,2,9,10,3,41,29,13,43,25,29,2,42,14,15,20,1,33,34,19,22,46,47,41,3,2,3,40,25,6,7,42,39,11,26,6,8,9,37,39,43,44,4,2,4,21,46,35,36,34,17,21,22,29,47,27,28,47,25,18,43,44,2,7,45,7,40,40,10,11,0,9,42,16,17,0,0,39,19,20,1,31,9,21,14,6,28,29,29,25,15,16,18,29,45,5,46,35,36,24,8,37,38,24,45,36,37,10,15,44,29,14,16,17,17,42,36,45,46,46,35,19,20,2,37,33,34,29,6,21,0,1,4,32,34,39,47,44,45,47,16,40,41,31,29,11,12,6,17,24,42,23,42,19,20,39,45,1,2,27,36,21,44,27,18,47,12,10,36,0,41,33,8,1,8,4,43,45,8,24,32,25,15,3,35,17,3,24,16,37,42,23,8,41,44,21,15,25,8,25,14,47,29,16,13,33,0,28,31,11,13,18,26,24,26,43,20,10,8,39,44,3,21,2,21,47,0,18,24,29,19,14,32,21,38,33,18,39,35,3,0,20,7,1,4,29,38,23,46,42,29,20,1,12,38,2,43,35,10,13,10,6,45,47,10,26,34,27,17,5,37,19,5,26,18,39,44,25,23,10,43,46,23,17,27,4,27,16,1,31,18,15,35,2,30,33,13,15,20,28,26,28,45,22,12,10,41,46,5,23,4,23,1,20,26,31,12,5,39,20,0,29,10,40,21,23,40,12,26,12,21,6,29,9,12,3,32,43,21,33,26,18,41,13,41,37,28,42,30,41,9,17,10,0,36,20,2,36,9,1,22,27,8,41,26,29,6,0,10,2,10,47,32,14,1,46,18,33,13,16,44,46,3,11,9,11,28,5,43,41,24,29,36,6,35,6,32,3,9,14,23,16,46,23,22,32,27,39,1,1,4,29,18,3,33,1,10,43,17,18,1,40,20,21,11,32,10,22,15,7,29,30,30,26,16,17,19,30,46,6,47,36,37,25,9,38,39,25,46,37,38,11,16,45,30,15,17,18,43,37,46,47,47,36,20,21,3,38,34,35,7,22,1,2,4,5,33,35,40,0,45,46,0,17,41,42,32,30,12,13,2,18,25,43,24,43,20,21,40,46,2,3,13,22,6,7,29,30,14,13,3,4,32,33,44,22,33,34,27,19,41,42,42,37,38,28,29,31,42,9,10,18,10,11,0,1,37,20,21,2,3,37,9,10,1,2,23,28,8,9,42,26,27,29,30,36,7,1,10,11,11,0,32,33,15,1,2,46,47,19,19,33,34,13,14,17,45,46,47,4,12,9,10,12,28,29,5,6,44,41,42,24,25,30,37,6,7,36,6,7,32,33,4,10,14,15,36,35,45,44,30,29,5,3,4,36,35,27,26,8,6,7,3,19,18,45,44,9,8,2,1,42,41,17,15,16,17,16,13,12,4,2,3,6,5,17,16,33,32,41,40,34,33,24,22,23,12,11,44,43,26,24,25,22,12,11,33,32,25,23,24,46,45,3,2,32,31,17,16,2,1,5,3,4,30,29,24,23,34,32,33,34,33,23,22,8,6,7,38,37,25,24,22,20,21,42,41,9,8,37,35,36,40,39,20,19,22,21,27,26,35,34,33,31,32,35,34,4,3,29,27,28,19,18,17,16,0,46,47,5,4,12,11,30,29,11,10,30,29,8,6,7,27,26,33,32,38,36,37,18,27,11,12,34,35,5,18,8,9,37,38,1,27,38,39,32,24,46,47,47,42,43,33,34,36,47,14,15,23,15,16,5,6,42,25,26,7,8,42,14,15,6,7,28,33,13,14,47,31,32,34,35,12,6,15,16,16,5,37,38,8,20,6,7,3,4,24,38,39,18,19,30,22,2,3,4,9,17,14,15,17,33,34,10,11,1,46,47,29,30,35,42,11,12,41,11,12,37,38,9,15,19,20,34,7,24,8,37,3,9,23,44,5,38,13,44,35,16,31,27,5,17,10,2,25,25,21,12,14,25,41,1,42,32,46,20,4,34,20,41,33,6,11,40,25,10,13,38,32,42,42,31,16,1,46,33,30,2,17,45,0,28,30,35,43,41,43,12,37,27,25,8,13,20,38,19,38,16,35,41,46,17,24,8,20,37,38,47,32,7,37,38,29,10,28,20,21,47,11,3,4,44,19,19,15,6,7,8,19,35,42,43,36,26,14,46,28,14,35,27,47,0,5,34,18,19,4,7,31,32,26,36,35,36,25,10,39,40,27,24,33,44,11,39,41,42,22,24,28,29,37,35,37,6,31,20,21,19,2,6,7,14,32,12,13,32,10,28,29,35,40,40,32,0,21,17,44,9,8,30,36,23,3,25,42,47,45,6,38,39,13,14,16,45,35,36,16,17,28,6,17,18,11,3,25,26,26,21,22,12,13,13,15,26,41,42,2,42,43,32,33,21,4,5,34,35,21,41,42,33,34,7,12,40,41,26,10,11,13,14,39,33,42,43,43,32,16,17,47,33,34,30,31,3,17,18,45,46,1,29,30,31,36,44,41,42,44,12,13,37,38,28,25,26,8,9,14,21,38,39,20,38,39,16,17,36,42,46,47,43,4,37,11,12,43,34,14,15,16,26,4,16,9,1,23,24,24,20,10,11,13,24,40,0,41,30,31,19,3,32,33,19,40,31,32,5,10,39,24,9,11,12,37,31,40,41,41,30,14,15,45,32,28,29,1,16,43,44,47,27,29,34,42,39,40,35,42,11,35,36,26,24,6,7,17,12,19,37,18,37,14,15,34,40,44,45,4,13,46,21,31,4,43,24,35,13,25,18,10,33,33,29,20,22,33,1,9,2,40,28,12,42,29,28,1,41,14,19,0,18,33,18,21,46,40,2,2,39,24,6,41,38,10,25,5,8,36,38,43,3,1,3,20,45,35,33,16,21,28,46,27,46,24,43,1,6,38,4,14};
static const short Gen_shift_values_BG1_Z_52[2109]= {50,20,26,2,50,35,4,50,9,19,50,18,31,50,22,7,50,8,2,50,43,47,50,46,19,50,36,4,50,0,16,50,37,45,50,14,29,50,6,48,50,49,33,50,26,3,50,4,31,50,28,38,50,45,15,50,21,14,50,10,40,50,12,0,50,29,36,51,50,20,26,2,51,50,35,4,51,50,9,19,51,50,18,31,50,22,7,51,50,8,2,51,50,43,47,50,46,19,50,36,4,51,50,0,16,51,50,37,45,51,50,14,29,51,50,6,48,51,50,49,33,50,26,3,51,50,4,31,51,50,28,38,50,45,15,51,50,21,14,51,50,10,40,51,50,12,0,51,50,29,36,50,20,27,26,3,2,50,36,35,5,4,50,9,20,19,50,18,32,31,50,23,22,8,7,50,8,3,2,50,44,43,48,47,50,47,46,20,19,50,37,36,5,4,50,0,17,16,50,38,37,46,45,50,14,30,29,50,6,49,48,50,50,49,34,33,50,27,26,4,3,50,4,32,31,50,28,39,38,50,46,45,16,15,50,22,21,15,14,50,10,41,40,50,13,12,1,0,50,29,37,36,50,20,26,3,2,50,35,5,4,50,9,19,50,18,32,31,50,22,8,7,50,8,2,50,43,48,47,50,46,20,19,50,36,5,4,50,0,16,50,37,46,45,50,14,30,29,50,6,49,48,50,49,34,33,50,26,4,3,50,4,31,50,28,39,38,50,45,16,15,50,21,15,14,50,10,40,50,12,1,0,50,29,37,36,23,47,18,40,46,22,28,18,3,24,47,18,29,39,18,38,51,23,18,42,27,18,28,22,18,11,15,18,14,39,18,4,24,18,20,36,18,5,13,18,34,49,18,26,16,12,18,17,1,18,46,23,18,24,51,18,48,6,50,18,13,35,18,41,34,18,30,8,18,32,20,18,49,4,4,5,26,6,49,47,23,37,38,40,35,7,48,2,23,33,10,3,32,9,39,38,37,15,14,15,33,10,18,48,47,39,17,16,1,33,10,44,21,2,32,31,33,10,1,30,14,44,43,26,33,10,5,35,34,42,20,19,33,10,43,20,37,15,14,33,10,26,4,3,30,8,7,33,10,29,7,6,2,32,31,33,10,19,49,48,39,17,16,33,10,35,12,51,29,28,33,10,20,50,49,28,6,5,33,10,49,26,12,42,41,33,10,41,18,31,9,8,36,33,10,32,10,9,16,46,45,33,10,9,39,38,38,16,15,33,10,39,16,14,44,43,33,10,11,40,21,51,50,43,33,10,28,6,5,50,28,27,33,10,4,34,33,49,27,26,33,10,45,22,23,1,0,46,33,10,47,25,24,35,13,12,33,10,12,41,19,49,48,48,5,9,40,0,44,3,7,16,21,24,51,15,11,17,3,19,18,25,40,31,46,7,22,27,3,19,18,40,3,9,24,37,3,19,18,14,29,24,39,3,19,18,23,38,36,51,3,18,27,42,12,27,3,19,18,13,28,7,22,3,19,18,48,11,0,15,3,18,51,14,24,39,3,18,41,4,9,24,3,19,18,5,20,21,36,3,19,18,42,5,50,13,3,19,18,19,34,34,49,3,19,18,11,26,1,16,18,3,19,18,2,17,38,1,3,18,31,46,8,23,3,19,18,9,24,36,51,3,19,18,33,48,43,6,15,3,18,50,13,20,35,3,19,18,26,41,19,34,3,19,18,15,30,45,8,3,19,18,17,32,5,20,3,19,18,34,49,41,4,51,5,19,46,48,51,50,45,44,14,20,48,51,45,44,29,50,45,44,3,13,45,44,12,25,42,44,16,1,45,44,2,48,45,44,37,41,44,40,13,0,44,30,50,45,44,46,10,45,44,31,39,45,44,8,23,45,44,0,42,45,44,43,27,44,20,49,45,44,50,25,45,44,22,32,44,39,9,45,44,15,8,45,44,4,34,45,44,6,46,15,45,44,23,30,0,45,13,25,0,1,44,14,20,49,48,16,44,29,51,50,5,44,3,13,44,12,26,25,44,16,2,1,44,2,48,44,37,42,41,44,40,14,13,44,30,51,50,44,46,10,44,31,40,39,28,44,8,24,23,44,0,43,42,44,43,28,27,25,44,20,50,49,44,50,25,44,22,33,32,44,39,10,9,44,15,9,8,0,44,4,34,44,6,47,46,44,23,31,30,24,46,0,28,24,9,30,35,24,35,45,24,44,5,41,24,48,33,24,34,28,24,17,21,24,20,45,24,10,30,24,26,42,24,11,19,24,40,3,3,24,32,22,24,23,7,24,0,29,24,30,5,24,2,12,24,19,41,24,47,40,24,36,14,24,38,26,17,24,3,10,38,27,29,2,50,0,40,10,15,43,11,5,9,27,34,28,50,4,32,5,28,13,34,28,39,49,28,48,9,11,28,0,37,28,38,32,28,21,25,28,24,49,28,14,34,28,30,46,14,28,15,23,28,44,7,4,28,36,26,28,27,11,28,4,33,28,34,9,28,6,16,28,23,45,28,51,44,28,40,18,28,42,30,28,7,14,5,33,43,41,42,43,5,25,26,44,17,27,47,4,26,32,8,8,4,41,10,4,15,25,4,24,37,20,4,28,13,34,4,14,8,4,49,1,4,0,25,4,42,10,4,6,22,4,43,51,4,20,35,27,4,12,2,4,3,39,4,32,9,4,10,37,4,34,44,4,51,21,4,27,20,4,16,46,4,18,6,4,35,42,3,21,15,27,20,37,35,40,45,35,21,3,0,39,40,4,26,32,9,8,4,41,11,10,39,4,15,25,4,24,38,37,4,28,14,13,4,14,8,4,49,2,1,4,0,26,25,4,42,11,10,4,6,22,4,43,0,51,4,20,36,35,4,12,3,2,4,3,40,39,4,32,10,9,31,4,10,37,4,34,45,44,4,51,22,21,4,27,21,20,1,4,16,46,4,18,7,6,4,35,43,42,18,40,47,46,23,22,1,18,4,3,25,24,18,29,40,39,18,38,0,51,18,43,42,28,27,18,28,23,22,18,12,11,16,15,18,15,14,40,39,18,5,4,25,24,18,20,37,36,18,6,5,14,13,35,18,34,50,49,18,26,17,16,18,18,17,2,1,7,18,47,46,24,23,18,24,0,51,18,48,7,6,18,14,13,36,35,18,42,41,35,34,18,30,9,8,18,33,32,21,20,18,49,5,4,19,36,41,6,47,12,23,41,40,19,36,4,21,25,43,42,3,19,36,30,47,40,5,19,36,39,4,0,18,17,19,36,43,8,28,46,45,19,36,29,46,23,40,19,36,12,29,16,34,33,19,36,15,32,40,6,5,48,19,36,5,22,25,43,42,19,36,21,38,37,2,19,36,6,23,14,32,31,19,36,35,0,50,16,15,19,36,27,44,17,35,34,19,36,18,35,2,20,19,19,36,47,12,24,42,41,19,36,25,42,0,17,19,36,49,14,7,25,24,19,36,14,31,36,2,1,19,36,42,7,35,1,0,19,36,31,48,9,26,19,36,33,50,21,39,38,19,36,50,15,5,23,22,18,40,47,46,23,22,5,18,4,3,25,24,18,29,40,39,18,38,0,51,18,43,42,28,27,18,28,23,22,18,12,11,16,15,18,15,14,40,39,18,5,4,25,24,18,20,37,36,18,6,5,14,13,18,34,50,49,18,26,17,16,21,18,18,17,2,1,18,47,46,24,23,10,18,24,0,51,18,48,7,6,18,14,13,36,35,18,42,41,35,34,18,30,9,8,18,33,32,21,20,18,49,5,4,9,29,5,39,3,48,40,50,27,49,3,31,27,12,33,3,27,38,48,27,47,8,27,51,36,27,37,31,27,20,24,44,27,23,48,27,13,33,27,29,45,27,14,22,27,43,6,27,35,25,11,27,26,10,27,3,32,27,33,8,27,5,15,27,22,44,27,50,43,27,39,17,27,41,29,27,6,13,5,43,20,42,30,29,51,5,33,30,29,14,35,29,30,29,40,50,30,29,49,10,29,1,38,30,29,39,33,30,29,22,26,29,25,50,29,15,35,30,29,31,47,30,29,16,24,30,29,45,8,30,29,37,27,30,29,28,12,1,29,5,34,30,29,35,10,30,29,7,17,29,24,46,30,29,0,45,30,29,41,19,30,29,43,31,30,29,8,15,38,11,41,47,3,27,4,31,9,31,11,1,22,37,23,4,26,33,32,9,8,6,4,42,41,11,10,4,15,26,25,4,24,38,37,4,29,28,14,13,9,4,14,9,8,4,50,49,2,1,4,1,0,26,25,4,43,42,11,10,4,6,23,22,4,44,43,0,51,4,20,36,35,4,12,3,2,4,4,3,40,39,4,33,32,10,9,4,10,38,37,4,34,45,44,4,0,51,22,21,4,28,27,21,20,4,16,47,46,4,19,18,7,6,4,35,43,42,44,14,20,49,48,44,29,51,50,0,44,3,13,44,12,26,25,44,16,2,1,44,2,48,44,37,42,41,44,40,14,13,44,30,51,50,44,46,10,44,31,40,39,44,8,24,23,44,0,43,42,44,43,28,27,44,20,50,49,44,50,25,44,22,33,32,6,44,39,10,9,44,15,9,8,46,44,4,34,44,6,47,46,44,23,31,30,1,23,29,5,3,1,38,7,1,12,22,1,21,34,1,25,10,1,11,5,1,46,50,1,49,22,5,1,39,7,1,3,19,37,1,40,48,1,17,32,1,9,51,1,0,36,1,29,6,1,7,34,1,31,41,1,48,18,1,24,17,1,13,43,1,15,3,1,32,39,24,44,48};
static const short Gen_shift_values_BG1_Z_56[2109]= {54,28,38,32,15,34,17,37,44,30,34,38,52,45,7,4,17,6,11,9,17,44,44,38,29,20,40,15,55,30,8,36,13,33,47,37,42,20,36,44,46,20,34,22,45,12,13,8,20,13,5,39,25,29,17,28,4,42,29,30,54,47,33,29,24,18,45,54,55,29,39,33,15,16,35,18,37,38,45,31,34,35,39,53,46,8,5,17,18,7,12,9,10,18,45,45,39,30,21,41,16,55,0,31,9,36,37,14,34,47,48,38,43,20,21,37,45,46,47,21,35,23,46,13,13,14,9,21,13,14,6,40,26,30,18,28,29,5,43,29,30,31,55,47,48,34,30,24,25,19,46,55,29,38,39,32,33,16,34,35,17,18,38,45,30,31,35,39,52,53,46,7,8,4,5,18,7,11,12,10,17,18,44,45,45,38,39,29,30,21,40,41,15,16,0,31,8,9,37,13,14,33,34,48,38,42,43,21,37,44,45,47,20,21,34,35,23,45,46,12,13,14,9,20,21,14,6,39,40,26,29,30,17,18,29,4,5,42,43,30,31,54,55,48,33,34,29,30,25,19,45,46,55,29,39,32,33,16,35,17,18,38,45,31,35,39,52,53,46,8,4,5,18,7,12,10,18,44,45,45,39,29,30,21,41,15,16,0,31,9,37,14,33,34,48,38,42,43,21,37,44,45,47,21,34,35,23,46,12,13,14,9,21,14,6,39,40,26,30,17,18,29,5,42,43,30,31,55,48,34,29,30,25,19,45,46,1,9,39,13,23,17,51,0,19,2,2,22,29,15,19,23,37,29,30,48,45,2,47,52,50,2,29,29,23,14,5,25,0,40,15,49,21,54,18,32,22,27,5,21,29,23,31,5,19,7,30,53,54,49,5,54,46,24,13,10,14,2,13,45,27,14,15,39,32,18,14,9,3,30,17,45,6,0,20,6,50,23,3,16,19,47,43,37,45,42,32,16,6,26,15,16,20,9,10,32,3,49,22,11,12,5,50,51,38,25,15,32,22,18,7,8,22,12,26,16,40,29,30,3,33,23,51,40,41,48,37,38,5,51,50,40,55,44,45,53,43,5,50,51,32,21,22,32,22,26,15,16,17,6,7,8,54,28,17,18,3,48,49,43,33,18,8,52,41,42,24,14,1,46,47,21,10,11,35,25,25,15,30,19,20,8,54,24,14,32,21,22,48,34,24,8,53,54,22,11,12,10,0,33,22,23,0,45,46,1,47,52,42,8,53,54,1,47,49,39,27,16,17,35,13,3,17,6,7,5,50,51,16,6,48,37,38,30,19,20,17,7,18,8,42,31,32,38,35,25,21,10,11,17,6,7,12,2,6,52,33,22,23,1,8,36,44,48,32,16,52,49,25,52,5,18,25,46,26,31,32,0,6,10,16,4,10,51,43,48,49,6,12,45,51,10,9,14,15,16,22,2,8,6,11,12,10,16,24,30,17,23,35,41,32,38,45,50,51,34,40,39,45,37,42,43,45,51,16,22,16,22,10,16,1,7,48,54,12,18,43,49,27,32,33,2,8,36,42,8,13,14,41,47,5,11,19,24,25,9,15,14,20,48,53,54,8,14,16,22,1,18,23,24,48,54,6,12,50,0,17,23,40,46,41,46,47,36,42,48,54,41,46,47,33,39,11,17,34,53,3,1,7,45,51,0,5,6,32,38,14,20,1,6,7,2,8,26,32,19,24,25,5,11,1,7,52,1,2,46,52,17,23,31,29,6,23,2,27,13,20,21,51,5,55,24,37,38,1,40,3,4,11,53,0,1,5,19,55,12,30,27,39,40,29,34,31,32,40,11,11,5,52,15,43,7,38,21,22,53,31,2,3,36,0,13,14,4,9,42,43,3,11,12,13,43,1,45,12,35,35,36,31,43,35,36,28,6,48,52,40,50,51,27,9,51,52,53,21,13,14,0,52,48,46,47,41,12,13,6,42,22,50,42,24,54,8,1,2,33,41,4,42,43,7,7,14,0,4,8,21,22,15,33,29,30,43,32,37,35,43,13,14,14,8,54,55,46,10,40,41,25,0,34,6,39,2,3,18,17,7,11,12,46,6,13,14,16,46,3,4,40,48,15,37,38,39,34,46,39,31,8,9,51,55,42,43,54,30,11,12,40,55,0,24,17,3,54,55,50,44,14,15,43,17,27,21,4,23,6,41,26,33,19,23,27,41,51,34,52,49,6,51,0,54,6,33,33,27,18,9,29,4,44,19,53,25,2,22,36,26,31,42,9,25,33,35,9,23,11,34,1,2,53,9,2,50,28,14,18,6,17,49,31,18,19,43,36,22,18,20,13,7,34,55,53,31,6,3,30,53,31,30,17,7,5,46,29,7,13,43,53,47,48,30,49,32,52,3,45,49,53,11,41,4,22,19,32,21,26,24,32,3,3,53,44,35,55,30,14,45,23,8,51,28,48,6,52,1,45,35,51,3,5,35,49,37,4,27,28,23,35,28,20,54,40,44,32,43,19,1,44,45,13,6,48,44,39,33,4,23,18,51,49,49,52,55,2,35,31,34,55,9,10,40,50,44,48,27,46,29,49,0,42,46,50,8,44,1,19,16,7,29,18,23,21,29,0,0,50,41,32,52,27,11,42,20,48,25,45,3,49,54,24,32,48,0,2,32,46,34,1,24,25,20,32,25,17,51,37,41,29,40,16,54,41,42,10,3,45,41,36,30,1,0,53,8,24,50,7,43,14,39,28,5,33,40,48,1,11,41,51,44,45,28,47,29,30,37,50,1,43,47,51,8,9,2,20,16,17,30,19,24,22,30,0,1,1,51,41,42,33,53,27,28,12,43,21,49,26,45,46,4,50,54,55,33,49,0,1,3,33,46,47,35,2,24,25,10,26,21,33,26,18,51,52,38,42,29,30,41,17,54,55,52,42,43,11,4,46,41,42,37,31,1,2,10,40,49,50,43,44,33,27,45,46,28,29,49,0,41,42,46,50,7,8,1,18,19,15,16,29,18,22,23,21,28,29,55,0,0,49,50,40,41,32,51,52,26,27,11,42,19,20,48,24,25,44,45,17,3,49,53,54,32,48,55,0,2,31,32,45,46,41,34,0,1,23,24,25,20,31,32,25,17,50,51,37,40,41,28,29,40,15,16,53,54,41,42,9,10,3,44,45,40,41,36,30,0,1,7,15,37,45,47,55,41,48,49,24,32,43,51,26,33,34,6,46,54,53,5,39,47,43,51,47,55,5,12,13,54,6,16,24,13,20,21,26,34,15,23,20,28,18,26,26,34,53,4,5,53,5,47,55,38,45,46,48,29,37,49,1,24,31,32,8,16,39,47,17,25,45,53,22,30,42,49,50,0,8,46,54,51,2,3,29,37,45,53,53,4,5,55,7,29,37,43,50,51,31,39,54,6,21,28,29,22,30,17,25,29,37,22,30,14,22,48,55,0,34,42,38,46,26,33,34,37,45,13,21,51,2,3,38,46,39,47,7,15,0,8,42,50,38,45,46,33,41,27,35,54,5,6,29,3,12,13,6,7,23,46,8,9,47,48,12,19,4,5,9,13,26,27,20,37,38,34,35,48,37,41,42,40,47,48,18,19,19,12,13,3,4,51,14,15,45,46,30,5,38,39,11,43,44,7,8,22,12,16,17,51,11,18,19,40,21,50,51,8,9,53,19,20,42,43,1,44,39,50,51,44,36,13,14,0,3,4,47,48,3,34,35,16,17,4,5,28,29,22,7,8,3,4,55,49,19,20,1,48,48,24,25,17,11,37,17,47,1,51,34,53,36,23,0,7,49,53,1,15,8,26,23,36,25,30,28,36,7,4,7,1,48,39,3,34,18,49,27,55,32,52,10,0,5,39,55,7,25,9,39,53,41,8,31,32,27,39,32,24,2,44,48,36,47,23,5,48,49,17,10,52,48,43,37,8,53,44,55,5,24,25,55,9,3,41,42,5,44,24,7,8,15,1,4,5,9,23,16,34,31,43,44,33,38,35,36,44,15,15,9,0,47,11,42,25,26,1,35,6,7,40,4,17,18,8,13,46,47,7,15,16,17,47,5,26,49,16,39,39,40,35,47,39,40,32,10,52,0,44,54,55,31,13,55,0,1,25,17,18,4,0,50,51,45,16,10,33,16,9,11,20,48,1,10,44,39,22,46,3,54,21,51,4,5,54,55,1,38,0,1,39,40,4,11,52,53,1,5,18,19,12,29,30,26,27,34,40,29,33,34,32,39,40,10,11,11,4,5,51,52,43,6,7,37,38,22,53,30,31,3,35,36,55,0,14,4,8,9,43,3,10,11,13,42,43,0,1,45,11,12,34,35,36,31,42,43,36,28,5,6,48,51,52,39,40,51,26,27,8,9,52,53,20,21,14,55,0,51,52,47,41,11,12,48,22,32,25,26,9,28,10,11,37,31,38,24,28,32,45,46,39,1,53,54,11,0,5,3,11,37,38,38,32,22,23,14,34,8,9,49,24,2,30,7,26,27,41,31,35,36,14,30,37,38,40,14,27,28,16,39,5,6,7,2,14,7,55,32,33,21,19,23,10,11,22,54,35,36,21,23,24,48,41,27,22,23,18,12,38,39,10,40,50,44,27,27,46,29,49,0,42,46,50,8,1,19,16,29,18,23,21,29,0,0,50,41,3,32,52,27,11,42,20,8,48,25,45,3,49,54,32,48,0,2,32,46,34,1,24,25,20,32,25,17,51,37,41,29,40,16,54,41,42,10,3,45,41,36,30,1,15,8,28};
static const short Gen_shift_values_BG1_Z_60[2109]= {14,35,8,7,46,3,22,5,55,44,13,15,41,40,30,39,23,7,55,22,56,42,31,58,5,51,31,35,52,55,23,44,7,0,24,10,35,7,8,21,14,5,23,34,40,46,14,24,32,36,32,19,26,35,31,39,4,54,29,42,6,44,49,51,16,35,38,14,15,36,9,8,46,47,4,23,5,6,56,45,13,14,16,42,41,31,40,23,24,8,56,22,23,57,43,32,59,6,52,32,36,52,53,56,24,44,45,8,1,24,25,11,36,7,8,9,22,14,15,6,24,35,41,47,14,15,25,33,36,37,33,20,27,36,32,39,40,5,55,29,30,43,7,44,45,50,52,16,17,36,39,15,36,8,9,7,8,47,3,4,22,23,6,56,44,45,14,16,41,42,41,30,31,39,40,24,8,55,56,23,56,57,42,43,32,58,59,5,6,52,31,32,35,36,53,56,23,24,45,7,8,0,1,25,11,35,36,8,9,21,22,15,5,6,23,24,35,40,41,46,47,15,25,32,33,37,33,19,20,27,35,36,31,32,40,4,5,54,55,30,43,6,7,45,49,50,51,52,17,36,38,39,15,36,9,7,8,47,4,22,23,6,56,45,14,16,41,42,41,31,39,40,24,8,56,23,57,42,43,32,59,5,6,52,32,35,36,53,56,24,45,8,0,1,25,11,35,36,8,9,21,22,15,6,23,24,35,41,46,47,15,25,33,37,33,19,20,27,36,31,32,40,5,54,55,30,43,7,45,50,51,52,17,36,38,39,3,30,14,35,8,7,1,46,3,22,50,5,55,44,13,15,41,46,40,30,39,23,7,55,22,56,42,31,58,5,51,31,35,52,55,23,44,7,0,24,10,35,7,8,21,22,14,5,23,34,40,46,14,24,32,36,32,19,29,26,35,31,39,4,54,29,42,6,44,49,51,16,35,38,59,18,21,22,39,31,26,51,12,16,25,28,31,45,17,47,53,8,14,41,46,47,40,45,46,0,19,25,36,41,42,55,0,1,44,38,44,28,34,17,22,23,46,52,48,54,14,19,20,20,13,19,3,8,9,12,17,18,56,2,40,46,28,33,34,55,1,29,34,35,15,20,21,4,10,31,36,37,38,43,44,24,30,4,9,10,8,13,14,25,31,28,34,56,1,2,17,23,40,45,46,33,38,39,57,3,43,49,8,13,14,40,46,41,47,54,59,0,42,47,53,38,43,44,56,1,2,7,13,13,18,19,19,24,25,47,53,57,3,5,10,11,9,15,5,11,52,57,58,56,59,5,8,13,14,4,9,10,12,18,37,42,43,27,32,33,2,8,15,21,39,44,45,24,17,23,22,27,28,24,29,30,49,55,8,14,11,16,17,18,48,11,25,40,16,31,31,24,55,30,9,49,54,23,59,1,2,20,23,53,56,52,55,44,31,33,34,48,51,7,10,54,50,52,53,40,43,29,32,58,0,1,0,3,26,29,25,28,15,18,24,27,8,10,11,52,55,40,43,7,9,10,41,44,27,30,16,19,43,46,50,53,36,39,16,19,20,23,37,39,40,40,43,8,11,29,31,32,52,55,45,48,9,11,12,55,58,20,23,52,54,55,53,56,6,9,13,59,1,2,50,53,8,11,19,22,25,28,31,34,59,1,2,9,12,17,20,21,23,24,17,20,4,7,0,11,14,20,23,16,19,24,26,27,49,52,39,42,14,16,17,27,30,51,54,29,31,32,34,37,36,39,1,3,4,20,23,23,26,31,5,34,3,59,37,19,44,45,6,39,38,39,16,17,34,53,35,36,26,15,43,44,46,12,4,11,1,10,53,54,38,26,52,53,27,13,2,29,36,33,22,2,6,22,23,26,54,14,15,38,31,54,55,41,6,37,38,39,52,44,45,36,54,5,11,17,44,45,55,3,6,7,3,50,57,6,2,9,10,35,25,59,0,13,37,14,15,20,22,57,46,47,6,9,3,23,1,34,11,15,4,25,58,56,57,38,36,53,11,12,17,55,45,34,3,5,30,31,30,20,28,29,13,57,45,12,46,31,32,21,48,54,55,41,21,24,25,42,45,13,34,57,49,50,39,14,0,24,25,57,58,10,11,4,55,12,13,52,24,30,35,36,4,14,22,26,22,8,9,16,25,20,21,29,54,43,44,21,19,32,56,34,39,40,41,6,25,27,28,39,0,33,32,11,28,47,17,30,20,9,38,40,6,31,5,55,4,48,32,20,47,21,7,56,23,30,16,56,0,17,20,48,9,32,25,49,35,0,23,32,33,46,39,30,48,59,5,11,39,49,57,1,57,44,51,0,56,4,29,19,54,7,31,9,14,16,4,41,0,3,2,51,45,38,8,2,34,59,22,13,58,47,38,17,15,24,45,18,17,16,56,13,32,15,5,54,23,25,51,6,50,40,49,33,17,5,32,6,52,41,8,15,1,41,45,2,5,33,22,54,17,10,34,20,45,46,17,18,31,24,15,33,44,50,56,24,34,42,46,42,29,36,45,41,49,14,4,39,52,16,54,59,1,26,45,48,16,1,34,4,35,24,46,5,57,4,6,56,18,12,33,6,5,31,44,1,20,3,53,42,11,13,39,57,38,28,37,1,21,5,53,20,54,40,29,56,3,49,29,33,50,53,21,42,5,58,22,8,33,35,5,6,19,12,3,21,32,38,44,12,22,30,34,30,17,24,33,29,37,2,52,27,40,4,42,47,49,14,33,36,26,20,10,0,42,10,48,37,44,51,8,31,42,19,24,58,19,52,50,51,30,47,5,6,51,49,39,28,57,59,24,25,24,14,22,23,7,51,39,6,40,25,26,15,42,48,49,35,15,18,19,36,39,7,28,51,43,44,8,54,18,19,51,52,4,5,58,49,6,7,18,24,29,30,31,58,8,16,20,16,2,3,10,19,14,15,23,48,37,38,57,13,26,50,28,33,34,35,0,19,21,22,0,21,53,54,52,53,49,32,48,49,7,8,51,41,29,30,59,1,26,27,26,15,16,24,25,9,53,40,41,8,41,42,27,28,17,43,44,50,51,37,16,17,20,21,38,41,8,9,30,52,53,45,46,18,10,56,20,21,53,54,6,7,0,50,51,8,9,25,20,25,26,31,32,0,10,17,18,22,18,4,5,12,20,21,16,17,25,49,50,39,40,15,28,51,52,30,34,35,36,37,2,21,23,24,9,3,30,24,3,57,2,55,56,41,35,58,52,17,10,11,12,0,54,50,44,39,33,8,2,10,4,36,29,30,35,29,25,19,34,27,28,18,12,2,56,50,44,17,11,51,45,37,30,31,26,20,53,47,0,53,54,28,46,40,26,20,30,23,24,47,41,50,44,18,12,39,33,2,56,55,48,49,19,13,5,59,30,23,24,2,56,3,57,16,9,10,9,3,0,54,18,11,12,29,23,35,29,41,34,35,9,3,19,13,27,21,31,25,27,21,14,7,8,21,15,30,24,26,19,20,34,28,59,53,49,42,43,24,18,37,31,1,55,39,33,44,38,46,39,40,11,5,30,24,33,26,27,46,7,39,40,38,39,42,18,34,35,53,54,37,27,15,16,45,47,12,13,12,1,2,10,11,55,39,26,27,54,27,28,13,14,3,29,30,36,37,23,2,3,6,7,24,27,54,55,16,38,39,31,32,56,42,6,7,39,40,52,53,49,46,36,37,54,55,6,11,12,17,18,30,46,56,3,4,8,4,50,51,58,6,7,2,3,11,35,36,25,26,1,14,37,38,16,20,21,22,23,48,7,9,10,18,11,51,4,40,56,21,59,54,15,48,47,26,43,2,50,45,35,24,53,55,21,20,10,19,3,47,35,2,36,22,53,11,38,45,31,11,15,32,35,3,24,47,40,4,50,15,47,48,1,24,54,45,3,14,20,26,54,4,12,16,12,59,6,15,11,19,44,34,9,22,46,24,29,31,56,15,18,10,26,41,39,55,56,17,50,49,27,28,45,4,58,46,47,37,26,54,55,57,23,22,12,21,4,5,49,37,3,4,38,24,13,40,47,33,13,17,33,34,37,5,25,26,49,42,5,6,52,17,48,49,50,3,55,56,47,5,23,16,22,28,55,56,6,14,17,18,14,1,8,17,13,20,21,46,36,10,11,24,48,25,26,31,33,57,58,17,20,0,29,25,19,54,7,47,51,3,42,29,52,8,34,23,26,47,19,20,18,19,41,58,14,15,33,34,17,7,55,56,25,27,52,53,52,41,42,50,51,49,35,19,6,7,34,7,8,53,54,43,9,10,16,17,3,42,43,46,47,4,7,34,35,56,18,19,11,12,36,22,46,47,19,20,32,33,26,16,17,34,35,46,51,52,57,58,26,36,43,44,48,44,30,31,38,46,47,42,43,51,15,16,5,6,41,54,17,18,56,0,1,2,3,28,47,49,50,20,41,14,12,13,52,9,27,28,21,11,1,50,19,21,46,47,46,36,44,45,29,13,1,28,2,47,48,37,4,10,11,57,37,40,41,58,1,29,50,13,5,6,30,16,40,41,13,14,26,27,20,11,28,29,40,46,51,52,20,30,38,42,38,24,25,6,32,41,36,37,45,10,59,0,48,35,48,12,50,55,56,57,22,41,43,44,42,3,36,35,10,14,31,50,33,23,12,41,43,9,8,58,7,51,35,23,50,24,10,59,26,33,30,19,59,3,20,23,51,6,12,35,28,52,38,3,35,36,49,42,33,51,2,8,14,42,52,0,4,0,47,54,3,59,7,32,22,57,10,34,12,17,19,44,3,6,56,53,32};
static const short Gen_shift_values_BG1_Z_64[2109]= {57,1,41,56,4,46,24,33,46,56,30,52,19,59,62,19,35,6,52,9,28,21,29,36,2,39,48,50,58,44,30,36,38,7,45,27,21,62,37,53,8,13,26,44,32,18,2,3,32,22,13,47,26,52,11,61,12,51,34,62,58,46,52,15,30,27,11,57,58,2,42,57,4,5,47,25,33,34,47,57,30,31,53,20,60,63,20,35,36,7,53,9,10,29,22,30,37,3,40,49,51,58,59,45,31,36,37,39,8,45,46,28,22,62,63,38,54,8,9,14,27,45,33,19,2,3,4,33,22,23,14,48,27,53,12,61,62,13,52,34,35,63,59,46,47,53,16,30,31,28,12,58,2,41,42,56,57,5,46,47,24,25,34,47,56,57,31,53,19,20,60,62,63,19,20,36,7,52,53,10,28,29,21,22,30,36,37,2,3,40,48,49,50,51,59,45,30,31,37,38,39,7,8,46,28,21,22,63,38,53,54,9,13,14,26,27,45,32,33,18,19,3,4,32,33,23,14,47,48,27,52,53,11,12,62,12,13,51,52,35,63,58,59,47,52,53,15,16,31,28,11,12,58,2,42,56,57,5,47,24,25,34,47,57,31,53,19,20,60,63,19,20,36,7,53,10,29,21,22,30,37,2,3,40,49,50,51,59,45,31,37,39,7,8,46,28,21,22,63,38,53,54,9,14,26,27,45,33,18,19,3,4,33,23,14,47,48,27,53,11,12,62,13,51,52,35,63,59,47,53,15,16,31,28,11,12,28,37,44,52,28,43,12,55,33,11,43,20,33,43,17,39,6,1,46,49,6,22,57,39,60,15,8,16,23,53,26,35,37,45,31,17,23,25,58,32,14,8,49,24,40,38,59,0,13,31,19,5,53,54,19,9,0,34,27,13,39,62,48,63,38,21,49,45,33,39,2,17,14,62,58,54,21,27,2,51,10,28,18,27,43,30,30,38,39,42,20,50,28,26,3,4,41,18,19,47,53,31,31,8,9,9,50,51,3,18,60,31,9,41,18,19,15,57,37,15,4,45,46,6,44,22,47,24,25,4,45,46,20,62,55,33,37,14,15,58,36,13,54,55,6,47,48,14,56,21,62,63,51,28,29,24,2,33,10,11,35,12,13,43,21,29,7,15,56,57,21,63,23,0,1,56,33,34,30,8,12,54,6,47,48,47,25,22,0,38,15,16,18,57,35,62,39,40,11,52,53,29,7,17,58,59,3,44,45,51,29,52,30,17,58,59,7,49,62,40,32,9,10,37,11,53,37,14,15,60,37,38,46,24,61,38,39,36,13,14,19,61,47,25,43,20,21,35,31,9,37,14,15,0,41,42,15,57,12,54,60,37,38,44,38,53,44,20,13,13,60,23,33,20,38,31,48,57,53,15,16,61,24,37,0,52,15,12,0,26,27,42,5,20,47,40,29,55,56,42,5,52,15,26,52,53,48,11,15,42,55,18,58,21,15,42,31,57,58,2,29,48,11,5,31,32,24,51,17,44,25,52,32,59,62,25,35,62,44,7,46,9,54,16,17,40,3,26,53,32,58,59,34,61,3,30,41,3,4,23,50,17,44,58,20,21,33,60,49,12,18,4,30,31,9,36,22,49,40,3,28,55,14,41,62,24,25,63,26,28,55,18,44,45,9,36,43,6,53,22,49,48,11,7,34,57,19,20,8,35,47,10,30,56,57,58,21,54,17,42,4,5,48,11,11,38,26,52,53,23,50,7,34,13,31,41,20,31,41,6,55,56,0,40,55,48,2,3,45,23,31,32,45,55,28,29,51,18,55,58,61,18,33,34,5,51,7,8,27,20,28,35,1,22,38,47,49,56,57,43,29,34,35,37,6,43,44,26,20,60,61,36,52,6,7,12,25,43,31,17,0,1,2,31,20,21,12,46,25,51,10,59,60,11,50,32,33,61,57,44,45,51,14,56,28,29,26,10,13,54,13,62,15,36,45,53,29,43,44,39,56,34,11,12,31,21,34,44,18,40,6,7,47,50,6,7,23,58,40,61,16,8,9,17,24,53,54,27,36,37,38,46,32,18,24,26,58,59,0,33,15,8,9,50,25,40,41,60,1,13,14,62,32,20,5,6,54,55,20,10,1,34,35,14,40,62,63,49,0,38,39,10,22,50,46,34,40,2,3,18,15,62,63,19,27,3,18,30,8,50,63,59,8,18,56,14,45,48,21,24,45,61,32,14,35,54,47,55,62,28,1,10,12,20,6,56,62,0,33,7,53,47,48,24,63,15,34,39,52,6,58,44,28,29,58,48,39,9,52,14,37,23,38,13,60,24,20,8,14,41,50,56,53,37,6,35,58,0,15,41,40,7,26,18,59,8,7,62,31,25,33,9,24,22,36,14,56,1,14,24,62,20,51,57,27,30,51,3,38,20,41,60,53,61,4,34,7,16,18,26,12,62,24,4,6,39,13,59,53,46,30,5,21,40,45,58,12,0,50,34,35,0,54,45,15,58,20,43,29,44,19,2,30,26,14,20,47,62,59,43,56,56,44,2,42,63,13,59,29,27,18,41,23,23,31,7,22,47,34,12,54,63,12,22,60,18,49,21,25,28,49,43,1,36,18,39,58,51,59,2,32,5,14,16,24,10,60,2,4,37,11,57,51,51,28,3,19,38,43,56,10,62,48,32,33,62,52,43,13,56,18,41,27,42,17,0,28,24,12,18,45,60,57,41,22,7,51,53,2,50,22,60,24,39,1,63,36,52,62,0,8,48,62,63,11,53,30,31,21,40,53,63,37,59,25,26,2,5,25,26,42,13,59,16,35,27,28,36,43,8,9,46,55,56,57,1,51,37,43,45,13,14,52,34,27,28,5,44,59,60,15,20,32,33,51,39,24,25,43,9,10,39,29,20,53,54,33,59,17,18,4,19,57,58,19,41,5,1,53,59,21,22,37,34,17,18,3,11,50,51,1,2,23,14,55,56,33,34,43,56,1,2,40,62,28,29,5,7,8,28,29,45,16,61,62,19,37,38,30,31,39,45,46,11,12,49,57,58,59,60,4,54,39,40,46,47,48,16,17,8,55,37,30,31,8,47,62,63,18,22,23,35,36,55,54,41,42,27,28,12,13,41,42,32,23,56,57,36,61,62,20,21,7,21,22,60,61,44,8,3,4,56,61,62,24,25,40,37,20,21,37,55,45,63,21,39,36,53,54,48,2,26,44,4,21,22,30,13,31,26,44,36,54,10,28,32,50,63,16,17,39,57,42,60,63,16,17,15,33,50,4,32,50,53,7,8,26,1,18,19,9,27,16,34,46,63,0,48,19,37,28,46,30,47,48,38,56,24,42,10,28,16,34,18,36,51,4,5,25,43,7,25,1,18,19,42,60,17,35,33,50,51,52,6,57,11,6,23,24,24,42,12,30,62,15,16,46,0,47,1,12,30,2,20,57,11,27,44,45,6,24,32,50,55,8,9,41,59,56,10,31,48,49,14,32,42,60,38,56,26,44,32,50,59,12,13,10,28,7,25,55,8,9,51,59,34,35,49,50,28,62,39,40,17,18,27,40,49,50,24,46,12,13,53,55,56,12,13,29,0,45,46,3,21,22,14,15,23,29,30,59,60,33,41,42,43,44,52,38,23,24,30,31,32,0,1,39,21,14,15,56,31,46,47,47,2,6,7,19,20,38,25,26,11,12,6,60,61,25,26,16,7,40,41,20,45,46,4,5,55,5,6,44,45,28,56,51,52,40,45,46,8,9,24,21,4,5,1,58,40,18,62,38,35,30,32,40,16,31,43,21,63,32,8,21,31,5,27,58,34,37,58,10,45,27,48,3,60,4,4,11,41,14,23,25,33,19,5,11,13,46,20,2,60,37,12,28,14,47,52,1,19,7,57,41,42,7,61,52,22,1,27,50,36,51,26,9,37,33,21,27,54,5,2,50,36,40,50,55,51,52,60,36,51,62,63,41,19,5,27,28,41,51,24,25,47,14,54,57,14,29,30,1,47,3,4,23,16,24,31,61,34,43,45,52,53,39,25,30,31,33,2,39,40,22,16,56,57,32,48,2,3,8,21,27,39,27,13,60,61,62,27,16,17,8,42,21,47,6,55,56,7,46,28,29,57,53,40,41,47,10,24,25,22,6,38,22,28,34,44,10,20,63,28,8,20,38,44,10,22,3,11,50,51,1,2,20,14,55,56,33,34,43,56,1,2,40,62,28,29,5,7,8,28,29,28,45,16,61,62,19,37,38,30,31,39,45,46,11,12,49,57,58,59,60,4,54,39,40,46,47,48,16,17,55,37,30,31,8,47,62,63,18,22,23,35,36,54,41,42,27,28,12,13,41,42,32,23,56,57,36,61,62,20,21,7,21,22,60,61,44,8,3,4,56,61,62,24,25,40,37,20,21,5,13,53,3,4,16,58,35,36,22,45,58,4,42,0,30,31,7,10,30,31,47,18,0,21,40,32,33,41,48,13,14,51,60,61,62,6,56,42,48,50,18,19,57,39,32,33,10,49,0,1,20,25,37,38,56,44,29,30,14,15,44,34,25,58,59,34,38,0,22,23,9,24,62,63,44,46,10,6,58,0,26,27,42,39,22,23,38,46,22,37,10,49,27,5,14,27,37,11,33,0,40,43,0,16,51,33,54,9,2,10,17,47,28,20,29,31,39,25,11,34,17,19,52,26,8,2,43,18,34,53,58,7,25,13,63,47,48,13,3,58,28,7,33,56,42,57,32,15,43,39,27,33,60,11,8,56,20,22,38};
static const short Gen_shift_values_BG1_Z_72[2109]= {66,34,41,42,53,22,0,43,17,3,41,6,21,39,60,35,2,15,26,3,57,9,3,1,59,57,62,52,28,44,71,71,2,40,43,36,17,71,14,56,42,1,35,71,12,42,16,7,71,71,13,25,2,71,20,22,52,71,71,11,55,0,17,40,44,46,35,66,67,35,42,43,53,54,23,1,43,44,18,4,41,42,7,22,40,61,36,2,3,16,27,3,4,58,10,4,2,60,58,63,53,28,29,45,0,71,0,3,41,43,44,37,18,71,0,15,57,42,43,2,36,0,13,43,16,17,8,0,71,0,14,26,3,0,21,22,23,53,0,71,0,12,56,0,1,18,41,44,45,47,36,67,35,41,42,42,43,54,22,23,0,1,44,18,3,4,42,7,21,22,40,60,61,35,36,3,16,26,27,4,57,58,9,10,4,1,2,59,60,58,62,63,52,53,29,45,71,0,0,2,3,40,41,44,37,17,18,0,15,56,57,43,1,2,35,36,0,12,13,42,43,17,8,71,0,0,14,25,26,3,71,0,20,21,23,52,53,71,0,0,12,55,56,1,17,18,40,41,45,47,35,36,67,35,42,42,43,54,23,0,1,44,18,4,42,7,21,22,40,61,35,36,3,16,27,4,58,9,10,4,2,59,60,58,63,52,53,29,45,0,0,3,40,41,44,37,17,18,0,15,56,57,43,2,35,36,0,13,42,43,17,8,0,0,14,25,26,3,0,20,21,23,53,71,0,0,12,56,1,18,40,41,45,47,35,36,29,18,66,34,41,42,44,53,22,0,36,43,17,3,41,6,21,71,39,60,35,2,15,26,3,57,9,3,1,59,57,62,52,28,44,71,71,2,40,43,36,17,71,14,56,66,42,1,35,71,12,42,16,7,71,71,13,25,37,2,71,20,22,52,71,71,11,55,0,17,40,44,46,35,6,7,71,24,17,58,32,6,35,24,44,9,39,31,19,8,49,48,17,55,23,24,56,24,25,53,67,36,36,4,5,14,54,55,71,57,26,31,0,17,57,58,55,24,20,61,35,3,4,35,53,22,2,42,43,49,17,18,16,57,29,70,40,8,9,17,58,71,39,40,23,63,64,17,58,15,55,56,1,41,42,71,40,4,44,45,66,34,35,42,11,58,27,13,53,54,13,54,16,56,57,54,22,23,57,26,50,19,31,71,0,13,54,28,69,70,38,39,40,56,25,15,55,56,49,17,18,13,54,26,66,67,56,24,25,30,71,21,62,13,53,54,13,54,27,68,39,7,8,25,16,57,13,53,54,34,2,3,36,5,66,34,35,13,53,54,13,54,25,66,69,37,38,45,14,55,31,71,0,54,22,23,58,27,60,29,49,17,18,14,17,14,20,61,44,59,3,64,33,0,27,50,17,56,33,20,21,1,61,8,68,9,69,54,20,7,8,61,49,39,27,22,10,69,70,56,44,42,30,8,67,68,45,33,60,48,6,66,27,15,2,62,41,28,29,54,42,65,53,42,29,30,24,12,48,36,42,30,40,28,26,14,24,12,29,17,19,7,67,54,55,11,71,38,26,38,25,26,41,29,7,67,10,69,70,3,63,56,44,38,25,26,53,41,23,11,57,9,68,69,40,28,2,62,38,26,51,39,9,69,55,42,43,46,34,38,26,38,25,26,52,40,64,52,36,41,29,38,26,59,47,61,48,49,19,7,38,26,38,25,26,50,38,22,10,39,26,27,56,44,7,67,11,70,71,13,1,2,62,56,8,17,27,6,21,26,30,31,71,6,7,14,17,18,59,37,7,8,54,40,5,6,43,58,71,4,25,0,38,39,52,63,39,40,22,46,40,38,24,71,22,27,17,64,65,9,36,35,36,39,5,7,8,1,54,35,36,51,21,6,7,38,0,36,49,7,52,53,44,36,35,36,50,62,39,36,57,58,59,17,36,35,36,48,20,36,37,54,5,46,8,9,11,0,71,41,36,15,71,6,59,27,34,34,35,25,46,15,64,65,71,36,10,68,34,71,13,14,32,53,27,28,67,8,19,68,50,1,2,68,66,51,52,50,55,44,45,21,37,64,64,67,32,33,38,36,29,9,10,64,7,48,49,35,66,27,28,35,64,5,34,35,9,0,64,64,6,17,18,67,64,12,13,15,45,63,64,67,64,4,48,65,10,32,33,37,39,27,28,66,34,41,42,53,22,0,53,43,17,3,41,6,21,12,39,60,35,2,15,26,3,57,9,3,1,59,57,62,52,28,44,71,71,2,40,43,36,17,26,71,14,56,42,1,35,71,12,42,16,7,71,71,13,25,2,71,20,22,52,71,71,11,55,0,17,40,53,44,46,35,8,64,71,71,17,16,6,71,24,71,71,71,45,71,71,6,46,53,54,48,65,34,12,55,29,15,53,18,33,8,51,0,47,14,27,38,15,69,21,15,13,71,69,2,64,40,56,11,17,11,14,52,55,48,29,71,11,26,68,54,13,47,11,24,54,28,19,11,11,25,37,14,11,32,34,64,11,11,23,67,12,29,52,56,58,47,63,45,49,8,17,71,44,71,40,35,71,71,20,66,34,41,42,19,53,22,0,43,17,3,41,6,21,54,39,60,35,71,2,15,26,3,57,9,3,1,59,57,62,52,28,44,71,71,2,40,43,36,17,49,71,14,56,42,1,35,71,12,42,16,7,71,71,13,25,2,71,20,22,52,71,71,11,55,0,17,40,44,46,35,60,71,71,38,71,71,71,60,44,35,71,58,71,10,61,37,5,12,12,13,24,65,42,43,71,14,60,46,12,49,63,64,10,31,5,6,45,58,69,46,28,51,52,46,44,29,30,28,33,22,23,71,15,42,42,45,10,11,14,7,59,60,42,57,26,27,13,44,5,6,42,55,12,13,35,59,50,42,42,56,67,68,45,42,62,63,65,23,41,42,71,42,54,26,43,60,10,11,15,17,5,6,24,64,70,71,71,0,71,11,51,52,29,30,1,47,32,33,71,36,50,51,69,17,18,64,65,32,45,55,56,33,14,15,38,39,33,30,31,16,17,15,19,20,9,10,58,2,28,29,29,31,32,69,70,17,1,66,46,47,29,44,13,14,0,30,31,64,65,35,29,41,42,71,0,46,37,28,29,29,43,54,55,32,28,29,49,50,52,9,10,28,29,29,41,12,13,30,46,47,69,70,2,4,64,65,16,14,56,54,63,61,64,61,62,3,1,44,42,22,19,20,71,65,63,39,37,25,23,63,61,28,26,43,40,41,61,59,10,8,57,54,55,24,22,37,35,48,46,25,23,7,5,31,28,29,25,23,23,21,9,6,7,71,7,5,12,10,2,71,0,50,48,66,64,21,19,21,19,24,22,62,59,60,65,63,58,56,39,36,37,21,19,36,34,6,3,4,64,62,23,21,57,54,55,21,19,34,32,64,61,62,38,36,29,27,21,19,21,19,35,33,47,44,45,24,22,21,19,42,39,40,44,42,2,0,21,18,19,21,19,33,31,5,3,22,20,39,37,62,59,60,66,64,68,66,57,54,55,13,53,59,60,60,61,71,0,40,41,18,19,62,36,21,22,60,25,39,40,58,6,7,53,54,21,34,44,45,22,3,4,27,28,22,19,20,5,6,4,8,9,70,71,47,63,17,18,18,20,21,58,59,62,55,35,36,18,33,2,3,66,61,19,20,53,54,18,30,31,60,61,35,35,26,17,18,18,32,43,44,21,17,18,38,39,41,70,71,17,18,18,30,1,2,19,35,36,58,59,63,65,53,54,71,71,3,17,52,71,35,71,55,23,30,31,42,11,61,54,32,6,64,30,67,10,28,49,24,63,4,15,64,46,70,61,64,62,48,46,51,41,17,33,60,60,63,29,32,25,6,60,3,45,71,31,62,24,60,1,31,5,68,60,60,2,14,63,60,9,11,41,60,60,0,44,61,6,29,33,35,24,71,15,71,71,66,67,35,42,43,53,54,23,1,71,43,44,18,4,41,42,7,22,40,61,36,2,3,16,27,3,4,58,10,4,2,60,58,63,53,28,29,45,0,71,0,3,41,43,44,37,18,71,0,15,57,42,43,2,36,71,0,13,43,16,17,8,0,71,0,14,26,3,0,21,22,23,53,0,71,0,12,56,0,1,18,41,44,45,47,36,45,71,71,71,8,71,20,44,71,71,1,71,71,71,38,30,70,4,5,5,6,26,17,57,58,35,36,7,53,38,39,5,42,56,57,3,23,24,70,71,71,38,51,61,62,39,20,21,44,45,39,36,37,22,23,21,25,26,15,16,64,8,34,35,35,37,38,3,4,7,0,52,53,35,50,19,20,6,36,37,70,71,35,47,48,5,6,52,43,34,35,35,49,60,61,38,34,35,55,56,58,15,16,34,35,35,47,18,19,36,52,53,3,4,8,10,70,71,49,17,24,24,25,36,5,54,55,51,26,0,58,24,61,3,4,22,43,17,18,57,70,9,58,40,63,64,58,56,41,42,40,45,34,35,11,27,54,54,57,22,23,26,19,71,0,54,69,38,39,25,56,17,18,54,67,24,25,71,62,54,54,68,7,8,26,57,54,2,3,5,35,53,54,71,54,66,38,55,0,22,23,27,29,17,18,51,19,26,27,17,38,7,57,28,2,60,26,63,6,24,45,20,59,0,11,60,42,66,60,58,44,71,42,47,37,13,29,56,71,56,59,25,28,21,2,56,71,41,27,58,20,56,69,27,1,64,56,56,70,10,59,56,5,7,37,56,56,68,40,57,2,25,29,31,20,23,71,71};
static const short Gen_shift_values_BG1_Z_80[2109]= {72,62,67,59,14,6,47,22,53,79,48,26,29,20,39,36,79,0,37,38,66,60,52,41,14,3,39,78,14,79,70,1,25,40,54,48,62,3,59,12,52,54,3,75,42,52,57,25,60,29,71,43,2,23,27,32,5,76,15,19,69,28,35,78,31,60,67,72,73,63,68,60,14,15,7,48,22,23,54,0,48,49,27,30,21,40,37,79,0,1,38,38,39,67,61,53,42,15,4,40,79,14,15,0,71,1,2,26,41,54,55,49,63,3,4,60,13,52,53,55,4,76,43,53,57,58,26,61,29,30,72,44,3,24,28,32,33,6,77,15,16,20,70,28,29,36,79,31,32,61,68,73,63,67,68,59,60,15,6,7,47,48,23,54,79,0,49,27,29,30,21,39,40,36,37,0,1,37,38,39,66,67,60,61,53,41,42,14,15,4,39,40,78,79,15,0,70,71,2,25,26,40,41,55,49,62,63,4,60,12,13,53,54,55,3,4,76,42,43,52,53,58,26,60,61,30,72,43,44,3,23,24,27,28,33,5,6,76,77,16,20,69,70,29,35,36,78,79,32,61,67,68,73,63,68,59,60,15,7,47,48,23,54,0,49,27,29,30,21,40,36,37,0,1,38,39,67,60,61,53,42,14,15,4,40,78,79,15,0,71,2,26,40,41,55,49,62,63,4,60,12,13,53,55,3,4,76,43,52,53,58,26,61,30,72,43,44,3,24,27,28,33,6,76,77,16,20,70,29,36,78,79,32,61,67,68,72,44,31,21,26,18,2,53,45,6,51,61,12,38,7,65,68,49,59,78,75,38,39,76,77,25,19,11,0,53,42,78,37,53,38,29,40,64,79,13,7,21,42,18,51,77,11,13,42,34,1,11,16,64,19,68,30,2,40,41,62,66,71,44,35,54,58,28,67,74,37,70,19,26,26,48,20,52,12,71,61,57,74,11,7,46,49,24,75,77,67,67,57,72,61,62,64,53,54,54,19,9,11,0,1,52,41,42,52,27,17,58,48,4,73,74,53,43,31,21,34,23,24,49,25,15,44,33,34,41,30,31,4,74,5,75,42,31,32,43,33,71,60,61,65,54,55,57,47,46,35,36,19,8,9,8,78,44,33,34,3,72,73,19,9,4,74,75,64,65,6,76,30,19,20,45,34,35,59,49,53,43,67,56,57,8,78,64,54,17,6,7,70,57,47,59,48,49,8,77,78,0,70,47,36,37,57,46,47,62,52,30,20,65,54,55,34,24,76,66,48,37,38,55,7,77,28,17,18,32,21,22,37,27,10,79,0,1,70,71,20,10,24,14,74,63,64,29,33,23,40,29,30,3,72,73,36,26,65,55,72,61,62,28,28,3,35,45,70,26,54,48,13,79,50,74,0,70,35,32,33,25,23,30,28,22,20,15,57,54,55,49,47,10,8,66,65,62,63,16,14,42,40,11,8,9,69,67,72,70,63,61,2,0,79,77,42,39,40,43,41,0,78,1,78,79,29,27,23,21,15,13,4,2,57,55,46,44,2,0,41,39,57,54,55,42,40,33,31,44,41,42,68,66,3,1,17,14,15,11,9,25,23,46,43,44,22,20,55,53,49,15,12,13,17,15,46,44,38,36,5,3,15,13,20,17,18,68,66,23,21,72,69,70,34,32,6,4,48,45,43,66,64,70,68,75,72,73,48,46,39,37,58,55,56,62,60,32,30,71,68,69,78,76,41,39,74,71,72,23,21,30,28,16,68,74,8,47,24,51,29,30,20,25,17,38,51,52,44,5,59,60,11,37,5,6,64,67,61,58,77,74,36,37,38,75,75,76,24,18,10,79,52,62,41,77,36,51,52,37,28,38,39,63,78,11,12,6,20,40,41,17,50,9,10,12,41,33,0,10,14,15,63,18,66,67,29,1,40,61,65,69,70,43,34,52,53,57,27,65,66,73,36,79,68,69,18,25,77,58,53,60,18,17,44,34,39,30,31,68,66,58,18,19,49,74,25,51,20,78,0,1,72,11,7,8,51,52,9,10,38,31,32,24,13,65,66,55,11,49,50,66,51,42,53,77,11,12,59,26,20,33,34,55,31,63,64,24,26,54,55,49,47,14,23,24,29,77,32,1,43,14,15,54,75,78,79,4,57,47,48,23,67,71,41,0,7,49,50,3,32,38,39,52,42,47,39,74,66,27,68,2,33,59,28,6,9,59,0,19,16,59,60,17,18,46,40,32,21,74,63,19,58,74,59,50,61,5,20,34,28,42,44,63,39,72,32,34,63,55,22,32,37,5,40,9,51,23,62,3,7,12,65,56,75,79,49,8,15,58,34,11,40,47,16,66,47,50,67,19,53,50,60,54,63,20,20,29,40,2,72,77,69,60,24,16,57,32,63,9,58,36,39,1,30,49,46,9,10,47,48,76,70,62,51,24,13,49,8,24,9,0,39,11,35,50,64,58,72,49,13,69,22,62,64,13,5,52,62,67,35,70,39,1,53,12,33,37,42,15,6,25,29,79,38,45,8,41,70,77,78,14,51,42,22,16,19,54,75,8,49,52,24,33,23,28,20,48,55,47,8,63,14,40,9,67,70,39,61,0,77,29,40,41,78,79,27,21,13,2,55,44,0,39,55,40,31,42,66,1,15,9,23,26,44,20,53,13,15,44,36,3,13,18,66,21,70,32,4,43,64,68,73,46,37,56,60,30,69,76,39,72,21,28,11,54,15,45,29,29,77,66,49,28,63,10,52,49,73,22,12,17,8,9,44,36,76,77,26,52,3,29,78,56,58,59,50,69,65,66,29,30,67,68,16,9,10,2,71,43,44,33,69,27,28,44,29,20,31,55,69,70,4,78,11,12,33,9,41,42,2,4,32,33,25,72,1,2,67,7,55,10,59,21,72,73,32,53,56,57,62,35,25,26,36,45,49,19,58,65,27,28,61,10,16,17,48,38,42,43,34,35,10,70,61,62,22,23,78,29,54,55,24,2,4,5,76,14,15,11,12,55,56,12,13,14,41,42,35,36,28,16,17,69,70,59,14,15,53,54,70,55,45,46,57,0,1,15,16,22,30,24,37,38,59,35,67,68,28,29,30,58,59,24,51,17,18,27,28,33,1,35,36,5,47,18,19,58,78,79,2,3,8,60,61,51,52,71,75,44,45,4,10,11,53,54,7,36,42,43,58,75,48,65,53,70,45,61,62,0,17,72,9,33,49,50,61,8,25,39,56,65,2,34,51,12,29,15,31,32,6,23,25,42,22,38,39,65,2,66,3,23,40,24,41,52,69,46,62,63,38,55,27,44,0,16,17,67,69,6,25,42,64,0,1,0,17,65,2,56,73,67,4,11,28,26,42,43,40,57,34,51,48,64,65,69,6,45,62,78,14,15,38,55,40,57,69,5,6,61,78,28,45,38,54,55,43,60,11,28,46,63,15,32,57,74,29,45,46,68,5,9,26,13,29,30,18,35,71,8,62,78,79,1,18,5,22,55,72,14,31,21,38,64,0,1,17,34,46,63,53,69,70,50,40,44,45,36,37,49,72,63,64,24,25,0,31,56,57,26,4,6,7,78,16,17,13,14,57,58,14,15,16,43,44,37,38,30,18,19,71,72,61,16,17,55,56,72,57,47,48,59,2,3,17,18,32,26,39,40,61,37,69,70,21,30,31,32,60,61,53,19,20,29,30,30,35,3,37,38,7,49,20,21,60,0,1,4,5,10,62,63,53,54,73,77,46,47,6,12,13,55,56,9,38,44,45,9,19,59,32,26,55,4,43,37,27,32,24,59,51,12,46,67,18,44,13,71,74,65,4,1,44,45,2,3,31,25,77,17,6,59,48,4,43,59,44,35,46,70,5,19,13,27,48,24,57,54,17,19,48,40,7,17,22,70,25,74,36,8,47,68,72,77,50,41,60,64,34,73,0,43,76,25,32,18,18,17,79,27,28,18,23,15,49,50,42,3,57,57,58,9,35,3,4,62,65,56,75,72,34,35,36,73,73,74,22,16,8,77,50,39,75,34,49,50,35,26,36,37,61,76,9,10,4,18,38,39,15,48,7,8,10,39,14,31,78,8,12,13,61,16,64,65,27,79,38,59,63,67,68,41,32,50,51,55,25,63,64,71,34,66,67,16,23,70,18,63,20,21,76,31,47,31,79,36,73,46,43,46,39,29,33,34,25,26,65,61,52,53,13,14,69,20,45,46,15,73,75,76,67,5,6,2,3,64,46,47,3,4,5,32,33,26,27,19,7,8,60,61,50,5,6,44,45,61,46,36,37,48,71,72,6,7,21,15,28,29,50,26,58,59,19,20,21,49,50,42,8,9,18,19,24,72,26,27,76,38,9,10,49,69,70,73,74,79,51,52,42,43,62,66,35,36,75,1,2,44,45,78,27,33,34,15,5,10,1,2,37,29,69,70,67,45,76,22,71,49,51,52,43,62,58,59,22,23,60,61,9,2,3,75,64,36,37,26,62,20,21,37,22,13,24,48,62,63,77,71,4,5,26,2,34,35,75,77,25,26,18,65,74,75,0,48,3,52,14,65,66,68,25,46,49,50,55,28,18,19,15,38,42,12,51,58,20,21,54,3,9,10,12,2,7,79,73,34,26,67,42,73,19,68,46,49,40,59,56,19,20,57,58,6,0,72,61,34,66,23,59,18,34,19,10,18,21,45,60,74,68,2,23,79,32,72,74,23,15,62,72,77,45,0,49,11,63,22,43,47,52,25,16,35,39,9,48,55,18,51,0,7,20,67,45};
static const short Gen_shift_values_BG1_Z_88[2109]= {29,76,49,8,29,34,5,78,48,36,65,7,48,73,37,14,30,3,22,76,0,50,23,39,77,37,60,2,66,49,29,73,38,17,0,78,69,74,76,80,24,21,4,69,21,8,52,65,36,82,80,72,44,42,38,39,74,54,78,8,33,46,6,32,11,37,32,29,30,77,50,9,29,30,35,6,78,79,49,37,65,66,8,49,74,38,15,30,31,4,23,76,77,1,51,24,40,78,38,61,3,66,67,50,30,73,74,39,18,0,1,79,70,74,75,77,81,24,25,22,5,70,22,9,52,53,66,37,82,83,81,73,45,43,39,39,40,75,55,78,79,9,34,46,47,7,33,11,12,38,33,30,77,49,50,8,9,30,34,35,5,6,79,49,36,37,66,8,48,49,74,37,38,14,15,31,4,22,23,77,0,1,50,51,24,39,40,77,78,38,60,61,2,3,67,50,29,30,74,38,39,17,18,1,79,69,70,75,77,80,81,25,21,22,4,5,70,21,22,8,9,53,66,36,37,83,81,72,73,45,42,43,38,39,40,74,75,54,55,79,9,33,34,47,6,7,32,33,12,38,32,33,30,77,50,8,9,30,35,5,6,79,49,37,66,8,48,49,74,38,14,15,31,4,23,77,1,50,51,24,40,77,78,38,61,2,3,67,50,30,74,39,17,18,1,79,69,70,75,77,80,81,25,22,4,5,70,22,8,9,53,66,37,83,81,72,73,45,43,38,39,40,75,54,55,79,9,34,47,7,32,33,12,38,32,33,41,79,48,7,68,27,42,48,53,24,41,9,67,55,84,26,67,74,4,56,33,49,22,41,7,19,69,42,58,8,56,79,21,85,68,48,4,57,36,19,9,0,5,7,11,57,43,40,23,0,40,27,71,84,55,13,11,3,30,63,61,57,58,5,73,9,27,52,65,25,51,30,56,51,81,29,72,65,10,83,61,19,40,2,14,47,32,38,38,79,10,38,57,11,29,30,58,76,77,83,79,10,84,14,15,55,73,74,74,40,59,10,29,86,16,17,27,46,57,76,10,28,29,21,35,54,87,17,18,64,82,83,80,11,53,72,72,2,3,38,57,50,68,69,12,30,31,73,4,1,19,20,39,57,58,87,18,22,40,41,52,70,71,28,47,11,30,79,9,10,35,54,0,18,19,67,85,86,50,69,40,59,31,49,50,36,55,38,57,42,60,61,47,74,5,71,1,2,54,72,73,31,50,71,1,2,58,76,77,14,33,27,46,86,16,17,44,63,42,61,34,52,53,47,6,25,4,22,23,0,18,19,1,20,36,54,55,16,34,35,40,59,58,77,83,13,14,16,8,27,56,74,75,82,12,13,61,80,87,18,82,12,13,58,67,87,28,22,3,63,22,72,86,76,26,54,48,2,15,45,46,62,5,35,66,82,25,24,15,45,46,20,51,79,22,57,64,6,7,34,65,22,53,51,81,82,81,24,34,65,59,2,23,54,0,31,16,46,47,77,20,8,39,62,4,5,74,17,36,67,9,40,25,56,63,6,23,54,46,77,76,19,52,82,83,35,66,15,46,59,1,2,24,55,3,34,74,16,17,64,7,55,86,60,2,3,62,5,66,9,23,10,40,41,7,38,78,21,55,86,7,38,82,25,38,68,69,51,82,22,53,68,10,11,66,9,58,1,86,30,61,28,59,24,55,25,55,56,60,3,40,71,64,6,7,82,25,19,50,32,62,63,80,23,18,49,85,27,28,23,54,18,49,77,34,40,53,21,87,75,22,23,70,43,2,46,22,23,28,87,71,72,42,30,58,59,1,42,74,67,31,8,23,24,85,16,69,70,82,44,17,33,71,0,31,54,84,59,60,43,23,66,67,32,11,81,82,72,63,67,68,70,74,17,18,15,86,63,15,2,45,46,59,30,75,76,74,66,38,36,32,32,33,68,48,71,72,2,27,39,40,0,26,5,4,5,31,26,21,57,12,67,65,77,55,14,75,33,34,87,55,60,30,31,83,16,74,62,3,33,73,74,11,63,39,40,56,29,48,14,26,75,76,49,65,14,15,63,86,27,28,4,75,55,11,64,42,43,14,26,16,6,7,12,14,17,18,50,47,29,30,80,7,47,33,34,78,3,62,20,18,9,10,70,68,63,64,65,12,79,80,87,16,34,59,72,32,57,58,37,63,57,58,55,14,75,34,55,60,31,13,16,74,62,3,33,74,28,11,63,40,56,29,48,14,26,76,49,65,15,63,86,28,4,75,55,11,64,43,26,16,7,67,12,14,18,50,47,30,7,47,34,78,3,62,20,18,10,70,68,64,65,12,80,16,34,59,72,32,58,66,37,63,58,21,51,70,27,13,46,21,69,4,72,86,21,58,81,27,59,18,79,38,0,59,64,35,20,78,66,7,37,78,64,15,67,44,60,33,52,18,30,80,53,69,19,67,2,32,8,79,59,66,15,68,47,30,20,11,67,16,18,22,54,51,34,11,51,38,82,7,66,24,22,14,74,72,68,69,16,84,20,38,63,76,36,62,41,67,62,73,87,81,54,20,15,68,59,24,17,5,4,39,47,6,67,26,37,47,52,23,8,66,54,83,25,66,81,3,55,32,72,48,21,40,6,18,68,41,57,7,55,78,20,84,67,47,3,56,35,18,8,87,23,4,6,10,42,39,22,87,39,26,70,83,54,12,10,2,62,60,56,57,4,72,8,26,51,64,24,50,29,55,50,14,78,22,53,60,61,49,10,2,61,3,13,0,39,78,49,8,69,27,28,49,54,24,25,8,10,68,56,85,27,67,68,5,57,33,34,50,23,42,8,20,69,70,43,59,8,9,57,80,21,22,86,69,49,5,58,36,37,20,10,0,1,6,8,11,12,44,41,23,24,1,41,27,28,15,72,85,56,14,12,3,4,64,62,57,58,59,6,73,74,66,10,28,53,66,26,51,52,31,57,51,52,66,25,85,86,44,45,82,66,70,71,41,42,27,85,72,73,14,44,84,85,22,73,74,50,51,67,40,58,59,25,36,37,86,87,60,75,76,25,26,74,8,9,38,39,15,86,65,66,22,74,75,53,54,15,37,27,17,18,23,25,28,29,61,57,58,40,41,6,18,57,58,44,45,1,14,72,73,31,29,20,21,81,78,79,74,75,76,22,23,2,3,27,45,69,70,83,42,43,68,69,48,74,68,69,44,76,3,35,64,8,23,54,55,44,76,49,81,20,51,52,12,5,37,63,7,51,83,80,24,22,54,63,6,7,0,32,52,84,29,60,61,45,77,18,50,37,69,3,35,15,47,65,8,9,38,70,54,86,4,35,36,32,52,84,75,19,17,48,49,81,25,64,8,44,76,0,32,53,85,32,63,64,15,47,5,37,84,27,28,1,33,3,35,7,38,39,39,71,36,68,19,50,51,84,28,36,68,23,54,55,67,11,80,24,51,83,9,41,7,39,87,30,31,59,3,57,1,53,84,85,54,86,1,33,69,12,13,5,37,23,55,48,80,61,5,21,53,47,78,79,26,58,52,84,47,78,79,25,72,44,45,3,4,86,25,29,30,0,1,74,44,31,32,61,3,43,44,69,32,33,9,10,26,87,17,18,72,83,84,45,46,19,34,35,72,73,33,55,56,85,86,62,45,24,25,69,33,34,12,13,84,74,64,65,70,72,75,76,0,20,16,17,87,0,65,16,17,3,4,73,48,61,31,32,78,76,67,68,40,37,38,33,34,35,69,70,49,50,74,4,28,29,42,1,2,27,28,7,33,27,28,55,39,52,12,59,55,23,53,33,80,53,12,33,38,9,11,82,52,40,69,11,52,77,41,18,34,7,26,80,4,54,33,27,43,81,41,64,6,70,53,33,77,42,21,4,82,73,78,80,84,18,28,25,8,73,25,12,56,69,40,86,84,76,48,46,42,43,78,58,82,12,37,50,10,36,15,41,36,46,14,34,11,26,27,74,47,6,26,27,32,3,54,75,76,46,34,62,63,5,46,71,35,12,27,28,1,20,73,74,86,48,21,37,75,35,58,0,63,64,47,27,70,71,36,15,85,86,76,67,71,72,74,78,21,22,19,2,59,67,19,6,49,50,63,34,79,80,78,70,42,40,36,36,37,72,52,75,76,6,31,43,44,4,30,8,9,35,30,75,19,32,69,59,87,36,7,39,60,46,34,76,24,7,47,6,66,67,25,26,23,47,51,52,22,23,8,66,53,54,83,25,65,66,3,54,55,31,32,82,48,21,39,40,6,17,18,67,68,41,56,57,6,7,55,77,78,19,20,84,67,46,47,3,55,56,34,35,18,8,86,87,4,6,9,10,42,38,39,21,22,87,38,39,25,26,70,83,53,54,12,10,1,2,62,59,60,55,56,57,3,4,71,72,8,26,50,51,64,23,24,49,50,29,55,49,50,21,68,41,87,0,21,26,84,85,33,70,40,28,57,87,39,40,65,29,5,6,22,83,14,68,80,41,42,15,31,68,69,29,52,81,82,58,41,21,65,30,8,9,80,70,60,61,66,68,71,72,16,13,83,84,61,13,87,0,44,57,28,74,72,63,64,2,36,34,29,30,31,66,45,46,52,70,0,25,38,86,23,24,3,29,23,24,37,84,57,16,78,37,42,13,86,56,44,73,15,56,81,45,22,38,11,30,84,8,58,31,47,85,67,45,68,10,74,57,37,28,81,46,25,8,86,77,82,84,0,32,29,12,77,29,16,60,73,44,2,0,80,52,50,46,47,82,62,86,16,41,54,14,40,19,45,40,81,66,58};
static const short Gen_shift_values_BG1_Z_96[2109]= {18,75,12,83,18,57,86,49,75,39,80,72,95,95,43,82,84,47,63,23,64,6,42,74,56,42,63,55,28,81,62,95,32,35,12,6,16,16,53,38,68,7,52,24,87,19,22,2,52,9,65,15,17,34,11,49,47,78,83,42,12,41,12,38,57,15,68,18,19,76,13,84,18,19,58,87,49,50,76,40,80,81,73,0,0,44,83,84,85,48,64,23,24,65,7,43,75,57,43,64,56,28,29,82,63,95,0,33,36,12,13,7,17,16,17,54,39,68,69,8,53,25,88,20,22,23,3,53,9,10,66,16,18,35,12,49,50,48,79,83,84,43,13,41,42,13,39,57,58,16,69,19,76,12,13,83,84,19,57,58,86,87,50,76,39,40,81,73,95,0,0,43,44,82,83,85,48,63,64,24,64,65,6,7,43,74,75,56,57,43,63,64,55,56,29,82,62,63,0,32,33,35,36,13,7,16,17,17,54,38,39,69,7,8,52,53,25,87,88,19,20,23,3,52,53,10,66,15,16,18,34,35,11,12,50,47,48,78,79,84,43,12,13,42,12,13,38,39,58,16,68,69,19,76,13,83,84,19,58,86,87,50,76,40,81,73,95,0,0,44,82,83,85,48,64,24,65,6,7,43,75,56,57,43,64,55,56,29,82,63,0,33,35,36,13,7,16,17,17,54,38,39,69,8,52,53,25,88,19,20,23,3,53,10,66,15,16,18,35,11,12,50,48,78,79,84,43,13,42,13,38,39,58,16,68,69,43,84,79,40,73,48,2,79,22,51,13,14,40,4,45,37,60,18,60,8,47,49,12,28,84,29,67,7,39,21,7,28,20,89,46,27,60,93,0,73,67,77,77,18,3,69,33,68,17,85,52,80,83,63,17,70,30,76,48,78,95,72,14,12,43,48,7,73,6,73,3,22,76,33,50,85,64,0,62,91,60,17,32,8,61,27,44,1,17,85,93,46,54,79,86,87,54,61,62,18,85,93,28,35,36,57,64,65,82,20,28,46,54,10,17,18,51,59,43,51,66,73,74,68,66,74,14,21,22,53,60,61,55,63,18,26,34,41,42,90,2,35,42,43,73,80,81,13,21,45,52,53,27,34,35,13,21,34,41,42,26,33,34,95,7,52,60,33,40,41,66,74,3,10,11,6,13,14,79,87,73,81,83,90,91,83,91,24,32,9,16,17,17,39,47,74,81,82,23,30,31,91,3,58,65,66,86,93,94,89,1,69,77,23,30,31,76,84,36,44,82,89,90,38,84,92,5,12,13,78,85,86,20,28,18,25,26,49,56,57,54,62,13,21,79,86,87,31,12,20,79,86,87,9,16,17,28,36,82,90,39,46,47,79,77,39,32,36,56,14,62,81,4,50,81,14,94,65,64,37,38,25,95,58,32,33,7,47,64,37,38,7,77,36,10,5,95,68,69,25,95,85,59,30,3,4,22,92,45,19,45,19,89,63,32,6,34,7,8,93,67,13,83,69,42,43,14,84,52,26,88,62,24,94,6,76,88,62,13,83,5,75,74,47,48,31,5,12,82,45,18,19,78,52,81,55,58,31,32,52,26,62,36,62,35,36,3,73,84,58,7,18,87,88,53,27,2,72,70,44,37,11,65,39,68,41,42,48,22,2,72,55,28,29,15,85,61,35,46,63,37,80,54,57,31,95,68,69,93,67,28,2,33,6,7,88,62,58,32,87,60,61,58,32,84,58,7,76,77,61,35,18,88,91,76,89,77,39,49,73,4,5,62,95,70,24,4,5,44,73,35,36,62,26,66,67,59,82,80,82,30,69,70,71,34,50,9,10,51,89,29,61,43,73,29,50,42,14,15,68,49,81,82,19,22,94,95,89,3,2,3,40,25,54,55,90,39,11,74,6,8,9,85,39,91,92,52,2,4,21,94,35,36,34,65,69,70,29,95,27,28,95,25,18,43,44,2,55,45,55,40,88,58,11,0,57,90,64,65,48,0,39,67,68,1,31,57,21,62,54,76,77,77,25,63,64,66,29,45,5,46,83,84,24,56,37,38,24,45,36,37,10,63,44,77,14,16,17,17,90,84,93,94,94,35,19,20,50,85,33,34,29,6,69,0,1,4,80,34,87,47,92,93,95,16,88,89,31,29,59,60,54,65,24,90,23,90,19,20,39,93,49,50,75,36,69,44,75,18,47,12,10,36,0,41,33,56,49,56,4,43,45,8,24,80,25,63,3,35,17,3,24,16,85,42,23,56,89,92,69,63,73,56,73,14,95,29,64,13,81,48,76,79,59,13,66,26,72,74,91,68,10,8,39,44,3,69,2,69,95,0,18,72,29,67,14,80,69,86,33,66,87,35,3,48,20,55,49,4,77,38,71,46,90,77,20,49,12,38,2,43,35,58,13,58,6,45,47,10,26,82,27,65,5,37,19,5,26,18,87,44,25,71,58,91,94,71,65,75,52,75,16,1,31,66,15,83,50,78,81,61,15,68,28,74,76,93,70,12,10,41,46,5,71,4,71,1,20,74,31,12,5,39,20,0,29,10,40,21,23,88,60,26,60,21,54,29,9,60,3,32,91,21,81,26,18,41,61,41,85,28,42,30,89,9,65,10,48,84,20,2,84,9,1,70,27,8,41,74,77,54,48,58,50,58,95,80,14,49,94,66,33,61,64,44,94,51,11,57,59,76,53,91,89,24,29,84,54,83,54,80,3,57,14,71,16,94,23,70,80,75,39,1,1,4,29,18,51,81,1,58,91,65,66,1,40,68,69,59,32,58,22,63,55,77,78,78,26,64,65,67,30,46,6,47,84,85,25,57,38,39,25,46,37,38,11,64,45,78,15,17,18,91,85,94,95,95,36,20,21,51,86,34,35,7,70,1,2,4,5,81,35,88,48,93,94,0,17,89,90,32,30,60,61,50,66,25,91,24,91,20,21,40,94,50,51,13,70,6,7,77,78,62,13,51,52,80,81,44,70,33,34,75,67,89,90,90,37,38,76,77,79,42,57,58,18,58,59,0,1,37,68,69,50,51,37,57,58,49,50,23,76,56,57,90,26,27,29,30,36,7,1,10,11,11,48,32,33,63,1,2,46,47,67,19,81,82,13,14,17,93,46,47,4,60,9,10,12,28,29,5,6,44,41,42,72,73,78,37,6,7,36,6,7,32,33,52,10,62,63,84,83,45,44,78,77,53,51,52,84,83,27,26,56,54,55,3,19,18,45,44,9,8,50,49,42,41,65,63,64,65,64,13,12,52,50,51,54,53,17,16,33,32,89,88,34,33,72,70,71,12,11,44,43,26,24,25,22,12,11,33,32,25,23,24,94,93,51,50,32,31,65,64,2,1,5,3,4,78,77,72,71,82,80,81,82,81,23,22,8,6,7,38,37,73,72,22,20,21,90,89,57,56,85,83,84,88,87,68,67,22,21,75,74,35,34,81,79,80,83,82,4,3,77,75,76,19,18,17,16,48,46,47,53,52,12,11,78,77,11,10,78,77,8,6,7,27,26,81,80,38,36,37,18,75,11,12,82,83,5,18,56,57,85,86,49,75,38,39,80,72,94,95,95,42,43,81,82,84,47,62,63,23,63,64,5,6,42,73,74,55,56,42,62,63,54,55,28,81,61,62,95,31,32,34,35,12,6,15,16,16,53,37,38,8,68,6,7,51,52,24,86,87,18,19,78,22,2,51,52,9,65,14,15,17,33,34,10,11,49,46,47,77,78,83,42,11,12,41,11,12,37,38,57,15,67,68,34,7,72,8,37,51,9,23,92,53,86,61,92,35,64,31,27,53,17,58,50,73,73,21,60,62,25,41,1,42,80,46,20,52,34,20,41,33,6,59,40,73,10,13,86,80,90,90,31,16,1,46,81,30,2,65,93,0,76,30,83,43,89,91,12,85,27,25,56,61,20,86,19,86,16,35,89,46,17,24,8,20,37,38,95,32,7,37,38,77,10,76,68,69,95,59,3,4,92,19,19,63,6,7,8,67,83,42,43,84,26,62,94,76,62,83,75,47,48,5,82,18,19,52,55,31,32,26,36,35,36,73,58,87,88,27,72,81,44,11,39,41,42,22,72,28,29,85,35,37,54,31,68,69,67,2,6,7,62,32,60,61,32,58,76,77,35,88,88,80,0,21,65,92,57,8,78,36,23,51,25,42,95,45,6,38,39,13,14,16,45,83,84,16,17,76,6,65,66,11,3,25,26,26,69,70,12,13,13,15,74,89,90,50,90,91,32,33,69,4,5,82,83,69,89,90,81,82,55,12,88,89,26,58,59,61,62,39,33,42,43,43,80,64,65,95,33,34,78,79,51,17,18,45,46,49,29,78,79,36,92,41,42,44,60,61,37,38,76,73,74,8,9,14,69,38,39,68,38,39,64,65,84,42,94,95,91,52,85,59,60,91,34,62,63,16,26,52,16,57,49,71,72,72,20,58,59,61,24,40,0,41,78,79,19,51,32,33,19,40,31,32,5,58,39,72,9,11,12,85,79,88,89,89,30,14,15,45,80,28,29,1,64,91,92,95,75,29,82,42,87,88,35,90,11,83,84,26,24,54,55,17,60,19,85,18,85,14,15,34,88,44,45,4,61,94,69,79,4,43,72,35,61,25,66,58,81,81,29,68,70,33,49,9,50,88,28,60,42,77,28,49,41,14,67,48,66,81,18,21,94,88,2,2,39,24,54,89,38,10,73,5,8,84,38,91,51,1,3,20,93,35,33,64,69,28,94,27,94,24,43,1,54,38,52,14};
static const short Gen_shift_values_BG1_Z_104[2109]= {102,20,26,2,102,35,4,102,9,19,102,18,31,102,74,7,102,8,2,102,43,47,102,46,19,102,36,4,102,0,16,102,89,45,102,14,81,102,58,48,102,49,85,102,26,3,102,4,83,102,28,90,102,45,67,102,73,14,102,62,40,102,64,0,102,29,36,103,102,20,26,2,103,102,35,4,103,102,9,19,103,102,18,31,102,74,7,103,102,8,2,103,102,43,47,102,46,19,102,36,4,103,102,0,16,103,102,89,45,103,102,14,81,103,102,58,48,103,102,49,85,102,26,3,103,102,4,83,103,102,28,90,102,45,67,103,102,73,14,103,102,62,40,103,102,64,0,103,102,29,36,102,20,27,26,3,2,102,36,35,5,4,102,9,20,19,102,18,32,31,102,75,74,8,7,102,8,3,2,102,44,43,48,47,102,47,46,20,19,102,37,36,5,4,102,0,17,16,102,90,89,46,45,102,14,82,81,102,58,49,48,102,50,49,86,85,102,27,26,4,3,102,4,84,83,102,28,91,90,102,46,45,68,67,102,74,73,15,14,102,62,41,40,102,65,64,1,0,102,29,37,36,102,20,26,3,2,102,35,5,4,102,9,19,102,18,32,31,102,74,8,7,102,8,2,102,43,48,47,102,46,20,19,102,36,5,4,102,0,16,102,89,46,45,102,14,82,81,102,58,49,48,102,49,86,85,102,26,4,3,102,4,83,102,28,91,90,102,45,68,67,102,73,15,14,102,62,40,102,64,1,0,102,29,37,36,23,99,70,92,98,74,80,70,3,76,99,70,81,91,70,90,103,23,70,42,79,70,80,74,70,11,15,70,14,91,70,4,76,70,72,88,70,57,13,70,86,49,70,26,16,64,70,17,53,70,98,75,70,76,51,70,100,58,102,70,13,35,70,41,86,70,30,8,70,32,72,70,101,4,56,5,26,58,49,47,23,37,90,40,87,7,48,54,75,33,10,55,32,61,39,38,37,15,14,67,33,10,70,48,47,39,17,16,1,33,10,44,21,54,32,31,33,10,53,30,66,44,43,26,33,10,5,87,86,42,20,19,33,10,43,20,37,15,14,33,10,78,56,55,82,60,59,33,10,81,59,58,54,32,31,33,10,71,49,48,39,17,16,33,10,35,12,51,29,28,33,10,20,102,101,80,58,57,33,10,49,26,12,94,93,33,10,93,70,83,61,60,36,33,10,84,62,61,16,98,97,33,10,61,39,38,38,16,15,33,10,39,16,14,96,95,33,10,63,40,21,103,102,95,33,10,80,58,57,102,80,79,33,10,4,86,85,49,27,26,33,10,97,74,75,53,52,98,33,10,99,77,76,35,13,12,33,10,64,41,71,49,48,100,5,9,40,52,96,3,59,68,21,76,51,15,11,69,3,19,18,25,40,31,46,7,22,79,3,19,18,40,55,9,24,89,3,19,18,14,29,24,39,3,19,18,23,38,36,51,3,18,79,94,12,27,3,19,18,13,28,7,22,3,19,18,48,63,52,67,3,18,51,66,24,39,3,18,41,56,9,24,3,19,18,5,20,21,36,3,19,18,94,5,50,65,3,19,18,19,34,86,101,3,19,18,63,78,53,68,18,3,19,18,54,69,90,1,3,18,31,46,8,23,3,19,18,9,24,88,103,3,19,18,33,48,95,6,15,3,18,50,65,72,87,3,19,18,78,93,19,34,3,19,18,67,82,45,60,3,19,18,69,84,5,20,3,19,18,34,49,41,56,103,5,19,98,48,103,102,45,44,66,72,48,51,45,44,81,50,45,44,55,65,45,44,64,77,42,44,16,53,45,44,54,48,45,44,89,93,44,92,65,0,44,82,50,45,44,46,62,45,44,31,91,45,44,60,23,45,44,0,94,45,44,95,27,44,72,49,45,44,50,25,45,44,74,32,44,91,9,45,44,15,60,45,44,4,86,45,44,6,46,15,45,44,75,82,0,97,13,25,0,1,44,66,72,49,48,68,44,81,51,50,5,44,55,65,44,64,78,77,44,16,54,53,44,54,48,44,89,94,93,44,92,66,65,44,82,51,50,44,46,62,44,31,92,91,80,44,60,24,23,44,0,95,94,44,95,28,27,77,44,72,50,49,44,50,25,44,74,33,32,44,91,10,9,44,15,61,60,52,44,4,86,44,6,47,46,44,75,83,82,76,98,0,80,76,9,82,87,76,87,97,76,96,5,93,76,48,85,76,86,80,76,17,21,76,20,97,76,10,82,76,78,94,76,63,19,76,92,55,55,76,32,22,76,23,59,76,0,81,76,82,57,76,2,64,76,19,41,76,47,92,76,36,14,76,38,78,17,76,3,10,90,79,29,2,50,0,40,62,67,43,11,5,61,79,86,28,50,56,32,5,28,65,34,28,39,49,28,48,61,11,28,0,37,28,38,32,28,73,77,28,76,49,28,66,34,28,30,46,14,28,15,75,28,44,7,4,28,88,78,28,79,11,28,56,33,28,34,9,28,58,16,28,75,97,28,103,44,28,92,70,28,94,30,28,59,66,5,85,95,41,94,43,57,25,26,44,17,27,99,4,26,32,8,8,4,41,10,4,15,25,4,24,37,20,4,80,13,86,4,14,8,4,49,53,4,52,25,4,42,10,4,6,22,4,95,51,4,20,87,27,4,64,54,4,55,91,4,32,9,4,10,89,4,34,96,4,51,73,4,79,20,4,68,46,4,70,6,4,35,42,3,73,15,27,20,37,87,92,97,35,21,3,0,39,92,4,26,32,9,8,4,41,11,10,91,4,15,25,4,24,38,37,4,80,14,13,4,14,8,4,49,54,53,4,52,26,25,4,42,11,10,4,6,22,4,95,52,51,4,20,88,87,4,64,55,54,4,55,92,91,4,32,10,9,31,4,10,89,4,34,97,96,4,51,74,73,4,79,21,20,1,4,68,46,4,70,7,6,4,35,43,42,18,40,47,46,23,22,1,18,56,55,25,24,18,29,40,39,18,38,52,51,18,95,94,28,27,18,28,23,22,18,64,63,68,67,18,67,66,40,39,18,57,56,25,24,18,20,37,36,18,6,5,66,65,87,18,34,102,101,18,78,69,68,18,70,69,2,1,7,18,47,46,24,23,18,24,0,103,18,48,7,6,18,66,65,88,87,18,94,93,35,34,18,82,61,60,18,85,84,21,20,18,49,57,56,19,88,41,6,47,12,23,93,92,19,88,56,21,25,95,94,3,19,88,30,99,40,5,19,88,39,4,52,18,17,19,88,95,60,28,98,97,19,88,29,98,23,92,19,88,64,29,68,34,33,19,88,67,32,40,6,5,48,19,88,57,22,25,95,94,19,88,21,90,37,2,19,88,6,75,66,32,31,19,88,35,0,102,68,67,19,88,79,44,69,35,34,19,88,70,35,2,72,71,19,88,47,12,24,94,93,19,88,25,94,0,69,19,88,49,14,7,77,76,19,88,66,31,88,54,53,19,88,94,59,35,1,0,19,88,83,48,61,26,19,88,85,50,21,91,90,19,88,50,15,57,23,22,18,40,47,46,23,22,5,18,56,55,25,24,18,29,40,39,18,38,52,51,18,95,94,28,27,18,28,23,22,18,64,63,68,67,18,67,66,40,39,18,57,56,25,24,18,20,37,36,18,6,5,66,65,18,34,102,101,18,78,69,68,21,18,70,69,2,1,18,47,46,24,23,62,18,24,0,103,18,48,7,6,18,66,65,88,87,18,94,93,35,34,18,82,61,60,18,85,84,21,20,18,49,57,56,9,29,5,91,3,48,92,50,79,101,3,83,79,12,85,3,79,90,100,79,99,8,79,51,88,79,89,83,79,20,24,44,79,23,100,79,13,85,79,81,97,79,66,22,79,95,58,79,35,25,63,79,26,62,79,3,84,79,85,60,79,5,67,79,22,44,79,50,95,79,39,17,79,41,81,79,6,13,5,95,72,42,30,29,51,57,33,30,29,66,35,81,30,29,40,50,30,29,49,62,29,1,38,30,29,39,33,30,29,74,78,29,77,50,29,67,35,30,29,31,47,30,29,16,76,30,29,45,8,30,29,89,79,30,29,80,12,1,29,57,34,30,29,35,10,30,29,59,17,29,76,98,30,29,0,45,30,29,93,71,30,29,95,31,30,29,60,67,90,63,93,99,3,27,4,83,9,83,11,1,74,37,23,56,78,85,84,61,60,58,56,94,93,63,62,56,67,78,77,56,76,90,89,56,29,28,66,65,9,56,66,61,60,56,102,101,2,1,56,1,0,78,77,56,95,94,63,62,56,58,75,74,56,44,43,0,103,56,72,36,35,56,12,3,2,56,4,3,40,39,56,85,84,62,61,56,62,38,37,56,86,45,44,56,0,103,22,21,56,28,27,73,72,56,16,99,98,56,19,18,59,58,56,87,95,94,96,14,20,101,100,96,29,103,102,0,96,3,13,96,12,26,25,96,68,2,1,96,2,100,96,37,42,41,96,40,14,13,96,30,103,102,96,98,10,96,83,40,39,96,8,76,75,96,52,43,42,96,43,80,79,96,20,102,101,96,102,77,96,22,85,84,58,96,39,62,61,96,67,9,8,98,96,56,34,96,58,99,98,96,23,31,30,1,23,29,5,3,1,38,7,1,12,22,1,21,34,1,77,10,1,11,5,1,46,50,1,49,22,5,1,39,7,1,3,19,37,1,92,48,1,17,84,1,61,51,1,52,88,1,29,6,1,7,86,1,31,93,1,48,70,1,76,17,1,65,43,1,67,3,1,32,39,76,44,48};
static const short Gen_shift_values_BG1_Z_112[2109]= {110,28,94,88,15,90,17,93,44,30,90,38,52,45,63,4,73,6,67,9,73,44,44,94,29,20,40,15,111,86,64,92,69,33,103,93,42,20,92,100,102,76,34,78,101,68,13,8,76,69,5,95,81,85,73,28,4,98,85,30,110,103,89,29,80,74,45,110,111,29,95,89,15,16,91,18,93,94,45,31,90,91,39,53,46,64,5,73,74,7,68,9,10,74,45,45,95,30,21,41,16,111,0,87,65,92,93,70,34,103,104,94,43,20,21,93,101,102,103,77,35,79,102,69,13,14,9,77,69,70,6,96,82,86,74,28,29,5,99,85,86,31,111,103,104,90,30,80,81,75,46,111,29,94,95,88,89,16,90,91,17,18,94,45,30,31,91,39,52,53,46,63,64,4,5,74,7,67,68,10,73,74,44,45,45,94,95,29,30,21,40,41,15,16,0,87,64,65,93,69,70,33,34,104,94,42,43,21,93,100,101,103,76,77,34,35,79,101,102,68,69,14,9,76,77,70,6,95,96,82,85,86,73,74,29,4,5,98,99,86,31,110,111,104,89,90,29,30,81,75,45,46,111,29,95,88,89,16,91,17,18,94,45,31,91,39,52,53,46,64,4,5,74,7,68,10,74,44,45,45,95,29,30,21,41,15,16,0,87,65,93,70,33,34,104,94,42,43,21,93,100,101,103,77,34,35,79,102,68,69,14,9,77,70,6,95,96,82,86,73,74,29,5,98,99,86,31,111,104,90,29,30,81,75,45,46,57,9,39,69,23,17,51,56,19,58,58,22,85,71,19,79,93,85,86,104,45,2,47,108,50,2,85,85,23,70,61,81,56,40,15,105,21,110,74,32,22,83,61,21,29,79,31,5,75,7,30,109,54,49,5,110,46,24,69,10,14,2,69,45,27,14,71,39,32,18,70,9,3,86,17,45,6,0,20,62,50,23,3,16,75,103,99,37,45,42,88,72,6,26,71,72,20,65,66,32,59,105,22,67,68,61,106,107,94,25,71,88,22,74,7,8,22,68,82,16,96,29,30,3,89,23,107,40,41,48,93,94,5,51,50,96,111,44,45,53,99,5,50,51,88,21,22,88,22,26,71,72,73,6,7,64,110,84,17,18,59,104,105,43,89,18,64,108,41,42,24,70,1,46,47,77,10,11,35,81,25,71,86,19,20,64,110,24,70,32,77,78,104,34,80,8,53,54,78,11,12,10,56,33,78,79,0,45,46,57,103,52,98,8,53,54,1,47,49,95,27,72,73,91,13,59,17,62,63,5,50,51,72,6,48,93,94,30,75,76,17,63,74,8,42,87,88,38,35,81,21,66,67,73,6,7,12,58,6,52,89,22,23,57,8,36,100,104,88,72,108,105,81,52,61,18,81,102,82,87,88,0,6,66,72,60,66,51,99,104,105,62,68,101,107,10,65,70,71,16,22,2,8,62,67,68,10,16,24,30,17,23,35,41,88,94,45,50,51,90,96,39,45,93,98,99,45,51,16,22,16,22,66,72,1,7,104,110,12,18,99,105,83,88,89,58,64,36,42,64,69,70,41,47,5,11,75,80,81,65,71,14,20,104,109,110,64,70,72,78,1,74,79,80,48,54,6,12,50,56,73,79,40,46,97,102,103,92,98,48,54,41,46,47,89,95,67,73,34,53,59,57,63,45,51,0,5,6,88,94,70,76,57,62,63,2,8,82,88,75,80,81,61,67,1,7,52,57,58,46,52,17,23,31,29,62,23,2,27,69,76,77,107,61,55,80,93,94,57,96,59,60,11,109,56,57,5,19,55,12,30,83,39,40,85,34,87,88,40,11,11,61,108,71,99,7,94,77,78,53,31,58,59,36,0,69,70,60,9,98,99,59,67,68,69,43,1,45,68,35,91,92,87,43,35,36,84,62,48,52,40,106,107,83,65,51,52,109,77,69,70,56,108,104,46,47,41,12,13,62,98,78,50,42,80,110,64,57,58,89,97,60,98,99,7,63,14,0,60,8,21,22,15,33,85,86,43,88,37,91,43,13,14,14,64,110,111,102,10,96,97,81,56,34,62,39,2,3,18,73,63,11,12,102,62,69,70,72,46,3,4,96,48,71,37,38,95,90,46,39,87,64,65,51,55,42,43,110,86,67,68,96,55,0,80,73,59,110,111,50,44,14,15,99,17,83,77,4,79,6,41,82,33,19,79,27,41,51,34,52,105,62,107,56,110,62,33,33,83,18,9,29,4,100,75,53,81,58,22,92,82,31,42,9,81,89,91,65,23,67,90,57,2,109,65,58,106,84,70,74,62,17,105,87,74,19,99,92,78,18,76,69,63,34,55,109,87,62,3,86,109,87,30,73,7,5,102,85,7,69,99,53,47,104,86,49,88,52,3,101,49,109,11,97,4,22,75,32,77,26,80,32,3,3,53,100,91,111,86,70,45,23,8,51,28,104,62,52,1,101,91,51,59,61,35,105,37,60,27,84,79,35,28,76,54,40,44,32,99,75,57,44,101,69,62,48,100,39,33,4,79,18,107,49,105,52,111,2,35,87,90,55,9,10,40,106,100,48,27,102,29,105,56,42,102,50,64,44,57,75,16,63,85,18,79,21,85,56,56,106,41,32,52,27,11,98,76,104,81,45,3,105,54,80,32,104,0,2,88,46,90,1,80,25,20,88,81,17,107,93,97,85,40,16,110,97,42,10,3,101,41,92,86,57,0,53,64,80,106,63,99,14,95,28,61,33,40,104,1,67,97,51,44,45,84,47,85,86,37,50,1,99,47,107,8,9,2,20,72,73,30,75,24,78,30,0,1,1,51,97,98,89,109,83,84,68,43,21,49,26,101,102,60,50,110,111,89,49,56,57,59,33,102,103,35,58,24,25,10,82,77,33,26,74,51,52,38,42,29,30,97,73,54,55,52,42,99,67,60,46,97,98,37,31,1,2,10,40,105,106,99,100,33,27,101,102,28,29,105,56,41,42,102,50,63,64,57,74,75,15,16,85,18,78,79,21,84,85,55,56,56,105,106,40,41,32,51,52,26,27,11,98,75,76,104,80,81,44,45,17,3,105,53,54,32,104,111,0,2,87,88,45,46,97,90,0,1,79,80,25,20,87,88,81,17,106,107,93,96,97,84,85,40,15,16,109,110,97,42,9,10,3,100,101,40,41,92,86,56,57,63,15,93,45,47,111,41,104,105,80,32,43,107,82,33,34,62,46,110,109,61,95,47,43,107,103,55,5,68,69,110,62,16,80,69,20,21,26,90,71,23,20,84,74,26,26,90,109,60,61,109,61,47,111,94,45,46,48,85,37,105,57,80,31,32,64,16,39,103,17,81,45,109,22,86,98,49,50,56,8,46,110,107,58,59,85,37,45,109,53,4,5,55,7,29,93,99,50,51,31,95,54,6,21,84,85,78,30,73,25,29,93,22,86,70,22,48,111,0,34,98,38,102,26,89,90,93,45,69,21,51,2,3,38,102,95,47,63,15,56,8,42,106,94,45,46,33,97,27,91,110,61,62,29,59,12,13,6,7,79,46,8,9,47,48,12,75,60,61,9,69,82,83,76,93,94,34,35,104,37,97,98,40,103,104,74,75,75,12,13,59,60,51,70,71,45,46,30,5,94,95,11,99,100,63,64,22,12,72,73,51,11,18,19,96,21,106,107,64,65,109,19,20,98,99,57,44,39,106,107,100,36,13,14,0,3,4,103,104,59,34,35,16,17,4,61,28,29,22,7,8,59,60,111,105,75,76,1,48,48,24,81,73,67,37,73,103,57,51,90,53,92,79,56,7,105,53,1,15,8,26,79,36,81,30,84,36,7,60,7,57,104,95,3,90,74,49,27,55,32,108,66,56,5,95,55,63,25,65,39,109,41,64,31,88,83,39,32,80,58,44,48,36,103,79,61,48,105,73,66,52,104,43,37,8,109,44,111,5,24,25,55,9,3,41,42,5,44,80,7,8,71,57,4,5,65,79,72,90,31,99,100,33,94,35,36,100,71,71,9,56,47,67,42,25,26,1,91,6,7,96,60,17,18,8,69,46,47,7,15,16,17,103,61,82,105,16,95,39,40,35,103,95,96,32,10,108,0,100,54,55,31,13,111,0,57,25,17,18,4,56,106,107,101,72,10,89,72,9,11,76,48,1,66,44,95,22,102,59,54,77,107,60,61,54,55,1,94,56,57,95,96,60,11,108,109,57,5,18,19,12,29,30,82,83,90,40,85,33,34,88,39,40,10,11,11,60,61,107,108,99,6,7,93,94,78,53,30,31,59,35,36,111,0,70,60,8,9,99,59,66,67,69,42,43,0,1,45,67,68,34,35,92,87,42,43,36,84,61,62,48,51,52,39,40,107,82,83,64,65,52,109,76,77,70,55,56,107,108,47,41,11,12,48,78,32,25,26,65,28,66,67,93,31,94,80,28,88,101,102,95,1,53,54,11,56,5,59,11,93,94,94,32,78,79,70,90,64,65,49,24,2,30,7,82,83,41,31,91,92,70,30,37,38,40,14,83,84,16,39,5,6,63,58,14,7,55,32,33,21,19,23,10,11,78,54,35,36,21,23,80,48,41,27,78,79,18,12,94,95,10,40,106,100,83,27,102,29,105,56,42,102,50,64,57,75,16,85,18,79,21,85,56,56,106,41,3,32,52,27,11,98,76,8,104,81,45,3,105,54,32,104,0,2,88,46,90,1,80,25,20,88,81,17,107,93,97,85,40,16,110,97,42,10,3,101,41,92,86,57,71,8,28};
static const short Gen_shift_values_BG1_Z_120[2109]= {14,95,68,7,106,3,22,5,115,104,13,15,41,100,30,99,83,7,115,82,116,42,91,58,65,51,91,95,52,55,23,104,67,0,84,10,95,7,68,21,74,5,23,94,100,46,14,84,32,96,32,79,86,95,31,99,4,114,89,42,66,104,109,51,16,95,98,14,15,96,69,8,106,107,4,23,5,6,116,105,13,14,16,42,101,31,100,83,84,8,116,82,83,117,43,92,59,66,52,92,96,52,53,56,24,104,105,68,1,84,85,11,96,7,8,69,22,74,75,6,24,95,101,47,14,15,85,33,96,97,33,80,87,96,32,99,100,5,115,89,90,43,67,104,105,110,52,16,17,96,99,15,96,68,69,7,8,107,3,4,22,23,6,116,104,105,14,16,41,42,101,30,31,99,100,84,8,115,116,83,116,117,42,43,92,58,59,65,66,52,91,92,95,96,53,56,23,24,105,67,68,0,1,85,11,95,96,8,69,21,22,75,5,6,23,24,95,100,101,46,47,15,85,32,33,97,33,79,80,87,95,96,31,32,100,4,5,114,115,90,43,66,67,105,109,110,51,52,17,96,98,99,15,96,69,7,8,107,4,22,23,6,116,105,14,16,41,42,101,31,99,100,84,8,116,83,117,42,43,92,59,65,66,52,92,95,96,53,56,24,105,68,0,1,85,11,95,96,8,69,21,22,75,6,23,24,95,101,46,47,15,85,33,97,33,79,80,87,96,31,32,100,5,114,115,90,43,67,105,110,51,52,17,96,98,99,63,90,74,35,8,67,1,46,63,82,50,65,55,44,73,75,101,46,40,90,39,23,67,55,22,56,102,31,118,5,111,31,35,112,115,83,44,7,60,24,70,35,67,8,81,22,14,65,83,34,40,106,74,24,92,36,92,19,89,26,35,91,39,64,54,29,102,6,44,49,111,76,35,38,59,78,21,22,99,91,86,51,12,76,25,88,31,45,17,47,53,8,14,101,106,107,40,45,46,60,19,25,36,41,42,55,60,61,104,38,44,28,34,17,22,23,46,52,48,54,74,79,80,20,13,19,63,68,69,12,17,18,116,2,40,46,28,33,34,115,1,29,34,35,75,80,81,4,10,91,96,97,98,103,104,84,90,4,9,10,8,13,14,85,91,88,94,56,61,62,17,23,100,105,106,33,38,39,117,3,43,49,8,13,14,40,46,101,107,54,59,60,102,107,113,38,43,44,56,61,62,7,13,13,18,19,79,84,85,47,53,117,3,65,70,71,9,15,65,71,112,117,118,56,119,5,8,13,14,64,69,70,12,18,37,42,43,27,32,33,2,8,75,81,99,104,105,24,17,23,22,27,28,84,89,90,49,55,8,14,11,16,17,78,48,11,85,100,16,91,91,84,115,30,69,109,114,83,59,1,2,20,83,113,56,52,115,44,31,93,94,48,111,67,10,114,50,112,113,40,103,29,92,58,0,1,60,3,86,29,25,88,75,18,24,87,8,70,71,52,115,40,103,7,69,70,41,104,87,30,16,79,103,46,110,53,96,39,16,79,20,83,97,39,40,100,43,68,11,29,91,92,112,55,45,108,9,71,72,55,118,20,83,52,114,115,113,56,66,9,13,119,61,62,50,113,68,11,19,82,25,88,91,34,59,1,2,9,72,77,20,21,83,84,77,20,4,67,0,11,74,20,83,76,19,24,86,87,49,112,39,102,14,76,77,87,30,111,54,29,91,92,34,97,96,39,61,3,4,20,83,23,86,31,65,94,3,59,97,79,44,45,6,99,38,99,16,17,34,53,35,36,26,15,43,44,46,72,64,11,61,10,113,114,38,26,112,113,27,73,2,89,96,33,82,2,6,82,83,86,54,14,15,98,31,114,115,41,6,37,38,99,52,104,105,36,54,5,11,77,44,45,115,63,6,7,63,110,117,6,62,9,10,35,25,119,0,73,97,14,15,20,82,57,46,47,6,9,3,23,61,94,71,75,64,25,118,56,57,38,36,53,71,72,17,55,45,34,63,65,90,91,30,80,28,29,13,57,45,12,46,91,92,21,108,114,115,101,21,24,25,102,105,73,34,117,49,50,99,14,60,24,25,57,118,70,71,4,55,72,73,52,24,30,95,96,64,14,82,26,82,8,9,16,25,80,81,29,54,43,44,21,19,92,116,34,39,100,101,66,25,27,28,99,60,33,92,71,88,107,77,90,80,69,98,100,6,31,65,115,64,48,92,80,47,81,7,56,23,30,16,56,60,17,20,108,69,32,85,49,95,60,83,92,33,106,39,90,108,59,65,11,99,49,117,61,117,44,51,60,116,64,89,79,54,7,31,69,74,16,4,101,60,63,62,111,105,98,8,62,94,59,22,13,58,107,38,17,75,24,105,78,17,76,116,13,32,15,5,114,23,25,51,66,110,40,109,93,17,5,92,6,52,101,68,75,61,101,105,62,65,33,82,114,77,10,94,20,105,46,17,78,31,84,15,33,104,110,56,24,94,42,106,42,89,96,105,41,109,14,4,99,52,76,114,119,61,26,105,108,76,1,94,64,95,24,46,5,57,64,6,116,78,72,33,6,65,31,44,61,80,63,53,42,71,73,99,57,38,88,37,1,21,65,53,20,54,100,29,116,3,109,29,33,110,113,81,42,5,58,22,68,33,35,65,6,79,12,63,81,32,38,104,72,22,90,34,90,17,24,33,89,37,62,52,27,100,4,42,47,109,74,33,36,26,20,10,60,42,10,48,97,44,111,8,31,42,79,84,118,79,52,110,111,90,107,5,6,111,109,99,88,117,119,24,25,84,14,82,83,67,111,99,66,100,25,26,75,42,48,49,35,75,78,79,36,39,7,88,51,103,104,68,114,78,79,111,52,4,5,58,109,6,7,78,84,29,30,31,118,68,16,80,16,62,63,70,79,14,15,83,108,97,98,117,73,26,50,88,93,34,35,0,79,81,82,0,81,53,54,112,113,49,92,108,109,7,8,111,101,89,90,119,1,26,27,86,15,16,84,85,69,113,100,101,68,101,102,27,28,77,43,44,50,51,37,76,77,80,81,38,41,8,9,90,52,53,105,106,78,70,116,80,81,113,54,6,7,60,110,111,8,9,25,80,85,86,31,32,0,70,17,18,82,18,64,65,72,80,81,16,17,85,109,110,99,100,75,28,51,52,90,94,95,36,37,2,81,83,84,69,3,30,84,3,57,62,115,116,41,95,58,112,77,10,11,72,60,114,50,104,39,93,68,2,70,4,96,29,30,35,89,85,19,34,87,88,18,72,62,116,50,104,17,71,51,105,97,30,31,26,80,113,47,0,53,54,28,106,40,26,80,30,83,84,107,41,110,44,78,12,39,93,2,56,55,108,109,19,73,65,119,30,83,84,62,116,3,57,76,9,10,9,63,60,114,78,11,12,29,83,35,89,101,34,35,69,3,19,73,87,21,31,85,87,21,14,67,68,21,75,30,84,86,19,20,34,88,59,113,49,102,103,24,78,97,31,1,55,39,93,44,98,106,39,40,71,5,30,84,33,86,87,106,67,39,40,98,99,102,78,94,95,113,114,97,87,75,76,105,107,12,13,72,1,2,70,71,55,99,86,87,54,87,88,13,14,63,29,30,36,37,23,62,63,66,67,24,27,114,115,76,38,39,91,92,56,102,66,67,99,40,112,113,109,46,96,97,114,115,66,71,72,17,18,30,106,56,3,4,68,4,50,51,58,66,67,2,3,71,95,96,85,86,61,14,37,38,76,80,81,22,23,108,67,69,70,78,11,51,64,40,116,21,59,114,75,48,107,86,103,2,110,105,95,84,113,115,21,80,10,79,63,107,95,62,96,22,53,71,38,45,31,71,75,32,35,3,84,47,100,64,110,75,107,48,1,24,54,105,3,74,80,26,114,64,12,76,12,59,66,75,11,79,104,94,69,22,46,84,89,31,116,75,78,10,86,41,99,55,56,17,110,49,27,28,45,64,58,46,47,37,26,54,55,57,83,22,72,21,4,5,49,37,3,4,38,84,13,100,107,93,13,17,93,94,97,65,25,26,109,42,5,6,52,17,48,49,110,63,115,116,47,65,83,16,22,88,55,56,6,74,17,18,74,1,8,17,73,20,21,46,36,10,11,84,108,25,26,31,93,57,58,17,20,0,89,25,19,114,67,47,51,3,102,29,52,68,94,23,86,47,19,20,78,79,101,58,74,75,93,94,77,67,55,56,85,87,112,113,52,101,102,50,51,49,35,79,66,67,34,67,68,113,114,43,9,10,16,17,3,42,43,46,47,4,7,94,95,56,18,19,71,72,36,82,46,47,79,20,92,93,26,76,77,94,95,46,51,52,117,118,86,36,103,104,48,104,30,31,38,46,47,102,103,51,75,76,65,66,41,114,17,18,56,60,61,2,3,88,47,49,50,20,101,74,12,13,112,9,27,28,21,11,1,110,19,21,46,47,106,36,104,105,89,13,1,88,2,47,48,97,64,70,71,57,97,100,101,58,61,29,110,73,5,6,90,16,100,101,13,74,26,27,80,11,28,29,100,106,51,52,20,90,38,102,38,84,85,6,92,101,36,37,105,10,119,0,48,95,48,72,110,115,56,57,22,101,103,104,42,3,96,35,70,14,31,50,33,23,12,41,43,69,8,58,7,111,35,23,110,24,70,119,86,93,90,79,119,3,80,83,51,66,12,95,28,112,38,3,35,96,49,102,33,51,2,8,74,42,112,60,4,60,107,114,3,59,7,32,22,117,70,94,12,17,79,44,3,6,56,113,92};
static const short Gen_shift_values_BG1_Z_128[2109]= {121,1,105,120,68,110,88,97,110,56,30,116,83,123,62,19,99,70,116,9,92,21,93,100,2,103,48,114,58,44,94,100,38,7,109,91,85,62,101,117,8,13,90,108,96,82,66,3,96,22,13,111,26,116,75,61,76,115,34,126,122,110,116,15,30,27,11,121,122,2,106,121,68,69,111,89,97,98,111,57,30,31,117,84,124,63,20,99,100,71,117,9,10,93,22,94,101,3,104,49,115,58,59,45,95,100,101,39,8,109,110,92,86,62,63,102,118,8,9,14,91,109,97,83,66,67,4,97,22,23,14,112,27,117,76,61,62,77,116,34,35,127,123,110,111,117,16,30,31,28,12,122,2,105,106,120,121,69,110,111,88,89,98,111,56,57,31,117,83,84,124,62,63,19,20,100,71,116,117,10,92,93,21,22,94,100,101,2,3,104,48,49,114,115,59,45,94,95,101,38,39,7,8,110,92,85,86,63,102,117,118,9,13,14,90,91,109,96,97,82,83,67,4,96,97,23,14,111,112,27,116,117,75,76,62,76,77,115,116,35,127,122,123,111,116,117,15,16,31,28,11,12,122,2,106,120,121,69,111,88,89,98,111,57,31,117,83,84,124,63,19,20,100,71,117,10,93,21,22,94,101,2,3,104,49,114,115,59,45,95,101,39,7,8,110,92,85,86,63,102,117,118,9,14,90,91,109,97,82,83,67,4,97,23,14,111,112,27,117,75,76,62,77,115,116,35,127,123,111,117,15,16,31,28,11,12,28,101,108,116,92,107,76,55,97,75,107,84,97,43,17,103,70,65,110,49,6,86,57,103,124,79,8,80,87,117,90,35,101,45,31,81,87,25,122,96,78,72,49,88,104,102,123,0,77,95,83,69,53,118,83,9,0,98,27,13,103,62,48,63,102,21,113,109,97,103,2,17,14,126,122,54,21,27,66,115,10,28,82,91,43,30,30,38,103,106,84,114,92,90,67,68,105,82,83,111,53,31,95,72,73,73,50,51,3,82,60,95,73,41,18,19,15,121,101,79,68,45,46,6,108,86,47,24,25,4,109,110,84,62,55,33,101,78,79,122,100,77,54,55,6,111,112,78,56,85,62,63,115,92,93,88,66,33,10,11,99,76,77,43,21,29,7,79,56,57,85,63,23,0,1,120,97,98,94,72,76,54,70,47,48,47,25,86,64,102,79,80,82,121,99,126,103,104,75,52,53,93,71,81,58,59,67,44,45,51,29,116,94,81,58,59,7,113,126,104,96,73,74,101,11,117,101,78,79,60,37,38,46,24,61,38,39,100,77,78,19,125,111,89,107,84,85,35,95,73,101,78,79,0,105,106,15,121,12,118,124,101,102,108,102,53,108,20,13,13,60,87,97,20,38,31,48,57,117,15,16,125,24,101,0,116,15,76,64,90,91,106,5,84,111,40,93,119,120,106,5,52,79,26,52,53,112,11,79,106,119,18,58,85,15,42,95,121,122,66,93,112,11,5,31,32,88,115,17,44,89,116,96,123,126,25,99,126,44,71,110,9,54,80,81,40,67,90,117,96,122,123,34,61,3,30,105,3,4,87,114,81,108,58,84,85,97,124,113,12,82,4,30,31,9,36,86,113,104,3,92,119,78,105,62,88,89,127,26,92,119,18,44,45,9,36,107,6,53,22,49,112,11,71,98,57,83,84,72,99,111,10,30,56,57,122,21,118,17,106,4,5,112,11,11,38,26,52,53,23,50,7,34,77,31,41,20,31,105,6,55,56,64,40,55,48,2,3,45,23,31,32,45,119,92,93,51,18,119,58,125,82,33,34,5,51,71,72,27,84,28,35,65,22,38,111,49,120,121,107,29,34,35,101,70,43,44,26,20,124,125,36,52,70,71,76,25,43,31,17,0,1,66,31,84,85,76,46,89,51,10,123,124,11,50,96,97,61,57,44,45,51,78,56,92,93,90,74,77,54,77,126,15,100,45,53,29,43,44,39,120,34,11,12,95,21,34,108,82,40,6,7,47,114,70,71,23,122,40,61,16,72,73,17,24,53,54,27,100,37,38,110,96,18,24,90,58,59,64,33,15,8,9,114,25,40,41,60,65,13,14,62,32,20,5,6,118,55,20,74,65,34,35,78,40,126,127,113,0,38,39,74,86,50,46,34,40,66,67,82,79,62,63,19,27,3,18,94,8,114,63,123,8,82,56,14,109,48,21,88,45,125,96,14,35,118,47,119,126,28,1,74,12,84,70,120,126,64,33,7,117,111,48,88,127,15,34,39,116,6,122,108,92,29,122,48,39,9,52,14,101,87,102,13,60,24,20,8,14,41,50,56,53,37,6,35,58,0,15,41,104,7,26,18,59,72,71,126,95,25,33,9,24,22,100,14,120,1,14,88,62,20,115,57,27,94,51,3,102,20,41,124,53,125,4,34,7,80,18,90,76,126,88,4,70,39,13,123,117,46,94,5,21,40,45,122,12,0,114,98,35,0,54,45,15,58,20,107,93,108,19,66,30,26,14,20,47,62,59,43,120,120,108,2,42,63,13,59,29,27,18,41,23,87,95,71,86,111,34,76,54,63,76,22,124,82,49,85,89,28,113,107,65,36,82,103,58,115,59,66,96,69,14,80,24,10,60,66,4,101,75,57,51,115,28,67,83,102,107,56,74,62,48,32,97,62,116,107,77,120,82,41,27,42,81,0,92,88,76,82,109,124,121,105,22,7,115,53,66,114,86,60,24,103,65,127,36,52,62,0,8,112,126,127,75,117,94,95,85,104,117,63,37,123,89,90,2,69,25,26,106,77,123,16,99,27,28,100,107,8,9,110,55,120,121,65,51,101,107,45,13,14,116,98,91,92,69,108,123,124,15,20,96,97,115,103,88,89,107,73,10,103,29,20,117,118,33,123,81,82,68,83,121,122,83,41,5,1,117,123,21,22,37,34,17,18,3,11,114,115,1,2,87,78,119,120,97,98,107,120,65,66,40,126,92,93,5,71,72,28,29,109,80,125,126,19,101,102,30,31,103,109,110,11,12,113,57,58,123,124,68,54,103,104,110,47,48,16,17,72,119,101,94,95,72,111,126,127,18,22,23,99,100,119,118,105,106,91,92,76,13,105,106,32,23,120,121,36,125,126,84,85,71,85,86,124,125,44,8,3,4,120,125,126,24,25,40,37,20,21,37,55,45,63,21,39,36,53,54,112,2,26,44,4,21,22,94,13,31,26,44,100,118,74,92,32,50,127,16,17,39,57,106,124,63,80,81,15,33,114,4,32,50,53,71,8,26,65,82,83,9,27,16,34,46,63,64,48,19,37,92,110,30,47,48,102,120,88,106,10,28,16,34,82,100,51,68,69,25,43,7,25,1,18,19,106,124,17,35,33,50,51,52,70,57,75,6,23,24,24,42,12,30,126,15,16,110,0,47,65,12,30,66,84,57,75,27,44,45,70,88,32,50,119,8,9,105,123,120,10,31,48,49,78,96,42,60,38,56,26,44,32,50,59,76,77,74,92,71,89,55,72,73,115,123,98,99,113,114,92,62,103,104,81,82,91,104,49,50,24,110,76,77,117,55,56,12,13,93,64,109,110,3,85,86,14,15,87,93,94,123,124,97,41,42,107,108,52,38,87,88,94,31,32,0,1,103,85,78,79,56,95,110,111,111,2,6,7,83,84,102,89,90,75,76,70,60,125,89,90,16,7,104,105,20,109,110,68,69,55,69,70,108,109,28,120,115,116,104,109,110,8,9,24,21,4,5,1,58,40,82,126,38,35,30,96,104,80,95,43,85,63,32,72,85,31,5,91,58,98,37,122,74,45,91,112,67,124,68,68,75,105,78,23,89,33,19,69,75,13,110,84,66,60,37,76,92,78,111,116,65,83,71,57,41,106,71,125,116,86,1,91,50,36,51,90,9,101,97,85,91,118,5,2,114,36,104,50,119,115,116,124,100,115,62,63,105,83,69,91,92,105,51,24,25,111,78,118,57,14,93,94,65,111,3,4,87,16,88,95,125,98,43,109,52,53,39,89,94,95,33,2,103,104,86,80,56,57,96,112,2,3,8,85,91,103,91,77,60,61,126,91,16,17,8,106,21,111,70,55,56,71,110,28,29,121,117,104,105,111,10,24,25,22,6,38,22,28,34,44,10,20,127,28,8,20,38,44,10,22,3,11,114,115,1,2,20,78,119,120,97,98,107,120,65,66,40,126,92,93,5,71,72,28,29,28,109,80,125,126,19,101,102,30,31,103,109,110,11,12,113,57,58,123,124,68,54,103,104,110,47,48,16,17,119,101,94,95,72,111,126,127,18,22,23,99,100,118,105,106,91,92,76,13,105,106,32,23,120,121,36,125,126,84,85,71,85,86,124,125,44,8,3,4,120,125,126,24,25,40,37,20,21,5,13,117,3,4,80,122,99,100,22,109,122,68,42,0,94,95,7,74,30,31,111,82,0,21,104,32,33,105,112,13,14,115,60,125,126,70,56,106,112,50,18,19,121,103,96,97,74,113,0,1,20,25,101,102,120,108,93,94,78,15,108,34,25,122,123,34,38,0,86,87,73,88,126,127,44,46,10,6,122,0,26,27,42,39,22,23,38,46,22,37,10,113,27,5,14,27,101,75,33,0,40,107,64,16,115,33,54,9,66,10,17,47,28,20,93,31,103,89,11,34,17,83,52,26,8,2,107,18,34,53,58,7,25,13,127,111,48,13,67,58,28,71,33,120,106,121,32,79,43,39,27,33,60,75,72,56,20,22,38};
static const short Gen_shift_values_BG1_Z_144[2109]= {66,34,113,42,53,22,0,43,17,75,41,78,21,111,132,107,74,15,98,3,57,81,75,73,131,57,62,52,28,116,143,143,2,40,115,108,17,71,14,56,114,73,35,71,84,114,88,7,143,143,13,97,2,71,20,94,124,143,71,11,55,72,89,112,116,118,107,66,67,35,114,43,53,54,23,1,43,44,18,76,41,42,79,22,112,133,108,74,75,16,99,3,4,58,82,76,74,132,58,63,53,28,29,117,0,143,0,3,41,115,116,109,18,71,72,15,57,114,115,74,36,72,85,115,88,89,8,0,143,0,14,98,3,72,21,94,95,125,0,71,72,12,56,72,73,90,113,116,117,119,108,67,35,113,114,42,43,54,22,23,0,1,44,18,75,76,42,79,21,22,112,132,133,107,108,75,16,98,99,4,57,58,81,82,76,73,74,131,132,58,62,63,52,53,29,117,143,0,0,2,3,40,41,116,109,17,18,72,15,56,57,115,73,74,35,36,72,84,85,114,115,89,8,143,0,0,14,97,98,3,71,72,20,21,95,124,125,143,0,72,12,55,56,73,89,90,112,113,117,119,107,108,67,35,114,42,43,54,23,0,1,44,18,76,42,79,21,22,112,133,107,108,75,16,99,4,58,81,82,76,74,131,132,58,63,52,53,29,117,0,0,3,40,41,116,109,17,18,72,15,56,57,115,74,35,36,72,85,114,115,89,8,0,0,14,97,98,3,72,20,21,95,125,143,0,72,12,56,73,90,112,113,117,119,107,108,101,90,66,34,113,42,116,53,22,0,36,43,17,75,41,78,21,71,111,132,107,74,15,98,3,57,81,75,73,131,57,62,52,28,116,143,143,2,40,115,108,17,71,14,56,138,114,73,35,71,84,114,88,7,143,143,13,97,109,2,71,20,94,124,143,71,11,55,72,89,112,116,118,107,78,79,143,24,89,58,32,6,107,24,44,9,39,103,19,8,121,120,89,55,23,24,128,96,97,53,139,108,108,76,77,86,54,55,143,129,98,103,72,17,129,130,127,96,20,133,107,75,76,107,53,22,74,42,43,49,17,18,16,129,101,70,40,8,9,89,58,143,111,112,23,135,136,17,130,15,127,128,73,41,42,143,112,4,116,117,138,106,107,114,83,58,27,85,53,54,85,54,88,56,57,126,94,95,57,26,50,19,103,71,72,13,126,100,69,142,110,111,40,56,25,15,127,128,121,89,90,13,126,26,138,139,56,24,25,30,143,93,62,85,53,54,85,54,99,68,39,7,8,97,88,57,13,125,126,106,74,75,36,5,66,34,35,85,53,54,13,126,97,66,141,109,110,45,14,127,31,143,0,54,22,23,58,27,60,29,49,17,18,14,17,14,92,133,44,131,75,64,33,0,27,122,89,56,105,92,93,73,61,8,140,81,69,54,92,79,80,61,49,39,27,22,82,69,70,56,44,114,102,80,67,68,117,105,60,48,6,138,27,15,2,134,113,100,101,54,42,137,125,42,29,30,96,84,120,108,114,102,112,100,26,14,96,84,101,89,91,79,67,54,55,11,143,38,26,38,25,26,41,29,79,67,10,141,142,3,135,56,44,110,97,98,53,41,95,83,129,9,140,141,112,100,74,62,110,98,123,111,9,141,127,114,115,46,34,38,26,38,25,26,52,40,136,124,36,41,29,110,98,59,47,133,120,121,19,7,38,26,110,97,98,50,38,94,82,111,98,99,128,116,7,139,11,142,143,13,1,2,134,128,80,17,99,6,93,98,102,103,71,6,79,86,89,90,59,37,79,80,54,112,77,78,115,58,143,4,25,0,110,111,52,135,39,40,94,118,112,110,24,71,94,99,89,64,65,9,36,35,36,39,77,7,8,1,54,107,108,51,93,6,7,110,72,108,121,7,124,125,44,36,35,36,50,134,39,108,57,130,131,17,36,107,108,48,92,108,109,126,5,46,8,9,11,0,143,41,108,15,143,78,131,99,34,106,107,25,118,87,64,65,143,108,82,140,106,143,85,86,32,53,27,28,139,80,19,68,122,1,2,140,138,51,52,122,127,116,117,93,37,64,64,67,104,105,38,36,29,81,82,136,79,120,121,35,138,99,100,107,136,5,34,35,9,72,64,64,78,17,18,67,136,84,85,15,45,63,64,67,136,76,120,137,10,32,33,37,39,27,28,66,34,113,42,53,22,0,125,43,17,75,41,78,21,12,111,132,107,74,15,98,3,57,81,75,73,131,57,62,52,28,116,143,143,2,40,115,108,17,98,71,14,56,114,73,35,71,84,114,88,7,143,143,13,97,2,71,20,94,124,143,71,11,55,72,89,112,53,116,118,107,8,136,143,143,17,16,6,143,96,143,143,143,117,143,143,6,118,53,126,120,137,106,84,127,101,15,125,18,105,80,51,72,47,14,99,38,87,141,21,15,13,71,141,2,136,112,56,83,89,83,86,124,55,48,101,143,11,98,140,54,13,119,11,24,54,28,91,83,83,97,37,86,11,104,34,64,83,11,95,139,12,29,52,56,58,47,63,45,121,8,17,71,44,71,112,35,143,143,20,66,34,113,42,91,53,22,0,43,17,75,41,78,21,54,111,132,107,143,74,15,98,3,57,81,75,73,131,57,62,52,28,116,143,143,2,40,115,108,17,121,71,14,56,114,73,35,71,84,114,88,7,143,143,13,97,2,71,20,94,124,143,71,11,55,72,89,112,116,118,107,60,143,143,38,143,143,143,132,44,35,71,130,143,10,61,109,77,12,84,85,96,65,42,43,143,86,60,118,84,121,63,64,10,31,5,6,117,58,141,46,100,123,124,118,116,29,30,100,105,94,95,71,15,42,42,45,82,83,14,7,59,60,114,57,98,99,13,116,77,78,114,127,12,13,35,131,50,42,42,56,139,140,45,114,62,63,137,23,41,42,143,114,54,98,115,132,10,11,15,17,5,6,96,64,142,143,71,72,143,83,51,52,29,30,73,47,104,105,71,108,50,51,141,17,18,136,137,104,45,127,128,33,86,87,110,111,105,102,103,16,17,87,91,92,81,82,58,2,28,29,29,31,32,69,70,89,1,138,46,47,101,44,85,86,0,102,103,64,65,107,101,113,114,143,0,118,37,28,29,29,43,126,127,32,100,101,49,50,124,9,10,28,29,101,41,84,85,102,118,119,141,142,2,4,136,137,88,86,56,54,135,133,64,61,62,75,73,44,42,22,19,20,143,65,63,39,37,97,95,63,61,100,98,43,40,41,133,131,10,8,129,126,127,96,94,37,35,120,118,25,23,79,77,103,100,101,97,95,95,93,9,6,7,143,79,77,84,82,74,71,72,50,48,138,136,21,19,21,19,24,22,62,59,60,137,135,130,128,39,36,37,93,91,36,34,78,75,76,136,134,95,93,57,54,55,93,91,106,104,136,133,134,110,108,29,27,21,19,21,19,35,33,119,116,117,24,22,93,91,42,39,40,116,114,2,0,21,18,19,93,91,33,31,77,75,94,92,111,109,134,131,132,138,136,140,138,129,126,127,85,53,131,132,60,61,143,72,40,41,18,19,62,36,93,94,60,97,39,40,130,6,7,125,126,93,34,116,117,22,75,76,99,100,94,91,92,5,6,76,80,81,70,71,47,135,17,18,18,20,21,58,59,134,127,35,36,90,33,74,75,66,133,91,92,53,54,90,102,103,132,133,35,107,26,17,18,18,32,115,116,21,89,90,38,39,113,142,143,17,18,90,30,73,74,91,107,108,130,131,135,137,125,126,143,143,75,17,52,143,107,143,127,95,30,103,114,83,61,54,104,78,136,102,139,82,28,49,24,135,76,15,64,118,142,133,136,134,48,118,123,113,89,33,60,60,63,101,32,25,78,132,75,117,143,31,134,96,132,1,31,5,68,60,60,74,14,63,132,81,11,41,60,132,72,116,133,6,29,33,35,24,71,15,143,143,66,67,35,114,43,53,54,23,1,71,43,44,18,76,41,42,79,22,112,133,108,74,75,16,99,3,4,58,82,76,74,132,58,63,53,28,29,117,0,143,0,3,41,115,116,109,18,71,72,15,57,114,115,74,36,143,72,85,115,88,89,8,0,143,0,14,98,3,72,21,94,95,125,0,71,72,12,56,72,73,90,113,116,117,119,108,45,143,143,143,8,143,20,116,71,143,1,143,143,143,38,102,70,4,5,77,78,26,89,57,58,35,36,79,53,110,111,77,114,56,57,3,23,24,142,143,143,110,51,133,134,39,92,93,116,117,111,108,109,22,23,93,97,98,87,88,64,8,34,35,35,37,38,75,76,7,0,52,53,107,50,91,92,6,108,109,70,71,107,119,120,5,6,124,43,34,35,35,49,132,133,38,106,107,55,56,130,15,16,34,35,107,47,90,91,108,124,125,3,4,8,10,142,143,49,17,96,24,25,36,5,126,127,51,26,0,58,24,61,3,4,94,115,89,90,57,142,81,130,40,63,64,58,56,113,114,40,45,34,35,11,99,126,126,129,22,23,98,91,143,0,54,141,38,39,97,56,17,18,54,67,96,97,71,134,126,126,140,79,80,98,129,54,2,3,77,107,125,126,143,54,138,38,55,72,94,95,99,101,89,90,123,91,26,99,17,110,79,57,100,74,132,98,135,78,24,45,20,131,72,11,60,114,138,132,130,44,143,114,119,109,85,29,56,143,56,59,97,28,21,74,128,71,113,27,130,92,128,141,27,1,64,56,56,70,10,59,128,77,7,37,56,128,68,112,129,2,25,29,31,20,23,143,143};
static const short Gen_shift_values_BG1_Z_160[2109]= {72,142,67,59,14,6,47,102,133,79,48,26,29,100,119,36,79,0,37,38,66,60,132,41,14,3,39,78,14,79,70,1,105,120,54,128,142,3,139,92,132,134,3,75,122,52,137,105,140,109,71,43,82,23,27,112,85,76,15,99,69,28,115,158,31,140,67,72,73,143,68,60,14,15,7,48,102,103,134,80,48,49,27,30,101,120,37,79,80,1,38,38,39,67,61,133,42,15,4,40,79,14,15,80,71,1,2,106,121,54,55,129,143,3,4,140,93,132,133,135,4,76,123,53,137,138,106,141,109,110,72,44,83,24,28,112,113,86,77,15,16,100,70,28,29,116,159,31,32,141,68,73,143,67,68,59,60,15,6,7,47,48,103,134,79,80,49,27,29,30,101,119,120,36,37,80,1,37,38,39,66,67,60,61,133,41,42,14,15,4,39,40,78,79,15,80,70,71,2,105,106,120,121,55,129,142,143,4,140,92,93,133,134,135,3,4,76,122,123,52,53,138,106,140,141,110,72,43,44,83,23,24,27,28,113,85,86,76,77,16,100,69,70,29,115,116,158,159,32,141,67,68,73,143,68,59,60,15,7,47,48,103,134,80,49,27,29,30,101,120,36,37,80,1,38,39,67,60,61,133,42,14,15,4,40,78,79,15,80,71,2,106,120,121,55,129,142,143,4,140,92,93,133,135,3,4,76,123,52,53,138,106,141,110,72,43,44,83,24,27,28,113,86,76,77,16,100,70,29,116,158,159,32,141,67,68,72,44,31,101,26,18,82,133,125,6,131,61,92,38,7,145,148,49,59,78,155,38,119,156,157,25,19,91,0,133,122,158,37,133,38,29,120,64,79,13,87,101,122,98,51,157,91,93,122,34,81,11,96,64,99,68,30,2,40,41,142,146,71,44,35,134,58,28,147,74,117,150,99,26,106,128,20,132,12,71,141,137,74,11,87,46,49,24,75,157,67,67,137,152,61,62,144,53,54,134,99,9,91,0,1,132,41,42,132,27,97,58,128,4,73,74,133,43,111,21,114,23,24,129,25,95,44,113,114,121,30,31,4,74,85,155,122,31,32,123,33,151,60,61,145,54,55,57,127,126,35,36,99,8,9,88,158,124,33,34,3,72,73,99,9,4,74,155,64,65,86,156,30,99,100,45,114,115,139,49,53,123,67,136,137,88,158,64,134,17,86,87,70,57,127,59,128,129,88,157,158,0,70,47,116,117,137,46,47,62,132,30,100,65,134,135,34,104,156,66,128,37,38,135,7,77,108,17,18,112,21,22,37,107,10,79,80,1,70,71,100,10,24,94,154,63,64,109,113,23,40,109,110,83,152,153,116,26,65,135,152,61,62,108,28,83,35,125,150,106,134,48,13,79,50,74,0,150,115,32,33,25,103,110,28,102,20,15,57,134,135,49,127,90,8,146,145,62,63,16,94,122,40,91,8,9,69,147,72,150,143,61,2,80,79,157,122,39,40,43,121,80,158,81,158,159,109,27,103,21,15,93,84,2,57,135,46,124,82,0,121,39,57,134,135,122,40,113,31,44,121,122,148,66,3,81,97,14,15,11,89,25,103,46,123,124,22,100,135,53,129,15,92,93,17,95,46,124,118,36,5,83,95,13,20,97,98,148,66,23,101,152,69,70,114,32,86,4,128,125,43,66,144,70,148,155,72,73,128,46,119,37,58,135,136,142,60,112,30,71,148,149,158,76,41,119,74,151,152,23,101,110,28,16,68,74,8,47,104,51,109,110,20,105,97,38,51,52,44,85,139,140,11,117,85,86,64,67,141,138,157,74,116,117,38,75,75,76,104,98,10,79,52,142,41,77,116,51,52,117,108,38,39,143,158,91,92,6,20,40,41,17,130,9,10,12,41,113,0,90,14,15,143,18,146,147,109,81,120,61,65,149,150,123,114,52,53,137,107,65,66,153,36,159,68,69,18,105,77,138,53,60,18,97,124,34,119,110,111,68,66,58,98,99,129,154,25,131,100,78,80,81,152,11,87,88,131,52,89,90,118,111,112,24,93,65,66,55,91,129,130,66,131,122,53,157,11,12,59,106,20,33,34,55,31,143,144,24,26,54,55,129,127,14,103,104,29,157,32,1,123,94,95,134,75,78,79,4,137,127,128,23,67,151,121,80,7,49,50,83,32,118,119,52,122,47,39,154,146,27,68,82,113,59,28,6,9,139,80,99,16,59,140,17,18,46,40,112,21,154,143,19,58,154,59,50,141,85,100,34,108,122,44,143,119,72,112,114,143,55,102,32,117,85,120,89,51,23,62,3,7,92,65,56,155,79,49,8,95,138,114,11,120,47,96,146,127,50,67,99,133,130,140,134,63,20,100,109,40,82,152,77,69,140,24,16,57,112,143,89,58,36,39,1,110,129,46,89,10,47,48,76,70,142,51,24,13,49,88,24,89,80,39,11,115,130,64,138,152,129,13,149,102,142,144,13,85,132,62,147,115,150,119,81,53,92,33,37,122,95,86,25,109,79,38,125,8,41,150,77,78,14,131,122,102,16,19,54,155,88,49,132,104,33,103,28,20,128,135,127,8,63,94,40,9,147,150,119,61,80,157,109,40,121,158,159,27,21,93,2,135,124,0,39,135,40,31,122,66,81,15,89,103,26,124,100,53,93,95,124,36,83,13,98,66,101,70,32,4,43,144,148,73,46,37,136,60,30,149,76,119,152,101,28,11,134,95,45,109,109,157,66,49,28,143,10,132,49,73,102,12,97,88,89,44,36,76,77,26,132,3,109,78,56,58,59,130,149,65,66,109,30,67,68,96,89,90,2,71,43,44,33,69,107,108,44,109,100,31,135,149,150,84,158,11,12,33,9,121,122,2,4,32,33,105,152,81,82,147,7,135,10,139,101,72,73,112,53,56,57,142,115,105,106,116,45,129,99,58,145,27,28,61,10,96,97,48,118,42,43,34,35,90,150,141,142,22,23,78,109,54,55,24,2,4,5,76,94,95,11,12,55,136,12,13,14,41,42,35,36,108,16,17,149,150,139,14,15,53,54,150,55,45,46,137,80,81,95,96,22,30,104,117,118,139,115,67,68,108,109,110,138,139,104,51,97,98,27,28,113,81,115,116,85,47,18,19,58,158,159,2,3,88,60,61,51,52,151,75,44,45,4,90,91,133,134,7,116,42,43,138,75,48,145,133,70,125,61,62,80,17,72,9,113,49,50,61,8,105,39,136,145,82,114,51,92,29,95,31,32,6,103,25,122,102,38,39,145,82,66,3,103,40,104,41,132,69,126,62,63,38,135,107,44,80,16,17,147,69,6,105,42,144,80,81,80,17,145,82,136,73,67,4,11,108,26,122,123,120,57,34,131,48,144,145,69,6,45,142,158,94,95,38,135,40,137,69,5,6,141,78,28,125,118,54,55,43,140,11,108,46,143,15,112,137,74,109,45,46,148,85,89,26,93,29,30,18,115,151,88,142,78,79,81,18,5,102,135,72,94,31,21,118,64,0,1,97,34,46,143,133,69,70,130,40,124,125,116,117,49,72,63,64,104,105,0,31,136,137,106,84,86,87,158,16,17,93,94,137,58,94,95,96,123,124,117,118,30,98,99,71,72,61,96,97,135,136,72,137,127,128,59,2,3,17,18,112,26,39,40,61,37,149,150,21,30,31,32,60,61,133,19,20,109,110,110,35,3,37,38,7,129,100,101,140,80,81,84,85,10,142,143,133,134,73,157,126,127,86,12,13,55,56,89,38,124,125,9,19,139,32,26,135,4,43,37,107,32,24,139,131,12,46,67,98,44,13,151,154,65,84,1,44,125,2,3,31,25,157,97,6,139,128,4,43,139,44,35,126,70,85,19,93,107,128,104,57,54,97,99,128,40,87,17,102,70,105,74,36,8,47,148,152,77,50,41,140,64,34,153,80,123,156,105,32,98,18,17,159,27,28,98,23,15,129,130,122,3,137,57,58,89,35,3,4,142,145,56,75,152,34,35,116,153,153,154,22,16,88,157,130,119,155,34,129,130,35,26,116,117,61,76,9,10,84,98,118,119,95,48,87,88,90,119,14,31,78,8,92,93,61,96,64,65,27,159,38,139,143,67,68,41,32,130,131,55,25,143,144,71,114,146,147,96,23,150,18,63,20,101,76,31,47,31,79,36,153,46,123,46,39,109,33,34,25,26,65,141,132,133,13,14,69,100,45,46,15,153,155,156,67,85,86,2,3,64,46,127,3,4,5,32,33,26,27,99,7,8,140,141,130,5,6,44,45,141,46,36,37,128,71,72,86,87,21,95,108,109,130,106,58,59,99,100,101,129,130,42,88,89,18,19,104,72,106,107,76,38,9,10,49,149,150,153,154,79,51,52,42,43,142,66,35,36,155,81,82,124,125,158,107,33,34,15,85,10,1,2,117,109,149,150,67,45,76,22,151,129,131,132,43,62,138,139,22,103,140,141,9,2,3,75,144,116,117,106,142,20,21,117,22,13,104,48,62,63,157,71,84,85,106,82,34,35,75,77,105,106,18,65,154,155,80,48,83,52,14,145,146,68,25,126,129,130,55,28,18,19,15,118,42,12,131,58,100,101,134,83,9,10,12,82,7,159,73,114,106,147,42,73,19,148,126,129,40,59,136,19,100,137,138,6,0,72,141,114,66,103,139,18,114,19,10,98,101,45,60,154,68,82,103,79,32,72,74,103,15,62,152,77,45,80,49,11,143,22,123,127,52,25,16,115,39,9,128,55,98,131,80,7,100,67,125};
static const short Gen_shift_values_BG1_Z_176[2109]= {117,76,49,96,117,34,93,166,48,36,153,95,48,161,125,102,30,91,110,164,88,138,111,127,165,125,60,90,66,49,117,73,126,105,0,166,69,162,76,168,24,109,92,157,109,8,52,65,124,170,80,72,132,130,38,127,162,142,166,8,33,46,6,120,11,125,120,117,118,77,50,97,117,118,35,94,166,167,49,37,153,154,96,49,162,126,103,30,31,92,111,164,165,89,139,112,128,166,126,61,91,66,67,50,118,73,74,127,106,0,1,167,70,162,163,77,169,24,25,110,93,158,110,9,52,53,66,125,170,171,81,73,133,131,39,127,128,163,143,166,167,9,34,46,47,7,121,11,12,126,121,118,77,49,50,96,97,118,34,35,93,94,167,49,36,37,154,96,48,49,162,125,126,102,103,31,92,110,111,165,88,89,138,139,112,127,128,165,166,126,60,61,90,91,67,50,117,118,74,126,127,105,106,1,167,69,70,163,77,168,169,25,109,110,92,93,158,109,110,8,9,53,66,124,125,171,81,72,73,133,130,131,38,39,128,162,163,142,143,167,9,33,34,47,6,7,120,121,12,126,120,121,118,77,50,96,97,118,35,93,94,167,49,37,154,96,48,49,162,126,102,103,31,92,111,165,89,138,139,112,128,165,166,126,61,90,91,67,50,118,74,127,105,106,1,167,69,70,163,77,168,169,25,110,92,93,158,110,8,9,53,66,125,171,81,72,73,133,131,38,39,128,163,142,143,167,9,34,47,7,120,121,12,126,120,121,41,79,48,7,156,27,42,48,141,24,129,97,155,143,84,26,155,74,92,56,33,137,22,41,95,19,69,42,58,96,56,167,21,173,156,48,4,57,36,107,97,0,93,7,99,145,131,40,23,88,40,115,159,172,55,101,11,3,118,63,61,145,58,93,73,97,115,140,153,113,51,118,56,51,81,117,72,153,98,171,149,107,128,2,102,47,120,38,38,79,10,38,145,11,117,118,58,164,165,171,79,10,172,102,103,55,161,162,74,128,59,10,117,174,104,105,115,46,57,164,10,116,117,21,123,54,87,17,18,64,170,171,168,99,53,160,72,2,3,126,57,50,156,157,100,30,31,73,4,89,19,20,127,57,58,87,18,22,128,129,52,158,159,28,135,11,118,79,9,10,35,142,88,18,19,67,173,174,138,69,128,59,31,137,138,124,55,38,145,130,60,61,135,162,93,71,1,2,54,160,161,119,50,71,1,2,146,76,77,14,121,27,134,86,16,17,132,63,42,149,34,140,141,47,94,25,92,22,23,0,106,107,89,20,124,54,55,104,34,35,128,59,146,77,171,101,102,16,8,115,144,74,75,82,12,13,149,80,87,18,82,12,13,58,155,87,116,110,91,151,22,160,174,76,26,54,48,90,103,133,134,62,93,35,66,82,113,24,103,133,134,20,51,79,110,145,152,6,7,34,65,22,53,139,169,170,81,112,34,65,147,2,111,142,88,119,16,46,47,77,108,96,127,150,4,5,74,105,124,155,97,128,113,144,151,6,111,142,46,77,76,107,52,82,83,35,66,103,134,59,89,90,112,143,91,122,162,16,17,152,7,55,86,148,2,3,62,93,154,9,23,10,40,41,95,126,78,109,143,174,95,126,170,25,38,68,69,51,82,110,141,156,10,11,66,97,58,89,174,118,149,116,147,24,55,113,143,144,148,3,128,159,152,6,7,170,25,19,50,32,62,63,168,23,106,137,173,27,28,111,142,106,137,165,122,40,141,109,175,75,22,23,158,131,2,134,22,23,116,175,71,72,130,118,58,59,1,130,74,67,31,8,111,112,173,16,69,70,170,44,17,33,71,88,31,142,172,147,148,131,23,154,155,32,11,81,82,72,151,67,68,158,74,105,106,15,174,63,15,90,133,134,147,30,75,76,162,154,38,36,120,32,33,68,48,71,72,90,115,127,128,88,26,93,92,93,31,26,21,145,100,155,65,77,55,14,163,33,34,175,55,148,30,31,171,104,162,150,91,33,161,162,99,63,39,40,144,29,48,102,26,75,76,49,65,102,103,63,174,27,28,4,163,55,11,64,42,43,14,114,104,6,7,100,14,105,106,138,47,29,30,80,95,47,121,122,166,3,62,108,18,9,10,70,68,151,152,65,100,79,80,175,104,122,147,160,120,57,58,125,63,57,58,55,14,163,34,55,148,31,13,104,162,150,91,33,162,116,99,63,40,144,29,48,102,26,76,49,65,103,63,174,28,4,163,55,11,64,43,114,104,7,155,100,14,106,138,47,30,95,47,122,166,3,62,108,18,10,70,68,152,65,100,80,104,122,147,160,120,58,154,125,63,58,109,51,70,115,13,46,109,69,4,72,86,109,146,81,27,147,106,79,126,88,147,64,123,20,78,66,7,125,78,64,15,155,132,60,121,140,18,118,168,141,157,19,155,90,120,96,79,147,154,103,156,135,30,20,99,67,16,106,22,54,139,122,11,139,38,82,95,154,24,110,102,162,160,68,157,16,172,20,38,63,76,36,150,41,155,150,161,87,169,142,108,103,156,59,112,17,5,4,127,135,94,67,114,37,135,52,111,8,66,54,171,113,66,169,3,143,120,72,48,109,128,6,106,156,129,145,7,143,78,108,84,67,135,91,144,123,18,8,87,111,4,94,10,42,127,110,175,127,26,70,83,142,12,98,90,150,148,56,145,4,160,8,26,51,64,24,138,29,143,138,102,78,110,53,148,149,49,98,90,149,91,101,0,39,166,49,8,157,27,28,49,142,24,25,96,98,156,144,85,27,155,156,93,57,33,34,138,23,42,96,20,69,70,43,59,96,97,57,168,21,22,174,157,49,5,58,36,37,108,98,0,1,94,8,99,100,132,41,23,24,89,41,115,116,103,160,173,56,102,12,3,4,64,62,145,146,59,94,73,74,66,98,116,141,154,114,51,52,119,57,51,52,154,113,85,86,132,133,170,154,70,71,129,130,27,85,72,73,14,132,84,85,22,161,162,138,139,67,128,146,147,25,124,125,174,175,148,163,164,25,26,162,96,97,126,127,103,86,153,154,110,162,163,141,142,15,37,27,105,106,23,113,28,29,61,145,146,128,129,94,18,145,146,44,45,89,102,160,161,31,117,108,109,169,166,167,74,75,164,22,23,2,3,27,45,69,70,83,42,43,156,157,48,162,156,157,44,164,3,123,152,96,23,142,143,44,164,137,81,20,139,140,100,93,37,151,95,139,83,80,24,22,142,151,94,95,88,32,52,172,29,148,149,133,77,18,138,37,157,91,35,15,135,65,8,9,38,158,54,174,92,35,36,120,52,172,163,107,17,136,137,169,113,152,96,44,164,0,120,53,173,32,151,152,103,47,93,37,172,115,116,89,33,3,123,95,38,39,127,71,36,156,19,138,139,84,28,36,156,111,54,55,155,99,168,112,51,171,97,41,7,127,175,118,119,59,3,57,1,141,84,85,54,174,89,33,69,12,13,93,37,111,55,136,80,149,93,109,53,47,166,167,114,58,52,172,47,166,167,25,160,132,133,3,4,174,25,117,118,0,1,74,132,119,120,61,3,131,132,69,32,33,9,10,114,175,17,18,72,171,172,45,46,19,34,35,72,73,33,143,144,173,174,150,133,24,25,157,33,34,12,13,84,74,152,153,70,160,75,76,88,108,16,17,175,0,65,16,17,91,92,161,136,149,31,32,78,164,155,156,40,37,38,121,122,35,69,70,49,50,74,92,116,117,130,89,90,27,28,95,33,27,28,55,127,140,100,59,143,111,53,33,168,141,12,33,126,9,99,82,140,128,69,11,140,77,41,18,122,7,26,80,4,54,33,27,43,81,41,152,6,158,141,33,165,42,21,92,82,161,78,168,84,18,116,25,8,73,25,100,144,157,40,86,172,164,48,46,130,43,78,58,82,100,125,138,98,36,103,41,36,134,14,34,11,26,27,162,135,6,26,27,120,3,142,75,76,134,122,62,63,5,134,71,35,12,115,116,1,20,73,74,174,48,21,37,75,35,146,0,151,152,135,27,158,159,36,15,85,86,76,155,71,72,162,78,109,110,19,2,59,67,19,94,137,138,151,34,79,80,166,158,42,40,124,36,37,72,52,75,76,94,119,131,132,92,30,96,97,35,30,163,19,32,69,59,87,36,95,127,60,134,122,76,24,95,135,94,66,67,113,114,111,135,51,52,110,111,8,66,53,54,171,113,65,66,3,142,143,119,120,82,48,109,127,128,6,105,106,155,156,129,144,145,6,7,143,77,78,107,108,84,67,134,135,91,143,144,122,123,18,8,86,87,4,94,9,10,42,126,127,109,110,175,126,127,25,26,70,83,141,142,12,98,89,90,150,147,148,55,56,145,3,4,159,160,8,26,50,51,64,23,24,137,138,29,143,137,138,109,68,41,87,88,109,26,84,85,33,158,40,28,145,87,39,40,153,117,93,94,22,83,102,156,80,129,130,103,119,156,157,117,52,81,82,58,41,109,65,118,96,97,168,158,60,61,154,68,159,160,16,101,83,84,149,101,175,0,44,57,116,162,72,63,64,2,124,122,29,30,119,154,133,134,52,158,0,25,38,174,111,112,3,117,111,112,37,172,145,16,78,37,130,13,86,144,132,73,15,144,81,45,22,126,11,30,84,8,58,31,47,85,67,45,156,10,162,145,37,116,169,46,25,96,86,165,82,172,88,120,29,12,77,29,104,148,161,44,90,0,168,52,50,134,47,82,62,86,104,129,142,102,40,107,45,40,81,66,58};
static const short Gen_shift_values_BG1_Z_192[2109]= {114,75,12,83,18,57,86,49,75,135,176,72,191,95,139,82,180,143,63,23,160,6,138,74,152,138,159,55,124,177,62,95,128,131,108,102,112,16,149,38,164,7,148,24,87,19,22,98,52,105,161,111,113,130,107,49,47,78,179,138,12,137,12,38,153,111,164,114,115,76,13,84,18,19,58,87,49,50,76,136,176,177,73,0,96,140,83,180,181,144,64,23,24,161,7,139,75,153,139,160,56,124,125,178,63,95,96,129,132,108,109,103,113,16,17,150,39,164,165,8,149,25,88,20,22,23,99,53,105,106,162,112,114,131,108,49,50,48,79,179,180,139,13,137,138,13,39,153,154,112,165,115,76,12,13,83,84,19,57,58,86,87,50,76,135,136,177,73,191,0,96,139,140,82,83,181,144,63,64,24,160,161,6,7,139,74,75,152,153,139,159,160,55,56,125,178,62,63,96,128,129,131,132,109,103,112,113,17,150,38,39,165,7,8,148,149,25,87,88,19,20,23,99,52,53,106,162,111,112,114,130,131,107,108,50,47,48,78,79,180,139,12,13,138,12,13,38,39,154,112,164,165,115,76,13,83,84,19,58,86,87,50,76,136,177,73,191,0,96,140,82,83,181,144,64,24,161,6,7,139,75,152,153,139,160,55,56,125,178,63,96,129,131,132,109,103,112,113,17,150,38,39,165,8,148,149,25,88,19,20,23,99,53,106,162,111,112,114,131,107,108,50,48,78,79,180,139,13,138,13,38,39,154,112,164,165,139,180,79,40,169,48,2,175,22,51,13,14,40,100,141,37,156,114,60,104,47,145,108,28,180,125,163,103,39,117,103,124,20,89,142,27,60,93,96,73,67,77,173,114,3,165,129,164,113,181,52,176,179,63,17,70,126,76,48,78,95,72,14,12,43,144,103,169,102,169,3,118,76,129,50,85,64,0,158,91,60,17,32,8,61,123,140,97,113,181,93,142,54,79,182,183,150,61,62,114,85,189,124,35,36,153,64,65,178,116,28,142,54,10,113,114,51,155,139,51,66,169,170,164,162,74,14,117,118,149,60,61,55,159,18,122,130,41,42,90,2,35,138,139,73,176,177,13,117,141,52,53,27,130,131,13,117,34,137,138,122,33,34,191,103,52,156,129,40,41,162,74,3,106,107,6,109,110,175,87,169,81,179,90,91,83,187,24,128,105,16,17,17,39,143,74,177,178,23,126,127,91,3,154,65,66,86,189,190,89,1,165,77,119,30,31,172,84,36,140,178,89,90,38,180,92,5,108,109,174,85,86,116,28,114,25,26,145,56,57,54,158,13,117,79,182,183,31,12,116,79,182,183,105,16,17,28,132,178,90,39,142,143,175,173,39,128,132,56,110,62,81,100,146,81,110,190,161,64,37,38,25,191,154,128,33,7,47,160,133,134,7,173,36,10,101,191,164,165,25,191,85,59,126,99,100,22,188,141,115,45,19,89,63,32,6,130,103,104,93,67,13,179,165,138,139,110,84,148,122,88,62,24,190,102,76,88,62,109,83,5,171,74,47,48,127,101,12,178,45,18,19,78,52,81,55,58,31,32,52,26,62,36,158,131,132,99,73,180,154,7,114,87,88,149,123,98,72,166,140,37,11,161,135,164,137,138,48,22,2,168,55,28,29,111,85,61,35,46,63,37,80,54,57,31,191,164,165,189,163,28,2,129,102,103,88,62,154,128,87,60,61,154,128,180,154,103,76,77,61,35,114,88,187,76,185,173,39,49,73,100,101,62,191,70,120,4,5,44,73,35,36,62,122,162,163,59,178,176,82,126,69,166,167,130,50,9,10,147,185,125,61,139,73,125,146,42,110,111,164,49,81,82,115,118,94,95,89,99,2,3,136,25,150,151,186,135,11,74,6,8,9,85,39,91,92,148,98,100,117,94,35,36,34,65,165,166,125,191,123,124,191,25,114,139,140,98,151,141,55,136,88,154,11,0,153,90,160,161,48,96,135,163,164,1,127,153,21,62,150,76,77,173,25,159,160,66,29,141,101,46,83,84,24,152,37,38,24,45,132,133,10,63,140,173,14,16,17,17,186,180,189,190,94,35,115,116,50,85,33,34,125,102,165,96,97,100,176,130,183,47,188,189,191,16,184,185,127,125,155,156,54,65,24,90,23,90,115,116,39,189,49,50,171,132,69,140,75,114,143,12,106,132,0,41,129,56,145,152,4,139,45,8,120,80,25,63,3,131,17,3,24,112,181,42,119,152,185,188,165,159,169,56,73,14,95,29,64,13,81,144,76,79,155,109,162,26,168,170,187,164,106,104,135,44,3,69,2,69,95,96,18,168,29,67,110,80,165,182,129,162,87,131,3,144,20,151,49,4,173,134,71,142,186,77,116,145,108,134,2,43,131,58,13,154,6,141,47,10,122,82,27,65,5,133,19,5,26,114,183,44,121,71,154,187,190,167,161,171,148,75,16,97,31,66,15,83,146,78,81,157,111,164,28,170,172,189,166,108,106,137,46,5,71,4,71,97,20,170,31,12,101,135,20,96,29,10,40,21,23,88,60,26,156,117,54,125,105,60,99,128,91,117,177,26,114,41,157,137,181,124,42,30,185,105,65,10,48,180,116,2,180,9,97,166,27,104,137,170,173,150,144,154,146,58,191,80,14,49,190,66,129,61,64,140,94,147,11,153,155,172,149,91,89,120,29,180,54,179,54,80,3,153,14,71,16,190,119,70,80,75,135,1,1,100,29,18,51,81,1,154,91,161,162,97,136,164,165,59,128,154,22,63,151,77,78,174,26,160,161,67,30,142,102,47,84,85,25,153,38,39,25,46,133,134,11,64,141,174,15,17,18,187,181,190,191,95,36,116,117,51,86,34,35,103,166,97,98,4,101,177,131,184,48,189,190,0,17,185,186,128,126,156,157,146,66,25,91,24,91,116,117,40,190,50,51,13,166,102,103,173,174,158,109,147,148,176,177,140,166,33,34,75,163,89,90,186,37,38,172,173,79,42,153,154,114,58,59,96,97,37,164,165,50,51,37,57,58,145,146,23,76,152,153,186,26,27,29,30,36,7,1,10,11,107,48,128,129,63,97,98,46,47,67,115,177,178,109,110,113,189,142,143,4,60,9,10,12,28,29,5,6,140,137,138,168,169,78,37,102,103,36,102,103,128,129,52,10,62,63,180,179,141,140,78,77,149,147,148,84,83,123,122,152,150,151,99,115,114,141,140,9,8,50,49,138,137,65,63,64,161,160,13,12,148,146,147,54,53,17,16,129,128,89,88,34,33,72,70,71,12,11,140,139,26,24,25,22,12,11,33,32,121,119,120,190,189,51,50,128,127,161,160,2,1,5,3,4,174,173,168,167,178,176,177,82,81,23,22,104,102,103,38,37,73,72,22,20,21,90,89,153,152,85,83,84,88,87,164,163,118,117,171,170,35,34,177,175,176,179,178,4,3,173,171,172,115,114,113,112,144,142,143,53,52,12,11,78,77,11,10,78,77,104,102,103,27,26,177,176,38,36,37,18,171,107,108,178,179,101,114,152,153,181,182,145,171,38,39,80,168,94,95,191,42,43,177,178,84,47,158,159,119,63,64,101,102,42,169,170,55,56,42,62,63,150,151,28,81,157,158,191,31,32,34,35,12,6,15,16,112,53,133,134,8,68,102,103,51,52,120,182,183,114,115,174,118,2,147,148,9,65,14,15,17,33,34,10,11,145,142,143,173,174,83,42,107,108,41,107,108,133,134,57,15,67,68,130,7,168,104,37,147,9,119,188,149,86,157,92,131,160,127,123,149,17,58,146,73,169,21,156,62,25,137,97,42,80,142,20,148,34,20,41,129,6,59,136,169,10,13,182,176,186,90,31,112,1,46,81,30,98,161,93,96,172,126,179,43,185,187,12,181,123,121,152,61,20,86,19,86,112,35,185,46,17,120,104,20,37,38,191,128,7,133,134,173,10,76,164,165,191,59,99,100,188,115,19,63,6,103,104,67,179,138,139,84,122,62,190,76,62,83,171,47,48,101,178,18,19,52,55,31,32,26,36,131,132,73,154,87,88,123,72,81,140,11,135,137,138,22,168,28,29,85,35,37,54,31,164,165,163,2,102,103,62,128,60,61,128,154,76,77,35,88,184,176,96,21,65,92,153,104,174,36,119,51,121,138,95,141,102,38,39,109,110,112,45,83,84,112,113,76,102,161,162,11,99,25,26,122,165,166,108,109,13,15,170,89,90,50,186,187,32,33,165,100,101,178,179,165,185,186,81,82,151,12,88,89,122,154,155,157,158,135,129,138,139,43,176,64,65,191,33,34,174,175,51,113,114,45,46,49,125,78,79,132,188,137,138,140,156,157,133,134,76,73,74,104,105,14,165,38,39,164,38,39,64,65,180,138,190,191,91,52,181,59,60,187,34,62,63,112,26,52,112,153,49,167,168,72,116,58,59,157,120,40,0,137,174,175,115,51,128,129,115,136,31,32,101,154,39,72,105,107,108,85,79,88,89,185,126,14,15,141,176,124,125,1,64,187,188,191,75,29,82,138,87,88,131,90,107,83,84,26,24,54,55,113,156,115,181,114,181,14,15,130,88,140,141,4,157,94,165,79,100,139,168,131,157,25,66,154,81,177,29,164,70,33,145,105,50,88,28,156,42,77,28,49,137,14,67,144,162,177,18,21,190,184,2,98,39,120,54,89,38,106,169,101,104,180,134,187,51,1,3,20,189,131,129,160,69,28,94,27,94,120,43,1,54,134,148,14};
static const short Gen_shift_values_BG1_Z_208[2109]= {102,124,26,106,102,139,108,102,113,123,102,18,135,102,74,7,102,112,106,102,43,151,102,150,123,102,140,108,102,104,16,102,89,45,102,118,185,102,162,48,102,49,189,102,130,107,102,108,187,102,132,194,102,149,67,102,73,14,102,62,144,102,168,104,102,133,36,207,102,124,26,106,207,102,139,108,207,102,113,123,207,102,18,135,102,74,7,207,102,112,106,207,102,43,151,102,150,123,102,140,108,207,102,104,16,207,102,89,45,207,102,118,185,207,102,162,48,207,102,49,189,102,130,107,207,102,108,187,207,102,132,194,102,149,67,207,102,73,14,207,102,62,144,207,102,168,104,207,102,133,36,102,124,131,26,3,106,102,36,139,5,108,102,113,20,123,102,18,32,135,102,179,74,112,7,102,112,3,106,102,148,43,48,151,102,47,150,20,123,102,37,140,5,108,102,104,121,16,102,194,89,150,45,102,118,82,185,102,162,153,48,102,154,49,86,189,102,27,130,4,107,102,108,84,187,102,132,91,194,102,46,149,172,67,102,178,73,119,14,102,62,41,144,102,65,168,1,104,102,133,141,36,102,124,26,3,106,102,139,5,108,102,113,123,102,18,32,135,102,74,112,7,102,112,106,102,43,48,151,102,150,20,123,102,140,5,108,102,104,16,102,89,150,45,102,118,82,185,102,162,153,48,102,49,86,189,102,130,4,107,102,108,187,102,132,91,194,102,149,172,67,102,73,119,14,102,62,144,102,168,1,104,102,133,141,36,23,203,174,196,98,178,184,174,3,180,99,174,185,195,174,90,207,23,174,146,79,174,184,178,174,115,15,174,14,195,174,4,180,174,176,88,174,161,117,174,190,49,174,26,120,64,174,121,53,174,202,179,174,180,51,174,204,58,206,174,13,139,174,145,86,174,134,8,174,32,176,174,205,108,160,5,26,162,49,47,23,37,90,144,87,111,152,158,75,137,10,159,32,61,39,142,141,119,14,171,137,10,174,152,47,143,121,16,1,137,10,148,21,158,136,31,137,10,53,134,170,148,43,130,137,10,109,87,190,42,20,123,137,10,147,20,141,119,14,137,10,78,56,159,186,164,59,137,10,185,163,58,158,136,31,137,10,175,153,48,143,121,16,137,10,139,12,51,29,132,137,10,124,102,205,80,58,161,137,10,153,26,12,198,93,137,10,197,70,83,61,164,140,137,10,84,62,165,16,202,97,137,10,165,143,38,142,120,15,137,10,143,16,14,200,95,137,10,167,40,21,207,102,95,137,10,184,162,57,102,80,183,137,10,108,86,189,49,27,130,137,10,97,178,179,157,52,98,137,10,203,181,76,139,117,12,137,10,168,41,71,49,152,100,5,9,144,52,200,3,163,172,125,76,155,15,11,69,3,123,18,25,40,135,150,7,22,183,3,123,18,40,55,9,24,193,3,123,18,14,29,24,39,3,123,18,127,142,36,51,3,18,183,198,116,131,3,123,18,13,28,7,22,3,123,18,152,167,52,67,3,18,51,66,24,39,3,18,41,56,9,24,3,123,18,5,20,125,140,3,123,18,198,5,154,169,3,123,18,19,34,86,101,3,123,18,63,78,157,172,122,3,123,18,158,173,90,105,3,18,31,46,8,23,3,123,18,9,24,88,103,3,123,18,33,48,95,110,15,3,18,50,65,176,191,3,123,18,182,197,123,138,3,123,18,171,186,45,60,3,123,18,69,84,5,20,3,123,18,34,49,145,160,103,5,19,202,152,103,206,45,148,170,72,152,51,45,148,185,154,45,148,159,169,45,148,64,181,146,148,120,53,45,148,158,152,45,148,89,197,148,196,169,0,148,186,154,45,148,150,62,45,148,135,91,45,148,164,23,45,148,0,94,45,148,95,27,148,176,153,45,148,154,25,45,148,178,32,148,195,113,45,148,119,60,45,148,108,190,45,148,6,150,15,45,148,179,82,0,201,117,129,0,1,148,170,72,49,152,172,148,185,51,154,5,148,159,169,148,64,78,181,148,120,158,53,148,158,152,148,89,94,197,148,196,66,169,148,186,51,154,148,150,62,148,135,196,91,80,148,164,128,23,148,0,199,94,148,95,132,27,181,148,176,50,153,148,154,25,148,178,137,32,148,195,10,113,148,119,165,60,52,148,108,190,148,6,47,150,148,179,187,82,76,98,0,80,76,113,82,87,76,87,97,76,200,109,197,76,48,189,76,86,80,76,17,125,76,124,97,76,114,82,76,78,198,76,63,19,76,92,159,159,76,136,22,76,23,163,76,104,81,76,82,161,76,106,168,76,123,41,76,47,196,76,36,118,76,142,78,121,76,107,10,90,183,29,2,154,0,40,166,67,147,11,5,165,183,190,132,154,56,136,5,132,169,138,132,143,153,132,48,165,11,132,104,37,132,142,136,132,73,181,132,180,153,132,170,138,132,134,46,14,132,119,75,132,148,7,4,132,192,78,132,79,11,132,160,137,132,138,9,132,162,16,132,179,97,132,103,44,132,92,174,132,198,134,132,163,66,5,85,95,41,198,43,57,129,130,44,17,131,99,108,130,32,112,8,108,145,114,108,119,129,108,24,141,124,108,80,13,190,108,118,112,108,49,157,108,156,129,108,146,114,108,110,22,108,95,51,108,124,191,27,108,168,54,108,55,195,108,136,113,108,114,193,108,138,200,108,155,73,108,79,20,108,68,150,108,174,110,108,139,42,3,73,15,27,20,141,191,196,97,139,21,3,0,39,92,108,130,32,9,112,108,145,11,114,91,108,119,129,108,24,38,141,108,80,118,13,108,118,112,108,49,54,157,108,156,26,129,108,146,11,114,108,110,22,108,95,156,51,108,124,88,191,108,168,159,54,108,55,92,195,108,136,10,113,135,108,114,193,108,138,97,200,108,155,178,73,108,79,125,20,105,108,68,150,108,174,7,110,108,139,147,42,122,144,151,46,23,126,1,122,56,159,25,128,122,133,40,143,122,38,52,155,122,199,94,132,27,122,132,23,126,122,168,63,68,171,122,67,170,40,143,122,57,160,25,128,122,124,141,36,122,6,109,170,65,87,122,138,102,205,122,182,173,68,122,174,69,106,1,111,122,47,150,24,127,122,128,104,207,122,152,111,6,122,66,169,192,87,122,198,93,139,34,122,82,61,164,122,85,188,21,124,122,153,161,56,19,88,41,110,151,12,23,197,92,19,88,56,125,25,199,94,3,19,88,30,99,40,109,19,88,143,4,52,18,121,19,88,199,60,132,98,201,19,88,29,98,23,92,19,88,168,29,68,34,137,19,88,67,136,40,6,109,48,19,88,57,126,25,199,94,19,88,21,90,141,2,19,88,6,75,170,136,31,19,88,35,104,102,68,171,19,88,79,148,173,139,34,19,88,174,35,106,72,175,19,88,47,116,24,198,93,19,88,25,94,104,173,19,88,49,118,111,77,180,19,88,66,135,192,158,53,19,88,198,59,139,105,0,19,88,187,48,61,130,19,88,85,154,21,195,90,19,88,50,119,161,127,22,122,144,151,46,23,126,5,122,56,159,25,128,122,133,40,143,122,38,52,155,122,199,94,132,27,122,132,23,126,122,168,63,68,171,122,67,170,40,143,122,57,160,25,128,122,124,141,36,122,6,109,170,65,122,138,102,205,122,182,173,68,125,122,174,69,106,1,122,47,150,24,127,62,122,128,104,207,122,152,111,6,122,66,169,192,87,122,198,93,139,34,122,82,61,164,122,85,188,21,124,122,153,161,56,9,29,5,91,3,152,196,154,79,101,3,83,79,116,85,3,79,90,100,79,203,112,79,51,192,79,89,83,79,20,128,44,79,127,100,79,117,85,79,81,201,79,66,22,79,95,162,79,139,25,167,79,26,166,79,107,84,79,85,164,79,109,171,79,126,44,79,50,199,79,39,121,79,145,81,79,110,13,5,199,176,42,134,29,51,161,33,134,29,66,35,81,134,29,40,50,134,29,153,62,29,1,142,134,29,39,33,134,29,178,78,29,77,50,29,67,35,134,29,31,151,134,29,16,180,134,29,45,112,134,29,89,183,134,29,184,116,1,29,57,34,134,29,35,114,134,29,59,121,29,76,202,134,29,0,149,134,29,197,71,134,29,95,31,134,29,60,171,90,63,197,99,3,27,108,187,9,83,11,1,74,141,127,56,78,85,188,165,60,162,56,198,93,167,62,56,67,182,77,56,180,194,89,56,133,28,66,169,9,56,66,165,60,56,102,205,2,105,56,1,104,182,77,56,199,94,167,62,56,58,75,178,56,148,43,104,207,56,72,36,139,56,116,107,2,56,108,3,40,143,56,189,84,166,61,56,62,38,141,56,86,45,148,56,0,103,126,21,56,132,27,73,176,56,16,203,98,56,19,122,163,58,56,87,95,198,200,14,124,101,204,200,29,103,206,0,200,3,13,200,116,130,25,200,172,2,105,200,2,204,200,141,146,41,200,40,118,13,200,30,103,206,200,202,114,200,187,40,143,200,8,180,75,200,52,43,146,200,147,184,79,200,20,102,205,200,206,77,200,22,189,84,162,200,39,62,165,200,171,9,112,98,200,160,34,200,58,99,202,200,23,31,134,105,127,29,109,3,105,142,111,105,116,126,105,21,138,105,77,10,105,115,109,105,46,154,105,153,126,5,105,143,111,105,107,19,141,105,92,48,105,121,188,105,165,51,105,52,192,105,133,110,105,111,190,105,135,197,105,152,70,105,76,17,105,65,147,105,171,107,105,136,39,180,44,152};
static const short Gen_shift_values_BG1_Z_224[2109]= {222,140,206,200,15,202,17,93,44,30,90,150,164,45,175,4,73,118,179,9,185,44,156,94,141,132,152,15,223,86,176,204,69,33,215,205,154,20,92,212,214,76,146,78,213,68,13,8,76,69,117,95,193,197,73,140,116,98,197,30,222,103,89,29,80,186,157,222,223,141,207,201,15,16,203,18,93,94,45,31,90,91,151,165,46,176,5,73,74,119,180,9,10,186,45,157,95,142,133,153,16,223,0,87,177,204,205,70,34,215,216,206,155,20,21,93,213,214,215,77,147,79,214,69,13,14,9,77,69,70,118,96,194,198,74,140,141,117,99,197,198,31,223,103,104,90,30,80,81,187,158,223,141,206,207,200,201,16,202,203,17,18,94,45,30,31,91,151,164,165,46,175,176,4,5,74,119,179,180,10,185,186,44,45,157,94,95,141,142,133,152,153,15,16,0,87,176,177,205,69,70,33,34,216,206,154,155,21,93,212,213,215,76,77,146,147,79,213,214,68,69,14,9,76,77,70,118,95,96,194,197,198,73,74,141,116,117,98,99,198,31,222,223,104,89,90,29,30,81,187,157,158,223,141,207,200,201,16,203,17,18,94,45,31,91,151,164,165,46,176,4,5,74,119,180,10,186,44,45,157,95,141,142,133,153,15,16,0,87,177,205,70,33,34,216,206,154,155,21,93,212,213,215,77,146,147,79,214,68,69,14,9,77,70,118,95,96,194,198,73,74,141,117,98,99,198,31,223,104,90,29,30,81,187,157,158,169,9,151,69,135,129,163,168,131,170,58,22,197,183,19,79,93,85,198,104,157,2,47,108,162,114,197,85,23,70,61,81,168,152,15,105,133,222,186,144,134,83,173,21,141,79,143,5,75,7,142,221,166,161,5,222,46,24,181,122,126,2,69,45,27,126,183,151,32,18,182,9,115,86,129,157,118,112,20,62,50,135,115,16,75,103,99,149,157,42,200,184,118,26,183,184,20,177,178,32,59,217,22,179,180,61,218,219,94,137,71,88,22,74,7,8,134,68,194,128,208,141,142,3,89,23,219,152,153,48,205,206,117,51,162,96,223,156,157,53,211,5,162,163,88,21,22,200,134,138,71,72,185,118,119,176,110,196,129,130,59,216,217,43,201,130,64,220,153,154,24,182,113,46,47,77,10,11,35,193,25,183,198,131,132,64,222,136,70,32,189,190,216,34,192,120,53,54,190,123,124,122,56,33,190,191,112,45,46,57,215,52,210,120,53,54,113,47,161,95,139,72,73,203,13,171,17,174,175,117,50,51,184,118,160,93,94,142,75,76,17,175,74,8,42,199,200,38,147,81,133,66,67,73,6,7,124,58,6,164,201,134,135,57,8,36,212,104,88,184,108,217,81,164,173,18,193,102,82,199,200,0,118,66,184,60,178,51,99,216,217,62,180,101,219,10,177,70,71,128,22,114,8,174,67,68,10,128,24,142,129,23,35,153,88,206,157,50,51,202,96,39,157,93,210,211,45,163,128,22,16,134,178,72,1,119,216,110,12,130,99,217,83,200,201,170,64,36,154,64,181,182,153,47,117,11,75,192,193,65,183,14,132,104,221,222,176,70,72,190,1,74,191,192,160,54,6,124,162,56,73,191,152,46,97,214,215,92,210,160,54,153,46,47,201,95,179,73,34,53,171,57,175,157,51,0,117,118,200,94,182,76,57,174,175,114,8,82,200,187,80,81,173,67,113,7,164,57,58,46,164,17,135,31,141,174,135,2,27,181,76,77,219,61,55,80,93,94,57,96,171,172,123,109,168,169,5,19,55,124,30,83,151,152,197,34,87,88,40,123,11,173,220,71,211,7,94,77,78,165,31,58,59,148,112,69,70,60,9,98,99,171,67,68,69,155,1,157,68,147,91,92,87,155,147,148,196,174,48,52,152,218,219,195,177,51,52,109,77,181,182,168,108,216,158,159,41,12,13,174,210,190,50,42,80,222,64,57,58,89,97,60,98,99,119,175,126,112,172,8,21,22,127,33,85,86,155,200,37,91,43,125,126,14,176,222,223,214,10,96,97,81,168,34,62,151,114,115,130,73,63,11,12,102,174,69,70,72,158,3,4,208,160,71,149,150,95,90,158,151,199,176,177,51,55,154,155,222,198,179,180,208,55,112,80,185,171,110,111,162,44,14,15,99,17,83,77,116,79,118,153,194,145,131,191,27,41,163,146,52,105,174,219,56,110,62,145,33,195,18,9,29,116,100,187,53,81,170,134,92,82,31,42,121,193,89,91,177,23,179,90,169,114,109,177,170,218,196,70,74,174,17,217,199,74,131,99,204,190,130,188,181,63,34,55,109,199,62,3,198,109,199,142,185,7,5,102,197,7,181,99,165,159,104,198,161,200,52,3,213,49,109,123,209,4,134,187,32,77,138,192,144,3,115,53,100,91,111,198,182,45,135,120,163,28,216,174,164,113,213,203,51,171,173,35,105,37,172,27,196,191,35,28,76,54,152,156,32,99,75,57,156,213,181,62,48,212,39,145,116,191,130,219,49,105,52,223,2,147,87,202,167,121,122,40,106,100,48,139,102,141,217,168,154,214,50,64,156,169,75,128,63,197,18,79,133,85,168,56,218,41,32,52,139,123,210,76,104,193,157,115,105,54,192,144,216,112,114,200,46,202,113,192,137,132,200,193,17,219,93,97,197,40,16,222,97,154,122,3,213,153,204,86,57,0,165,64,80,106,175,211,126,207,140,173,145,152,216,113,67,209,51,44,45,84,47,85,86,149,162,113,99,159,219,8,9,114,20,72,73,142,187,24,78,30,112,113,1,163,209,210,201,221,83,84,68,155,21,49,138,101,102,60,50,222,223,89,161,56,57,59,145,214,215,147,58,136,137,10,82,77,145,138,186,163,164,38,42,141,142,209,185,166,167,52,42,99,67,172,158,97,98,149,31,1,2,122,40,105,106,99,100,33,139,101,102,140,141,217,168,153,154,214,50,63,64,169,74,75,127,128,197,18,78,79,133,84,85,167,168,56,217,218,40,41,32,51,52,138,139,123,210,75,76,104,192,193,156,157,129,115,105,53,54,144,216,111,112,114,199,200,45,46,209,202,112,113,191,192,137,132,199,200,193,17,218,219,93,96,97,196,197,40,15,16,221,222,97,154,121,122,3,212,213,152,153,204,86,56,57,175,127,93,45,159,111,153,104,105,192,144,155,107,194,145,146,174,46,222,221,173,207,159,43,219,103,55,117,68,69,222,174,128,80,181,132,133,26,202,71,23,132,84,186,138,138,90,221,172,173,109,61,47,223,94,45,46,48,85,37,105,57,192,143,144,176,128,39,215,129,81,157,109,22,198,210,161,162,168,120,158,110,107,58,59,197,149,45,221,165,116,117,167,119,29,205,99,50,51,31,207,166,118,21,196,197,190,142,185,137,29,205,22,198,70,22,48,223,0,146,98,150,102,26,201,202,93,45,69,21,51,2,3,150,102,207,159,175,127,56,8,42,218,206,157,158,33,209,139,91,110,61,62,29,171,12,13,6,7,191,46,8,9,47,48,124,75,60,61,121,181,194,195,76,205,206,34,35,104,149,209,210,40,215,216,74,75,187,124,125,171,172,163,182,183,45,46,30,117,206,207,11,99,100,63,64,22,12,184,185,51,123,18,19,208,21,106,107,176,177,109,19,20,98,99,57,44,39,106,107,100,148,125,126,0,3,4,103,104,171,146,147,128,129,4,61,28,29,134,119,120,59,60,111,217,187,188,113,48,160,136,81,185,67,149,185,103,169,163,202,165,204,191,56,7,217,53,113,127,8,138,191,36,81,142,196,148,7,172,119,57,104,95,115,202,186,49,139,167,32,220,178,168,117,207,55,175,25,177,39,109,41,176,31,200,195,39,32,80,58,156,160,36,103,79,61,160,217,185,66,52,216,43,149,120,221,156,223,5,136,137,55,121,115,153,154,117,156,80,7,8,183,169,4,5,65,79,184,90,143,211,212,33,94,147,148,100,183,71,9,56,47,67,154,137,138,1,91,118,119,208,172,129,130,120,69,158,159,7,127,128,129,215,61,194,217,128,207,151,152,147,215,207,208,32,10,108,112,212,54,55,31,13,111,112,169,137,17,18,4,168,218,219,101,72,122,89,72,9,11,76,48,113,66,44,95,22,214,59,166,77,219,60,61,54,55,113,94,56,57,95,96,172,123,108,109,169,5,18,19,124,29,30,82,83,90,152,197,33,34,88,39,40,122,123,11,172,173,219,220,211,6,7,93,94,78,165,30,31,59,147,148,111,112,70,60,8,9,99,171,66,67,69,154,155,0,1,157,67,68,146,147,92,87,154,155,148,196,173,174,48,51,52,151,152,219,194,195,176,177,52,109,76,77,182,167,168,107,108,159,41,11,12,160,78,144,137,138,177,140,178,179,205,31,206,192,28,88,101,102,207,113,165,166,11,56,117,171,123,205,206,94,32,78,79,70,90,176,177,161,24,114,142,7,194,195,153,143,91,92,182,30,149,150,152,14,83,84,16,151,5,6,175,170,14,7,55,32,33,21,131,135,10,11,78,54,35,36,133,135,192,160,41,27,190,191,18,124,94,95,10,152,218,212,83,27,214,29,105,56,42,102,162,176,57,187,16,85,130,191,21,197,56,168,106,153,3,144,164,27,11,98,188,8,216,81,45,3,217,166,32,104,0,2,88,158,90,1,80,25,20,88,81,129,107,205,209,85,152,128,110,209,42,10,115,101,41,92,198,169,183,120,28};
static const short Gen_shift_values_BG1_Z_240[2109]= {134,95,188,127,226,3,22,125,235,224,133,135,161,220,150,219,83,127,235,82,116,42,91,178,185,171,91,95,52,55,23,224,67,0,204,10,215,127,188,21,74,5,23,94,100,166,134,84,32,216,152,199,86,95,31,219,124,234,89,162,66,104,229,171,136,215,218,134,135,96,189,128,226,227,4,23,125,126,236,225,133,134,136,162,221,151,220,83,84,128,236,82,83,117,43,92,179,186,172,92,96,52,53,56,24,224,225,68,1,204,205,11,216,127,128,189,22,74,75,6,24,95,101,167,134,135,85,33,216,217,153,200,87,96,32,219,220,125,235,89,90,163,67,104,105,230,172,136,137,216,219,135,96,188,189,127,128,227,3,4,22,23,126,236,224,225,134,136,161,162,221,150,151,219,220,84,128,235,236,83,116,117,42,43,92,178,179,185,186,172,91,92,95,96,53,56,23,24,225,67,68,0,1,205,11,215,216,128,189,21,22,75,5,6,23,24,95,100,101,166,167,135,85,32,33,217,153,199,200,87,95,96,31,32,220,124,125,234,235,90,163,66,67,105,229,230,171,172,137,216,218,219,135,96,189,127,128,227,4,22,23,126,236,225,134,136,161,162,221,151,219,220,84,128,236,83,117,42,43,92,179,185,186,172,92,95,96,53,56,24,225,68,0,1,205,11,215,216,128,189,21,22,75,6,23,24,95,101,166,167,135,85,33,217,153,199,200,87,96,31,32,220,125,234,235,90,163,67,105,230,171,172,137,216,218,219,63,210,74,35,128,67,1,166,183,202,170,65,175,164,73,75,101,46,160,90,159,23,67,175,22,56,222,31,118,125,111,31,35,232,235,203,164,7,180,144,190,155,67,128,201,142,14,185,203,34,40,106,74,24,212,156,92,139,209,26,35,211,159,64,174,29,102,6,44,169,111,76,155,158,179,198,21,22,99,91,206,51,12,76,145,208,31,165,17,47,173,8,134,101,226,227,40,165,166,180,139,25,156,41,42,175,60,61,104,38,164,148,34,137,22,23,46,172,48,174,74,199,200,140,133,19,63,188,189,132,17,18,236,122,40,166,148,33,34,235,121,29,154,155,195,80,81,4,130,91,216,217,98,223,224,84,210,4,129,130,8,133,134,205,91,208,94,176,61,62,137,23,220,105,106,153,38,39,117,3,163,49,128,13,14,40,166,101,227,174,59,60,222,227,113,158,43,44,176,61,62,7,133,13,138,139,79,204,205,47,173,237,123,185,70,71,129,15,65,191,112,237,238,176,239,125,8,133,134,184,69,70,132,18,37,162,163,147,32,33,2,128,75,201,219,104,105,144,17,143,142,27,28,84,209,210,49,175,128,14,131,16,17,198,168,11,205,220,16,211,91,204,115,150,69,229,114,83,59,1,2,20,203,113,56,52,235,44,151,93,94,168,111,187,130,114,50,232,233,160,103,149,92,58,0,1,60,3,86,29,145,88,75,18,144,87,8,190,191,52,235,160,103,7,189,190,41,224,207,150,16,199,103,46,110,53,96,39,16,199,20,203,217,159,160,220,163,188,131,149,91,92,232,175,165,108,129,71,72,175,118,140,83,52,234,235,113,56,186,129,133,239,181,182,170,113,188,131,19,202,25,208,91,34,59,1,2,9,192,197,140,141,83,84,77,20,124,67,0,11,194,20,203,196,139,144,86,87,49,232,159,102,14,196,197,87,30,231,174,29,211,212,154,97,96,39,61,3,4,140,83,143,86,151,185,214,123,179,97,79,44,45,6,99,38,219,136,137,154,173,35,36,146,135,43,44,46,72,184,131,61,130,233,234,38,146,232,233,27,193,2,89,96,153,82,2,6,202,203,206,174,134,135,218,151,114,115,161,126,37,38,99,172,224,225,156,174,5,11,77,44,45,235,183,126,127,63,110,237,6,182,129,130,35,145,239,0,73,217,14,15,140,82,177,46,47,126,129,123,143,181,94,71,75,184,145,238,176,177,38,36,53,71,72,137,175,45,34,183,185,210,211,30,200,28,29,133,177,45,132,166,91,92,141,228,234,235,221,141,144,145,102,105,73,34,117,49,50,219,14,60,24,25,177,238,70,71,124,55,72,73,172,144,150,215,216,184,134,82,26,202,8,9,136,145,80,81,29,174,43,44,141,139,212,116,154,39,220,221,186,25,27,28,99,60,153,92,191,208,227,77,90,200,189,98,100,126,151,185,115,184,48,92,200,47,81,7,56,143,150,136,56,60,17,20,228,189,32,205,169,215,180,83,92,153,226,39,210,228,59,65,131,99,49,237,181,117,164,51,60,236,184,89,199,54,127,31,69,194,136,4,101,180,183,182,111,105,218,128,182,214,179,142,13,178,107,158,137,195,24,225,78,17,76,116,133,152,15,125,114,23,25,51,186,110,40,109,213,17,125,212,6,172,221,68,75,61,221,225,182,185,153,202,114,197,130,94,140,105,166,17,78,151,204,135,153,224,230,56,24,214,162,106,42,89,216,225,161,109,14,124,219,52,196,234,119,61,26,105,108,196,121,214,64,215,24,46,125,177,184,126,116,198,192,153,6,185,31,44,61,80,183,53,42,191,193,219,177,38,208,37,1,141,185,53,140,174,100,149,236,3,229,149,153,110,113,81,42,125,58,22,68,33,155,185,6,79,132,63,81,152,158,224,192,142,90,34,210,17,144,153,89,37,182,52,147,220,124,162,47,229,194,33,36,26,140,10,180,162,130,168,97,164,231,8,31,42,199,204,238,199,52,230,231,90,107,125,126,231,229,99,88,237,239,24,25,84,14,82,83,187,231,99,186,220,145,146,195,42,48,49,35,195,198,199,156,159,127,88,171,103,104,68,114,78,79,231,52,124,125,178,109,126,127,198,204,29,30,31,238,188,136,80,16,62,63,190,199,134,135,83,228,97,98,117,193,26,170,208,93,34,35,0,79,81,82,0,201,53,54,232,233,169,92,108,109,127,128,231,101,89,90,239,1,26,27,86,15,16,84,85,189,233,100,101,188,221,222,147,148,197,43,44,50,51,37,196,197,200,201,158,161,128,129,90,172,173,105,106,198,70,116,80,81,233,54,126,127,180,110,111,128,129,25,200,205,206,31,32,0,190,137,138,82,18,64,65,192,200,201,136,137,85,229,230,99,100,195,28,171,172,210,94,95,36,37,2,81,83,84,69,3,30,204,123,57,62,235,236,161,95,178,112,197,130,131,72,60,234,170,104,159,93,68,2,70,4,96,29,30,155,89,85,19,154,87,88,18,192,62,236,170,104,17,191,51,225,217,150,151,26,200,113,47,120,53,54,148,106,40,26,200,30,203,204,227,161,230,164,198,132,159,93,2,176,175,108,109,139,73,185,119,150,83,84,62,236,123,57,196,129,130,9,183,180,114,198,131,132,29,203,35,209,101,34,35,69,3,19,193,207,141,151,85,87,21,134,67,68,21,195,30,204,206,139,140,154,88,59,233,169,102,103,24,198,97,31,1,175,39,213,164,98,106,39,40,71,5,150,84,153,86,87,106,67,159,160,98,99,102,198,214,215,233,234,97,207,195,196,105,107,132,133,192,121,122,190,191,55,99,206,207,54,87,88,13,14,63,149,150,156,157,143,62,63,66,67,24,27,234,235,196,38,39,211,212,176,222,186,187,99,160,232,233,109,46,216,217,234,235,66,71,72,137,138,150,106,56,3,4,188,124,170,171,58,66,67,2,3,191,95,96,205,206,61,134,37,38,76,200,201,142,143,108,187,189,190,198,131,171,64,160,236,141,179,234,195,48,227,86,103,122,230,225,95,84,233,235,21,80,10,79,183,227,95,182,216,142,173,191,38,45,31,191,195,152,155,123,84,167,100,64,110,75,227,48,121,144,174,105,123,194,200,26,234,184,132,76,12,59,186,195,131,79,224,94,189,22,166,204,89,31,236,75,78,10,206,41,99,55,56,17,110,49,147,148,165,184,58,46,47,157,146,54,55,57,83,142,72,141,4,5,49,157,3,4,38,204,13,100,107,93,13,17,213,214,217,185,145,146,229,162,125,126,172,137,48,49,110,183,235,236,167,185,203,16,22,88,55,56,6,194,137,138,74,121,8,17,193,140,141,46,156,10,11,84,228,25,26,151,93,57,58,137,140,120,89,25,139,114,187,167,51,3,102,29,52,188,214,23,206,167,19,20,198,199,221,58,74,75,93,94,197,67,55,56,205,207,232,233,52,221,222,50,51,169,155,199,66,67,154,187,188,113,114,163,9,10,16,17,3,162,163,166,167,124,127,94,95,56,138,139,71,72,36,82,46,47,199,20,92,93,146,76,77,94,95,166,171,172,237,238,206,156,103,104,48,224,30,31,158,166,167,102,103,51,195,196,65,66,161,234,137,138,176,60,61,2,3,208,47,49,50,20,221,74,12,13,112,129,147,148,21,11,121,110,19,21,46,47,106,36,104,105,209,13,121,208,2,167,168,217,64,70,71,57,217,220,221,178,181,149,110,193,125,126,90,136,100,101,13,74,146,147,200,131,148,149,220,226,51,52,20,210,158,102,38,84,85,126,212,221,156,157,105,10,119,120,48,215,48,192,230,115,56,57,22,101,103,104,42,3,96,35,190,134,151,170,33,143,132,41,43,69,128,58,127,231,35,143,230,24,190,239,86,93,210,79,239,3,200,203,171,186,132,215,148,112,158,123,35,96,169,222,153,171,2,8,74,42,232,180,124,60,107,234,3,179,127,32,142,237,70,214,12,137,79,44,123,126,176,113,92};
static const short Gen_shift_values_BG1_Z_256[2109]= {249,1,105,120,68,110,88,225,238,184,158,116,83,123,62,19,99,70,116,9,92,149,221,228,130,103,176,242,58,172,94,228,38,135,109,219,85,190,101,245,8,141,218,108,224,210,194,131,224,22,141,239,154,244,75,189,204,243,34,254,250,238,116,143,30,27,11,249,250,2,106,121,68,69,111,89,225,226,239,185,158,159,117,84,124,63,20,99,100,71,117,9,10,93,150,222,229,131,104,177,243,58,59,173,95,228,229,39,136,109,110,220,86,190,191,102,246,8,9,142,219,109,225,211,194,195,132,225,22,23,142,240,155,245,76,189,190,205,244,34,35,255,251,238,239,117,144,30,31,28,12,250,2,105,106,120,121,69,110,111,88,89,226,239,184,185,159,117,83,84,124,62,63,19,20,100,71,116,117,10,92,93,149,150,222,228,229,130,131,104,176,177,242,243,59,173,94,95,229,38,39,135,136,110,220,85,86,191,102,245,246,9,141,142,218,219,109,224,225,210,211,195,132,224,225,23,142,239,240,155,244,245,75,76,190,204,205,243,244,35,255,250,251,239,116,117,143,144,31,28,11,12,250,2,106,120,121,69,111,88,89,226,239,185,159,117,83,84,124,63,19,20,100,71,117,10,93,149,150,222,229,130,131,104,177,242,243,59,173,95,229,39,135,136,110,220,85,86,191,102,245,246,9,142,218,219,109,225,210,211,195,132,225,23,142,239,240,155,245,75,76,190,205,243,244,35,255,251,239,117,143,144,31,28,11,12,156,101,108,116,220,235,204,183,225,203,235,84,97,43,17,231,198,193,238,177,134,214,185,231,124,207,8,80,87,245,218,35,101,173,31,209,87,153,250,224,78,200,49,216,104,230,123,0,77,223,83,69,53,246,83,137,0,98,27,13,103,190,48,63,102,149,113,109,97,231,2,145,142,126,122,182,21,27,66,243,10,156,210,219,43,158,30,166,103,234,84,242,92,90,195,196,105,210,211,111,53,159,95,200,201,73,178,179,3,210,60,223,73,169,18,19,143,249,101,207,68,173,174,6,108,214,47,152,153,4,109,110,84,190,55,161,101,206,207,250,100,77,182,183,134,239,240,206,56,213,62,63,115,220,221,88,194,161,10,11,227,76,77,43,149,157,7,79,184,185,213,63,23,128,129,120,225,226,94,200,204,54,70,175,176,175,25,86,192,230,79,80,210,249,99,126,231,232,203,52,53,93,199,209,58,59,195,44,45,179,29,116,222,209,58,59,7,113,126,232,224,73,74,101,139,245,229,78,79,60,165,166,174,24,189,38,39,228,77,78,19,125,239,89,235,84,85,163,223,73,101,206,207,128,233,234,15,121,12,118,252,101,102,108,102,181,108,20,141,13,60,215,97,148,166,159,48,57,245,15,16,253,24,101,128,116,143,76,64,90,91,106,133,84,111,40,221,247,248,234,5,180,207,154,180,181,112,139,79,106,119,146,58,85,15,42,95,121,122,66,93,112,139,5,31,32,88,115,145,172,217,244,224,251,126,153,99,126,172,199,238,9,54,80,81,168,195,90,117,224,250,251,34,61,131,158,105,131,132,215,242,81,108,186,212,213,97,124,241,12,82,4,30,31,137,164,214,241,104,131,220,247,206,233,190,216,217,127,154,220,247,18,44,45,137,164,235,6,181,150,177,240,11,71,98,185,211,212,200,227,239,10,30,56,57,250,21,246,17,234,4,5,112,139,139,166,26,52,53,23,50,7,34,77,159,41,20,31,233,6,55,56,64,168,183,176,130,131,173,151,31,32,45,247,220,221,179,146,247,186,125,82,161,162,133,179,71,72,155,212,28,35,193,150,166,239,49,120,121,235,157,34,35,101,198,171,172,26,148,252,253,164,52,70,71,204,25,171,31,17,0,1,194,31,84,85,204,46,217,51,138,251,252,11,50,96,97,61,57,44,45,179,206,184,92,93,90,74,205,54,205,126,15,228,173,181,29,43,44,39,248,34,11,12,95,149,162,108,82,40,6,7,47,242,198,199,23,250,40,189,16,72,73,145,152,53,54,27,100,165,166,238,96,18,152,218,58,59,64,33,143,8,9,114,25,168,169,188,65,141,142,62,32,148,133,134,118,55,148,202,65,162,163,78,168,254,255,113,128,166,167,74,214,178,174,162,40,66,67,210,207,190,191,147,155,3,18,222,8,242,63,123,136,82,56,14,237,48,21,216,173,253,224,14,163,246,47,119,126,28,1,74,140,212,70,248,126,192,33,7,117,239,48,88,255,143,162,39,116,6,122,108,92,29,122,176,39,137,52,142,229,87,102,141,188,152,148,136,14,41,50,184,181,165,6,163,58,0,143,41,232,7,154,146,59,72,71,126,223,153,161,9,24,150,228,14,248,129,142,88,62,20,243,185,27,222,179,3,230,20,169,252,53,125,132,34,7,80,146,218,76,254,216,132,198,39,13,123,245,46,94,5,149,168,45,122,12,128,114,98,35,128,182,45,143,58,148,235,93,108,147,194,158,154,142,20,47,190,187,171,248,120,108,130,170,63,141,187,157,155,146,169,151,215,223,71,86,111,34,76,54,191,204,150,124,82,49,85,89,28,241,235,65,36,82,231,58,115,187,194,96,69,142,208,24,138,60,194,4,101,75,185,51,115,156,67,211,230,107,184,74,190,176,160,97,190,244,107,205,120,210,41,155,170,209,0,220,216,204,82,109,252,249,233,22,135,115,181,194,242,214,60,24,103,193,127,164,180,62,0,8,112,126,127,75,117,94,95,85,232,245,191,165,123,89,90,130,69,25,26,106,77,123,16,99,155,156,228,235,136,137,110,183,248,249,65,179,101,235,45,141,142,116,226,91,92,197,108,251,252,15,148,224,225,115,231,216,217,235,201,138,231,29,148,245,246,161,251,81,82,196,211,249,250,83,41,5,1,245,123,149,150,37,34,17,18,3,11,114,115,129,130,215,78,119,120,97,98,235,248,193,194,168,126,92,93,133,71,72,28,29,109,80,125,126,19,101,102,158,159,231,237,238,139,140,113,185,186,251,252,68,182,103,104,238,47,48,144,145,72,119,229,94,95,200,111,254,255,18,150,151,227,228,119,118,233,234,219,220,204,141,233,234,32,151,248,249,164,253,254,84,85,199,213,214,252,253,44,8,3,4,248,125,126,152,153,40,37,20,21,165,55,173,63,21,167,36,181,182,240,130,26,172,4,149,150,94,141,31,154,44,100,246,74,220,32,178,255,144,145,39,185,234,124,191,80,81,15,161,242,132,32,178,181,71,8,154,65,210,211,137,27,144,34,46,191,192,176,19,165,92,238,158,47,48,230,120,88,234,10,156,144,34,210,100,51,196,197,25,171,135,25,1,146,147,106,252,17,163,161,50,51,180,70,57,203,134,23,24,24,170,140,30,126,15,16,110,0,47,193,140,30,194,84,57,203,155,44,45,70,216,160,50,247,136,137,105,251,120,10,159,48,49,206,96,170,60,166,56,154,44,32,178,59,204,205,202,92,199,89,183,72,73,115,123,226,227,241,242,220,190,231,232,209,210,91,104,49,50,24,238,204,205,245,183,184,140,141,221,192,237,238,131,213,214,14,15,87,93,94,251,252,225,41,42,107,108,180,38,215,216,94,159,160,0,1,231,85,206,207,56,223,110,111,111,130,6,7,83,84,230,89,90,75,76,198,60,253,89,90,144,7,104,105,20,109,110,196,197,55,69,70,108,109,156,120,115,116,104,237,238,8,9,152,149,132,133,1,186,40,210,126,166,163,158,96,104,208,223,171,213,191,160,72,85,31,5,219,186,226,165,122,202,173,219,112,195,252,196,68,75,233,206,23,89,161,19,197,75,141,238,212,66,188,37,204,92,206,111,244,65,211,71,57,41,234,71,125,244,86,1,91,178,36,51,90,137,101,97,85,219,246,133,130,114,36,104,50,119,115,116,124,228,243,190,191,233,211,197,91,92,105,51,24,25,239,206,246,185,142,221,222,193,239,131,132,215,16,88,95,253,226,43,109,180,181,39,217,94,95,161,2,231,232,86,208,56,57,224,112,130,131,8,85,219,231,91,77,60,61,254,91,144,145,8,106,21,111,198,55,56,71,110,156,157,121,117,104,105,239,10,152,153,150,134,166,150,156,162,172,138,148,255,156,136,148,166,172,138,150,131,139,242,243,1,2,148,206,247,248,225,226,107,120,65,66,40,254,220,221,5,199,200,156,157,156,237,208,253,254,147,229,230,30,31,103,109,110,11,12,241,57,58,123,124,196,54,231,232,110,175,176,16,17,247,101,222,223,72,239,126,127,146,22,23,99,100,246,105,106,91,92,76,13,105,106,160,23,120,121,36,125,126,212,213,71,85,86,124,125,172,136,131,132,120,253,254,24,25,168,165,148,149,133,141,245,3,4,208,250,227,228,150,109,122,68,42,0,222,223,7,202,158,159,239,210,0,149,232,32,33,105,112,13,14,243,60,125,126,198,56,234,112,178,18,19,249,103,224,225,74,241,128,129,148,25,101,102,248,108,93,94,78,15,108,162,25,122,123,162,38,128,214,215,73,88,126,127,172,174,138,134,122,0,26,27,170,167,150,151,166,174,22,37,138,241,27,5,142,155,101,75,33,0,40,235,192,16,243,33,182,9,66,138,145,47,156,20,93,159,231,89,11,162,145,211,52,26,136,2,107,18,162,181,58,135,25,141,127,111,48,141,195,58,156,71,161,248,106,121,160,207,171,167,155,33,60,203,200,184,148,150,166};
static const short Gen_shift_values_BG1_Z_288[2109]= {210,178,257,186,197,166,144,187,161,219,185,222,165,255,132,107,218,159,242,3,201,81,75,217,131,201,62,196,28,116,287,143,2,40,115,108,161,215,14,56,114,73,35,71,228,114,232,151,287,143,157,241,146,215,164,94,268,287,215,155,199,72,233,112,260,118,107,210,211,179,258,187,197,198,167,145,187,188,162,220,185,186,223,166,256,133,108,218,219,160,243,3,4,202,82,76,218,132,202,63,197,28,29,117,0,143,144,3,41,115,116,109,162,215,216,15,57,114,115,74,36,72,229,115,232,233,152,0,143,144,158,242,147,216,165,94,95,269,0,215,216,156,200,72,73,234,113,260,261,119,108,211,179,257,258,186,187,198,166,167,144,145,188,162,219,220,186,223,165,166,256,132,133,107,108,219,160,242,243,4,201,202,81,82,76,217,218,131,132,202,62,63,196,197,29,117,287,0,144,2,3,40,41,116,109,161,162,216,15,56,57,115,73,74,35,36,72,228,229,114,115,233,152,287,0,144,158,241,242,147,215,216,164,165,95,268,269,287,0,216,156,199,200,73,233,234,112,113,261,119,107,108,211,179,258,186,187,198,167,144,145,188,162,220,186,223,165,166,256,133,107,108,219,160,243,4,202,81,82,76,218,131,132,202,63,196,197,29,117,0,144,3,40,41,116,109,161,162,216,15,56,57,115,74,35,36,72,229,114,115,233,152,0,144,158,241,242,147,216,164,165,95,269,287,0,216,156,200,73,234,112,113,261,119,107,108,245,234,66,34,113,42,260,53,22,0,180,43,17,75,41,78,21,71,111,276,251,74,15,98,147,57,225,219,73,275,57,206,52,172,260,143,287,146,184,259,252,17,71,158,200,282,258,217,179,215,84,258,88,7,143,287,13,97,253,2,71,20,238,124,143,71,11,55,216,89,256,116,262,251,78,79,143,168,89,58,176,150,107,168,188,153,183,103,163,152,265,120,233,199,23,24,128,240,241,53,139,252,108,220,221,86,198,199,287,129,242,103,216,161,273,274,127,240,164,277,107,219,220,251,197,22,74,186,187,49,161,162,160,273,101,214,184,8,9,233,58,143,255,256,23,135,136,17,130,159,271,272,73,185,186,143,256,4,116,117,138,250,251,258,83,58,171,229,53,54,85,198,232,56,57,270,94,95,57,170,50,163,103,215,216,157,270,244,69,286,110,111,40,56,169,15,127,128,265,89,90,13,126,170,282,283,56,168,169,174,287,93,206,229,53,54,85,198,99,212,183,7,8,97,88,201,157,269,270,106,218,219,36,149,210,34,35,229,53,54,157,270,97,210,141,253,254,45,14,127,175,287,0,54,166,167,202,27,60,173,49,161,162,14,161,158,92,133,44,131,75,208,177,0,27,266,233,200,249,236,237,217,205,8,284,225,213,54,236,223,224,205,193,183,171,22,226,213,214,200,188,258,246,224,211,212,261,249,204,192,6,282,171,159,146,134,257,244,245,198,186,281,269,42,29,30,240,228,120,108,114,102,256,244,170,158,240,228,101,89,235,223,67,54,55,155,143,38,26,182,169,170,41,29,79,67,154,141,142,147,135,200,188,254,241,242,53,41,95,83,273,153,140,141,112,100,74,62,110,98,267,255,153,141,271,258,259,190,178,38,26,182,169,170,196,184,280,268,180,185,173,254,242,203,191,133,120,121,19,7,38,26,254,241,242,194,182,238,226,111,98,99,272,260,151,139,11,286,287,157,145,146,134,272,224,161,243,150,237,242,246,247,215,6,223,230,233,234,203,181,223,224,198,256,221,222,259,202,287,4,169,144,254,255,196,279,39,40,238,118,112,254,168,215,238,99,233,64,65,153,36,179,180,39,77,151,152,145,198,251,252,51,93,150,151,110,72,108,265,151,268,269,188,36,179,180,194,278,183,252,201,130,131,17,36,251,252,192,236,108,109,270,149,46,8,9,155,144,287,185,252,15,287,78,275,243,34,250,251,169,262,231,208,209,287,252,226,284,250,287,229,230,32,197,171,172,283,224,19,68,266,145,146,140,282,195,196,266,127,260,261,93,181,64,208,67,104,105,182,180,173,225,226,280,79,120,121,179,138,99,100,107,136,5,178,179,9,216,64,208,222,17,18,211,280,228,229,159,45,63,64,67,280,220,264,137,10,176,177,37,183,171,172,210,178,257,186,197,166,144,269,187,161,219,185,222,165,12,255,132,107,218,159,242,3,201,81,75,217,131,201,62,196,28,116,287,143,2,40,115,108,161,98,215,14,56,114,73,35,71,228,114,232,151,287,143,157,241,146,215,164,94,268,287,215,155,199,72,233,112,53,260,118,107,152,136,287,287,161,160,150,287,240,143,287,287,117,143,287,150,118,197,126,264,137,106,84,127,101,159,125,162,105,80,195,72,47,158,99,182,231,141,21,15,157,71,141,2,136,256,56,227,89,83,230,268,55,48,101,143,155,242,284,54,13,263,11,168,54,172,91,227,83,97,181,86,155,104,34,208,227,155,95,139,12,173,52,200,58,47,63,45,265,8,17,71,188,71,256,179,287,287,164,210,178,257,186,235,197,166,144,187,161,219,185,222,165,198,255,132,107,287,218,159,242,3,201,81,75,217,131,201,62,196,28,116,287,143,2,40,115,108,161,265,215,14,56,114,73,35,71,228,114,232,151,287,143,157,241,146,215,164,94,268,287,215,155,199,72,233,112,260,118,107,204,287,287,182,287,287,287,276,44,35,71,274,287,154,61,253,221,12,228,229,240,209,186,187,287,230,204,262,228,265,207,208,10,175,149,150,261,202,285,46,244,123,124,118,260,173,174,244,105,238,239,71,159,42,186,45,82,83,158,151,203,204,258,57,98,99,157,116,77,78,114,271,156,157,179,275,194,42,186,200,283,284,189,258,206,207,137,23,41,42,287,258,198,242,115,276,154,155,15,161,149,150,96,64,142,143,71,72,287,83,51,52,29,30,73,47,104,105,71,108,50,51,141,17,18,280,281,104,45,127,128,177,86,87,254,255,249,102,103,16,17,87,235,236,81,82,202,2,172,173,29,175,176,213,214,89,1,282,46,47,101,188,229,230,0,246,247,208,209,251,245,113,114,287,0,118,37,172,173,29,43,126,127,32,100,101,49,50,268,153,154,172,173,101,41,84,85,246,118,119,285,286,146,4,280,281,88,230,56,198,135,277,64,205,206,75,217,44,186,22,163,164,143,65,207,39,181,97,239,63,205,100,242,43,184,185,133,275,10,152,273,126,127,96,238,37,179,120,262,169,23,79,221,247,100,101,241,95,95,237,9,150,151,143,79,221,228,82,74,215,216,194,48,282,136,165,19,21,163,168,22,206,59,60,281,135,274,128,39,180,181,93,235,180,34,222,75,76,280,134,239,93,201,54,55,237,91,106,248,280,133,134,110,252,29,171,165,19,21,163,35,177,119,260,261,24,166,93,235,42,183,184,260,114,146,0,165,18,19,93,235,33,175,77,219,238,92,111,253,278,131,132,138,280,284,138,273,126,127,85,53,131,132,60,61,287,72,40,41,18,19,62,36,93,94,60,97,39,40,130,6,7,269,270,93,34,116,117,166,75,76,243,244,238,91,92,5,6,76,224,225,70,71,191,279,161,162,18,164,165,202,203,278,271,35,36,90,177,218,219,210,277,235,236,197,198,234,102,103,276,277,35,107,26,161,162,18,32,115,116,21,89,90,38,39,257,142,143,161,162,90,30,73,74,235,107,108,274,275,135,281,269,270,287,287,75,17,196,287,107,287,127,95,174,103,114,83,61,198,104,78,136,102,139,82,172,49,24,135,76,159,208,118,286,277,280,134,48,118,267,113,233,33,204,60,207,245,32,25,78,132,219,261,287,31,278,240,276,145,31,149,68,204,60,74,158,63,132,81,11,185,204,132,72,116,277,150,29,177,35,24,215,15,287,287,210,211,179,258,187,197,198,167,145,71,187,188,162,220,185,186,223,166,256,133,108,218,219,160,243,3,4,202,82,76,218,132,202,63,197,28,29,117,0,143,144,3,41,115,116,109,162,215,216,15,57,114,115,74,36,143,72,229,115,232,233,152,0,143,144,158,242,147,216,165,94,95,269,0,215,216,156,200,72,73,234,113,260,261,119,108,189,287,287,287,152,287,164,116,215,143,1,287,287,287,182,246,214,4,5,221,222,26,233,201,202,179,180,223,197,254,255,221,258,200,201,3,167,168,142,143,287,254,195,277,278,39,236,237,116,117,111,252,253,166,167,237,97,98,231,232,64,152,34,35,179,37,38,75,76,151,144,196,197,251,50,91,92,150,108,109,70,71,107,263,264,149,150,268,187,34,35,179,193,276,277,182,250,251,199,200,130,15,16,34,35,251,191,234,235,108,268,269,147,148,8,154,142,143,193,161,240,168,169,180,149,126,127,51,170,144,202,168,205,147,148,238,115,89,90,201,142,225,274,184,63,64,58,200,113,114,184,45,178,179,11,99,270,126,273,22,23,98,91,143,144,198,285,38,39,97,56,17,18,54,211,96,97,215,134,270,126,140,223,224,242,129,198,146,147,77,251,269,270,287,198,138,182,55,216,94,95,243,101,89,90,267,235,26,243,17,254,223,201,244,218,276,242,279,222,24,189,164,275,216,11,60,258,138,132,274,188,287,258,119,253,85,173,56,287,200,59,97,172,165,218,272,71,113,171,130,92,128,285,171,1,208,56,200,214,10,203,272,221,151,37,56,272,212,256,129,2,169,29,175,164,167,287,143};
static const short Gen_shift_values_BG1_Z_320[2109]= {72,302,67,219,14,6,207,102,293,79,48,26,29,260,279,196,239,160,37,38,226,60,132,201,174,3,199,78,14,79,70,161,105,280,214,128,302,163,299,252,132,294,163,75,282,52,297,265,300,109,71,43,82,183,27,112,245,76,15,259,229,188,275,318,31,300,67,72,73,303,68,220,14,15,7,208,102,103,294,80,48,49,27,30,261,280,197,239,240,161,38,38,39,227,61,133,202,175,4,200,79,14,15,80,71,161,162,106,281,214,215,129,303,163,164,300,253,132,133,295,164,76,283,53,297,298,266,301,109,110,72,44,83,184,28,112,113,246,77,15,16,260,230,188,189,276,319,31,32,301,68,73,303,67,68,219,220,15,6,7,207,208,103,294,79,80,49,27,29,30,261,279,280,196,197,240,161,37,38,39,226,227,60,61,133,201,202,174,175,4,199,200,78,79,15,80,70,71,162,105,106,280,281,215,129,302,303,164,300,252,253,133,294,295,163,164,76,282,283,52,53,298,266,300,301,110,72,43,44,83,183,184,27,28,113,245,246,76,77,16,260,229,230,189,275,276,318,319,32,301,67,68,73,303,68,219,220,15,7,207,208,103,294,80,49,27,29,30,261,280,196,197,240,161,38,39,227,60,61,133,202,174,175,4,200,78,79,15,80,71,162,106,280,281,215,129,302,303,164,300,252,253,133,295,163,164,76,283,52,53,298,266,301,110,72,43,44,83,184,27,28,113,246,76,77,16,260,230,189,276,318,319,32,301,67,68,232,204,31,261,26,178,82,293,285,166,291,61,252,38,7,305,308,49,219,238,155,198,119,316,317,185,19,91,160,133,282,158,37,293,38,29,120,64,239,173,87,261,122,258,211,317,91,253,122,34,241,11,256,224,259,68,30,2,200,41,142,306,71,204,35,294,218,188,147,234,277,310,259,26,266,288,20,292,12,231,301,137,234,11,87,206,49,24,75,317,227,227,137,312,221,222,144,53,54,294,259,169,251,160,161,132,41,42,132,27,257,218,128,4,233,234,293,203,271,181,274,183,184,129,185,95,204,113,114,121,30,31,164,74,85,315,282,191,192,283,193,151,60,61,305,214,215,57,287,126,35,36,99,8,9,248,158,124,33,34,3,232,233,259,169,4,234,315,224,225,86,316,30,259,260,205,114,115,139,49,53,283,227,136,137,88,318,224,134,177,86,87,230,57,287,219,128,129,88,317,318,0,230,207,116,117,297,206,207,222,132,190,100,225,134,135,34,264,316,226,288,197,198,295,7,237,108,17,18,272,181,182,37,267,170,79,80,1,230,231,260,170,184,94,154,63,64,109,113,23,200,109,110,243,152,153,276,186,225,135,312,221,222,268,188,243,35,285,150,266,134,208,13,79,210,74,160,310,115,32,33,25,263,110,28,262,180,15,57,294,295,49,287,250,168,146,145,62,63,16,254,122,40,91,8,9,69,307,72,310,303,221,2,240,239,157,282,199,200,203,121,80,318,81,318,319,269,187,103,21,175,93,244,162,217,135,46,284,242,160,121,39,57,294,295,122,40,113,31,204,121,122,148,66,3,241,257,174,175,171,89,25,263,206,123,124,22,260,295,213,289,175,92,93,17,255,206,124,118,36,5,243,95,13,20,257,258,308,226,23,261,152,69,70,114,32,86,4,288,125,43,226,144,70,308,155,72,73,288,206,119,37,58,295,296,302,220,272,190,231,148,149,318,236,41,279,74,311,312,23,261,110,28,176,228,234,168,47,104,51,109,110,20,105,257,38,51,52,44,245,139,140,11,117,85,86,64,67,301,298,317,234,276,277,198,75,75,76,264,98,170,239,212,302,41,237,116,51,52,117,108,198,199,143,318,251,252,166,20,200,201,17,290,169,170,12,201,113,0,90,14,15,303,18,146,147,109,81,120,221,65,149,150,283,114,52,53,297,267,225,226,313,36,159,68,69,18,105,77,298,53,60,178,257,124,34,119,270,271,228,66,58,258,259,289,154,25,131,100,78,80,81,312,11,247,248,291,212,89,90,278,111,112,184,253,225,226,55,251,129,130,66,131,122,213,157,11,12,59,266,180,33,34,215,31,303,304,184,26,214,215,129,127,14,103,104,29,317,32,161,123,94,95,134,235,78,79,164,297,127,128,183,67,311,281,240,7,49,50,83,32,118,119,52,282,47,199,314,306,187,68,82,273,59,28,6,9,139,240,259,176,219,140,17,18,206,40,112,181,154,303,179,58,314,59,50,141,85,260,194,108,282,44,143,279,232,112,274,143,55,262,32,277,245,280,89,51,23,62,163,7,92,225,56,315,239,209,168,255,298,114,11,280,47,256,146,127,50,227,259,293,290,140,294,63,180,100,269,40,82,312,77,229,300,24,16,217,112,303,89,58,36,39,161,270,289,206,249,170,47,48,236,70,142,211,184,13,209,88,24,89,80,39,171,115,290,224,138,312,129,173,309,262,142,304,173,85,292,62,307,275,310,119,81,53,92,193,37,122,255,86,25,269,239,198,285,8,41,310,77,78,174,131,282,102,176,19,54,315,248,49,132,104,33,263,28,180,288,295,287,168,63,254,40,9,307,310,279,221,240,157,109,200,121,318,319,187,21,93,162,135,284,160,39,295,40,31,122,66,241,175,89,263,186,124,260,213,93,255,124,36,243,13,258,226,261,70,32,4,43,144,308,73,206,37,296,220,190,149,236,279,312,261,28,171,294,95,45,269,109,317,66,209,28,303,10,292,49,233,102,12,97,248,249,44,36,236,237,26,132,3,109,78,56,58,59,290,309,225,226,269,190,67,68,256,89,90,162,231,203,204,33,229,107,108,44,109,100,191,135,309,310,244,158,11,12,193,9,281,282,162,4,192,193,105,312,81,82,307,7,295,10,139,101,72,73,112,213,56,57,142,275,105,106,116,45,289,259,218,305,27,28,61,10,96,97,208,118,202,203,34,35,90,150,141,142,22,23,238,109,214,215,184,162,164,165,76,94,95,11,12,55,296,172,173,174,41,42,195,196,268,16,17,309,310,139,14,15,213,214,150,215,205,206,297,240,241,95,96,22,30,264,117,118,299,115,67,68,268,109,110,298,299,104,211,97,98,187,188,113,81,115,116,245,207,178,179,218,318,319,162,163,248,60,61,211,212,151,75,44,45,4,90,91,133,134,167,116,202,203,138,235,48,145,133,230,285,61,62,80,177,72,169,273,49,50,221,168,265,39,136,145,242,114,211,92,189,95,191,192,6,103,25,122,262,38,39,305,82,226,3,103,200,104,201,292,69,126,222,223,198,295,267,44,240,16,17,307,69,166,265,42,144,240,241,80,177,145,242,136,233,227,4,171,268,26,122,123,280,57,194,291,48,144,145,229,6,45,142,318,94,95,198,295,40,137,229,5,6,141,238,28,125,118,214,215,43,140,11,108,46,143,175,272,137,234,109,205,206,148,245,249,26,93,189,190,178,275,311,88,142,238,239,81,178,5,102,295,72,254,31,21,118,64,160,161,97,194,46,143,133,229,230,290,200,284,285,116,117,209,232,223,224,104,105,0,191,296,297,266,244,246,247,158,176,177,93,94,137,58,254,255,256,123,124,277,278,30,98,99,71,72,221,96,97,295,296,232,297,287,288,59,2,3,177,178,112,26,199,200,61,197,149,150,21,30,191,192,60,61,293,179,180,269,270,270,195,163,197,198,7,289,260,261,300,80,81,244,245,10,142,143,293,294,233,157,126,127,86,172,173,215,216,249,198,284,285,169,19,139,32,186,295,4,43,37,267,32,184,299,291,172,206,67,258,44,13,311,314,225,244,161,204,125,2,3,191,25,157,97,166,139,288,164,43,299,44,35,126,70,245,179,93,267,128,264,217,54,97,259,128,40,247,17,262,230,265,74,36,8,47,148,312,77,210,41,300,224,194,153,240,283,316,265,32,258,178,177,159,187,188,98,183,15,129,130,122,3,297,217,218,89,195,163,164,142,145,56,75,312,34,35,276,153,153,154,22,176,248,317,290,119,315,194,129,130,195,186,276,277,221,76,9,10,244,98,278,279,95,48,247,248,90,279,14,191,78,168,92,93,61,96,224,225,187,159,198,299,143,227,228,41,192,130,131,55,25,303,304,71,114,146,147,96,183,150,178,63,180,101,76,191,207,31,79,196,153,46,123,206,199,109,193,194,25,26,225,141,132,133,13,14,229,100,205,206,175,153,155,156,67,85,86,2,3,64,46,287,163,164,165,32,33,186,187,259,7,8,300,301,130,5,6,204,205,141,206,196,197,288,231,232,86,87,21,255,108,109,290,106,58,59,259,100,101,289,290,202,88,89,178,179,104,72,106,107,236,198,169,170,209,309,310,153,154,239,51,52,202,203,142,66,35,36,315,81,82,124,125,158,107,193,194,175,85,170,1,2,117,109,309,310,227,205,76,182,151,129,131,132,43,62,298,299,22,263,140,141,9,162,163,235,304,276,277,106,302,180,181,117,182,173,264,208,62,63,317,231,84,85,266,82,34,35,235,77,265,266,178,65,154,155,80,48,83,212,174,145,146,68,185,286,129,130,215,28,178,179,175,118,42,12,291,58,100,101,134,83,169,170,12,242,7,159,233,274,266,147,42,233,19,308,286,289,200,219,136,179,100,297,298,166,0,72,141,114,226,263,139,18,274,19,10,258,101,45,220,154,68,242,103,239,192,72,234,103,15,222,312,237,205,240,49,11,303,22,123,287,52,185,16,275,199,169,128,215,258,291,240,7,100,227,125};
static const short Gen_shift_values_BG1_Z_352[2109]= {293,76,225,96,117,34,93,166,224,212,329,95,48,337,301,278,206,267,110,164,264,138,111,127,165,301,236,90,242,49,293,249,126,105,0,166,245,338,252,344,200,109,268,333,285,184,52,241,124,346,256,248,132,130,214,303,162,142,166,8,209,46,6,120,187,301,120,293,294,77,226,97,117,118,35,94,166,167,225,213,329,330,96,49,338,302,279,206,207,268,111,164,165,265,139,112,128,166,302,237,91,242,243,50,294,249,250,127,106,0,1,167,246,338,339,253,345,200,201,110,269,334,286,185,52,53,242,125,346,347,257,249,133,131,215,303,304,163,143,166,167,9,210,46,47,7,121,187,188,302,121,294,77,225,226,96,97,118,34,35,93,94,167,225,212,213,330,96,48,49,338,301,302,278,279,207,268,110,111,165,264,265,138,139,112,127,128,165,166,302,236,237,90,91,243,50,293,294,250,126,127,105,106,1,167,245,246,339,253,344,345,201,109,110,268,269,334,285,286,184,185,53,242,124,125,347,257,248,249,133,130,131,214,215,304,162,163,142,143,167,9,209,210,47,6,7,120,121,188,302,120,121,294,77,226,96,97,118,35,93,94,167,225,213,330,96,48,49,338,302,278,279,207,268,111,165,265,138,139,112,128,165,166,302,237,90,91,243,50,294,250,127,105,106,1,167,245,246,339,253,344,345,201,110,268,269,334,286,184,185,53,242,125,347,257,248,249,133,131,214,215,304,163,142,143,167,9,210,47,7,120,121,188,302,120,121,41,255,224,7,156,27,218,48,317,24,129,97,155,143,260,26,331,250,268,232,209,137,198,41,95,195,69,42,58,96,232,167,21,173,332,224,180,57,36,283,97,176,269,183,275,321,131,40,199,264,216,115,335,172,55,277,187,179,294,63,61,145,234,93,73,97,291,140,329,289,51,118,232,51,257,293,72,329,98,171,149,283,304,2,102,223,296,214,38,255,186,38,321,187,117,118,58,340,341,347,79,10,348,278,279,55,337,338,74,128,59,186,117,174,104,105,291,222,57,340,10,292,293,21,299,230,263,193,194,240,170,171,168,99,229,160,72,2,3,126,57,226,156,157,100,30,31,73,4,89,19,20,127,57,58,263,194,198,128,129,52,334,335,204,135,11,294,255,185,186,211,142,88,18,19,67,349,350,314,245,128,59,207,137,138,300,231,214,145,306,236,237,311,162,93,71,1,2,230,160,161,295,226,247,177,178,146,76,77,14,297,203,134,86,16,17,308,239,218,149,210,140,141,223,94,25,92,22,23,176,106,107,265,196,124,54,55,104,34,35,128,59,322,253,171,101,102,16,8,291,320,250,251,82,12,13,149,80,263,194,82,12,13,58,155,87,292,110,91,151,22,336,174,252,26,230,48,266,279,133,134,62,269,211,66,82,289,24,103,309,310,20,227,79,286,321,152,6,7,210,65,198,53,315,169,170,81,288,34,241,323,178,287,142,264,119,192,46,47,253,108,96,303,150,4,5,250,105,124,331,97,304,113,320,151,6,287,142,222,77,76,283,228,82,83,35,242,279,134,235,89,90,112,319,91,298,338,192,193,152,7,231,86,324,178,179,238,93,330,185,199,186,40,41,95,302,254,109,319,174,271,126,170,25,38,244,245,227,82,110,317,332,186,187,242,97,234,89,350,118,325,116,323,200,55,289,143,144,148,3,128,335,152,6,7,346,201,195,50,32,238,239,344,199,106,313,173,27,28,287,142,106,313,165,122,216,141,109,175,75,22,23,158,307,178,310,198,199,116,175,247,248,306,294,58,59,177,130,250,67,31,8,287,288,349,192,245,246,346,220,193,209,247,264,31,318,172,323,324,131,23,330,331,208,187,81,82,248,327,67,68,334,74,281,282,191,350,63,15,266,133,134,323,206,75,76,338,330,214,212,296,32,33,244,224,247,248,90,291,127,128,88,202,93,268,269,31,202,21,321,276,155,65,77,55,190,339,209,210,175,231,148,206,207,347,280,338,326,91,209,161,162,99,63,39,40,320,29,224,278,26,251,252,225,241,278,279,63,350,203,204,4,163,55,11,240,218,219,14,114,280,6,7,100,14,105,106,314,223,29,30,80,95,47,297,298,166,3,238,108,18,9,10,246,244,327,328,65,276,255,256,175,280,122,323,160,120,233,234,301,63,233,234,55,190,339,210,231,148,207,189,280,338,326,91,209,162,292,99,63,40,320,29,224,278,26,252,225,241,279,63,350,204,4,163,55,11,240,219,114,280,7,331,100,14,106,314,223,30,95,47,298,166,3,238,108,18,10,246,244,328,65,276,256,280,122,323,160,120,234,330,301,63,234,109,227,246,115,189,46,285,245,180,72,86,109,146,257,203,323,106,255,126,88,147,64,123,196,254,242,7,125,78,64,15,331,308,236,297,140,194,294,168,141,157,195,331,266,120,272,79,323,154,279,156,135,30,196,275,243,16,282,22,230,139,298,11,315,214,82,271,154,24,286,278,162,160,244,333,192,172,196,38,239,76,36,150,217,331,150,161,263,345,142,108,279,156,235,112,17,5,180,303,135,270,67,290,37,311,228,287,8,66,54,171,289,242,169,179,143,120,248,48,109,304,6,106,332,305,321,7,143,78,284,84,243,135,91,320,299,194,8,87,287,180,94,186,42,303,110,175,127,26,246,83,318,188,98,90,326,324,56,145,4,336,8,202,51,240,200,314,29,143,314,278,254,110,53,324,325,225,98,90,325,267,101,0,39,166,49,184,333,203,204,225,142,200,201,272,274,332,320,85,203,155,156,93,57,33,34,314,23,218,272,20,245,246,219,235,272,273,57,344,197,198,350,157,49,5,234,212,213,108,274,0,1,94,8,99,100,308,217,23,24,89,41,291,292,103,160,349,232,102,12,3,4,240,238,321,322,59,270,249,250,242,274,116,317,154,114,227,228,295,57,227,228,154,289,85,86,308,309,170,330,246,247,305,306,27,85,72,73,190,308,260,261,198,161,162,138,139,67,128,322,323,25,124,125,350,351,324,339,340,25,26,162,96,97,302,303,103,262,153,154,110,338,339,317,318,15,213,27,105,106,199,113,204,205,61,321,322,128,129,94,194,145,146,44,45,265,102,336,337,207,117,108,109,345,342,343,74,75,164,22,23,2,3,27,221,69,70,259,218,219,332,333,48,162,332,333,220,164,3,299,152,96,23,318,319,44,340,313,257,20,315,316,100,93,37,151,95,139,83,256,200,22,318,327,270,271,264,208,228,172,205,148,149,133,77,194,138,37,333,91,35,191,135,65,8,9,38,334,54,350,92,35,36,296,228,172,163,107,17,312,313,169,113,328,272,220,164,176,120,53,349,32,327,328,279,223,93,37,172,115,116,265,209,179,123,271,214,215,127,71,36,332,195,138,139,260,204,212,156,111,54,55,331,275,168,112,51,347,273,217,183,127,175,118,119,59,3,57,1,141,84,85,230,174,89,33,69,12,13,93,37,287,231,136,80,325,269,285,229,47,342,343,114,58,228,172,47,342,343,25,160,308,309,179,180,350,201,117,118,176,177,250,308,295,296,61,179,131,132,69,32,33,9,10,290,351,193,194,248,347,348,221,222,195,210,211,248,249,33,319,320,173,174,326,133,24,25,333,209,210,188,189,84,250,328,329,70,336,75,76,264,284,192,193,351,0,65,16,17,267,268,337,136,325,207,208,78,340,331,332,216,213,214,297,298,35,245,246,225,226,250,92,292,293,130,89,90,203,204,271,33,203,204,55,303,140,100,59,319,111,53,209,344,141,12,33,302,9,99,82,140,128,245,11,316,253,217,194,122,183,26,80,180,54,209,27,43,81,217,152,6,158,317,209,165,42,21,268,82,161,254,168,260,194,116,25,184,249,201,100,320,157,40,262,172,164,48,46,130,219,78,58,82,276,125,314,274,36,103,217,36,134,14,34,187,26,27,162,311,182,202,203,120,179,318,251,252,310,298,62,63,181,134,71,35,12,291,292,1,196,249,250,350,224,197,213,251,35,322,176,327,328,135,27,334,335,212,191,85,86,252,331,71,72,338,78,285,286,195,2,235,67,19,270,137,138,327,210,79,80,342,334,218,216,300,36,37,248,228,251,252,94,295,131,132,92,206,272,273,35,206,163,195,208,245,235,263,36,271,303,236,134,122,76,24,271,311,94,242,243,113,114,287,135,51,52,110,111,184,242,229,230,347,113,65,66,3,318,319,295,296,82,224,285,127,128,182,281,282,155,156,129,144,145,182,183,319,253,254,107,108,260,67,310,311,267,143,144,122,123,18,184,262,263,4,270,9,10,218,126,127,285,286,351,302,303,201,202,70,259,141,142,12,274,265,266,150,147,148,231,232,321,179,180,159,160,184,26,226,227,64,23,24,137,138,205,319,137,138,109,244,41,263,264,285,202,260,261,209,334,40,28,145,263,215,216,153,117,93,94,22,83,278,332,80,305,306,279,295,332,333,117,52,257,258,58,217,109,65,294,272,273,168,334,60,61,154,68,159,160,16,277,83,84,149,101,351,0,220,57,292,162,72,63,64,2,300,298,29,30,119,330,309,310,52,334,176,25,214,174,287,288,3,117,287,288,213,348,145,16,78,37,306,13,86,144,132,249,15,320,257,221,198,126,187,30,84,184,58,31,47,85,243,221,156,10,162,321,213,292,169,46,25,272,86,165,258,172,264,120,29,188,253,205,104,324,161,44,266,176,168,52,50,134,223,82,62,86,280,129,318,278,40,107,221,40,81,66,234};
static const short Gen_shift_values_BG1_Z_384[2109]= {306,75,204,275,18,249,86,49,75,327,368,72,383,287,331,274,180,143,255,215,160,198,330,266,152,330,159,55,316,177,62,287,128,131,108,294,304,16,341,230,356,199,340,216,87,211,214,98,52,105,353,303,113,130,299,241,239,270,179,330,204,329,12,38,345,111,356,306,307,76,205,276,18,19,250,87,49,50,76,328,368,369,73,0,288,332,275,180,181,144,256,215,216,161,199,331,267,153,331,160,56,316,317,178,63,287,288,129,132,108,109,295,305,16,17,342,231,356,357,200,341,217,88,212,214,215,99,53,105,106,354,304,114,131,300,241,242,240,271,179,180,331,205,329,330,13,39,345,346,112,357,307,76,204,205,275,276,19,249,250,86,87,50,76,327,328,369,73,383,0,288,331,332,274,275,181,144,255,256,216,160,161,198,199,331,266,267,152,153,331,159,160,55,56,317,178,62,63,288,128,129,131,132,109,295,304,305,17,342,230,231,357,199,200,340,341,217,87,88,211,212,215,99,52,53,106,354,303,304,114,130,131,299,300,242,239,240,270,271,180,331,204,205,330,12,13,38,39,346,112,356,357,307,76,205,275,276,19,250,86,87,50,76,328,369,73,383,0,288,332,274,275,181,144,256,216,161,198,199,331,267,152,153,331,160,55,56,317,178,63,288,129,131,132,109,295,304,305,17,342,230,231,357,200,340,341,217,88,211,212,215,99,53,106,354,303,304,114,131,299,300,242,240,270,271,180,331,205,330,13,38,39,346,112,356,357,331,180,79,232,361,48,194,175,22,243,13,206,232,100,141,229,156,114,60,104,47,337,300,28,372,317,355,103,39,309,103,316,212,89,334,219,60,285,288,265,67,77,173,114,3,165,129,356,113,373,244,368,371,255,209,262,126,76,240,270,287,72,14,12,43,336,103,361,102,169,195,118,268,129,50,277,256,0,350,91,252,17,224,8,61,315,332,289,113,373,93,142,246,271,374,375,342,61,62,306,85,189,316,35,36,153,256,257,178,116,220,142,246,10,113,114,51,155,139,243,66,169,170,164,354,74,14,117,118,341,60,61,247,351,210,314,322,41,42,282,2,227,330,331,265,368,369,13,117,333,52,53,219,322,323,13,117,226,329,330,122,225,226,383,103,244,348,129,232,233,354,74,195,298,299,198,301,302,175,279,361,81,371,90,91,83,187,24,128,297,16,17,17,39,143,266,369,370,23,126,127,283,3,154,257,258,278,381,382,281,1,165,269,119,222,223,172,276,36,140,370,89,90,38,180,284,197,300,301,366,85,86,308,28,306,25,26,337,56,57,246,350,13,117,271,374,375,223,12,116,79,182,183,105,208,209,28,132,178,282,39,142,143,367,365,231,320,132,56,302,62,81,100,338,273,110,382,353,256,37,38,25,191,154,320,225,7,47,352,133,134,199,365,36,202,101,383,164,165,25,191,277,59,318,99,100,22,188,333,115,237,19,281,63,224,6,130,295,296,93,259,205,371,165,330,331,110,276,148,314,280,62,216,382,102,268,280,62,109,275,5,171,266,47,48,127,293,12,178,237,18,19,78,244,81,247,58,223,224,244,26,254,36,350,131,132,291,73,180,346,7,306,87,88,149,315,290,72,166,332,37,203,161,327,164,329,330,48,214,2,168,55,220,221,303,85,253,35,46,63,229,80,246,249,31,191,356,357,189,355,220,2,129,294,295,280,62,154,320,279,60,61,346,128,372,154,295,76,77,61,227,306,88,187,76,185,173,231,49,73,292,293,62,191,262,312,4,5,236,73,35,36,62,314,354,355,59,370,176,274,318,261,166,167,130,242,201,202,147,185,317,253,139,265,317,146,42,302,303,164,49,273,274,115,118,94,95,281,291,2,3,328,217,342,343,186,327,203,74,198,200,201,85,39,91,92,340,290,100,117,286,227,228,226,257,165,166,317,191,315,316,383,25,114,331,332,98,343,141,247,136,88,346,11,192,345,90,160,161,240,288,135,355,356,1,319,345,213,254,342,268,269,173,217,159,160,66,29,141,101,46,83,84,216,152,37,38,216,45,324,325,202,63,332,173,14,16,17,209,378,180,189,190,286,227,115,116,242,85,225,226,317,102,357,96,97,100,368,322,375,239,188,189,383,16,184,185,127,125,155,156,54,65,216,90,215,282,307,308,231,381,241,242,363,132,261,332,75,306,143,12,106,132,0,41,129,56,337,344,4,331,237,200,312,272,217,255,3,323,209,3,216,112,373,234,119,344,185,188,165,351,361,56,73,14,287,29,256,13,273,144,268,271,155,109,162,26,360,170,187,356,298,296,327,236,3,261,2,69,95,288,18,168,29,259,302,80,357,374,129,162,279,131,3,144,212,343,241,196,365,134,263,334,186,77,308,145,108,134,2,43,131,58,205,346,6,333,239,202,314,274,219,257,5,325,211,5,218,114,375,236,121,263,346,187,190,167,353,363,340,75,16,289,31,258,15,275,146,270,273,157,111,164,28,362,172,189,358,300,298,329,238,5,263,4,71,97,20,170,31,204,101,327,212,96,29,10,232,21,23,88,60,26,156,309,54,125,297,252,99,320,283,309,177,218,306,233,157,137,181,124,234,30,377,105,65,10,48,180,116,2,180,9,289,166,27,296,137,362,365,342,144,154,338,250,191,80,206,49,190,66,321,61,64,332,286,339,203,153,347,364,149,91,89,120,29,180,54,179,246,272,195,345,206,71,16,382,311,70,80,75,135,193,193,100,221,18,243,273,1,154,283,353,354,97,328,164,165,251,128,154,22,63,151,77,78,366,26,352,353,259,222,334,294,239,276,277,25,345,230,231,25,238,133,134,11,256,141,366,207,209,210,187,373,382,383,95,36,308,309,51,278,34,35,295,166,289,290,4,293,177,131,184,48,381,382,192,209,377,378,320,318,348,349,146,258,25,283,24,91,116,117,40,190,50,51,13,166,294,295,365,366,158,109,339,340,176,177,140,166,33,34,75,163,89,90,378,37,38,364,365,271,234,345,346,306,250,251,288,289,37,356,357,242,243,37,249,250,145,146,23,268,152,153,378,218,219,221,222,228,199,1,10,11,107,48,320,321,63,289,290,46,47,259,307,177,178,301,302,305,189,142,143,196,60,9,10,204,220,221,5,6,332,329,330,360,361,270,37,294,295,36,102,103,128,129,52,202,62,63,180,179,333,332,78,77,149,147,148,276,275,123,122,344,342,343,99,307,306,333,332,201,200,242,241,330,329,257,255,256,161,160,205,204,148,146,147,54,53,17,16,129,128,89,88,34,33,72,70,71,204,203,140,139,26,24,25,214,204,203,33,32,313,311,312,190,189,51,50,320,319,161,160,2,1,5,3,4,366,365,168,167,178,176,177,274,273,215,214,104,102,103,230,229,73,72,214,212,213,90,89,345,344,85,83,84,88,87,356,355,310,309,363,362,227,226,177,175,176,371,370,4,3,173,171,172,115,114,113,112,144,142,143,53,52,204,203,78,77,203,202,270,269,296,294,295,219,218,369,368,230,228,229,210,363,107,108,178,179,101,306,152,153,373,374,337,363,230,231,272,360,286,287,191,234,235,177,178,84,47,158,159,119,63,64,101,102,234,169,170,55,56,234,62,63,342,343,220,81,349,350,191,31,32,34,35,12,198,207,208,304,245,133,134,200,260,102,103,243,244,120,374,375,114,115,174,118,2,339,340,9,257,206,207,17,33,34,202,203,145,142,143,173,174,83,234,107,108,233,299,300,325,326,249,15,259,260,322,7,360,104,229,147,201,311,188,341,86,157,284,131,352,319,315,341,209,250,338,265,169,213,156,62,25,137,97,42,80,334,212,148,34,212,41,321,198,59,328,169,10,13,374,176,186,282,223,112,1,238,81,222,98,353,93,96,364,318,371,235,185,379,12,181,123,121,152,61,212,86,211,278,304,227,377,238,209,312,296,20,37,38,191,320,7,133,134,365,202,268,164,165,191,59,99,100,188,115,19,63,6,295,296,259,371,330,331,276,314,62,382,268,62,275,171,47,48,293,178,18,19,244,247,223,224,26,36,131,132,73,346,87,88,315,72,81,332,203,327,329,330,214,168,220,221,85,35,229,246,31,356,357,355,2,294,295,62,320,60,61,128,154,76,77,227,88,184,176,288,213,257,92,345,296,174,36,311,51,313,138,287,141,294,38,39,109,110,112,237,83,84,304,305,268,294,161,162,203,291,217,218,122,165,166,108,109,13,15,362,89,90,50,378,379,32,33,165,100,101,370,371,165,377,378,273,274,151,12,280,281,122,346,347,349,350,327,129,138,139,235,176,64,65,191,33,34,174,175,51,305,306,45,46,49,317,270,271,324,188,137,138,332,348,349,133,134,76,73,74,104,105,14,165,38,39,164,230,231,256,257,180,330,190,191,91,244,373,59,60,187,34,254,255,112,218,244,112,153,241,167,168,72,116,58,59,349,312,40,0,329,366,367,115,51,320,321,115,328,223,224,101,346,231,72,297,299,300,277,79,88,89,185,126,14,15,141,368,124,125,1,256,379,380,383,267,221,274,138,87,88,131,282,299,83,84,26,24,54,55,113,348,115,373,114,181,206,207,130,280,140,141,196,349,94,165,79,292,139,360,323,349,217,258,346,273,177,221,164,70,33,145,105,50,88,220,156,42,77,220,49,329,206,67,336,162,177,18,21,382,184,194,290,231,120,246,89,230,106,361,101,104,372,326,379,243,193,3,20,189,131,129,160,69,220,94,219,286,312,235,1,246,134,148,14};

static const short no_shift_values_BG2[420]= {3,3,2,3,3,2,3,2,3,3,4,4,3,4,3,2,4,2,3,4,5,4,3,5,4,3,5,3,4,5,3,4,3,3,4,3,4,3,4,4,5,5,3,4,3,2,4,2,3,4,5,5,3,4,3,3,4,3,3,4,5,4,3,4,3,3,4,3,3,5,7,9,6,7,7,6,8,6,7,8,6,5,3,5,4,3,5,3,4,5,7,8,5,7,6,4,7,4,7,7,1,1,0,0,0,0,1,1,0,0,4,4,3,3,4,3,4,4,4,5,4,5,3,5,3,2,4,2,3,4,4,5,3,3,4,3,4,3,5,4,7,9,6,7,7,5,9,5,7,8,8,7,5,7,6,4,7,4,6,7,9,9,6,9,7,5,9,5,7,10,9,9,6,9,7,6,9,5,7,9,1,0,0,0,0,0,1,1,0,0,4,4,2,3,3,2,3,2,3,3,4,5,3,4,4,2,4,2,3,4,4,4,3,3,4,3,4,3,5,4,0,1,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,8,8,7,8,8,6,9,7,8,9,1,0,0,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,3,5,3,3,4,3,4,3,4,4,6,4,3,5,4,4,5,3,4,5,3,3,3,3,3,2,3,3,3,3,9,8,6,8,8,6,9,6,8,9,4,5,3,4,3,3,4,2,3,4,1,0,1,0,0,0,0,1,0,0,6,7,5,6,7,5,7,5,7,7,4,5,3,4,3,3,4,2,3,4,6,4,3,5,4,3,5,4,4,5,6,7,6,6,7,5,7,5,7,7,4,5,3,4,3,3,4,2,3,4};
static const short pointer_shift_values_BG2[420]= {0,3,6,8,11,14,16,19,21,24,27,31,35,38,42,45,47,51,53,56,60,65,69,72,77,81,84,89,92,96,101,104,108,111,114,118,121,125,128,132,136,141,146,149,153,156,158,162,164,167,171,176,181,184,188,191,194,198,201,204,208,213,217,220,224,227,230,234,237,240,245,252,261,267,274,281,287,295,301,308,316,322,327,330,335,339,342,347,350,354,359,366,374,379,386,392,396,403,407,414,421,422,423,423,423,423,423,424,425,425,425,429,433,436,439,443,446,450,454,458,463,467,472,475,480,483,485,489,491,494,498,502,507,510,513,517,520,524,527,532,536,543,552,558,565,572,577,586,591,598,606,614,621,626,633,639,643,650,654,660,667,676,685,691,700,707,712,721,726,733,743,752,761,767,776,783,789,798,803,810,819,820,820,820,820,820,820,821,822,822,822,826,830,832,835,838,840,843,845,848,851,855,860,863,867,871,873,877,879,882,886,890,894,897,900,904,907,911,914,919,923,923,924,925,925,925,925,925,925,925,925,926,926,926,927,927,928,928,928,928,928,928,929,930,930,930,930,930,930,930,931,932,932,932,932,932,933,933,933,933,933,941,949,956,964,972,978,987,994,1002,1011,1012,1012,1012,1012,1012,1012,1013,1013,1013,1013,1013,1014,1015,1015,1015,1016,1016,1016,1016,1016,1017,1017,1017,1017,1018,1018,1018,1018,1018,1018,1018,1018,1019,1019,1019,1020,1020,1021,1021,1022,1025,1030,1033,1036,1040,1043,1047,1050,1054,1058,1064,1068,1071,1076,1080,1084,1089,1092,1096,1101,1104,1107,1110,1113,1116,1118,1121,1124,1127,1130,1139,1147,1153,1161,1169,1175,1184,1190,1198,1207,1211,1216,1219,1223,1226,1229,1233,1235,1238,1242,1243,1243,1244,1244,1244,1244,1244,1245,1245,1245,1251,1258,1263,1269,1276,1281,1288,1293,1300,1307,1311,1316,1319,1323,1326,1329,1333,1335,1338,1342,1348,1352,1355,1360,1364,1367,1372,1376,1380,1385,1391,1398,1404,1410,1417,1422,1429,1434,1441,1448,1452,1457,1460,1464,1467,1470,1474,1476,1479};


static const short Gen_shift_values_BG2_Z_2[1483]= {1,1,1,1,0,0,0,0,0,0,0,1,0,0,1,0,1,0,1,0,0,0,0,0,1,0,0,0,1,1,1,0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,1,1,1,0,1,0,0,1,0,0,0,0,1,0,1,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,0,1,1,1,0,1,1,0,1,1,0,1,0,1,1,1,1,1,1,0,1,1,1,0,0,0,0,1,0,1,1,0,0,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1,0,1,1,0,1,1,1,1,0,1,1,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,1,0,1,0,1,0,1,1,0,1,1,0,1,1,0,0,0,1,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,1,1,0,0,1,1,1,0,0,1,0,1,1,0,0,0,1,1,0,1,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,0,1,0,1,1,1,0,1,0,0,1,1,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,1,0,0,1,1,1,1,0,0,1,1,1,1,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,1,0,0,1,0,1,1,1,0,1,0,1,0,0,1,0,0,0,0,1,0,1,0,1,1,0,1,0,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0,1,0,0,1,1,1,0,1,0,1,0,1,0,1,0,0,0,0,1,0,1,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,1,0,1,0,1,0,1,1,0,1,1,0,1,1,0,0,0,1,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,1,1,0,0,1,1,1,0,1,0,1,1,0,0,0,1,0,1,0,1,1,0,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0,0,0,0,0,0,0,1,0,0,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,1,1,0,1,1,1,1,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,0,0,1,1,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,1,1,0,0,1,0,0,1,1,1,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,1,1,1,1,0,1,1,1,0,0,0,1,0,1,1,1,0,1,1,0,1,1,1,0,1,1,0,0,1,1,0,1,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,0,0,1,0,0,0,0,1,0,1,0,1,1,0,1,0,0,1,0,1,0,0,0,1,0,1,1,0,1,0,1,0,0,0,1,1,0,1,1,1,0,1,1,0,1,1,1,1,0,1,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1,1,1,0,0,1,0,0,1,0,1,0,0,1,1,0,1,0,1,0,0,0,0,1,0,1,1,1,0,1,1,1,1,0,1,0,1,0,0,1,0,1,1,0,1,0,1,1,1,0,1,0,1,0,1,0,1,0,1,1,1,0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,1,1,0,1,1,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,0,1,1,1,1,1,1,0,1,1,1,0,1,1,0,1,0,1,0,1,0,1,1,0,1,1,0,0,1,0,1,1,0,0,1,0,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,1,1,0,1,0,1,0,1,0,0,0,1,0,1,0,1,1,0,0,1,0,1,0,1,1,0,1,0,1,0,1,0,1,1,0,1,0,0,0,1,0,1,1,0,0,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1,0,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,1,1,0,1,1,0,0,0,1,1,0,0,1,1,1,0,0,1,1,0,1,1,1,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,1,0,1,0,1,0,0,0,0,0,0,1,0,0,0,1,0,1,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,1,1,0,1,1,0,0,1,1,0,0,0,0,1,1,0,0,0,1,0,1,0,1,0,1,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0,1,0,0,1,1,0,1,1,0,0,1,1,1,0,0,1,1,0,0,0,1,1,0,1,1,0,1,0,1,0,1,1,0,0,1,1,0,1,1,0,0,1,1,1,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0};
static const short Gen_shift_values_BG2_Z_3[1483]= {1,1,2,2,1,2,2,2,1,1,1,1,0,0,0,1,0,2,1,2,2,0,1,2,2,1,1,2,1,1,2,0,2,1,2,0,2,2,2,1,1,1,1,0,0,0,1,1,0,2,1,2,2,0,1,2,0,2,1,1,2,1,2,1,2,0,2,1,2,0,2,2,2,1,2,1,1,2,1,0,0,1,0,1,1,0,0,2,1,0,2,2,1,0,1,2,0,2,2,1,1,1,1,2,2,1,0,2,2,0,2,1,1,1,1,0,1,0,0,2,1,0,2,2,1,2,0,2,0,1,0,2,2,1,2,1,1,0,0,1,2,2,1,0,1,1,2,1,1,1,0,0,0,0,2,2,2,0,0,2,1,0,1,1,2,0,1,2,1,0,0,2,1,1,2,0,0,2,1,2,1,0,2,2,2,1,1,1,1,0,0,0,1,0,1,0,2,1,2,2,1,0,1,2,0,2,1,1,0,2,2,0,2,1,0,2,0,1,0,0,0,2,2,2,2,1,1,1,2,1,2,1,0,2,0,0,0,1,2,0,1,0,2,2,0,2,1,0,1,0,2,1,0,2,1,1,0,2,2,1,1,0,2,1,2,2,1,2,1,0,1,0,1,0,1,0,0,2,0,0,2,0,2,1,1,0,2,1,0,2,2,1,1,1,0,2,1,2,2,1,0,0,2,1,0,2,2,1,0,2,1,1,0,1,1,0,1,0,1,0,1,0,2,1,0,1,0,2,1,1,1,0,1,0,0,1,0,2,2,0,2,0,0,2,2,1,0,2,1,1,0,2,0,1,2,1,1,0,0,0,0,2,0,2,1,0,1,1,0,0,2,1,0,0,1,1,0,1,0,0,0,2,0,2,0,2,0,2,2,1,2,1,2,1,0,2,2,2,1,1,0,0,2,1,0,1,0,2,1,0,2,1,0,2,1,1,0,0,2,0,2,1,1,0,0,2,2,0,1,0,2,1,0,0,1,0,2,2,2,2,1,2,1,1,0,2,1,0,0,2,0,1,0,1,1,2,1,0,0,2,0,2,2,1,0,0,1,2,1,0,1,2,2,1,1,1,0,0,0,2,0,2,2,2,0,0,2,1,0,1,1,2,0,1,2,1,0,0,2,2,0,0,0,2,1,0,1,0,1,0,2,2,2,2,1,2,1,1,0,2,1,0,0,2,0,1,0,1,2,1,0,1,0,2,0,2,2,1,2,1,2,2,0,0,2,0,1,2,2,1,0,0,0,2,0,2,1,0,2,1,2,1,2,1,2,1,2,0,1,0,2,1,0,1,1,0,2,1,0,1,2,0,1,0,2,0,2,0,2,1,0,0,1,1,2,2,1,0,0,2,0,1,2,1,0,2,1,2,1,1,1,2,2,1,2,0,2,1,1,2,2,2,0,2,2,2,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,0,1,0,2,2,1,1,2,2,2,2,0,0,1,1,2,2,2,0,2,1,1,1,1,2,1,0,2,1,0,2,2,0,0,2,1,0,1,2,2,0,2,0,2,1,0,2,0,2,1,0,2,1,0,2,1,2,1,0,2,0,1,0,1,0,2,1,1,2,1,0,2,1,2,1,0,1,2,2,1,0,2,0,0,2,1,1,2,2,0,0,2,1,0,1,0,2,1,2,2,2,1,2,1,1,2,1,2,2,0,2,0,2,1,1,2,2,1,0,2,0,2,2,2,2,1,2,1,1,2,1,1,1,1,2,1,0,0,0,0,0,1,0,1,1,1,1,0,1,0,2,0,2,1,1,2,0,2,2,2,0,1,0,1,1,2,2,0,2,0,2,1,2,1,1,1,2,2,0,1,1,2,0,2,1,2,2,2,2,1,1,1,1,0,0,0,1,0,2,1,2,2,0,1,2,2,1,1,2,1,1,2,0,2,1,2,0,0,2,2,2,1,1,1,1,0,0,0,0,1,1,0,2,1,2,2,0,1,2,0,2,1,1,2,2,0,0,0,2,1,0,0,1,0,2,2,2,2,1,2,1,1,0,2,1,0,0,2,0,1,0,1,2,1,0,0,0,2,0,2,1,0,0,1,1,1,2,0,2,2,0,2,2,0,2,2,0,0,1,0,0,2,2,0,1,0,1,0,0,0,1,0,0,0,2,2,0,2,2,2,2,0,2,2,1,1,1,2,1,2,1,1,2,0,2,2,1,1,1,0,0,2,0,2,1,0,0,0,1,0,1,2,1,1,2,2,0,1,0,1,0,0,0,2,2,2,0,2,0,1,0,2,2,1,1,2,0,0,1,0,0,1,1,0,2,1,2,1,2,1,0,0,0,0,2,0,2,2,1,0,2,1,1,0,1,2,1,2,0,2,1,1,0,1,0,1,0,1,0,1,2,2,1,0,1,2,1,1,1,0,1,0,0,1,0,2,2,0,2,0,1,0,2,2,1,0,2,1,1,0,2,0,1,2,1,1,0,0,2,2,0,0,2,0,0,0,2,2,2,2,2,1,1,1,2,1,0,2,0,0,1,1,2,0,0,2,2,2,1,1,2,1,1,2,2,1,0,2,2,1,1,2,0,2,0,2,2,2,0,2,2,1,1,2,1,1,1,1,2,1,1,0,0,0,1,0,1,0,0,1,2,1,1,0,0,0,2,2,1,2,1,0,2,2,2,0,2,1,0,0,1,1,2,0,2,0,2,2,2,1,1,1,2,1,2,1,1,2,0,2,1,2,1,0,2,2,2,1,1,1,1,0,0,0,1,0,1,0,2,1,2,2,0,1,2,0,2,1,1,0,0,1,2,2,2,2,0,0,0,0,2,2,0,1,0,0,0,0,1,0,2,2,2,2,2,2,2,2,1,1,1,2,1,1,1,2,0,2,1,1,0,0,2,0,2,0,0,0,1,0,1,1,2,2,0,1,0,0,0,2,2,2,0,2,0,2,2,0,1,0,2,0,2,1,0,0,0,2,2,2,2,1,1,1,2,0,2,1,0,2,0,0,1,2,0,1,0,2,2,2,1,2,1,2,2,0,2,1,2,0,2,2,2,1,2,1,1,2,1,0,0,1,0,1,1,0,0,2,1,0,2,2,2,1,0,1,2,0,2,2,1,1,0,2,0,2,1,0,1,0,0,2,1,1,0,1,0,1,1,0,0,0,2,0,2,0,2,0,2,2,1,2,2,1,2,1,0,0,2,2,1,1,0,0,0,2,1,0,1,1,0,2,1,0,2,1,1,0,1,0,0,2,0,0,2,2,1,1,2,0,2,1,2,2,0,2,2,2,1,1,1,1,0,0,0,1,0,1,0,2,1,2,2,0,1,2,0,2,1,1};
static const short Gen_shift_values_BG2_Z_4[1483]= {3,1,3,3,0,2,2,0,0,0,2,3,2,0,3,2,3,0,3,2,0,2,2,0,3,2,2,0,3,1,3,0,3,0,2,3,2,0,1,0,0,2,3,2,0,3,2,0,3,0,3,2,0,2,2,0,0,3,2,2,0,3,2,1,3,0,3,0,2,3,2,0,1,0,1,0,2,0,3,2,0,0,3,2,0,3,1,0,3,3,2,0,3,2,2,0,0,3,3,2,2,3,1,3,3,0,3,2,2,1,0,0,0,2,3,2,1,0,3,3,2,3,0,0,3,2,1,0,2,2,1,0,3,2,3,2,3,2,0,2,2,3,2,3,1,1,2,1,3,0,3,3,1,2,1,3,2,1,3,2,3,2,1,3,1,1,3,3,2,1,1,3,2,0,2,2,3,2,3,1,0,2,1,3,0,3,3,1,2,1,3,2,1,1,3,2,3,2,1,3,2,1,1,3,3,2,1,1,2,1,3,1,2,2,1,2,0,1,0,2,3,2,2,0,1,0,2,1,0,3,2,1,2,1,0,2,0,0,0,2,2,1,0,0,3,3,2,3,0,1,2,3,3,2,3,3,0,3,1,2,0,2,1,2,1,3,0,0,3,0,3,0,1,2,2,3,1,2,1,3,0,2,3,3,1,2,2,3,2,3,3,0,0,2,3,1,2,1,3,0,3,1,2,1,2,1,3,0,3,2,3,1,2,3,1,2,2,1,0,3,1,1,2,1,2,0,1,1,0,2,3,2,3,2,0,2,1,0,2,2,1,0,2,1,3,2,1,1,0,2,1,0,0,2,2,1,1,0,0,3,0,2,2,0,0,2,3,0,2,1,3,3,1,2,2,3,1,1,3,0,1,3,1,3,3,1,0,2,3,1,1,3,0,2,3,1,3,0,2,1,3,0,2,3,1,1,3,3,1,3,1,1,3,0,3,0,2,3,1,3,1,2,0,3,0,3,1,3,2,3,0,3,2,2,1,0,0,0,2,3,2,1,0,3,3,2,3,0,0,3,2,1,0,3,2,2,1,0,3,2,3,2,1,2,1,3,1,2,1,2,0,2,1,0,2,3,2,2,0,2,1,0,2,1,0,2,1,2,1,0,2,0,0,2,2,1,0,0,1,3,1,2,1,2,1,0,1,0,3,2,2,2,0,1,0,3,2,1,1,0,1,2,2,1,0,3,2,0,0,3,2,1,1,0,1,0,3,2,3,0,1,2,3,3,2,3,3,0,3,1,2,2,2,1,2,1,3,0,0,3,0,3,0,1,2,2,3,1,2,1,3,0,2,3,3,1,2,3,2,3,3,0,0,2,3,0,1,2,1,3,0,1,2,1,2,1,3,0,3,2,3,1,2,3,1,2,1,2,0,0,2,2,0,2,1,2,0,3,1,1,3,0,1,3,3,1,2,3,1,3,1,1,3,2,0,1,3,3,1,2,0,1,3,1,2,0,3,1,2,0,1,3,3,1,1,3,1,3,3,1,1,2,0,1,3,1,3,0,2,3,1,0,1,3,3,1,0,2,3,1,0,2,2,0,2,3,1,2,0,0,2,1,3,0,2,3,0,2,2,0,2,3,1,2,0,0,2,2,3,1,2,0,0,2,3,1,3,0,2,3,1,1,2,0,0,2,1,2,0,2,0,0,2,0,2,3,1,1,2,0,2,0,1,2,0,1,3,2,3,1,1,3,2,0,1,3,2,0,0,2,1,1,3,0,2,2,0,3,1,2,0,1,2,0,0,2,0,1,3,0,2,2,0,0,1,3,0,2,3,2,0,1,3,1,2,0,1,3,3,0,2,2,0,3,0,2,0,2,2,0,2,0,1,3,3,0,2,0,2,3,1,1,0,2,0,2,0,1,3,3,3,1,1,1,3,0,3,1,0,3,0,1,0,3,1,3,3,1,0,3,3,1,0,2,0,1,0,1,3,1,0,3,1,2,1,1,3,0,3,1,0,0,3,1,0,1,0,3,1,3,3,1,1,0,3,3,1,3,1,3,1,2,1,0,0,3,2,2,2,0,1,0,3,2,1,1,0,1,2,2,1,0,3,2,0,0,3,2,1,1,0,1,0,1,2,2,2,1,1,2,3,3,3,0,3,1,2,1,3,3,1,0,3,1,0,2,1,2,0,3,2,0,3,0,2,0,1,0,2,1,0,2,2,0,0,3,1,2,0,3,0,2,0,3,1,1,2,0,0,3,1,1,0,2,2,3,1,3,2,0,3,0,2,2,3,2,0,2,0,3,0,2,0,3,1,3,2,0,1,2,0,3,2,1,0,2,1,3,2,3,0,3,0,2,0,0,1,0,3,1,3,2,1,1,1,3,0,3,2,1,0,0,3,0,1,1,0,3,2,1,3,3,2,1,0,3,0,3,2,1,0,3,1,1,2,1,2,0,1,0,2,3,2,3,2,0,2,1,0,2,2,1,0,3,2,1,3,2,1,1,0,2,1,0,0,2,2,1,1,0,0,2,0,2,2,3,1,1,3,3,3,3,1,2,1,3,2,1,2,3,2,1,3,3,1,1,3,2,1,1,1,0,3,3,2,1,0,3,2,1,0,3,1,0,3,3,2,0,3,2,1,1,0,2,1,0,2,1,0,3,2,1,0,3,3,2,1,1,0,1,0,3,3,3,2,1,0,3,2,1,0,0,0,3,0,3,2,1,1,0,0,3,2,3,2,1,1,0,1,0,3,0,3,2,3,3,2,3,2,0,2,3,2,3,1,0,2,1,3,0,3,3,1,2,1,3,2,1,3,3,2,3,2,1,3,1,1,3,3,2,1,1,3,1,1,2,2,0,0,2,2,2,2,3,3,2,1,1,1,1,0,3,3,3,3,3,3,1,1,2,2,1,1,0,3,3,2,2,2,1,1,2,2,3,3,3,2,2,1,1,0,3,3,1,1,1,1,0,3,3,2,2,1,1,2,1,1,2,1,3,1,2,1,2,0,2,1,0,2,3,2,2,0,1,0,2,1,0,1,2,1,2,1,0,2,0,0,2,2,1,0,0,2,1,0,3,1,2,2,1,2,0,1,0,2,3,2,3,2,0,2,1,0,2,2,1,0,2,1,3,2,1,1,0,2,3,1,0,0,2,2,1,1,0,0,2,3,0,1,2,3,2,3,3,0,3,1,2,1,2,1,3,0,3,3,0,3,0,1,2,2,3,1,2,1,3,0,2,3,3,1,2,2,3,3,0,0,2,3,1,2,1,3,0,1,2,1,2,1,3,0,2,3,1,2,3,1,2,2,1,3,1,2,1,2,0,0,1,0,2,3,2,2,0,1,0,2,1,0,0,2,1,2,1,0,2,0,0,2,2,1,0,0};
static const short Gen_shift_values_BG2_Z_5[1483]= {3,0,3,3,2,1,3,3,3,2,2,3,2,0,3,4,3,1,0,3,0,3,1,1,3,3,4,4,3,0,3,4,3,2,1,4,3,3,4,3,2,2,3,2,0,3,4,4,3,1,0,3,0,3,1,1,4,3,3,4,4,3,1,0,3,4,3,2,1,4,3,3,4,3,3,2,2,4,3,2,0,4,3,4,4,3,2,1,0,4,3,0,4,3,1,1,4,3,4,3,4,3,0,3,3,2,2,1,3,4,3,3,2,2,3,2,1,0,3,0,4,3,1,1,0,3,1,0,3,1,2,1,3,3,0,4,1,0,2,0,4,1,0,4,3,0,1,0,0,1,0,4,4,0,4,2,0,1,1,0,3,2,0,2,0,3,3,1,0,0,1,3,2,4,2,4,3,2,1,0,0,3,2,2,3,2,1,1,2,1,4,2,3,1,3,2,0,4,2,4,0,2,0,0,3,2,2,3,2,1,3,1,4,2,1,0,4,2,1,1,2,1,0,0,1,0,3,1,2,3,2,1,4,3,1,3,3,1,4,4,2,1,1,2,4,0,4,1,1,3,4,1,0,4,1,3,0,2,0,4,4,0,4,1,4,2,1,0,4,1,3,0,3,0,4,1,3,0,1,4,3,4,1,0,3,2,4,0,4,1,2,4,1,4,3,4,1,1,4,3,2,4,1,2,4,2,0,4,0,4,1,4,1,0,3,2,1,0,3,2,0,4,1,0,4,3,4,1,0,0,1,0,0,4,4,1,0,4,2,1,0,1,1,0,4,3,2,1,0,2,1,0,3,3,1,0,1,0,1,4,4,3,1,0,4,3,4,4,3,3,2,2,1,4,4,4,3,4,3,4,4,3,3,2,3,2,4,3,3,2,1,0,4,3,0,4,4,4,3,2,1,1,0,4,3,1,0,4,3,2,1,2,1,1,4,4,3,4,3,0,4,4,1,0,4,0,2,0,4,0,4,4,3,0,1,0,0,4,4,0,4,3,2,0,2,1,0,3,3,2,0,3,2,1,0,3,4,3,0,0,2,1,3,2,1,3,1,2,1,0,4,4,2,1,1,2,1,0,0,2,1,0,3,1,2,2,1,4,3,1,3,1,4,4,2,1,1,2,4,1,4,4,4,3,3,2,1,4,0,4,4,3,3,4,3,2,1,4,1,0,4,2,2,1,4,2,1,4,2,3,2,1,4,4,1,0,1,0,0,2,2,0,0,1,0,0,4,4,3,4,3,4,1,0,0,0,1,0,1,0,0,4,4,4,4,0,0,4,4,2,3,2,0,0,1,2,1,1,0,0,3,3,2,3,2,2,0,0,2,3,2,0,0,3,3,3,4,3,1,0,0,0,0,1,2,1,1,3,2,3,4,1,2,4,1,3,2,0,1,4,0,1,3,2,1,2,1,3,2,0,1,0,1,1,2,0,1,3,4,1,2,2,3,1,3,2,4,0,3,4,1,2,3,4,1,2,4,0,4,0,1,3,2,1,2,2,3,0,4,2,1,1,4,3,4,1,0,4,2,1,3,0,2,4,4,0,4,2,1,4,1,0,4,2,1,3,1,0,3,0,4,2,1,3,0,1,3,4,2,1,0,2,0,4,2,1,2,0,4,1,3,4,2,1,1,3,4,2,1,2,4,2,4,0,4,2,1,4,2,1,0,2,3,3,2,2,1,4,4,3,2,1,3,2,2,1,1,0,0,4,4,3,2,2,1,2,1,3,2,2,1,1,1,0,1,0,2,2,1,1,0,4,3,2,2,1,3,2,3,3,2,2,1,0,0,4,4,3,2,2,1,4,3,2,2,1,0,4,0,4,3,2,2,1,2,2,1,3,2,4,2,0,2,4,2,4,2,1,0,2,2,2,2,1,1,2,1,4,2,3,2,0,4,2,4,2,0,0,2,2,3,3,2,4,2,3,2,1,0,4,3,2,2,3,2,1,1,2,1,4,2,2,3,3,2,0,4,2,4,2,0,0,3,2,2,3,1,3,1,4,1,0,0,4,1,2,1,1,0,0,1,0,4,3,1,3,2,1,4,4,3,1,4,3,1,4,0,4,1,1,1,3,2,4,3,4,4,2,4,3,1,4,4,2,1,0,4,3,2,1,0,2,1,0,0,4,4,4,3,2,1,0,1,1,0,4,2,1,0,1,0,4,0,4,2,1,0,0,4,3,3,2,2,1,0,2,2,1,2,1,0,0,4,3,3,3,2,2,1,0,3,3,2,4,2,1,0,4,3,4,4,3,2,1,0,2,1,0,2,2,1,4,1,4,0,4,4,3,4,4,0,3,3,0,3,3,2,2,1,4,3,4,3,3,2,2,3,2,1,0,3,0,4,3,1,1,0,3,1,0,3,1,2,1,3,3,0,4,1,0,3,2,0,4,1,0,4,3,1,0,0,1,0,0,4,4,1,0,4,2,1,0,1,4,1,0,4,3,2,1,0,2,1,0,3,3,1,0,1,0,1,1,3,1,1,0,4,1,1,4,1,0,0,1,0,3,1,2,1,4,3,1,3,2,1,4,4,1,1,2,3,2,1,0,4,3,2,1,4,3,2,1,1,0,0,0,4,3,2,1,2,2,1,3,2,1,2,1,0,1,0,3,2,1,1,0,4,4,3,3,2,1,3,3,2,3,2,1,1,0,4,4,4,3,3,2,1,4,4,3,3,2,1,0,4,0,0,4,3,2,1,3,2,1,3,3,2,0,4,1,4,0,4,3,2,4,0,4,4,0,4,3,3,4,3,1,4,0,1,0,4,2,1,4,1,4,2,2,0,4,4,0,4,2,1,3,2,0,4,3,2,3,2,2,1,1,1,0,3,2,3,3,2,3,2,2,1,2,1,3,2,2,1,0,0,4,3,2,4,4,3,3,2,1,0,0,0,4,3,2,0,0,4,3,2,1,0,1,1,0,3,2,3,2,4,4,3,3,2,4,2,3,2,1,0,4,3,2,2,3,2,1,1,2,1,4,2,3,2,3,2,0,4,2,4,2,0,0,3,2,2,3,2,1,4,3,1,4,2,1,0,4,2,1,1,2,1,1,0,0,2,1,0,3,2,1,2,2,1,0,4,3,2,1,3,3,2,1,4,4,2,1,2,1,2,4,1,1,3,4,1,4,1,3,0,2,0,4,4,1,4,2,1,4,4,1,3,0,3,0,4,1,3,0,1,4,3,4,1,0,3,2,4,1,2,4,1,4,3,4,1,1,4,3,4,1,2,4,2,0,4,4,1,4,1,0,3,2,4,3,0,3,4,3,2,1,4,4,3,3,4,3,2,2,3,2,0,3,4,1,4,3,1,0,3,0,3,1,1,4,3,3,4};
static const short Gen_shift_values_BG2_Z_6[1483]= {4,1,5,5,4,2,2,5,4,4,1,4,0,3,0,4,3,5,1,5,2,3,4,2,2,1,4,5,4,1,5,0,5,4,2,3,2,5,5,4,4,1,4,0,3,0,4,4,3,5,1,5,2,3,4,2,3,2,1,4,5,4,2,1,5,0,5,4,2,3,2,5,5,4,5,4,1,5,4,0,3,1,0,4,4,3,0,5,1,0,5,2,4,3,4,2,3,2,2,1,4,4,1,5,5,4,3,2,2,0,5,4,4,1,4,0,4,3,0,5,4,3,5,2,1,5,3,2,3,4,3,2,2,1,5,4,4,3,0,4,5,5,4,3,1,1,2,1,4,4,3,3,0,3,5,2,5,3,3,2,4,0,4,1,2,3,1,2,1,0,3,5,4,1,5,3,0,5,4,2,1,3,2,5,5,4,4,1,4,0,3,0,4,0,4,3,5,1,5,2,1,3,4,2,3,2,1,4,3,2,5,3,2,4,3,2,0,1,0,3,3,2,2,5,2,4,1,4,2,1,2,1,3,5,3,0,3,1,2,0,1,0,5,2,0,5,4,3,1,0,5,4,0,5,4,4,3,2,2,1,1,3,2,1,5,5,4,5,4,3,4,3,1,0,4,3,0,5,3,3,2,0,5,4,4,3,5,4,3,2,5,4,1,1,0,5,4,2,2,1,3,3,2,4,3,2,2,1,3,2,1,1,0,4,4,3,1,0,4,3,1,3,2,1,0,4,3,5,4,1,1,0,1,0,3,1,0,2,5,3,2,0,0,5,2,1,3,2,1,4,0,5,0,4,5,4,4,3,0,3,3,2,0,5,4,3,4,4,3,3,2,1,0,3,1,1,0,4,3,3,3,2,3,2,0,5,3,2,5,4,2,1,5,4,3,2,2,2,1,4,3,0,5,4,3,1,0,2,1,3,2,1,0,5,1,1,0,0,5,3,2,4,1,3,3,2,5,3,1,3,2,1,0,0,4,3,2,2,5,2,4,2,1,4,3,2,1,3,0,5,3,1,0,1,1,2,1,0,0,5,3,2,5,4,3,0,4,5,4,3,1,2,2,1,4,4,3,3,0,2,3,5,2,5,3,3,2,4,0,4,1,2,3,1,2,1,0,3,2,5,3,0,3,2,1,0,4,0,4,3,2,2,5,2,4,2,1,4,3,2,1,3,0,5,3,1,0,1,2,1,0,4,0,5,3,2,2,1,5,4,2,2,0,3,2,0,1,5,5,4,3,0,0,5,3,2,1,0,2,1,5,1,5,4,2,1,5,3,1,0,5,4,3,1,1,0,5,1,0,4,2,0,4,3,2,3,2,0,5,4,3,0,4,1,5,5,4,3,0,5,3,4,2,1,0,5,1,2,1,4,4,2,2,1,2,3,2,1,1,5,5,5,0,5,2,2,1,2,1,1,1,4,4,1,1,3,3,0,0,3,3,1,1,0,1,0,2,2,4,4,2,2,5,5,0,0,1,1,5,5,5,0,5,4,4,1,1,2,1,3,2,4,0,5,2,3,3,2,4,3,1,2,5,0,2,0,5,1,0,2,3,2,1,3,2,1,3,2,4,5,1,3,2,3,4,0,1,3,5,4,1,2,1,0,2,1,2,4,3,4,5,2,4,3,5,0,0,2,1,1,2,5,0,0,5,1,0,4,0,5,1,2,2,2,1,5,4,4,2,1,2,5,3,2,0,5,1,4,5,2,1,0,5,3,2,2,5,2,1,5,4,1,5,4,4,1,1,5,4,3,0,0,3,3,1,0,1,4,4,1,0,4,3,2,0,5,4,1,2,0,5,5,2,0,4,3,1,4,5,2,0,5,3,2,4,2,1,1,4,5,5,3,4,1,5,3,5,4,2,5,2,5,4,4,1,4,0,3,0,4,3,5,1,5,2,3,4,2,2,1,4,2,1,4,2,3,2,1,5,3,0,5,2,2,1,1,4,1,3,0,0,3,1,1,0,2,4,2,5,0,1,5,0,5,4,1,5,2,0,0,0,5,4,3,3,1,0,5,5,2,5,1,5,4,1,0,5,4,0,3,2,0,4,3,4,5,4,3,0,3,2,0,5,1,3,3,1,4,1,2,3,2,2,0,5,5,3,2,2,0,0,1,0,0,5,5,3,4,3,4,3,3,0,1,0,0,0,5,5,0,5,5,2,2,0,5,5,1,1,4,5,4,2,1,1,5,0,5,5,4,4,1,0,0,2,3,2,1,0,0,3,4,3,4,5,4,4,5,5,3,4,3,4,3,3,3,2,2,5,0,5,0,1,3,2,5,1,4,5,3,3,1,0,3,1,1,0,5,4,2,4,2,1,0,0,3,0,2,0,5,2,1,0,5,1,4,3,1,5,4,5,0,5,4,4,3,1,0,4,3,1,0,4,5,5,4,3,1,2,1,4,4,3,4,3,0,4,3,5,2,0,5,3,1,3,2,5,4,0,5,4,1,3,2,3,1,2,1,1,0,3,2,5,3,3,2,0,0,3,2,2,2,5,2,4,1,4,2,1,3,5,3,0,4,1,2,0,0,5,2,2,1,4,5,4,1,2,5,4,3,2,5,1,4,5,3,2,0,5,2,2,0,5,2,1,4,2,1,4,4,1,2,1,4,3,0,0,4,3,4,3,0,1,5,4,1,0,3,3,2,5,4,2,1,3,2,5,5,3,2,1,0,3,1,4,5,3,2,0,5,2,5,4,1,1,5,4,5,4,1,5,0,5,4,2,4,3,2,5,5,4,4,1,4,0,3,0,4,3,4,3,5,1,5,2,3,4,2,3,2,1,4,0,0,1,5,5,2,2,0,0,0,0,5,5,3,4,3,3,3,0,1,0,5,5,5,5,2,2,5,5,1,1,4,5,4,1,1,5,0,5,4,4,0,0,2,3,2,0,0,3,4,3,4,4,5,5,3,4,3,3,3,2,2,5,0,5,3,2,5,3,4,3,2,0,5,1,0,3,3,2,2,5,2,4,1,4,2,0,2,1,3,5,3,0,1,2,0,1,0,5,2,2,1,5,4,2,2,3,2,1,5,0,5,2,2,1,2,1,4,2,1,3,0,4,3,1,1,0,3,2,4,3,2,5,5,1,0,1,5,0,5,5,4,1,3,5,0,2,4,0,4,0,3,5,1,4,3,1,3,4,1,0,0,3,5,3,5,0,2,3,5,5,1,2,5,4,5,1,3,0,5,2,4,4,0,0,3,2,4,0,1,4,3,2,4,3,5,1,4,3,1,3,0,2,3,0,5,5,4,1,5,0,5,4,2,2,3,2,5,5,4,4,1,4,0,3,0,4,0,4,3,5,1,5,2,3,4,2,3,2,1,4};
static const short Gen_shift_values_BG2_Z_7[1483]= {1,3,4,4,4,2,1,5,5,1,3,2,1,0,1,4,3,2,4,3,4,0,6,1,0,2,6,1,2,4,5,4,5,5,3,1,2,6,5,6,2,4,3,2,1,2,5,3,4,3,5,4,5,1,0,2,0,1,3,0,1,2,3,4,5,4,5,5,3,1,2,6,5,6,1,2,4,2,3,2,1,1,2,5,3,4,2,3,5,3,4,5,0,1,0,2,0,1,2,3,0,2,4,5,5,5,2,3,2,5,6,6,2,4,3,2,0,1,2,4,5,4,3,4,5,4,4,5,1,0,1,2,1,3,6,0,4,5,0,1,3,0,1,1,6,1,4,5,2,1,2,5,0,6,5,4,5,1,6,0,6,1,0,1,4,3,5,3,4,6,3,5,6,1,2,2,1,2,2,0,4,5,6,3,2,3,6,1,0,6,5,6,2,1,0,1,0,2,1,2,1,5,4,6,4,5,0,4,0,1,3,4,3,3,4,4,2,0,1,5,4,5,1,3,2,1,0,1,4,5,2,3,2,4,3,4,2,0,6,1,6,0,2,6,4,4,5,1,0,3,1,4,0,1,4,1,4,6,1,2,4,4,5,1,2,4,5,1,2,5,5,1,0,3,6,2,5,1,4,6,0,5,1,1,3,4,5,6,0,3,6,2,1,3,4,0,3,1,3,4,6,4,0,3,6,5,0,1,3,4,0,6,2,3,5,6,6,0,1,2,3,6,2,3,3,1,0,6,0,4,3,4,6,0,2,0,1,0,6,6,0,3,1,2,0,1,3,1,2,3,5,6,5,0,5,6,0,1,5,3,0,1,5,3,6,4,6,3,4,6,4,4,2,1,3,0,1,0,5,0,4,5,3,1,5,3,4,2,3,1,2,0,3,1,6,4,5,2,3,4,2,6,4,5,3,6,4,2,0,1,6,3,1,1,2,6,0,4,2,1,6,5,2,0,6,3,5,6,0,6,6,3,4,3,6,0,0,3,5,4,3,1,2,3,5,6,5,4,5,6,5,5,6,4,2,1,2,3,2,4,0,1,4,5,6,1,2,1,2,2,0,3,5,6,3,2,3,6,1,6,0,6,5,6,2,0,1,0,2,1,2,5,4,6,4,5,0,4,2,4,5,1,5,5,2,3,0,2,5,6,6,2,4,3,2,0,1,2,4,5,4,3,4,5,4,4,5,1,0,1,2,2,1,3,6,0,6,0,6,2,1,3,2,2,3,2,3,2,1,6,0,0,6,0,6,4,2,3,3,4,3,0,6,2,1,1,0,0,6,6,4,5,0,6,3,1,2,1,2,1,1,0,3,1,2,3,2,1,3,1,2,6,5,5,4,0,5,6,5,6,5,1,0,5,3,4,5,6,0,0,2,1,3,3,1,2,3,1,3,6,1,5,6,0,2,4,2,3,4,5,0,0,2,6,1,5,0,4,6,5,0,1,3,0,1,2,6,1,1,3,0,2,1,3,4,6,3,5,5,0,4,5,6,6,1,3,5,2,3,0,1,5,2,3,6,4,5,6,3,4,6,4,4,2,4,2,3,0,1,0,5,6,0,4,5,3,0,1,5,3,4,1,2,3,1,2,0,3,0,1,6,4,4,5,2,3,4,1,2,6,4,5,2,3,6,4,2,6,0,1,6,3,1,1,2,6,0,4,1,2,1,6,3,4,5,3,4,0,5,6,1,0,0,1,6,0,1,0,6,5,5,4,5,3,4,2,1,1,2,0,1,5,3,4,0,6,6,4,5,5,4,4,3,5,3,4,1,0,5,6,0,5,6,6,4,5,1,0,0,5,6,1,0,4,2,3,3,2,5,4,3,4,2,3,6,4,5,3,2,4,1,1,3,5,6,6,6,6,4,4,3,0,0,3,5,4,3,2,3,6,5,4,6,5,6,2,1,3,2,4,1,2,3,5,6,5,6,6,4,5,2,3,0,6,0,3,5,4,3,2,5,3,6,4,5,4,6,5,6,2,1,3,1,2,4,1,6,1,2,2,2,2,6,0,6,2,3,3,6,1,0,6,4,5,6,1,2,1,0,1,2,1,1,2,5,4,5,6,0,5,0,3,4,6,0,1,4,0,5,3,6,0,2,5,6,1,0,1,3,2,4,1,2,4,2,4,0,1,2,5,6,1,3,4,5,5,2,3,5,5,6,1,1,3,6,0,2,6,1,5,6,0,5,6,1,2,3,4,0,1,3,6,0,2,2,3,4,0,1,3,2,3,4,5,4,5,0,4,6,6,0,1,4,5,0,6,0,2,4,5,6,5,5,5,1,3,2,4,0,1,2,0,2,4,5,5,5,2,3,6,2,5,6,6,2,4,3,2,0,1,2,4,5,4,3,4,5,4,4,5,1,0,1,2,1,3,6,0,6,0,1,2,3,2,2,3,3,1,6,0,4,3,4,6,0,2,0,1,0,6,6,0,3,6,1,2,0,1,3,1,2,3,5,6,5,0,5,6,0,1,5,5,0,1,1,1,6,5,2,0,2,5,0,6,5,4,5,1,0,6,1,0,1,4,4,3,5,4,6,3,6,0,1,1,2,3,3,4,0,2,3,4,3,4,1,1,2,6,0,1,4,4,5,3,4,5,6,0,1,2,3,0,1,2,0,1,6,6,0,6,0,1,3,3,4,1,2,3,0,1,2,3,3,4,1,2,3,3,3,4,5,6,0,5,6,0,0,1,5,6,0,0,1,2,5,5,6,0,1,3,4,3,4,4,2,6,0,1,5,4,5,1,3,2,1,0,1,4,3,2,3,2,4,3,4,0,6,1,6,0,2,6,0,6,5,6,0,1,2,2,3,2,3,2,3,0,0,1,6,0,3,3,4,3,4,6,0,1,2,0,1,6,0,5,5,6,6,0,2,2,3,1,2,0,1,2,2,3,1,2,2,2,3,5,6,4,5,6,6,0,5,6,0,1,4,4,5,5,6,1,2,1,2,2,0,1,5,6,3,2,3,6,1,0,6,5,6,2,5,0,1,0,2,1,2,5,4,6,4,5,0,4,1,2,3,4,5,0,4,5,5,3,1,2,6,5,6,1,2,4,2,3,2,1,1,2,5,3,4,2,3,5,3,4,5,5,0,1,0,2,0,1,2,3,0,1,3,3,5,4,6,4,6,4,6,2,3,4,1,3,5,6,0,6,5,0,1,3,3,5,2,4,1,3,0,1,2,1,3,4,5,6,3,5,2,4,4,5,6,3,5,4,5,6,0,2,6,1,1,2,3,0,2,2,4,6,0,1,5,6,1,2,1,2,2,0,0,5,6,3,2,3,6,1,0,6,5,6,2,2,0,1,0,2,1,2,5,4,6,4,5,0,4};
static const short Gen_shift_values_BG2_Z_8[1483]= {7,5,7,3,0,6,2,0,0,4,2,3,2,4,3,6,3,0,7,2,4,6,6,0,3,2,6,0,7,5,7,4,3,0,6,3,2,0,1,0,4,2,3,2,4,3,6,4,3,0,7,2,4,6,6,0,4,3,2,6,0,7,6,5,7,4,3,0,6,3,2,0,1,0,5,4,2,4,3,2,4,4,3,6,4,3,1,0,7,3,2,4,7,6,6,0,4,3,3,2,6,7,5,7,3,0,7,6,2,1,0,0,4,2,3,2,5,4,3,7,6,3,0,0,7,2,5,4,6,6,1,0,3,2,7,6,7,6,4,6,2,3,2,7,5,5,2,1,7,0,7,3,1,2,1,3,2,5,3,2,7,6,1,3,5,5,7,3,2,1,5,7,6,4,6,6,3,2,7,5,0,2,1,7,0,7,3,1,2,1,3,2,5,1,3,2,7,6,1,3,6,5,5,7,3,2,1,5,6,5,3,5,2,2,1,6,4,1,0,6,7,6,2,0,1,0,2,1,4,3,2,1,6,5,0,2,4,4,4,6,2,1,0,4,3,3,2,3,0,1,2,3,7,6,7,3,4,3,1,2,0,6,5,6,5,3,4,4,3,4,7,0,5,6,6,7,5,6,1,7,0,6,7,3,1,2,2,7,6,7,3,4,4,2,3,5,6,1,7,0,3,1,2,1,2,5,3,4,7,6,7,5,6,3,1,2,6,5,4,3,5,5,2,1,6,4,5,1,0,6,7,6,3,2,0,2,1,0,2,2,1,4,2,1,7,6,5,1,0,2,5,4,4,6,2,1,1,0,4,7,4,6,2,4,4,6,3,0,2,5,7,3,5,2,2,7,1,5,7,0,5,7,1,3,7,1,0,2,7,1,1,3,0,2,3,5,3,0,2,5,7,4,6,7,1,1,3,3,5,3,5,5,7,4,3,0,2,7,1,3,5,2,0,7,4,7,5,7,2,3,0,7,6,2,1,0,0,4,2,3,2,5,4,3,7,6,3,0,0,7,2,5,4,3,6,6,1,0,3,2,7,6,1,6,5,3,5,2,1,6,4,6,1,0,6,7,6,2,0,6,1,0,2,1,4,2,1,6,5,0,2,4,4,6,2,1,0,4,5,3,5,2,1,6,5,4,1,0,7,6,6,2,0,1,0,3,2,1,5,4,1,6,6,5,0,3,2,4,4,7,6,5,1,0,5,4,3,2,7,0,5,2,7,7,6,3,3,0,7,1,6,2,6,5,2,1,3,0,4,3,0,7,4,5,2,6,3,5,2,5,7,4,6,3,7,1,6,7,6,3,3,0,0,2,7,0,5,2,5,7,4,1,6,1,6,1,3,0,7,6,3,5,2,7,1,6,5,6,4,4,2,6,4,2,1,2,0,7,5,5,3,0,1,7,7,5,6,7,5,3,1,1,7,2,0,1,7,3,1,2,0,5,3,1,2,0,7,5,6,4,1,7,3,1,5,3,5,3,7,5,1,2,0,1,7,5,3,0,2,7,1,0,5,7,7,1,4,6,3,5,0,2,6,0,2,3,5,2,4,0,2,1,3,0,2,7,4,6,2,4,6,3,5,2,4,4,6,6,3,5,6,0,4,6,3,5,3,0,2,7,1,5,2,4,4,6,1,6,0,6,0,0,2,4,6,3,5,5,2,4,6,0,5,2,0,1,7,6,7,5,1,7,6,4,5,3,2,0,0,6,5,5,3,4,2,2,0,3,1,2,0,5,6,4,4,2,4,5,3,4,2,6,4,4,5,3,0,6,3,6,4,5,3,1,2,0,1,7,3,4,2,6,4,7,0,6,0,6,2,0,6,4,5,3,3,4,2,0,6,3,1,1,0,6,0,6,4,1,7,3,3,1,1,5,3,4,3,5,4,7,4,1,0,3,5,7,7,1,4,3,7,5,4,2,4,1,0,5,3,1,0,7,5,6,5,1,7,0,7,1,0,0,3,1,0,5,4,7,1,3,3,5,1,0,7,3,1,7,1,3,5,2,1,0,4,3,2,2,6,4,5,4,7,6,5,1,0,5,2,2,1,4,7,6,0,0,3,2,1,5,4,1,0,5,6,6,2,5,5,2,7,3,3,0,7,1,6,5,7,7,1,4,3,5,0,2,1,6,0,3,2,4,3,0,2,4,1,0,2,5,4,6,2,4,4,3,5,2,4,7,4,6,4,3,5,1,6,0,4,3,5,1,0,2,2,7,1,3,2,4,7,4,6,6,7,6,0,6,0,3,0,2,4,3,5,3,2,4,1,6,0,7,6,1,4,6,1,3,6,7,0,3,0,6,0,4,1,0,7,1,3,2,1,1,5,3,4,3,6,5,4,0,7,4,1,1,0,3,6,5,7,7,2,1,4,3,0,7,6,5,4,3,5,1,2,1,6,4,1,0,6,7,6,3,2,0,2,1,0,2,2,1,4,3,2,1,7,6,5,1,0,2,5,4,4,6,2,1,1,0,4,2,0,2,6,3,1,5,3,3,3,7,5,6,5,7,6,1,6,3,2,5,7,3,1,1,3,6,5,1,5,4,3,3,2,1,4,3,2,1,0,7,5,4,3,3,2,0,7,6,5,5,4,6,5,4,2,1,0,7,6,1,0,7,7,6,1,1,0,1,0,7,3,3,2,1,0,7,6,5,4,4,4,3,0,7,6,1,1,0,4,3,2,3,2,5,5,4,1,0,7,0,7,6,3,3,2,7,6,4,6,3,2,7,5,0,2,1,7,0,7,3,1,2,1,3,2,5,7,3,2,7,6,1,3,5,5,7,3,2,1,5,3,5,1,2,6,0,4,2,6,6,2,3,7,6,1,5,5,1,0,3,7,3,7,7,3,5,1,6,2,5,1,4,7,3,6,2,6,1,5,6,2,3,7,7,2,6,5,1,4,7,3,1,5,1,5,0,3,7,6,2,5,1,6,1,5,6,5,3,5,2,1,6,4,6,1,0,6,7,6,2,0,1,0,2,1,4,1,2,1,6,5,0,2,4,4,6,2,1,0,4,2,1,0,7,1,6,6,5,2,0,5,4,2,3,2,7,6,4,6,5,4,6,6,5,0,6,5,3,2,1,5,4,6,3,1,0,0,2,6,5,5,4,0,2,7,0,5,2,7,6,3,3,0,7,1,6,5,2,1,3,0,7,3,0,7,4,5,2,6,3,5,2,5,7,4,6,3,7,1,6,6,3,3,0,0,2,7,5,2,5,7,4,1,6,1,6,1,3,0,6,3,5,2,7,1,6,6,5,3,5,2,1,6,4,0,1,0,6,7,6,2,0,1,0,2,1,4,4,2,1,6,5,0,2,4,4,6,2,1,0,4};
static const short Gen_shift_values_BG2_Z_9[1483]= {1,8,3,6,5,1,6,2,6,2,0,3,0,2,1,2,5,1,8,6,2,4,1,0,8,3,5,2,1,8,3,7,6,5,1,7,6,2,7,6,2,0,3,0,2,1,2,6,5,1,8,6,2,4,1,0,0,8,3,5,2,1,0,8,3,7,6,5,1,7,6,2,7,6,3,2,0,4,3,0,2,2,1,2,6,5,2,1,8,7,6,2,5,4,1,0,0,8,4,3,5,1,8,3,6,5,2,1,6,3,2,6,2,0,3,0,3,2,1,3,2,5,1,0,8,6,3,2,4,1,1,0,8,3,6,5,8,7,5,0,5,4,3,2,7,5,4,3,8,4,3,8,6,0,6,8,7,8,3,2,7,5,3,8,1,7,6,6,5,0,2,1,0,7,2,3,6,5,4,0,4,6,5,1,6,5,1,8,2,8,1,0,1,2,5,4,0,7,5,1,1,3,0,8,8,7,2,4,6,5,3,7,0,2,1,0,5,2,1,6,2,1,6,4,7,4,6,5,6,5,1,0,5,3,1,6,7,8,5,4,4,3,7,0,6,2,1,3,8,1,3,5,7,6,8,5,7,1,4,3,6,7,6,8,2,5,4,7,6,8,2,4,0,2,3,5,0,2,2,5,4,1,3,2,5,4,8,6,5,7,1,3,8,2,1,6,8,2,5,4,7,4,6,1,3,0,3,2,0,8,1,3,5,5,8,7,0,8,7,6,1,6,5,4,3,8,5,5,4,0,5,4,1,0,7,2,1,7,0,0,8,0,4,3,0,8,6,5,4,0,3,2,8,7,7,6,2,1,3,7,6,5,5,3,0,7,3,2,1,2,0,7,5,6,3,2,1,8,6,3,2,1,8,6,6,4,0,7,6,4,8,6,7,5,8,6,2,1,0,7,5,5,3,3,1,8,6,1,8,7,5,6,4,3,5,4,3,0,7,2,0,0,4,1,5,2,0,4,0,7,6,3,2,7,4,3,7,3,1,4,1,4,3,2,4,3,6,2,1,0,7,4,3,2,5,2,2,1,0,4,7,6,7,7,6,4,8,3,2,1,6,5,3,2,7,3,2,7,5,4,8,5,7,6,7,2,1,6,4,2,7,0,6,5,5,4,8,1,3,1,5,3,8,7,4,3,0,8,5,4,8,4,2,5,2,5,4,3,5,4,7,3,2,1,8,5,4,6,3,3,2,7,1,5,8,7,6,5,8,3,6,7,1,2,1,4,0,3,5,0,8,7,2,1,4,6,1,0,2,1,4,6,0,4,7,7,1,4,7,6,1,0,5,8,6,1,0,1,0,3,5,8,3,7,6,5,1,4,6,1,0,8,2,5,8,4,8,7,4,3,6,7,1,0,4,3,7,4,3,5,1,0,5,3,3,0,8,2,7,7,3,3,0,8,8,4,3,0,8,8,4,6,2,0,5,6,2,8,4,7,3,8,4,2,8,7,7,3,5,1,3,8,8,4,1,6,7,3,6,2,5,2,1,0,5,2,7,3,2,1,0,0,8,7,4,2,8,7,6,5,6,4,2,0,2,8,7,6,5,3,1,8,7,6,5,3,2,1,1,8,4,3,2,1,8,3,1,2,1,0,3,1,7,6,5,4,2,1,0,0,7,7,6,5,3,1,5,4,3,2,0,1,8,1,0,8,7,4,3,2,6,4,8,4,3,8,7,1,6,5,5,0,0,8,4,3,7,2,3,7,2,0,8,4,3,4,8,0,8,4,3,4,0,8,2,6,5,1,0,2,6,4,8,3,8,7,4,8,6,8,7,3,2,3,8,7,1,5,8,4,3,4,8,6,2,1,3,7,2,6,2,1,6,5,5,1,0,7,2,7,6,6,6,4,8,6,2,1,6,0,2,7,2,7,5,8,5,7,6,7,1,6,4,2,7,0,6,5,4,8,1,8,7,5,0,4,3,2,7,1,4,3,8,4,3,8,6,0,6,8,3,7,8,3,2,7,5,3,8,1,7,6,6,5,0,2,1,8,3,0,6,5,2,1,6,3,2,6,2,0,3,0,3,2,1,3,2,5,1,0,8,6,3,2,4,1,1,0,2,8,3,6,5,8,5,4,6,1,2,5,1,1,8,3,2,8,1,0,6,4,1,8,7,4,6,3,2,0,8,8,7,4,3,1,0,6,8,7,4,4,3,0,1,7,5,4,1,1,7,3,1,0,3,2,8,3,1,0,7,6,3,3,2,8,0,7,6,8,7,4,3,1,0,0,6,5,2,2,8,1,8,7,1,0,6,5,4,1,6,4,3,3,0,6,4,6,6,6,5,1,4,6,5,3,7,1,0,6,5,7,1,7,6,1,6,4,7,4,7,6,5,7,6,0,5,4,3,1,7,6,8,5,5,4,3,7,1,0,1,0,8,7,2,4,6,5,4,0,6,5,1,6,5,2,1,8,3,2,8,1,1,0,1,7,5,4,1,0,7,6,5,1,4,3,0,8,8,7,3,2,4,3,1,5,8,7,3,8,4,8,8,4,2,5,2,4,3,4,7,3,1,8,4,5,6,3,2,1,5,7,0,8,7,7,6,5,1,0,0,5,4,3,3,2,8,8,7,5,4,3,0,0,8,5,4,3,1,0,8,7,6,2,1,0,7,6,0,0,8,0,8,7,0,0,8,4,3,2,0,8,7,6,6,5,5,4,3,0,0,8,3,2,1,8,7,7,7,6,7,6,5,2,1,0,3,3,2,5,4,2,6,1,0,8,4,5,1,0,5,1,0,5,3,6,3,5,4,5,1,0,8,4,2,0,5,7,4,3,3,2,6,8,3,2,7,8,3,6,1,1,5,4,8,3,7,8,4,3,4,8,0,5,4,4,8,0,4,7,2,1,5,7,2,0,5,4,8,3,0,5,4,3,7,8,3,6,2,1,4,8,0,5,4,2,6,8,3,7,3,2,6,1,1,5,3,8,7,3,2,0,4,8,7,6,2,0,8,7,3,8,7,3,1,4,1,3,2,3,6,7,6,2,0,7,3,5,2,1,1,0,4,6,0,8,7,6,1,1,5,4,3,8,5,4,0,5,4,1,0,7,2,1,7,0,0,8,0,4,3,0,8,6,5,4,0,4,3,2,8,7,7,6,2,1,3,2,4,0,2,4,6,7,0,6,8,2,5,4,7,0,3,6,5,5,7,0,3,5,1,3,4,6,1,3,3,6,5,2,4,3,6,5,6,8,2,4,0,3,2,7,0,3,6,5,5,7,2,4,1,4,3,0,2,4,6,6,0,8,3,2,0,4,8,7,6,2,2,8,7,3,8,7,3,1,4,1,3,2,3,1,7,6,2,0,7,3,5,2,1,1,0,4,6};
static const short Gen_shift_values_BG2_Z_10[1483]= {8,5,8,8,2,6,8,3,8,2,7,8,7,0,8,4,8,6,0,8,5,8,6,1,8,3,4,9,8,5,8,9,8,2,6,9,8,3,9,8,2,7,8,7,0,8,4,9,8,6,0,8,5,8,6,1,9,8,3,4,9,8,6,5,8,9,8,2,6,9,8,3,9,8,3,2,7,9,8,7,0,9,8,4,9,8,7,6,0,9,8,5,9,8,6,1,9,8,4,3,4,8,5,8,8,2,7,6,8,4,3,8,2,7,8,7,1,0,8,5,4,8,6,1,0,8,6,5,8,6,2,1,8,3,5,4,6,5,2,5,9,6,5,9,3,5,6,5,0,6,5,9,4,5,4,7,5,1,6,5,3,7,5,2,5,3,8,6,5,0,1,3,2,9,2,9,3,2,6,0,0,3,2,7,3,2,6,1,2,1,4,2,8,1,3,2,0,4,2,9,0,2,0,5,3,2,7,8,7,6,3,6,9,7,6,0,4,7,6,1,7,6,0,5,6,5,8,6,2,3,7,6,4,8,6,3,8,6,4,9,7,6,1,2,4,5,4,6,1,3,4,6,5,4,6,8,0,2,5,4,9,5,4,6,9,2,1,5,4,6,8,0,3,5,4,6,3,5,6,9,8,4,6,0,3,2,4,5,4,6,2,4,6,9,8,4,6,1,4,3,7,4,6,2,4,7,0,9,5,4,6,9,1,0,3,2,6,5,3,2,5,9,6,5,9,3,4,6,5,0,6,5,0,9,4,6,5,4,7,6,5,1,6,5,4,3,7,6,5,2,6,5,3,8,6,5,1,0,1,9,4,3,6,0,9,3,9,4,3,3,7,7,1,9,9,4,3,4,8,9,4,3,3,7,8,2,9,3,8,2,1,5,9,3,5,9,9,4,3,7,1,1,5,9,3,6,0,9,3,7,1,2,6,6,9,4,3,4,8,5,9,9,6,5,9,0,7,0,9,0,4,9,8,0,6,5,0,4,9,0,9,3,2,0,7,6,0,8,3,2,0,8,7,6,0,8,4,3,0,5,7,6,3,7,6,3,6,7,6,0,4,9,7,6,1,7,6,0,5,2,6,5,8,6,2,7,6,4,8,6,3,6,4,9,7,6,1,2,4,1,4,9,4,8,3,2,1,4,0,9,4,8,3,4,3,7,6,4,1,0,4,2,7,6,4,2,1,4,2,8,7,1,4,9,1,0,6,5,5,2,2,5,5,6,5,5,9,9,3,4,3,9,6,5,5,0,1,0,6,5,5,9,9,4,4,5,5,4,4,7,8,7,5,5,1,2,1,6,5,5,3,3,7,8,7,7,5,5,2,3,2,5,5,3,3,8,9,8,6,5,5,0,0,1,2,1,1,8,7,8,4,1,7,9,1,8,7,5,1,9,5,1,8,7,6,2,1,8,7,5,1,0,6,1,7,0,6,3,9,1,7,7,3,1,8,7,9,5,3,9,1,7,8,4,1,7,9,5,4,0,1,8,7,6,2,7,3,0,9,2,1,6,9,8,9,1,0,9,2,1,3,5,7,9,9,0,9,2,1,4,6,0,9,2,1,3,6,5,8,0,9,2,1,8,0,1,3,9,2,1,5,7,0,9,2,1,7,0,9,1,3,9,2,1,6,8,9,2,1,7,9,2,4,0,9,2,1,4,7,6,5,7,8,8,7,7,6,4,4,3,7,6,8,7,7,6,1,0,5,4,9,8,7,7,6,2,1,8,7,7,6,1,1,0,6,5,7,7,6,6,5,9,8,7,7,6,3,2,3,8,7,7,6,5,5,4,9,8,7,7,6,4,3,7,7,6,5,4,0,9,8,7,7,6,2,2,1,3,2,9,7,5,2,9,2,9,2,6,0,7,2,7,2,6,1,2,1,4,2,8,2,0,4,2,9,2,0,5,2,7,8,3,2,9,2,3,2,6,0,9,3,2,7,3,2,6,1,2,1,4,7,2,8,3,2,0,4,2,9,2,0,5,3,2,7,8,1,8,1,9,1,5,0,9,1,7,6,1,5,0,1,0,4,3,1,8,7,1,9,4,3,1,9,8,1,9,5,4,6,1,6,8,7,9,3,9,4,7,9,8,6,9,4,2,1,5,9,8,2,1,5,2,1,5,5,9,9,4,3,2,1,5,6,1,0,9,2,1,5,6,5,9,0,4,2,1,5,0,4,3,8,7,2,1,5,7,2,1,2,1,5,0,9,3,3,8,7,2,1,5,8,3,2,9,2,1,5,9,3,4,9,8,2,1,5,7,6,0,7,2,1,9,1,9,5,9,9,3,9,4,0,3,8,5,8,8,2,7,6,9,8,4,3,8,2,7,8,7,1,0,8,5,4,8,6,1,0,8,6,5,8,6,2,1,8,3,5,4,1,0,8,7,0,9,1,0,4,8,1,0,5,1,0,5,4,9,1,0,9,2,1,0,6,9,1,0,9,8,2,1,0,7,1,0,8,3,1,0,6,5,6,1,8,1,1,5,9,1,6,9,1,5,0,1,0,3,1,7,1,9,3,1,8,7,1,9,4,1,6,7,8,7,6,5,4,3,7,6,9,8,7,6,1,0,5,5,4,8,7,6,2,2,1,8,7,6,2,1,0,6,5,8,7,6,6,5,9,9,8,8,7,6,3,3,2,8,7,6,6,5,4,9,9,8,8,7,6,4,4,3,8,7,6,5,4,0,0,9,8,7,6,3,2,1,3,3,2,5,4,1,4,5,4,8,2,9,5,4,9,5,4,8,3,4,3,6,4,0,6,5,4,2,6,4,1,4,2,7,5,4,9,0,9,2,1,8,2,5,9,8,2,8,2,2,6,6,1,0,8,2,3,8,7,8,2,2,6,7,1,8,2,7,1,0,5,4,8,2,4,9,8,8,2,6,0,0,5,4,8,2,5,0,9,8,2,6,0,1,6,5,8,2,3,7,4,9,8,8,7,4,7,8,7,1,5,9,8,7,2,8,7,1,6,7,6,9,7,3,2,8,7,5,9,7,4,7,5,0,8,7,2,3,7,6,4,3,6,9,7,6,0,4,7,6,1,7,6,1,0,5,7,6,5,8,7,6,2,7,6,5,4,8,7,6,3,3,7,6,4,9,7,6,2,1,2,4,1,1,8,4,1,4,1,8,5,2,0,9,4,1,9,7,6,9,4,1,8,5,3,0,4,1,3,0,6,4,3,4,1,0,8,7,4,1,2,9,6,4,3,4,1,1,9,8,4,1,2,9,7,5,4,4,1,9,6,0,8,7,4,3,0,3,4,3,7,1,9,4,3,8,4,3,7,2,3,2,5,3,9,1,4,3,1,5,3,0,3,1,6,4,3,8,9};
static const short Gen_shift_values_BG2_Z_11[1483]= {0,4,8,9,1,7,1,7,1,8,6,6,3,7,10,4,5,9,4,2,10,4,8,4,0,10,4,1,0,4,8,10,9,1,7,2,1,7,2,1,8,6,6,3,7,10,4,6,5,9,4,2,10,4,8,4,1,0,10,4,1,0,5,4,8,10,9,1,7,2,1,7,2,1,9,8,6,7,6,3,7,0,10,4,6,5,10,9,4,3,2,10,5,4,8,4,1,0,0,10,4,0,4,8,9,1,8,7,1,8,7,1,8,6,6,3,8,7,10,5,4,5,9,5,4,2,0,10,4,8,5,4,0,10,5,4,7,6,10,3,8,5,4,7,2,0,8,7,2,8,7,3,1,1,9,2,5,10,1,0,4,10,8,5,10,3,10,7,6,5,10,6,5,9,2,1,4,3,6,1,6,7,6,1,7,6,2,0,0,8,1,4,9,1,0,10,3,9,7,4,3,9,2,9,6,5,4,9,8,7,0,4,2,6,5,8,3,9,8,3,9,8,4,2,2,10,3,6,0,10,2,1,5,0,9,6,9,0,4,0,8,7,6,0,0,4,3,0,7,4,0,8,2,1,9,4,1,10,8,7,3,5,4,1,10,8,7,5,4,1,0,8,9,6,9,6,6,3,10,8,7,2,10,7,5,4,3,9,8,5,1,9,7,5,4,5,2,2,0,10,1,7,4,0,8,7,5,4,4,3,0,2,10,7,5,4,8,7,1,0,4,8,6,5,8,3,8,9,8,3,9,8,5,4,2,3,2,10,3,7,6,0,2,1,6,5,0,10,9,6,1,0,4,0,8,7,7,6,0,0,10,9,4,2,8,6,9,8,7,1,10,7,5,4,1,0,10,7,5,1,0,10,8,6,6,4,6,4,3,1,7,5,10,8,4,2,5,4,3,9,7,4,2,2,0,10,8,4,2,8,6,4,2,9,0,10,9,10,8,4,2,0,2,8,0,9,2,6,2,7,10,6,5,10,6,5,10,6,4,4,1,6,5,8,3,2,3,7,3,2,0,9,8,9,2,6,3,2,9,8,3,2,1,5,4,8,1,3,2,5,0,0,6,5,0,6,5,1,10,10,10,7,0,3,8,10,9,2,8,6,3,8,1,8,5,4,3,8,6,10,3,6,4,7,3,2,2,7,3,2,7,3,1,1,9,3,2,5,0,10,0,4,0,10,8,6,5,10,3,0,10,4,6,5,0,10,9,8,1,1,5,5,9,7,6,10,9,2,4,9,8,10,10,9,2,4,9,8,10,9,2,5,9,3,7,3,7,0,4,4,9,8,7,0,1,6,5,3,2,6,6,10,1,6,5,1,10,3,7,1,0,1,5,5,9,1,6,5,9,8,1,7,0,1,6,5,4,8,7,8,0,1,4,4,2,6,5,5,8,0,3,5,9,8,0,3,5,9,8,1,4,10,2,10,2,7,10,0,3,3,6,8,0,9,2,1,2,5,8,0,6,9,3,6,8,0,1,4,8,0,4,8,7,3,6,8,0,7,6,1,0,10,5,4,3,8,5,4,10,9,7,1,2,7,0,8,7,2,1,2,7,8,7,2,1,3,9,8,1,6,1,7,6,9,3,2,7,5,0,10,10,4,1,0,6,5,4,10,9,10,4,8,3,2,5,10,10,5,4,3,8,10,4,7,6,1,0,5,0,10,10,4,3,8,7,10,9,0,3,2,4,6,6,5,8,7,8,10,3,5,1,9,8,0,10,3,5,9,8,0,10,4,7,6,2,4,2,5,4,10,1,3,5,6,9,8,0,2,0,2,1,4,3,5,8,7,0,2,9,1,0,6,8,0,3,2,4,6,0,2,8,7,10,9,6,9,8,0,2,7,8,10,2,6,10,1,0,3,9,2,3,9,3,10,8,8,5,9,1,6,7,0,6,4,1,6,10,6,2,1,6,9,8,1,5,7,6,9,4,6,10,9,4,10,9,5,3,3,0,4,7,7,1,3,2,6,1,10,7,1,5,1,9,8,7,1,7,0,4,1,5,8,4,3,8,4,3,8,4,2,2,10,4,3,6,1,0,1,5,1,0,9,7,6,0,4,1,0,0,7,6,1,0,6,8,10,10,6,2,8,5,5,3,10,9,2,3,2,6,6,10,8,7,0,10,3,5,10,9,0,10,3,5,10,9,2,0,10,3,7,6,10,4,8,5,4,8,1,5,5,10,9,9,8,1,2,7,6,4,3,7,8,7,0,2,7,6,1,0,4,8,2,1,4,3,2,6,6,10,2,7,6,10,9,2,9,8,1,2,7,6,8,4,8,1,5,6,6,6,7,4,6,5,9,2,3,6,2,1,6,6,2,1,6,2,0,0,8,2,1,4,10,9,10,3,10,9,7,5,4,9,2,10,9,5,4,10,9,0,10,4,3,7,5,9,8,0,6,1,0,6,1,0,8,7,5,6,5,2,6,10,9,3,6,5,4,9,8,3,2,1,9,4,3,7,3,0,10,10,9,3,7,0,4,5,8,3,8,3,5,8,4,2,2,10,3,6,0,1,5,0,9,6,4,0,4,0,7,6,0,9,8,8,2,1,1,5,5,10,7,6,6,9,9,4,5,4,10,9,9,4,5,4,10,9,9,6,5,5,3,3,4,3,3,0,0,4,5,4,8,7,7,1,2,1,3,2,2,7,6,6,1,2,1,0,10,10,7,8,7,2,1,1,5,5,1,2,1,9,8,8,8,7,7,1,2,1,8,7,0,4,6,5,8,3,4,9,8,3,9,8,4,2,2,10,3,6,0,8,2,1,5,0,9,6,0,4,0,8,7,6,0,6,10,7,2,5,6,9,10,2,0,3,3,6,9,2,1,3,6,9,2,1,3,6,10,2,8,0,8,0,5,8,9,2,1,1,4,6,10,9,7,10,0,3,6,10,9,4,7,1,5,4,6,9,10,2,6,10,9,2,5,1,4,6,10,9,9,8,1,5,7,6,9,4,1,10,9,4,10,9,5,3,3,0,4,7,1,6,3,2,6,1,10,7,1,5,1,9,8,7,1,7,6,0,10,3,9,5,4,7,2,8,7,2,8,7,4,3,1,2,1,9,2,6,5,10,1,0,5,4,10,9,8,5,5,0,10,3,10,7,6,6,5,10,2,5,6,9,10,2,0,3,3,6,9,2,1,3,6,9,2,1,5,3,6,10,2,8,0,8,0,5,8,9,2,1,1,4,6,10,9,7,10,0,3,6,10,9,4,7,1,5,4,6,9,10,2,6,10,9,2,5,1,4,6,10,9,9,8,1,5,7,6,9,4,10,10,9,4,10,9,5,3,3,0,4,7,1,5,3,2,6,1,10,7,1,5,1,9,8,7,1};
static const short Gen_shift_values_BG2_Z_12[1483]= {4,1,11,11,4,2,8,5,4,10,7,10,0,3,6,10,9,5,1,5,8,3,4,2,2,1,4,5,4,1,11,0,11,4,2,9,8,5,5,4,10,7,10,0,3,6,10,10,9,5,1,5,8,3,4,2,3,2,1,4,5,4,2,1,11,0,11,4,2,9,8,5,5,4,11,10,7,11,10,0,3,7,6,10,10,9,6,5,1,6,5,8,4,3,4,2,3,2,2,1,4,4,1,11,11,4,3,2,8,6,5,4,10,7,10,0,4,3,6,11,10,9,5,2,1,5,9,8,3,4,3,2,2,1,5,4,10,9,6,4,11,5,4,9,7,1,2,1,10,10,9,3,0,3,5,8,11,3,3,2,10,6,10,1,8,9,7,8,7,6,9,5,4,1,11,9,0,11,4,2,7,9,8,5,5,4,10,7,10,0,3,6,10,0,10,9,5,1,5,8,7,3,4,2,3,2,1,4,9,8,5,3,8,4,3,8,6,1,0,9,9,8,2,11,2,4,7,10,2,7,2,1,9,5,9,0,3,7,8,6,7,6,5,8,0,11,10,3,7,0,5,10,6,5,10,10,3,8,2,1,7,3,2,7,11,5,4,11,10,3,4,9,1,6,4,9,6,11,9,3,2,0,5,4,10,9,5,4,3,8,11,4,7,1,0,11,4,2,8,7,3,9,2,10,3,8,2,1,9,8,1,7,0,10,4,3,1,0,10,9,7,9,8,7,0,10,9,5,4,1,1,0,7,6,3,7,6,8,11,3,2,6,6,5,2,1,9,2,1,4,0,11,0,10,11,10,10,9,0,9,3,2,6,11,4,9,4,10,9,9,2,7,0,3,1,7,6,10,3,9,3,2,3,8,0,5,3,8,5,10,8,1,11,4,3,8,2,8,7,10,3,6,11,10,3,1,6,8,1,9,2,7,0,11,7,1,0,6,11,9,2,10,7,9,3,2,11,9,7,9,2,1,0,6,4,3,2,8,5,8,10,2,1,4,9,8,7,3,0,11,3,7,6,7,1,2,1,0,0,11,3,2,5,4,3,0,10,11,10,3,1,2,8,7,4,4,3,9,6,8,9,11,2,5,9,9,8,4,0,4,7,2,3,1,2,1,0,3,2,11,9,0,9,2,1,0,4,6,4,3,2,8,5,8,10,2,1,4,9,8,7,3,0,11,3,7,6,1,2,1,0,10,0,11,3,2,2,1,11,10,8,8,6,9,8,6,1,11,11,10,9,6,6,5,3,2,1,0,2,1,11,7,5,4,2,7,5,9,7,0,11,10,3,1,7,6,5,7,6,4,2,0,10,9,8,9,2,0,5,4,3,0,10,1,11,11,10,9,0,11,9,10,8,1,0,11,7,2,1,4,10,2,8,7,2,9,8,7,1,5,11,11,6,5,8,2,7,2,1,1,7,10,4,1,7,3,9,6,0,9,3,1,7,0,7,6,8,2,4,10,8,2,11,5,6,0,7,1,5,11,5,0,11,4,10,7,1,8,7,9,8,4,6,5,2,3,3,2,4,3,7,8,5,6,2,0,11,1,0,8,9,8,7,9,8,1,3,2,10,11,1,3,2,3,4,6,7,9,11,10,1,2,1,0,2,1,8,10,9,4,5,8,10,9,11,0,6,8,7,7,8,5,6,6,5,7,6,4,6,5,7,8,8,2,1,11,10,10,8,7,8,5,9,8,6,5,1,10,11,8,1,6,5,3,2,2,11,2,1,11,10,7,5,4,4,1,7,5,4,9,6,0,9,3,1,0,7,4,10,7,6,4,3,2,0,11,10,7,2,0,11,5,2,0,10,9,1,10,11,8,0,11,9,8,10,8,7,1,10,5,5,9,4,1,11,9,11,4,2,5,8,5,4,10,7,10,0,3,6,10,9,5,1,5,8,3,4,2,2,1,4,2,1,10,8,9,8,1,11,3,6,5,2,2,1,7,4,7,9,0,0,3,7,7,6,2,10,2,5,0,1,11,0,11,10,1,11,8,6,0,6,11,10,9,3,1,0,11,5,2,5,7,11,10,1,6,5,4,0,9,8,0,4,3,10,11,10,9,6,9,8,0,11,7,3,9,1,10,1,8,3,8,8,0,11,5,9,8,2,6,0,7,6,0,11,5,9,4,3,4,3,9,0,7,6,6,0,11,5,6,5,11,2,8,6,5,11,7,1,10,5,4,2,1,7,5,0,11,5,4,10,1,0,6,8,3,2,1,0,6,3,10,9,4,11,10,4,11,5,9,4,3,10,9,3,9,8,2,11,6,5,6,1,9,2,11,1,4,11,9,3,7,6,3,1,1,6,5,4,2,10,8,7,6,0,9,0,2,6,5,8,1,0,11,7,4,3,7,11,10,5,6,5,4,4,3,7,6,10,9,7,6,4,11,5,4,9,7,2,1,10,10,9,4,3,0,4,3,5,8,0,11,3,7,3,2,11,10,6,11,10,1,9,8,9,7,8,7,7,6,9,8,5,3,3,8,6,0,9,8,8,2,11,2,4,7,10,2,1,9,5,9,0,10,7,8,6,6,5,8,2,1,4,11,10,1,8,11,4,9,8,11,1,4,11,3,2,6,5,8,2,6,5,2,1,4,8,7,10,4,7,8,7,10,9,0,0,4,3,4,3,6,7,11,10,7,6,9,3,2,5,10,2,1,3,2,5,5,9,8,1,0,3,1,4,11,3,2,0,11,2,11,10,1,1,5,4,11,10,7,5,6,5,10,8,4,3,2,11,11,10,4,1,4,6,9,0,4,3,4,3,11,7,11,2,9,10,8,9,8,7,10,0,6,1,5,11,2,8,0,6,0,6,5,11,3,10,9,9,3,6,1,0,5,11,11,5,8,2,11,5,1,7,4,11,10,7,1,11,6,5,10,4,6,0,2,9,8,6,0,9,4,3,4,10,5,11,3,10,9,3,9,2,8,5,0,11,3,2,11,9,10,9,2,0,11,7,6,3,3,2,8,5,8,10,1,4,8,6,8,7,3,11,3,6,1,2,0,1,0,11,2,2,1,11,10,8,8,9,8,1,11,6,5,2,2,1,8,7,4,8,7,9,0,4,3,7,7,6,3,2,10,3,2,5,11,1,0,1,11,0,11,11,10,1,3,11,0,8,10,6,10,6,3,11,1,10,9,7,3,4,1,0,6,3,11,9,5,6,2,9,5,11,7,2,11,10,5,1,9,6,5,8,4,4,0,0,9,8,4,0,7,4,3,2,10,3,11,1,10,9,1,9,0,8,3,0,11,5,4,1,11,0,11,4,2,2,9,8,5,5,4,10,7,10,0,3,6,10,6,10,9,5,1,5,8,3,4,2,3,2,1,4};
static const short Gen_shift_values_BG2_Z_13[1483]= {11,3,7,4,5,8,5,7,7,12,6,1,12,3,9,5,12,1,6,2,1,12,0,7,11,9,2,12,11,3,7,5,4,5,8,6,5,7,8,7,12,6,1,12,3,9,5,0,12,1,6,2,1,12,0,7,12,11,9,2,12,11,4,3,7,5,4,5,8,6,5,7,8,7,0,12,6,2,1,12,3,10,9,5,0,12,2,1,6,3,2,1,0,12,0,7,12,11,10,9,2,11,3,7,4,5,9,8,5,8,7,7,12,6,1,12,4,3,9,6,5,12,1,7,6,2,2,1,12,0,8,7,11,9,3,2,12,11,3,7,3,5,4,5,8,0,6,5,7,8,7,12,6,1,12,3,9,5,0,12,1,6,2,1,12,0,7,12,11,9,2,9,8,0,4,5,2,1,2,5,9,3,2,4,5,4,9,3,11,9,0,6,2,9,10,9,11,3,12,11,1,9,10,4,9,8,6,12,11,10,2,6,6,4,3,4,7,5,4,6,7,6,11,5,0,11,2,8,4,7,12,11,0,5,1,0,2,11,12,6,11,10,8,1,11,2,1,4,6,9,10,0,8,7,10,8,11,11,2,1,6,9,8,11,10,1,0,11,10,0,2,5,9,12,4,7,2,5,6,10,9,12,2,8,12,11,12,3,2,5,4,7,9,0,12,5,8,4,8,7,12,2,5,3,6,10,1,0,2,1,4,12,2,5,9,8,8,7,0,12,3,9,1,0,1,4,7,2,1,3,4,3,9,8,2,11,10,8,12,6,5,1,9,8,11,10,2,12,11,10,9,8,9,3,8,7,6,5,11,8,2,1,0,6,4,10,1,8,7,2,8,5,11,3,2,9,8,4,10,4,11,10,9,2,3,9,11,4,9,2,0,6,6,12,2,8,9,3,2,11,4,3,9,12,5,11,4,9,2,10,3,4,10,0,8,2,1,6,12,12,5,7,7,7,11,6,11,2,12,12,0,4,3,0,3,2,2,7,1,9,7,12,11,4,1,0,7,9,2,1,10,10,9,2,7,8,3,2,6,4,11,10,8,9,8,0,4,2,1,2,5,4,3,2,4,5,4,9,3,11,11,9,0,6,2,10,9,11,3,12,11,9,10,4,9,8,6,12,2,7,11,5,8,9,0,12,0,9,12,11,11,3,10,5,3,8,7,0,10,9,3,5,11,10,6,6,5,3,4,12,11,3,2,0,7,6,12,11,3,3,8,7,12,5,4,9,5,10,8,1,0,12,6,5,10,7,0,12,8,7,12,12,4,6,11,1,6,12,4,3,9,8,9,1,5,11,10,0,12,4,1,6,6,12,11,6,2,7,1,7,6,12,4,0,5,7,0,12,12,11,3,9,1,2,8,7,2,10,9,7,1,11,5,4,8,3,2,9,3,12,6,9,4,3,11,5,11,6,5,3,10,10,4,5,12,3,10,7,1,0,7,9,3,3,11,10,5,12,10,4,6,0,5,12,3,10,4,11,11,5,2,10,9,0,7,6,0,1,0,6,5,5,11,10,9,1,7,6,12,11,7,12,10,2,7,8,7,0,12,9,1,10,9,2,1,1,7,6,8,0,3,9,8,1,6,5,10,11,4,3,7,12,2,1,7,6,3,9,8,8,0,4,10,9,3,8,1,7,6,2,7,9,1,1,0,6,5,11,4,3,4,9,4,11,10,8,7,2,0,12,6,3,4,3,1,0,4,1,7,4,4,5,4,2,1,6,3,7,6,4,3,11,9,8,5,2,0,11,10,11,8,2,12,8,6,5,4,1,5,12,11,9,8,0,11,10,5,2,1,12,11,0,10,11,9,8,12,9,6,3,11,10,8,7,8,6,5,1,11,11,7,9,11,3,7,5,4,5,8,6,5,7,7,12,6,1,12,3,9,5,12,1,6,2,1,12,0,7,11,9,2,9,8,0,4,2,1,2,5,0,3,2,4,5,4,9,3,11,9,0,8,6,2,10,9,11,3,12,11,9,10,4,9,8,6,12,8,0,4,9,1,2,6,5,2,5,4,4,9,3,11,9,1,0,6,3,2,9,11,4,3,12,12,11,9,10,5,4,4,8,6,0,12,6,8,12,0,12,8,4,9,1,11,9,8,3,1,0,8,4,12,2,1,9,2,10,5,1,0,3,2,10,4,0,12,7,5,4,12,10,9,4,3,11,12,11,6,9,4,0,9,8,7,6,1,2,11,10,10,9,4,12,11,6,3,12,11,0,12,7,11,7,6,2,10,9,4,10,5,4,0,12,9,8,3,7,6,1,12,8,7,11,10,0,3,6,10,0,4,3,10,5,5,10,1,11,12,3,2,10,12,2,1,1,6,0,8,6,11,10,3,0,12,6,8,1,0,9,9,8,6,7,2,1,5,3,10,9,6,5,11,10,1,5,12,11,12,2,0,12,1,2,1,7,6,0,9,8,6,10,4,3,12,12,7,6,9,8,0,10,9,8,7,6,7,1,6,5,4,3,9,8,0,4,1,2,5,2,4,6,4,9,3,11,9,0,6,2,9,11,3,12,11,3,9,10,4,8,6,12,8,7,9,0,12,1,3,5,1,1,0,2,1,3,4,7,6,2,1,3,3,6,5,4,3,5,9,8,10,2,4,11,10,12,8,10,12,2,1,6,5,7,1,4,3,9,8,10,11,10,12,2,5,4,12,11,0,10,0,12,9,8,10,9,11,3,6,5,8,7,9,6,5,7,11,1,0,11,10,2,6,4,3,4,7,0,5,4,6,7,6,11,5,0,11,2,8,4,10,12,11,0,5,1,0,11,12,6,11,10,8,1,1,10,9,10,9,2,1,6,5,3,2,4,3,7,7,6,4,3,6,6,5,6,5,11,10,5,4,0,12,11,10,2,2,1,8,7,4,4,3,11,10,0,12,5,5,4,1,0,0,0,12,11,10,12,11,6,6,5,10,9,8,7,1,1,0,8,7,12,3,1,0,1,4,0,2,1,3,4,3,8,2,10,8,12,5,1,3,9,8,10,2,11,10,8,9,3,8,7,5,11,3,2,8,7,11,11,9,8,9,12,10,9,11,12,11,4,3,10,6,5,3,7,1,0,9,4,3,6,5,10,7,6,5,0,4,3,4,11,3,2,1,0,6,5,8,10,0,1,4,11,1,12,2,2,6,5,12,2,1,5,4,10,1,4,6,9,0,3,8,11,6,9,10,1,0,3,6,12,3,2,6,9,8,11,0,4,3,9,12,8,12,11,6,9,7,10,1,5,4,5,8,3,6,9,0,12,10,9,1,5,3,2,3,6,8,4,3,5,6,5,10,4,12,10,1,7,3,1,11,10,12,4,0,12,10,11,5,10,9,7,0};
static const short Gen_shift_values_BG2_Z_14[1483]= {1,10,11,11,4,2,8,5,12,1,3,2,8,7,1,11,10,2,11,3,11,0,6,1,7,2,6,1,2,11,12,11,12,5,3,8,9,6,12,13,2,4,3,9,8,2,12,10,11,3,12,4,12,1,7,2,7,8,3,7,1,2,10,11,12,11,12,5,3,8,9,6,12,13,1,2,4,2,3,9,8,1,2,12,10,11,2,3,12,3,4,12,0,1,7,2,7,8,2,3,7,2,11,12,12,5,2,3,9,5,6,13,2,4,3,9,7,8,2,11,12,11,3,11,12,4,11,12,1,7,1,2,8,3,6,7,4,5,0,1,3,0,1,8,6,1,11,12,9,1,2,5,7,6,12,11,5,1,13,0,6,1,7,1,4,10,5,10,11,6,10,12,13,8,9,2,8,9,2,0,11,5,6,3,9,10,13,1,0,6,5,13,9,1,7,8,0,9,1,9,8,12,4,13,4,5,0,4,0,1,10,11,10,10,11,4,2,7,8,5,11,12,1,3,2,8,7,1,11,12,9,10,2,11,3,11,2,0,6,1,6,7,2,6,11,11,12,1,7,10,8,11,7,8,11,1,4,13,1,2,4,4,5,8,2,4,5,8,9,12,12,1,0,3,13,2,5,8,4,6,7,12,1,8,10,11,12,6,7,10,13,2,8,10,11,0,3,8,10,11,6,11,0,3,6,12,0,1,3,4,7,13,2,3,5,6,13,0,8,9,10,6,9,10,3,1,0,6,7,4,10,11,13,0,2,0,1,7,6,13,0,10,8,9,0,1,10,1,2,10,12,13,5,0,5,6,0,1,5,3,0,1,12,10,13,11,13,10,11,6,4,4,2,1,10,7,8,7,5,0,11,12,3,1,5,3,4,2,10,8,9,7,3,1,13,11,12,9,10,4,2,13,11,5,3,13,11,2,0,8,6,3,1,1,9,6,7,4,2,8,6,5,9,7,13,3,12,13,0,13,6,3,4,10,6,7,0,3,5,4,10,8,9,3,12,13,12,4,12,13,5,12,13,11,2,8,2,3,9,4,7,8,11,12,13,8,9,8,9,2,0,3,5,6,3,9,10,13,1,6,0,6,5,13,9,7,8,0,9,1,9,12,4,13,4,5,0,4,2,11,12,8,12,5,2,3,0,9,5,6,13,2,4,3,9,7,8,2,11,12,11,3,11,12,4,11,12,1,7,1,2,2,8,3,6,7,13,0,6,9,1,10,2,9,10,2,3,9,1,6,7,7,6,7,13,4,9,10,10,11,3,0,6,2,8,1,7,7,13,6,11,12,0,6,10,1,2,8,9,1,1,7,10,1,2,10,2,8,10,1,2,13,5,5,11,0,5,6,5,6,12,1,7,5,10,11,5,13,0,0,9,1,10,3,1,9,10,8,3,6,1,12,6,7,9,4,2,10,11,5,0,7,2,6,1,12,7,11,6,5,0,1,10,0,8,9,6,1,1,10,7,2,1,10,4,13,10,5,5,0,11,5,6,6,1,10,5,9,10,0,1,5,9,10,6,11,5,6,10,11,13,4,11,2,4,2,3,7,8,0,5,6,7,11,12,10,0,1,12,3,11,1,2,3,8,2,7,10,0,1,6,11,4,5,9,10,11,1,2,6,11,12,2,3,6,11,9,13,0,1,6,10,1,1,2,6,7,11,1,2,1,6,3,11,12,3,4,7,12,13,8,0,7,8,13,0,1,7,13,5,5,4,5,10,11,2,8,8,9,0,1,12,3,4,0,6,13,4,5,5,11,4,10,12,3,4,8,0,5,6,7,12,13,13,4,5,8,0,0,5,6,8,0,11,2,3,3,9,12,4,3,4,9,10,13,4,5,3,9,11,1,1,3,12,13,6,13,6,4,11,10,7,0,3,5,4,10,9,3,13,12,4,13,5,13,2,8,3,9,4,8,2,3,12,13,12,13,6,4,5,9,10,7,13,0,3,5,4,10,9,5,3,13,11,12,4,13,5,13,2,8,3,8,9,4,8,13,8,9,9,9,2,13,0,6,2,3,10,13,1,0,6,4,5,13,8,9,8,0,8,9,1,8,9,12,4,12,13,0,5,0,3,4,6,0,1,11,7,12,3,6,0,9,12,13,8,7,8,3,9,4,8,9,4,2,11,0,8,9,5,6,1,3,11,12,5,9,10,5,12,13,8,1,10,13,0,9,6,1,5,13,0,12,13,8,9,3,4,7,8,3,13,0,9,9,3,4,0,1,10,9,3,4,5,11,12,7,4,13,13,7,8,4,5,0,13,0,9,4,12,13,12,5,5,1,10,9,4,7,1,2,7,2,11,12,12,5,2,3,6,9,5,6,13,2,4,3,9,7,8,2,11,12,11,3,11,12,4,11,12,1,7,1,2,8,3,6,7,13,0,8,9,10,9,9,10,3,1,6,7,4,10,11,13,0,2,0,1,7,6,13,0,10,6,8,9,0,1,10,1,2,10,12,13,5,0,5,6,0,1,5,12,7,8,8,1,13,5,2,0,9,12,0,13,5,4,12,8,7,13,8,0,8,11,11,3,12,4,13,3,6,7,1,1,2,10,3,11,0,2,3,11,10,4,8,1,2,13,0,8,11,4,5,3,4,12,6,7,1,9,3,7,8,2,0,8,13,6,7,6,7,1,3,10,11,1,2,10,7,8,2,3,10,11,8,9,3,3,10,11,5,6,0,12,6,7,0,1,12,13,7,7,8,2,12,5,6,0,1,10,11,10,11,4,2,6,7,8,5,11,12,1,3,2,8,7,1,11,10,9,10,2,11,3,11,0,6,1,6,7,2,6,0,6,12,13,0,8,9,9,10,9,10,2,3,0,0,1,6,7,3,3,4,10,11,13,0,1,2,0,1,6,7,5,5,6,13,0,9,9,10,8,9,0,1,9,9,10,1,2,9,9,10,12,13,4,5,13,13,0,5,6,0,1,4,4,5,5,6,1,2,1,2,9,7,8,12,13,10,2,3,6,8,7,13,12,6,2,12,0,1,7,2,8,2,5,11,6,11,12,7,11,1,2,10,11,12,7,11,12,5,3,8,9,6,12,13,1,2,4,2,3,9,8,1,2,12,10,11,2,3,12,3,4,12,12,0,1,7,2,7,8,2,3,7,8,10,3,5,4,6,4,6,11,13,9,10,11,1,3,12,13,0,13,5,7,8,10,10,12,9,11,1,3,0,1,2,8,10,4,5,6,3,5,9,11,4,5,6,10,12,4,5,6,7,9,13,1,8,9,10,0,2,9,11,13,0,1,12,13,8,9,8,9,2,0,7,5,6,3,9,10,13,1,0,6,5,13,9,2,7,8,0,9,1,9,12,4,13,4,5,0,4};
static const short Gen_shift_values_BG2_Z_15[1483]= {9,6,13,10,0,13,10,5,5,8,2,2,7,4,11,4,7,5,8,7,3,8,4,12,6,1,14,9,10,7,14,10,11,1,14,10,11,6,5,6,9,3,3,8,5,12,5,7,8,6,9,8,4,9,5,13,6,7,2,0,9,10,6,7,14,10,11,1,14,10,11,6,5,6,8,9,3,2,3,8,5,11,12,5,7,8,5,6,9,7,8,4,8,9,5,13,6,7,1,2,0,10,7,14,11,1,13,14,11,5,6,6,9,3,3,8,4,5,12,4,5,8,6,8,9,8,3,4,9,5,12,13,7,2,14,0,9,10,7,14,13,10,11,1,14,4,10,11,6,5,6,9,3,3,8,5,12,5,7,8,6,9,8,4,9,5,13,6,7,2,0,6,7,4,11,0,7,8,13,11,10,7,8,3,2,3,6,0,0,5,2,9,2,3,4,5,3,6,5,1,12,6,2,10,3,4,14,12,5,6,3,10,1,6,7,12,10,6,7,2,1,2,5,14,14,4,1,8,1,11,3,4,2,5,4,0,6,5,1,9,2,3,13,11,3,1,2,14,14,11,6,3,2,3,0,8,5,6,2,3,10,2,3,0,13,9,10,12,13,10,1,13,10,7,10,7,0,12,12,8,9,4,1,12,8,9,5,14,0,12,13,10,1,12,13,0,12,11,7,8,11,1,13,12,9,5,1,2,13,14,11,9,6,7,3,4,9,10,6,7,14,10,10,11,1,14,3,10,11,6,5,6,8,9,3,2,3,8,5,11,12,5,7,8,5,6,9,7,8,4,8,9,5,13,6,7,1,2,0,12,2,3,9,0,1,7,13,3,4,3,9,1,7,1,13,3,4,8,14,8,13,14,11,2,5,11,5,11,10,1,7,13,14,5,7,13,10,0,1,8,14,11,2,10,1,6,12,11,2,7,13,0,6,12,9,14,0,4,10,2,8,7,6,12,6,1,13,5,12,2,7,4,5,2,11,12,12,0,9,9,14,10,11,3,10,11,14,12,14,0,14,9,10,3,0,11,3,4,13,8,5,6,2,6,7,4,11,7,8,13,11,3,7,8,3,2,3,6,0,1,0,5,2,9,2,4,5,3,6,5,1,6,2,10,3,4,14,12,4,1,8,2,5,10,7,8,11,5,14,0,0,3,12,12,2,13,14,6,13,14,2,0,2,3,2,12,13,3,14,6,7,1,1,11,8,9,3,4,7,1,4,8,11,4,5,8,10,13,8,10,11,6,4,5,8,0,2,3,14,0,3,3,6,12,0,12,0,2,5,14,1,2,6,9,14,1,2,1,2,5,0,3,3,5,6,6,2,5,13,0,1,3,6,14,2,7,9,10,0,1,4,11,14,9,11,12,1,1,2,13,14,5,6,7,2,2,3,7,8,5,6,2,2,3,12,13,12,12,13,0,1,9,10,9,10,14,0,11,12,3,4,11,12,14,14,0,12,13,0,1,14,0,10,11,0,1,11,12,4,5,13,13,14,8,9,6,7,4,5,1,2,2,13,14,9,6,5,6,2,3,11,8,9,6,4,5,6,2,3,1,13,0,1,12,13,4,0,1,13,10,13,9,10,3,0,0,12,7,3,4,0,12,2,3,14,0,1,12,13,4,1,3,14,0,14,11,4,0,1,0,12,8,5,1,2,13,14,12,8,9,10,7,7,9,10,2,3,7,14,0,14,7,10,11,3,4,1,9,14,7,0,10,11,3,4,6,14,5,6,13,14,9,1,2,3,11,3,10,11,8,1,5,13,12,4,5,5,13,7,7,8,0,1,6,13,14,9,2,8,0,1,4,12,9,1,2,5,13,13,6,6,7,14,0,2,9,10,0,8,7,0,14,7,4,11,8,8,13,11,8,8,3,3,6,0,0,5,2,9,2,5,3,6,5,1,6,2,10,4,14,12,0,1,13,5,1,2,7,5,11,1,2,12,11,12,0,9,9,14,11,1,3,11,13,14,12,0,14,10,0,11,4,12,13,8,6,6,3,10,12,7,12,9,10,7,1,2,2,5,14,14,4,0,1,8,0,1,4,2,4,5,4,14,0,5,1,8,9,12,3,13,10,11,14,13,4,3,5,5,3,9,5,4,4,5,6,1,2,3,9,10,5,6,7,11,12,9,9,10,5,6,7,1,1,2,10,0,1,2,3,4,5,13,14,12,13,14,3,4,0,0,1,6,7,8,0,0,1,2,3,4,0,1,2,4,4,5,2,3,4,14,14,0,5,3,4,5,0,1,8,8,9,1,2,3,11,12,13,10,10,11,3,0,6,8,0,9,11,6,3,10,1,11,8,0,12,2,14,0,5,12,6,7,7,10,4,4,9,5,6,13,5,6,9,7,9,10,9,4,5,10,6,13,14,8,3,0,1,5,6,2,3,10,13,6,7,12,10,6,7,2,1,2,4,5,14,13,14,4,1,7,8,1,13,3,4,1,2,5,3,4,0,4,5,1,9,2,3,12,13,11,10,7,14,11,1,14,11,6,0,6,9,3,3,8,5,12,5,8,6,9,8,4,1,9,5,13,7,2,0,9,10,1,6,7,13,14,5,3,10,11,2,1,7,14,4,5,10,11,2,6,11,12,5,6,12,8,9,0,3,9,2,3,9,8,14,5,10,11,11,12,3,5,10,11,7,8,14,5,6,12,9,14,0,7,8,14,4,9,10,8,9,0,5,11,13,3,4,6,7,13,1,2,8,0,5,6,4,5,2,9,5,6,11,9,9,5,6,1,0,1,4,13,13,3,0,7,0,14,2,3,1,4,3,14,4,0,8,1,2,12,10,12,6,0,13,4,10,1,2,8,14,5,4,10,2,7,8,14,5,9,14,0,9,0,12,3,6,12,6,12,11,2,8,13,14,0,6,8,13,14,11,2,9,0,12,2,3,11,2,7,12,13,12,3,8,14,1,6,7,10,1,5,11,3,8,9,9,10,7,14,10,11,1,14,11,10,11,6,5,6,9,3,3,8,5,12,5,10,7,8,6,9,8,4,9,5,13,6,7,2,0,3,4,0,1,8,1,4,5,10,8,4,5,0,14,0,2,3,12,11,12,2,14,5,6,14,1,2,14,0,3,1,2,13,14,2,3,14,7,0,1,10,11,9,1,10,13,7,5,14,2,11,7,1,5,13,14,2,11,12,5,6,2,12,6,0,9,9,3,9,3,14,8,11,4,5,3,12,11,4,5,14,8,12,6,0,8,9,14,8,10,3,4,0,9,11,5,4,12,13,13,7,8,2,6,14,0,14,0,12,4,0,1,6,4,7,0,1,11,10,11,14,8,8,13,10,2,10,4,12,13,11,14,13,9,14,10,3,11,12,7,5};
static const short Gen_shift_values_BG2_Z_16[1483]= {7,5,15,3,0,6,10,8,8,4,10,11,2,12,11,6,11,0,15,10,4,14,14,0,11,10,14,8,7,5,15,4,3,0,6,11,10,8,9,8,4,10,11,2,12,11,6,12,11,0,15,10,4,14,14,0,12,11,10,14,8,7,6,5,15,4,3,0,6,11,10,8,9,8,5,4,10,12,11,2,12,12,11,6,12,11,1,0,15,11,10,4,15,14,14,0,12,11,11,10,14,7,5,15,3,0,7,6,10,9,8,8,4,10,11,2,13,12,11,7,6,11,0,0,15,10,5,4,14,14,1,0,11,10,15,14,15,14,12,6,2,11,10,7,13,5,2,1,15,0,15,11,1,2,9,3,2,13,3,2,7,6,1,11,5,5,7,3,2,1,5,15,14,12,6,6,11,10,7,13,8,2,1,15,0,15,11,1,2,9,3,2,13,1,3,2,7,6,1,11,14,5,5,7,3,2,1,5,6,5,3,13,10,2,1,14,4,9,8,6,7,6,2,8,9,0,10,9,4,3,10,9,14,13,8,2,12,12,12,14,10,9,8,12,11,11,10,11,8,9,2,3,7,6,7,3,4,11,9,10,0,14,13,14,13,11,12,12,11,12,7,8,13,14,14,15,5,6,1,15,0,14,15,11,9,10,2,15,14,15,3,4,4,2,3,13,14,9,7,8,11,1,2,1,2,5,3,4,15,14,15,13,14,3,1,2,14,13,12,11,5,13,10,9,6,12,13,1,0,14,15,14,11,10,0,2,1,8,2,2,1,12,2,1,7,6,5,1,0,10,5,4,4,6,2,1,1,0,4,15,4,14,2,12,12,6,11,0,10,13,7,3,13,10,2,7,1,5,15,0,5,15,1,11,7,1,8,2,15,9,9,3,8,2,3,13,3,8,2,13,7,12,6,7,1,1,11,11,5,11,5,13,7,12,3,8,2,7,1,11,5,10,8,15,4,15,13,7,10,11,8,15,14,2,1,0,0,12,2,3,10,5,4,3,15,14,3,8,8,7,2,13,12,11,6,6,9,8,3,2,7,6,1,6,5,3,13,2,1,14,4,14,9,8,6,7,6,2,8,14,9,0,10,9,4,10,9,14,13,8,2,12,12,14,10,9,8,12,5,3,13,2,1,14,5,4,1,8,7,6,6,2,8,9,0,11,10,9,5,4,9,14,14,13,8,3,2,12,12,15,14,5,9,8,13,12,11,10,15,8,13,2,7,7,6,11,3,8,15,9,14,2,14,13,2,1,11,0,12,11,0,7,12,13,2,14,3,5,10,5,15,4,14,3,15,9,14,15,14,3,3,8,8,2,7,0,13,2,13,7,12,1,6,1,6,9,3,8,15,14,3,13,2,7,1,6,13,6,12,4,10,14,4,2,9,2,8,15,5,5,11,0,9,15,7,13,14,7,13,3,9,9,15,10,0,1,7,11,1,10,0,5,11,1,10,0,15,5,14,4,9,15,3,9,13,3,13,3,15,5,1,10,0,9,15,13,3,0,10,15,9,8,13,7,7,1,12,6,11,5,8,2,14,8,10,3,13,2,12,0,10,1,11,0,10,7,12,6,2,12,14,3,13,10,4,4,14,14,3,13,14,8,4,14,3,13,3,8,2,7,1,13,2,12,12,6,1,6,0,6,0,8,2,4,14,3,13,13,2,12,6,0,13,10,8,9,7,6,7,5,1,15,6,4,5,3,2,0,8,6,13,13,11,12,10,10,8,11,9,10,8,5,6,4,12,10,12,13,11,4,2,14,12,12,13,11,8,6,11,14,12,13,11,1,2,0,1,15,11,12,10,6,4,15,0,14,0,14,2,0,14,12,13,11,11,12,10,0,14,11,1,1,0,14,8,6,12,9,15,3,3,1,1,13,3,4,11,5,4,15,4,9,8,3,13,7,7,9,4,3,7,5,4,2,12,1,0,13,3,9,8,7,5,6,5,1,7,8,15,9,8,8,3,9,8,13,12,7,1,11,11,13,9,8,7,11,9,7,1,11,5,2,9,8,12,11,10,10,6,12,13,4,15,14,13,9,8,13,2,2,1,12,7,6,0,0,3,2,9,13,12,1,0,13,14,6,10,13,13,10,7,3,11,8,7,1,6,5,15,15,9,4,3,13,0,10,1,6,0,11,10,4,3,8,2,12,9,8,2,5,4,14,10,4,12,11,5,2,12,7,12,6,12,11,5,1,6,0,12,11,5,1,0,10,10,15,9,11,10,4,15,4,14,14,15,14,8,14,8,11,0,10,12,11,5,11,10,4,9,14,8,7,6,1,4,6,1,11,6,15,8,3,8,6,0,4,1,8,7,9,11,10,9,9,5,11,12,3,14,13,12,8,7,12,1,1,0,11,6,5,15,15,2,1,12,11,0,15,14,13,12,11,5,1,10,9,6,12,1,0,14,15,14,11,10,0,2,1,8,2,2,1,12,11,2,1,7,6,5,1,0,10,5,4,4,6,2,1,1,0,4,2,0,10,14,11,1,5,3,3,3,15,5,6,13,7,6,1,6,11,10,5,15,3,9,9,11,6,5,9,13,12,11,11,10,9,4,3,2,9,8,7,5,4,11,11,10,0,15,14,13,13,12,14,13,12,10,9,8,15,14,1,0,15,7,6,1,1,0,1,0,15,11,11,10,1,0,15,6,5,4,4,4,3,0,15,14,9,9,8,4,3,2,3,2,5,5,4,1,0,15,0,15,14,3,3,2,7,6,4,14,3,2,15,5,8,10,9,7,8,7,3,9,10,1,11,10,5,7,11,10,15,14,9,3,13,13,15,11,10,9,13,11,5,9,2,14,0,12,10,6,14,10,11,7,14,1,13,5,1,0,3,15,3,15,15,11,5,1,6,2,13,9,4,7,3,6,2,14,1,13,6,2,11,7,7,10,6,5,1,12,15,11,9,5,9,5,8,11,7,6,2,5,1,6,9,5,14,13,11,5,10,9,6,12,14,1,0,14,15,14,10,0,1,8,2,1,12,1,2,1,6,5,0,10,4,4,6,2,1,0,4,10,9,8,7,1,14,6,5,2,8,13,12,10,11,10,7,6,12,14,13,4,14,14,13,8,14,13,3,2,1,13,12,6,11,1,0,0,2,14,13,13,12,0,2,15,0,13,10,7,14,11,11,8,15,1,14,5,2,1,3,0,15,3,0,15,12,5,2,6,3,13,10,5,7,4,6,3,15,1,14,6,3,11,8,8,10,7,5,2,13,15,12,9,6,9,6,9,11,8,6,3,5,2,7,9,6,14,13,11,5,10,9,6,12,0,1,0,14,15,14,10,0,1,8,2,1,12,4,2,1,6,5,0,10,4,4,6,2,1,0,4};
static const short Gen_shift_values_BG2_Z_18[1483]= {1,17,3,6,14,10,15,11,15,2,0,12,0,2,10,2,5,10,17,6,11,13,1,0,17,12,5,2,1,17,3,7,6,14,10,16,15,11,16,15,2,0,12,0,2,10,2,6,5,10,17,6,11,13,1,0,0,17,12,5,2,1,0,17,3,7,6,14,10,16,15,11,16,15,3,2,0,13,12,0,2,11,10,2,6,5,11,10,17,7,6,11,14,13,1,0,0,17,13,12,5,1,17,3,6,14,11,10,15,12,11,15,2,0,12,0,3,2,10,3,2,5,10,0,17,6,12,11,13,1,1,0,17,12,6,5,17,16,14,0,5,4,3,11,7,5,13,12,8,13,12,17,15,9,15,17,7,17,3,2,7,14,3,8,10,16,15,15,14,9,2,1,0,16,2,3,6,5,13,9,13,15,14,10,15,14,1,17,11,17,1,9,1,11,5,4,9,16,5,10,10,12,0,17,17,16,11,4,15,14,12,16,0,2,1,9,5,11,10,6,11,10,15,13,7,13,15,5,15,14,1,0,5,12,1,6,16,8,14,13,13,12,7,0,6,2,1,12,17,10,3,14,7,6,17,14,7,10,4,3,6,16,15,8,11,5,4,16,15,8,2,13,0,11,12,5,0,11,2,14,13,10,3,2,14,13,8,6,5,16,10,3,17,11,10,6,17,11,5,4,16,13,6,1,12,0,12,11,0,17,10,12,5,5,17,16,0,17,16,15,1,15,5,4,12,8,14,14,13,9,14,13,1,0,16,11,10,16,0,9,8,0,4,3,9,8,15,5,4,9,12,11,17,16,16,15,11,10,3,7,15,14,5,12,9,16,12,2,1,2,9,16,5,6,3,11,10,17,6,3,11,10,8,15,6,13,0,7,6,13,8,15,16,5,8,15,11,1,0,16,5,5,12,12,1,17,6,1,8,7,14,6,13,3,5,13,12,0,7,11,0,9,4,10,5,11,9,13,9,16,6,3,2,7,4,3,7,12,10,4,10,13,12,2,13,12,15,2,10,9,16,4,3,11,5,11,11,10,9,4,16,15,7,7,6,4,8,12,11,1,15,14,3,2,16,3,2,7,5,13,17,5,7,15,7,11,10,15,4,11,16,0,6,5,5,4,17,10,12,10,14,3,17,7,4,3,0,8,5,4,8,13,11,5,11,14,13,3,14,13,16,3,11,10,17,5,4,6,12,12,11,7,10,5,17,16,6,5,8,3,6,7,10,11,10,13,0,3,14,0,17,16,2,1,4,15,1,0,2,1,4,6,9,4,7,16,1,4,7,6,10,9,14,17,6,10,9,10,9,12,14,17,3,7,6,14,10,13,15,1,0,17,2,5,8,4,8,7,4,3,6,16,1,9,13,12,7,4,3,5,1,9,5,12,12,9,8,2,16,16,12,3,0,17,17,13,3,0,17,8,4,6,2,0,14,6,2,8,4,16,12,8,4,11,8,7,16,12,5,1,12,8,17,13,1,15,7,3,6,2,5,2,1,0,14,11,7,12,11,10,9,9,8,7,13,11,17,16,15,14,6,4,2,0,11,8,7,6,5,3,1,8,7,6,5,12,11,10,10,8,4,3,2,10,8,12,10,2,1,0,12,10,16,15,14,13,2,1,0,9,7,16,15,14,3,1,5,4,3,11,9,10,8,10,9,8,7,4,3,2,15,13,8,13,12,8,7,10,6,5,14,9,0,17,13,12,7,2,3,16,11,9,8,4,3,4,17,9,8,4,3,13,9,8,11,6,5,1,0,11,6,13,8,3,17,16,13,8,6,17,16,12,11,3,17,16,10,5,17,13,12,4,17,6,2,1,12,7,11,6,11,10,6,5,5,1,0,16,11,16,15,15,6,4,8,6,11,1,15,9,2,16,2,7,5,17,5,7,15,7,10,15,4,11,16,0,6,5,4,17,10,8,7,5,9,13,12,2,16,1,4,3,17,4,3,8,6,0,6,8,12,16,8,12,11,16,5,12,17,1,7,6,6,5,0,11,10,8,12,0,15,5,2,1,6,3,2,6,11,9,3,9,12,11,1,12,11,14,1,9,8,15,3,2,4,10,10,9,2,8,3,15,14,17,5,13,6,1,11,5,10,1,8,12,11,8,10,9,6,13,10,17,16,13,6,3,2,0,17,8,7,4,3,1,0,15,8,7,4,13,12,9,10,7,5,4,1,10,7,12,10,9,3,2,17,12,10,9,16,15,12,3,2,17,9,7,6,17,16,13,3,1,0,9,6,5,2,11,8,10,8,7,10,9,6,5,4,1,15,13,12,12,9,15,4,6,6,6,14,1,13,15,14,12,16,1,9,6,5,7,10,7,6,10,15,13,7,13,16,15,5,16,15,0,5,13,12,1,7,6,8,14,14,13,12,7,1,0,1,0,17,16,2,13,6,5,13,9,15,14,10,15,14,2,1,17,12,11,17,1,10,9,1,16,5,4,10,9,16,6,5,10,13,12,0,17,17,16,12,11,4,3,1,5,8,16,12,17,13,8,17,4,2,14,2,4,12,4,7,12,1,8,13,5,15,3,2,1,14,7,9,8,7,7,6,5,10,9,0,14,13,12,3,2,17,17,16,5,4,3,0,0,17,5,4,3,10,9,8,7,6,2,1,0,7,6,9,9,8,0,17,16,9,9,8,13,12,11,0,17,16,6,6,5,14,13,12,0,0,17,3,2,1,8,7,7,7,6,7,6,5,2,1,0,12,12,11,5,4,2,6,10,9,17,13,5,1,0,14,1,0,5,3,15,3,5,13,5,10,9,8,13,2,9,14,16,4,3,3,2,15,8,12,2,7,8,3,6,1,10,5,13,8,3,16,17,13,12,4,17,0,14,13,4,17,9,4,7,2,1,14,7,2,9,5,4,17,12,9,5,4,12,7,17,12,6,2,1,13,8,0,14,13,2,15,8,3,7,3,2,6,1,1,14,12,8,7,3,2,0,4,8,7,15,11,0,17,16,12,17,16,3,1,13,1,3,11,3,15,7,6,11,0,7,12,14,2,1,1,0,13,6,0,17,16,15,1,10,5,4,12,8,14,13,9,14,13,1,0,16,11,10,16,0,9,8,0,4,3,9,8,15,5,4,9,13,12,11,17,16,16,15,11,10,3,2,13,0,11,4,15,7,0,15,8,11,5,4,16,9,12,6,5,5,16,9,3,14,1,12,13,6,1,12,3,15,14,11,4,3,15,14,6,17,11,4,0,12,11,7,0,12,6,5,14,7,2,13,1,13,12,0,11,13,6,6,0,17,3,2,0,4,8,7,15,11,11,17,16,12,17,16,3,1,13,1,3,11,3,10,7,6,11,0,7,12,14,2,1,1,0,13,6};
static const short Gen_shift_values_BG2_Z_20[1483]= {18,15,18,18,12,16,18,13,18,2,17,18,7,0,18,4,18,6,10,18,15,18,6,11,18,13,4,19,18,15,18,19,18,12,16,19,18,13,19,18,2,17,18,7,0,18,4,19,18,6,10,18,15,18,6,11,19,18,13,4,19,18,16,15,18,19,18,12,16,19,18,13,19,18,3,2,17,19,18,7,0,19,18,4,19,18,7,6,10,19,18,15,19,18,6,11,19,18,14,13,4,18,15,18,18,12,17,16,18,14,13,18,2,17,18,7,1,0,18,5,4,18,6,11,10,18,16,15,18,6,12,11,18,13,5,4,16,15,12,15,19,16,15,9,13,15,16,15,10,16,15,19,14,15,4,17,15,1,16,15,3,7,15,12,15,3,8,16,15,10,1,3,2,19,2,19,3,2,16,0,10,3,2,17,3,2,6,1,2,11,4,2,8,1,3,2,10,14,2,19,0,2,10,15,3,2,17,8,7,6,3,6,19,7,6,0,4,7,6,1,7,6,10,5,6,15,8,6,12,3,7,6,14,18,6,3,18,6,14,19,7,6,1,12,4,15,14,16,11,13,14,16,15,14,16,8,10,12,15,14,19,15,14,16,9,12,11,15,14,16,18,0,13,15,14,16,3,5,16,19,18,14,16,0,3,2,4,15,14,16,2,4,6,9,8,14,16,11,14,13,7,14,16,2,4,7,10,9,15,14,16,9,11,0,3,2,6,5,3,2,5,19,6,5,19,3,4,6,5,0,6,5,10,9,4,6,5,14,7,6,5,11,6,5,14,13,17,6,5,2,6,5,13,18,6,5,1,0,11,9,4,3,6,0,9,3,9,4,3,3,17,7,1,19,9,4,3,4,18,9,4,3,13,7,8,2,9,3,18,12,11,5,9,3,15,9,9,4,3,17,11,1,15,9,3,6,0,9,3,17,11,2,16,16,9,4,3,4,18,15,9,19,16,15,19,0,17,0,19,0,14,19,18,0,16,15,0,4,19,0,9,3,2,0,7,6,0,8,13,12,0,18,17,6,0,8,14,13,0,15,7,6,3,7,6,3,6,7,6,0,4,19,7,6,1,7,6,10,5,12,6,15,8,6,12,7,6,14,18,6,3,6,14,19,7,6,1,12,4,1,4,19,4,18,3,2,11,4,0,19,4,8,3,4,13,7,6,4,11,10,4,12,17,16,4,2,1,4,12,18,17,1,4,19,11,10,16,15,5,12,2,15,5,16,15,5,9,19,13,4,3,19,16,15,5,10,1,0,16,15,5,19,9,14,4,15,5,4,14,17,8,7,15,5,1,12,11,16,15,5,3,13,7,18,17,17,15,5,12,3,2,15,5,3,13,8,19,18,16,15,5,10,0,1,12,11,11,18,17,8,14,11,17,19,11,18,17,5,11,9,15,11,18,17,6,12,11,18,17,15,1,10,16,11,17,0,6,13,19,11,17,17,3,11,18,17,19,5,3,9,11,17,8,14,11,17,19,5,4,10,11,18,17,6,12,17,3,10,9,2,1,6,19,18,9,1,10,9,2,1,3,15,7,19,19,10,9,2,1,4,16,10,9,2,1,13,6,5,8,0,9,2,1,18,10,11,3,9,2,1,15,7,10,9,2,1,17,10,9,1,13,9,2,1,6,18,9,2,1,17,9,2,14,10,9,2,1,4,17,16,15,7,18,8,7,17,16,4,14,13,7,16,8,7,17,16,1,10,5,14,19,8,7,17,16,2,11,8,7,17,16,11,1,0,6,15,7,17,16,16,5,9,18,7,17,16,13,2,3,8,7,17,16,15,5,4,19,8,7,17,16,4,13,7,17,16,15,4,0,9,8,7,17,16,2,12,11,13,2,19,17,5,12,9,12,19,12,6,10,17,12,7,12,16,11,12,1,14,12,18,12,0,4,12,9,12,0,5,12,7,18,3,2,19,2,3,2,16,0,19,3,2,17,3,2,6,1,2,11,4,7,2,8,3,2,10,14,2,19,2,10,15,3,2,17,8,11,8,11,19,11,5,10,9,11,7,6,11,15,10,11,0,14,13,11,18,17,11,19,4,3,11,9,8,11,19,5,4,16,11,6,18,17,19,3,19,14,17,19,8,6,19,4,12,11,5,9,8,2,11,5,12,11,5,5,19,9,4,3,12,11,5,6,1,0,19,12,11,5,16,15,9,10,4,12,11,5,0,14,13,8,7,12,11,5,17,12,11,12,11,5,0,19,13,3,18,17,12,11,5,8,3,2,19,12,11,5,19,13,4,19,18,12,11,5,7,6,0,17,12,11,19,11,19,5,9,19,13,19,14,10,13,18,15,18,18,12,17,16,19,18,14,13,18,2,17,18,7,1,0,18,5,4,18,6,11,10,18,16,15,18,6,12,11,18,13,5,4,1,0,18,17,0,19,1,0,14,18,1,0,15,1,0,5,4,19,1,0,9,2,1,0,6,19,1,0,9,8,12,1,0,17,1,0,8,13,1,0,16,15,6,11,8,11,11,5,9,11,6,19,11,15,10,11,0,13,11,17,11,19,3,11,8,7,11,19,4,11,6,17,18,17,16,15,14,13,17,16,19,18,17,16,11,10,15,15,14,18,17,16,12,12,11,18,17,16,2,1,0,16,15,18,17,16,6,5,19,19,18,18,17,16,3,3,2,18,17,16,6,5,4,9,9,8,18,17,16,14,14,13,18,17,16,5,4,10,10,9,18,17,16,13,12,11,3,3,2,5,4,1,4,5,4,18,2,19,5,4,19,5,4,8,3,4,13,6,4,10,16,5,4,12,16,4,1,4,12,17,5,4,19,10,19,2,1,18,2,15,19,18,2,18,2,12,16,16,1,0,18,2,13,18,17,18,2,2,6,17,1,18,2,7,11,0,5,4,18,2,4,9,8,18,2,6,10,10,15,14,18,2,15,0,19,18,2,6,10,11,16,15,18,2,13,17,4,9,8,18,17,14,17,18,17,11,15,19,18,17,12,18,17,1,16,17,6,19,17,3,12,18,17,5,9,17,14,17,5,10,18,17,12,3,17,16,14,13,16,19,17,16,10,14,17,16,11,17,16,1,0,15,17,16,5,18,17,16,2,17,16,5,4,8,17,16,13,3,17,16,4,9,17,16,12,11,2,14,1,11,18,14,1,14,1,8,15,12,0,19,14,1,9,17,16,19,14,1,18,5,13,0,14,1,3,10,16,4,3,14,1,0,8,7,14,1,2,9,6,14,13,14,1,11,19,18,14,1,2,9,7,15,14,14,1,9,16,0,8,7,14,13,10,13,14,13,7,11,19,14,13,8,14,13,17,12,13,2,15,13,19,1,14,13,1,5,13,10,13,1,6,14,13,8,19};
static const short Gen_shift_values_BG2_Z_22[1483]= {0,15,8,9,12,7,12,18,1,19,17,17,14,18,21,15,16,9,15,13,21,15,8,15,11,21,15,1,0,15,8,10,9,12,7,13,12,18,2,1,19,17,17,14,18,21,15,17,16,9,15,13,21,15,8,15,12,11,21,15,1,0,16,15,8,10,9,12,7,13,12,18,2,1,20,19,17,18,17,14,18,0,21,15,17,16,10,9,15,14,13,21,16,15,8,15,12,11,0,21,15,0,15,8,9,12,8,7,12,19,18,1,19,17,17,14,19,18,21,16,15,16,9,16,15,13,0,21,15,8,16,15,11,21,16,15,18,17,10,3,19,5,4,7,2,0,8,7,13,19,18,14,12,12,9,13,16,10,12,11,4,10,8,16,10,3,10,7,6,16,10,17,16,9,2,12,4,3,6,1,17,7,6,12,18,17,13,11,11,8,12,15,9,12,11,10,3,9,7,15,14,9,2,9,6,5,15,9,8,7,0,15,2,17,16,19,14,20,19,3,9,8,4,2,2,21,3,6,0,21,2,1,16,0,20,6,9,0,15,0,19,18,6,0,0,4,3,11,18,4,11,19,13,12,20,15,1,10,19,18,3,16,15,1,21,8,7,5,4,12,0,8,20,6,20,6,17,3,21,8,7,2,10,18,5,4,14,20,19,5,12,20,18,5,4,16,2,2,11,10,1,18,4,11,19,18,5,4,15,14,0,2,10,18,5,4,8,7,1,0,15,8,17,16,19,14,8,20,19,3,9,8,5,4,2,3,2,21,3,7,6,0,2,1,17,16,0,21,20,6,1,0,15,0,19,18,7,6,0,11,21,20,4,13,19,6,20,8,7,1,10,18,5,15,1,11,10,7,16,12,0,21,8,17,6,15,6,15,3,12,7,16,10,19,4,13,5,15,14,20,7,4,13,2,11,10,19,4,13,19,6,4,13,9,0,10,9,10,19,4,13,0,2,19,0,9,2,17,2,18,21,17,16,21,6,5,10,6,4,4,1,6,5,8,3,2,3,18,3,2,0,9,8,20,2,17,3,2,20,8,3,2,1,5,4,19,12,14,13,16,11,11,17,16,0,6,5,1,21,10,21,18,0,3,19,21,20,13,19,17,3,19,12,19,16,15,3,19,17,10,3,6,4,7,3,2,2,7,14,13,18,14,12,12,9,14,13,16,11,10,11,4,11,10,8,17,16,10,3,11,10,4,6,16,11,10,9,8,12,1,5,16,20,18,17,21,20,2,15,20,19,10,21,20,2,4,9,8,10,9,13,5,9,3,7,3,7,0,4,4,9,8,7,11,1,6,5,3,2,6,17,21,1,6,5,12,21,3,7,12,11,1,5,16,20,1,6,5,20,19,1,7,11,1,6,5,15,19,18,8,11,1,4,4,2,6,5,5,8,0,3,5,9,8,11,14,16,20,19,12,15,10,13,10,13,7,10,11,14,14,17,8,11,9,13,12,2,5,8,11,6,9,14,17,8,11,1,4,8,11,4,8,7,14,17,8,11,18,17,12,11,10,5,4,3,19,5,4,21,20,7,1,2,18,11,8,7,2,1,13,7,19,18,13,12,14,9,8,12,6,12,7,6,9,3,13,7,16,11,10,10,4,12,11,6,5,4,21,20,10,4,8,3,2,16,10,10,5,4,3,19,10,4,7,6,1,0,16,11,10,10,4,3,19,18,10,9,11,3,2,4,17,6,5,19,18,8,21,3,16,1,9,8,0,21,14,5,20,19,11,10,15,7,6,13,4,13,5,4,10,1,14,5,17,9,8,11,2,0,13,12,4,3,5,19,18,11,2,9,1,0,17,8,11,3,2,4,17,11,2,8,7,21,20,17,9,8,11,2,18,8,21,13,6,21,12,0,3,20,2,3,9,14,10,8,8,5,9,12,6,7,0,6,4,12,6,21,6,2,12,6,20,19,12,5,7,6,9,4,17,10,9,15,21,20,16,14,14,11,15,7,18,12,14,13,6,12,10,18,12,5,12,9,8,18,12,18,11,4,1,5,8,4,3,8,15,14,19,15,13,13,10,15,14,17,12,11,12,5,12,11,9,18,17,11,4,12,11,11,7,17,12,11,17,8,21,21,17,2,19,16,5,3,10,9,13,3,2,6,17,21,19,18,0,21,3,16,21,20,0,21,3,5,10,9,13,11,10,14,7,6,10,4,8,5,4,8,1,5,5,10,9,9,8,12,2,7,6,4,3,7,19,18,0,2,7,6,1,0,4,8,13,12,15,3,2,6,17,21,2,7,6,21,20,2,9,8,12,2,7,6,19,15,19,1,16,6,6,17,18,4,6,16,9,2,3,6,2,1,6,6,13,12,17,13,11,11,8,13,12,15,10,9,10,3,10,9,7,16,15,9,2,10,9,5,15,10,9,11,10,4,3,18,5,20,19,0,17,1,0,6,12,11,8,7,5,6,5,2,6,10,9,3,6,5,4,20,19,3,2,1,9,4,3,18,3,0,21,10,9,3,7,0,15,16,19,14,19,3,16,8,4,2,2,21,3,6,0,1,16,0,20,6,4,0,15,0,18,6,0,20,19,8,13,12,1,5,16,10,7,6,17,9,20,4,16,15,10,9,20,15,5,4,21,20,9,17,16,5,14,3,15,14,3,11,0,15,5,4,19,18,7,12,2,1,14,13,2,7,6,17,12,2,1,11,10,21,18,8,7,13,12,1,5,16,12,2,1,9,8,19,19,18,7,12,2,1,19,18,11,4,6,5,8,3,15,9,8,14,20,19,15,13,13,10,14,17,11,19,13,12,5,11,9,17,11,4,11,8,7,17,11,6,21,18,13,16,6,9,21,2,0,3,3,6,20,2,1,3,6,9,13,12,14,17,10,13,8,11,8,11,5,8,9,13,12,12,15,6,10,9,7,10,0,3,6,10,9,4,7,12,16,15,6,9,21,2,6,10,9,2,5,12,15,6,10,9,20,19,12,5,7,6,9,4,1,10,9,15,21,20,16,14,14,11,15,18,12,6,14,13,6,12,10,18,12,5,12,9,8,18,12,18,17,11,10,3,20,5,4,7,2,8,7,13,19,18,15,14,12,13,12,9,13,17,16,10,12,11,5,4,10,9,8,16,5,11,10,3,10,7,6,17,16,10,2,16,17,9,10,2,11,3,14,6,9,2,1,14,6,20,13,12,5,3,17,21,13,19,11,19,11,16,8,20,13,12,1,15,17,10,9,18,10,11,3,17,10,9,15,7,1,16,15,17,9,10,2,17,10,9,13,5,1,15,17,10,9,9,8,1,16,18,17,20,15,21,21,20,4,10,9,5,3,3,0,4,7,1,5,3,2,17,1,21,7,1,16,1,20,19,7,1};
static const short Gen_shift_values_BG2_Z_24[1483]= {4,1,23,23,16,14,20,5,16,10,19,22,12,15,18,22,21,5,1,17,20,15,16,2,2,1,16,5,4,1,23,0,23,16,14,21,20,5,17,16,10,19,22,12,15,18,22,22,21,5,1,17,20,15,16,2,3,2,1,16,5,4,2,1,23,0,23,16,14,21,20,5,17,16,11,10,19,23,22,12,15,19,18,22,22,21,6,5,1,18,17,20,16,15,16,2,3,2,2,1,16,4,1,23,23,16,15,14,20,6,5,16,10,19,22,12,16,15,18,23,22,21,5,2,1,17,21,20,15,16,3,2,2,1,17,16,10,9,6,4,23,5,4,21,19,1,2,1,10,22,21,15,0,3,17,20,23,3,3,2,10,6,22,1,20,21,7,8,7,6,21,5,4,1,23,9,0,23,16,14,19,21,20,5,17,16,10,19,22,12,15,18,22,0,22,21,5,1,17,20,7,15,16,2,3,2,1,16,21,20,17,15,8,16,15,8,6,13,12,21,9,8,2,11,14,4,7,10,14,19,14,13,21,17,9,12,3,7,8,18,19,18,17,8,0,11,10,3,7,0,5,22,6,5,22,22,15,20,14,13,7,3,2,19,11,5,4,23,22,15,16,9,1,18,4,21,18,11,21,15,14,0,17,4,22,21,17,4,3,20,11,4,7,1,0,23,16,2,20,19,15,21,14,22,15,8,2,1,9,8,1,7,0,22,16,15,13,12,10,9,7,21,8,7,0,22,21,5,4,13,1,0,19,18,3,7,6,20,23,3,2,6,6,5,14,13,9,2,1,4,0,23,0,10,11,10,10,9,0,21,15,14,18,11,16,9,16,10,9,9,2,7,0,3,13,7,6,22,15,9,3,2,3,20,12,5,15,8,5,22,8,1,11,4,15,8,14,8,7,22,15,18,11,10,3,13,6,8,1,9,2,19,12,11,19,13,12,18,11,9,2,10,7,21,3,14,11,9,7,9,2,1,0,6,16,15,2,20,5,8,22,2,1,4,9,8,7,15,12,11,3,7,6,19,1,2,13,12,12,11,3,2,5,16,15,12,10,11,10,3,1,14,8,7,16,4,3,21,6,20,9,23,2,5,9,9,8,16,12,4,7,2,3,13,14,13,12,3,2,23,21,0,21,14,13,12,4,18,4,3,14,8,17,20,10,14,13,16,21,20,19,3,0,23,15,19,18,13,14,1,0,10,0,23,15,14,2,1,23,22,20,20,18,21,20,18,13,11,11,10,9,18,18,17,15,2,1,0,14,13,11,7,5,16,14,19,17,9,7,12,11,10,15,13,19,18,17,19,18,16,2,0,22,21,20,21,14,12,17,16,15,12,10,13,11,23,22,21,0,23,21,22,20,13,12,11,19,14,13,16,10,14,8,19,14,9,8,7,1,5,23,11,6,5,20,14,7,2,1,1,19,10,4,13,7,3,21,6,0,9,3,13,7,12,7,6,20,14,16,10,8,2,11,5,6,0,7,1,17,11,17,12,11,16,10,7,1,20,19,21,20,16,18,17,14,15,15,14,16,15,7,8,5,6,14,12,11,13,12,20,21,8,7,9,8,1,3,2,10,11,13,15,14,3,4,6,7,9,11,10,13,14,13,12,14,13,20,22,21,16,17,8,10,9,11,12,6,8,7,7,8,17,18,18,17,19,18,16,18,17,7,8,8,14,13,11,10,10,8,7,8,5,9,8,6,5,1,22,23,20,13,6,5,3,2,14,11,2,1,23,22,19,17,16,4,1,7,5,4,21,18,0,21,3,1,0,7,4,22,7,6,4,3,14,12,11,10,7,2,0,23,5,2,0,22,21,1,22,11,8,12,11,9,8,10,8,7,1,22,17,5,21,16,13,11,9,11,4,2,17,8,17,4,22,7,10,0,3,6,10,9,17,13,5,8,3,4,14,14,13,4,14,13,10,8,9,8,1,23,3,6,5,14,2,1,19,4,7,21,0,12,3,7,7,6,14,10,2,5,0,1,11,12,11,10,1,23,20,18,12,18,11,10,9,15,1,0,11,5,14,17,7,11,10,13,18,17,16,0,21,20,12,16,15,10,11,22,21,6,21,20,12,11,19,3,9,13,22,13,8,15,20,20,12,11,17,9,8,14,6,12,7,6,12,23,5,21,4,3,4,3,9,12,19,18,18,0,23,5,18,17,23,2,8,6,5,11,19,1,22,5,4,2,1,7,5,12,11,5,4,10,13,12,18,8,15,14,1,0,6,3,10,9,16,23,22,4,23,5,9,16,15,10,9,15,9,8,14,23,6,5,6,1,21,14,23,13,16,23,9,3,7,6,3,1,1,18,17,16,2,22,8,7,18,12,21,0,14,18,17,20,1,0,23,7,4,3,19,23,22,17,18,5,4,4,3,19,18,22,21,19,18,16,11,17,16,9,7,14,13,22,10,9,4,3,12,16,15,5,8,12,11,15,7,15,14,23,22,18,11,10,13,9,8,9,19,20,19,19,18,9,8,5,3,3,20,18,0,9,20,20,14,23,2,16,19,22,2,1,9,5,21,0,10,19,20,6,6,5,20,14,13,16,11,10,13,8,11,4,9,8,11,1,4,23,3,2,6,5,8,14,18,17,2,1,4,20,19,22,4,7,8,7,10,21,0,0,4,3,4,3,6,7,11,10,7,6,9,15,14,17,10,14,13,3,2,5,5,9,8,1,0,3,1,4,11,15,14,12,11,14,11,10,13,1,5,4,23,22,19,17,18,17,10,8,4,15,14,23,11,10,4,13,16,6,9,12,16,15,16,15,23,19,11,14,9,10,20,21,20,19,10,0,6,1,17,11,14,8,12,6,12,6,5,23,3,22,21,9,3,18,13,12,5,23,23,17,8,2,11,5,1,19,4,23,22,7,1,11,6,5,10,4,18,12,14,9,8,6,0,9,4,3,4,22,5,23,15,10,9,15,9,14,8,5,0,23,3,2,23,21,22,21,14,12,11,19,18,3,15,14,8,17,20,10,13,16,20,6,20,19,3,23,15,18,13,14,0,1,0,23,14,14,13,11,10,8,20,9,8,1,23,6,5,14,2,1,20,19,4,8,7,21,0,4,3,7,7,6,15,14,10,3,2,5,11,1,0,1,11,12,11,11,10,1,15,23,12,20,10,18,10,18,3,11,1,10,9,7,15,16,1,0,6,3,11,21,5,6,14,9,17,23,7,2,11,10,5,13,9,18,17,8,16,16,0,12,21,20,4,12,7,16,15,2,10,3,11,13,22,21,13,21,12,20,3,12,11,17,16,13,11,12,11,4,2,2,9,8,17,5,4,22,7,10,0,3,6,10,6,10,9,17,13,5,8,3,4,14,15,14,13,4};
static const short Gen_shift_values_BG2_Z_26[1483]= {11,16,20,17,5,8,18,20,7,25,19,1,25,16,22,5,12,1,19,15,1,12,0,7,11,22,2,12,11,16,20,18,17,5,8,19,18,20,8,7,25,19,1,25,16,22,5,13,12,1,19,15,1,12,0,7,12,11,22,2,12,11,17,16,20,18,17,5,8,19,18,20,8,7,0,25,19,2,1,25,16,23,22,5,13,12,2,1,19,16,15,1,13,12,0,7,12,11,23,22,2,11,16,20,17,5,9,8,18,21,20,7,25,19,1,25,17,16,22,6,5,12,1,20,19,15,2,1,12,0,8,7,11,22,3,2,25,24,3,7,16,5,4,18,21,0,6,5,7,21,20,12,6,14,12,3,9,18,0,25,14,6,2,14,25,13,20,25,24,9,15,22,21,0,4,5,2,1,15,18,22,3,2,4,18,17,9,3,11,9,0,6,15,9,23,22,11,3,25,11,1,22,10,17,22,21,6,12,24,23,2,6,6,4,3,17,20,5,4,6,20,19,11,5,13,11,2,8,17,7,25,24,13,5,1,13,15,24,12,19,24,23,8,14,11,15,14,17,19,22,23,0,21,20,23,8,11,11,15,14,6,22,21,24,23,1,0,11,10,13,2,5,22,25,4,7,2,5,19,23,22,25,2,8,12,11,25,16,15,18,4,7,22,0,25,18,21,4,8,7,12,15,18,3,6,10,14,13,15,14,17,25,2,5,9,8,8,7,13,12,16,22,14,13,1,4,20,15,14,16,4,3,22,21,15,24,23,21,12,19,18,1,9,8,24,23,15,12,11,23,9,8,22,3,8,7,19,18,24,8,15,14,13,19,17,23,14,21,20,2,8,5,11,3,15,22,21,17,23,4,11,10,22,2,16,22,24,4,22,2,13,19,19,25,2,8,9,16,15,24,4,16,22,12,18,24,4,9,15,23,3,4,10,0,8,15,14,19,25,25,5,20,7,20,24,19,24,2,12,25,13,17,16,0,3,2,15,7,1,9,7,25,24,4,14,13,20,9,2,1,23,10,9,2,20,8,16,15,19,4,11,10,8,9,8,13,17,15,14,2,5,17,16,15,17,5,4,22,16,24,24,22,13,19,2,10,9,24,16,12,24,9,23,4,9,8,19,25,15,20,24,5,21,9,13,12,0,22,25,24,11,3,23,5,3,21,20,0,10,9,16,5,24,23,19,6,5,16,4,12,11,16,15,0,7,6,12,11,16,16,21,20,25,18,17,22,5,10,8,14,13,12,19,18,23,20,0,25,8,7,12,25,4,19,24,1,6,25,4,16,22,21,22,1,5,11,10,13,12,17,1,6,19,25,24,19,15,20,1,7,6,12,17,0,5,7,13,12,12,11,16,22,1,2,8,7,15,10,9,20,14,24,18,17,21,16,15,9,3,12,6,22,17,16,24,18,11,6,5,3,23,23,17,5,25,3,23,20,14,0,20,9,3,16,11,10,5,25,23,17,19,13,5,25,16,10,4,24,11,5,15,10,9,0,20,6,0,14,13,6,5,18,11,10,22,14,20,19,12,11,7,25,10,2,20,21,20,13,12,22,14,10,9,2,1,1,20,19,21,13,3,22,21,1,19,18,10,24,17,16,7,25,15,14,7,6,3,22,21,21,13,17,10,9,3,21,14,7,6,2,20,9,1,14,13,6,5,24,17,16,4,22,4,24,23,21,20,2,0,25,6,3,4,3,1,0,17,14,20,17,4,5,4,2,1,6,3,20,19,17,16,11,9,8,5,2,13,11,10,11,8,2,25,8,6,5,17,14,18,25,24,22,21,13,11,10,5,2,1,25,24,13,10,24,22,21,12,9,19,16,24,23,21,20,8,6,5,14,11,24,20,9,11,16,20,5,17,5,8,19,18,20,7,25,19,1,25,16,22,5,12,1,19,15,1,12,0,7,11,22,2,22,21,0,4,2,1,15,18,13,3,2,4,18,17,9,3,11,9,0,8,6,15,23,22,11,3,25,11,22,10,17,22,21,6,12,8,13,17,9,14,2,6,5,15,18,17,4,22,16,24,22,14,13,19,3,2,9,24,17,16,12,25,24,9,23,5,4,17,8,19,0,25,19,21,25,13,12,8,4,9,14,11,9,8,16,14,13,21,17,25,15,14,22,2,10,5,14,13,16,15,23,17,0,25,7,5,4,12,23,22,4,16,24,25,24,6,22,4,13,22,21,20,19,1,2,11,10,10,9,17,25,24,6,16,25,24,13,12,20,24,7,6,15,10,9,17,23,5,4,13,12,9,8,16,20,19,1,25,8,7,11,10,13,3,19,23,0,17,16,23,5,18,23,1,24,12,16,15,10,25,2,1,14,6,0,8,6,24,23,3,13,12,19,8,1,0,22,9,8,19,7,15,14,18,3,10,9,19,18,24,23,1,5,25,24,12,15,0,25,1,15,14,7,6,0,9,8,6,23,4,3,12,25,20,19,9,8,0,23,22,8,20,19,7,14,19,18,4,3,9,8,13,17,14,2,5,15,17,6,4,22,16,24,22,13,19,2,9,24,16,12,24,16,9,23,4,8,19,25,21,20,22,0,25,1,3,5,14,1,0,2,14,16,17,20,19,2,1,3,3,6,5,17,16,18,9,8,10,2,4,11,10,12,8,10,25,2,1,6,5,7,14,17,16,22,21,23,11,10,12,2,5,4,25,24,0,10,13,12,22,21,23,9,11,16,19,18,21,20,22,6,5,7,11,14,13,11,10,15,19,17,16,4,7,0,18,17,19,7,6,24,18,0,24,15,21,4,10,12,11,0,18,14,0,11,25,6,11,10,21,1,14,10,22,10,22,15,1,19,5,16,2,4,16,7,20,19,17,3,19,6,5,6,18,24,10,18,4,0,12,24,10,15,2,1,21,7,4,17,16,11,23,0,12,18,5,4,14,0,0,13,12,11,23,25,11,6,19,18,10,22,21,7,1,14,13,21,20,25,3,1,0,14,17,0,2,1,3,17,16,8,2,10,8,25,5,14,16,22,21,10,2,24,10,21,9,16,21,20,5,11,3,2,8,7,11,24,9,8,22,25,10,9,11,25,24,17,16,10,19,18,16,7,14,13,22,4,3,19,18,10,7,6,18,0,4,3,17,24,3,2,14,13,19,18,8,23,13,1,17,24,14,12,2,15,6,5,25,15,1,18,17,10,14,4,6,22,0,16,8,24,6,22,23,14,13,3,19,12,3,2,19,9,8,24,0,17,16,22,12,8,25,24,19,9,7,23,14,5,4,18,8,3,19,9,0,25,23,22,1,5,3,2,16,19,8,4,3,5,19,18,10,4,12,10,1,7,16,14,24,23,12,4,0,12,23,11,18,23,22,7,13};
static const short Gen_shift_values_BG2_Z_28[1483]= {15,24,11,25,18,16,22,5,12,15,17,2,22,7,15,11,10,2,11,3,25,0,6,15,7,2,20,15,16,25,12,25,26,19,17,22,23,6,12,13,16,18,3,23,8,16,12,10,11,3,12,4,26,1,7,16,7,8,3,21,15,16,24,25,12,25,26,19,17,22,23,6,12,13,15,16,18,2,3,23,8,15,16,12,10,11,2,3,12,3,4,26,0,1,7,16,7,8,2,3,21,16,25,12,26,19,16,17,23,5,6,13,16,18,3,23,7,8,16,11,12,11,3,11,12,4,25,26,1,7,15,16,8,3,20,21,4,5,14,1,3,14,15,8,6,15,11,12,23,1,2,5,7,20,12,25,5,1,27,0,20,1,21,15,18,24,5,24,25,20,10,12,13,22,9,16,22,23,16,14,25,19,20,3,9,10,13,15,0,20,5,13,9,1,7,8,0,9,1,23,22,26,4,13,4,5,0,18,0,1,10,25,10,10,11,4,2,7,8,19,25,26,1,3,16,8,21,1,25,26,23,24,16,25,17,11,2,14,20,1,20,21,16,6,25,25,26,1,7,10,22,25,7,8,11,1,4,27,1,2,18,4,5,8,16,18,19,22,23,26,26,1,0,3,13,16,5,8,18,20,21,26,1,22,24,25,12,20,21,24,13,16,22,24,25,14,17,8,10,11,20,11,14,17,20,26,0,1,17,18,21,13,16,3,5,6,27,0,8,9,24,6,9,10,3,1,14,6,7,18,24,25,27,0,2,14,15,7,20,27,0,24,22,23,14,15,24,15,16,10,12,13,19,0,19,20,14,15,5,3,14,15,12,24,27,11,13,24,25,6,18,4,16,1,10,21,22,21,5,0,11,12,3,15,5,17,18,2,10,22,23,7,3,15,27,11,26,9,10,18,2,27,11,19,3,13,25,16,0,22,6,3,15,1,23,6,7,18,2,8,20,5,9,7,27,3,12,27,14,13,6,3,4,10,20,21,0,3,5,18,10,22,23,3,26,27,26,18,26,27,19,12,13,25,16,22,2,3,23,18,7,8,25,12,13,22,9,22,23,16,14,17,19,20,3,9,10,13,15,20,0,20,5,13,9,7,8,0,9,1,23,26,4,13,4,5,0,18,16,25,12,8,26,19,16,17,0,23,5,6,13,16,18,3,23,7,8,16,11,12,11,3,11,12,4,25,26,1,7,15,16,2,8,3,20,21,27,0,20,9,1,24,16,9,10,2,3,23,1,20,21,7,6,7,27,18,9,10,24,25,17,0,20,2,22,15,7,7,27,20,11,12,0,20,24,15,16,22,23,15,15,7,24,15,16,10,16,8,10,1,2,13,5,19,11,0,19,20,19,20,12,15,7,5,24,25,19,13,14,0,23,15,10,3,1,23,24,22,17,20,15,26,20,21,9,4,16,10,11,19,14,21,16,6,1,26,21,11,6,19,14,15,10,14,8,9,6,1,15,10,7,2,1,24,4,27,10,5,19,14,11,5,6,6,1,24,19,9,10,0,1,19,9,10,6,25,19,20,10,11,13,4,11,2,18,16,17,7,8,0,19,6,7,25,26,10,0,1,12,3,25,15,16,17,8,2,21,10,0,1,6,25,4,5,23,24,25,15,16,6,25,26,16,17,20,11,23,13,14,1,20,10,1,1,2,20,21,25,15,16,15,6,17,25,26,17,18,7,26,27,22,14,7,8,27,0,1,21,27,19,19,4,5,24,25,16,8,22,23,14,15,26,17,18,0,20,13,4,5,5,25,18,10,26,17,18,22,14,19,20,21,12,13,13,4,5,22,14,14,5,6,8,0,11,2,3,17,9,26,18,17,18,9,10,13,4,5,3,23,11,15,15,17,26,13,6,27,20,18,25,24,7,14,17,19,4,24,9,17,13,12,4,13,5,27,2,8,17,9,4,22,16,17,26,13,26,27,20,18,5,23,24,7,13,14,17,19,4,24,9,19,17,13,11,12,4,13,5,27,2,8,17,8,9,4,22,13,22,9,23,23,16,13,14,20,2,3,10,13,15,0,20,4,5,13,8,9,8,0,8,9,1,22,23,26,4,12,13,14,5,0,17,18,20,0,15,25,21,12,3,6,14,9,12,13,22,21,22,3,9,18,22,23,4,16,25,14,22,23,19,20,1,3,11,12,5,9,10,19,12,13,22,15,24,27,0,9,20,1,5,13,14,12,13,22,9,17,18,7,8,17,27,0,9,9,17,18,0,1,10,23,3,4,5,25,26,7,4,13,13,21,22,4,5,14,27,0,9,18,26,27,26,5,19,15,24,23,4,21,15,16,7,2,11,26,12,5,2,3,6,9,19,20,27,2,4,17,9,21,22,2,25,26,25,17,25,26,18,11,12,15,21,1,2,22,17,6,7,13,14,22,23,10,23,23,24,17,15,20,21,4,10,11,13,14,16,0,1,21,6,13,14,10,20,8,9,0,1,10,1,2,24,26,27,5,14,5,6,0,1,19,12,21,8,22,15,13,19,2,14,9,12,14,27,19,4,12,8,7,27,8,0,22,11,25,3,12,4,27,17,20,21,1,1,2,10,17,25,0,2,3,11,24,4,22,1,2,27,0,8,11,18,19,17,18,26,20,21,1,23,3,7,8,16,0,8,13,20,21,20,21,1,17,24,25,15,16,24,7,8,16,17,24,25,8,9,17,3,10,11,5,6,14,12,20,21,0,1,12,13,21,7,8,16,26,5,6,14,15,24,11,24,25,18,16,6,21,22,5,11,12,15,17,2,22,7,15,11,24,9,10,2,11,3,25,0,6,15,6,7,2,20,0,6,26,27,0,8,9,23,24,9,10,2,3,0,0,1,6,7,17,17,18,24,25,27,0,1,2,14,15,6,7,19,19,20,27,0,23,23,24,22,23,14,15,23,23,24,15,16,9,9,10,12,13,18,19,27,27,0,19,20,14,15,4,4,5,5,6,15,2,15,16,9,7,8,12,13,24,2,3,6,8,21,13,26,6,2,12,0,1,21,2,22,16,19,25,6,25,26,21,11,1,2,10,11,26,21,11,12,5,3,8,9,20,26,27,1,2,4,16,17,9,22,1,2,26,24,25,16,17,26,17,18,12,12,14,15,21,2,21,22,16,17,7,22,24,3,5,18,20,4,6,25,27,23,24,25,1,3,12,13,14,13,19,21,22,24,24,26,9,11,1,3,14,15,16,22,24,18,19,20,17,19,9,11,18,19,20,10,12,4,5,6,7,9,13,15,22,23,24,14,16,9,11,27,0,1,12,13,22,9,22,23,16,14,7,19,20,3,9,10,13,15,0,20,5,13,9,16,7,8,0,9,1,23,26,4,13,4,5,0,18};
static const short Gen_shift_values_BG2_Z_30[1483]= {24,21,13,10,0,28,10,20,20,23,2,2,22,4,26,19,22,5,8,22,18,8,4,12,21,16,14,24,25,22,14,10,11,1,29,10,11,21,20,21,24,3,3,23,5,27,20,22,23,6,9,23,19,9,5,13,21,22,17,15,24,25,21,22,14,10,11,1,29,10,11,21,20,21,23,24,3,2,3,23,5,26,27,20,22,23,5,6,9,22,23,19,8,9,5,13,21,22,16,17,15,25,22,14,11,1,28,29,11,20,21,21,24,3,3,23,4,5,27,19,20,23,6,8,9,23,18,19,9,5,12,13,22,17,14,15,24,25,22,14,28,10,11,1,29,19,10,11,21,20,21,24,3,3,23,5,27,20,22,23,6,9,23,19,9,5,13,21,22,17,15,21,22,19,11,0,7,8,28,26,10,7,8,18,17,18,21,0,0,20,2,24,17,18,19,20,3,6,20,16,27,6,2,10,18,19,14,12,20,21,18,10,16,6,7,27,25,6,7,17,16,17,20,29,29,19,1,23,16,11,18,19,2,5,19,15,21,5,1,9,17,18,13,11,3,16,17,29,14,26,6,18,2,3,15,23,5,21,2,3,25,2,3,15,13,24,25,12,13,25,16,28,25,7,25,7,15,27,27,8,9,19,1,12,23,24,5,14,15,27,28,10,1,12,13,15,27,11,22,23,26,1,13,27,9,5,16,17,13,14,26,9,21,7,18,19,9,10,6,7,29,25,25,26,16,14,18,25,26,6,5,6,8,9,18,17,18,8,20,11,12,5,7,8,20,21,24,7,8,4,23,24,20,28,6,7,1,2,0,12,2,3,9,0,1,22,28,18,19,18,9,16,7,16,28,18,19,8,29,8,28,29,11,2,20,11,20,11,10,1,22,13,14,5,7,28,10,0,1,23,14,26,17,10,1,6,27,26,17,22,13,0,21,27,9,29,0,4,25,2,23,7,6,27,21,16,13,5,27,2,22,19,20,2,11,12,12,15,24,24,14,25,26,18,10,11,14,27,29,0,14,9,10,3,0,26,3,4,13,8,5,6,17,6,7,4,26,22,23,13,11,3,22,23,3,2,3,6,15,1,15,5,17,9,2,4,5,18,21,5,1,21,17,25,3,4,29,27,4,1,23,17,20,10,7,8,26,20,29,0,0,3,12,12,2,13,14,6,28,29,2,15,17,18,2,27,28,18,14,21,22,16,1,26,23,24,18,19,7,16,4,8,26,4,5,23,25,13,23,10,11,21,4,5,23,15,2,3,14,15,3,18,6,27,15,27,15,17,5,29,16,17,21,9,14,1,2,16,17,5,0,18,3,20,21,21,17,5,13,0,1,3,21,29,17,7,24,25,15,16,4,11,29,9,26,27,1,1,2,28,29,20,21,7,17,17,18,7,8,5,6,17,17,18,27,28,27,27,28,0,1,9,10,9,10,29,0,11,12,3,4,26,27,29,29,0,12,13,15,16,29,0,25,26,15,16,11,12,19,20,28,28,29,23,24,21,22,19,20,16,17,17,13,14,9,6,5,6,2,3,26,23,24,21,19,5,6,2,3,16,13,15,16,12,13,19,15,16,28,25,28,24,25,18,15,0,27,22,18,19,15,12,17,18,14,15,1,27,28,4,1,18,14,15,14,11,4,0,1,0,27,8,5,16,17,13,14,12,8,9,10,7,22,9,10,2,3,7,29,0,29,22,25,26,18,19,16,9,14,7,15,25,26,18,19,6,29,5,6,28,29,9,1,2,18,11,18,10,11,8,1,20,13,12,4,5,5,28,22,7,8,0,1,21,13,14,24,17,8,0,1,4,27,24,16,17,20,13,28,21,6,7,29,0,2,24,25,0,23,7,0,29,22,19,11,8,8,28,26,23,8,18,18,21,0,0,20,2,24,17,20,3,6,20,16,6,2,10,19,14,12,0,1,28,20,16,17,7,5,26,16,17,27,26,27,0,9,9,29,11,16,3,26,28,29,12,15,29,25,15,11,19,27,28,23,21,6,3,25,27,22,12,9,10,22,1,2,2,5,14,14,4,15,16,8,0,1,4,17,19,20,4,29,0,20,16,23,24,12,3,28,25,26,14,13,4,3,20,20,18,9,5,4,4,5,21,1,2,18,24,10,20,21,7,11,27,9,24,25,20,21,7,1,16,17,25,0,1,17,3,4,20,13,29,12,13,29,3,19,15,0,1,6,7,23,0,15,16,2,3,19,15,16,2,19,4,5,2,3,19,29,14,15,5,18,19,5,15,1,23,8,9,1,2,18,26,27,13,25,10,11,3,0,6,23,15,24,26,6,18,10,16,11,8,0,27,17,14,15,20,27,6,7,7,10,19,19,9,20,21,13,5,6,9,22,24,25,9,4,5,25,21,28,29,8,3,0,1,20,21,17,18,10,28,6,7,27,25,6,7,17,16,17,19,20,29,28,29,19,1,22,23,16,13,18,19,1,2,5,18,19,15,4,5,1,9,17,18,12,13,11,10,7,29,26,16,14,26,6,15,6,9,18,18,8,20,12,5,8,21,24,8,4,1,24,20,28,7,2,0,9,10,16,6,7,13,29,5,3,25,26,2,16,22,14,19,20,25,26,2,6,11,12,5,6,12,8,9,15,18,24,17,18,24,8,14,20,25,26,11,12,18,5,10,11,7,8,14,20,21,27,24,29,0,7,8,14,4,9,10,23,24,0,20,26,28,3,4,6,7,13,1,2,8,0,5,6,19,20,17,9,5,6,26,24,24,5,6,16,15,16,19,28,28,18,0,22,15,14,17,18,1,4,18,14,4,0,8,16,17,12,10,27,21,15,28,19,25,16,17,8,14,5,4,25,2,22,23,14,5,24,14,15,24,15,27,18,6,27,6,27,26,17,8,28,29,0,21,23,13,14,26,17,9,0,12,2,3,26,17,22,12,13,12,3,8,29,16,6,7,25,16,20,11,18,8,9,9,10,7,29,25,26,16,14,11,25,26,6,5,6,9,18,18,8,20,12,5,10,7,8,21,24,8,4,24,20,28,6,7,2,0,3,4,0,1,23,16,19,20,10,8,19,20,0,29,0,2,3,12,11,12,2,14,5,6,29,1,2,14,15,18,1,2,28,14,17,18,14,22,0,1,25,26,24,1,25,28,22,20,14,17,11,7,1,5,28,29,17,11,27,20,21,17,27,21,0,24,9,3,9,3,29,23,11,4,5,3,27,26,19,20,29,23,12,6,15,8,9,29,23,25,18,19,15,9,11,5,19,12,13,28,22,23,17,21,14,15,14,15,12,4,0,1,21,19,22,0,1,11,10,11,14,23,23,13,25,17,10,4,12,13,26,29,13,9,29,25,3,11,12,7,5};
static const short Gen_shift_values_BG2_Z_32[1483]= {7,5,15,19,16,6,10,24,24,4,10,27,18,28,27,6,27,0,15,26,20,30,14,16,11,26,30,8,7,5,15,20,19,16,6,11,10,24,25,24,4,10,27,18,28,27,6,28,27,0,15,26,20,30,14,16,12,11,26,30,8,7,6,5,15,20,19,16,6,11,10,24,25,24,5,4,10,28,27,18,28,28,27,6,28,27,1,0,15,27,26,20,31,30,14,16,12,11,27,26,30,7,5,15,19,16,7,6,10,25,24,24,4,10,27,18,29,28,27,7,6,27,0,16,15,26,21,20,30,14,17,16,11,26,31,30,15,14,12,22,18,27,26,23,13,21,18,17,31,0,31,11,17,2,25,3,2,13,3,2,7,22,1,27,5,21,23,19,18,1,5,15,14,12,22,6,27,26,23,13,8,18,17,31,0,31,11,17,2,25,3,2,13,1,3,2,7,22,1,27,30,5,21,23,19,18,1,5,6,5,3,13,26,18,17,14,4,9,8,22,23,22,2,8,25,16,26,25,4,3,26,25,30,13,24,18,12,28,12,14,10,9,24,28,27,11,10,27,8,25,18,3,23,22,7,19,4,27,9,26,0,14,13,30,13,27,12,28,27,12,7,24,13,30,30,15,21,6,17,31,16,30,15,27,9,26,18,31,30,15,3,20,4,18,3,29,14,9,23,8,11,1,18,17,2,5,19,4,15,14,31,29,14,19,1,18,14,13,12,11,21,13,26,25,22,12,29,17,16,30,31,30,11,10,16,2,1,24,2,2,1,12,2,1,7,6,21,1,0,26,5,4,20,22,18,17,1,0,4,31,4,30,2,28,12,6,11,16,10,13,7,3,29,10,2,7,1,21,15,16,21,15,1,27,7,1,24,18,15,9,25,19,24,18,3,29,19,24,18,29,23,12,6,23,17,17,11,27,21,11,5,13,7,12,3,8,2,23,17,27,21,10,24,31,20,31,29,7,10,11,8,31,30,2,17,16,16,28,2,19,10,21,20,19,31,30,19,24,8,7,18,13,12,11,22,6,9,8,3,18,23,22,17,22,21,19,29,2,1,30,20,30,25,24,6,7,6,18,24,14,9,0,10,9,20,10,9,14,29,8,2,12,28,30,26,25,8,12,5,3,13,18,17,14,5,4,1,8,23,22,22,2,8,25,16,27,26,25,5,4,25,30,14,13,24,19,18,28,12,15,14,5,9,24,29,28,11,10,15,8,13,18,23,23,22,27,19,24,15,9,14,18,14,13,18,1,27,0,28,27,0,7,12,13,18,30,3,21,26,5,31,4,30,3,15,9,14,31,30,3,3,8,24,18,23,16,29,2,29,23,28,1,6,17,22,25,19,24,15,14,19,29,2,7,1,6,29,22,28,20,26,30,4,18,9,2,8,31,5,21,27,0,25,31,7,13,14,7,13,19,25,25,31,10,16,1,7,11,17,10,16,21,27,17,10,16,15,21,30,4,9,15,3,9,13,19,29,3,31,5,1,26,0,9,15,13,19,16,26,15,25,24,13,23,23,1,28,6,27,5,24,2,14,24,10,19,29,18,28,0,10,1,11,0,10,23,12,22,18,28,14,3,13,26,4,4,14,14,3,13,14,24,4,14,3,13,19,8,18,23,1,13,2,12,28,6,17,6,16,22,0,24,2,20,30,19,29,13,2,12,6,16,13,26,8,25,7,6,23,5,1,15,6,20,5,19,2,16,24,6,29,29,11,28,10,10,24,11,25,10,24,5,22,4,28,10,28,13,27,4,18,14,28,28,13,27,24,6,27,14,28,13,27,1,18,0,1,15,27,12,26,6,20,31,16,30,0,14,2,16,30,12,29,11,27,12,26,16,30,27,1,17,0,30,8,22,12,9,31,19,3,17,17,29,3,20,11,21,20,31,20,25,8,19,13,23,7,9,4,19,23,5,4,2,12,17,16,13,3,25,8,7,21,22,21,1,7,24,15,25,8,24,3,25,24,29,12,23,17,27,11,13,9,8,23,27,25,23,1,11,5,2,25,24,28,11,10,10,22,28,13,4,15,14,13,25,24,13,18,2,1,12,7,6,16,0,3,2,9,29,12,17,16,29,30,22,10,13,13,10,7,3,27,8,7,1,6,5,31,15,9,20,19,13,16,10,1,6,0,11,10,4,19,24,18,28,25,24,18,5,4,30,10,4,28,27,21,18,12,23,28,22,28,27,21,1,6,0,28,27,21,1,0,26,10,15,9,27,26,20,15,20,14,14,31,30,24,14,8,11,16,10,12,11,5,27,26,20,25,30,24,7,22,1,4,6,17,27,6,15,8,19,8,6,16,20,17,8,7,9,11,26,25,25,5,11,28,19,30,29,28,8,7,28,1,17,16,27,22,21,31,15,18,17,12,27,0,31,14,13,12,11,21,17,26,25,22,12,17,16,30,31,30,11,10,16,2,1,24,2,2,1,12,11,2,1,7,6,21,1,0,26,5,4,20,22,18,17,1,0,4,18,16,26,30,27,17,21,3,3,3,15,21,6,29,7,6,17,6,11,26,5,31,3,9,25,27,22,5,9,29,28,11,27,26,9,4,19,18,9,8,23,5,20,11,27,10,0,31,14,29,13,28,14,13,28,26,25,8,31,14,17,16,31,7,22,1,17,0,17,16,31,11,27,10,17,16,31,22,21,4,20,4,19,16,15,30,25,9,24,20,19,2,3,18,21,5,20,1,0,15,16,15,30,3,19,2,7,6,4,14,19,18,15,5,24,10,9,23,24,23,3,9,26,17,27,26,5,7,27,26,31,14,25,19,29,13,15,11,10,25,29,11,5,25,2,30,0,28,10,6,14,10,11,7,30,1,29,5,1,16,19,15,19,15,31,27,5,1,22,18,13,9,20,23,19,22,18,30,1,29,22,18,27,23,7,10,6,21,17,12,15,11,25,21,9,5,8,11,7,6,2,21,17,22,25,21,14,13,11,21,26,25,22,12,30,17,16,30,31,30,10,16,1,24,2,1,12,1,2,1,6,21,0,26,4,20,22,18,17,0,4,10,9,8,7,17,14,22,21,18,8,13,12,26,27,26,7,6,12,30,29,20,30,30,29,8,30,29,3,2,17,29,28,22,11,1,0,16,18,14,13,29,28,0,18,31,16,29,26,7,30,11,27,8,31,17,30,21,2,17,3,16,31,3,16,15,28,21,2,6,19,29,10,21,7,20,6,19,31,17,30,6,19,11,24,8,26,7,5,18,13,31,12,9,22,25,6,9,27,8,22,3,5,18,23,9,22,30,29,27,5,10,9,6,28,0,1,0,14,15,14,26,0,17,8,18,17,28,4,18,17,22,5,16,10,20,4,6,2,1,16,20};
static const short Gen_shift_values_BG2_Z_36[1483]= {1,17,21,24,32,10,15,11,33,20,18,30,0,20,28,2,5,10,35,24,11,31,1,18,17,12,5,2,1,17,21,25,24,32,10,16,15,11,34,33,20,18,30,0,20,28,2,6,5,10,35,24,11,31,1,18,18,17,12,5,2,1,18,17,21,25,24,32,10,16,15,11,34,33,21,20,18,31,30,0,20,29,28,2,6,5,11,10,35,25,24,11,32,31,1,18,18,17,13,12,5,1,17,21,24,32,11,10,15,12,11,33,20,18,30,0,21,20,28,3,2,5,10,0,35,24,12,11,31,1,19,18,17,12,6,5,17,16,32,0,5,4,3,11,25,23,31,30,26,13,12,35,33,9,15,35,7,17,21,20,25,14,3,26,10,16,33,33,32,27,20,1,0,16,20,3,24,23,31,9,31,15,14,10,33,32,19,17,29,35,19,27,1,11,5,4,9,34,23,10,28,30,0,17,17,16,11,4,33,32,12,16,0,20,19,27,5,11,10,6,29,28,15,13,25,31,15,23,33,14,1,0,5,30,19,6,34,26,32,13,13,12,7,0,24,2,1,30,17,10,21,14,25,24,17,32,25,10,4,3,24,16,15,8,11,5,4,34,33,26,20,13,18,11,30,23,0,29,20,14,13,28,21,2,32,31,26,6,5,34,10,3,35,29,28,24,17,11,5,4,34,31,24,1,30,18,12,11,18,17,10,12,5,5,35,34,18,17,34,33,1,33,5,4,12,26,32,32,31,27,14,13,1,0,34,11,10,16,0,9,8,18,22,21,27,26,15,5,4,27,12,11,17,34,34,33,29,28,21,25,15,14,5,30,9,34,12,2,1,20,9,34,23,24,3,29,28,35,24,21,11,10,8,33,6,31,18,7,24,13,8,33,16,5,26,15,29,19,18,34,23,23,12,12,1,35,24,19,8,25,14,6,31,3,5,31,30,0,25,29,18,9,4,28,23,29,9,13,27,16,24,3,2,7,4,3,25,12,10,22,28,13,12,20,31,30,33,2,28,27,16,4,3,29,23,29,11,10,9,4,34,33,7,25,24,4,8,12,11,19,33,32,3,2,34,21,20,7,5,13,17,23,7,15,25,29,28,33,22,11,34,18,24,5,5,4,35,28,12,28,32,3,35,7,22,21,0,26,23,22,8,31,29,5,11,32,31,3,14,13,16,21,11,10,35,23,22,6,12,30,29,25,28,23,17,16,24,23,26,3,6,7,10,11,10,13,18,21,32,0,35,34,2,1,4,33,1,0,20,19,22,6,9,4,7,16,19,22,25,6,10,9,14,17,24,28,27,28,27,30,32,35,21,25,24,14,10,13,33,1,0,17,20,23,26,4,8,7,4,3,6,34,1,27,31,30,25,22,21,5,1,9,5,30,12,9,8,20,16,34,30,3,0,35,35,31,21,18,17,8,4,6,2,18,14,24,20,8,4,16,12,26,22,29,26,25,34,30,23,19,12,8,35,31,19,15,25,21,6,2,5,2,1,0,32,29,25,30,29,10,9,9,26,25,13,29,17,16,33,32,24,4,2,18,11,8,7,24,23,3,19,26,25,6,5,12,29,28,10,26,22,3,2,28,8,12,28,20,1,0,30,10,34,33,14,13,2,19,18,27,7,16,33,32,3,19,23,4,3,29,9,10,26,10,9,26,25,4,21,20,33,13,8,31,30,8,7,10,24,23,14,27,18,17,31,30,25,2,3,16,11,9,8,22,21,4,17,27,26,4,3,13,27,26,11,24,23,1,0,29,6,13,26,21,35,34,31,8,6,35,34,12,11,3,17,16,28,5,17,31,30,4,17,24,2,1,30,7,11,24,11,10,24,23,5,19,18,34,11,16,33,33,6,22,26,6,29,1,15,27,20,16,2,25,23,35,5,25,33,7,10,15,4,29,16,0,6,23,22,17,10,8,7,23,27,31,30,2,16,1,22,21,17,4,3,26,24,0,6,26,30,34,8,12,11,16,5,30,17,1,7,24,24,23,18,11,10,26,30,18,33,5,20,19,24,21,20,6,29,27,3,9,30,29,1,12,11,14,19,9,8,33,21,20,4,10,28,27,2,26,21,15,14,17,23,31,6,19,29,5,28,19,26,30,29,26,10,9,6,13,10,17,16,13,24,21,2,0,35,8,7,4,3,1,0,33,26,25,22,13,12,9,10,7,23,22,19,28,25,12,10,9,21,20,17,30,28,27,34,33,30,3,2,35,27,25,24,17,16,13,3,1,0,27,24,23,20,29,26,10,8,7,10,9,6,5,4,1,33,31,30,12,9,33,4,6,24,24,14,19,31,33,32,12,16,19,27,6,5,7,10,7,6,28,15,13,25,31,16,15,23,34,33,0,5,31,30,19,7,6,26,32,14,13,12,7,1,0,1,0,17,16,20,31,24,23,31,9,15,14,10,33,32,20,19,17,30,29,35,19,28,27,1,16,5,4,10,9,34,24,23,10,31,30,0,17,17,16,12,11,4,3,19,23,26,34,12,17,13,26,35,22,20,32,2,22,30,4,7,12,1,26,13,5,33,3,20,19,14,7,27,26,7,7,6,23,10,27,0,14,13,30,21,2,35,17,16,5,4,21,0,18,17,23,22,3,10,9,26,7,24,20,19,0,25,6,9,27,26,18,17,34,27,9,8,31,30,11,0,35,16,24,6,5,14,13,30,0,18,17,21,20,1,26,7,7,25,24,7,6,23,2,1,18,30,12,11,23,22,2,6,10,9,17,31,23,1,0,32,19,18,5,3,15,21,5,13,23,28,27,26,31,20,9,32,16,22,3,3,2,33,26,12,20,25,26,21,6,1,10,5,13,8,21,16,35,31,30,4,35,0,32,31,22,17,9,4,7,2,19,14,25,20,9,5,4,17,12,27,23,22,30,25,35,30,24,20,19,13,8,0,32,31,20,15,26,21,7,3,2,6,1,1,32,30,26,25,3,2,18,22,26,25,33,11,0,17,16,12,35,34,21,19,31,1,21,29,3,33,7,6,11,0,25,12,32,2,19,19,18,13,6,0,35,16,15,19,10,23,22,30,8,14,13,9,32,31,19,18,16,29,28,34,18,27,26,0,4,3,9,8,33,23,22,9,31,30,29,35,16,16,15,11,10,3,2,31,18,11,22,15,25,18,33,26,11,5,4,16,9,12,6,5,5,34,27,21,14,19,12,31,24,1,30,21,15,14,29,22,3,33,32,6,35,11,4,0,30,29,25,18,12,6,5,32,25,2,31,19,13,12,18,11,13,6,6,0,35,21,20,0,4,8,7,15,29,11,35,34,30,17,16,3,1,13,19,3,11,21,10,25,24,29,18,7,30,14,20,1,1,0,31,24};
static const short Gen_shift_values_BG2_Z_40[1483]= {38,15,18,38,12,36,38,13,38,2,17,38,7,20,38,24,38,6,10,38,15,38,26,11,38,13,4,39,38,15,18,39,38,12,36,39,38,13,39,38,2,17,38,7,20,38,24,39,38,6,10,38,15,38,26,11,39,38,13,4,39,38,16,15,18,39,38,12,36,39,38,13,39,38,3,2,17,39,38,7,20,39,38,24,39,38,7,6,10,39,38,15,39,38,26,11,39,38,14,13,4,38,15,18,38,12,37,36,38,14,13,38,2,17,38,7,21,20,38,25,24,38,6,11,10,38,16,15,38,26,12,11,38,13,5,4,36,35,12,15,39,36,35,9,33,15,36,35,10,36,35,39,14,35,4,17,35,21,36,35,3,7,35,12,35,23,8,36,35,10,1,23,22,39,2,39,23,22,36,20,10,23,22,37,23,22,26,1,22,31,4,22,8,21,23,22,30,34,22,39,20,22,10,35,23,22,37,28,27,26,3,6,39,27,26,0,24,27,26,1,27,26,30,5,26,35,8,26,12,3,27,26,34,38,26,3,18,26,14,39,27,26,1,32,4,15,14,36,31,13,34,16,15,14,36,28,10,12,35,34,39,15,14,36,29,12,11,15,14,36,18,0,33,15,14,36,23,5,36,19,18,14,36,0,23,22,4,15,14,36,22,4,26,9,8,14,36,31,14,13,27,14,36,2,24,27,10,9,15,14,36,29,11,20,3,2,6,5,23,22,25,39,6,5,19,3,24,6,5,20,6,5,10,9,24,6,5,14,27,6,5,31,6,5,14,13,17,6,5,22,6,5,33,18,6,5,21,20,11,9,4,3,26,20,29,23,9,4,3,23,17,7,1,39,9,4,3,24,18,9,4,3,13,7,28,22,9,3,18,12,31,25,9,3,35,29,9,4,3,17,11,21,15,9,3,26,20,9,3,37,31,22,16,16,9,4,3,24,18,15,9,39,16,35,19,0,17,20,39,0,14,39,38,0,16,15,0,4,19,0,9,23,22,0,27,26,0,8,13,12,0,18,17,6,0,28,14,13,0,15,7,6,3,7,6,23,26,7,6,20,4,39,7,6,21,7,6,10,25,32,6,15,28,6,32,7,6,14,18,6,23,6,34,19,7,6,21,12,24,1,4,39,24,38,23,22,31,24,0,39,24,28,3,24,33,7,6,24,11,10,24,32,37,36,24,2,1,24,12,38,37,21,24,39,31,30,16,15,25,32,2,35,5,16,15,25,29,39,13,24,23,39,16,15,25,30,1,0,16,15,25,19,29,34,4,15,25,24,34,37,8,7,15,25,1,12,11,16,15,25,23,33,27,38,37,17,15,25,32,3,2,15,25,3,13,28,39,38,16,15,25,30,0,21,32,31,31,18,17,8,34,11,37,39,31,18,17,5,31,29,15,31,18,17,6,32,31,18,17,35,21,10,36,31,17,0,26,13,39,31,17,17,3,31,18,17,39,25,3,29,31,17,8,34,31,17,19,5,4,30,31,18,17,6,32,37,23,30,29,22,21,6,39,38,9,1,30,29,22,21,3,35,27,19,39,30,29,22,21,4,36,30,29,22,21,33,26,25,8,0,29,22,21,38,30,11,3,29,22,21,15,7,30,29,22,21,37,30,29,1,33,29,22,21,6,38,29,22,21,17,9,2,34,30,29,22,21,4,37,36,35,27,38,28,27,17,16,4,34,33,7,36,28,27,17,16,1,30,25,14,39,28,27,17,16,2,31,28,27,17,16,31,21,20,6,35,27,17,16,36,25,9,38,27,17,16,13,2,23,28,27,17,16,35,25,24,39,28,27,17,16,4,33,27,17,16,15,4,0,29,28,27,17,16,2,32,31,33,22,39,17,5,32,9,12,39,32,6,30,37,32,7,32,36,11,32,1,14,32,18,32,0,4,32,9,32,20,5,32,7,38,23,22,39,2,23,22,36,20,39,23,22,37,23,22,26,1,22,31,4,27,22,8,23,22,30,34,22,39,22,10,35,23,22,37,28,31,8,11,39,31,5,30,29,31,7,6,31,35,10,31,0,14,13,31,18,17,31,39,4,3,31,9,8,31,19,5,4,16,31,6,38,37,39,3,39,34,37,39,28,6,39,24,12,11,5,29,28,22,31,25,12,11,5,25,19,9,4,3,12,11,5,26,21,20,39,12,11,5,16,15,9,30,24,12,11,5,20,14,33,28,27,12,11,5,37,32,31,12,11,5,20,19,13,23,18,17,12,11,5,28,23,22,19,12,11,5,39,33,24,19,18,12,11,5,27,26,20,17,12,11,39,31,39,5,29,39,33,39,34,10,13,18,35,38,18,32,17,16,39,18,34,33,18,22,37,18,27,1,0,18,5,4,18,26,31,30,18,36,35,18,6,32,31,18,33,25,24,1,0,18,17,20,39,1,0,14,38,1,0,15,1,0,5,4,19,1,0,9,22,1,0,26,19,1,0,9,8,12,1,0,17,1,0,28,13,1,0,16,15,6,11,28,31,11,25,9,11,26,39,11,15,30,11,20,33,11,37,11,19,23,11,28,7,11,39,24,11,26,17,18,17,36,35,34,13,37,16,39,18,17,36,31,10,15,35,34,18,17,36,32,12,11,18,17,36,22,21,0,36,15,18,17,36,26,5,39,19,18,18,17,36,3,23,22,18,17,36,26,25,4,29,9,8,18,17,36,34,14,13,18,17,36,5,24,30,10,9,18,17,36,33,32,11,23,3,2,5,4,21,24,5,4,18,2,39,5,4,19,5,4,8,23,4,13,26,4,30,36,5,4,12,16,4,21,4,32,17,5,4,19,10,39,22,1,38,22,15,39,18,2,38,22,12,36,36,21,20,38,22,13,38,37,38,22,2,26,17,1,38,22,7,31,20,5,4,38,22,24,9,8,38,22,6,30,10,35,34,38,22,15,0,39,38,22,26,10,11,36,35,38,22,13,37,4,29,28,18,17,34,37,18,17,31,15,39,18,17,32,18,17,21,36,17,26,39,17,3,12,18,17,25,29,17,34,17,5,30,18,17,32,23,17,16,34,33,36,39,17,16,30,14,17,16,31,17,16,21,20,35,17,16,25,38,17,16,2,17,16,25,24,28,17,16,33,23,17,16,4,29,17,16,32,31,22,34,21,11,38,14,1,34,21,8,35,32,20,19,34,21,9,37,36,39,34,21,38,25,13,0,34,21,3,30,16,4,3,34,21,20,8,7,34,21,2,29,6,34,33,34,21,11,39,38,34,21,22,9,7,35,34,34,21,9,36,0,28,27,14,13,30,33,14,13,27,11,39,14,13,28,14,13,17,32,13,22,35,13,39,1,14,13,21,25,13,30,13,1,26,14,13,28,19};
static const short Gen_shift_values_BG2_Z_44[1483]= {22,15,8,9,34,7,12,40,1,19,17,17,36,40,43,37,38,9,15,35,43,37,8,15,33,43,15,23,22,15,8,10,9,34,7,13,12,40,2,1,19,17,17,36,40,43,37,39,38,9,15,35,43,37,8,15,34,33,43,15,23,22,16,15,8,10,9,34,7,13,12,40,2,1,20,19,17,18,17,36,40,0,43,37,39,38,10,9,15,36,35,43,38,37,8,15,34,33,0,43,15,22,15,8,9,34,8,7,12,41,40,1,19,17,17,36,41,40,43,38,37,38,9,16,15,35,0,43,37,8,16,15,33,43,16,15,18,17,10,3,41,5,4,29,2,22,8,7,35,41,40,14,12,12,31,35,38,32,34,33,4,10,30,38,32,3,10,29,28,38,10,39,38,31,24,34,26,25,6,23,39,29,28,12,18,17,35,33,33,8,12,15,9,34,11,10,25,31,7,15,14,9,24,31,6,5,15,31,8,7,0,37,2,39,38,19,36,42,41,25,31,30,4,2,2,21,25,28,22,21,24,23,38,0,20,28,9,22,37,0,19,18,28,0,22,26,25,33,18,26,11,19,13,12,20,37,1,10,19,18,3,16,15,23,43,8,7,5,4,12,22,30,20,28,20,28,39,3,43,8,7,2,10,40,5,4,36,42,41,5,12,20,18,27,26,38,2,2,11,10,23,40,4,11,19,18,27,26,37,36,0,2,10,18,27,26,8,7,1,0,37,8,39,38,19,36,30,42,41,25,31,30,5,4,2,3,2,21,25,29,28,22,24,23,39,38,0,21,20,28,23,22,37,0,19,18,29,28,0,33,43,42,26,35,19,28,20,30,29,1,10,18,27,15,23,33,32,7,16,12,22,21,30,39,28,37,28,37,3,12,7,16,10,19,4,13,5,15,14,20,29,26,35,2,11,10,19,4,13,19,28,26,35,9,0,10,9,10,19,26,35,22,24,41,22,31,24,17,2,18,43,17,16,21,6,5,10,28,26,26,1,6,5,8,3,2,3,18,25,24,0,9,8,42,2,17,25,24,42,8,25,24,23,27,26,19,12,14,13,38,11,33,17,16,0,6,5,23,21,10,21,40,0,3,41,43,42,13,19,39,3,41,12,19,38,37,3,19,17,10,3,28,4,29,3,2,2,7,36,35,40,14,12,12,31,36,35,38,33,32,33,4,11,10,30,39,38,32,3,11,10,26,28,38,11,10,31,30,12,23,5,16,42,18,17,43,42,24,15,42,41,10,21,20,2,4,31,30,10,9,35,27,9,25,7,25,7,0,26,4,31,30,7,33,1,28,27,3,2,28,17,43,23,6,5,12,43,25,7,34,33,1,27,16,42,23,6,5,42,41,23,7,33,23,6,5,37,19,18,30,11,23,4,4,24,6,5,5,30,22,3,27,9,8,11,36,16,42,41,34,15,32,13,32,13,7,32,11,36,14,39,8,33,9,35,34,24,5,30,11,6,31,14,39,8,33,23,4,30,11,4,30,29,14,39,30,11,40,39,12,11,32,5,4,25,41,27,26,43,42,7,23,24,40,33,30,29,2,1,13,29,19,18,35,34,36,9,8,34,6,34,7,6,9,25,13,29,16,33,32,10,26,12,11,28,27,26,43,42,32,4,8,25,24,16,32,10,27,26,25,41,32,4,7,6,23,22,16,33,32,32,4,25,41,40,10,9,33,3,2,26,39,28,27,41,40,8,21,25,38,1,31,30,0,43,14,27,20,19,33,32,37,7,6,35,4,35,5,4,10,23,14,27,17,31,30,11,24,22,13,12,26,25,27,41,40,33,2,9,23,22,17,30,11,25,24,26,39,33,2,8,7,21,20,17,31,30,33,2,40,30,21,35,28,21,12,22,3,20,2,25,9,14,32,30,30,5,9,12,6,7,22,28,4,12,6,21,28,2,12,28,20,19,12,5,7,6,31,4,39,10,9,37,43,42,16,14,14,33,37,7,40,34,36,35,6,12,32,40,34,5,12,31,30,40,12,18,11,4,23,5,30,4,3,8,37,36,41,15,13,13,32,37,36,39,34,33,34,5,12,11,31,40,39,33,4,12,11,33,29,39,12,11,17,30,21,43,17,24,19,16,27,3,32,31,35,25,24,28,17,21,19,18,22,43,3,16,21,20,22,21,25,5,10,9,35,11,10,14,29,28,32,26,30,27,26,30,1,5,5,10,9,9,8,12,2,7,6,4,3,7,19,18,22,24,29,28,1,0,4,8,13,12,37,3,2,6,17,21,24,29,28,43,42,2,9,8,12,24,29,28,41,15,19,23,16,6,28,39,40,4,28,38,31,24,25,6,24,23,28,28,13,12,17,35,33,33,8,13,12,15,10,9,10,25,32,31,7,16,15,9,24,32,31,5,15,32,31,33,32,26,25,18,27,20,19,0,17,23,22,6,12,11,30,29,27,28,27,2,6,10,9,3,28,5,4,20,19,25,2,1,9,4,3,18,25,0,43,10,9,25,7,0,37,38,19,36,41,25,16,30,4,2,2,21,25,28,22,23,38,0,20,28,4,22,37,0,18,28,0,20,19,8,13,12,1,5,38,10,7,6,39,31,20,4,38,37,10,9,42,37,27,26,43,42,31,17,16,5,14,3,15,14,3,33,22,37,27,26,41,40,29,34,24,23,36,35,24,7,6,39,12,2,1,33,32,21,40,30,29,35,34,23,5,38,12,2,1,31,30,19,41,40,29,12,2,1,19,18,11,4,6,5,30,3,37,9,8,36,42,41,15,13,13,32,36,39,33,19,35,34,5,11,31,39,33,4,11,30,29,39,11,28,21,40,13,16,6,9,43,2,0,3,25,28,42,2,1,3,6,31,35,34,36,39,10,13,8,11,8,11,27,30,31,35,34,34,37,28,32,31,29,32,0,3,6,10,9,26,29,34,38,37,28,31,43,2,6,10,9,24,27,34,37,6,10,9,42,41,34,27,29,28,9,26,23,32,31,15,21,20,38,36,36,11,15,18,12,6,14,13,28,34,10,18,12,27,34,9,8,18,34,40,39,33,32,25,20,27,26,7,24,30,29,13,19,18,37,36,34,35,34,9,13,17,16,10,12,11,27,26,32,9,8,16,5,11,10,25,32,7,6,17,16,32,2,16,39,9,32,2,33,3,14,28,31,2,1,36,6,20,35,34,27,25,39,43,13,41,11,41,11,16,30,20,35,34,23,37,17,32,31,18,32,33,3,39,10,9,15,29,23,38,37,17,31,32,2,39,10,9,13,27,23,37,39,10,9,31,30,23,16,18,17,42,15,43,21,20,4,10,9,27,25,25,0,4,7,1,5,3,2,17,23,43,7,1,16,23,42,41,7,23};
static const short Gen_shift_values_BG2_Z_48[1483]= {28,25,23,47,16,38,20,29,16,34,19,46,12,15,42,22,21,29,25,41,20,39,16,26,26,1,40,29,28,25,23,0,47,16,38,21,20,29,17,16,34,19,46,12,15,42,22,22,21,29,25,41,20,39,16,26,27,26,1,40,29,28,26,25,23,0,47,16,38,21,20,29,17,16,35,34,19,47,46,12,15,43,42,22,22,21,30,29,25,42,41,20,40,39,16,26,27,26,2,1,40,28,25,23,47,16,39,38,20,30,29,16,34,19,46,12,16,15,42,23,22,21,29,26,25,41,21,20,39,16,27,26,26,1,41,40,10,9,6,4,23,29,28,45,19,25,2,1,10,46,45,15,0,27,41,44,23,3,3,2,10,6,22,1,20,45,7,8,7,30,21,29,28,25,23,9,0,47,16,38,43,21,20,29,17,16,34,19,46,12,15,42,22,24,22,21,29,25,41,20,31,39,16,26,27,26,1,40,21,20,17,15,32,40,39,8,30,13,12,21,9,8,26,11,38,4,7,34,14,43,14,13,21,17,33,12,3,31,8,18,19,18,41,32,0,35,34,27,31,24,29,22,6,5,46,22,15,44,38,37,31,27,26,19,35,29,28,23,22,15,40,33,25,18,4,45,18,11,21,15,14,0,41,28,22,21,41,28,27,20,35,28,31,25,24,47,40,26,20,19,15,45,38,22,15,32,26,25,33,32,25,7,0,46,40,39,37,36,34,33,31,21,8,7,24,46,21,29,28,37,25,24,43,42,27,7,6,20,23,3,2,30,30,29,38,37,33,2,1,28,0,47,24,34,35,34,10,9,0,21,15,14,18,11,16,9,40,34,33,9,2,31,24,27,13,7,6,22,15,9,3,2,27,20,12,5,39,32,5,46,8,1,35,28,15,8,14,8,7,22,15,18,11,34,27,13,6,32,25,9,2,19,12,35,19,13,12,42,35,33,26,10,7,21,3,38,35,33,31,9,26,1,0,30,40,39,26,44,29,8,22,26,25,4,33,32,31,39,36,35,3,31,30,43,1,26,37,36,36,11,3,2,29,40,39,36,34,11,10,27,1,38,32,31,40,28,27,45,30,44,9,23,26,5,33,33,32,40,36,4,31,2,27,37,38,37,12,3,2,47,45,0,21,38,13,12,28,42,4,3,38,8,41,20,34,38,37,16,45,44,43,3,0,47,15,43,42,13,38,1,0,34,0,23,15,14,2,1,47,46,44,44,42,21,20,18,37,35,11,10,9,18,42,41,39,2,1,0,38,37,35,7,5,40,38,19,17,33,31,36,35,34,15,13,43,42,41,43,42,40,2,0,46,45,44,21,14,12,41,40,39,12,10,37,35,47,46,45,0,47,45,22,20,13,12,11,43,14,13,40,10,38,8,19,14,33,32,31,1,5,23,35,6,5,44,14,31,2,1,1,19,34,4,13,31,27,45,30,0,9,27,37,7,36,7,6,44,14,40,10,8,26,35,5,6,24,31,1,41,11,41,12,11,16,34,7,25,20,19,45,44,16,42,41,14,39,39,38,16,15,7,32,29,6,38,12,11,37,36,20,45,8,7,33,32,25,3,2,10,35,37,15,14,3,28,6,31,33,11,10,13,38,13,12,38,37,20,46,45,16,41,32,10,9,11,36,30,8,7,7,32,17,42,18,17,43,42,40,18,17,31,8,32,38,37,35,34,34,32,31,32,29,9,8,6,5,25,22,47,44,13,30,29,27,26,38,35,26,25,23,22,43,41,40,28,25,7,5,4,21,18,24,21,3,1,0,31,28,22,31,30,28,27,38,36,35,34,31,2,0,47,29,26,0,46,45,25,22,35,32,36,35,33,32,10,8,7,1,46,41,5,45,40,37,35,9,11,28,2,41,32,41,28,46,31,10,24,27,6,34,33,41,37,5,32,3,28,38,38,13,4,38,37,34,32,9,8,25,47,27,30,29,38,26,25,43,28,7,21,24,12,3,31,31,30,38,34,2,29,0,25,35,36,35,10,1,47,44,42,12,18,35,10,9,39,1,0,35,5,38,17,31,35,34,13,42,41,40,0,45,44,12,40,39,10,35,46,45,30,45,20,12,11,19,3,9,37,46,37,8,15,44,20,36,35,17,33,32,14,30,12,7,6,36,23,5,45,28,27,28,27,9,36,19,18,18,24,23,5,42,41,23,26,8,6,5,35,19,1,22,5,4,2,1,31,29,12,11,29,28,10,37,36,18,32,15,14,1,0,30,27,10,9,40,47,46,28,23,5,33,16,15,34,33,15,9,8,38,47,30,29,6,1,21,14,23,13,16,23,9,3,7,6,3,1,25,42,17,16,2,46,8,7,42,12,45,24,38,42,41,20,1,0,47,7,4,3,19,47,46,17,42,5,4,4,27,19,18,46,45,43,42,40,35,17,16,33,7,38,37,46,34,33,4,3,36,16,15,29,32,12,11,39,7,39,38,47,46,42,11,10,37,9,8,33,43,44,43,19,18,9,8,5,3,27,44,18,0,9,20,44,14,47,26,40,43,22,2,1,9,5,21,0,34,19,44,6,6,29,20,14,13,40,11,10,37,8,35,28,33,32,11,1,28,23,3,2,6,5,32,14,42,41,2,1,28,20,19,46,4,31,32,31,10,45,24,0,28,27,28,27,6,7,35,34,7,6,33,15,14,41,10,38,37,27,26,5,5,33,32,25,24,3,1,28,11,39,38,12,11,38,35,34,13,25,5,4,47,46,43,41,18,17,34,8,28,39,38,47,35,34,4,37,16,30,33,12,40,39,40,39,47,43,11,38,9,34,44,45,44,19,10,24,6,25,17,11,14,8,12,6,36,30,5,47,27,22,21,9,3,18,13,12,5,47,23,17,8,2,35,29,1,43,4,47,46,31,25,11,6,5,10,4,18,12,14,9,8,30,24,9,4,3,28,22,5,47,15,10,9,15,9,38,32,29,24,23,27,26,23,21,46,45,14,36,35,19,18,27,15,14,32,17,44,10,13,40,20,6,20,19,27,23,39,18,37,14,24,25,24,47,38,38,37,35,34,32,44,9,8,25,47,30,29,38,26,25,44,43,28,8,7,21,24,4,3,31,31,30,39,38,34,3,2,29,35,1,0,25,35,36,35,11,10,1,39,47,36,44,34,42,10,18,27,35,1,10,9,31,39,40,1,0,6,27,35,45,5,30,38,9,17,23,31,26,35,34,5,13,33,42,41,32,40,40,0,36,45,44,4,12,31,40,39,2,10,27,35,37,46,45,37,45,12,20,3,12,11,41,40,37,35,12,11,28,2,2,33,32,41,29,28,46,31,10,24,27,6,34,6,34,33,41,37,5,32,3,28,38,39,38,13,4};
static const short Gen_shift_values_BG2_Z_52[1483]= {37,16,20,17,5,34,18,46,7,25,45,1,25,16,48,5,38,27,45,15,1,12,26,33,11,22,2,38,37,16,20,18,17,5,34,19,18,46,8,7,25,45,1,25,16,48,5,39,38,27,45,15,1,12,26,33,12,11,22,2,38,37,17,16,20,18,17,5,34,19,18,46,8,7,26,25,45,2,1,25,16,49,48,5,39,38,28,27,45,16,15,1,13,12,26,33,12,11,23,22,2,37,16,20,17,5,35,34,18,47,46,7,25,45,1,25,17,16,48,6,5,38,27,46,45,15,2,1,12,26,34,33,11,22,3,2,51,50,29,33,42,31,30,18,47,26,32,31,7,21,20,38,6,14,38,29,9,18,0,51,40,6,28,14,25,39,46,25,24,35,15,48,47,26,30,31,28,27,15,44,48,29,28,4,18,17,35,3,11,35,26,6,15,35,49,48,37,3,25,11,27,22,36,43,22,21,32,12,50,49,28,32,6,30,29,17,46,31,30,6,20,19,37,5,13,37,28,8,17,33,51,50,39,5,27,13,41,24,38,45,24,23,34,14,11,41,40,43,19,22,23,26,21,20,23,8,11,37,41,40,6,22,21,24,49,1,0,11,10,13,28,31,48,51,4,7,28,31,19,23,22,51,2,8,12,11,25,42,41,44,30,33,48,0,51,18,21,4,8,7,38,15,18,29,32,36,40,39,15,14,17,25,28,5,9,8,8,7,39,38,42,48,40,39,27,4,20,41,40,16,30,29,48,47,15,24,23,47,38,19,18,27,9,8,50,49,15,38,37,23,35,34,48,3,34,33,45,44,24,34,15,14,13,45,17,49,14,47,46,2,34,31,11,29,15,48,47,43,23,4,37,36,22,2,42,22,50,30,22,2,13,45,45,25,2,34,35,16,15,24,4,42,22,12,44,50,30,9,41,23,3,30,10,26,8,41,40,19,51,51,31,20,7,20,50,45,24,28,38,25,13,43,42,26,3,2,15,33,1,9,33,25,24,4,14,13,46,35,2,1,23,10,9,28,20,34,42,41,19,30,11,10,34,35,34,13,17,15,14,2,31,17,16,15,43,5,4,22,42,50,50,22,13,45,2,36,35,24,42,12,50,9,23,30,9,8,19,51,15,46,50,31,47,35,13,12,0,48,25,24,37,3,23,31,3,47,46,26,36,35,16,5,24,23,45,32,31,42,4,12,11,42,41,0,33,32,38,37,42,16,21,20,25,18,17,22,5,10,34,40,39,38,19,18,23,46,0,51,8,7,12,25,30,45,50,1,6,25,30,16,22,21,48,1,5,11,10,39,38,43,27,32,45,51,50,19,15,20,1,7,6,12,17,26,31,33,39,38,12,11,16,22,27,2,8,7,41,36,35,20,14,24,18,17,21,16,15,9,3,38,32,22,17,16,50,44,11,6,5,29,23,49,43,5,51,29,23,20,14,0,46,9,3,42,37,36,31,25,49,43,19,13,5,51,16,10,30,24,37,31,15,10,9,26,20,6,0,40,39,6,5,18,37,36,22,40,20,19,38,37,7,25,36,2,20,21,20,39,38,48,14,10,9,28,27,27,46,45,47,13,3,22,21,27,45,18,36,50,17,16,7,25,41,40,7,6,29,48,47,47,13,17,36,35,3,21,14,33,32,28,46,35,1,14,13,32,31,24,43,42,4,22,30,24,23,21,20,2,0,51,6,3,4,3,1,0,43,40,20,17,4,5,4,2,1,32,29,46,45,43,42,11,9,8,31,28,39,37,36,11,8,2,51,34,32,31,43,40,44,25,24,22,21,13,11,10,31,28,1,51,50,39,36,50,48,47,12,9,19,16,50,49,47,46,8,6,5,40,37,24,46,35,37,16,20,5,17,5,34,19,18,46,7,25,45,1,25,16,48,5,38,27,45,15,1,12,26,33,11,22,2,48,47,26,30,28,27,15,44,39,29,28,4,18,17,35,3,11,35,26,34,6,15,49,48,37,3,25,11,22,36,43,22,21,32,12,8,39,43,9,40,28,6,5,41,18,17,30,48,16,24,48,40,39,19,29,28,9,50,17,16,38,25,24,35,49,5,4,17,34,45,26,25,45,21,51,13,12,8,4,35,40,37,35,34,42,14,13,21,17,25,15,14,22,2,10,31,40,39,16,15,23,43,0,51,7,5,4,12,23,22,30,42,50,51,50,6,22,30,13,22,21,46,45,1,2,11,10,36,35,43,25,24,32,42,51,50,13,12,20,50,7,6,15,10,9,17,23,31,30,39,38,9,8,16,20,19,27,51,8,7,11,36,13,29,45,49,26,17,16,49,5,18,49,1,50,38,16,15,10,51,28,27,40,6,26,34,6,50,49,29,39,38,19,8,27,26,48,35,34,45,7,15,14,44,3,36,35,45,44,24,23,27,5,25,24,12,41,26,25,1,15,14,33,32,0,9,8,32,23,4,3,12,51,46,45,35,34,0,23,22,8,20,19,33,40,19,18,30,29,9,8,39,43,40,28,5,41,17,6,30,48,16,24,48,39,19,28,9,50,16,38,24,16,35,49,4,34,45,25,21,20,22,0,51,1,3,5,40,1,0,2,40,42,17,20,19,2,1,3,29,32,31,43,42,44,9,8,10,28,30,37,36,38,8,10,51,2,1,32,31,33,40,43,42,22,21,23,11,10,12,28,31,30,51,50,0,36,39,38,48,47,49,9,11,16,19,18,47,46,48,6,5,7,37,40,39,11,10,41,45,43,42,30,7,0,44,43,19,33,32,50,18,26,50,41,21,30,10,12,11,0,18,40,26,37,51,6,37,36,47,27,40,10,22,10,22,41,1,45,5,42,2,30,42,7,20,19,43,3,19,32,31,32,44,50,10,18,30,26,38,50,10,41,2,1,21,33,30,43,42,11,23,0,12,18,31,30,40,0,26,39,38,37,49,51,11,6,19,18,36,48,47,7,27,40,39,21,20,51,3,1,0,40,17,0,2,1,29,43,42,8,28,36,8,51,31,40,16,22,21,10,28,50,36,47,9,16,47,46,5,37,3,2,34,33,37,24,35,34,22,51,36,35,11,25,24,43,42,10,19,18,42,33,14,13,22,4,3,45,44,10,33,32,18,0,30,29,43,50,29,28,40,39,19,44,8,23,39,27,43,24,40,12,28,41,6,5,25,41,1,18,17,36,14,30,32,48,0,16,8,24,32,48,23,40,39,3,19,12,29,28,45,9,34,50,0,17,16,22,38,8,25,24,19,35,33,49,40,5,4,18,34,29,45,9,26,25,49,48,27,31,29,28,16,45,34,30,29,5,19,18,36,4,12,36,27,7,16,40,50,49,38,4,26,12,23,37,44,23,22,33,13};
static const short Gen_shift_values_BG2_Z_56[1483]= {15,52,39,53,18,16,22,5,12,43,45,2,22,35,43,11,38,2,11,31,53,28,34,43,7,30,20,15,16,53,40,53,54,19,17,22,23,6,12,13,44,46,3,23,36,44,12,38,39,3,12,32,54,29,35,44,7,8,31,21,15,16,52,53,40,53,54,19,17,22,23,6,12,13,43,44,46,2,3,23,36,43,44,12,38,39,2,3,12,31,32,54,28,29,35,44,7,8,30,31,21,16,53,40,54,19,16,17,23,5,6,13,44,46,3,23,35,36,44,11,12,39,3,11,12,32,53,54,29,35,43,44,8,31,20,21,4,5,42,29,31,42,43,8,6,15,11,12,51,1,2,33,35,48,12,25,33,1,27,28,48,1,21,43,18,24,33,52,53,20,10,40,41,22,9,16,22,23,44,42,25,47,48,31,37,38,13,15,28,48,5,13,37,1,7,8,28,37,1,23,50,54,4,13,32,33,0,46,0,1,38,25,10,38,39,4,2,7,8,47,53,54,29,31,44,8,21,29,53,54,23,24,44,53,17,39,30,14,20,29,48,49,16,6,53,53,54,29,35,10,22,53,35,36,11,1,32,55,29,30,46,4,5,36,44,18,19,50,51,26,26,1,28,3,41,16,5,36,18,48,49,26,1,50,24,25,12,20,21,52,41,16,50,24,25,14,45,36,10,11,48,11,42,17,48,26,0,1,45,46,21,13,44,3,33,34,55,0,36,37,24,34,37,38,3,1,42,6,7,46,52,53,27,28,30,42,43,7,20,27,28,52,22,23,42,43,52,15,16,38,12,13,19,28,47,48,14,15,5,31,42,43,12,24,55,11,13,24,25,34,46,32,44,1,38,49,50,21,33,28,39,40,3,15,5,17,18,30,38,50,51,7,3,15,27,39,54,9,10,18,30,27,39,47,3,13,25,44,0,50,6,3,15,29,23,34,35,46,2,36,48,5,37,7,55,3,40,27,42,41,6,3,4,10,48,49,0,31,33,46,10,22,23,31,54,55,26,46,54,55,19,40,41,25,16,22,30,31,51,18,7,8,53,12,13,50,37,50,51,16,14,45,19,20,3,9,10,41,43,48,0,20,33,41,9,35,36,0,9,29,51,26,32,41,4,5,28,18,44,25,12,36,26,47,44,45,0,51,33,34,41,16,18,31,51,7,8,16,39,40,11,31,39,40,4,25,26,1,7,15,16,30,36,3,48,49,55,0,20,37,1,24,44,37,38,2,3,23,1,20,21,35,6,7,27,46,9,10,52,53,17,28,48,30,50,43,7,7,27,20,39,40,28,48,52,15,16,22,23,43,43,7,52,15,16,38,16,36,38,1,2,13,33,19,39,28,47,48,47,48,12,15,35,5,24,25,47,13,14,28,51,15,38,3,29,51,52,50,17,48,15,54,20,21,37,4,44,10,11,19,42,21,44,34,1,54,21,11,34,19,42,43,10,14,36,37,34,1,43,10,7,30,29,52,4,27,10,33,19,42,39,5,6,6,29,52,19,37,38,0,1,19,37,38,6,25,19,20,38,39,41,4,39,2,18,44,45,7,8,28,47,34,35,53,54,10,28,29,12,31,25,43,44,45,8,2,21,10,28,29,34,53,4,5,23,24,25,43,44,34,53,54,16,17,20,39,51,13,14,1,20,10,29,29,30,48,49,53,15,16,43,6,45,53,54,17,18,35,54,55,22,42,35,36,55,0,1,21,55,19,47,4,5,24,25,44,8,50,51,14,15,26,45,46,28,48,41,4,5,5,25,18,38,26,45,46,50,14,19,20,21,40,41,41,4,5,50,14,14,33,34,36,0,11,30,31,17,37,26,46,45,46,9,10,13,32,33,3,23,11,15,43,45,26,13,34,27,48,46,25,52,35,42,17,19,32,52,9,17,41,12,32,41,5,27,2,8,17,37,4,50,44,45,26,13,26,27,48,46,5,51,52,35,41,42,17,19,32,52,9,19,17,41,11,12,32,41,5,27,2,8,17,36,37,4,50,41,22,9,23,23,44,41,42,48,30,31,38,13,15,28,48,4,5,13,36,37,8,28,36,37,1,22,23,54,4,12,13,42,33,0,45,46,48,0,43,53,21,40,31,6,42,37,12,13,22,49,50,3,37,46,50,51,4,16,25,14,22,23,19,20,29,3,11,12,33,9,10,19,40,41,50,43,52,55,0,9,20,29,33,41,42,40,41,50,9,17,18,35,36,45,55,0,9,9,17,18,28,29,38,51,3,4,5,25,26,35,32,41,41,49,50,4,5,14,27,28,37,18,26,27,26,5,47,43,24,51,4,49,43,16,7,30,11,54,12,33,30,31,34,37,19,20,27,2,4,17,37,49,50,2,25,26,53,17,25,26,46,11,12,43,49,1,2,22,45,34,35,13,14,50,51,38,51,51,52,17,15,20,21,4,10,11,41,42,44,0,1,21,34,41,42,10,20,36,37,0,1,10,29,30,52,26,27,33,42,5,6,28,29,19,12,49,36,50,15,13,19,2,14,9,40,42,55,19,32,40,8,35,55,8,28,50,11,25,31,40,4,27,17,48,49,29,29,30,10,17,53,28,30,31,11,52,32,50,29,30,55,0,36,39,18,19,45,46,26,20,21,1,23,3,35,36,16,0,36,13,48,49,20,21,1,45,24,25,15,16,52,35,36,16,45,24,25,8,9,45,31,10,11,5,6,42,12,48,21,0,1,40,41,21,7,8,44,54,33,34,14,15,52,39,52,53,18,16,34,21,22,5,11,12,43,45,2,22,35,43,11,52,37,38,2,11,31,53,28,34,43,6,7,30,20,0,6,26,55,28,36,9,23,52,37,10,2,31,0,28,29,6,35,45,17,18,52,25,27,0,29,2,42,15,6,35,19,47,48,27,0,51,23,24,22,51,42,15,51,23,24,15,44,37,9,10,12,41,18,47,27,55,0,47,20,14,43,4,32,33,5,6,43,30,43,44,9,7,36,12,13,52,2,3,34,36,49,13,26,34,2,40,28,29,49,2,22,44,19,25,34,53,54,21,11,1,2,38,39,26,49,39,40,5,3,8,9,48,54,55,29,30,32,44,45,9,22,29,30,54,24,25,44,45,54,17,18,40,12,14,15,21,30,49,50,16,17,7,50,52,31,33,18,20,32,34,53,55,51,52,53,1,3,40,41,42,41,47,49,22,24,24,26,37,39,1,3,14,15,16,22,24,46,47,48,17,19,37,39,46,47,48,10,12,32,33,34,7,9,13,15,22,23,24,42,44,9,11,55,0,1,40,41,22,9,22,23,44,42,7,47,48,31,37,38,13,15,28,48,5,13,37,44,7,8,28,37,1,23,54,4,13,32,33,0,46};
static const short Gen_shift_values_BG2_Z_60[1483]= {24,21,13,10,30,58,10,50,20,53,2,2,52,34,26,49,22,35,38,22,18,8,34,42,51,46,14,24,25,22,14,10,11,31,59,10,11,51,20,21,54,3,3,53,35,27,50,22,23,36,39,23,19,9,35,43,51,52,47,15,24,25,21,22,14,10,11,31,59,10,11,51,20,21,53,54,3,2,3,53,35,26,27,50,22,23,35,36,39,22,23,19,8,9,35,43,51,52,46,47,15,25,22,14,11,31,58,59,11,50,51,21,54,3,3,53,34,35,27,49,50,23,36,38,39,23,18,19,9,35,42,43,52,47,14,15,24,25,22,14,28,10,11,31,59,19,10,11,51,20,21,54,3,3,53,35,27,50,22,23,36,39,23,19,9,35,43,51,52,47,15,51,52,49,41,0,37,38,58,26,40,37,38,18,47,48,21,30,30,20,2,54,17,48,49,50,3,6,50,46,27,36,2,10,18,19,14,42,20,21,18,10,16,6,7,27,55,6,7,47,16,17,50,59,59,49,31,23,46,11,18,19,32,35,19,15,51,5,31,39,47,48,43,11,3,16,17,59,14,56,6,48,2,3,45,23,5,51,32,33,25,2,3,45,43,24,25,12,13,55,46,28,55,37,55,37,45,27,27,8,9,19,1,42,23,24,5,14,15,57,28,10,31,12,13,15,57,11,52,53,26,1,43,27,9,35,16,17,43,44,26,39,21,7,48,49,9,10,6,7,59,55,55,56,16,44,48,55,56,36,5,6,38,39,48,47,48,38,20,11,12,35,7,8,20,21,24,7,8,4,53,54,20,28,36,37,31,32,0,12,32,33,9,30,1,22,58,18,19,18,39,46,7,46,58,18,19,38,59,8,28,29,41,2,50,11,50,11,40,1,22,43,14,35,37,58,10,30,31,23,44,26,47,10,31,6,27,56,17,22,43,30,51,57,39,59,0,34,55,2,23,37,36,27,51,16,13,5,57,2,22,49,50,2,41,42,12,45,54,54,44,25,26,18,40,41,14,27,29,30,14,9,10,33,0,26,33,34,43,38,5,6,47,36,37,34,26,22,23,43,11,3,22,23,3,32,33,6,15,1,15,5,47,39,2,34,35,48,51,35,31,21,47,55,3,4,59,27,4,1,53,47,50,10,37,38,56,50,29,30,0,33,42,42,32,13,14,6,28,29,2,15,17,18,2,57,58,48,14,21,22,46,31,26,53,54,48,49,7,46,4,38,56,34,35,53,55,13,23,40,41,21,34,35,53,15,32,33,44,45,3,18,36,27,45,27,45,17,35,59,16,17,51,9,14,31,32,46,47,5,0,18,3,20,21,51,47,5,43,0,1,33,51,59,17,7,24,25,15,16,34,11,29,39,56,57,1,1,2,58,59,50,51,37,47,47,48,7,8,35,36,47,47,48,27,28,57,57,58,30,31,39,40,39,40,29,30,11,12,3,4,26,27,59,59,0,12,13,15,16,59,0,55,56,45,46,11,12,19,20,28,28,29,23,24,51,52,19,20,46,47,17,43,44,9,36,5,6,32,33,26,53,54,21,49,5,6,32,33,46,13,15,16,42,43,49,15,16,58,25,58,24,25,48,15,30,57,22,48,49,45,12,17,18,44,45,31,57,58,34,1,18,44,45,14,41,4,30,31,30,57,38,5,46,47,13,14,42,8,9,10,37,22,39,40,2,3,37,59,0,29,52,25,26,48,49,46,9,14,37,15,25,26,48,49,6,29,35,36,58,59,9,31,32,18,41,18,40,41,8,31,50,13,42,4,5,5,28,52,37,38,0,1,51,13,14,54,17,38,0,1,34,57,24,46,47,50,13,58,21,6,7,29,30,2,24,25,30,53,7,30,29,52,49,41,38,38,58,26,23,38,18,48,21,30,30,20,2,54,17,50,3,6,50,46,36,2,10,19,14,42,30,31,28,20,16,17,37,5,56,16,17,57,26,27,0,9,9,59,41,46,33,56,28,29,42,45,29,25,15,41,49,57,58,53,21,36,33,25,57,22,42,9,10,22,1,2,32,5,14,14,4,45,46,38,0,1,34,47,49,50,34,29,30,20,46,53,54,12,3,58,25,26,14,43,4,33,50,20,18,9,5,34,34,35,51,31,32,48,24,40,20,21,37,41,57,9,24,25,20,21,37,1,16,17,25,30,31,47,3,4,20,13,29,12,13,29,3,19,45,0,1,36,37,53,0,15,16,32,33,49,45,46,2,49,4,5,32,33,49,29,44,45,5,18,19,35,45,1,53,8,9,1,2,18,56,57,13,25,40,41,3,0,6,23,15,24,56,36,18,40,16,11,8,0,57,17,44,45,20,57,36,37,7,40,49,49,39,20,21,13,35,36,9,22,24,25,9,4,5,55,21,28,29,38,33,0,1,20,21,17,18,10,58,6,7,27,55,6,7,47,16,17,49,50,59,58,59,49,31,22,23,46,13,18,19,31,32,35,18,19,15,4,5,31,39,47,48,42,43,11,10,7,59,56,16,44,56,36,45,6,39,48,48,38,20,12,35,8,21,24,8,4,1,54,20,28,37,32,0,39,40,46,36,37,43,29,35,3,25,26,32,46,52,14,19,20,25,26,32,6,11,12,35,36,42,8,9,15,18,24,17,18,24,8,14,50,55,56,41,42,48,5,10,11,37,38,44,50,51,57,54,59,0,37,38,44,34,39,40,23,24,30,50,56,58,3,4,6,7,13,1,2,8,30,35,36,19,20,17,9,5,6,26,54,24,5,6,46,15,16,49,58,58,48,30,22,45,44,17,18,31,34,18,14,4,30,38,46,47,42,10,57,51,45,58,19,55,16,47,8,44,5,4,25,32,52,53,44,5,24,44,45,54,15,27,48,36,57,36,57,26,47,8,28,29,0,21,23,43,44,56,17,9,30,12,32,33,56,17,52,12,13,42,3,8,29,16,36,37,25,46,20,41,48,8,9,9,10,7,59,55,56,16,44,41,55,56,36,5,6,39,48,48,38,20,12,35,40,7,8,21,24,8,4,54,20,28,36,37,32,0,33,34,30,31,23,46,19,20,40,8,19,20,0,29,30,2,3,12,11,12,2,44,35,36,59,31,32,44,45,48,31,32,28,44,17,18,44,52,0,1,55,56,24,31,25,28,22,20,14,17,11,37,31,5,58,59,17,11,57,50,51,17,27,21,0,54,9,3,9,3,59,53,41,34,35,33,27,56,49,50,29,23,42,36,45,38,39,29,23,25,18,19,15,9,41,35,49,42,43,58,52,53,47,21,14,15,14,15,12,4,0,1,21,49,52,0,1,41,10,11,44,53,53,43,25,17,40,34,12,13,26,29,13,9,59,25,33,41,42,37,5};
static const short Gen_shift_values_BG2_Z_64[1483]= {7,37,15,51,48,6,10,56,24,36,42,59,50,28,59,38,59,32,15,26,52,30,46,16,11,58,62,8,7,37,15,52,51,48,6,11,10,56,25,24,36,42,59,50,28,59,38,60,59,32,15,26,52,30,46,16,12,11,58,62,8,7,38,37,15,52,51,48,6,11,10,56,25,24,37,36,42,60,59,50,28,60,59,38,60,59,33,32,15,27,26,52,31,30,46,16,12,11,59,58,62,7,37,15,51,48,7,6,10,57,56,24,36,42,59,50,29,28,59,39,38,59,32,16,15,26,53,52,30,46,17,16,11,58,63,62,15,14,44,22,50,59,58,55,13,21,18,17,63,32,31,43,49,2,57,35,2,45,3,2,39,22,33,59,37,53,23,19,18,1,5,47,46,12,54,38,27,26,23,45,40,50,49,31,0,63,11,17,34,25,3,34,13,1,35,34,7,54,1,27,30,5,21,55,51,50,33,37,38,37,3,45,26,18,17,14,36,41,40,22,55,54,2,8,25,16,58,25,4,35,26,25,62,45,56,18,44,60,12,46,42,41,24,28,27,11,10,59,40,25,18,3,55,54,39,51,36,59,9,58,0,14,13,62,45,59,44,28,27,12,39,24,45,30,62,47,53,38,17,31,16,62,47,27,41,26,18,63,62,47,35,20,4,18,3,29,14,41,55,40,11,33,18,49,34,5,19,4,15,14,63,61,46,51,1,50,46,45,12,11,53,13,26,25,22,44,29,49,48,30,63,62,11,10,16,34,33,24,2,34,33,12,34,33,7,6,53,1,0,26,5,4,20,54,50,49,33,32,36,63,4,62,34,28,12,6,43,48,42,45,39,3,61,10,2,7,1,53,47,16,21,15,33,27,39,33,56,50,47,41,25,19,56,50,35,29,51,56,50,29,23,12,6,23,17,49,43,27,21,43,37,13,7,12,3,8,2,55,49,59,53,10,56,63,52,63,29,7,10,43,40,63,62,2,49,48,16,28,34,51,42,21,20,51,31,30,51,24,8,7,18,45,44,43,22,38,9,8,3,50,55,54,17,22,21,51,29,2,1,62,20,62,25,24,6,39,38,50,56,46,9,0,42,9,52,10,9,46,29,40,2,44,60,30,26,25,8,12,37,3,45,18,17,14,37,36,1,40,23,22,54,2,8,25,16,59,58,25,5,4,25,62,46,45,56,19,18,60,12,47,46,37,41,24,29,28,11,10,47,40,13,18,55,55,54,27,51,24,47,9,46,50,14,13,50,33,59,32,28,27,0,39,12,45,18,62,35,53,26,5,31,4,62,35,15,41,14,63,62,35,35,8,56,18,55,16,29,2,29,55,28,33,6,49,22,57,19,56,15,14,51,61,34,39,1,38,29,54,28,20,58,62,36,50,9,34,8,31,5,53,27,32,57,31,39,13,46,7,45,19,57,25,63,42,16,33,7,11,49,42,16,21,59,17,42,16,15,53,62,36,9,47,35,9,13,51,29,3,63,37,33,58,32,41,15,45,19,16,58,15,57,24,45,23,23,1,60,38,59,37,56,34,14,56,10,19,61,18,60,0,42,33,11,32,10,23,44,22,50,28,46,3,45,58,36,36,14,46,3,45,46,24,4,46,3,45,19,40,18,23,1,13,34,12,60,38,17,38,16,54,32,24,2,20,62,19,61,45,2,44,6,48,13,58,8,57,7,38,23,37,1,15,38,52,37,51,34,48,56,6,61,61,11,60,10,42,56,11,25,10,24,37,22,36,28,42,60,45,59,36,50,14,28,60,45,59,24,38,59,46,60,45,59,33,18,32,1,15,27,12,26,38,52,31,16,30,32,46,2,16,62,12,61,11,59,44,58,48,62,27,1,49,0,30,8,22,44,41,63,19,3,49,17,29,35,52,43,21,52,31,52,25,8,19,45,23,39,9,4,51,55,37,36,2,44,17,16,13,35,25,40,39,21,54,53,1,7,24,15,57,40,24,3,25,24,61,44,55,17,59,11,45,41,40,23,27,25,55,33,11,5,2,25,24,28,11,10,42,54,60,13,4,47,46,13,57,56,13,50,34,33,44,7,6,48,0,35,34,41,29,12,17,16,29,62,22,42,45,45,10,7,35,27,40,39,1,6,5,31,47,9,20,19,45,16,42,1,38,0,43,42,4,51,24,50,28,57,56,18,5,4,30,10,36,28,27,53,18,44,23,60,22,28,27,53,33,6,32,28,27,53,1,0,26,10,47,9,59,58,20,47,20,46,14,63,62,24,14,40,11,48,10,44,43,5,27,26,52,57,30,56,7,22,33,36,6,17,27,6,47,8,19,8,38,16,52,49,8,7,41,11,58,57,25,37,43,60,51,30,29,60,40,39,60,33,17,16,27,54,53,31,47,18,17,12,59,0,63,46,45,12,11,53,49,26,25,22,44,49,48,30,63,62,11,10,16,34,33,24,2,34,33,12,43,34,33,7,6,53,1,0,26,5,4,20,54,50,49,33,32,36,50,16,58,30,27,49,53,35,3,3,15,21,38,29,7,38,17,38,11,58,5,31,35,9,25,59,54,37,41,29,28,43,59,58,9,36,51,18,9,8,23,5,20,43,27,42,32,31,46,29,13,28,46,45,60,58,57,8,63,14,17,16,31,7,22,1,49,0,17,16,31,11,59,10,17,16,31,54,53,4,52,36,51,48,47,62,25,9,24,52,51,2,3,18,53,37,52,33,32,47,16,15,30,35,19,34,7,6,36,14,51,50,47,5,56,10,9,55,24,23,35,41,58,49,27,58,37,39,59,58,31,14,25,51,29,45,15,11,10,57,61,11,37,25,34,30,0,60,42,38,14,10,11,7,30,33,29,37,33,16,19,15,51,47,63,59,5,1,22,18,13,9,52,55,51,22,18,62,1,61,22,18,59,55,39,42,38,53,49,12,15,11,57,53,9,5,40,43,39,38,34,21,17,22,25,21,46,45,11,53,26,25,22,44,30,49,48,30,63,62,10,16,33,24,2,33,12,1,34,33,6,53,0,26,4,20,54,50,49,32,36,42,41,8,7,49,46,22,21,18,40,45,44,26,59,58,7,6,12,30,29,20,62,30,29,8,30,29,3,2,49,61,60,22,43,1,0,16,50,46,45,29,28,32,18,63,48,29,26,7,62,43,59,40,63,17,62,21,2,49,3,48,63,35,16,47,28,53,34,6,51,61,42,21,39,20,6,51,31,49,30,6,51,43,24,8,26,7,37,18,45,63,44,41,22,57,38,9,27,8,22,3,5,50,55,9,54,62,61,27,5,42,41,38,60,0,1,0,46,15,14,26,32,49,40,18,49,28,36,50,49,22,5,16,42,20,36,6,2,1,48,52};
static const short Gen_shift_values_BG2_Z_72[1483]= {1,17,21,24,32,46,51,47,33,20,18,30,36,20,64,2,41,10,71,24,47,67,37,54,53,48,5,2,1,17,21,25,24,32,46,52,51,47,34,33,20,18,30,36,20,64,2,42,41,10,71,24,47,67,37,54,54,53,48,5,2,1,18,17,21,25,24,32,46,52,51,47,34,33,21,20,18,31,30,36,20,65,64,2,42,41,11,10,71,25,24,47,68,67,37,54,54,53,49,48,5,1,17,21,24,32,47,46,51,48,47,33,20,18,30,36,21,20,64,3,2,41,10,0,71,24,48,47,67,37,55,54,53,48,6,5,53,52,68,0,41,4,3,11,25,23,31,30,26,13,12,71,69,9,15,71,43,53,21,20,61,50,3,26,46,16,33,33,32,27,56,1,0,16,20,39,24,23,31,45,67,51,50,46,33,32,19,17,29,35,19,63,1,11,41,40,9,70,23,46,64,66,36,53,53,52,47,4,69,68,12,16,36,20,19,27,41,47,46,42,29,28,15,13,25,31,15,59,69,14,37,36,5,66,19,42,34,62,32,49,49,48,43,0,60,38,37,66,53,10,57,14,61,60,17,68,25,10,40,39,24,16,15,44,11,41,40,70,69,26,56,13,54,11,66,23,0,29,56,14,13,28,57,38,68,67,62,6,5,34,46,3,35,65,64,60,17,11,41,40,34,31,60,1,30,18,48,47,18,17,46,12,41,41,71,70,18,17,34,33,37,69,41,40,48,62,68,68,67,63,50,49,37,36,34,47,46,52,36,9,8,18,58,57,27,26,15,41,40,63,12,11,53,70,70,69,65,64,21,25,51,50,41,66,45,70,48,2,1,56,9,70,23,24,3,29,28,71,24,57,11,10,44,69,42,67,54,7,60,13,44,69,16,41,26,51,65,19,18,34,59,23,48,48,1,71,24,19,44,61,14,6,31,39,5,31,30,0,25,29,54,45,40,28,23,65,9,13,27,16,24,39,38,43,40,39,25,12,10,22,28,13,12,56,67,66,33,2,64,63,16,40,39,29,59,29,47,46,45,40,70,69,43,61,60,4,8,12,11,19,33,32,39,38,34,21,20,7,5,49,17,23,7,51,61,29,28,69,58,11,34,54,24,41,41,40,35,64,48,64,68,3,71,7,22,21,36,26,23,22,8,67,65,5,11,68,67,39,50,49,16,57,47,46,71,23,22,42,12,30,29,61,28,23,53,52,60,59,26,3,42,7,46,11,10,49,18,57,32,0,71,70,38,37,4,33,1,0,20,19,58,6,45,4,43,16,55,22,61,6,46,45,50,17,60,28,27,28,27,66,68,35,57,25,24,50,10,49,33,1,0,53,20,23,62,40,8,7,40,39,6,34,1,63,31,30,25,58,57,41,1,45,5,66,48,9,8,56,16,70,30,3,36,35,71,31,57,18,17,44,4,42,2,54,14,60,20,44,4,16,48,26,58,65,26,25,34,66,23,55,48,8,71,31,19,51,61,21,6,38,5,38,37,0,32,29,61,30,29,10,9,45,26,25,49,29,53,52,33,32,60,40,2,54,47,8,7,60,59,3,55,62,61,42,41,48,29,28,46,26,58,39,38,64,44,48,28,20,1,0,30,10,70,69,50,49,38,19,18,27,7,52,33,32,3,55,23,4,3,65,45,10,62,10,9,62,61,4,57,56,33,13,8,67,66,44,43,10,60,59,14,63,18,17,67,66,25,2,39,16,47,45,44,22,21,40,17,27,26,4,3,13,63,62,11,60,23,1,0,29,6,13,62,57,35,34,67,44,42,35,34,12,11,3,53,52,64,41,17,67,66,40,17,60,38,37,30,7,47,24,47,46,24,23,41,19,18,70,47,16,33,69,42,58,62,6,65,1,15,27,20,16,2,61,59,71,5,61,33,43,10,51,40,65,16,36,6,23,22,17,46,8,7,23,27,31,30,38,52,1,58,57,53,40,39,26,24,36,42,26,30,70,8,48,47,16,5,30,53,1,43,60,60,59,54,11,10,26,30,18,33,41,56,55,60,57,56,42,29,27,39,45,30,29,1,12,11,50,19,9,8,33,57,56,4,46,64,63,2,62,57,15,14,53,59,67,42,55,29,41,28,55,62,30,29,62,46,45,6,49,10,53,52,13,60,21,2,36,35,8,7,40,3,37,36,69,62,61,22,49,48,9,46,7,59,58,19,64,25,48,10,9,21,20,53,30,64,63,70,69,30,39,38,71,27,61,60,53,52,13,3,37,36,27,24,23,56,65,26,10,44,43,10,9,42,5,4,37,33,67,66,12,9,33,4,42,60,24,14,55,31,69,68,12,16,19,27,42,41,7,46,43,42,28,15,13,25,31,16,15,59,70,69,36,5,67,66,19,43,42,62,32,50,49,48,43,1,0,1,0,17,16,20,31,24,23,31,45,51,50,46,33,32,20,19,17,30,29,35,19,64,63,1,16,41,40,10,9,70,24,23,46,67,66,36,53,53,52,48,47,4,3,19,23,26,34,48,53,49,62,35,22,20,32,38,22,66,4,43,12,1,26,49,5,69,39,56,55,50,7,27,26,43,43,42,59,46,63,36,50,49,66,57,2,71,17,16,5,4,21,0,18,17,59,58,3,46,45,62,43,60,56,55,0,61,6,45,63,62,18,17,34,27,45,44,67,66,11,36,35,52,24,42,41,50,49,66,0,18,17,21,20,37,62,7,7,25,24,7,6,23,2,1,18,30,48,47,23,22,38,42,46,45,53,67,59,1,0,68,55,54,41,39,51,57,41,13,23,64,63,62,31,20,45,68,16,58,3,3,2,69,26,48,56,25,26,57,42,1,46,5,49,8,57,16,71,31,30,4,35,0,32,31,58,17,45,4,43,2,55,14,61,20,45,5,4,17,48,27,59,58,66,25,35,66,24,56,55,49,8,0,32,31,20,51,62,21,7,39,38,6,37,1,32,30,62,61,3,2,18,22,26,25,33,47,0,53,52,48,35,34,21,19,31,37,21,65,3,69,43,42,11,0,25,48,68,38,55,55,54,49,6,0,71,16,15,19,46,23,22,30,44,50,49,45,32,31,19,18,16,29,28,34,18,63,62,0,40,39,9,8,69,23,22,45,31,66,65,35,52,52,51,47,46,3,2,31,18,47,22,51,25,54,33,62,47,5,4,52,9,48,6,5,5,34,63,21,50,19,48,31,60,37,66,21,51,50,65,22,3,33,32,42,71,11,40,0,30,29,25,54,48,6,5,68,25,38,67,55,13,12,54,11,49,6,6,36,35,21,20,36,40,44,43,51,65,47,71,70,66,53,52,39,37,49,55,39,11,21,46,61,60,29,18,43,66,14,56,1,1,0,67,24};
static const short Gen_shift_values_BG2_Z_80[1483]= {78,55,18,78,12,36,78,13,78,42,17,78,7,20,78,64,78,6,10,78,55,78,26,51,78,53,44,79,78,55,18,79,78,12,36,79,78,13,79,78,42,17,78,7,20,78,64,79,78,6,10,78,55,78,26,51,79,78,53,44,79,78,56,55,18,79,78,12,36,79,78,13,79,78,43,42,17,79,78,7,20,79,78,64,79,78,7,6,10,79,78,55,79,78,26,51,79,78,54,53,44,78,55,18,78,12,37,36,78,14,13,78,42,17,78,7,21,20,78,65,64,78,6,11,10,78,56,55,78,26,52,51,78,53,45,44,76,75,52,15,79,76,75,9,33,55,76,75,10,76,75,39,14,75,4,17,75,61,76,75,3,7,75,52,75,23,48,76,75,50,41,63,62,39,2,79,63,62,76,20,50,63,62,77,63,62,26,1,62,71,4,62,48,61,63,62,70,74,62,39,60,62,10,35,63,62,37,28,67,66,43,6,79,67,66,0,24,67,66,1,67,66,30,5,66,75,8,66,52,43,67,66,74,78,66,43,18,66,14,39,67,66,41,32,44,15,14,76,71,53,34,16,15,14,76,28,10,52,35,34,79,15,14,76,29,12,11,15,14,76,58,40,33,15,14,76,23,5,36,19,18,14,76,0,63,62,44,15,14,76,22,4,26,9,8,14,76,71,54,53,67,14,76,42,24,67,50,49,15,14,76,69,51,60,43,42,6,5,63,62,25,79,6,5,19,43,64,6,5,20,6,5,50,49,24,6,5,14,27,6,5,71,6,5,14,13,17,6,5,62,6,5,33,58,6,5,61,60,51,49,4,3,26,60,69,23,49,4,3,63,17,7,41,79,49,4,3,64,18,49,4,3,13,47,68,22,49,3,58,12,71,25,49,3,35,69,49,4,3,57,11,61,15,49,3,26,60,49,3,77,31,22,56,16,49,4,3,24,58,15,49,79,16,75,19,0,57,20,79,0,14,39,38,0,16,15,0,44,19,0,9,23,22,0,67,66,0,8,13,12,0,58,57,6,0,28,54,53,0,55,47,46,3,47,46,23,66,47,46,60,4,79,47,46,61,47,46,10,65,32,46,55,68,46,32,47,46,54,58,46,23,46,74,19,47,46,21,12,24,1,44,79,24,38,63,62,31,24,40,39,24,68,43,24,33,47,46,24,11,10,24,32,37,36,24,2,1,24,52,78,77,21,24,79,71,70,56,55,25,32,2,75,45,56,55,25,69,39,13,64,63,79,56,55,25,70,41,40,56,55,25,19,69,74,44,55,25,64,34,77,48,47,55,25,41,12,11,56,55,25,63,33,67,38,37,57,55,25,32,3,2,55,25,3,53,28,79,78,56,55,25,30,0,21,72,71,71,18,17,48,74,11,37,79,71,18,17,5,31,29,55,71,18,17,6,32,71,18,17,35,61,10,36,71,17,0,26,13,39,71,17,57,3,71,18,17,79,25,3,29,71,17,48,74,71,17,19,45,44,70,71,18,17,46,72,37,63,30,29,62,61,6,39,38,49,1,30,29,62,61,43,75,67,19,79,30,29,62,61,44,76,30,29,62,61,73,26,25,48,0,29,62,61,38,70,51,3,29,62,61,15,47,30,29,62,61,37,70,69,41,73,29,62,61,6,38,29,62,61,57,9,2,34,30,29,62,61,4,37,36,75,27,78,28,27,17,16,4,74,73,47,36,28,27,17,16,41,30,65,54,79,28,27,17,16,42,31,28,27,17,16,71,61,60,46,35,27,17,16,36,25,49,38,27,17,16,13,2,23,28,27,17,16,35,25,24,39,28,27,17,16,4,73,27,17,16,55,44,0,69,28,27,17,16,2,72,71,73,62,79,17,5,72,49,12,79,72,6,30,77,72,7,72,36,11,72,1,14,72,58,72,0,4,72,49,72,20,45,72,47,38,23,22,79,42,23,22,36,60,79,23,22,37,23,22,66,41,22,31,44,67,22,8,23,22,30,34,22,79,22,50,75,23,22,77,68,31,8,51,79,31,45,70,69,31,47,46,31,75,50,31,40,54,53,31,18,17,31,39,44,43,31,9,8,31,59,5,4,16,31,6,78,77,79,3,79,74,77,79,68,6,79,64,12,11,5,69,68,62,31,25,12,11,5,25,19,49,44,43,12,11,5,26,21,20,79,12,11,5,56,55,49,30,24,12,11,5,20,14,33,28,27,12,11,5,77,72,71,12,11,5,20,19,13,23,18,17,12,11,5,68,63,62,19,12,11,5,39,33,64,59,58,12,11,5,67,66,60,57,52,51,79,31,79,45,29,79,73,79,34,50,53,18,75,38,18,32,57,56,79,18,34,33,18,62,37,18,27,41,40,18,5,4,18,26,31,30,18,76,75,18,46,72,71,18,73,65,64,41,40,18,17,60,79,41,40,54,78,41,40,55,41,40,5,4,59,41,40,49,62,41,40,26,19,41,40,49,48,52,41,40,17,41,40,68,13,41,40,16,15,6,11,68,31,11,25,49,11,26,79,11,55,30,11,20,33,11,77,11,19,23,11,68,7,11,39,64,11,66,57,18,17,76,75,74,53,37,16,79,18,17,76,31,10,55,35,34,18,17,76,32,12,11,18,17,76,62,61,40,36,15,18,17,76,26,5,39,19,18,18,17,76,3,63,62,18,17,76,26,25,4,29,9,8,18,17,76,74,54,53,18,17,76,45,24,70,50,49,18,17,76,73,72,51,63,43,42,5,4,61,24,5,4,18,42,79,5,4,19,5,4,48,23,4,13,26,4,70,76,5,4,12,16,4,61,4,32,57,5,4,59,50,79,62,1,78,62,55,39,18,2,78,62,12,76,36,21,20,78,62,13,78,77,78,62,42,26,17,1,78,62,7,71,20,5,4,78,62,64,49,48,78,62,6,70,10,75,74,78,62,55,40,39,78,62,26,10,51,36,35,78,62,53,37,44,29,28,18,17,74,37,18,17,31,55,79,18,17,32,18,17,61,36,17,26,39,17,3,12,18,17,25,29,17,74,17,45,70,18,17,72,63,57,56,34,33,76,79,57,56,70,14,57,56,71,57,56,21,20,75,57,56,65,78,57,56,42,57,56,65,64,68,57,56,33,23,57,56,4,29,57,56,32,31,22,34,61,11,38,54,1,34,61,48,75,72,20,19,34,61,49,77,76,79,34,61,78,25,53,0,34,61,43,70,56,4,3,34,61,20,48,47,34,61,42,69,46,74,73,34,61,11,39,38,34,61,62,9,7,35,34,34,61,9,36,0,28,27,54,53,30,73,54,53,67,11,79,54,53,68,54,53,17,72,53,62,75,53,39,1,54,53,61,65,53,30,53,1,26,54,53,28,19};
static const short Gen_shift_values_BG2_Z_88[1483]= {66,15,8,53,78,51,12,84,1,63,17,61,80,84,87,37,38,53,15,35,87,81,52,15,33,43,15,67,66,15,8,54,53,78,51,13,12,84,2,1,63,17,61,80,84,87,37,39,38,53,15,35,87,81,52,15,34,33,43,15,67,66,16,15,8,54,53,78,51,13,12,84,2,1,64,63,17,62,61,80,84,0,87,37,39,38,54,53,15,36,35,87,82,81,52,15,34,33,44,43,15,66,15,8,53,78,52,51,12,85,84,1,63,17,61,80,85,84,87,38,37,38,53,16,15,35,0,87,81,52,16,15,33,43,16,15,62,61,10,3,85,49,48,73,46,66,8,7,79,85,84,58,12,56,75,79,82,32,34,33,48,10,30,82,76,47,10,29,28,38,10,39,38,75,68,78,26,25,50,23,83,73,72,56,62,61,35,77,33,52,56,59,9,34,11,10,25,75,7,59,14,53,24,75,6,5,15,75,8,7,44,37,46,83,82,19,80,42,41,25,31,30,4,46,2,21,25,28,66,65,68,67,82,44,64,28,9,22,81,44,63,62,72,44,66,26,25,33,62,70,55,63,13,12,20,37,45,10,19,18,47,60,59,67,43,52,51,49,48,56,22,30,64,72,20,28,39,47,43,52,51,46,54,84,5,4,36,86,85,5,12,20,62,71,70,82,2,46,55,54,23,40,48,11,19,62,71,70,81,80,0,2,10,62,71,70,52,51,1,0,81,52,39,38,63,36,30,86,85,69,75,74,49,48,2,47,46,65,69,73,72,22,24,23,39,38,0,21,20,72,67,66,37,0,19,18,29,28,0,77,43,42,26,79,19,72,64,30,29,1,54,62,27,15,23,77,76,7,60,12,66,65,74,39,28,81,72,37,3,56,7,60,10,63,48,13,49,15,14,64,29,26,79,46,11,10,63,4,57,63,28,26,79,53,44,10,9,54,19,26,79,22,24,85,22,31,68,61,2,18,43,17,16,65,50,49,54,28,70,26,45,50,49,52,3,2,3,18,69,68,0,53,52,86,46,17,69,68,86,8,69,68,23,71,70,19,12,58,57,82,55,33,17,16,0,6,5,67,21,10,65,84,0,3,41,43,42,57,19,39,3,85,56,19,38,37,47,19,17,54,47,28,4,29,3,2,2,51,36,35,40,14,56,12,31,36,35,38,77,76,77,4,55,54,74,39,38,32,3,55,54,26,72,82,55,54,75,74,56,23,5,16,86,62,61,43,86,68,59,42,41,10,21,20,2,4,75,74,10,9,79,71,53,25,7,69,51,0,70,4,75,74,7,77,45,28,27,47,46,28,61,43,23,6,5,56,43,25,7,78,77,1,71,60,42,23,6,5,42,41,23,51,33,23,6,5,81,19,18,30,55,23,48,48,68,6,5,5,30,66,3,27,53,52,11,36,16,42,41,78,15,32,57,76,13,7,32,11,36,14,39,52,77,53,79,78,68,5,30,55,50,75,14,39,8,33,67,4,30,55,48,74,73,58,83,30,55,84,83,56,55,32,5,4,25,85,71,70,43,42,7,67,68,40,77,30,29,2,1,13,73,19,18,79,78,80,53,52,34,6,78,51,50,9,69,13,73,16,77,76,54,26,56,55,28,27,70,43,42,32,4,52,25,24,16,76,10,71,70,69,41,32,4,51,50,23,22,60,33,32,32,4,69,41,40,54,53,77,3,2,70,83,28,27,41,40,52,65,25,38,45,75,74,0,87,58,71,64,63,77,76,37,51,50,79,4,35,49,48,54,67,58,71,61,75,74,11,24,22,13,12,26,25,27,41,40,77,2,9,23,22,61,74,55,69,68,26,39,77,2,8,7,21,20,17,31,30,77,2,84,30,21,35,72,65,12,22,47,20,46,69,53,58,32,74,30,49,53,56,6,7,22,72,4,56,50,21,72,2,12,72,64,63,12,5,51,50,75,48,39,10,9,81,87,86,60,14,58,77,81,51,84,34,36,35,50,12,32,84,78,49,12,31,30,40,12,18,55,48,67,5,30,4,3,52,37,36,41,15,57,13,32,37,36,39,78,77,78,5,56,55,75,40,39,33,4,56,55,77,73,83,56,55,17,74,21,43,61,24,19,60,71,47,32,31,35,69,68,72,61,65,19,18,22,43,47,16,21,20,66,65,69,49,54,53,35,55,54,58,29,28,32,70,74,27,26,30,45,49,49,54,53,53,52,56,2,7,6,4,3,7,19,18,22,68,73,72,1,0,4,52,57,56,37,47,46,50,17,21,68,73,72,87,86,2,9,8,12,68,73,72,41,15,63,23,60,50,72,83,84,4,28,38,75,68,25,50,24,23,28,72,57,56,61,35,77,33,52,57,56,59,10,9,10,25,76,75,7,60,59,53,24,76,75,5,15,76,75,33,32,70,69,62,27,20,19,44,17,67,66,50,56,55,30,29,71,28,27,46,50,54,53,3,72,5,4,20,19,69,2,1,53,48,47,18,69,0,87,10,9,69,7,44,37,82,19,80,41,25,16,30,4,46,2,21,25,28,66,67,82,44,64,28,48,22,81,44,62,72,44,20,19,52,57,56,1,49,82,10,7,6,39,31,64,4,38,37,54,53,86,37,71,70,43,42,75,17,16,49,58,3,15,14,47,33,66,37,71,70,41,40,73,78,24,23,80,79,24,7,6,39,56,2,1,77,76,21,40,74,73,35,34,67,5,38,56,2,1,75,74,19,85,84,29,56,2,1,63,62,11,4,50,49,74,47,37,9,8,80,86,85,59,13,57,76,80,83,33,63,35,34,49,11,31,83,77,48,11,30,29,39,11,72,65,40,57,16,6,53,87,46,44,3,69,28,42,2,1,3,50,75,35,34,80,39,54,13,8,55,52,11,71,30,75,35,34,78,37,28,76,75,29,76,44,3,6,54,53,26,73,78,38,37,72,31,43,2,6,54,53,24,71,34,81,6,54,53,86,85,34,27,73,72,9,70,23,32,31,15,21,20,82,36,80,11,15,18,56,6,58,57,72,34,54,18,12,71,34,53,52,62,34,84,83,33,32,25,20,71,70,7,68,30,29,13,19,18,81,80,34,79,78,9,13,17,16,54,56,55,71,70,32,53,52,16,5,11,10,69,32,51,50,61,60,32,46,60,83,9,76,2,33,47,58,72,31,46,45,80,6,64,79,78,71,69,83,43,57,85,11,41,55,60,74,64,79,78,67,81,17,32,31,18,32,33,47,83,10,9,15,29,67,82,81,61,75,32,46,83,10,9,13,27,23,37,83,10,9,75,74,23,16,62,61,86,59,43,21,20,4,10,9,71,25,69,0,4,7,45,5,47,46,61,23,43,7,1,60,23,42,41,51,23};
static const short Gen_shift_values_BG2_Z_96[1483]= {76,25,23,95,16,38,68,77,64,34,19,46,12,15,90,70,69,29,25,89,20,87,16,26,74,1,88,77,76,25,23,0,95,16,38,69,68,77,65,64,34,19,46,12,15,90,70,70,69,29,25,89,20,87,16,26,75,74,1,88,77,76,26,25,23,0,95,16,38,69,68,77,65,64,35,34,19,47,46,12,15,91,90,70,70,69,30,29,25,90,89,20,88,87,16,26,75,74,2,1,88,76,25,23,95,16,39,38,68,78,77,64,34,19,46,12,16,15,90,71,70,69,29,26,25,89,21,20,87,16,27,26,74,1,89,88,10,9,54,52,71,29,28,45,67,73,2,1,10,94,93,63,48,75,41,44,23,3,3,2,58,54,22,49,20,45,55,8,7,30,21,29,28,73,71,9,48,47,64,86,43,21,20,29,17,16,82,67,94,60,63,42,22,24,22,21,77,73,41,68,79,39,64,74,27,26,49,40,69,68,17,15,32,88,87,8,30,61,60,69,57,56,26,11,38,4,7,82,62,91,62,61,21,17,81,12,3,79,8,18,67,66,89,80,48,83,82,27,31,72,29,70,6,5,46,22,63,44,86,85,79,75,74,19,83,29,28,71,70,15,40,81,25,66,52,93,18,59,21,63,62,0,41,76,22,21,89,76,75,20,35,76,31,73,72,95,40,26,68,67,15,93,38,22,63,32,74,73,81,80,25,7,48,94,40,39,37,36,82,81,79,21,56,55,72,94,69,29,28,37,25,24,91,90,75,7,6,68,71,51,50,30,30,29,86,85,81,50,49,76,48,47,72,82,35,34,58,57,48,69,63,62,18,11,16,9,88,82,81,9,2,31,24,27,61,55,54,70,63,57,51,50,27,20,12,5,39,32,5,94,8,1,83,76,63,56,62,56,55,22,15,18,11,82,75,13,6,80,73,9,2,19,12,35,67,61,60,90,83,81,74,58,7,21,51,38,83,81,31,57,74,1,0,30,40,39,26,92,77,8,70,74,73,52,33,32,31,87,84,83,51,79,78,91,49,74,85,84,36,59,51,50,77,88,87,36,34,11,10,27,49,38,80,79,88,76,75,45,30,92,57,23,26,5,81,81,80,40,36,4,31,2,27,37,86,85,12,3,50,95,93,48,69,86,13,12,28,42,52,51,38,8,89,20,82,86,85,64,45,44,43,3,0,95,63,91,90,61,86,1,0,34,48,71,63,62,2,1,47,46,92,44,90,21,20,66,37,83,59,10,9,18,90,89,39,2,49,48,86,85,35,55,5,40,86,67,17,33,79,36,83,82,15,61,91,42,41,91,90,40,50,0,46,93,92,21,14,60,41,88,87,12,58,37,83,47,94,93,0,95,45,22,68,13,60,59,43,62,61,88,10,86,8,67,62,81,80,79,1,5,23,35,54,53,44,62,31,50,49,1,19,82,4,13,31,75,93,78,0,57,75,37,55,36,55,54,92,14,88,10,56,74,83,5,54,72,79,1,89,11,41,60,59,64,82,55,73,20,19,45,44,64,90,89,62,87,39,38,64,63,55,80,77,6,86,12,11,37,36,20,45,8,7,33,32,73,3,2,58,83,85,15,14,51,76,54,79,33,59,58,13,38,13,12,38,37,68,94,93,64,89,32,58,57,59,84,30,56,55,55,80,65,90,18,17,43,42,40,66,65,31,56,80,86,85,83,82,34,32,31,32,29,9,8,6,5,25,22,47,44,61,78,77,75,74,86,83,74,73,71,70,43,41,40,28,25,55,53,52,21,18,24,21,3,1,0,79,76,22,79,78,76,75,38,36,35,34,31,2,0,95,29,26,0,94,93,25,22,35,32,84,83,81,80,10,8,7,1,94,89,5,45,40,85,83,57,59,76,2,41,32,41,28,94,79,10,72,75,54,34,33,89,85,53,80,51,76,86,38,61,52,38,37,82,80,57,56,73,95,75,30,29,38,26,25,91,76,7,69,72,60,51,31,31,30,86,82,50,77,48,73,83,36,35,58,49,47,92,90,60,66,83,10,9,39,49,48,35,5,86,17,79,83,82,61,42,41,40,0,93,92,60,88,87,58,83,94,93,78,45,68,60,59,19,51,9,85,94,85,56,63,44,20,36,35,65,81,80,14,78,12,55,54,84,71,5,93,28,27,28,27,57,36,67,66,66,24,23,53,90,89,23,74,8,6,5,35,67,1,70,5,4,50,49,79,29,60,59,29,28,58,85,84,18,80,15,14,49,48,78,75,10,9,40,47,46,76,71,5,81,16,15,34,33,63,57,56,86,47,78,77,6,49,69,14,71,13,16,23,57,51,55,54,3,1,73,90,17,16,2,46,56,55,42,12,93,24,86,90,89,68,49,48,47,7,4,3,67,95,94,65,90,5,4,52,75,67,66,94,93,43,42,40,83,17,16,33,55,86,85,94,82,81,52,51,36,64,63,29,32,12,11,87,7,87,86,47,46,42,11,10,37,9,8,33,43,92,91,19,18,9,8,53,51,27,44,66,0,9,68,92,62,47,74,40,43,22,2,1,57,53,21,48,82,19,44,54,6,29,20,62,61,88,11,10,37,8,35,76,81,80,11,1,28,23,51,50,54,53,80,62,90,89,50,49,76,20,19,46,4,31,32,31,58,93,24,0,28,27,76,75,6,55,83,82,55,54,81,15,14,41,10,38,37,75,74,5,5,33,32,73,72,3,1,28,11,39,38,60,59,86,83,82,13,73,5,4,95,94,43,41,18,17,34,56,76,87,86,95,83,82,52,37,64,30,33,12,88,87,88,87,47,43,11,38,9,34,44,93,92,19,10,24,54,73,17,11,62,56,60,54,36,30,53,47,75,70,69,9,3,18,13,12,5,95,71,65,56,50,83,77,49,43,52,47,46,31,25,11,6,5,10,4,66,60,62,57,56,30,24,57,52,51,28,22,53,47,63,58,57,15,9,38,32,29,24,23,75,74,23,21,94,93,14,36,83,67,66,75,63,62,32,17,44,10,13,88,68,54,68,67,27,23,87,18,85,14,24,73,72,95,86,38,37,83,82,80,92,57,56,73,95,30,29,38,26,25,92,91,76,8,7,69,72,52,51,31,31,30,87,86,82,51,50,77,35,49,48,73,83,36,35,59,58,49,87,47,36,92,34,90,10,66,27,83,49,10,9,79,39,88,49,48,6,75,35,45,5,30,86,57,17,23,79,26,83,82,5,61,81,42,41,80,40,40,0,36,93,92,4,60,31,88,87,2,58,27,83,37,94,93,85,45,12,68,3,60,59,41,40,85,83,60,59,76,2,50,33,32,41,29,28,94,79,10,72,75,54,34,6,34,33,89,85,53,80,51,76,86,39,38,61,52};
static const short Gen_shift_values_BG2_Z_104[1483]= {37,16,20,17,57,34,70,46,59,25,45,1,77,16,100,5,90,79,97,15,1,12,26,85,11,74,54,38,37,16,20,18,17,57,34,71,70,46,60,59,25,45,1,77,16,100,5,91,90,79,97,15,1,12,26,85,12,11,74,54,38,37,17,16,20,18,17,57,34,71,70,46,60,59,26,25,45,2,1,77,16,101,100,5,91,90,80,79,97,16,15,1,13,12,26,85,12,11,75,74,54,37,16,20,17,57,35,34,70,47,46,59,25,45,1,77,17,16,100,6,5,90,79,98,97,15,2,1,12,26,86,85,11,74,55,54,51,50,29,33,42,31,30,70,47,26,84,83,59,73,72,38,58,14,90,29,9,18,0,103,92,6,28,14,25,39,98,25,24,87,67,100,99,78,82,31,80,79,15,96,48,29,28,4,18,17,87,3,63,35,78,58,67,35,49,48,37,55,77,63,27,74,88,43,74,73,32,12,50,49,28,32,6,30,29,69,46,83,82,58,72,71,37,57,13,89,28,8,17,33,103,102,91,5,27,13,93,24,38,97,24,23,86,66,63,41,40,95,19,74,23,78,21,20,75,60,11,37,93,92,58,74,73,24,49,1,0,63,62,13,28,83,48,103,4,59,80,31,19,75,74,103,54,8,64,63,77,94,93,44,82,33,100,52,51,18,73,4,60,59,38,15,70,29,84,88,40,39,15,14,69,77,28,57,9,8,60,59,39,38,42,100,40,39,79,56,72,93,92,68,82,81,48,47,67,24,23,99,38,19,18,27,9,8,102,101,15,38,37,23,35,34,48,3,34,33,97,96,76,34,15,14,13,97,17,101,14,99,98,54,34,31,11,81,67,48,47,43,23,56,37,36,22,2,42,22,102,82,74,54,13,97,97,77,2,86,87,68,67,76,56,94,74,12,96,102,82,9,93,23,3,82,62,26,8,93,92,71,51,51,31,20,59,72,50,45,24,28,38,25,65,43,42,78,55,54,67,33,53,9,85,25,24,4,14,13,98,87,2,1,23,10,9,28,20,34,94,93,19,82,63,62,34,87,86,65,69,67,66,2,83,17,16,15,95,5,4,74,94,50,50,22,65,45,54,36,35,24,42,64,50,61,75,30,61,60,19,103,15,98,102,31,99,35,13,12,52,48,25,24,37,3,23,83,55,99,98,78,88,87,68,57,76,75,97,84,83,94,4,64,63,94,93,52,33,32,90,89,42,68,21,72,25,70,69,22,5,62,86,40,39,90,19,18,75,98,52,51,8,7,64,77,30,97,50,53,6,25,82,68,22,21,48,1,57,11,10,39,38,95,27,84,45,103,102,19,67,20,53,7,6,64,17,78,31,33,91,90,64,63,16,22,79,2,60,59,41,36,35,20,14,24,18,69,21,16,15,61,55,38,32,74,69,68,50,44,63,58,57,29,23,49,43,5,103,81,75,20,14,0,98,9,3,94,89,88,83,77,101,95,19,13,5,103,16,10,30,24,89,83,15,10,9,78,72,58,52,92,91,6,5,70,89,88,74,92,72,71,90,89,7,25,88,2,20,21,20,39,38,100,14,10,9,28,27,79,98,97,99,13,55,74,73,27,45,70,88,50,69,68,59,77,41,40,59,58,29,48,47,47,65,69,88,87,55,73,66,85,84,80,98,35,53,66,65,84,83,24,43,42,4,22,30,76,75,73,72,54,52,51,58,55,56,55,53,52,95,92,72,69,56,5,4,2,1,84,81,98,97,95,94,63,61,60,83,80,39,37,36,11,8,54,51,34,32,31,43,40,96,25,24,22,21,13,11,10,31,28,53,51,50,39,36,50,48,47,64,61,19,16,50,49,47,46,8,6,5,92,89,24,98,35,89,68,72,5,69,5,86,19,18,98,7,77,97,53,25,68,48,57,38,27,45,67,53,64,78,33,63,22,2,48,47,26,30,28,27,67,44,91,81,80,56,70,69,35,55,11,87,26,34,6,15,101,100,89,3,25,11,22,36,95,22,21,84,64,60,39,43,9,40,80,58,57,93,70,69,82,48,68,24,100,40,39,19,29,28,9,102,17,16,38,25,24,35,49,5,4,17,34,97,78,77,97,21,51,65,12,8,56,87,92,89,87,86,94,66,65,73,69,77,67,66,74,2,10,83,92,91,16,15,23,95,0,103,59,5,4,12,75,74,82,94,102,51,50,58,22,30,65,74,73,46,45,53,54,63,62,36,35,43,25,24,32,42,51,50,65,64,72,50,59,58,67,62,61,69,75,83,30,39,38,61,60,68,20,19,27,103,8,7,63,88,13,81,45,49,26,69,16,49,5,18,101,1,102,38,16,15,10,51,28,27,40,6,26,86,58,102,101,81,91,90,71,60,79,78,100,87,86,97,7,67,66,96,55,36,35,97,96,76,75,79,5,77,76,12,93,26,25,1,15,14,85,84,0,61,60,32,75,56,55,64,103,46,45,35,34,52,75,74,60,72,71,85,40,71,70,30,29,9,8,91,95,92,28,5,41,17,58,30,100,16,76,48,91,71,80,61,50,68,90,76,68,87,101,56,86,45,25,21,20,22,0,103,1,3,5,92,1,0,2,40,42,17,20,19,54,53,55,29,32,31,43,42,44,9,8,10,28,30,89,88,90,60,62,103,2,1,84,83,85,92,95,94,74,73,75,63,62,64,80,83,82,103,102,0,88,91,90,100,99,101,9,11,68,71,70,99,98,100,58,57,59,37,40,39,11,10,93,97,95,94,30,7,52,44,43,19,33,32,102,18,78,50,93,73,82,62,64,63,52,70,92,78,89,103,58,89,88,47,27,92,62,74,10,22,93,1,97,5,94,2,30,42,7,20,19,43,55,19,32,31,32,44,102,10,18,30,78,90,50,62,93,2,1,73,85,82,95,94,63,75,52,64,70,83,82,92,0,78,91,90,89,101,103,11,58,71,70,88,100,47,59,27,40,39,21,20,103,3,1,0,40,17,52,54,53,29,43,42,8,28,88,60,103,83,92,68,74,73,62,80,102,88,99,9,68,99,98,57,37,3,2,86,85,89,76,87,86,22,103,36,35,11,25,24,95,94,10,71,70,42,85,66,65,74,56,55,45,44,62,85,84,70,52,82,81,95,50,81,80,40,39,19,96,8,75,91,79,95,76,92,12,28,93,6,5,25,41,1,18,17,88,14,30,84,100,0,16,60,76,32,48,75,92,91,55,71,64,81,80,45,61,34,50,52,69,68,74,90,60,77,76,71,87,85,101,40,57,56,70,86,29,45,9,26,25,101,100,79,83,81,80,16,97,86,30,29,5,19,18,88,4,64,36,79,59,68,92,50,49,38,56,78,64,75,89,44,75,74,33,13};
static const short Gen_shift_values_BG2_Z_112[1483]= {71,52,39,109,18,72,22,5,68,43,45,2,78,35,43,11,94,2,11,87,109,28,90,43,7,30,20,71,72,53,40,109,110,19,73,22,23,6,68,69,44,46,3,79,36,44,12,94,95,3,12,88,110,29,91,44,7,8,31,21,71,72,52,53,40,109,110,19,73,22,23,6,68,69,43,44,46,2,3,79,36,43,44,12,94,95,2,3,12,87,88,110,28,29,91,44,7,8,30,31,21,72,53,40,110,19,72,73,23,5,6,69,44,46,3,79,35,36,44,11,12,95,3,11,12,88,109,110,29,91,43,44,8,31,20,21,60,61,42,29,87,98,99,8,62,15,11,12,107,57,58,33,35,104,68,25,33,1,83,84,104,1,77,99,18,80,33,108,109,20,10,40,41,22,9,72,78,79,100,42,25,103,104,87,37,38,13,15,84,48,5,13,93,57,63,64,84,93,57,79,106,110,60,13,88,89,0,102,56,57,38,25,10,94,95,4,58,7,8,103,53,54,29,31,100,64,21,29,109,54,79,80,100,109,73,95,30,14,76,29,104,105,16,6,109,109,110,29,91,10,78,109,35,36,67,57,88,111,29,30,102,60,61,92,44,74,75,106,107,26,82,1,84,3,41,72,5,36,74,104,105,82,1,50,80,81,12,20,21,52,41,72,50,80,81,14,45,36,66,67,104,67,98,17,48,82,0,1,45,46,77,69,100,59,89,90,111,0,92,93,80,34,37,38,59,1,42,62,63,46,108,109,83,84,86,42,43,7,76,83,84,52,22,23,42,43,52,15,16,38,68,69,19,84,47,48,70,71,61,31,42,43,12,24,111,11,69,80,81,90,102,32,44,1,94,105,106,77,89,28,39,40,3,15,5,17,74,86,38,50,107,7,3,15,83,95,54,65,66,74,86,83,95,47,59,69,81,100,0,50,62,3,15,29,79,90,91,102,2,92,104,61,37,7,55,59,40,27,98,97,6,59,60,10,104,105,56,31,33,102,66,22,23,31,110,111,82,102,110,111,75,96,97,25,16,78,30,31,107,18,7,8,109,68,69,50,37,106,107,16,70,45,19,20,3,65,66,41,43,104,0,76,33,41,9,91,92,0,9,85,107,26,88,41,4,5,28,18,100,81,68,36,26,47,100,101,0,51,33,34,97,72,74,31,107,63,64,72,39,40,11,31,39,40,4,25,26,57,7,71,72,30,36,59,48,49,111,0,76,93,57,80,44,37,38,2,59,23,1,76,77,35,62,63,27,46,9,10,108,109,73,84,48,86,50,43,7,7,83,76,39,40,84,48,52,15,16,22,23,99,43,7,52,15,16,94,16,92,38,1,2,69,33,19,95,84,47,48,47,48,12,71,35,61,24,25,47,69,70,28,51,15,38,3,85,107,108,106,17,48,71,110,20,21,93,4,44,66,67,19,42,21,44,90,1,54,77,11,34,19,42,99,10,70,92,93,90,1,99,10,63,86,85,108,4,27,66,89,19,42,95,5,6,6,29,108,19,93,94,56,57,75,37,38,62,25,19,20,94,95,41,4,95,58,74,44,45,7,8,28,103,90,91,53,54,66,28,29,68,31,25,99,100,101,64,58,21,66,28,29,34,109,4,5,79,80,25,99,100,34,109,110,72,73,20,95,51,13,14,1,76,66,29,29,30,104,105,53,15,16,43,6,45,53,54,73,74,35,54,55,22,42,91,92,111,0,1,21,55,75,47,4,5,24,25,100,8,50,51,70,71,26,45,46,28,48,97,4,5,61,81,18,38,26,45,46,106,14,19,76,77,96,97,97,4,5,106,14,70,89,90,92,0,11,30,31,73,93,26,46,101,102,9,10,13,32,33,3,23,67,15,43,45,26,13,34,83,104,46,25,108,91,42,17,19,88,52,9,17,97,68,88,97,61,83,2,64,17,93,4,106,100,101,82,69,26,27,48,102,5,51,52,35,97,98,73,75,32,108,65,19,73,41,11,12,32,41,5,27,58,8,73,36,37,60,50,41,22,9,79,79,100,41,42,104,86,87,38,13,15,84,48,4,5,13,92,93,64,84,92,93,57,78,79,110,60,12,13,42,89,0,101,102,48,0,43,53,21,40,87,62,98,93,68,69,78,49,50,59,37,46,106,107,4,16,25,70,78,79,19,20,29,3,11,12,89,65,66,75,40,41,50,43,52,111,0,9,76,85,33,41,42,40,41,50,9,17,18,91,92,101,111,0,9,9,17,18,84,85,94,107,3,4,5,25,26,35,88,97,41,49,50,4,5,14,27,28,37,18,26,27,26,5,103,99,80,107,60,105,43,72,63,30,11,110,68,89,30,31,34,93,75,76,27,2,4,73,37,105,106,2,81,82,53,73,81,82,46,67,68,99,49,1,2,78,101,90,91,69,70,50,51,38,107,107,108,17,71,20,21,4,66,67,41,42,44,0,1,77,34,41,42,10,20,92,93,0,1,10,85,86,108,26,27,89,42,5,6,28,29,19,68,49,36,106,15,69,19,2,70,65,40,42,111,75,32,40,8,91,111,8,84,106,11,25,87,40,4,27,17,48,49,29,29,30,10,17,109,28,86,87,67,108,88,50,29,30,111,0,92,95,74,75,45,46,26,20,21,1,23,3,91,92,72,56,36,13,104,105,20,21,1,101,80,81,71,72,52,91,92,72,101,80,81,64,65,45,87,66,67,5,6,98,68,48,21,0,1,96,97,77,7,8,100,110,89,90,14,15,108,95,52,53,74,16,90,77,78,61,11,12,99,101,58,22,91,99,67,52,37,38,58,67,31,53,84,34,99,62,63,86,76,0,62,82,111,84,92,65,79,52,37,10,58,31,0,84,85,62,35,45,17,18,108,81,83,56,85,58,42,15,6,91,75,47,48,83,56,51,23,24,22,107,42,15,51,23,24,15,100,37,9,10,68,41,18,103,83,55,56,47,20,70,43,60,32,33,5,6,99,86,43,44,65,7,36,68,69,52,2,3,90,92,49,13,82,90,58,96,28,29,49,58,22,44,75,25,90,53,54,77,67,1,2,94,95,82,105,39,40,61,3,64,65,48,110,111,85,86,88,44,45,9,78,85,86,54,24,25,44,45,54,17,18,40,68,70,71,21,86,49,50,72,73,63,106,108,87,89,74,76,32,34,53,55,107,108,109,57,59,40,41,42,97,103,105,78,80,80,82,37,39,1,3,70,71,72,78,80,46,47,48,17,19,37,39,46,47,48,10,12,32,33,34,63,65,13,15,78,79,80,42,44,65,67,55,56,57,40,41,22,9,78,79,100,42,7,103,104,87,37,38,13,15,84,48,5,13,93,100,63,64,84,93,57,79,110,60,13,88,89,0,102};
static const short Gen_shift_values_BG2_Z_120[1483]= {24,21,73,10,30,118,70,50,20,53,2,62,52,94,26,109,22,95,38,22,78,8,34,42,111,46,74,24,25,22,74,10,11,31,119,70,71,51,20,21,54,3,63,53,95,27,110,22,23,96,39,23,79,9,35,43,111,112,47,75,24,25,21,22,74,10,11,31,119,70,71,51,20,21,53,54,3,62,63,53,95,26,27,110,22,23,95,96,39,22,23,79,8,9,35,43,111,112,46,47,75,25,22,74,11,31,118,119,71,50,51,21,54,3,63,53,94,95,27,109,110,23,96,38,39,23,78,79,9,35,42,43,112,47,74,75,84,85,82,14,28,70,71,91,59,19,10,11,111,80,81,114,63,3,113,35,87,50,82,83,36,99,83,19,69,95,103,51,52,107,15,111,112,109,41,0,97,98,118,86,40,37,38,18,107,108,21,90,30,20,62,114,77,48,109,110,63,6,110,46,87,96,2,10,78,79,14,42,80,81,78,10,16,66,67,87,55,6,7,107,76,77,110,59,119,109,31,83,46,71,78,79,32,95,79,15,51,65,91,99,47,48,103,11,3,76,77,59,74,56,6,108,62,63,45,83,65,51,32,33,85,2,3,105,103,84,85,72,73,55,106,88,55,37,115,97,105,87,27,8,9,79,61,42,23,24,65,74,75,57,28,10,91,72,73,75,57,11,112,113,86,61,43,87,69,95,76,77,43,44,26,99,81,7,108,109,9,10,6,7,59,55,115,116,16,104,48,55,56,36,5,6,38,39,108,47,48,38,80,11,12,95,7,8,80,81,24,7,8,64,113,114,20,28,96,97,31,32,60,72,92,93,69,90,1,22,58,78,79,78,99,46,67,46,118,18,19,98,119,68,88,89,101,2,50,71,110,11,100,1,22,43,74,95,37,58,70,90,91,23,44,86,107,70,91,6,27,56,77,82,103,90,111,117,39,59,60,94,115,2,23,37,96,87,111,76,73,5,57,62,82,49,50,2,101,102,72,105,54,114,104,25,26,78,40,41,74,27,89,90,74,9,10,93,60,86,93,94,43,98,5,6,47,96,97,94,26,82,83,103,71,3,22,23,3,92,93,6,75,1,15,5,47,99,62,94,95,48,111,95,31,81,107,115,63,64,119,27,4,1,53,47,110,10,97,98,56,50,29,30,0,33,102,42,32,73,74,6,88,89,2,75,17,18,2,57,58,108,14,21,22,46,91,26,53,54,108,109,67,106,64,38,116,94,95,53,115,73,83,40,41,81,34,35,113,15,92,93,104,105,63,18,96,87,45,27,105,17,95,59,16,17,111,69,74,31,32,106,107,65,60,18,3,80,81,111,107,65,43,0,1,93,51,119,77,7,84,85,75,76,34,11,89,39,116,117,1,61,62,118,59,50,111,37,107,47,48,7,68,95,36,47,107,108,27,88,117,57,58,30,91,99,40,39,100,29,90,71,12,3,64,86,27,119,59,60,72,13,15,76,119,60,55,116,105,46,11,72,19,80,88,28,29,23,84,51,112,79,80,106,107,77,103,104,9,36,65,66,92,93,86,113,54,81,49,5,6,32,33,106,13,75,76,102,103,109,15,16,58,85,118,24,25,108,15,30,57,82,108,109,45,72,77,78,104,105,31,57,58,94,1,78,104,105,14,41,64,90,91,90,117,98,5,46,47,73,74,102,8,9,10,37,22,99,100,2,3,97,119,0,29,52,85,86,108,109,106,9,74,97,75,25,26,48,49,6,29,95,96,118,119,9,31,32,78,101,18,40,41,8,31,50,73,102,4,5,65,88,52,97,98,0,1,51,73,74,114,17,98,0,1,34,57,84,106,107,110,13,118,21,66,67,89,90,2,24,25,30,53,7,90,89,112,109,41,38,98,118,86,83,38,18,108,21,90,30,20,62,114,77,110,63,6,110,46,96,2,10,79,14,42,30,31,28,80,16,17,37,5,116,76,77,57,26,27,60,9,69,59,101,106,33,116,28,29,102,45,29,85,15,41,49,117,118,53,81,36,33,85,117,22,42,9,10,82,61,62,32,65,14,74,64,105,106,38,0,1,34,107,49,50,34,89,90,20,46,53,54,12,3,58,85,86,74,43,4,93,110,80,18,9,65,94,94,95,111,91,92,108,24,40,80,81,97,101,117,69,84,85,20,21,37,1,16,17,25,90,91,107,3,4,20,73,89,12,13,29,3,19,45,60,61,96,97,113,60,75,76,92,93,109,45,46,62,109,4,5,92,93,109,29,44,45,65,78,79,95,105,1,113,8,9,61,62,78,116,117,13,25,40,41,63,60,6,23,15,24,56,36,18,100,16,71,68,0,57,77,44,45,80,117,96,97,67,100,49,109,99,20,21,73,35,36,69,22,84,85,69,4,5,55,81,88,89,38,93,0,1,20,21,17,18,70,58,6,7,27,115,66,67,47,16,17,49,50,119,58,59,49,91,22,23,106,13,18,19,91,92,35,18,19,75,4,5,31,39,107,108,42,43,71,10,7,59,116,16,104,56,36,45,6,39,108,48,38,80,12,95,8,81,24,8,64,1,114,20,28,97,32,60,39,40,46,36,37,43,89,95,63,25,26,32,46,52,14,19,20,85,86,92,66,71,72,35,36,42,68,69,75,18,24,77,78,84,68,74,110,115,116,41,42,48,5,10,11,37,38,44,110,111,117,54,59,60,37,38,44,94,99,100,23,24,30,50,56,58,63,64,6,7,13,61,62,68,90,95,96,79,80,77,9,65,66,86,54,84,5,6,106,75,76,109,58,118,108,30,82,45,104,77,78,31,94,78,14,64,90,98,46,47,102,10,57,111,105,58,19,55,16,107,68,44,5,64,25,32,112,113,104,65,84,44,45,54,15,87,48,36,117,96,57,86,47,8,88,89,60,21,23,103,104,56,17,9,90,72,32,33,56,17,112,72,73,42,3,68,29,76,36,37,25,106,80,41,108,68,69,9,10,7,59,115,116,16,104,41,55,56,36,5,6,39,108,48,38,80,12,95,40,7,8,81,24,8,64,114,20,28,96,97,32,60,93,94,90,91,23,46,79,80,100,68,19,20,0,89,90,2,3,72,11,12,2,44,95,96,59,91,92,44,45,108,91,92,28,44,77,78,104,112,60,61,115,116,24,91,85,88,82,20,14,77,71,97,91,65,58,59,17,11,117,110,111,77,87,81,0,114,69,63,9,3,119,113,41,34,35,93,87,56,49,50,89,83,42,36,105,98,99,89,83,25,18,19,75,69,101,95,109,102,103,58,52,113,107,21,14,15,14,15,12,64,0,1,21,109,52,60,61,41,10,11,44,113,53,43,85,17,100,94,12,13,86,29,13,69,119,25,33,101,102,37,65};
static const short Gen_shift_values_BG2_Z_128[1483]= {7,37,79,115,112,6,74,56,24,36,42,123,50,28,123,102,59,96,79,26,52,94,110,16,75,122,126,8,7,37,79,116,115,112,6,75,74,56,25,24,36,42,123,50,28,123,102,60,59,96,79,26,52,94,110,16,76,75,122,126,8,7,38,37,79,116,115,112,6,75,74,56,25,24,37,36,42,124,123,50,28,124,123,102,60,59,97,96,79,27,26,52,95,94,110,16,76,75,123,122,126,7,37,79,115,112,7,6,74,57,56,24,36,42,123,50,29,28,123,103,102,59,96,80,79,26,53,52,94,110,17,16,75,122,127,126,79,78,108,22,50,59,58,55,77,85,18,17,127,96,95,107,113,66,121,99,66,45,3,2,39,22,97,123,37,53,87,19,18,65,69,111,110,12,54,102,91,90,87,109,40,50,49,31,0,127,11,17,98,25,3,98,77,65,35,34,71,54,1,27,30,69,85,119,51,50,97,101,38,37,67,109,26,18,17,14,36,105,104,86,55,54,66,72,25,80,58,25,4,99,90,89,126,109,56,82,44,124,12,46,106,105,24,28,27,11,10,123,40,25,82,67,119,118,103,115,100,123,9,122,0,78,77,62,45,59,44,28,27,12,39,24,45,30,126,111,53,38,17,31,16,126,111,91,105,90,18,63,62,47,99,84,68,82,67,29,14,41,55,40,11,97,82,113,98,5,19,4,79,78,63,125,110,115,1,114,110,109,12,11,53,13,90,89,86,108,93,49,48,30,127,126,11,10,16,98,97,24,2,98,97,76,34,33,71,70,53,1,0,26,69,68,84,118,50,49,97,96,100,127,68,126,98,28,12,70,107,48,106,45,103,67,125,74,66,7,65,117,47,16,85,15,97,27,103,33,56,114,111,41,89,19,56,114,35,93,51,120,50,29,87,12,70,87,17,113,43,27,85,43,101,77,7,76,67,8,66,55,113,59,117,10,56,127,116,63,93,7,10,43,40,63,62,2,113,112,80,92,98,51,106,85,84,51,31,30,115,24,8,7,82,109,108,107,22,38,73,72,3,50,55,54,81,22,21,51,93,2,1,126,20,62,89,88,70,39,38,50,56,110,9,64,42,9,116,74,73,110,93,40,66,108,124,30,90,89,8,12,101,3,45,82,81,78,101,100,1,40,23,22,118,2,8,89,16,123,122,89,69,68,25,62,46,45,120,19,18,60,76,111,110,37,41,88,93,92,11,10,111,40,13,82,55,119,118,91,115,88,111,9,110,114,78,77,50,33,59,32,28,27,0,39,12,45,18,126,99,53,26,5,31,4,126,99,79,105,78,63,62,35,99,72,56,82,55,16,29,2,29,55,28,97,70,113,86,121,19,120,79,78,51,125,98,103,1,102,93,54,92,84,122,126,36,50,73,34,72,31,69,53,91,32,121,31,103,13,110,71,109,83,121,89,127,42,80,97,7,75,113,42,80,21,59,17,106,16,15,53,126,36,73,111,99,9,13,51,29,67,63,101,33,122,32,41,79,45,83,16,122,15,121,24,45,23,87,65,124,102,123,101,120,98,14,120,74,83,61,82,60,64,42,33,11,32,10,23,44,22,50,28,110,3,109,58,36,36,14,110,3,109,110,88,68,46,67,45,83,104,82,87,65,13,34,12,60,38,81,102,80,118,96,24,2,84,62,83,61,109,2,108,6,112,13,122,72,121,71,102,23,101,65,15,102,52,101,51,98,48,120,70,125,61,11,60,10,42,120,11,89,10,88,101,22,100,28,106,60,109,59,36,114,14,92,60,109,59,88,38,123,46,124,45,123,33,82,32,65,15,91,12,90,38,116,31,80,30,96,46,2,80,62,12,61,11,59,108,58,112,62,91,65,49,64,94,8,86,44,41,63,19,3,113,81,93,99,52,107,85,52,31,116,25,8,83,109,23,39,73,4,51,55,37,36,66,108,17,16,13,35,25,104,103,85,54,53,65,71,24,79,57,104,24,3,89,88,125,108,55,81,123,11,45,105,104,23,27,89,119,33,75,69,66,89,88,28,11,10,106,118,124,77,4,111,110,77,57,56,13,50,34,33,108,7,6,48,64,99,98,41,29,76,81,80,93,62,22,106,109,45,10,7,99,27,40,39,1,70,69,31,111,73,20,19,109,16,106,1,38,0,107,106,68,51,88,50,28,57,56,18,69,68,30,74,36,28,27,117,82,44,23,60,22,28,27,117,97,6,96,92,91,53,1,0,90,74,111,73,59,58,20,47,84,46,14,127,126,88,14,104,11,48,10,108,107,69,27,26,116,121,30,120,7,22,97,100,6,17,27,70,111,8,83,8,38,80,116,113,8,7,105,75,58,57,25,37,43,124,51,30,29,124,104,103,60,97,81,80,27,54,53,95,111,18,17,76,123,0,127,46,45,76,75,117,113,26,25,22,44,113,112,94,63,62,75,74,80,34,33,88,66,34,33,12,43,98,97,7,6,117,65,64,90,5,4,20,54,114,113,33,32,36,114,16,58,94,91,113,53,35,3,3,15,21,102,29,7,102,81,38,75,58,5,31,35,73,89,123,54,101,105,93,92,43,123,122,73,36,115,18,73,72,23,69,20,43,91,42,32,31,110,93,13,92,110,109,60,122,121,72,127,78,81,80,31,7,86,65,113,64,81,80,31,11,59,10,17,16,95,54,53,4,116,36,115,112,111,62,89,9,88,52,51,2,67,18,53,101,52,33,32,111,80,79,30,35,83,34,71,70,100,14,51,50,47,69,56,10,9,119,88,87,99,105,58,113,91,58,37,39,123,122,31,14,89,115,29,45,79,11,10,57,61,11,37,25,98,30,0,60,42,102,78,10,75,7,30,97,29,37,97,80,19,79,115,47,127,59,5,65,86,18,13,73,52,119,51,86,18,126,65,125,22,82,59,119,103,42,102,117,49,76,15,75,57,117,73,5,40,107,39,38,98,85,17,22,89,21,46,45,75,117,26,25,22,44,30,113,112,94,63,62,74,80,33,88,66,33,12,65,98,97,6,117,64,90,4,20,54,114,113,32,36,42,41,72,71,113,110,22,21,18,40,109,108,90,59,58,71,70,76,30,29,84,62,30,29,8,94,93,3,2,113,61,60,86,43,1,0,16,50,110,109,29,28,32,82,127,112,29,26,71,62,107,59,104,127,81,126,21,66,49,3,48,127,99,16,111,28,117,34,70,115,125,42,21,103,20,70,115,95,49,94,6,51,43,88,72,26,71,101,18,45,127,44,41,86,57,102,9,91,8,22,67,69,114,119,73,118,126,125,27,69,106,105,102,124,0,65,64,46,15,14,26,32,113,40,18,113,92,100,50,49,86,69,16,42,84,100,6,66,65,112,116};
static const short Gen_shift_values_BG2_Z_144[1483]= {1,17,93,24,104,118,51,119,33,92,90,102,108,20,64,2,113,82,71,96,47,67,109,126,125,48,77,2,1,17,93,25,24,104,118,52,51,119,34,33,92,90,102,108,20,64,2,114,113,82,71,96,47,67,109,126,126,125,48,77,2,1,18,17,93,25,24,104,118,52,51,119,34,33,93,92,90,103,102,108,20,65,64,2,114,113,83,82,71,97,96,47,68,67,109,126,126,125,49,48,77,1,17,93,24,104,119,118,51,120,119,33,92,90,102,108,21,20,64,3,2,113,82,72,71,96,48,47,67,109,127,126,125,48,78,77,53,52,68,0,41,76,75,11,25,23,103,102,26,85,84,143,141,9,15,71,115,53,21,20,133,122,3,98,118,16,33,33,32,99,128,73,72,88,20,39,96,95,31,45,139,123,122,46,105,104,19,17,29,35,91,135,73,83,41,40,9,142,23,118,136,138,36,53,53,52,119,4,141,140,12,88,108,20,19,99,113,47,46,114,29,28,87,85,97,103,15,59,141,86,109,108,77,66,91,42,106,62,104,121,121,120,43,72,132,110,109,66,125,82,57,14,133,132,89,68,25,82,40,39,96,16,15,116,83,41,40,142,141,98,56,13,54,11,66,23,72,29,128,86,85,28,129,110,68,67,134,78,77,34,46,3,35,137,136,60,17,11,113,112,34,31,132,73,30,90,48,47,90,89,46,12,113,41,143,142,90,89,106,105,37,69,113,112,48,62,68,140,139,63,122,121,37,36,34,47,46,52,108,9,8,90,58,57,27,26,15,41,40,135,12,11,53,70,70,69,137,136,21,25,51,50,41,66,117,142,48,74,73,128,9,142,23,96,75,101,100,143,24,57,83,82,116,141,114,139,126,7,132,13,44,69,88,113,26,51,137,19,18,106,131,95,120,120,1,71,96,91,116,133,14,6,31,39,5,31,30,72,97,101,126,45,40,100,95,65,81,13,27,88,24,39,38,115,40,39,97,12,10,22,28,85,84,128,67,66,33,2,136,135,16,112,111,29,131,29,47,46,45,112,142,141,115,133,132,4,80,12,11,91,105,32,39,38,106,21,20,79,77,121,89,95,7,51,133,101,100,69,58,83,34,54,96,113,113,112,35,64,48,64,140,75,71,7,22,21,36,98,23,22,80,139,137,5,11,68,67,111,50,49,16,129,119,118,143,95,94,114,12,30,29,61,28,95,125,124,132,131,98,3,114,79,46,11,10,121,90,57,104,72,71,142,38,37,4,105,73,72,20,19,130,78,45,76,43,88,55,94,61,6,118,117,50,17,132,100,99,100,99,66,68,35,57,25,24,50,82,49,33,1,0,53,20,95,62,112,80,79,112,111,78,34,1,63,31,30,97,130,129,113,1,45,77,138,120,9,8,56,88,70,102,3,36,35,71,103,129,18,17,44,76,42,74,54,86,60,92,116,4,16,48,98,130,65,98,97,34,66,23,55,48,80,143,31,19,51,61,93,78,110,77,110,109,0,32,29,61,30,29,10,9,45,26,25,121,101,53,52,33,32,132,112,2,126,47,80,79,60,59,3,127,62,61,42,41,120,101,100,118,98,130,111,110,136,116,48,28,92,73,72,30,10,142,141,122,121,110,91,90,99,79,124,105,104,75,55,95,76,75,137,117,10,134,10,9,134,133,76,57,56,105,85,8,67,66,44,43,82,60,59,14,135,90,89,67,66,25,2,39,16,119,117,116,94,93,40,17,99,98,76,75,13,135,134,11,132,23,1,0,29,6,85,62,129,107,106,67,44,42,35,34,12,11,3,125,124,136,113,17,139,138,112,89,132,110,109,30,7,47,24,47,46,24,23,113,91,90,142,119,16,105,141,42,58,134,78,65,1,15,27,92,16,74,133,131,143,5,61,105,43,10,123,112,137,88,108,6,23,22,89,118,80,79,95,27,103,102,38,52,1,130,129,53,112,111,26,24,36,42,98,102,142,80,48,47,16,5,30,125,1,43,60,60,59,126,11,82,98,30,90,105,41,56,55,132,57,56,114,29,27,39,45,102,101,1,84,83,50,19,9,8,33,129,128,4,46,64,63,74,62,129,15,14,53,131,67,114,55,29,41,100,127,62,102,101,134,118,117,6,49,82,125,124,13,60,93,74,108,107,8,7,40,75,109,108,141,134,133,22,49,48,81,46,79,59,58,91,64,97,120,10,9,21,20,53,102,136,135,70,69,102,39,38,71,27,61,60,53,52,85,3,37,36,27,24,23,56,65,98,82,116,115,82,81,114,5,4,37,33,67,66,12,9,105,76,42,132,24,86,55,103,69,140,12,88,19,99,114,113,79,46,115,114,28,87,85,97,103,16,15,59,142,141,108,77,67,66,91,43,42,62,104,122,121,120,43,73,72,73,72,89,88,20,31,96,95,31,45,123,122,46,105,104,20,19,17,30,29,35,91,136,135,73,88,41,40,10,9,142,24,23,118,139,138,36,53,53,52,120,119,4,3,19,95,26,106,120,53,121,134,35,94,92,104,110,22,66,4,115,84,73,98,49,5,69,111,128,127,50,79,27,26,115,43,42,131,118,63,36,50,49,138,129,74,143,89,88,77,76,21,0,90,89,59,58,3,118,117,62,115,60,128,127,72,133,78,45,135,134,90,89,34,27,117,116,139,138,83,108,107,52,96,42,41,122,121,66,72,18,17,93,92,37,134,79,7,97,96,7,6,95,74,73,18,102,48,47,95,94,110,42,118,117,53,67,59,1,0,68,127,126,41,39,51,57,113,13,95,136,63,62,31,20,45,140,16,58,75,75,74,141,26,120,128,25,98,57,114,73,46,5,121,80,57,16,71,31,30,4,107,72,32,31,130,89,45,4,43,2,55,14,61,20,117,77,76,17,120,99,59,58,66,25,35,138,24,128,127,49,8,0,104,103,20,123,62,21,79,39,38,78,37,1,104,30,134,133,3,2,18,94,26,25,105,119,0,53,52,120,35,34,93,91,103,109,21,65,3,69,115,114,83,72,97,48,68,110,127,127,126,49,78,0,143,16,15,91,118,23,22,102,116,50,49,117,32,31,91,90,88,101,100,106,18,63,62,0,112,111,81,80,69,95,94,45,31,66,65,107,124,124,123,47,46,75,74,103,90,119,22,51,97,126,33,62,47,77,76,124,9,48,78,77,5,106,135,21,50,19,48,31,60,37,66,93,123,122,137,22,75,105,104,42,71,11,40,0,30,29,25,54,120,6,5,140,25,38,67,55,85,84,54,83,121,6,6,36,35,21,20,36,112,44,43,123,137,47,71,70,138,53,52,111,109,121,127,39,83,21,46,133,132,101,90,115,66,86,128,1,1,0,67,96};
static const short Gen_shift_values_BG2_Z_160[1483]= {158,135,18,158,92,36,158,13,158,122,97,158,7,100,158,144,158,86,10,158,55,158,106,51,158,53,44,159,158,135,18,159,158,92,36,159,158,13,159,158,122,97,158,7,100,158,144,159,158,86,10,158,55,158,106,51,159,158,53,44,159,158,136,135,18,159,158,92,36,159,158,13,159,158,123,122,97,159,158,7,100,159,158,144,159,158,87,86,10,159,158,55,159,158,106,51,159,158,54,53,44,158,135,18,158,92,37,36,158,14,13,158,122,97,158,7,101,100,158,145,144,158,86,11,10,158,56,55,158,106,52,51,158,53,45,44,156,155,132,15,159,156,155,89,33,135,156,155,10,156,155,119,94,155,4,97,155,141,156,155,83,7,155,52,155,103,48,156,155,50,41,63,62,39,82,159,63,62,156,100,130,63,62,77,63,62,26,1,62,71,4,62,48,141,63,62,150,74,62,119,140,62,10,115,63,62,117,108,147,146,123,6,159,147,146,80,24,147,146,1,147,146,110,85,146,155,88,146,132,123,147,146,74,158,146,43,98,146,94,39,147,146,41,32,44,95,94,76,71,53,114,96,95,94,76,28,10,132,115,114,159,95,94,76,109,92,91,95,94,76,58,40,33,15,94,76,103,85,36,19,18,94,76,80,63,62,44,95,94,76,22,4,106,89,88,94,76,151,134,133,147,94,76,42,24,147,130,129,95,94,76,149,131,140,123,122,86,85,63,62,105,159,86,85,19,123,64,86,85,100,86,85,50,49,24,86,85,94,27,86,85,71,86,85,14,13,97,86,85,142,86,85,33,138,86,85,141,140,131,49,84,83,26,60,69,103,49,84,83,143,17,87,121,159,49,84,83,64,98,49,84,83,13,47,148,22,49,83,58,92,151,25,49,83,35,69,49,84,83,137,11,61,95,49,83,106,140,49,83,157,31,102,136,96,49,84,83,104,138,95,129,159,16,155,19,0,137,20,159,0,94,39,38,0,16,15,0,124,99,0,9,103,102,0,147,146,0,88,13,12,0,58,57,6,0,108,54,53,0,55,47,46,3,47,46,23,66,47,46,140,84,159,47,46,61,47,46,10,145,112,46,55,148,46,32,47,46,134,58,46,103,46,154,99,47,46,101,92,24,1,44,159,24,118,63,62,111,24,40,39,24,148,123,24,33,127,126,24,11,10,24,112,37,36,24,82,81,24,132,78,77,101,24,79,71,70,56,55,25,32,2,75,45,56,55,25,149,119,93,64,63,159,56,55,25,70,41,40,56,55,25,19,149,154,124,55,25,64,34,157,128,127,55,25,41,12,11,56,55,25,143,113,67,38,37,137,55,25,112,83,82,55,25,3,133,108,79,78,56,55,25,110,80,101,72,71,71,98,97,48,74,91,117,159,71,98,97,5,31,109,135,71,98,97,86,112,71,98,97,35,61,10,36,71,97,80,106,13,39,71,97,57,83,71,98,97,159,25,83,109,71,97,128,154,71,97,19,45,124,150,71,98,97,126,152,117,143,110,109,142,141,86,119,118,129,1,110,109,142,141,43,75,147,19,159,110,109,142,141,124,156,110,109,142,141,73,106,105,48,80,109,142,141,118,150,51,83,109,142,141,95,127,110,109,142,141,37,70,69,121,153,109,142,141,6,38,109,142,141,57,89,2,34,110,109,142,141,4,37,36,155,27,78,108,107,17,16,84,154,153,127,36,108,107,17,16,41,110,145,54,159,108,107,17,16,122,31,108,107,17,16,71,141,140,46,115,107,17,16,116,25,49,118,107,17,16,93,2,23,108,107,17,16,35,105,104,119,28,107,17,16,4,73,107,17,16,55,124,0,69,108,107,17,16,2,72,71,153,62,159,17,85,152,129,12,159,152,86,30,157,152,7,152,116,91,152,1,94,152,138,152,80,4,152,49,152,100,45,152,47,38,103,102,79,122,103,102,36,140,159,103,102,117,103,102,66,41,102,111,44,147,102,88,103,102,30,114,102,159,102,50,155,103,102,157,148,31,8,51,159,31,125,70,69,31,47,46,31,155,130,31,40,134,133,31,18,17,31,119,44,43,31,89,88,31,139,85,84,16,31,86,78,77,159,3,159,74,157,159,68,86,159,64,12,11,5,149,148,142,31,25,12,11,5,105,99,49,44,43,12,11,5,26,21,20,159,12,11,5,136,135,129,110,104,12,11,5,20,14,113,108,107,12,11,5,157,152,151,12,11,5,100,99,93,23,18,17,12,11,5,68,63,62,99,12,11,5,119,113,64,59,58,12,11,5,67,66,60,57,52,51,159,31,159,125,109,159,153,159,34,50,133,18,155,38,18,112,57,56,159,18,34,33,18,142,117,18,27,121,120,18,5,4,18,106,31,30,18,76,75,18,126,72,71,18,73,65,64,121,120,98,97,140,159,121,120,54,158,121,120,135,121,120,85,84,59,121,120,129,62,121,120,106,19,121,120,49,48,132,121,120,17,121,120,68,13,121,120,16,15,6,11,148,31,11,105,49,11,26,159,11,135,110,11,20,113,11,157,11,99,23,11,68,87,11,119,64,11,66,57,18,17,76,155,154,53,37,96,159,18,17,76,111,10,55,115,114,18,17,76,32,92,91,18,17,76,142,141,40,116,15,18,17,76,26,85,119,19,18,18,17,76,3,63,62,18,17,76,106,105,4,29,89,88,18,17,76,74,134,133,18,17,76,125,24,70,130,129,18,17,76,73,72,131,63,123,122,5,4,141,24,5,4,98,42,159,5,4,19,5,4,128,103,4,13,106,4,150,156,5,4,92,16,4,61,4,112,57,5,4,59,50,159,62,81,158,142,135,119,18,2,158,142,92,76,36,21,20,158,142,13,158,157,158,142,122,106,97,81,158,142,7,151,100,85,84,158,142,144,129,128,158,142,86,70,10,155,154,158,142,55,40,39,158,142,106,90,51,36,35,158,142,53,37,44,29,28,18,17,154,37,18,17,111,55,159,18,17,32,18,17,141,116,17,26,119,17,3,92,18,17,105,29,17,74,17,125,70,18,17,72,63,137,136,114,113,156,159,137,136,70,14,137,136,151,137,136,101,100,75,137,136,145,78,137,136,122,137,136,65,64,148,137,136,33,23,137,136,84,29,137,136,32,31,22,34,141,11,118,54,1,34,141,128,75,72,20,19,34,141,49,157,156,159,34,141,158,105,133,80,34,141,43,150,136,84,83,34,141,20,128,127,34,141,122,69,46,154,153,34,141,91,39,38,34,141,142,89,87,35,34,34,141,89,36,80,28,27,54,53,30,73,54,53,147,91,159,54,53,68,54,53,17,152,53,62,155,53,39,1,54,53,141,65,53,110,53,1,106,54,53,108,99};
static const short Gen_shift_values_BG2_Z_176[1483]= {154,15,96,141,166,51,12,172,1,63,105,61,80,172,175,125,38,53,15,35,87,169,140,15,121,131,103,155,154,15,96,142,141,166,51,13,12,172,2,1,63,105,61,80,172,175,125,39,38,53,15,35,87,169,140,15,122,121,131,103,155,154,16,15,96,142,141,166,51,13,12,172,2,1,64,63,105,62,61,80,172,0,175,125,39,38,54,53,15,36,35,87,170,169,140,15,122,121,132,131,103,154,15,96,141,166,52,51,12,173,172,1,63,105,61,80,173,172,175,126,125,38,53,16,15,35,88,87,169,140,16,15,121,131,104,103,62,61,98,3,85,49,48,73,134,66,96,95,79,85,84,146,12,144,163,79,82,32,122,121,136,98,118,170,76,47,98,29,28,38,10,39,38,75,156,78,26,25,50,111,83,73,72,56,62,61,123,165,121,140,56,59,9,34,99,98,113,75,95,147,102,53,24,75,6,5,15,163,8,7,44,125,46,171,170,19,80,42,41,25,31,30,92,134,90,109,25,28,154,153,68,67,82,44,64,116,9,22,169,44,151,150,160,132,154,26,25,33,62,70,143,151,13,12,20,37,45,98,107,106,47,60,59,67,43,52,51,49,48,56,110,118,152,160,108,116,127,135,43,52,51,46,54,172,5,4,124,86,85,93,100,108,62,71,70,82,90,134,143,142,23,40,48,11,19,62,71,70,169,168,0,2,10,150,159,158,140,139,1,0,81,52,127,126,151,36,30,174,173,157,163,162,49,48,90,47,46,65,157,161,160,110,24,23,39,38,0,21,20,72,155,154,125,0,107,106,117,116,88,77,43,42,114,79,19,160,64,30,29,89,54,150,115,103,111,77,76,95,60,100,66,65,162,127,28,169,160,125,3,144,95,60,98,63,48,13,137,103,102,152,117,114,79,134,99,10,151,92,57,63,28,114,79,141,44,10,9,54,19,26,167,110,24,173,22,119,156,61,90,106,131,17,16,153,138,137,142,28,70,26,45,138,137,140,91,90,3,18,157,156,0,53,52,174,134,105,157,156,86,96,69,68,23,159,158,19,100,146,145,170,55,121,17,16,0,6,5,67,109,10,65,84,0,3,129,43,42,57,19,39,91,173,144,19,126,125,135,107,105,142,47,28,92,117,3,2,90,139,124,123,128,14,56,12,31,124,123,126,77,76,165,4,143,142,162,39,38,120,91,143,142,26,72,82,55,54,163,162,144,23,5,104,86,150,149,131,174,156,59,42,41,10,21,20,2,4,163,162,10,9,167,71,53,113,95,69,51,88,70,4,163,162,7,165,133,116,115,47,46,28,61,43,23,6,5,144,43,25,95,78,77,1,159,148,130,23,6,5,130,129,111,139,121,111,94,93,81,19,18,118,55,23,136,136,68,6,5,93,30,154,91,115,53,52,99,36,104,42,41,166,103,32,145,164,101,7,120,99,36,102,39,52,165,141,79,78,156,93,118,55,138,75,14,127,96,33,67,4,118,55,48,162,161,58,171,30,143,172,171,144,143,32,5,4,113,85,159,158,131,130,7,155,68,40,77,30,29,2,1,13,161,19,18,167,166,80,53,52,122,94,78,51,50,97,69,13,161,16,165,164,142,114,56,55,28,27,70,43,42,32,4,52,25,24,104,76,10,159,158,157,129,32,4,139,138,111,110,148,121,120,120,92,157,41,40,142,141,77,3,2,158,83,28,27,129,128,52,153,113,38,133,75,74,0,175,58,159,64,63,165,164,125,51,50,167,92,123,49,48,142,67,58,159,61,163,162,11,112,22,101,100,26,25,115,41,40,77,2,97,23,22,149,74,55,157,156,26,127,77,2,8,7,109,108,17,119,118,165,90,172,30,21,123,160,65,12,110,135,20,134,157,141,146,32,74,30,49,141,144,94,7,22,160,4,56,138,109,160,90,100,72,152,151,12,93,139,138,163,48,127,10,9,169,175,174,60,102,58,77,169,51,172,122,36,35,50,12,32,84,166,137,12,119,118,128,100,18,55,136,155,5,30,92,91,52,37,36,41,103,145,101,120,37,36,39,166,165,78,93,56,55,75,128,127,33,4,56,55,165,161,171,144,143,17,162,109,131,149,112,107,60,71,135,32,31,123,69,68,160,149,65,19,18,110,43,135,104,21,20,66,65,157,49,142,141,35,55,54,146,117,116,32,158,74,115,114,30,133,49,49,142,141,53,52,144,2,95,94,92,91,7,107,106,22,68,161,160,89,88,4,140,57,56,37,47,46,138,17,109,68,161,160,175,174,90,9,8,100,156,73,72,41,103,63,23,148,138,160,83,172,92,28,126,163,68,113,138,24,23,116,160,145,144,149,35,77,33,52,145,144,147,98,97,10,25,164,163,7,60,59,141,112,164,163,93,103,76,75,121,120,158,157,62,115,108,107,132,17,155,154,138,144,143,30,29,71,28,27,46,138,142,141,91,72,5,4,20,19,157,2,1,53,136,135,106,157,88,87,98,97,69,7,44,125,170,19,80,41,25,104,30,92,134,90,109,25,28,154,67,82,44,64,116,136,22,169,44,150,160,132,20,19,140,57,56,1,137,82,10,7,6,127,31,152,92,38,37,54,53,174,37,159,158,43,42,163,105,104,49,146,91,103,102,47,121,66,37,159,158,41,40,161,166,112,111,80,79,24,95,94,39,56,2,1,77,76,21,128,74,73,35,34,155,5,126,56,2,1,163,162,107,173,172,117,144,90,89,151,150,11,92,138,137,162,47,125,9,8,168,174,173,59,101,57,76,168,171,121,151,35,34,49,11,31,83,165,136,11,118,117,127,99,72,153,128,145,16,6,53,87,134,132,3,157,28,42,90,89,3,50,163,35,34,168,39,54,101,96,143,52,99,71,118,163,35,34,166,37,116,164,163,29,76,44,91,6,54,53,26,73,78,126,125,160,31,131,2,6,54,53,112,159,122,169,94,142,141,174,173,34,115,161,160,9,70,111,32,31,15,21,20,82,124,80,99,15,18,144,6,58,57,72,34,54,106,12,159,34,141,140,150,122,84,83,121,120,25,108,71,70,95,156,118,117,101,107,106,169,168,34,167,166,9,101,105,104,54,144,143,159,158,120,141,140,16,5,99,98,69,120,51,50,61,60,32,134,60,171,97,76,2,121,47,146,72,31,134,133,168,94,152,79,78,159,157,83,43,145,85,11,41,143,60,162,152,79,78,155,81,105,32,31,18,120,33,135,171,98,97,15,117,67,170,169,149,75,120,46,171,98,97,101,27,111,37,83,10,9,163,162,23,104,150,149,174,59,131,21,20,4,10,9,71,113,69,88,4,7,133,5,47,46,61,23,43,95,1,148,23,130,129,139,111};
static const short Gen_shift_values_BG2_Z_192[1483]= {172,25,23,95,112,134,164,173,64,34,115,46,108,111,90,70,69,29,121,185,116,183,112,26,170,1,184,173,172,25,23,96,95,112,134,165,164,173,65,64,34,115,46,108,111,90,70,70,69,29,121,185,116,183,112,26,171,170,1,184,173,172,26,25,23,96,95,112,134,165,164,173,65,64,35,34,115,47,46,108,111,91,90,70,70,69,30,29,121,186,185,116,184,183,112,26,171,170,2,1,184,172,25,23,95,112,135,134,164,174,173,64,34,115,46,108,112,111,90,71,70,69,29,122,121,185,117,116,183,112,27,26,170,1,185,184,10,9,54,52,71,125,124,141,163,73,2,1,10,94,93,63,144,75,137,140,119,99,99,98,58,150,22,145,20,141,55,8,7,30,21,29,28,73,71,9,144,143,160,182,43,21,20,29,113,112,82,163,94,156,159,138,118,120,118,117,77,169,41,164,79,39,160,74,27,26,49,40,165,164,17,15,128,88,87,104,126,157,156,165,57,56,26,107,38,100,103,82,62,91,62,61,21,113,177,108,99,175,104,18,163,162,185,176,48,83,82,123,127,168,125,166,6,5,46,22,63,44,86,85,79,75,74,115,83,125,124,167,166,15,136,177,25,66,148,189,18,59,21,63,62,0,41,172,22,21,185,172,171,20,131,172,31,73,72,95,136,26,68,67,15,93,134,22,63,128,170,169,81,80,121,103,144,94,136,135,133,132,178,177,175,117,56,55,72,94,69,125,124,133,25,24,187,186,75,7,6,68,71,51,50,30,30,29,182,181,81,146,145,76,144,143,72,178,131,130,154,153,144,165,159,158,18,11,16,9,88,82,81,105,98,127,120,27,157,151,150,166,159,57,51,50,27,20,108,101,39,32,101,94,104,97,83,76,63,56,62,56,55,22,15,114,107,178,171,109,102,176,169,105,98,19,12,131,163,157,156,186,179,177,170,58,103,21,51,134,179,177,31,57,74,97,96,126,136,135,26,188,77,8,70,74,73,52,33,32,31,183,84,83,147,79,78,91,145,74,181,180,132,155,147,146,173,184,183,36,34,107,106,123,145,38,176,175,184,76,75,45,126,92,57,119,122,101,81,81,80,40,132,4,127,2,123,37,182,181,12,3,146,191,189,48,69,86,109,108,124,138,148,147,38,8,89,20,82,86,85,64,45,44,43,3,96,95,159,91,90,157,86,1,0,34,144,167,159,158,2,1,143,46,188,44,186,117,116,66,133,83,155,106,105,18,186,185,135,2,145,144,86,85,35,55,5,136,86,67,17,129,79,132,83,82,111,61,91,42,41,91,90,40,50,0,142,93,92,117,14,156,137,88,87,12,154,133,83,47,190,189,0,191,141,22,164,13,156,155,43,62,61,88,106,86,104,67,158,177,176,175,1,5,23,35,54,53,44,62,127,146,145,97,115,178,4,109,127,171,189,174,0,153,171,133,151,132,151,150,92,110,184,10,56,74,179,5,54,72,175,1,89,107,41,60,59,64,82,55,73,116,115,45,44,160,90,89,158,87,39,38,160,159,55,176,77,6,86,108,107,37,36,116,45,8,7,129,128,169,99,98,58,179,181,111,110,51,172,54,175,33,155,154,13,134,13,12,134,133,164,94,93,64,185,128,58,57,59,180,126,56,55,55,176,161,90,114,113,43,42,136,66,65,127,56,176,182,181,179,178,34,32,31,32,29,105,104,102,101,121,118,143,140,157,174,173,171,170,182,179,74,73,71,70,43,41,40,124,121,55,53,52,117,114,120,117,99,97,96,79,76,22,79,78,76,75,38,36,35,130,127,2,0,191,125,122,0,190,189,121,118,35,32,180,179,177,176,10,8,7,1,190,185,5,45,136,181,179,57,59,76,98,41,128,137,28,190,79,10,72,75,54,34,33,185,85,149,80,147,76,182,134,157,148,134,133,178,176,57,56,73,95,75,126,125,134,26,25,187,76,7,69,72,60,51,31,31,30,182,82,146,77,144,73,179,132,131,154,145,47,92,90,156,162,179,10,9,39,49,48,131,101,182,113,175,179,178,157,138,137,136,96,189,188,60,184,183,58,179,94,93,174,45,68,60,59,19,51,105,85,94,181,152,63,44,20,36,35,65,81,80,110,78,108,151,150,180,167,5,189,28,27,28,27,57,36,67,66,66,120,119,149,90,89,119,170,8,102,101,131,163,1,166,5,4,146,145,175,125,156,155,125,124,154,85,84,114,176,15,14,49,48,78,171,10,9,136,47,46,76,167,5,81,112,111,34,33,63,57,56,86,47,78,77,102,49,69,110,167,109,16,119,153,51,55,150,3,1,73,90,113,112,2,142,152,151,42,12,93,24,86,90,89,68,49,48,47,7,100,99,163,95,94,161,90,5,4,148,171,163,162,190,189,43,42,40,83,113,112,129,151,182,181,190,82,81,52,51,132,64,63,125,128,108,107,87,7,87,86,47,46,138,11,10,133,9,8,129,43,188,187,19,18,9,104,149,147,27,44,66,96,105,164,188,158,47,170,40,43,22,2,1,153,53,117,48,178,115,44,150,102,125,116,158,157,184,11,10,37,8,35,172,81,80,107,97,124,119,147,146,150,149,176,158,186,185,50,49,76,20,19,46,100,127,32,31,58,93,120,96,124,123,76,75,102,55,83,82,55,54,81,15,14,41,106,134,133,171,170,5,101,129,128,169,168,3,97,124,11,39,38,156,155,182,179,178,13,169,5,4,191,190,43,41,114,113,130,152,76,183,182,191,83,82,52,133,64,126,129,108,88,183,88,87,47,139,11,134,9,130,44,189,188,19,10,24,150,169,17,11,62,56,60,54,132,126,149,143,171,166,165,9,3,18,13,12,101,95,71,65,152,146,83,77,145,139,148,143,142,127,121,107,102,101,106,100,66,60,158,153,152,30,24,153,148,147,28,22,149,143,63,58,57,15,9,38,32,29,24,23,171,170,23,21,94,93,110,132,83,163,162,171,63,62,32,113,44,106,109,88,68,150,68,67,27,119,183,114,181,110,24,169,168,191,182,38,37,83,82,80,92,153,152,169,191,30,29,38,122,121,92,91,172,104,103,165,168,148,147,127,127,126,87,86,178,51,50,173,131,49,48,169,83,36,35,59,58,49,87,143,132,188,130,186,10,66,27,83,49,106,105,79,135,88,145,144,102,171,35,141,5,30,86,153,17,23,79,26,83,82,5,61,177,42,41,176,40,136,0,36,93,92,100,156,31,88,87,98,154,27,83,133,190,189,85,141,108,164,99,156,155,41,40,85,83,156,155,172,2,146,33,32,41,125,124,94,175,106,168,171,150,130,6,130,129,89,181,53,176,51,172,86,39,38,61,52};
static const short Gen_shift_values_BG2_Z_208[1483]= {141,16,124,17,161,34,174,46,163,25,45,1,181,16,100,109,194,183,201,15,1,12,130,189,11,178,158,142,141,16,124,18,17,161,34,175,174,46,164,163,25,45,1,181,16,100,109,195,194,183,201,15,1,12,130,189,12,11,178,158,142,141,17,16,124,18,17,161,34,175,174,46,164,163,26,25,45,2,1,181,16,101,100,109,195,194,184,183,201,16,15,1,13,12,130,189,12,11,179,178,158,141,16,124,17,161,35,34,174,47,46,163,25,45,1,181,17,16,100,110,109,194,183,202,201,15,2,1,12,130,190,189,11,178,159,158,51,50,133,33,42,135,134,70,151,26,84,83,163,73,72,142,162,118,90,133,9,18,104,103,92,110,132,118,129,39,98,129,128,87,67,204,203,78,186,135,80,79,15,96,48,29,28,108,18,17,87,107,63,35,78,162,171,35,49,48,37,55,77,63,131,74,192,43,74,73,32,12,154,153,28,136,6,30,29,173,46,187,186,58,176,175,37,57,13,193,28,112,121,33,207,206,195,5,27,13,197,24,142,201,24,23,190,170,167,41,40,199,123,74,23,182,125,124,75,60,11,141,93,92,162,74,73,24,153,105,104,63,62,13,132,83,152,103,108,59,80,31,123,75,74,207,158,8,168,167,77,94,93,44,82,33,100,52,51,122,73,108,60,59,142,119,70,29,188,88,40,39,119,118,69,77,28,57,9,8,164,163,39,38,146,100,40,39,183,56,176,197,196,68,186,185,48,47,67,24,23,203,38,123,122,131,9,8,206,205,15,38,37,23,35,34,152,3,34,33,201,200,180,138,15,14,13,97,121,205,14,99,98,158,34,31,115,185,171,48,47,43,127,160,37,36,22,106,42,126,206,82,178,54,13,97,97,181,106,190,191,68,67,180,56,198,74,12,96,206,82,9,93,127,3,186,62,26,8,93,92,175,51,155,31,124,59,176,50,149,24,132,38,25,169,43,42,182,55,54,171,33,53,9,189,25,24,108,118,117,202,191,2,1,23,10,9,28,20,138,198,197,19,186,167,166,34,191,190,65,173,67,66,2,83,17,16,15,95,5,4,74,94,154,50,22,65,149,158,36,35,24,42,64,50,61,179,30,61,60,19,207,119,202,102,31,203,139,13,12,52,152,25,24,141,3,23,187,159,203,202,78,88,87,172,161,180,179,201,188,187,198,108,168,167,94,197,156,137,136,194,193,42,68,125,176,25,70,69,126,5,62,86,144,143,90,19,18,75,98,156,155,8,7,64,77,134,97,154,53,110,25,82,68,126,125,152,1,161,11,10,39,38,95,27,84,45,103,102,19,67,124,53,111,110,64,121,182,31,33,91,90,64,63,120,22,79,2,60,59,41,36,35,124,118,24,18,173,125,120,119,61,55,142,136,74,69,68,154,148,63,58,57,133,127,153,147,109,103,81,75,124,118,0,202,9,3,94,89,88,83,77,101,95,123,117,109,103,120,114,30,24,89,83,119,114,113,78,72,58,52,196,195,110,109,70,193,192,178,92,72,71,194,193,7,129,88,2,124,21,20,143,142,100,14,10,9,132,131,79,202,201,99,13,55,178,177,27,149,70,192,154,69,68,163,77,41,40,163,162,29,152,151,47,169,69,192,191,55,177,66,189,188,184,98,35,157,66,65,188,187,24,147,146,4,126,30,76,75,177,176,158,52,51,58,159,160,159,53,52,95,196,176,69,56,109,108,2,1,188,81,98,97,199,198,167,61,60,187,80,143,37,36,115,8,158,51,34,136,135,43,144,200,129,128,22,21,117,11,10,135,28,157,51,50,143,36,154,48,47,64,165,123,16,154,153,47,46,112,6,5,92,193,128,202,139,193,68,176,109,69,5,86,123,18,98,7,77,97,53,25,68,152,161,38,27,45,67,53,64,182,33,63,22,2,48,47,130,30,132,131,67,148,195,81,80,160,70,69,139,159,115,87,130,34,6,15,101,100,89,107,129,115,126,36,95,126,125,84,64,164,39,147,9,40,184,58,57,197,70,69,186,48,68,24,204,40,39,123,133,132,9,206,17,16,38,25,24,35,153,5,4,121,34,201,182,181,201,125,51,169,12,112,160,87,196,193,191,190,94,66,65,177,173,77,67,66,178,2,114,83,196,195,16,15,127,95,0,207,163,5,4,116,75,74,186,94,206,51,50,162,22,134,65,178,177,150,149,53,158,63,62,36,35,147,25,24,136,42,155,154,65,64,176,50,163,162,171,62,61,173,179,83,30,143,142,61,60,172,20,19,131,207,112,111,167,192,13,185,45,49,26,69,16,49,5,122,205,105,206,142,16,15,114,155,28,27,144,6,26,190,162,206,205,81,91,90,175,164,183,182,204,191,190,201,111,171,170,200,159,140,139,97,96,180,179,79,109,181,180,116,197,130,129,1,119,118,189,188,0,165,164,136,179,56,55,64,207,150,149,139,138,156,179,178,164,176,175,85,144,175,174,134,133,113,112,195,95,196,132,5,145,17,162,134,204,16,180,152,195,71,80,165,154,172,194,180,172,191,101,160,190,149,129,125,124,126,0,207,1,107,109,196,1,0,2,144,146,17,20,19,158,157,159,29,32,31,147,146,148,9,8,10,28,30,193,192,194,164,166,207,2,1,84,83,85,92,95,94,178,177,179,167,166,168,184,187,186,207,206,0,192,195,194,204,203,205,113,115,172,175,174,203,202,204,162,161,163,141,144,143,115,114,197,97,199,198,134,7,156,148,147,19,137,136,206,18,182,154,197,73,82,166,168,167,156,174,196,182,193,103,162,193,192,151,131,196,166,178,114,126,197,1,97,109,198,2,134,146,7,20,19,147,159,19,32,31,136,148,206,10,18,30,182,194,154,166,197,2,1,73,85,82,95,94,167,179,156,168,174,187,186,196,0,182,195,194,193,205,103,115,162,175,174,192,204,151,163,131,144,143,125,124,207,107,1,0,144,17,156,158,157,29,147,146,8,28,192,164,207,83,92,172,178,177,166,184,206,192,203,113,172,203,202,161,141,107,106,190,189,89,180,191,190,126,207,140,139,11,129,128,199,198,10,175,174,146,189,66,65,74,160,159,149,148,166,189,188,174,156,186,185,95,154,185,184,144,143,123,96,112,179,195,79,95,180,196,116,132,197,6,5,129,145,1,18,17,192,118,134,188,204,0,16,164,180,136,152,179,196,195,55,71,64,81,80,149,165,138,154,156,173,172,178,194,164,181,180,175,191,85,101,144,161,160,174,190,133,149,113,130,129,101,100,183,83,185,184,120,201,190,134,133,5,123,122,192,4,168,140,183,59,68,196,154,153,142,160,182,168,179,89,148,179,178,137,117};
static const short Gen_shift_values_BG2_Z_224[1483]= {71,52,151,109,130,184,22,5,180,155,45,114,190,35,155,123,94,114,123,199,109,28,90,155,7,30,132,71,72,53,152,109,110,131,185,22,23,6,180,181,156,46,115,191,36,156,124,94,95,115,124,200,110,29,91,156,7,8,31,133,71,72,52,53,152,109,110,131,185,22,23,6,180,181,155,156,46,114,115,191,36,155,156,124,94,95,114,115,124,199,200,110,28,29,91,156,7,8,30,31,133,72,53,152,110,131,184,185,23,5,6,181,156,46,115,191,35,36,156,123,124,95,115,123,124,200,109,110,29,91,155,156,8,31,132,133,172,173,154,29,199,210,211,8,62,15,123,124,107,57,58,33,147,216,68,137,33,1,195,196,216,1,77,211,130,192,33,108,109,132,10,40,41,22,121,184,78,79,100,154,137,215,216,199,149,150,125,15,84,160,5,125,93,169,63,64,84,93,169,79,218,222,60,125,200,201,0,102,56,57,38,137,122,94,95,116,170,7,8,215,165,166,141,31,100,176,21,141,109,54,79,80,100,109,185,95,30,14,76,141,216,217,16,118,221,221,222,29,203,10,78,109,35,36,67,57,88,111,141,142,102,172,173,204,156,186,187,106,107,138,82,113,196,3,41,72,117,148,186,216,217,82,113,50,80,81,12,20,21,52,41,72,50,80,81,126,157,36,66,67,104,179,210,17,48,82,112,113,157,158,189,181,212,59,89,90,223,0,204,205,80,146,37,38,59,113,42,174,175,158,108,109,83,84,198,42,43,119,188,83,84,52,22,23,42,43,52,127,128,38,180,181,19,84,159,160,182,183,61,31,154,155,12,136,111,11,69,192,193,90,214,144,44,1,206,105,106,189,89,140,39,40,115,15,5,129,74,198,150,50,219,119,115,15,83,207,54,177,178,74,198,83,207,159,59,69,193,212,112,50,174,115,15,29,191,90,91,214,114,92,216,173,149,7,55,171,152,27,98,209,6,59,60,122,104,105,56,31,145,214,66,134,135,31,222,223,194,214,222,223,75,208,209,137,128,190,30,31,107,130,7,8,109,180,181,162,37,218,219,16,70,45,131,132,115,65,66,41,155,216,0,76,145,41,9,203,204,0,9,85,219,138,200,41,116,117,140,18,212,193,68,36,26,47,100,101,112,163,145,146,97,72,186,31,107,175,176,72,39,40,11,31,39,40,116,25,26,169,7,71,72,142,148,171,48,49,111,112,188,93,169,192,44,149,150,2,171,23,1,76,77,35,62,63,139,46,121,122,220,221,73,196,48,86,162,155,7,7,83,76,151,152,196,48,164,15,16,134,135,211,155,7,164,15,16,94,16,92,150,1,2,69,145,131,207,196,47,48,47,48,124,71,147,173,24,25,47,181,182,28,163,127,38,115,85,219,220,106,17,160,71,222,132,133,205,116,156,66,67,131,42,21,156,90,1,166,77,11,146,131,42,99,10,70,204,205,90,1,99,10,175,86,85,220,4,139,66,201,131,42,207,117,118,6,141,108,19,205,206,168,169,187,149,150,62,25,19,20,206,207,41,4,95,58,74,156,157,119,120,140,103,90,91,53,54,66,28,29,180,143,25,211,212,101,64,170,133,66,28,29,34,221,4,5,191,192,25,211,212,34,221,110,72,73,20,207,163,125,126,1,188,66,29,141,142,104,105,165,127,128,43,6,157,53,54,73,74,35,54,55,134,154,91,92,111,112,113,133,167,187,47,4,5,24,25,212,8,162,163,182,183,138,157,158,28,48,97,116,117,173,193,18,38,138,157,158,106,126,131,76,77,96,97,97,116,117,106,126,182,201,202,92,112,11,30,31,73,93,138,158,213,214,9,10,13,32,33,115,135,67,15,155,157,138,13,34,195,216,46,137,108,91,42,17,131,200,52,121,17,209,180,200,209,61,195,114,176,17,93,116,218,212,213,194,69,26,27,48,102,5,163,164,147,97,98,73,187,32,108,177,19,73,41,11,12,32,41,117,27,170,8,73,148,149,172,50,153,134,9,79,191,212,41,42,104,86,87,38,13,127,196,48,116,117,13,204,205,176,196,204,205,57,190,191,110,172,12,13,42,89,112,213,214,48,0,155,53,133,152,87,62,210,93,68,69,78,49,50,59,149,158,106,107,116,128,137,182,190,191,19,20,29,3,11,12,89,177,178,187,152,153,162,43,52,111,112,121,188,197,33,41,42,152,153,162,121,129,130,91,92,101,111,112,121,121,129,130,196,197,206,107,115,116,5,25,26,35,88,97,153,161,162,4,5,14,27,28,37,130,138,139,26,117,215,211,192,107,60,105,43,184,175,30,11,110,68,89,142,143,146,205,187,188,139,114,4,73,149,217,218,114,81,82,53,73,81,82,158,67,68,211,49,113,114,190,213,90,91,181,182,162,163,38,107,219,220,17,71,132,133,116,66,67,41,42,156,0,1,77,146,41,42,10,20,204,205,0,1,10,85,86,220,138,139,201,42,117,118,140,141,19,180,161,36,218,15,69,131,114,70,65,40,154,223,75,144,40,8,203,223,8,84,218,11,137,199,40,116,139,17,48,49,141,29,30,122,129,221,28,86,87,179,108,200,162,29,30,223,0,92,207,74,75,157,158,26,132,133,1,23,115,91,92,184,168,36,13,104,105,132,133,1,101,192,193,71,72,164,91,92,184,101,192,193,176,177,45,87,178,179,5,6,98,68,160,133,0,1,208,209,77,7,8,100,110,201,202,126,127,108,207,164,165,186,16,90,77,78,61,11,12,211,101,170,22,91,211,179,164,149,150,170,179,31,165,84,146,211,62,63,86,188,0,174,82,111,84,92,65,191,164,149,122,170,143,0,196,197,62,35,45,17,18,220,193,195,168,85,58,154,127,6,203,75,47,48,195,168,163,135,136,134,107,154,127,163,135,136,15,212,149,121,122,68,41,130,103,195,167,168,47,20,70,43,172,144,145,117,118,99,198,155,156,177,7,36,68,69,52,2,3,202,92,161,13,82,202,170,96,140,141,161,170,22,156,75,137,202,53,54,77,179,1,2,206,207,82,105,39,40,61,115,176,177,160,110,111,85,86,200,44,45,121,190,85,86,54,24,25,44,45,54,129,130,40,180,182,183,21,86,161,162,184,185,63,106,108,87,89,186,188,144,146,165,167,219,220,221,57,59,40,41,42,97,215,217,190,192,80,82,149,151,1,3,70,71,72,190,192,158,159,160,129,131,149,151,158,159,160,10,12,144,145,146,63,65,125,127,190,191,192,42,44,65,67,167,168,169,152,153,134,9,190,191,212,42,119,103,104,87,37,38,13,127,196,48,117,13,205,100,175,176,196,205,57,191,110,172,13,88,89,112,214};
static const short Gen_shift_values_BG2_Z_240[1483]= {144,141,73,130,30,238,70,170,20,173,2,182,52,94,26,109,22,95,158,22,198,8,154,42,111,166,74,144,145,142,74,130,131,31,239,70,71,171,20,21,174,3,183,53,95,27,110,22,23,96,159,23,199,9,155,43,111,112,167,75,144,145,141,142,74,130,131,31,239,70,71,171,20,21,173,174,3,182,183,53,95,26,27,110,22,23,95,96,159,22,23,199,8,9,155,43,111,112,166,167,75,145,142,74,131,31,238,239,71,170,171,21,174,3,183,53,94,95,27,109,110,23,96,158,159,23,198,199,9,155,42,43,112,167,74,75,84,85,82,14,28,70,71,211,179,139,10,11,111,200,201,114,183,123,233,35,207,50,202,203,36,99,203,139,189,95,223,51,52,107,15,111,112,109,41,120,97,98,238,206,40,37,38,138,227,228,141,210,150,20,62,234,77,168,229,230,63,126,230,166,87,216,122,10,78,79,134,42,200,201,198,130,136,186,187,87,55,126,127,227,76,77,230,59,239,109,151,83,166,71,78,79,152,215,79,15,171,65,211,99,167,168,223,131,123,76,77,59,74,56,6,228,62,63,45,203,185,171,152,153,85,2,3,225,103,84,85,192,193,175,106,88,175,157,115,97,225,207,27,8,9,199,181,42,23,24,185,194,195,177,28,10,91,72,73,195,177,131,112,113,86,181,163,87,69,215,196,197,43,44,26,99,81,7,228,229,129,130,126,127,59,175,115,116,16,224,168,55,56,156,5,6,158,159,228,167,168,38,80,11,12,95,7,8,80,81,144,7,8,184,233,234,140,28,96,97,151,152,60,192,212,213,189,210,121,142,178,198,199,78,99,46,67,166,118,138,139,218,239,68,88,89,221,2,50,71,230,11,100,121,142,163,74,95,157,178,70,90,91,143,164,206,227,70,91,6,27,56,77,202,223,90,111,237,159,179,180,214,235,122,143,37,216,207,231,196,193,125,177,182,82,49,50,122,221,222,72,225,54,234,104,145,146,78,160,161,74,147,209,210,74,9,10,213,60,206,93,94,163,218,125,126,167,216,217,214,146,202,203,103,71,123,142,143,3,92,93,6,75,121,15,125,167,99,182,94,95,168,231,95,31,81,227,115,183,184,239,147,124,121,53,47,110,10,217,218,56,50,149,150,0,153,222,162,32,73,74,6,88,89,2,75,137,138,2,177,178,228,134,21,22,166,91,146,53,54,108,109,67,106,64,38,236,94,95,53,235,193,203,160,161,81,34,35,233,135,92,93,224,225,183,138,96,207,165,147,105,17,215,59,16,17,231,189,74,31,32,226,227,185,60,18,123,80,81,231,227,185,163,120,121,213,171,119,77,7,204,205,75,76,34,131,89,39,236,237,121,61,62,118,59,50,231,37,107,47,48,7,188,215,156,47,227,228,147,88,237,177,178,150,91,219,160,159,100,29,210,71,12,3,184,86,27,239,179,180,72,13,135,76,239,180,175,116,225,166,131,72,19,200,88,28,29,143,84,51,232,79,80,106,107,77,103,104,9,36,65,66,92,93,206,233,174,201,169,5,6,32,33,106,133,195,196,222,223,109,135,136,178,205,118,144,145,228,15,30,57,202,228,229,45,72,197,198,224,225,31,57,58,94,121,198,224,225,134,161,184,210,211,90,117,218,5,46,47,73,74,102,128,129,10,37,22,99,100,122,123,97,119,120,29,52,85,86,108,109,226,9,194,217,195,25,26,48,49,126,149,215,216,238,239,129,151,152,198,221,138,160,161,8,31,50,73,222,4,5,65,88,172,217,218,0,1,51,73,74,114,137,218,0,1,154,177,204,226,227,110,133,238,21,66,67,89,90,122,144,145,30,53,127,210,209,232,229,161,38,218,118,86,83,158,18,108,21,90,30,140,182,114,197,110,183,6,110,46,96,2,130,199,14,162,150,151,148,80,136,137,37,5,116,76,77,177,26,27,180,9,189,59,101,226,33,116,28,29,102,165,29,205,15,161,49,117,118,173,81,156,153,85,237,142,42,9,10,82,181,182,32,185,14,194,64,105,106,38,120,121,34,107,169,170,34,209,210,20,166,53,54,12,123,178,85,86,194,43,4,93,110,80,18,129,65,94,94,95,231,91,92,228,24,160,80,81,217,221,117,189,84,85,20,21,157,121,16,17,145,210,211,107,123,124,20,193,89,132,133,29,3,139,45,180,181,216,217,113,60,195,196,212,213,109,45,46,182,109,4,5,212,213,109,149,44,45,65,198,199,95,105,1,233,128,129,61,62,198,116,117,13,25,160,161,63,180,6,143,15,24,56,36,138,220,16,191,188,120,177,77,44,45,200,117,216,217,67,220,49,229,99,140,141,73,155,156,69,142,204,205,69,4,5,55,201,88,89,158,213,120,121,20,21,17,18,190,178,6,7,147,115,186,187,47,136,137,49,50,119,58,59,169,211,142,143,226,13,138,139,211,212,35,138,139,75,124,125,31,159,227,228,42,43,191,10,7,179,236,136,104,176,36,45,126,39,108,48,158,200,132,215,128,201,24,128,64,1,114,20,148,217,32,180,39,40,46,36,37,43,209,215,183,25,26,32,166,172,134,139,140,205,206,212,66,71,72,155,156,162,68,69,75,138,144,77,78,84,188,194,230,235,236,161,162,168,5,10,11,157,158,164,230,231,237,54,59,60,157,158,164,94,99,100,143,144,150,50,56,178,183,184,6,7,13,61,62,68,210,215,216,79,80,77,9,65,66,206,174,84,5,6,106,195,196,109,178,118,228,30,202,45,224,197,198,31,94,198,134,184,90,218,46,47,102,10,177,111,105,58,19,55,16,227,188,44,5,184,145,152,112,113,224,185,84,44,45,174,135,87,48,156,117,96,57,206,167,8,208,209,180,141,23,223,224,176,137,9,210,72,32,33,176,137,112,72,73,162,123,68,29,196,156,157,25,226,80,41,228,188,189,9,10,7,179,235,236,136,104,41,175,176,36,125,126,39,108,48,158,200,132,215,40,127,128,201,24,128,64,114,20,148,216,217,32,180,93,94,90,91,23,166,79,80,220,188,19,20,120,209,210,122,123,192,131,132,2,44,215,216,59,211,212,44,45,108,211,212,148,44,197,198,104,232,60,61,115,116,24,211,85,208,82,140,14,197,71,97,211,65,178,179,137,11,237,110,111,77,87,201,0,114,69,183,9,123,119,233,161,34,35,93,207,176,49,50,89,203,162,36,225,98,99,89,203,25,138,139,75,189,221,95,109,222,223,178,52,233,107,141,14,15,134,135,132,64,120,121,21,229,52,60,61,161,10,11,164,233,173,43,85,17,100,214,12,13,86,149,13,189,239,145,33,101,102,157,65};
static const short Gen_shift_values_BG2_Z_288[1483]= {1,17,93,24,104,118,51,119,33,92,90,102,108,20,64,2,113,82,71,96,47,67,109,126,125,48,77,2,1,17,93,25,24,104,118,52,51,119,34,33,92,90,102,108,20,64,2,114,113,82,71,96,47,67,109,126,126,125,48,77,2,1,18,17,93,25,24,104,118,52,51,119,34,33,93,92,90,103,102,108,20,65,64,2,114,113,83,82,71,97,96,47,68,67,109,126,126,125,49,48,77,1,17,93,24,104,119,118,51,120,119,33,92,90,102,108,21,20,64,3,2,113,82,72,71,96,48,47,67,109,127,126,125,48,78,77,53,52,68,144,41,76,75,155,169,23,103,102,170,85,84,143,141,153,159,71,115,53,165,164,133,122,147,98,118,160,177,177,176,99,128,73,72,88,164,39,96,95,175,189,139,123,122,190,105,104,163,161,173,179,91,135,73,83,185,184,153,142,167,118,136,138,180,197,197,196,119,148,141,140,156,232,108,164,163,243,257,191,190,258,173,172,231,229,241,247,159,203,141,86,253,252,221,210,235,186,106,206,248,265,265,264,187,216,132,110,109,66,125,82,201,158,133,132,89,212,169,226,184,183,96,160,159,116,227,185,184,142,141,98,200,157,198,155,210,167,216,173,128,86,85,172,129,110,68,67,134,222,221,178,190,147,179,137,136,204,161,155,113,112,34,175,132,217,174,234,192,191,234,233,190,156,113,185,143,142,90,89,106,105,181,69,113,112,192,206,68,140,139,207,122,121,181,180,178,191,190,196,108,153,152,90,202,201,171,170,159,185,184,135,156,155,197,214,214,213,137,136,165,25,51,50,41,66,117,142,48,74,73,128,153,142,167,96,75,101,100,143,168,57,83,82,116,141,114,139,126,151,132,157,44,69,88,113,26,51,137,163,162,106,131,95,120,120,145,71,96,91,116,133,158,150,175,39,149,175,174,72,97,101,126,45,40,100,95,65,81,157,27,88,168,183,182,115,184,183,97,156,154,166,172,85,84,128,67,66,177,146,136,135,160,112,111,29,131,173,191,190,189,112,142,141,115,133,132,148,224,156,155,235,249,32,183,182,250,165,164,223,221,121,233,239,151,195,133,245,244,213,202,227,178,198,240,257,257,256,179,208,48,64,140,75,71,151,166,165,36,98,167,166,80,139,137,149,155,68,67,111,50,49,160,129,119,118,143,95,94,114,156,174,173,61,172,95,125,124,132,131,98,147,114,223,190,155,154,121,234,201,248,216,215,142,182,181,148,249,217,216,164,163,130,222,189,220,187,232,199,238,205,150,118,117,194,161,132,100,99,244,243,210,212,179,201,169,168,50,226,193,177,145,144,197,164,239,206,256,224,223,256,255,222,178,145,207,175,174,97,130,129,113,145,189,221,138,120,153,152,200,232,214,246,147,180,179,215,247,129,162,161,188,220,186,218,198,230,204,236,116,148,160,192,98,130,209,242,241,178,210,167,199,192,224,143,175,163,195,205,237,222,254,221,254,253,144,176,173,205,30,29,10,9,45,26,25,121,101,53,52,33,32,132,112,146,126,47,80,79,60,59,147,127,62,61,42,41,120,101,100,118,98,130,111,110,136,116,48,28,92,73,72,30,10,142,141,122,121,110,91,90,99,79,124,105,104,75,55,95,76,75,137,117,154,134,154,153,134,133,76,57,56,105,85,8,67,66,44,43,82,60,59,158,135,90,89,67,66,169,146,183,160,119,117,116,94,93,184,161,99,98,76,75,157,135,134,155,132,167,145,144,173,150,85,62,129,107,106,67,44,42,179,178,156,155,147,125,124,136,113,161,139,138,112,89,132,110,109,174,151,191,168,191,190,168,167,113,91,90,142,119,16,105,141,42,58,134,78,65,145,159,27,92,160,74,133,131,143,149,61,105,43,154,123,112,137,88,108,150,167,166,89,118,80,79,95,171,103,102,182,196,1,130,129,197,112,111,170,168,180,186,98,102,142,80,192,191,160,149,174,125,145,187,204,204,203,126,155,82,98,174,90,105,185,200,199,132,201,200,114,173,171,183,189,102,101,145,84,83,194,163,153,152,177,129,128,148,190,208,207,74,206,129,159,158,53,131,67,114,55,29,41,100,127,62,102,101,134,118,117,150,193,226,125,124,157,204,237,218,252,251,152,151,184,219,253,252,141,134,133,166,193,192,225,190,223,203,202,235,208,241,120,154,153,165,164,197,102,136,135,214,213,246,183,182,215,171,205,204,197,196,229,147,181,180,27,168,167,200,209,242,226,260,259,226,225,258,149,148,181,177,211,210,12,9,105,76,42,132,24,86,55,103,69,140,156,232,163,243,258,257,79,190,259,258,172,231,229,241,247,160,159,203,142,141,252,221,211,210,235,187,186,206,248,266,265,264,187,217,216,73,72,89,88,164,31,96,95,175,189,123,122,190,105,104,164,163,161,174,173,179,91,136,135,73,88,185,184,154,153,142,168,167,118,139,138,180,197,197,196,120,119,148,3,19,95,26,106,120,53,121,134,35,94,92,104,110,22,66,4,115,84,73,98,49,5,69,111,128,127,50,79,27,26,115,43,42,131,118,207,36,50,49,138,129,218,143,233,232,77,76,165,144,234,233,59,58,147,118,117,206,115,204,128,127,216,133,222,45,135,134,90,89,178,27,117,116,139,138,227,108,107,196,96,186,185,122,121,210,72,162,161,93,92,181,134,223,151,241,240,151,150,239,74,73,162,102,192,191,95,94,110,186,118,117,197,211,59,145,144,212,127,126,185,183,195,201,113,157,95,136,207,206,175,164,189,140,160,202,219,219,218,141,170,120,128,25,98,57,114,73,190,149,121,80,201,160,215,175,174,148,107,216,176,175,130,89,189,148,187,146,199,158,205,164,117,77,76,161,120,99,59,58,210,169,179,138,168,128,127,193,152,144,104,103,164,123,206,165,223,183,182,222,181,145,104,174,134,133,3,2,18,94,26,25,105,119,0,53,52,120,35,34,93,91,103,109,21,65,3,69,115,114,83,72,97,48,68,110,127,127,126,49,78,144,143,160,159,235,118,167,166,246,260,194,193,261,176,175,235,234,232,245,244,250,162,207,206,144,256,255,225,224,213,239,238,189,31,210,209,251,268,268,267,191,190,219,74,103,90,119,166,195,97,126,177,206,191,221,220,124,153,192,222,221,5,106,135,165,194,163,192,175,204,181,210,93,123,122,137,166,75,105,104,186,215,155,184,144,174,173,169,198,120,150,149,140,169,182,211,199,229,228,198,227,121,150,150,180,179,21,20,36,112,44,43,123,137,47,71,70,138,53,52,111,109,121,127,39,83,21,46,133,132,101,90,115,66,86,128,145,145,144,67,96};
static const short Gen_shift_values_BG2_Z_256[1483]= {7,165,79,115,112,6,202,56,24,164,42,251,50,156,123,102,187,224,207,154,52,222,238,16,203,250,126,8,7,165,79,116,115,112,6,203,202,56,25,24,164,42,251,50,156,123,102,188,187,224,207,154,52,222,238,16,204,203,250,126,8,7,166,165,79,116,115,112,6,203,202,56,25,24,165,164,42,252,251,50,156,124,123,102,188,187,225,224,207,155,154,52,223,222,238,16,204,203,251,250,126,7,165,79,115,112,7,6,202,57,56,24,164,42,251,50,157,156,123,103,102,187,224,208,207,154,53,52,222,238,17,16,203,250,127,126,79,78,236,150,178,187,186,183,77,213,18,17,127,96,95,235,113,66,121,227,194,173,3,2,39,22,225,123,37,53,87,19,18,65,197,111,110,12,182,230,219,218,215,109,40,50,49,159,128,127,11,145,98,153,3,226,205,193,35,34,71,54,1,155,158,69,85,119,51,50,97,229,166,165,67,237,154,18,17,14,164,105,104,214,183,182,66,200,153,208,58,25,4,227,90,89,126,109,56,210,44,124,140,174,106,105,152,28,27,11,10,123,168,25,82,195,119,118,231,115,228,123,9,122,128,206,205,62,173,59,172,28,27,140,167,24,45,158,254,111,53,166,17,159,16,126,239,219,105,218,146,191,190,47,227,84,68,210,67,157,14,169,55,168,139,225,82,241,98,133,19,132,207,206,63,253,110,243,129,242,238,237,140,139,53,141,90,89,86,236,93,177,176,30,255,254,139,138,16,226,225,24,130,98,97,76,162,161,199,198,181,129,128,26,197,196,212,246,178,177,225,224,100,255,68,254,226,156,140,70,107,176,106,173,103,67,253,202,194,7,193,117,47,16,85,15,225,155,103,33,56,242,111,41,217,147,184,114,163,93,179,248,178,29,215,12,198,215,145,113,43,27,213,43,229,77,7,204,195,8,194,55,241,187,117,10,184,255,116,63,221,135,10,171,168,63,62,2,113,112,80,220,98,51,106,213,212,179,159,158,243,24,8,7,210,109,108,235,22,38,73,72,3,50,183,182,209,22,21,179,93,130,129,126,20,62,217,216,70,39,38,178,56,110,9,64,170,137,116,202,201,238,221,168,66,236,252,30,218,217,8,140,229,131,45,82,81,78,229,228,1,168,23,22,246,130,8,217,16,123,122,89,69,68,153,190,174,173,120,19,18,188,204,239,238,37,169,216,93,92,11,10,239,168,141,82,55,119,118,91,115,88,239,9,238,114,206,205,178,33,59,32,28,27,0,167,140,45,18,254,227,53,26,133,159,132,126,99,79,105,78,191,190,163,227,200,184,210,183,144,157,130,29,55,28,225,198,241,214,249,19,248,207,206,179,253,226,103,129,102,221,182,220,84,122,254,36,50,73,34,72,31,69,181,219,160,121,159,231,13,238,199,237,83,121,217,255,170,208,225,7,75,113,42,80,21,59,145,106,144,143,181,126,164,73,111,227,9,141,179,157,195,191,229,161,122,160,169,207,45,83,16,250,15,249,152,173,151,87,65,124,102,123,101,120,98,14,248,202,211,189,210,188,64,42,33,11,32,10,151,172,150,50,28,238,3,237,58,36,164,142,110,131,109,110,88,196,174,195,173,211,232,210,215,193,141,162,140,60,38,209,230,208,246,224,24,2,212,190,211,189,237,2,236,134,112,141,122,72,121,71,230,23,229,193,143,230,180,229,179,226,176,120,70,253,61,11,60,10,170,120,139,89,138,88,229,22,228,156,106,60,109,59,164,114,14,220,188,237,187,216,166,123,46,252,45,251,33,82,32,65,15,219,12,218,166,116,31,80,30,96,46,130,80,62,12,61,11,59,108,58,240,190,219,193,49,192,94,8,86,44,41,191,19,131,241,209,93,227,180,235,85,52,31,116,153,136,83,237,151,167,201,132,179,55,37,36,194,108,145,144,141,35,25,232,231,85,54,53,193,71,24,79,185,104,152,131,217,216,253,236,183,81,251,11,45,233,232,23,155,217,119,33,75,69,66,217,216,156,11,10,234,118,252,205,4,111,110,77,57,56,141,178,162,161,108,7,6,176,192,227,226,41,157,204,81,80,221,62,22,234,237,45,138,7,227,155,168,167,129,70,69,31,239,201,20,19,237,16,234,129,166,128,107,106,68,179,216,178,28,185,184,146,69,68,30,202,164,156,155,117,210,172,23,60,22,28,27,245,225,6,224,92,91,53,129,128,90,74,111,73,59,58,20,175,212,174,142,127,126,88,142,104,139,176,138,108,107,69,155,154,116,249,30,248,7,150,97,100,134,17,27,70,239,8,83,8,166,80,116,113,8,7,105,203,58,57,25,165,43,252,51,158,157,124,104,103,188,225,209,208,155,54,53,223,239,18,17,204,251,128,127,174,173,76,75,245,241,26,25,22,172,113,112,222,191,190,75,74,208,162,161,216,66,34,33,12,43,98,97,135,134,117,65,64,218,133,132,148,182,114,113,161,160,36,242,144,58,94,91,241,181,35,131,3,143,21,230,29,135,102,81,166,203,186,133,31,163,201,217,251,182,229,105,93,92,43,251,250,201,164,115,146,201,200,151,197,148,43,91,42,32,31,238,93,141,92,110,109,60,250,249,200,127,78,81,80,31,135,86,193,241,192,209,208,159,139,187,138,17,16,223,54,53,4,244,36,243,240,239,190,89,137,88,52,51,2,67,18,53,101,52,33,32,239,80,79,30,163,211,162,71,70,228,142,179,178,175,69,56,10,9,119,88,87,227,105,58,113,219,186,165,39,251,250,31,14,217,115,29,45,79,11,10,57,189,139,37,153,226,158,128,60,42,230,78,10,75,7,158,225,157,165,97,208,19,207,243,175,127,59,5,193,214,146,13,201,52,119,51,86,18,254,65,253,150,82,187,119,103,170,102,117,49,204,15,203,185,117,201,133,168,235,167,166,98,213,145,22,89,21,46,45,203,117,154,153,150,44,30,241,240,94,63,62,202,80,33,88,194,161,140,65,226,225,6,245,192,90,4,20,54,242,241,32,164,42,41,200,199,113,238,150,149,146,40,237,236,90,59,58,199,198,76,30,29,84,190,158,157,136,222,221,3,2,241,189,188,86,171,1,0,16,50,238,237,29,28,160,82,127,240,29,154,199,190,235,187,232,127,81,126,21,66,177,131,176,255,99,144,239,28,117,162,70,115,125,170,21,231,20,198,243,223,177,222,6,51,43,88,72,26,71,229,18,173,127,172,41,86,57,102,137,91,136,22,67,69,114,247,201,246,126,125,27,197,234,233,230,124,128,65,64,174,143,142,26,160,113,168,18,241,220,228,50,49,86,69,16,170,84,100,134,66,65,112,244};
static const short Gen_shift_values_BG2_Z_320[1483]= {318,135,18,318,92,36,318,13,318,122,97,318,7,100,318,144,318,86,10,318,55,318,106,51,318,53,44,319,318,135,18,319,318,92,36,319,318,13,319,318,122,97,318,7,100,318,144,319,318,86,10,318,55,318,106,51,319,318,53,44,319,318,136,135,18,319,318,92,36,319,318,13,319,318,123,122,97,319,318,7,100,319,318,144,319,318,87,86,10,319,318,55,319,318,106,51,319,318,54,53,44,318,135,18,318,92,37,36,318,14,13,318,122,97,318,7,101,100,318,145,144,318,86,11,10,318,56,55,318,106,52,51,318,53,45,44,156,155,292,175,319,156,155,249,193,135,156,155,170,156,155,279,254,155,164,257,155,301,156,155,243,167,155,212,155,263,208,156,155,210,201,63,62,199,82,319,63,62,156,100,130,63,62,77,63,62,186,161,62,71,164,62,208,141,63,62,150,74,62,119,140,62,170,115,63,62,117,108,147,146,283,166,319,147,146,240,184,147,146,161,147,146,270,245,146,155,248,146,292,123,147,146,234,158,146,203,98,146,254,199,147,146,201,192,44,95,94,76,231,213,114,96,95,94,76,188,170,132,115,114,319,95,94,76,109,92,91,95,94,76,218,200,193,175,94,76,103,85,196,179,178,94,76,240,223,222,44,95,94,76,182,164,106,89,88,94,76,151,134,133,147,94,76,202,184,147,130,129,95,94,76,149,131,140,123,122,86,85,223,222,105,319,86,85,179,123,64,86,85,100,86,85,210,209,184,86,85,94,187,86,85,231,86,85,174,173,97,86,85,142,86,85,193,138,86,85,141,140,131,49,84,83,186,220,69,103,49,84,83,143,177,87,121,319,49,84,83,64,98,49,84,83,173,207,148,182,49,83,58,92,151,185,49,83,195,229,49,84,83,137,171,61,95,49,83,106,140,49,83,157,191,102,136,96,49,84,83,104,138,95,129,319,16,155,19,0,137,20,319,0,94,39,38,0,16,15,0,124,99,0,9,103,102,0,147,146,0,88,13,12,0,58,57,6,0,108,54,53,0,55,47,46,3,47,46,183,66,47,46,140,84,319,47,46,61,47,46,170,145,112,46,55,148,46,192,47,46,134,58,46,103,46,154,99,47,46,101,92,24,161,44,319,24,118,63,62,111,24,40,39,24,148,123,24,33,127,126,24,171,170,24,112,37,36,24,82,81,24,132,78,77,101,24,79,71,70,56,55,25,192,162,75,45,56,55,25,149,119,93,64,63,319,56,55,25,70,41,40,56,55,25,179,149,154,124,55,25,64,34,157,128,127,55,25,201,172,171,56,55,25,143,113,67,38,37,137,55,25,112,83,82,55,25,163,133,108,79,78,56,55,25,110,80,101,72,71,71,98,97,208,234,91,117,319,71,98,97,165,191,109,135,71,98,97,86,112,71,98,97,195,221,170,196,71,97,80,106,173,199,71,97,217,243,71,98,97,159,185,83,109,71,97,128,154,71,97,179,205,124,150,71,98,97,126,152,117,143,110,109,142,141,246,279,278,129,161,110,109,142,141,203,235,147,179,319,110,109,142,141,124,156,110,109,142,141,233,266,265,208,240,109,142,141,118,150,211,243,109,142,141,255,287,110,109,142,141,197,230,229,121,153,109,142,141,166,198,109,142,141,217,249,162,194,110,109,142,141,164,197,196,155,187,78,108,107,17,16,244,154,153,127,36,108,107,17,16,201,110,145,54,319,108,107,17,16,122,31,108,107,17,16,231,141,140,206,115,107,17,16,116,25,209,118,107,17,16,253,162,23,108,107,17,16,195,105,104,119,28,107,17,16,164,73,107,17,16,215,124,160,69,108,107,17,16,162,72,71,153,62,319,17,85,152,289,172,319,152,246,190,157,152,167,152,276,251,152,161,254,152,298,152,240,164,152,209,152,260,205,152,207,198,103,102,239,122,103,102,196,140,319,103,102,117,103,102,226,201,102,111,204,147,102,248,103,102,190,114,102,159,102,210,155,103,102,157,148,31,168,51,319,31,125,70,69,31,47,46,31,155,130,31,40,134,133,31,178,177,31,119,44,43,31,89,88,31,139,85,84,16,31,86,78,77,319,3,319,74,157,319,68,86,319,64,12,11,5,149,148,142,31,25,12,11,5,105,99,49,44,43,12,11,5,26,21,20,319,12,11,5,136,135,129,110,104,12,11,5,20,14,113,108,107,12,11,5,157,152,151,12,11,5,100,99,93,23,18,17,12,11,5,68,63,62,99,12,11,5,119,113,64,59,58,12,11,5,67,66,60,57,52,51,319,31,319,125,109,319,153,319,34,50,133,18,155,38,18,112,57,56,319,18,34,33,18,142,117,18,27,121,120,18,165,164,18,106,31,30,18,76,75,18,126,72,71,18,73,65,64,121,120,258,257,140,319,121,120,214,158,121,120,135,121,120,245,244,219,121,120,129,222,121,120,266,19,121,120,209,208,132,121,120,177,121,120,228,173,121,120,176,175,166,11,148,31,11,105,49,11,26,319,11,135,110,11,20,113,11,157,11,99,23,11,68,87,11,119,64,11,66,57,18,17,76,155,154,213,37,96,319,18,17,76,111,170,55,115,114,18,17,76,32,92,91,18,17,76,142,141,200,116,175,18,17,76,26,85,119,179,178,18,17,76,163,223,222,18,17,76,106,105,164,29,89,88,18,17,76,74,134,133,18,17,76,125,184,70,130,129,18,17,76,73,72,131,63,123,122,5,4,141,24,5,4,98,42,319,5,4,19,5,4,128,103,4,13,106,4,150,156,5,4,92,16,4,61,4,112,57,5,4,59,50,319,62,81,318,142,135,279,18,162,318,142,92,236,36,181,180,318,142,13,158,157,318,142,122,266,97,241,318,142,7,151,100,245,244,318,142,144,289,288,318,142,86,230,10,155,154,318,142,55,200,199,318,142,106,250,51,196,195,318,142,53,197,44,189,188,18,17,154,37,18,17,111,55,319,18,17,32,18,17,141,116,17,26,119,17,163,92,18,17,105,29,17,74,17,125,70,18,17,72,63,137,136,274,273,156,319,137,136,230,174,137,136,151,137,136,261,260,235,137,136,145,238,137,136,282,137,136,225,224,148,137,136,193,23,137,136,244,189,137,136,192,191,182,34,141,171,278,54,161,34,141,128,235,72,180,179,34,141,49,157,156,319,34,141,158,265,133,240,34,141,43,150,136,244,243,34,141,180,288,287,34,141,122,229,46,154,153,34,141,91,199,198,34,141,142,249,87,195,194,34,141,89,196,80,188,187,54,53,190,73,54,53,147,91,319,54,53,68,54,53,177,152,53,62,155,53,199,1,54,53,141,65,53,110,53,161,106,54,53,108,99};
static const short Gen_shift_values_BG2_Z_352[1483]= {154,15,96,141,166,51,12,172,1,63,105,61,80,172,351,125,38,53,15,35,87,169,140,15,121,131,103,155,154,15,96,142,141,166,51,13,12,172,2,1,63,105,61,80,172,351,125,39,38,53,15,35,87,169,140,15,122,121,131,103,155,154,16,15,96,142,141,166,51,13,12,172,2,1,64,63,105,62,61,80,172,0,351,125,39,38,54,53,15,36,35,87,170,169,140,15,122,121,132,131,103,154,15,96,141,166,52,51,12,173,172,1,63,105,61,80,173,172,351,126,125,38,53,16,15,35,88,87,169,140,16,15,121,131,104,103,238,237,98,179,85,225,224,249,134,66,96,95,255,85,84,146,188,144,163,255,82,208,122,121,136,98,118,170,252,223,98,205,204,214,186,215,214,75,156,78,202,201,226,111,83,73,72,232,62,61,123,165,121,140,232,59,185,34,99,98,113,75,95,147,102,229,200,75,182,181,191,163,184,183,44,125,46,171,170,195,80,42,41,201,31,30,92,134,90,109,201,28,154,153,68,67,82,44,64,116,9,198,169,44,151,150,160,132,154,202,201,209,62,70,143,151,189,188,196,213,221,98,107,106,47,60,59,67,219,228,227,49,48,56,110,118,152,160,108,116,127,135,219,228,227,46,54,172,181,180,124,86,85,93,100,108,62,71,70,82,90,134,143,142,23,216,224,187,195,62,71,70,169,168,176,178,186,150,159,158,316,315,177,176,257,52,303,302,327,212,30,174,173,333,163,162,225,224,266,223,222,241,333,161,160,286,200,199,215,214,176,197,196,248,331,330,301,176,283,282,293,292,264,253,219,218,114,79,195,160,240,206,205,265,230,150,115,103,111,77,76,271,236,100,66,65,162,127,204,169,160,125,179,144,271,236,98,63,224,189,137,103,102,152,117,114,79,134,99,186,151,268,233,239,204,114,79,141,220,186,185,230,195,202,167,110,24,173,22,295,156,237,90,282,307,193,192,153,314,313,142,204,246,202,221,314,313,140,267,266,179,194,157,156,176,229,228,174,310,281,157,156,262,272,245,244,23,159,158,19,100,146,145,170,55,121,17,16,176,6,5,67,109,10,65,84,176,3,129,43,42,57,19,39,91,173,144,19,126,125,135,107,281,142,223,28,268,293,179,178,90,139,300,299,128,190,232,188,207,300,299,126,253,252,165,180,143,142,162,215,214,296,267,143,142,26,248,258,231,230,163,162,320,23,181,104,262,150,149,307,174,332,59,218,217,10,21,20,178,180,339,338,10,9,167,71,229,113,271,69,227,88,246,180,339,338,7,165,133,292,291,47,46,204,61,219,23,182,181,144,43,201,95,254,253,177,335,148,306,23,182,181,130,129,287,139,297,111,270,269,257,195,194,118,55,199,136,136,244,182,181,269,206,154,91,115,53,52,275,212,104,42,41,166,103,208,145,164,101,183,120,275,212,102,39,228,165,141,79,78,156,93,118,55,138,75,190,127,272,209,243,180,118,55,224,162,161,234,171,206,143,172,171,320,319,32,181,180,113,261,159,158,307,306,183,331,68,216,77,30,29,178,177,189,337,19,18,167,166,80,229,228,122,270,78,227,226,97,245,189,337,16,165,164,142,290,56,55,204,203,70,219,218,32,180,52,201,200,104,252,186,335,334,157,305,32,180,139,138,287,286,148,297,296,120,268,157,217,216,318,317,77,179,178,158,259,204,203,305,304,228,329,113,214,133,75,74,176,175,234,335,64,63,165,164,125,227,226,167,268,123,225,224,142,243,234,335,61,163,162,187,288,22,101,100,202,201,115,217,216,77,178,97,199,198,149,250,231,333,332,202,303,77,178,184,183,285,284,193,295,294,165,266,172,30,21,299,160,241,12,286,311,196,134,157,317,146,208,250,206,225,317,144,270,183,198,160,180,232,314,285,160,266,276,248,328,327,188,269,315,314,339,224,127,186,185,345,175,174,236,278,234,253,345,51,172,298,212,211,226,188,208,260,342,313,188,295,294,304,276,194,55,136,155,181,206,92,91,52,213,212,41,103,145,101,120,213,212,39,166,165,78,93,56,55,75,128,127,209,180,56,55,165,161,171,144,143,17,162,109,131,149,112,107,60,71,135,208,207,299,69,68,160,149,241,195,194,286,219,311,104,197,196,66,65,157,225,318,317,35,55,54,146,117,116,208,158,250,115,114,206,133,225,225,318,317,53,52,144,178,271,270,92,91,183,107,106,198,68,161,160,89,88,180,140,233,232,37,223,222,314,193,285,68,161,160,175,174,266,185,184,276,156,249,248,41,103,63,23,148,138,160,83,172,92,28,302,163,244,289,314,200,199,116,160,321,320,149,211,253,209,228,321,320,147,274,273,186,201,164,163,183,236,235,317,288,164,163,269,279,252,251,297,296,158,157,238,115,284,283,308,193,155,154,314,144,143,206,205,247,204,203,222,314,142,141,267,72,181,180,196,195,157,178,177,229,312,311,282,157,264,263,274,273,245,183,44,125,170,195,80,41,201,104,30,92,134,90,109,201,28,154,67,82,44,64,116,136,198,169,44,150,160,132,196,195,316,57,56,177,137,258,10,183,182,303,207,328,92,214,213,54,53,174,213,335,334,43,42,163,105,104,225,146,267,103,102,223,121,242,213,335,334,41,40,161,166,288,287,80,79,200,95,94,215,56,178,177,77,76,197,128,250,249,211,210,331,181,302,56,178,177,163,162,283,173,172,293,144,266,265,327,326,187,268,314,313,338,223,125,185,184,344,174,173,235,277,233,252,344,171,297,151,211,210,225,187,207,259,341,312,187,294,293,303,275,72,153,128,321,192,182,53,263,134,308,179,333,204,218,90,89,179,50,339,211,210,168,39,230,101,272,143,228,99,247,118,339,211,210,166,37,292,164,163,205,76,220,91,182,54,53,202,73,254,126,125,336,207,307,178,182,54,53,288,159,298,169,270,142,141,174,173,34,115,161,160,185,70,111,32,31,191,21,20,82,124,80,99,191,18,144,6,58,57,72,34,54,106,188,159,34,141,140,150,122,260,259,121,120,201,108,247,246,271,156,118,117,277,107,106,169,168,210,167,166,185,277,105,104,230,144,143,159,158,120,141,140,192,5,275,274,245,120,227,226,237,236,208,310,236,171,97,252,178,297,223,322,248,207,134,133,168,94,328,255,254,159,157,83,219,145,261,187,217,143,236,162,328,255,254,155,81,281,208,207,194,120,209,135,171,98,97,191,117,243,170,169,325,251,296,222,171,98,97,277,203,287,213,259,186,185,163,162,23,104,150,149,174,59,131,21,20,180,10,9,71,113,69,88,180,7,133,5,47,46,61,23,43,95,177,148,23,130,129,139,111};
static const short Gen_shift_values_BG2_Z_384[1483]= {172,25,23,95,112,134,164,173,64,34,115,46,108,111,90,70,69,29,121,185,116,183,112,26,170,1,184,173,172,25,23,96,95,112,134,165,164,173,65,64,34,115,46,108,111,90,70,70,69,29,121,185,116,183,112,26,171,170,1,184,173,172,26,25,23,96,95,112,134,165,164,173,65,64,35,34,115,47,46,108,111,91,90,70,70,69,30,29,121,186,185,116,184,183,112,26,171,170,2,1,184,172,25,23,95,112,135,134,164,174,173,64,34,115,46,108,112,111,90,71,70,69,29,122,121,185,117,116,183,112,27,26,170,1,185,184,202,201,54,52,71,125,124,141,163,73,194,193,202,94,93,63,144,75,137,140,119,99,99,98,58,150,214,145,212,141,55,200,199,30,213,221,220,73,71,9,144,143,160,182,43,213,212,221,113,112,82,163,94,156,159,138,118,120,118,117,77,169,233,164,79,231,160,74,219,218,49,232,357,356,209,207,128,280,279,296,318,349,348,357,249,248,218,299,230,292,295,274,254,91,254,253,213,305,369,300,99,367,296,210,355,354,185,368,48,275,274,315,127,168,125,166,198,197,238,214,255,236,278,277,79,267,266,307,275,317,316,167,166,207,136,177,217,258,148,189,210,251,213,255,254,192,233,172,214,213,185,172,171,212,131,172,223,265,264,287,328,218,260,259,15,285,326,214,255,128,170,169,273,272,313,103,144,286,328,327,325,324,178,177,175,117,248,247,264,286,69,317,316,325,217,216,187,186,267,199,198,260,263,243,242,222,222,221,182,181,273,338,337,268,336,335,264,178,323,322,154,153,336,357,351,350,210,203,208,201,280,274,273,297,290,319,312,27,349,343,342,358,351,249,243,242,219,212,300,293,231,224,293,286,296,289,275,268,255,248,254,248,247,214,207,306,299,370,363,301,294,368,361,297,290,211,204,131,355,349,348,186,179,369,362,58,103,21,51,326,179,177,31,249,266,289,288,318,328,327,218,188,269,200,262,266,265,244,225,224,223,183,276,275,339,271,270,91,337,266,181,180,324,155,339,338,173,184,183,36,34,107,106,123,145,38,176,175,184,76,75,45,126,92,57,119,122,101,81,81,80,40,132,196,127,194,123,37,182,181,12,195,338,191,189,48,261,278,301,300,124,330,340,339,230,200,281,212,274,278,277,256,237,236,235,195,288,287,351,283,282,349,278,193,192,34,336,167,351,350,194,193,335,46,188,44,186,117,116,258,133,275,155,298,297,18,186,185,327,194,337,336,86,85,227,55,197,136,278,67,209,129,271,132,275,274,111,253,91,234,233,91,90,232,50,192,142,285,284,117,206,348,137,280,279,204,346,133,275,47,190,189,192,191,333,22,164,205,348,347,235,254,253,88,106,86,104,67,158,177,176,175,193,197,215,227,246,245,236,254,127,146,145,97,115,178,196,109,127,171,189,174,192,153,171,133,151,132,151,150,92,110,184,202,248,266,179,197,246,264,175,193,89,107,233,252,251,64,82,247,265,308,307,237,236,160,90,89,158,87,231,230,160,159,247,176,269,198,86,300,299,229,228,308,237,200,199,129,128,169,99,98,250,179,181,111,110,243,172,246,175,225,155,154,205,134,205,204,134,133,164,94,93,256,185,320,250,249,251,180,318,248,247,247,176,161,90,306,305,235,234,136,66,65,319,248,176,182,181,179,178,34,32,31,32,29,105,104,102,101,121,118,143,140,157,174,173,171,170,182,179,74,73,71,70,43,41,40,124,121,55,53,52,117,114,120,117,99,97,96,79,76,22,79,78,76,75,38,36,35,130,127,194,192,191,125,122,192,190,189,121,118,35,32,180,179,177,176,10,8,7,193,190,185,5,45,328,181,179,57,251,268,290,41,320,329,220,190,271,202,264,267,246,226,225,185,277,341,272,339,268,182,326,157,340,326,325,178,176,249,248,265,287,75,318,317,326,218,217,187,268,199,261,264,60,243,223,223,222,182,274,338,269,336,265,179,324,323,154,337,239,92,90,156,162,179,202,201,231,241,240,131,101,182,113,175,179,178,157,138,137,136,96,189,188,252,184,183,250,179,94,93,174,237,68,252,251,19,51,105,85,94,181,152,63,44,20,228,227,257,81,80,110,78,108,151,150,180,167,197,189,220,219,220,219,249,228,259,258,66,120,119,149,90,89,119,170,200,102,101,131,163,193,166,197,196,146,145,175,125,156,155,125,124,154,85,84,114,176,207,206,241,240,270,171,202,201,136,239,238,268,167,197,81,112,111,226,225,255,57,56,86,239,270,269,102,49,69,110,167,109,16,119,153,51,55,342,195,193,265,282,305,304,2,334,344,343,234,204,285,216,278,282,281,260,241,240,239,199,292,291,355,287,286,353,282,197,196,340,171,355,354,190,189,43,42,40,83,113,112,129,151,182,181,190,82,81,52,51,132,64,63,125,128,108,107,87,7,87,86,47,46,138,203,202,133,201,200,129,43,188,187,19,18,201,296,149,147,219,236,258,288,297,164,188,158,239,170,232,235,214,194,193,153,245,309,240,178,307,236,150,294,125,308,350,349,184,203,202,37,200,35,172,273,272,107,289,124,311,147,146,342,341,176,350,186,185,242,241,76,212,211,46,292,127,224,223,58,285,120,288,124,123,268,267,102,247,83,82,247,246,81,207,206,41,298,134,133,363,362,197,293,129,128,361,360,195,289,124,203,39,38,348,347,182,179,178,13,361,197,196,191,190,43,41,114,113,130,152,76,183,182,191,83,82,52,133,64,126,129,108,88,183,88,87,47,139,203,134,201,130,44,189,188,19,202,24,150,169,209,203,62,56,60,54,132,126,149,143,171,166,165,201,195,210,205,204,101,95,71,65,152,146,83,77,145,139,148,143,142,127,121,107,102,101,106,100,66,60,158,153,152,222,216,153,148,147,220,214,149,143,63,58,57,207,201,38,32,221,216,215,363,362,215,213,286,285,302,324,83,355,354,363,255,254,224,305,236,298,301,280,260,150,260,259,219,311,375,306,373,302,216,361,360,191,374,230,229,83,82,80,92,153,152,169,191,222,221,230,122,121,92,91,172,104,103,165,168,148,147,127,127,126,87,86,178,243,242,173,131,241,240,169,83,228,227,59,58,241,279,335,132,188,130,186,202,258,219,275,241,298,297,271,327,280,337,336,102,171,227,141,197,222,278,153,209,215,271,218,275,274,197,253,177,234,233,176,232,136,192,228,285,284,292,348,223,280,279,290,346,219,275,133,190,189,277,333,108,164,291,348,347,233,232,85,83,156,155,172,194,146,225,224,233,125,124,94,175,106,168,171,150,130,6,130,129,89,181,245,176,243,172,86,231,230,61,244};
