/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/*!\file nrLDPC_lut.h
 * \brief Header file defining all look-up tables
 * \author Sebastian Wagner (TCL Communications) Email: <mailto:sebastian.wagner@tcl.com>
 * \date 30-09-2019
 * \version 2.0
 * \note
 * \warning
 */

#ifndef __NR_LDPC_LUT__H__
#define __NR_LDPC_LUT__H__

// Circular shifts of base graph
// There are 8 sets of circular shifts depending on Z
// However, each shift is modulo Z
// BG1
// Group of CNs with 3 BNs (CNG3)
// e.g. first and second value correspond to row 4 col 0 and 1 in the BG table (modulo Z)
static const uint16_t circShift_BG1_Z2_CNG3[3][1] = {{1},{0},{0}};
static const uint16_t circShift_BG1_Z3_CNG3[3][1] = {{2},{1},{0}};
static const uint16_t circShift_BG1_Z5_CNG3[3][1] = {{3},{0},{0}};
static const uint16_t circShift_BG1_Z7_CNG3[3][1] = {{2},{3},{0}};
static const uint16_t circShift_BG1_Z9_CNG3[3][1] = {{3},{1},{0}};
static const uint16_t circShift_BG1_Z11_CNG3[3][1] = {{9},{3},{0}};
static const uint16_t circShift_BG1_Z13_CNG3[3][1] = {{11},{9},{0}};
static const uint16_t circShift_BG1_Z15_CNG3[3][1] = {{4},{1},{0}};
static const uint16_t circShift_BG1_Z4_CNG3[3][1] = {{1},{2},{0}};
static const uint16_t circShift_BG1_Z6_CNG3[3][1] = {{2},{1},{0}};
static const uint16_t circShift_BG1_Z10_CNG3[3][1] = {{3},{5},{0}};
static const uint16_t circShift_BG1_Z14_CNG3[3][1] = {{2},{10},{0}};
static const uint16_t circShift_BG1_Z18_CNG3[3][1] = {{12},{1},{0}};
static const uint16_t circShift_BG1_Z22_CNG3[3][1] = {{20},{14},{0}};
static const uint16_t circShift_BG1_Z26_CNG3[3][1] = {{24},{22},{0}};
static const uint16_t circShift_BG1_Z30_CNG3[3][1] = {{4},{1},{0}};
static const uint16_t circShift_BG1_Z8_CNG3[3][1] = {{5},{6},{0}};
static const uint16_t circShift_BG1_Z12_CNG3[3][1] = {{8},{1},{0}};
static const uint16_t circShift_BG1_Z20_CNG3[3][1] = {{13},{5},{0}};
static const uint16_t circShift_BG1_Z28_CNG3[3][1] = {{2},{10},{0}};
static const uint16_t circShift_BG1_Z36_CNG3[3][1] = {{30},{19},{0}};
static const uint16_t circShift_BG1_Z44_CNG3[3][1] = {{42},{36},{0}};
static const uint16_t circShift_BG1_Z52_CNG3[3][1] = {{24},{48},{0}};
static const uint16_t circShift_BG1_Z60_CNG3[3][1] = {{4},{31},{0}};
static const uint16_t circShift_BG1_Z16_CNG3[3][1] = {{13},{6},{0}};
static const uint16_t circShift_BG1_Z24_CNG3[3][1] = {{20},{13},{0}};
static const uint16_t circShift_BG1_Z40_CNG3[3][1] = {{33},{5},{0}};
static const uint16_t circShift_BG1_Z56_CNG3[3][1] = {{2},{10},{0}};
static const uint16_t circShift_BG1_Z72_CNG3[3][1] = {{30},{19},{0}};
static const uint16_t circShift_BG1_Z88_CNG3[3][1] = {{42},{80},{0}};
static const uint16_t circShift_BG1_Z104_CNG3[3][1] = {{24},{100},{0}};
static const uint16_t circShift_BG1_Z120_CNG3[3][1] = {{64},{91},{0}};
static const uint16_t circShift_BG1_Z32_CNG3[3][1] = {{29},{6},{0}};
static const uint16_t circShift_BG1_Z48_CNG3[3][1] = {{44},{37},{0}};
static const uint16_t circShift_BG1_Z80_CNG3[3][1] = {{73},{45},{0}};
static const uint16_t circShift_BG1_Z112_CNG3[3][1] = {{58},{10},{0}};
static const uint16_t circShift_BG1_Z144_CNG3[3][1] = {{102},{91},{0}};
static const uint16_t circShift_BG1_Z176_CNG3[3][1] = {{42},{80},{0}};
static const uint16_t circShift_BG1_Z208_CNG3[3][1] = {{24},{204},{0}};
static const uint16_t circShift_BG1_Z240_CNG3[3][1] = {{64},{211},{0}};
static const uint16_t circShift_BG1_Z64_CNG3[3][1] = {{29},{38},{0}};
static const uint16_t circShift_BG1_Z96_CNG3[3][1] = {{44},{85},{0}};
static const uint16_t circShift_BG1_Z160_CNG3[3][1] = {{73},{45},{0}};
static const uint16_t circShift_BG1_Z224_CNG3[3][1] = {{170},{10},{0}};
static const uint16_t circShift_BG1_Z288_CNG3[3][1] = {{246},{235},{0}};
static const uint16_t circShift_BG1_Z352_CNG3[3][1] = {{42},{256},{0}};
static const uint16_t circShift_BG1_Z128_CNG3[3][1] = {{29},{102},{0}};
static const uint16_t circShift_BG1_Z192_CNG3[3][1] = {{140},{181},{0}};
static const uint16_t circShift_BG1_Z320_CNG3[3][1] = {{233},{205},{0}};
static const uint16_t circShift_BG1_Z256_CNG3[3][1] = {{157},{102},{0}};
static const uint16_t circShift_BG1_Z384_CNG3[3][1] = {{332},{181},{0}};

// Group of CNs with 4 BNs (CNG4) ->[Num BNs][Num of CN with 4 BNs]
static const uint16_t circShift_BG1_Z2_CNG4[4][5] = {{1, 0, 1, 1, 1},{0, 0, 1, 1, 1},{0, 0, 1, 1, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z3_CNG4[4][5] = {{2, 2, 1, 2, 0},{2, 1, 1, 2, 2},{2, 1, 0, 2, 0},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z5_CNG4[4][5] = {{0, 3, 2, 1, 1},{4, 0, 0, 0, 3},{4, 0, 2, 1, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z7_CNG4[4][5] = {{5, 4, 4, 2, 2},{1, 6, 3, 0, 2},{6, 5, 5, 1, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z9_CNG4[4][5] = {{0, 0, 0, 0, 6},{0, 0, 0, 0, 0},{0, 0, 2, 8, 0},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z11_CNG4[4][5] = {{3, 0, 7, 2, 5},{7, 5, 6, 6, 1},{4, 8, 3, 6, 4},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z13_CNG4[4][5] = {{7, 4, 10, 7, 12},{10, 2, 6, 10, 6},{9, 5, 12, 6, 10},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z15_CNG4[4][5] = {{0, 14, 4, 12, 12},{7, 9, 13, 5, 9},{9, 11, 0, 11, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z4_CNG4[4][5] = {{1, 2, 1, 1, 1},{0, 0, 1, 1, 3},{2, 2, 1, 1, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z6_CNG4[4][5] = {{2, 5, 1, 5, 3},{2, 4, 1, 2, 5},{5, 1, 0, 2, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z10_CNG4[4][5] = {{0, 8, 2, 6, 1},{9, 5, 0, 5, 8},{4, 5, 7, 6, 6},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z14_CNG4[4][5] = {{12, 11, 11, 2, 2},{1, 13, 3, 7, 9},{6, 12, 12, 8, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z18_CNG4[4][5] = {{9, 0, 0, 9, 6},{0, 0, 0, 0, 0},{0, 0, 2, 17, 0},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z22_CNG4[4][5] = {{3, 11, 18, 2, 16},{18, 16, 17, 17, 1},{4, 19, 3, 17, 15},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z26_CNG4[4][5] = {{20, 4, 10, 7, 25},{10, 2, 6, 10, 19},{22, 5, 12, 6, 23},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z30_CNG4[4][5] = {{15, 29, 4, 12, 27},{22, 24, 13, 20, 24},{9, 11, 0, 11, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z8_CNG4[4][5] = {{1, 6, 5, 5, 5},{0, 4, 1, 5, 7},{2, 2, 5, 1, 7},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z12_CNG4[4][5] = {{2, 5, 7, 5, 3},{2, 10, 1, 2, 5},{5, 7, 0, 2, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z20_CNG4[4][5] = {{10, 18, 12, 6, 1},{9, 15, 0, 5, 8},{4, 15, 17, 6, 6},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z28_CNG4[4][5] = {{12, 25, 11, 2, 16},{1, 27, 17, 7, 9},{6, 26, 12, 22, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z36_CNG4[4][5] = {{9, 0, 0, 27, 24},{0, 0, 0, 0, 0},{0, 0, 2, 35, 0},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z44_CNG4[4][5] = {{3, 11, 40, 24, 38},{18, 16, 17, 39, 23},{4, 41, 3, 17, 15},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z52_CNG4[4][5] = {{46, 30, 10, 7, 25},{36, 2, 32, 10, 45},{22, 31, 12, 6, 49},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z60_CNG4[4][5] = {{45, 59, 4, 42, 57},{52, 24, 43, 50, 54},{9, 41, 30, 11, 33},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z16_CNG4[4][5] = {{9, 6, 13, 5, 5},{8, 12, 9, 13, 7},{2, 10, 5, 9, 7},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z24_CNG4[4][5] = {{2, 5, 7, 17, 15},{2, 10, 13, 14, 5},{5, 19, 0, 2, 15},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z40_CNG4[4][5] = {{10, 18, 32, 26, 21},{29, 15, 0, 25, 28},{24, 35, 37, 6, 6},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z56_CNG4[4][5] = {{40, 25, 11, 2, 16},{29, 27, 45, 35, 9},{6, 26, 40, 22, 29},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z72_CNG4[4][5] = {{45, 0, 0, 27, 24},{36, 0, 0, 0, 0},{0, 0, 2, 35, 0},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z88_CNG4[4][5] = {{3, 55, 40, 24, 82},{62, 60, 61, 83, 67},{4, 85, 47, 17, 59},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z104_CNG4[4][5] = {{98, 82, 10, 59, 77},{36, 2, 84, 10, 45},{22, 31, 12, 58, 49},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z120_CNG4[4][5] = {{45, 59, 4, 102, 57},{112, 84, 103, 50, 114},{9, 41, 30, 71, 93},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z32_CNG4[4][5] = {{25, 6, 29, 21, 21},{8, 28, 9, 29, 23},{2, 26, 21, 9, 7},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z48_CNG4[4][5] = {{2, 29, 31, 17, 39},{2, 34, 37, 14, 5},{5, 19, 24, 26, 15},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z80_CNG4[4][5] = {{50, 58, 32, 66, 21},{29, 15, 0, 65, 68},{64, 35, 37, 46, 46},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z112_CNG4[4][5] = {{96, 81, 67, 2, 72},{29, 83, 45, 91, 9},{62, 26, 96, 78, 29},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z144_CNG4[4][5] = {{45, 72, 72, 27, 24},{36, 0, 0, 0, 0},{72, 0, 2, 35, 0},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z176_CNG4[4][5] = {{91, 143, 128, 112, 82},{150, 60, 61, 83, 67},{92, 85, 135, 17, 59},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z208_CNG4[4][5] = {{98, 82, 10, 163, 181},{140, 2, 84, 10, 45},{22, 135, 12, 162, 153},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z240_CNG4[4][5] = {{165, 59, 4, 222, 177},{232, 204, 103, 170, 114},{9, 161, 30, 71, 93},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z64_CNG4[4][5] = {{25, 6, 29, 21, 21},{40, 28, 9, 29, 23},{2, 58, 21, 9, 39},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z96_CNG4[4][5] = {{2, 77, 79, 17, 39},{2, 82, 37, 14, 53},{5, 19, 24, 26, 15},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z160_CNG4[4][5] = {{50, 138, 32, 66, 101},{29, 15, 80, 65, 68},{144, 115, 37, 126, 126},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z224_CNG4[4][5] = {{208, 81, 67, 114, 184},{141, 195, 45, 91, 121},{174, 138, 96, 78, 29},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z288_CNG4[4][5] = {{45, 72, 216, 27, 168},{36, 144, 144, 0, 0},{72, 0, 2, 35, 144},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z352_CNG4[4][5] = {{91, 319, 304, 288, 82},{326, 236, 237, 83, 67},{268, 85, 135, 17, 235},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z128_CNG4[4][5] = {{25, 70, 29, 21, 21},{104, 92, 9, 29, 23},{66, 122, 21, 9, 39},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z192_CNG4[4][5] = {{2, 77, 175, 113, 135},{2, 82, 37, 14, 149},{101, 115, 120, 26, 15},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z320_CNG4[4][5] = {{210, 298, 32, 226, 101},{29, 15, 80, 65, 228},{304, 115, 197, 126, 126},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z256_CNG4[4][5] = {{25, 198, 157, 149, 149},{104, 220, 137, 157, 151},{194, 122, 149, 137, 167},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z384_CNG4[4][5] = {{194, 269, 175, 113, 135},{194, 82, 37, 14, 149},{101, 115, 312, 218, 15},{0, 0, 0, 0, 0}};

// Group of CNs with 5 BNs (CNG5) ->[Num BNs][Num of CN with 5 BNs]
static const uint16_t circShift_BG1_Z2_CNG5[5][18] = {{0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1},{0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1},{0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1},{0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z3_CNG5[5][18] = {{0, 0, 0, 2, 0, 0, 0, 1, 0, 2, 2, 2, 0, 2, 0, 1, 2, 2},{2, 2, 2, 0, 1, 2, 1, 2, 0, 2, 1, 2, 1, 0, 0, 2, 0, 0},{2, 1, 2, 1, 1, 0, 2, 0, 1, 1, 1, 2, 0, 1, 1, 1, 0, 1},{1, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0, 2, 0, 1, 0, 0, 0, 1},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z5_CNG5[5][18] = {{2, 4, 2, 0, 1, 2, 1, 2, 0, 0, 2, 2, 4, 1, 2, 4, 3, 4},{0, 0, 0, 0, 3, 3, 3, 3, 2, 0, 1, 3, 4, 4, 2, 2, 4, 2},{0, 3, 1, 3, 0, 2, 0, 1, 1, 0, 0, 0, 3, 4, 2, 4, 1, 4},{1, 0, 1, 2, 4, 4, 0, 2, 2, 3, 4, 0, 0, 1, 3, 2, 2, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z7_CNG5[5][18] = {{4, 4, 1, 2, 6, 3, 6, 0, 3, 2, 5, 3, 5, 4, 5, 2, 3, 0},{0, 0, 5, 1, 6, 4, 4, 0, 6, 0, 4, 5, 3, 6, 0, 5, 1, 4},{3, 0, 2, 2, 0, 4, 0, 2, 2, 0, 5, 5, 0, 3, 0, 4, 1, 2},{1, 3, 4, 1, 2, 5, 4, 2, 2, 4, 3, 5, 6, 3, 2, 6, 0, 5},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z9_CNG5[5][18] = {{0, 0, 7, 0, 5, 0, 0, 0, 0, 0, 8, 1, 0, 1, 0, 0, 7, 0},{0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 8, 7, 0, 0, 0, 0, 0},{0, 0, 0, 0, 2, 0, 0, 4, 0, 4, 0, 0, 0, 0, 3, 0, 0, 0},{5, 3, 3, 7, 8, 6, 2, 1, 0, 0, 0, 7, 0, 0, 0, 3, 0, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z11_CNG5[5][18] = {{5, 7, 4, 6, 3, 9, 6, 2, 10, 1, 5, 1, 3, 10, 5, 2, 1, 2},{3, 6, 2, 7, 1, 5, 5, 0, 1, 7, 1, 1, 4, 9, 0, 0, 3, 2},{5, 5, 1, 6, 7, 1, 7, 4, 8, 9, 2, 8, 2, 0, 4, 3, 9, 7},{3, 7, 10, 0, 2, 8, 3, 2, 6, 2, 10, 4, 1, 4, 8, 8, 2, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z13_CNG5[5][18] = {{5, 6, 4, 8, 4, 1, 2, 4, 6, 10, 4, 4, 6, 0, 4, 2, 1, 4},{6, 5, 9, 12, 1, 6, 10, 10, 9, 4, 10, 6, 5, 12, 2, 10, 7, 6},{0, 2, 3, 10, 1, 2, 8, 8, 11, 6, 2, 12, 8, 3, 5, 12, 8, 12},{1, 9, 2, 2, 2, 6, 7, 12, 7, 1, 12, 3, 4, 9, 6, 11, 7, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z15_CNG5[5][18] = {{10, 5, 12, 13, 2, 7, 5, 13, 13, 4, 11, 6, 11, 1, 10, 8, 7, 11},{2, 7, 6, 11, 13, 2, 4, 14, 5, 12, 12, 9, 12, 0, 8, 9, 7, 1},{6, 12, 11, 4, 5, 13, 11, 10, 1, 7, 7, 10, 12, 11, 3, 5, 4, 7},{13, 4, 1, 8, 10, 13, 0, 3, 1, 5, 0, 10, 10, 5, 7, 9, 5, 13},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z4_CNG5[5][18] = {{0, 0, 3, 3, 0, 2, 0, 3, 1, 2, 3, 1, 1, 3, 1, 3, 3, 3},{2, 3, 0, 3, 1, 0, 1, 1, 0, 3, 3, 1, 1, 3, 3, 1, 3, 1},{0, 2, 0, 3, 1, 0, 0, 0, 3, 1, 0, 3, 3, 1, 1, 3, 1, 3},{2, 0, 2, 1, 3, 2, 1, 1, 1, 3, 3, 3, 0, 3, 0, 3, 3, 1},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z6_CNG5[5][18] = {{0, 0, 0, 5, 0, 0, 3, 4, 0, 5, 2, 2, 0, 5, 0, 4, 5, 2},{5, 5, 5, 3, 1, 5, 1, 5, 3, 2, 4, 5, 1, 3, 3, 2, 0, 0},{5, 1, 5, 4, 4, 3, 2, 0, 1, 1, 4, 2, 3, 1, 4, 1, 0, 1},{4, 3, 0, 4, 4, 0, 0, 4, 5, 3, 0, 2, 3, 4, 3, 0, 0, 4},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z10_CNG5[5][18] = {{7, 9, 2, 0, 1, 7, 1, 2, 0, 0, 7, 7, 9, 1, 2, 4, 8, 4},{0, 0, 5, 0, 3, 8, 3, 8, 2, 0, 6, 8, 9, 9, 7, 7, 9, 7},{5, 3, 6, 8, 0, 7, 5, 6, 1, 0, 5, 5, 8, 4, 2, 4, 6, 9},{6, 5, 6, 7, 4, 9, 5, 2, 7, 3, 4, 5, 0, 1, 8, 7, 2, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z14_CNG5[5][18] = {{11, 4, 1, 9, 6, 10, 6, 7, 10, 2, 12, 10, 12, 11, 12, 9, 10, 0},{0, 7, 12, 8, 13, 11, 4, 7, 13, 7, 4, 5, 3, 6, 7, 5, 8, 4},{3, 0, 9, 2, 7, 11, 0, 9, 2, 7, 12, 12, 0, 3, 7, 4, 8, 9},{8, 10, 11, 1, 2, 12, 11, 2, 2, 11, 10, 5, 6, 10, 2, 13, 7, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z18_CNG5[5][18] = {{0, 0, 7, 0, 5, 0, 0, 0, 0, 0, 17, 1, 0, 10, 9, 0, 16, 0},{9, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 8, 16, 0, 0, 0, 9, 0},{0, 0, 0, 0, 11, 0, 0, 4, 0, 4, 0, 0, 0, 0, 3, 0, 0, 0},{5, 3, 3, 7, 8, 6, 11, 1, 0, 0, 0, 7, 0, 0, 9, 3, 0, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z22_CNG5[5][18] = {{16, 18, 15, 17, 14, 9, 17, 13, 21, 12, 16, 12, 3, 10, 16, 13, 12, 13},{3, 6, 13, 18, 1, 16, 16, 11, 1, 18, 12, 12, 15, 20, 0, 11, 3, 2},{16, 5, 1, 6, 18, 1, 7, 15, 8, 9, 2, 19, 13, 11, 15, 3, 9, 7},{3, 18, 10, 11, 13, 19, 14, 2, 17, 13, 10, 4, 12, 4, 8, 8, 13, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z26_CNG5[5][18] = {{18, 19, 4, 21, 4, 14, 2, 4, 6, 10, 4, 4, 6, 13, 4, 2, 1, 4},{6, 18, 22, 12, 1, 6, 10, 23, 22, 4, 23, 19, 18, 12, 2, 23, 7, 6},{0, 2, 16, 10, 14, 2, 8, 21, 11, 6, 15, 12, 21, 16, 5, 12, 21, 12},{1, 22, 2, 15, 15, 6, 20, 12, 20, 14, 25, 3, 17, 22, 6, 24, 20, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z30_CNG5[5][18] = {{25, 5, 27, 13, 2, 22, 20, 13, 13, 19, 11, 21, 11, 1, 25, 23, 22, 11},{17, 7, 21, 11, 13, 2, 19, 29, 20, 12, 27, 24, 27, 0, 8, 9, 7, 1},{6, 27, 11, 19, 20, 28, 26, 25, 1, 22, 22, 25, 12, 26, 18, 5, 19, 7},{28, 19, 1, 8, 25, 13, 15, 18, 1, 5, 0, 10, 10, 20, 22, 24, 5, 28},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z8_CNG5[5][18] = {{0, 4, 7, 3, 0, 6, 0, 7, 5, 2, 7, 1, 5, 7, 5, 7, 7, 3},{6, 3, 0, 3, 5, 4, 1, 1, 0, 3, 7, 5, 1, 7, 3, 5, 3, 5},{4, 2, 4, 7, 5, 4, 0, 4, 7, 1, 4, 7, 3, 5, 5, 3, 5, 3},{6, 0, 6, 5, 7, 6, 1, 5, 1, 3, 7, 7, 0, 3, 0, 7, 3, 5},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z12_CNG5[5][18] = {{6, 0, 0, 11, 6, 0, 3, 4, 6, 11, 2, 8, 6, 5, 6, 4, 5, 8},{11, 5, 5, 9, 7, 5, 1, 11, 9, 8, 4, 11, 1, 9, 9, 2, 0, 6},{5, 1, 11, 4, 4, 3, 8, 6, 7, 1, 10, 2, 9, 1, 10, 7, 6, 7},{10, 3, 0, 4, 10, 6, 6, 4, 11, 9, 0, 2, 9, 10, 9, 0, 0, 10},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z20_CNG5[5][18] = {{17, 9, 12, 10, 11, 7, 11, 2, 10, 10, 7, 7, 19, 11, 2, 14, 8, 14},{0, 10, 15, 10, 13, 8, 3, 8, 2, 0, 16, 18, 19, 19, 17, 7, 9, 7},{15, 13, 16, 18, 10, 17, 5, 6, 11, 0, 5, 15, 18, 4, 12, 4, 16, 19},{16, 5, 6, 7, 14, 9, 15, 2, 17, 13, 4, 5, 0, 1, 8, 7, 2, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z28_CNG5[5][18] = {{25, 4, 1, 23, 6, 10, 6, 7, 24, 2, 26, 24, 26, 11, 12, 23, 10, 0},{0, 7, 26, 8, 13, 11, 18, 21, 13, 21, 18, 5, 17, 6, 21, 19, 22, 4},{3, 0, 9, 16, 21, 25, 14, 9, 2, 21, 12, 26, 0, 17, 21, 4, 22, 9},{8, 10, 25, 15, 2, 12, 11, 16, 2, 25, 10, 19, 6, 10, 2, 27, 21, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z36_CNG5[5][18] = {{0, 0, 25, 0, 23, 0, 0, 0, 0, 0, 17, 19, 0, 10, 9, 0, 16, 18},{9, 0, 0, 0, 0, 0, 18, 0, 31, 0, 0, 26, 16, 0, 0, 0, 27, 0},{0, 0, 0, 0, 11, 0, 0, 22, 0, 4, 0, 0, 0, 0, 21, 0, 0, 0},{5, 21, 3, 25, 26, 6, 29, 19, 18, 18, 0, 25, 0, 0, 9, 3, 18, 21},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z44_CNG5[5][18] = {{16, 18, 15, 17, 14, 9, 39, 13, 43, 12, 16, 12, 3, 32, 16, 35, 34, 35},{25, 6, 35, 18, 1, 16, 16, 33, 1, 40, 12, 34, 15, 20, 0, 33, 3, 24},{16, 5, 23, 6, 40, 23, 7, 15, 30, 9, 24, 19, 35, 33, 37, 25, 9, 29},{25, 40, 10, 11, 35, 19, 36, 2, 39, 13, 10, 4, 12, 26, 8, 8, 35, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z52_CNG5[5][18] = {{44, 45, 4, 21, 4, 40, 2, 4, 6, 10, 4, 4, 6, 39, 4, 2, 1, 4},{6, 18, 22, 38, 1, 32, 36, 49, 22, 30, 49, 45, 44, 12, 28, 23, 7, 6},{26, 28, 16, 36, 40, 2, 8, 21, 11, 6, 41, 12, 21, 42, 5, 38, 47, 38},{27, 48, 28, 41, 41, 6, 20, 38, 20, 40, 51, 29, 43, 48, 32, 24, 46, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z60_CNG5[5][18] = {{25, 5, 27, 43, 32, 52, 50, 13, 43, 19, 41, 51, 11, 1, 55, 53, 22, 11},{47, 7, 21, 11, 43, 32, 19, 29, 50, 12, 57, 54, 27, 30, 8, 9, 7, 31},{6, 57, 11, 49, 20, 58, 26, 55, 31, 52, 22, 25, 42, 26, 48, 35, 49, 7},{58, 19, 1, 38, 25, 43, 45, 48, 31, 5, 0, 40, 40, 20, 52, 24, 5, 28},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z16_CNG5[5][18] = {{0, 12, 7, 3, 0, 6, 8, 15, 13, 2, 15, 1, 5, 7, 13, 7, 7, 11},{14, 3, 8, 3, 5, 12, 9, 1, 0, 11, 7, 5, 9, 7, 11, 13, 3, 13},{12, 10, 4, 7, 5, 4, 8, 12, 7, 9, 4, 15, 3, 13, 5, 11, 13, 3},{14, 8, 6, 13, 15, 6, 9, 13, 9, 3, 15, 7, 8, 3, 0, 7, 11, 13},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z24_CNG5[5][18] = {{6, 0, 0, 23, 6, 12, 15, 4, 6, 11, 14, 8, 18, 17, 18, 4, 17, 8},{11, 17, 17, 9, 19, 5, 13, 23, 9, 8, 4, 23, 1, 9, 21, 2, 12, 6},{17, 13, 23, 4, 4, 3, 20, 18, 7, 1, 10, 2, 9, 1, 10, 19, 18, 19},{22, 3, 0, 16, 10, 6, 18, 16, 23, 9, 0, 2, 21, 22, 9, 0, 0, 10},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z40_CNG5[5][18] = {{17, 9, 12, 30, 11, 27, 11, 22, 10, 10, 27, 7, 19, 31, 22, 34, 28, 34},{20, 10, 15, 30, 13, 28, 23, 28, 22, 20, 16, 38, 19, 19, 37, 7, 29, 27},{15, 13, 16, 38, 10, 37, 25, 26, 31, 20, 5, 15, 18, 24, 32, 4, 16, 19},{36, 25, 6, 27, 34, 29, 15, 2, 17, 33, 4, 5, 0, 21, 8, 7, 22, 20},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z56_CNG5[5][18] = {{53, 32, 1, 51, 34, 38, 34, 7, 24, 2, 26, 24, 54, 11, 12, 23, 38, 28},{0, 35, 54, 8, 41, 11, 18, 49, 41, 49, 18, 5, 45, 34, 21, 47, 22, 4},{3, 0, 9, 44, 49, 53, 42, 9, 2, 49, 12, 26, 0, 17, 49, 4, 22, 9},{36, 10, 25, 15, 2, 12, 11, 16, 30, 25, 38, 19, 6, 10, 2, 55, 49, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z72_CNG5[5][18] = {{0, 36, 61, 0, 59, 0, 0, 0, 0, 0, 53, 55, 0, 46, 9, 0, 52, 18},{45, 0, 0, 0, 0, 36, 18, 0, 67, 0, 0, 62, 16, 0, 0, 0, 27, 0},{0, 0, 0, 0, 11, 0, 36, 22, 36, 4, 36, 0, 0, 0, 21, 0, 0, 0},{41, 21, 39, 61, 62, 42, 29, 19, 18, 18, 0, 61, 0, 0, 45, 39, 54, 57},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z88_CNG5[5][18] = {{16, 18, 15, 61, 14, 9, 83, 13, 87, 56, 60, 12, 47, 76, 60, 35, 34, 79},{69, 6, 79, 62, 1, 16, 16, 33, 1, 40, 56, 34, 15, 20, 0, 77, 3, 68},{60, 5, 23, 50, 40, 67, 7, 15, 74, 53, 24, 19, 35, 33, 37, 25, 53, 29},{25, 40, 54, 11, 79, 19, 36, 46, 83, 13, 54, 4, 12, 70, 8, 8, 79, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z104_CNG5[5][18] = {{44, 45, 4, 21, 4, 92, 2, 4, 6, 10, 4, 4, 6, 91, 4, 2, 1, 4},{58, 18, 74, 38, 1, 32, 88, 49, 22, 30, 49, 45, 96, 64, 28, 75, 59, 6},{26, 28, 16, 88, 40, 2, 8, 21, 63, 6, 93, 64, 73, 94, 5, 38, 99, 38},{27, 100, 28, 93, 93, 6, 20, 90, 20, 92, 51, 81, 43, 100, 84, 24, 98, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z120_CNG5[5][18] = {{25, 65, 27, 43, 32, 112, 50, 73, 103, 79, 41, 111, 11, 1, 115, 53, 22, 71},{47, 7, 21, 11, 43, 32, 79, 29, 110, 12, 117, 54, 87, 90, 68, 69, 7, 91},{6, 117, 11, 49, 80, 118, 26, 55, 31, 52, 22, 25, 42, 26, 48, 95, 49, 67},{58, 79, 61, 98, 85, 103, 105, 108, 91, 65, 60, 100, 100, 20, 52, 24, 5, 28},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z32_CNG5[5][18] = {{0, 28, 23, 3, 0, 22, 24, 31, 29, 2, 31, 1, 5, 7, 13, 7, 23, 11},{14, 19, 8, 19, 5, 12, 9, 17, 16, 27, 7, 5, 9, 23, 11, 13, 3, 29},{28, 10, 20, 23, 21, 20, 24, 12, 7, 9, 4, 15, 19, 29, 21, 11, 13, 3},{30, 24, 22, 29, 31, 6, 9, 29, 25, 19, 31, 7, 24, 3, 0, 23, 11, 13},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z48_CNG5[5][18] = {{30, 24, 24, 23, 30, 12, 15, 4, 6, 35, 38, 32, 18, 41, 18, 4, 17, 32},{11, 41, 17, 33, 19, 5, 37, 23, 9, 8, 4, 47, 25, 33, 45, 26, 36, 30},{41, 13, 47, 28, 4, 3, 20, 18, 31, 25, 10, 2, 9, 1, 10, 43, 18, 19},{22, 27, 24, 40, 34, 30, 42, 16, 47, 9, 24, 26, 21, 22, 9, 0, 24, 34},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z80_CNG5[5][18] = {{17, 9, 12, 30, 11, 27, 11, 62, 50, 10, 27, 47, 19, 71, 22, 74, 68, 74},{20, 50, 55, 30, 53, 68, 23, 68, 22, 20, 56, 78, 19, 19, 77, 47, 69, 67},{55, 53, 16, 78, 50, 37, 25, 66, 31, 60, 5, 55, 18, 64, 32, 44, 16, 19},{76, 25, 46, 67, 74, 29, 55, 2, 57, 33, 44, 45, 0, 21, 48, 47, 22, 20},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z112_CNG5[5][18] = {{53, 88, 1, 107, 34, 38, 34, 63, 80, 2, 82, 80, 110, 11, 12, 23, 94, 84},{0, 91, 54, 64, 41, 11, 18, 49, 97, 49, 74, 61, 45, 90, 77, 103, 22, 4},{3, 56, 65, 100, 105, 53, 98, 65, 58, 49, 68, 26, 0, 73, 49, 60, 22, 9},{36, 10, 81, 15, 2, 68, 11, 16, 30, 25, 38, 75, 6, 10, 2, 55, 49, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z144_CNG5[5][18] = {{72, 36, 61, 0, 131, 0, 0, 0, 0, 0, 53, 55, 72, 46, 9, 0, 52, 18},{45, 0, 0, 0, 0, 36, 90, 0, 67, 0, 0, 134, 16, 0, 0, 0, 99, 0},{72, 0, 0, 0, 11, 0, 108, 22, 36, 76, 108, 0, 0, 0, 21, 0, 0, 0},{113, 21, 39, 133, 62, 42, 29, 19, 18, 18, 0, 61, 0, 0, 117, 39, 126, 57},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z176_CNG5[5][18] = {{104, 18, 103, 149, 102, 97, 171, 101, 175, 56, 60, 100, 135, 164, 60, 123, 34, 79},{157, 6, 79, 150, 1, 104, 16, 121, 89, 128, 144, 34, 15, 20, 88, 77, 3, 68},{60, 5, 111, 50, 40, 67, 95, 103, 162, 141, 112, 19, 35, 33, 37, 25, 53, 117},{113, 128, 54, 99, 167, 107, 36, 46, 83, 101, 54, 92, 12, 70, 96, 96, 167, 96},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z208_CNG5[5][18] = {{44, 45, 4, 21, 4, 92, 2, 4, 6, 10, 4, 4, 6, 91, 4, 2, 1, 4},{58, 18, 74, 142, 1, 136, 88, 49, 126, 30, 153, 45, 200, 64, 28, 75, 163, 6},{130, 132, 16, 192, 40, 106, 112, 125, 63, 6, 197, 168, 177, 198, 109, 142, 99, 142},{131, 100, 28, 197, 93, 6, 20, 194, 20, 92, 155, 185, 43, 100, 188, 128, 98, 3},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z240_CNG5[5][18] = {{25, 185, 27, 163, 32, 232, 170, 73, 103, 199, 161, 231, 11, 121, 115, 53, 22, 191},{47, 127, 141, 131, 43, 32, 199, 149, 110, 132, 237, 174, 207, 90, 188, 189, 127, 211},{126, 117, 11, 169, 200, 118, 26, 175, 151, 172, 142, 145, 42, 26, 168, 215, 49, 187},{178, 199, 181, 98, 205, 103, 105, 108, 211, 65, 180, 100, 100, 140, 52, 24, 125, 148},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z64_CNG5[5][18] = {{0, 28, 23, 3, 0, 22, 24, 31, 29, 2, 63, 33, 37, 39, 45, 39, 23, 11},{14, 19, 8, 51, 37, 44, 9, 49, 48, 59, 39, 5, 41, 23, 11, 45, 35, 29},{60, 42, 52, 23, 53, 20, 56, 44, 7, 41, 36, 15, 51, 29, 21, 11, 45, 35},{30, 24, 54, 61, 63, 6, 9, 61, 57, 19, 31, 39, 56, 35, 0, 23, 11, 45},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z96_CNG5[5][18] = {{30, 24, 72, 71, 30, 60, 63, 4, 6, 35, 38, 32, 18, 89, 66, 52, 17, 80},{11, 89, 17, 81, 19, 5, 37, 23, 9, 8, 52, 47, 25, 81, 93, 26, 36, 78},{41, 61, 95, 76, 52, 51, 68, 66, 79, 73, 10, 2, 9, 1, 58, 43, 18, 67},{22, 27, 24, 40, 82, 78, 90, 64, 95, 9, 24, 74, 21, 22, 9, 0, 72, 82},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z160_CNG5[5][18] = {{17, 89, 12, 110, 11, 27, 91, 62, 50, 10, 27, 47, 99, 151, 102, 154, 68, 74},{20, 50, 135, 110, 133, 148, 23, 148, 22, 20, 136, 158, 19, 19, 77, 47, 69, 67},{55, 133, 96, 158, 50, 117, 105, 66, 111, 140, 5, 55, 18, 64, 32, 124, 16, 99},{156, 105, 46, 67, 74, 29, 135, 2, 57, 33, 44, 125, 0, 21, 48, 47, 102, 100},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z224_CNG5[5][18] = {{53, 88, 1, 107, 146, 150, 34, 175, 192, 114, 82, 192, 222, 123, 12, 23, 206, 84},{0, 203, 166, 176, 153, 11, 130, 49, 209, 49, 186, 173, 157, 90, 77, 215, 22, 4},{3, 168, 65, 212, 217, 53, 210, 177, 58, 161, 68, 26, 0, 73, 49, 60, 134, 9},{148, 122, 81, 127, 114, 68, 123, 128, 30, 137, 150, 187, 6, 10, 114, 167, 161, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z288_CNG5[5][18] = {{72, 180, 205, 0, 275, 0, 0, 144, 0, 0, 197, 199, 216, 190, 153, 0, 52, 18},{189, 0, 0, 0, 0, 180, 90, 144, 211, 0, 0, 278, 16, 0, 0, 0, 243, 0},{72, 0, 0, 0, 155, 0, 252, 166, 36, 76, 108, 0, 0, 0, 165, 0, 0, 0},{257, 165, 183, 277, 62, 42, 173, 19, 162, 18, 0, 205, 0, 0, 117, 183, 270, 57},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z352_CNG5[5][18] = {{280, 18, 279, 325, 102, 273, 171, 101, 351, 56, 60, 100, 135, 164, 236, 123, 210, 79},{157, 6, 255, 326, 1, 104, 16, 297, 265, 304, 320, 210, 15, 196, 264, 77, 3, 244},{236, 181, 111, 226, 40, 243, 95, 279, 338, 141, 112, 195, 35, 209, 37, 25, 53, 293},{113, 304, 54, 99, 167, 107, 212, 222, 83, 101, 54, 268, 188, 246, 272, 272, 167, 272},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z128_CNG5[5][18] = {{64, 28, 23, 67, 0, 86, 88, 95, 93, 2, 127, 33, 37, 39, 45, 39, 23, 11},{14, 19, 8, 115, 37, 108, 73, 49, 112, 59, 39, 69, 105, 23, 11, 45, 35, 29},{60, 42, 116, 87, 53, 84, 120, 44, 71, 41, 36, 79, 51, 29, 21, 11, 45, 35},{30, 24, 54, 61, 63, 6, 9, 61, 121, 83, 31, 103, 120, 35, 0, 23, 11, 45},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z192_CNG5[5][18] = {{30, 24, 72, 71, 30, 60, 159, 100, 102, 131, 38, 128, 18, 185, 66, 52, 113, 80},{11, 89, 17, 81, 19, 5, 37, 23, 9, 8, 148, 143, 121, 177, 93, 122, 132, 78},{41, 61, 191, 76, 52, 147, 68, 66, 175, 169, 10, 2, 105, 97, 154, 139, 114, 163},{22, 27, 120, 136, 82, 78, 90, 64, 95, 105, 120, 74, 21, 22, 105, 96, 168, 82},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z320_CNG5[5][18] = {{177, 249, 172, 270, 11, 27, 91, 222, 210, 170, 187, 207, 259, 151, 102, 154, 228, 234},{20, 50, 295, 110, 293, 308, 23, 308, 22, 20, 296, 158, 179, 179, 77, 47, 69, 227},{55, 133, 96, 318, 50, 117, 105, 66, 271, 140, 5, 55, 178, 64, 192, 124, 176, 259},{316, 105, 46, 67, 234, 29, 135, 162, 217, 33, 44, 285, 160, 181, 208, 207, 102, 260},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z256_CNG5[5][18] = {{64, 156, 23, 195, 128, 86, 216, 95, 221, 2, 127, 161, 37, 167, 173, 167, 151, 139},{142, 147, 136, 243, 165, 236, 73, 177, 112, 187, 167, 197, 105, 151, 139, 173, 163, 157},{188, 170, 116, 215, 181, 84, 120, 172, 199, 41, 164, 207, 51, 157, 149, 139, 173, 163},{158, 152, 182, 61, 63, 6, 9, 61, 121, 211, 159, 103, 120, 163, 0, 151, 139, 173},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z384_CNG5[5][18] = {{30, 24, 72, 71, 222, 252, 159, 100, 102, 323, 230, 320, 210, 185, 258, 52, 113, 80},{11, 89, 17, 81, 19, 5, 229, 215, 201, 8, 148, 335, 313, 177, 93, 314, 132, 78},{233, 61, 383, 76, 244, 147, 260, 258, 175, 361, 202, 2, 297, 289, 346, 139, 114, 163},{22, 27, 312, 136, 274, 78, 90, 256, 287, 105, 312, 266, 21, 214, 297, 288, 168, 274},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

// Group of CNs with 6 BNs (CNG6) ->[Num BNs][Num of CN with 6 BNs]
static const uint16_t circShift_BG1_Z2_CNG6[6][8] = {{1, 0, 1, 0, 0, 1, 1, 0},{0, 1, 0, 1, 1, 0, 1, 0},{1, 1, 1, 0, 0, 1, 1, 0},{1, 1, 1, 1, 1, 1, 1, 0},{0, 0, 0, 1, 0, 0, 1, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z3_CNG6[6][8] = {{1, 1, 2, 1, 1, 1, 1, 1},{0, 2, 0, 1, 0, 2, 0, 2},{2, 0, 0, 1, 2, 0, 1, 1},{1, 1, 1, 0, 2, 2, 0, 0},{1, 0, 0, 1, 2, 2, 1, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z5_CNG6[6][8] = {{4, 4, 2, 0, 4, 1, 4, 4},{2, 0, 2, 4, 1, 2, 0, 0},{3, 0, 3, 1, 1, 0, 2, 0},{0, 0, 1, 1, 0, 0, 3, 2},{2, 0, 3, 0, 1, 0, 3, 1},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z7_CNG6[6][8] = {{4, 0, 0, 3, 1, 0, 3, 0},{0, 3, 5, 5, 6, 0, 5, 3},{2, 1, 4, 4, 5, 2, 3, 1},{0, 0, 0, 3, 2, 4, 1, 4},{1, 3, 4, 4, 1, 1, 1, 5},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z9_CNG6[6][8] = {{6, 0, 0, 8, 0, 4, 1, 2},{0, 4, 2, 7, 0, 0, 1, 1},{0, 0, 0, 0, 1, 0, 5, 0},{2, 0, 0, 7, 0, 0, 0, 5},{0, 0, 0, 0, 0, 3, 0, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z11_CNG6[6][8] = {{3, 3, 0, 3, 10, 1, 8, 5},{9, 7, 8, 0, 0, 10, 0, 5},{1, 2, 5, 4, 4, 1, 5, 7},{6, 1, 6, 5, 5, 2, 0, 2},{4, 4, 3, 7, 6, 8, 10, 7},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z13_CNG6[6][8] = {{0, 10, 0, 1, 12, 6, 6, 9},{4, 3, 2, 2, 6, 12, 8, 8},{1, 4, 4, 11, 10, 2, 5, 9},{3, 5, 3, 3, 2, 5, 3, 2},{7, 0, 12, 5, 9, 4, 4, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z15_CNG6[6][8] = {{10, 3, 3, 3, 14, 2, 2, 2},{5, 2, 7, 5, 3, 7, 2, 13},{4, 9, 1, 0, 9, 8, 5, 2},{13, 5, 9, 8, 3, 2, 5, 6},{0, 10, 9, 14, 1, 10, 6, 13},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z4_CNG6[6][8] = {{1, 0, 3, 2, 0, 3, 1, 0},{0, 1, 0, 1, 1, 2, 1, 2},{3, 1, 3, 0, 0, 1, 1, 0},{1, 3, 1, 3, 3, 3, 3, 0},{2, 2, 0, 3, 0, 0, 3, 2},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z6_CNG6[6][8] = {{1, 1, 2, 4, 1, 1, 1, 4},{3, 2, 3, 1, 3, 2, 0, 2},{2, 3, 3, 4, 2, 0, 4, 1},{1, 1, 4, 0, 2, 5, 3, 3},{4, 3, 3, 4, 5, 5, 1, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z10_CNG6[6][8] = {{9, 9, 7, 0, 4, 1, 9, 9},{2, 0, 7, 4, 1, 2, 5, 0},{3, 5, 8, 1, 1, 0, 2, 0},{0, 5, 1, 1, 0, 0, 3, 7},{7, 0, 8, 5, 1, 0, 3, 1},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z14_CNG6[6][8] = {{11, 0, 0, 3, 8, 7, 10, 7},{0, 10, 12, 12, 6, 0, 5, 3},{2, 1, 4, 4, 5, 9, 10, 8},{7, 7, 7, 3, 2, 4, 8, 11},{8, 3, 4, 4, 8, 1, 8, 12},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z18_CNG6[6][8] = {{15, 0, 9, 17, 0, 13, 10, 2},{0, 13, 11, 7, 0, 9, 10, 1},{0, 9, 0, 0, 10, 0, 14, 0},{11, 0, 0, 7, 0, 0, 9, 14},{0, 0, 0, 0, 0, 12, 0, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z22_CNG6[6][8] = {{3, 14, 0, 3, 21, 1, 8, 16},{9, 7, 8, 0, 0, 21, 0, 16},{1, 2, 5, 4, 15, 1, 16, 7},{6, 1, 6, 5, 16, 2, 11, 2},{15, 4, 14, 7, 6, 8, 21, 18},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z26_CNG6[6][8] = {{0, 10, 13, 1, 12, 6, 6, 9},{17, 16, 2, 15, 6, 12, 8, 21},{1, 4, 4, 11, 10, 15, 18, 9},{16, 18, 3, 16, 2, 5, 16, 2},{20, 0, 25, 18, 9, 4, 17, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z30_CNG6[6][8] = {{10, 18, 3, 3, 29, 17, 17, 2},{5, 2, 22, 5, 18, 7, 2, 28},{4, 24, 16, 0, 9, 23, 5, 2},{28, 5, 9, 23, 18, 17, 5, 6},{0, 25, 9, 14, 16, 10, 6, 28},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z8_CNG6[6][8] = {{1, 0, 7, 2, 4, 7, 1, 0},{0, 1, 4, 1, 1, 2, 1, 6},{7, 1, 3, 0, 0, 1, 5, 4},{1, 3, 1, 3, 7, 7, 3, 4},{6, 2, 0, 3, 0, 0, 3, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z12_CNG6[6][8] = {{1, 1, 8, 10, 1, 7, 1, 10},{9, 2, 3, 7, 9, 2, 6, 2},{2, 9, 9, 4, 8, 0, 4, 7},{7, 1, 10, 0, 2, 5, 9, 3},{10, 9, 3, 4, 5, 11, 1, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z20_CNG6[6][8] = {{19, 9, 17, 0, 4, 1, 19, 9},{2, 0, 7, 14, 1, 2, 15, 0},{3, 5, 8, 11, 1, 0, 12, 10},{0, 15, 11, 1, 10, 10, 3, 7},{17, 0, 8, 15, 1, 10, 3, 1},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z28_CNG6[6][8] = {{25, 14, 0, 3, 8, 21, 24, 21},{0, 24, 26, 26, 6, 14, 19, 17},{16, 15, 4, 4, 19, 9, 24, 8},{21, 21, 7, 3, 2, 18, 22, 25},{22, 17, 4, 18, 8, 15, 22, 12},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z36_CNG6[6][8] = {{15, 18, 9, 17, 0, 13, 28, 20},{0, 13, 29, 7, 0, 9, 10, 19},{0, 27, 0, 0, 10, 18, 14, 0},{11, 18, 0, 25, 0, 0, 9, 14},{0, 0, 18, 0, 0, 12, 18, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z44_CNG6[6][8] = {{3, 14, 22, 3, 43, 1, 30, 38},{31, 29, 8, 22, 22, 21, 0, 38},{1, 24, 27, 26, 15, 23, 38, 29},{6, 23, 28, 5, 38, 24, 11, 24},{37, 26, 14, 29, 28, 30, 21, 18},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z52_CNG6[6][8] = {{0, 36, 39, 1, 12, 6, 6, 9},{43, 42, 28, 41, 6, 12, 34, 21},{1, 4, 30, 11, 10, 15, 44, 35},{16, 18, 3, 16, 28, 5, 42, 28},{46, 26, 51, 44, 35, 30, 43, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z60_CNG6[6][8] = {{40, 18, 3, 3, 59, 17, 17, 32},{5, 32, 52, 35, 48, 7, 2, 58},{34, 24, 46, 0, 39, 23, 35, 2},{58, 5, 39, 23, 18, 47, 5, 36},{30, 25, 9, 14, 16, 10, 36, 58},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z16_CNG6[6][8] = {{1, 0, 7, 10, 12, 7, 9, 0},{8, 1, 4, 9, 9, 10, 9, 6},{7, 1, 11, 8, 8, 9, 13, 12},{9, 3, 1, 11, 15, 15, 3, 4},{14, 10, 0, 3, 0, 0, 11, 14},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z24_CNG6[6][8] = {{1, 13, 20, 10, 1, 19, 13, 10},{9, 2, 15, 19, 21, 14, 6, 14},{2, 9, 9, 16, 8, 0, 16, 19},{19, 1, 22, 12, 2, 5, 21, 3},{10, 9, 15, 4, 5, 11, 1, 18},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z40_CNG6[6][8] = {{39, 29, 17, 20, 24, 21, 39, 9},{22, 20, 27, 14, 21, 2, 15, 0},{23, 5, 8, 11, 21, 0, 12, 30},{0, 35, 11, 21, 30, 10, 3, 27},{37, 20, 28, 15, 1, 10, 23, 1},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z56_CNG6[6][8] = {{25, 42, 0, 31, 8, 49, 24, 49},{0, 52, 54, 54, 6, 42, 19, 45},{16, 43, 32, 32, 47, 9, 52, 8},{49, 21, 7, 31, 30, 46, 50, 25},{22, 45, 4, 18, 8, 15, 50, 12},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z72_CNG6[6][8] = {{15, 54, 9, 17, 0, 49, 64, 20},{0, 13, 65, 7, 0, 9, 46, 55},{0, 27, 0, 0, 46, 18, 50, 0},{47, 54, 0, 25, 0, 0, 9, 50},{36, 0, 18, 0, 0, 12, 18, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z88_CNG6[6][8] = {{47, 14, 22, 47, 87, 1, 74, 38},{75, 29, 52, 22, 22, 65, 0, 82},{1, 68, 71, 70, 59, 67, 82, 73},{6, 67, 28, 5, 82, 68, 55, 24},{81, 26, 14, 73, 28, 30, 21, 18},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z104_CNG6[6][8] = {{52, 88, 91, 1, 12, 6, 6, 9},{43, 94, 80, 41, 6, 12, 86, 21},{1, 56, 30, 63, 62, 15, 96, 87},{16, 18, 3, 68, 80, 5, 42, 28},{46, 78, 51, 44, 87, 30, 95, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z120_CNG6[6][8] = {{100, 78, 63, 63, 59, 77, 77, 32},{65, 32, 112, 95, 108, 67, 2, 58},{34, 84, 106, 60, 39, 83, 95, 2},{58, 5, 99, 23, 18, 47, 65, 36},{30, 85, 9, 14, 76, 10, 96, 58},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z32_CNG6[6][8] = {{17, 0, 7, 10, 28, 23, 25, 16},{24, 17, 4, 9, 9, 26, 25, 22},{23, 17, 27, 8, 8, 25, 13, 12},{25, 19, 1, 27, 31, 15, 3, 20},{30, 26, 16, 19, 0, 0, 11, 30},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z48_CNG6[6][8] = {{25, 13, 20, 34, 1, 43, 13, 10},{33, 2, 15, 19, 21, 14, 6, 14},{26, 9, 33, 40, 8, 24, 40, 43},{19, 1, 22, 36, 2, 5, 21, 3},{34, 9, 39, 4, 5, 11, 1, 42},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z80_CNG6[6][8] = {{39, 69, 17, 20, 64, 61, 79, 49},{62, 60, 67, 54, 21, 2, 15, 40},{63, 45, 48, 51, 21, 40, 52, 30},{0, 35, 51, 61, 30, 50, 43, 27},{37, 60, 68, 55, 41, 10, 23, 41},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z112_CNG6[6][8] = {{81, 42, 56, 87, 8, 105, 80, 49},{56, 52, 110, 110, 6, 98, 19, 45},{72, 43, 88, 88, 103, 9, 108, 64},{105, 77, 63, 31, 86, 102, 50, 81},{78, 101, 4, 74, 8, 71, 106, 12},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z144_CNG6[6][8] = {{87, 126, 9, 17, 0, 121, 64, 92},{0, 13, 137, 7, 0, 81, 46, 55},{72, 99, 0, 0, 118, 90, 122, 0},{47, 54, 0, 97, 0, 0, 9, 122},{36, 0, 18, 0, 0, 84, 18, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z176_CNG6[6][8] = {{135, 14, 110, 47, 87, 89, 162, 38},{75, 117, 52, 110, 110, 65, 88, 170},{89, 156, 71, 70, 147, 155, 170, 73},{94, 155, 116, 5, 82, 68, 143, 112},{81, 114, 14, 73, 28, 30, 109, 18},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z208_CNG6[6][8] = {{52, 88, 91, 1, 12, 6, 6, 9},{147, 198, 184, 41, 6, 12, 86, 125},{1, 160, 30, 167, 166, 15, 96, 191},{16, 122, 3, 68, 184, 5, 42, 28},{46, 182, 155, 148, 191, 30, 199, 6},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z240_CNG6[6][8] = {{220, 78, 183, 183, 179, 77, 197, 32},{185, 152, 112, 215, 108, 187, 122, 178},{154, 84, 106, 180, 159, 203, 215, 2},{178, 5, 219, 143, 138, 167, 65, 156},{150, 205, 129, 14, 196, 130, 216, 58},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z64_CNG6[6][8] = {{49, 0, 7, 42, 60, 23, 57, 48},{56, 49, 36, 41, 9, 58, 57, 22},{23, 49, 59, 8, 8, 25, 45, 44},{57, 51, 1, 27, 63, 47, 3, 52},{62, 26, 16, 19, 32, 32, 43, 30},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z96_CNG6[6][8] = {{25, 13, 68, 34, 49, 91, 13, 10},{81, 50, 15, 67, 21, 14, 6, 62},{74, 57, 81, 88, 56, 72, 40, 43},{19, 1, 70, 36, 50, 53, 21, 51},{82, 57, 87, 4, 5, 59, 1, 42},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z160_CNG6[6][8] = {{39, 69, 97, 100, 64, 141, 79, 129},{142, 140, 147, 134, 21, 2, 15, 120},{143, 45, 128, 131, 101, 40, 132, 110},{0, 115, 51, 141, 110, 130, 123, 27},{37, 140, 68, 135, 41, 10, 103, 121},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z224_CNG6[6][8] = {{81, 154, 56, 199, 8, 105, 192, 49},{56, 164, 110, 110, 6, 210, 131, 157},{72, 43, 200, 200, 103, 121, 220, 64},{217, 189, 63, 143, 198, 214, 50, 193},{78, 101, 4, 186, 8, 183, 106, 124},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z288_CNG6[6][8] = {{231, 270, 153, 161, 0, 265, 64, 236},{0, 13, 137, 151, 0, 81, 46, 199},{216, 99, 0, 0, 118, 90, 266, 0},{47, 54, 0, 241, 144, 144, 9, 266},{36, 0, 162, 144, 0, 228, 18, 0},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z352_CNG6[6][8] = {{311, 190, 110, 47, 87, 89, 162, 38},{251, 293, 228, 286, 110, 65, 264, 170},{265, 332, 247, 246, 147, 155, 346, 249},{94, 331, 116, 181, 258, 244, 143, 288},{81, 114, 190, 73, 204, 30, 109, 194},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z128_CNG6[6][8] = {{49, 64, 7, 42, 60, 23, 121, 112},{120, 49, 36, 105, 73, 58, 121, 86},{23, 49, 59, 8, 72, 89, 109, 108},{57, 51, 1, 27, 127, 47, 3, 116},{62, 26, 16, 19, 96, 32, 43, 94},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z192_CNG6[6][8] = {{121, 13, 68, 130, 145, 187, 13, 106},{177, 146, 111, 163, 21, 14, 102, 158},{74, 57, 81, 88, 152, 72, 136, 43},{115, 97, 166, 132, 50, 149, 21, 147},{178, 57, 183, 4, 5, 59, 97, 42},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z320_CNG6[6][8] = {{39, 69, 257, 260, 64, 301, 79, 289},{302, 140, 147, 294, 181, 162, 175, 280},{303, 45, 128, 291, 101, 40, 132, 110},{160, 115, 51, 141, 270, 130, 283, 187},{37, 300, 228, 295, 41, 10, 103, 281},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z256_CNG6[6][8] = {{177, 64, 7, 42, 60, 151, 249, 112},{248, 49, 164, 233, 73, 186, 121, 86},{151, 49, 59, 8, 72, 217, 109, 236},{185, 51, 1, 155, 127, 47, 131, 116},{62, 154, 144, 147, 224, 160, 171, 222},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z384_CNG6[6][8] = {{313, 13, 260, 130, 145, 187, 205, 298},{177, 338, 303, 163, 213, 206, 102, 158},{266, 57, 81, 280, 344, 264, 328, 235},{115, 289, 358, 132, 242, 341, 213, 339},{370, 57, 375, 4, 197, 59, 97, 234},{0, 0, 0, 0, 0, 0, 0, 0}};

// Group of CNs with 7 BNs (CNG7) ->[Num BNs][Num of CN with 7 BNs]
static const uint16_t circShift_BG1_Z2_CNG7[7][5] = {{0, 0, 0, 0, 0},{0, 1, 0, 1, 0},{1, 1, 1, 0, 1},{1, 0, 0, 1, 1},{1, 1, 0, 0, 1},{0, 0, 1, 1, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z3_CNG7[7][5] = {{0, 2, 2, 1, 1},{2, 0, 0, 2, 2},{1, 1, 0, 2, 0},{0, 0, 1, 2, 0},{2, 2, 2, 2, 1},{0, 0, 2, 0, 2},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z5_CNG7[7][5] = {{2, 4, 4, 3, 4},{3, 0, 0, 4, 0},{2, 1, 4, 4, 0},{0, 0, 3, 1, 0},{0, 1, 0, 4, 4},{1, 1, 2, 3, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z7_CNG7[7][5] = {{3, 5, 2, 0, 6},{6, 4, 0, 0, 1},{6, 6, 3, 1, 5},{2, 5, 3, 2, 6},{3, 5, 0, 2, 6},{4, 5, 0, 1, 4},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z9_CNG7[7][5] = {{7, 7, 0, 0, 8},{0, 1, 0, 6, 0},{1, 1, 1, 1, 3},{4, 6, 7, 7, 0},{5, 0, 4, 0, 5},{2, 3, 0, 7, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z11_CNG7[7][5] = {{3, 10, 2, 0, 0},{4, 0, 8, 3, 7},{4, 5, 10, 2, 4},{0, 0, 0, 2, 4},{6, 5, 0, 0, 0},{6, 3, 10, 1, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z13_CNG7[7][5] = {{2, 9, 6, 1, 4},{10, 12, 7, 7, 6},{8, 0, 8, 1, 3},{10, 3, 10, 0, 0},{3, 12, 0, 1, 1},{11, 5, 12, 2, 7},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z15_CNG7[7][5] = {{2, 11, 6, 4, 9},{11, 1, 5, 9, 3},{14, 10, 4, 2, 10},{2, 5, 0, 5, 8},{1, 10, 8, 12, 7},{3, 9, 5, 1, 4},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z4_CNG7[7][5] = {{0, 2, 0, 2, 0},{0, 1, 2, 3, 0},{3, 3, 1, 2, 1},{3, 0, 0, 3, 3},{3, 1, 2, 0, 3},{0, 2, 3, 1, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z6_CNG7[7][5] = {{3, 5, 5, 4, 1},{2, 3, 0, 2, 2},{4, 4, 0, 5, 0},{3, 3, 4, 5, 0},{2, 5, 2, 5, 1},{0, 0, 2, 0, 5},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z10_CNG7[7][5] = {{2, 4, 9, 8, 9},{8, 0, 5, 9, 0},{7, 1, 9, 4, 0},{0, 5, 8, 1, 0},{5, 1, 5, 9, 4},{6, 1, 2, 8, 1},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z14_CNG7[7][5] = {{3, 12, 2, 0, 6},{6, 11, 7, 7, 8},{6, 6, 10, 1, 5},{2, 5, 3, 9, 13},{10, 12, 0, 9, 13},{4, 5, 0, 1, 11},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z18_CNG7[7][5] = {{7, 16, 9, 0, 8},{9, 1, 0, 6, 0},{10, 10, 10, 1, 3},{4, 15, 7, 16, 0},{14, 0, 4, 0, 14},{2, 3, 9, 7, 10},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z22_CNG7[7][5] = {{3, 21, 13, 0, 0},{15, 11, 19, 14, 18},{4, 5, 10, 13, 15},{11, 11, 0, 2, 15},{17, 5, 0, 0, 0},{17, 3, 10, 12, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z26_CNG7[7][5] = {{15, 22, 6, 1, 17},{10, 25, 20, 20, 6},{8, 0, 21, 14, 3},{23, 16, 23, 0, 0},{3, 12, 0, 1, 1},{24, 18, 25, 2, 20},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z30_CNG7[7][5] = {{17, 26, 6, 4, 9},{26, 1, 5, 24, 18},{29, 10, 4, 2, 10},{2, 20, 0, 5, 23},{16, 25, 8, 12, 22},{18, 24, 20, 16, 19},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z8_CNG7[7][5] = {{4, 2, 0, 6, 0},{4, 5, 2, 7, 0},{7, 7, 5, 6, 1},{7, 0, 0, 7, 7},{7, 1, 2, 0, 3},{0, 2, 7, 5, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z12_CNG7[7][5] = {{9, 5, 5, 10, 1},{2, 3, 6, 8, 2},{4, 10, 6, 5, 6},{9, 3, 4, 5, 6},{2, 11, 2, 11, 7},{6, 6, 2, 0, 5},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z20_CNG7[7][5] = {{12, 14, 9, 18, 9},{8, 0, 15, 19, 10},{7, 11, 9, 14, 0},{10, 15, 8, 1, 10},{5, 1, 5, 19, 4},{16, 11, 12, 18, 11},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z28_CNG7[7][5] = {{17, 26, 2, 14, 6},{20, 25, 7, 7, 8},{20, 6, 24, 15, 19},{16, 19, 3, 23, 13},{10, 26, 0, 23, 13},{18, 19, 14, 15, 25},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z36_CNG7[7][5] = {{25, 34, 9, 0, 26},{9, 1, 18, 6, 0},{10, 28, 28, 1, 3},{4, 15, 7, 16, 0},{32, 18, 22, 0, 32},{20, 21, 27, 7, 28},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z44_CNG7[7][5] = {{3, 43, 35, 22, 0},{15, 33, 41, 14, 40},{4, 27, 10, 13, 15},{33, 11, 22, 24, 37},{39, 5, 0, 22, 0},{39, 3, 32, 34, 25},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z52_CNG7[7][5] = {{41, 22, 6, 1, 17},{36, 25, 20, 46, 6},{8, 0, 47, 14, 29},{49, 16, 49, 26, 26},{3, 12, 0, 1, 1},{24, 18, 51, 2, 46},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z60_CNG7[7][5] = {{17, 56, 6, 4, 39},{26, 31, 35, 24, 18},{29, 10, 4, 2, 40},{32, 50, 0, 35, 53},{46, 55, 38, 12, 22},{18, 24, 20, 16, 49},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z16_CNG7[7][5] = {{12, 2, 0, 14, 8},{12, 5, 10, 7, 0},{15, 7, 5, 14, 1},{15, 0, 0, 15, 15},{7, 1, 10, 0, 11},{8, 10, 7, 5, 3},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z24_CNG7[7][5] = {{9, 5, 5, 22, 1},{14, 3, 18, 8, 2},{4, 10, 6, 17, 18},{21, 15, 16, 17, 6},{2, 23, 2, 11, 7},{18, 18, 2, 12, 5},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z40_CNG7[7][5] = {{12, 14, 29, 38, 29},{8, 0, 35, 19, 10},{7, 11, 9, 14, 20},{10, 35, 8, 21, 10},{25, 1, 25, 19, 24},{36, 31, 12, 18, 11},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z56_CNG7[7][5] = {{17, 26, 30, 14, 34},{20, 53, 7, 7, 8},{48, 6, 24, 43, 19},{44, 19, 3, 23, 41},{38, 26, 28, 51, 41},{46, 47, 14, 43, 25},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z72_CNG7[7][5] = {{25, 34, 9, 0, 26},{45, 1, 18, 42, 0},{10, 28, 28, 37, 39},{40, 51, 7, 16, 36},{32, 18, 22, 0, 68},{20, 57, 27, 7, 64},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z88_CNG7[7][5] = {{3, 87, 35, 22, 0},{15, 77, 41, 58, 84},{48, 27, 54, 13, 15},{33, 55, 22, 68, 81},{39, 49, 0, 66, 0},{39, 3, 76, 78, 25},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z104_CNG7[7][5] = {{41, 22, 6, 1, 69},{88, 77, 20, 98, 6},{8, 52, 99, 14, 81},{49, 16, 49, 26, 78},{55, 12, 0, 1, 53},{76, 70, 103, 2, 46},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z120_CNG7[7][5] = {{77, 116, 66, 4, 39},{26, 31, 95, 24, 18},{89, 70, 4, 62, 100},{32, 110, 60, 95, 53},{46, 115, 98, 72, 22},{18, 84, 80, 76, 49},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z32_CNG7[7][5] = {{28, 2, 0, 14, 8},{12, 21, 10, 23, 0},{31, 7, 21, 14, 1},{31, 0, 0, 31, 31},{7, 17, 10, 16, 11},{8, 26, 7, 5, 19},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z48_CNG7[7][5] = {{9, 5, 29, 46, 1},{14, 3, 42, 8, 2},{28, 34, 30, 41, 18},{45, 15, 40, 41, 30},{2, 47, 2, 11, 7},{18, 18, 26, 12, 29},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z80_CNG7[7][5] = {{12, 14, 69, 78, 69},{8, 0, 75, 59, 50},{47, 51, 9, 54, 60},{50, 75, 48, 61, 50},{25, 1, 25, 19, 24},{76, 71, 52, 18, 51},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z112_CNG7[7][5] = {{17, 82, 30, 14, 90},{76, 53, 63, 63, 8},{104, 62, 24, 99, 19},{100, 19, 3, 79, 97},{38, 82, 28, 51, 97},{46, 103, 70, 43, 81},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z144_CNG7[7][5] = {{25, 34, 81, 0, 26},{45, 1, 18, 42, 0},{10, 28, 100, 109, 39},{40, 123, 7, 16, 108},{104, 90, 94, 0, 68},{20, 57, 99, 79, 64},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z176_CNG7[7][5] = {{3, 175, 123, 22, 0},{103, 77, 41, 146, 172},{48, 27, 142, 101, 15},{121, 55, 110, 156, 81},{39, 49, 0, 66, 0},{39, 91, 76, 78, 113},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z208_CNG7[7][5] = {{145, 126, 6, 1, 173},{88, 77, 20, 202, 6},{112, 156, 203, 118, 81},{153, 16, 153, 130, 182},{159, 12, 104, 1, 53},{76, 70, 207, 2, 46},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z240_CNG7[7][5] = {{77, 116, 186, 124, 39},{146, 151, 215, 144, 138},{209, 70, 124, 182, 220},{32, 230, 180, 95, 173},{166, 115, 98, 72, 142},{18, 84, 80, 76, 49},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z64_CNG7[7][5] = {{28, 34, 32, 14, 40},{44, 21, 42, 55, 32},{31, 39, 21, 14, 1},{31, 32, 32, 63, 63},{39, 49, 42, 16, 11},{40, 58, 7, 37, 51},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z96_CNG7[7][5] = {{9, 5, 77, 46, 49},{62, 51, 90, 56, 2},{28, 82, 78, 41, 18},{45, 15, 40, 89, 30},{2, 95, 50, 59, 55},{18, 66, 74, 12, 77},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z160_CNG7[7][5] = {{12, 14, 69, 78, 69},{88, 80, 75, 139, 130},{47, 51, 9, 54, 60},{50, 75, 48, 61, 130},{25, 1, 105, 19, 24},{76, 151, 52, 98, 51},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z224_CNG7[7][5] = {{17, 82, 142, 14, 90},{76, 165, 175, 175, 120},{104, 174, 136, 211, 131},{100, 19, 3, 191, 209},{150, 194, 28, 51, 209},{158, 103, 182, 43, 81},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z288_CNG7[7][5] = {{169, 178, 225, 0, 170},{189, 1, 162, 186, 0},{154, 28, 244, 253, 183},{184, 267, 151, 16, 108},{104, 234, 238, 0, 68},{164, 201, 243, 79, 64},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z352_CNG7[7][5] = {{3, 175, 123, 22, 176},{103, 253, 217, 322, 348},{224, 27, 142, 277, 15},{297, 231, 110, 156, 81},{215, 49, 176, 66, 176},{39, 267, 76, 78, 113},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z128_CNG7[7][5] = {{92, 98, 32, 78, 40},{44, 21, 42, 55, 96},{31, 39, 21, 78, 65},{31, 32, 32, 127, 63},{39, 49, 106, 16, 75},{104, 58, 7, 101, 51},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z192_CNG7[7][5] = {{9, 101, 77, 142, 49},{62, 147, 186, 56, 2},{124, 82, 174, 137, 18},{141, 111, 40, 89, 126},{98, 191, 50, 155, 55},{114, 162, 74, 12, 77},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z320_CNG7[7][5] = {{12, 14, 229, 78, 229},{88, 80, 235, 299, 290},{207, 211, 169, 54, 60},{50, 75, 48, 61, 130},{25, 161, 105, 179, 184},{76, 311, 52, 258, 51},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z256_CNG7[7][5] = {{220, 98, 160, 206, 40},{44, 149, 42, 55, 96},{159, 167, 21, 206, 65},{31, 160, 32, 127, 63},{167, 49, 234, 16, 75},{104, 58, 7, 229, 179},{0, 0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z384_CNG7[7][5] = {{9, 101, 77, 142, 241},{62, 339, 186, 248, 2},{316, 274, 174, 137, 210},{333, 111, 232, 89, 318},{290, 383, 50, 347, 55},{114, 354, 74, 12, 269},{0, 0, 0, 0, 0}};

// Group of CNs with 8 BNs (CNG8) ->[Num BNs][Num of CN with 8 BNs]
static const uint16_t circShift_BG1_Z2_CNG8[8][2] = {{1, 1},{0, 1},{0, 1},{1, 0},{0, 0},{1, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG1_Z3_CNG8[8][2] = {{0, 0},{2, 0},{1, 2},{1, 2},{1, 2},{0, 1},{1, 1},{0, 0}};
static const uint16_t circShift_BG1_Z5_CNG8[8][2] = {{3, 1},{2, 2},{0, 0},{3, 4},{1, 2},{2, 3},{4, 0},{0, 0}};
static const uint16_t circShift_BG1_Z7_CNG8[8][2] = {{3, 3},{3, 4},{2, 2},{3, 0},{0, 4},{4, 0},{6, 5},{0, 0}};
static const uint16_t circShift_BG1_Z9_CNG8[8][2] = {{0, 1},{1, 5},{0, 4},{4, 1},{2, 3},{7, 3},{0, 8},{0, 0}};
static const uint16_t circShift_BG1_Z11_CNG8[8][2] = {{10, 3},{9, 3},{9, 2},{3, 10},{9, 1},{5, 8},{8, 5},{0, 0}};
static const uint16_t circShift_BG1_Z13_CNG8[8][2] = {{3, 2},{9, 12},{11, 6},{0, 3},{12, 0},{5, 5},{7, 7},{0, 0}};
static const uint16_t circShift_BG1_Z15_CNG8[8][2] = {{2, 0},{6, 10},{2, 14},{8, 1},{0, 2},{0, 0},{0, 2},{0, 0}};
static const uint16_t circShift_BG1_Z4_CNG8[8][2] = {{1, 1},{0, 1},{2, 3},{3, 2},{0, 2},{3, 0},{3, 2},{0, 0}};
static const uint16_t circShift_BG1_Z6_CNG8[8][2] = {{3, 0},{2, 0},{1, 2},{4, 5},{1, 2},{3, 4},{1, 1},{0, 0}};
static const uint16_t circShift_BG1_Z10_CNG8[8][2] = {{3, 6},{2, 7},{0, 0},{8, 9},{1, 7},{7, 3},{9, 0},{0, 0}};
static const uint16_t circShift_BG1_Z14_CNG8[8][2] = {{10, 10},{3, 11},{2, 2},{10, 7},{0, 4},{4, 0},{13, 5},{0, 0}};
static const uint16_t circShift_BG1_Z18_CNG8[8][2] = {{9, 1},{1, 5},{0, 4},{13, 1},{2, 3},{7, 3},{0, 8},{0, 0}};
static const uint16_t circShift_BG1_Z22_CNG8[8][2] = {{21, 3},{20, 14},{9, 2},{14, 21},{9, 12},{16, 8},{19, 16},{0, 0}};
static const uint16_t circShift_BG1_Z26_CNG8[8][2] = {{3, 2},{22, 12},{24, 19},{13, 16},{25, 0},{5, 5},{20, 20},{0, 0}};
static const uint16_t circShift_BG1_Z30_CNG8[8][2] = {{2, 15},{21, 25},{17, 14},{23, 1},{0, 2},{0, 15},{0, 17},{0, 0}};
static const uint16_t circShift_BG1_Z8_CNG8[8][2] = {{5, 5},{4, 1},{2, 3},{7, 6},{4, 6},{3, 4},{3, 6},{0, 0}};
static const uint16_t circShift_BG1_Z12_CNG8[8][2] = {{3, 0},{2, 6},{7, 8},{10, 11},{1, 8},{3, 10},{1, 7},{0, 0}};
static const uint16_t circShift_BG1_Z20_CNG8[8][2] = {{3, 16},{12, 7},{10, 10},{18, 9},{1, 17},{7, 3},{19, 0},{0, 0}};
static const uint16_t circShift_BG1_Z28_CNG8[8][2] = {{24, 24},{3, 11},{2, 2},{24, 7},{14, 4},{18, 0},{13, 5},{0, 0}};
static const uint16_t circShift_BG1_Z36_CNG8[8][2] = {{9, 19},{1, 23},{0, 22},{31, 1},{2, 21},{7, 3},{0, 26},{0, 0}};
static const uint16_t circShift_BG1_Z44_CNG8[8][2] = {{43, 25},{42, 14},{31, 24},{14, 43},{31, 34},{38, 30},{19, 16},{0, 0}};
static const uint16_t circShift_BG1_Z52_CNG8[8][2] = {{29, 28},{48, 38},{24, 19},{13, 16},{51, 0},{5, 5},{20, 20},{0, 0}};
static const uint16_t circShift_BG1_Z60_CNG8[8][2] = {{2, 45},{51, 55},{47, 14},{23, 1},{30, 32},{0, 45},{0, 47},{0, 0}};
static const uint16_t circShift_BG1_Z16_CNG8[8][2] = {{13, 13},{12, 9},{2, 3},{7, 6},{12, 14},{11, 12},{3, 6},{0, 0}};
static const uint16_t circShift_BG1_Z24_CNG8[8][2] = {{3, 0},{14, 6},{19, 8},{22, 23},{1, 20},{3, 22},{13, 19},{0, 0}};
static const uint16_t circShift_BG1_Z40_CNG8[8][2] = {{3, 16},{12, 27},{10, 10},{38, 9},{1, 17},{27, 3},{39, 0},{0, 0}};
static const uint16_t circShift_BG1_Z56_CNG8[8][2] = {{52, 52},{3, 11},{30, 2},{24, 35},{14, 32},{18, 28},{41, 33},{0, 0}};
static const uint16_t circShift_BG1_Z72_CNG8[8][2] = {{45, 55},{37, 23},{0, 58},{67, 37},{38, 57},{7, 39},{0, 26},{0, 0}};
static const uint16_t circShift_BG1_Z88_CNG8[8][2] = {{43, 25},{42, 58},{75, 24},{58, 87},{31, 78},{82, 74},{19, 16},{0, 0}};
static const uint16_t circShift_BG1_Z104_CNG8[8][2] = {{81, 80},{100, 90},{24, 19},{65, 16},{103, 0},{57, 5},{72, 20},{0, 0}};
static const uint16_t circShift_BG1_Z120_CNG8[8][2] = {{2, 45},{51, 115},{47, 14},{23, 1},{90, 32},{60, 45},{60, 107},{0, 0}};
static const uint16_t circShift_BG1_Z32_CNG8[8][2] = {{13, 13},{12, 9},{2, 19},{7, 22},{28, 14},{27, 28},{19, 22},{0, 0}};
static const uint16_t circShift_BG1_Z48_CNG8[8][2] = {{3, 0},{14, 6},{19, 8},{22, 47},{1, 44},{3, 46},{13, 19},{0, 0}};
static const uint16_t circShift_BG1_Z80_CNG8[8][2] = {{3, 16},{52, 67},{50, 50},{78, 49},{41, 17},{27, 43},{39, 40},{0, 0}};
static const uint16_t circShift_BG1_Z112_CNG8[8][2] = {{52, 52},{59, 11},{86, 2},{80, 35},{70, 32},{18, 84},{41, 89},{0, 0}};
static const uint16_t circShift_BG1_Z144_CNG8[8][2] = {{117, 55},{37, 23},{72, 130},{139, 37},{110, 129},{79, 39},{0, 26},{0, 0}};
static const uint16_t circShift_BG1_Z176_CNG8[8][2] = {{43, 25},{130, 146},{75, 24},{146, 175},{119, 166},{82, 162},{107, 16},{0, 0}};
static const uint16_t circShift_BG1_Z208_CNG8[8][2] = {{185, 184},{100, 194},{24, 123},{65, 16},{207, 104},{161, 109},{72, 124},{0, 0}};
static const uint16_t circShift_BG1_Z240_CNG8[8][2] = {{2, 45},{171, 115},{47, 134},{143, 1},{210, 152},{180, 165},{180, 107},{0, 0}};
static const uint16_t circShift_BG1_Z64_CNG8[8][2] = {{13, 13},{44, 41},{2, 19},{39, 54},{28, 14},{59, 60},{51, 22},{0, 0}};
static const uint16_t circShift_BG1_Z96_CNG8[8][2] = {{3, 48},{14, 6},{19, 8},{70, 47},{49, 92},{51, 46},{61, 19},{0, 0}};
static const uint16_t circShift_BG1_Z160_CNG8[8][2] = {{83, 16},{132, 147},{50, 130},{158, 129},{41, 17},{107, 43},{119, 120},{0, 0}};
static const uint16_t circShift_BG1_Z224_CNG8[8][2] = {{164, 52},{59, 11},{86, 2},{80, 35},{182, 32},{130, 84},{153, 201},{0, 0}};
static const uint16_t circShift_BG1_Z288_CNG8[8][2] = {{261, 55},{181, 23},{72, 274},{283, 181},{254, 273},{79, 39},{144, 26},{0, 0}};
static const uint16_t circShift_BG1_Z352_CNG8[8][2] = {{219, 25},{130, 322},{251, 200},{322, 351},{295, 166},{258, 338},{283, 192},{0, 0}};
static const uint16_t circShift_BG1_Z128_CNG8[8][2] = {{77, 77},{108, 41},{66, 83},{103, 54},{28, 78},{123, 124},{115, 22},{0, 0}};
static const uint16_t circShift_BG1_Z192_CNG8[8][2] = {{3, 48},{14, 102},{115, 8},{166, 47},{49, 188},{51, 142},{157, 115},{0, 0}};
static const uint16_t circShift_BG1_Z320_CNG8[8][2] = {{83, 16},{292, 147},{50, 290},{318, 289},{201, 177},{267, 43},{279, 280},{0, 0}};
static const uint16_t circShift_BG1_Z256_CNG8[8][2] = {{205, 77},{236, 41},{194, 83},{231, 182},{28, 78},{123, 252},{115, 22},{0, 0}};
static const uint16_t circShift_BG1_Z384_CNG8[8][2] = {{195, 48},{14, 102},{115, 8},{166, 47},{241, 188},{51, 334},{157, 115},{0, 0}};

// Group of CNs with 9 BNs (CNG9) ->[Num BNs][Num of CN with 9 BNs]
static const uint16_t circShift_BG1_Z2_CNG9[9][2] = {{1, 1},{0, 0},{0, 1},{1, 1},{0, 0},{1, 0},{1, 1},{1, 0},{0, 0}};
static const uint16_t circShift_BG1_Z3_CNG9[9][2] = {{2, 0},{2, 1},{1, 0},{0, 1},{2, 0},{1, 0},{0, 0},{0, 1},{0, 0}};
static const uint16_t circShift_BG1_Z5_CNG9[9][2] = {{4, 4},{1, 4},{3, 1},{3, 1},{2, 1},{2, 2},{3, 0},{0, 4},{0, 0}};
static const uint16_t circShift_BG1_Z7_CNG9[9][2] = {{4, 2},{0, 2},{1, 3},{0, 0},{0, 5},{2, 3},{3, 4},{4, 1},{0, 0}};
static const uint16_t circShift_BG1_Z9_CNG9[9][2] = {{8, 0},{0, 6},{7, 3},{0, 8},{5, 0},{6, 6},{7, 4},{0, 2},{0, 0}};
static const uint16_t circShift_BG1_Z11_CNG9[9][2] = {{8, 2},{7, 0},{0, 7},{0, 1},{7, 4},{7, 9},{9, 1},{8, 7},{0, 0}};
static const uint16_t circShift_BG1_Z13_CNG9[9][2] = {{6, 6},{1, 10},{7, 2},{11, 1},{9, 6},{11, 4},{12, 8},{0, 4},{0, 0}};
static const uint16_t circShift_BG1_Z15_CNG9[9][2] = {{4, 4},{7, 12},{8, 11},{10, 11},{2, 2},{12, 2},{7, 2},{13, 10},{0, 0}};
static const uint16_t circShift_BG1_Z4_CNG9[9][2] = {{3, 3},{2, 2},{0, 1},{3, 1},{0, 2},{3, 2},{1, 1},{3, 0},{0, 0}};
static const uint16_t circShift_BG1_Z6_CNG9[9][2] = {{2, 0},{5, 4},{1, 3},{3, 1},{2, 3},{1, 3},{0, 3},{3, 4},{0, 0}};
static const uint16_t circShift_BG1_Z10_CNG9[9][2] = {{9, 9},{1, 4},{3, 6},{3, 6},{2, 1},{2, 7},{8, 5},{5, 9},{0, 0}};
static const uint16_t circShift_BG1_Z14_CNG9[9][2] = {{4, 9},{7, 9},{1, 3},{7, 7},{7, 5},{9, 3},{10, 11},{4, 8},{0, 0}};
static const uint16_t circShift_BG1_Z18_CNG9[9][2] = {{8, 0},{0, 15},{7, 3},{0, 8},{5, 9},{15, 6},{7, 4},{0, 11},{0, 0}};
static const uint16_t circShift_BG1_Z22_CNG9[9][2] = {{8, 2},{7, 0},{0, 7},{11, 1},{18, 4},{18, 20},{20, 1},{19, 7},{0, 0}};
static const uint16_t circShift_BG1_Z26_CNG9[9][2] = {{6, 6},{1, 10},{7, 15},{24, 1},{22, 19},{24, 4},{12, 8},{13, 17},{0, 0}};
static const uint16_t circShift_BG1_Z30_CNG9[9][2] = {{19, 19},{22, 12},{23, 26},{10, 11},{2, 17},{27, 2},{22, 2},{13, 25},{0, 0}};
static const uint16_t circShift_BG1_Z8_CNG9[9][2] = {{7, 7},{6, 6},{4, 5},{3, 5},{4, 6},{3, 6},{5, 5},{3, 0},{0, 0}};
static const uint16_t circShift_BG1_Z12_CNG9[9][2] = {{2, 6},{5, 4},{1, 9},{3, 1},{8, 9},{1, 3},{6, 3},{9, 10},{0, 0}};
static const uint16_t circShift_BG1_Z20_CNG9[9][2] = {{9, 9},{1, 4},{13, 16},{13, 6},{12, 11},{2, 7},{18, 15},{15, 9},{0, 0}};
static const uint16_t circShift_BG1_Z28_CNG9[9][2] = {{18, 9},{7, 9},{1, 17},{21, 21},{7, 5},{23, 17},{24, 25},{4, 22},{0, 0}};
static const uint16_t circShift_BG1_Z36_CNG9[9][2] = {{8, 18},{0, 15},{25, 21},{18, 26},{23, 9},{33, 24},{7, 4},{0, 29},{0, 0}};
static const uint16_t circShift_BG1_Z44_CNG9[9][2] = {{30, 24},{29, 0},{22, 29},{11, 23},{40, 4},{18, 20},{20, 23},{41, 29},{0, 0}};
static const uint16_t circShift_BG1_Z52_CNG9[9][2] = {{6, 6},{27, 10},{7, 41},{50, 1},{48, 45},{24, 4},{38, 8},{39, 17},{0, 0}};
static const uint16_t circShift_BG1_Z60_CNG9[9][2] = {{19, 49},{22, 12},{23, 26},{40, 41},{32, 17},{27, 32},{52, 32},{13, 25},{0, 0}};
static const uint16_t circShift_BG1_Z16_CNG9[9][2] = {{7, 7},{6, 6},{12, 13},{3, 5},{4, 14},{11, 14},{13, 13},{3, 8},{0, 0}};
static const uint16_t circShift_BG1_Z24_CNG9[9][2] = {{14, 6},{17, 16},{1, 9},{15, 13},{20, 9},{13, 15},{18, 15},{9, 10},{0, 0}};
static const uint16_t circShift_BG1_Z40_CNG9[9][2] = {{9, 29},{21, 4},{13, 36},{13, 6},{32, 31},{22, 27},{18, 15},{35, 9},{0, 0}};
static const uint16_t circShift_BG1_Z56_CNG9[9][2] = {{46, 9},{7, 37},{1, 45},{21, 49},{7, 33},{51, 17},{24, 53},{4, 50},{0, 0}};
static const uint16_t circShift_BG1_Z72_CNG9[9][2] = {{8, 18},{0, 15},{25, 21},{18, 62},{59, 45},{33, 60},{7, 4},{36, 65},{0, 0}};
static const uint16_t circShift_BG1_Z88_CNG9[9][2] = {{30, 68},{73, 0},{66, 29},{11, 23},{84, 4},{62, 64},{20, 23},{41, 73},{0, 0}};
static const uint16_t circShift_BG1_Z104_CNG9[9][2] = {{6, 6},{27, 10},{59, 41},{50, 53},{48, 97},{24, 4},{38, 60},{91, 69},{0, 0}};
static const uint16_t circShift_BG1_Z120_CNG9[9][2] = {{79, 49},{22, 12},{23, 86},{100, 101},{92, 17},{87, 92},{52, 92},{13, 85},{0, 0}};
static const uint16_t circShift_BG1_Z32_CNG9[9][2] = {{23, 7},{22, 22},{28, 13},{3, 21},{20, 14},{11, 14},{29, 29},{19, 24},{0, 0}};
static const uint16_t circShift_BG1_Z48_CNG9[9][2] = {{38, 30},{17, 40},{1, 33},{15, 37},{44, 9},{13, 15},{18, 15},{33, 34},{0, 0}};
static const uint16_t circShift_BG1_Z80_CNG9[9][2] = {{49, 29},{21, 4},{53, 36},{13, 46},{72, 71},{62, 27},{58, 55},{75, 49},{0, 0}};
static const uint16_t circShift_BG1_Z112_CNG9[9][2] = {{46, 9},{7, 37},{1, 101},{21, 105},{63, 89},{51, 73},{24, 109},{4, 106},{0, 0}};
static const uint16_t circShift_BG1_Z144_CNG9[9][2] = {{80, 18},{0, 15},{25, 93},{90, 134},{59, 45},{33, 132},{7, 76},{108, 65},{0, 0}};
static const uint16_t circShift_BG1_Z176_CNG9[9][2] = {{118, 156},{73, 88},{154, 117},{99, 111},{172, 92},{150, 152},{108, 23},{129, 161},{0, 0}};
static const uint16_t circShift_BG1_Z208_CNG9[9][2] = {{6, 6},{27, 10},{163, 145},{50, 53},{48, 201},{24, 4},{38, 164},{91, 173},{0, 0}};
static const uint16_t circShift_BG1_Z240_CNG9[9][2] = {{199, 169},{22, 12},{23, 206},{100, 221},{92, 17},{207, 212},{52, 92},{13, 205},{0, 0}};
static const uint16_t circShift_BG1_Z64_CNG9[9][2] = {{55, 39},{22, 54},{28, 45},{3, 21},{52, 14},{11, 14},{29, 61},{19, 24},{0, 0}};
static const uint16_t circShift_BG1_Z96_CNG9[9][2] = {{86, 78},{65, 40},{1, 33},{63, 37},{92, 57},{61, 15},{18, 63},{33, 82},{0, 0}};
static const uint16_t circShift_BG1_Z160_CNG9[9][2] = {{129, 29},{21, 84},{133, 36},{13, 126},{72, 151},{142, 107},{138, 135},{75, 49},{0, 0}};
static const uint16_t circShift_BG1_Z224_CNG9[9][2] = {{158, 9},{119, 37},{113, 213},{21, 105},{63, 89},{51, 185},{136, 109},{116, 218},{0, 0}};
static const uint16_t circShift_BG1_Z288_CNG9[9][2] = {{80, 162},{144, 159},{169, 93},{90, 134},{59, 45},{177, 132},{151, 76},{108, 209},{0, 0}};
static const uint16_t circShift_BG1_Z352_CNG9[9][2] = {{294, 156},{73, 88},{330, 293},{99, 111},{172, 92},{150, 152},{284, 23},{305, 337},{0, 0}};
static const uint16_t circShift_BG1_Z128_CNG9[9][2] = {{55, 103},{22, 54},{28, 109},{67, 21},{116, 14},{11, 14},{29, 61},{83, 88},{0, 0}};
static const uint16_t circShift_BG1_Z192_CNG9[9][2] = {{86, 174},{65, 40},{1, 129},{159, 133},{92, 57},{61, 111},{18, 63},{33, 82},{0, 0}};
static const uint16_t circShift_BG1_Z320_CNG9[9][2] = {{289, 189},{21, 244},{293, 36},{13, 286},{232, 151},{302, 267},{138, 135},{235, 209},{0, 0}};
static const uint16_t circShift_BG1_Z256_CNG9[9][2] = {{183, 103},{22, 182},{28, 109},{67, 21},{244, 142},{11, 14},{157, 61},{211, 216},{0, 0}};
static const uint16_t circShift_BG1_Z384_CNG9[9][2] = {{278, 366},{257, 232},{1, 321},{351, 133},{92, 57},{253, 303},{18, 63},{225, 82},{0, 0}};

// Group of CNs with 10 BNs (CNG10) ->[Num BNs][Num of CN with 10 BNs]
static const uint16_t circShift_BG1_Z2_CNG10[10][1] = {{0},{0},{1},{1},{0},{0},{1},{1},{0},{0}};
static const uint16_t circShift_BG1_Z3_CNG10[10][1] = {{1},{2},{0},{0},{0},{2},{2},{1},{2},{0}};
static const uint16_t circShift_BG1_Z5_CNG10[10][1] = {{0},{3},{0},{1},{1},{0},{4},{0},{4},{0}};
static const uint16_t circShift_BG1_Z7_CNG10[10][1] = {{5},{4},{4},{0},{1},{4},{2},{2},{5},{0}};
static const uint16_t circShift_BG1_Z9_CNG10[10][1] = {{0},{0},{0},{5},{8},{1},{6},{5},{0},{0}};
static const uint16_t circShift_BG1_Z11_CNG10[10][1] = {{7},{9},{0},{4},{4},{6},{4},{6},{2},{0}};
static const uint16_t circShift_BG1_Z13_CNG10[10][1] = {{3},{2},{1},{11},{5},{8},{10},{9},{12},{0}};
static const uint16_t circShift_BG1_Z15_CNG10[10][1] = {{1},{0},{6},{13},{12},{10},{4},{3},{8},{0}};
static const uint16_t circShift_BG1_Z4_CNG10[10][1] = {{0},{0},{3},{3},{2},{0},{1},{1},{2},{0}};
static const uint16_t circShift_BG1_Z6_CNG10[10][1] = {{1},{5},{3},{0},{3},{2},{2},{1},{2},{0}};
static const uint16_t circShift_BG1_Z10_CNG10[10][1] = {{5},{3},{0},{1},{6},{0},{9},{5},{4},{0}};
static const uint16_t circShift_BG1_Z14_CNG10[10][1] = {{5},{11},{4},{7},{8},{11},{2},{2},{5},{0}};
static const uint16_t circShift_BG1_Z18_CNG10[10][1] = {{0},{0},{0},{5},{8},{10},{15},{14},{0},{0}};
static const uint16_t circShift_BG1_Z22_CNG10[10][1] = {{18},{9},{0},{4},{4},{17},{15},{6},{2},{0}};
static const uint16_t circShift_BG1_Z26_CNG10[10][1] = {{16},{2},{1},{11},{18},{21},{23},{9},{12},{0}};
static const uint16_t circShift_BG1_Z30_CNG10[10][1] = {{1},{15},{21},{13},{27},{25},{19},{3},{8},{0}};
static const uint16_t circShift_BG1_Z8_CNG10[10][1] = {{0},{4},{7},{3},{6},{4},{5},{1},{2},{0}};
static const uint16_t circShift_BG1_Z12_CNG10[10][1] = {{7},{11},{9},{6},{3},{8},{8},{7},{2},{0}};
static const uint16_t circShift_BG1_Z20_CNG10[10][1] = {{15},{13},{10},{11},{16},{10},{9},{5},{14},{0}};
static const uint16_t circShift_BG1_Z28_CNG10[10][1] = {{5},{11},{4},{21},{8},{11},{2},{16},{5},{0}};
static const uint16_t circShift_BG1_Z36_CNG10[10][1] = {{18},{0},{0},{5},{26},{10},{15},{14},{18},{0}};
static const uint16_t circShift_BG1_Z44_CNG10[10][1] = {{40},{31},{22},{4},{4},{17},{15},{6},{24},{0}};
static const uint16_t circShift_BG1_Z52_CNG10[10][1] = {{16},{2},{27},{37},{44},{47},{49},{35},{12},{0}};
static const uint16_t circShift_BG1_Z60_CNG10[10][1] = {{1},{45},{21},{43},{57},{25},{19},{33},{38},{0}};
static const uint16_t circShift_BG1_Z16_CNG10[10][1] = {{0},{4},{7},{3},{6},{4},{13},{1},{10},{0}};
static const uint16_t circShift_BG1_Z24_CNG10[10][1] = {{19},{11},{21},{18},{15},{8},{8},{19},{2},{0}};
static const uint16_t circShift_BG1_Z40_CNG10[10][1] = {{15},{13},{10},{31},{16},{30},{29},{5},{34},{0}};
static const uint16_t circShift_BG1_Z56_CNG10[10][1] = {{33},{39},{4},{49},{36},{39},{2},{44},{33},{0}};
static const uint16_t circShift_BG1_Z72_CNG10[10][1] = {{54},{0},{36},{41},{26},{46},{15},{14},{54},{0}};
static const uint16_t circShift_BG1_Z88_CNG10[10][1] = {{84},{75},{22},{48},{48},{17},{59},{50},{68},{0}};
static const uint16_t circShift_BG1_Z104_CNG10[10][1] = {{68},{2},{27},{37},{96},{99},{101},{35},{12},{0}};
static const uint16_t circShift_BG1_Z120_CNG10[10][1] = {{61},{105},{21},{103},{57},{25},{79},{33},{38},{0}};
static const uint16_t circShift_BG1_Z32_CNG10[10][1] = {{16},{4},{7},{19},{6},{4},{13},{17},{26},{0}};
static const uint16_t circShift_BG1_Z48_CNG10[10][1] = {{19},{35},{21},{18},{39},{32},{32},{19},{26},{0}};
static const uint16_t circShift_BG1_Z80_CNG10[10][1] = {{55},{53},{50},{71},{56},{30},{29},{5},{74},{0}};
static const uint16_t circShift_BG1_Z112_CNG10[10][1] = {{33},{95},{4},{105},{92},{39},{58},{44},{89},{0}};
static const uint16_t circShift_BG1_Z144_CNG10[10][1] = {{54},{0},{108},{41},{98},{46},{15},{86},{54},{0}};
static const uint16_t circShift_BG1_Z176_CNG10[10][1] = {{172},{75},{22},{136},{48},{17},{59},{138},{68},{0}};
static const uint16_t circShift_BG1_Z208_CNG10[10][1] = {{172},{2},{131},{141},{96},{99},{101},{35},{116},{0}};
static const uint16_t circShift_BG1_Z240_CNG10[10][1] = {{181},{105},{141},{223},{177},{145},{199},{153},{38},{0}};
static const uint16_t circShift_BG1_Z64_CNG10[10][1] = {{48},{4},{7},{19},{38},{36},{45},{49},{26},{0}};
static const uint16_t circShift_BG1_Z96_CNG10[10][1] = {{19},{83},{69},{18},{39},{32},{80},{67},{74},{0}};
static const uint16_t circShift_BG1_Z160_CNG10[10][1] = {{135},{133},{130},{71},{136},{110},{109},{85},{154},{0}};
static const uint16_t circShift_BG1_Z224_CNG10[10][1] = {{33},{95},{4},{217},{204},{39},{58},{44},{201},{0}};
static const uint16_t circShift_BG1_Z288_CNG10[10][1] = {{54},{0},{252},{41},{98},{46},{15},{230},{54},{0}};
static const uint16_t circShift_BG1_Z352_CNG10[10][1] = {{348},{75},{22},{312},{224},{17},{59},{314},{244},{0}};
static const uint16_t circShift_BG1_Z128_CNG10[10][1] = {{112},{4},{7},{83},{102},{36},{109},{113},{90},{0}};
static const uint16_t circShift_BG1_Z192_CNG10[10][1] = {{115},{179},{165},{18},{39},{32},{176},{67},{170},{0}};
static const uint16_t circShift_BG1_Z320_CNG10[10][1] = {{295},{133},{130},{231},{296},{110},{269},{245},{154},{0}};
static const uint16_t circShift_BG1_Z256_CNG10[10][1] = {{112},{4},{7},{211},{102},{164},{109},{241},{90},{0}};
static const uint16_t circShift_BG1_Z384_CNG10[10][1] = {{307},{179},{165},{18},{39},{224},{368},{67},{170},{0}};

// Group of CNs with 19 BNs (CNG19) ->[Num BNs][Num of CN with 19 BNs]
static const uint16_t circShift_BG1_Z2_CNG19[19][4] = {{0, 0, 0, 1},{1, 1, 1, 1},{0, 1, 1, 0},{1, 0, 1, 0},{0, 1, 1, 0},{0, 0, 1, 1},{1, 0, 1, 1},{1, 1, 1, 0},{0, 0, 1, 0},{1, 0, 1, 0},{1, 1, 0, 1},{1, 0, 1, 1},{1, 0, 1, 0},{0, 1, 1, 0},{1, 1, 1, 0},{1, 0, 1, 0},{1, 0, 1, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z3_CNG19[19][4] = {{1, 1, 1, 0},{1, 1, 1, 0},{2, 1, 1, 0},{0, 0, 2, 2},{1, 0, 1, 1},{0, 1, 2, 0},{2, 1, 0, 2},{0, 1, 1, 0},{1, 1, 0, 2},{2, 0, 0, 0},{0, 1, 2, 2},{2, 0, 1, 2},{1, 0, 2, 1},{2, 0, 2, 0},{0, 1, 0, 1},{0, 1, 1, 0},{1, 0, 1, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z5_CNG19[19][4] = {{3, 3, 3, 0},{0, 4, 2, 3},{3, 2, 0, 0},{4, 1, 0, 2},{0, 1, 3, 1},{4, 3, 2, 0},{0, 4, 2, 4},{2, 0, 0, 1},{0, 4, 1, 3},{4, 0, 1, 3},{3, 1, 0, 4},{3, 1, 3, 3},{0, 2, 1, 4},{3, 3, 4, 3},{1, 0, 1, 2},{4, 1, 0, 4},{2, 0, 1, 3},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z7_CNG19[19][4] = {{6, 1, 4, 5},{2, 3, 0, 4},{3, 4, 3, 4},{0, 4, 1, 5},{4, 0, 5, 3},{3, 3, 4, 2},{0, 0, 4, 2},{2, 3, 6, 6},{6, 3, 2, 1},{0, 2, 0, 3},{5, 2, 0, 0},{0, 2, 4, 6},{0, 6, 0, 5},{1, 5, 2, 4},{2, 3, 5, 1},{6, 5, 6, 2},{4, 0, 6, 4},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z9_CNG19[19][4] = {{4, 8, 6, 7},{0, 0, 5, 1},{8, 7, 4, 4},{6, 4, 7, 0},{3, 7, 0, 1},{4, 4, 4, 6},{2, 4, 2, 8},{0, 0, 0, 5},{8, 1, 0, 0},{0, 6, 3, 3},{7, 0, 2, 0},{8, 8, 4, 7},{0, 5, 0, 8},{5, 3, 0, 3},{0, 3, 8, 0},{1, 2, 2, 5},{0, 0, 0, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z11_CNG19[19][4] = {{8, 0, 6, 9},{8, 5, 2, 6},{2, 8, 4, 5},{0, 8, 5, 4},{9, 4, 1, 7},{0, 2, 1, 1},{1, 5, 7, 3},{8, 6, 6, 7},{1, 2, 8, 4},{9, 0, 6, 4},{3, 4, 0, 5},{9, 0, 0, 9},{6, 4, 4, 7},{7, 1, 10, 6},{2, 9, 9, 0},{3, 5, 1, 0},{1, 0, 7, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z13_CNG19[19][4] = {{0, 9, 2, 4},{0, 11, 11, 6},{0, 7, 8, 7},{0, 0, 11, 9},{0, 10, 4, 10},{0, 0, 6, 8},{0, 0, 9, 6},{0, 2, 12, 8},{0, 3, 5, 5},{0, 8, 0, 11},{0, 0, 12, 9},{0, 6, 2, 5},{0, 4, 7, 1},{0, 0, 8, 4},{0, 12, 10, 3},{0, 5, 3, 2},{0, 1, 1, 12},{0, 0, 0, 0},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z15_CNG19[19][4] = {{0, 6, 9, 8},{2, 11, 4, 8},{6, 1, 0, 12},{14, 11, 1, 10},{9, 8, 11, 13},{8, 2, 12, 6},{8, 7, 14, 6},{0, 11, 2, 1},{10, 11, 9, 6},{8, 9, 8, 7},{0, 5, 6, 9},{0, 10, 11, 2},{7, 3, 3, 5},{10, 12, 6, 2},{0, 13, 5, 10},{0, 6, 7, 7},{2, 0, 5, 9},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z4_CNG19[19][4] = {{2, 2, 2, 1},{1, 3, 3, 1},{2, 1, 1, 0},{3, 0, 3, 0},{0, 3, 1, 2},{2, 2, 1, 3},{3, 0, 1, 3},{1, 1, 1, 0},{2, 0, 3, 2},{3, 2, 3, 2},{1, 1, 2, 3},{3, 0, 1, 3},{3, 2, 1, 0},{2, 3, 1, 0},{3, 3, 1, 0},{3, 0, 3, 0},{3, 0, 1, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z6_CNG19[19][4] = {{1, 4, 1, 0},{1, 4, 4, 3},{2, 1, 4, 0},{3, 0, 2, 5},{1, 0, 4, 1},{0, 1, 5, 3},{5, 1, 3, 2},{0, 4, 4, 0},{1, 1, 3, 5},{5, 0, 3, 3},{3, 1, 2, 5},{5, 3, 4, 2},{4, 0, 5, 4},{2, 0, 5, 0},{0, 1, 0, 1},{0, 4, 1, 3},{4, 0, 1, 3},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z10_CNG19[19][4] = {{3, 3, 8, 0},{5, 4, 7, 8},{3, 7, 0, 0},{9, 1, 0, 7},{0, 1, 8, 1},{9, 3, 7, 5},{5, 4, 2, 9},{2, 0, 0, 1},{5, 9, 1, 3},{4, 0, 6, 3},{3, 6, 5, 4},{8, 6, 3, 3},{0, 2, 1, 4},{3, 3, 4, 8},{6, 0, 6, 7},{9, 1, 0, 9},{2, 0, 6, 8},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z14_CNG19[19][4] = {{13, 1, 11, 5},{2, 3, 7, 4},{10, 11, 3, 11},{7, 4, 8, 5},{4, 7, 12, 3},{10, 3, 4, 2},{0, 7, 11, 2},{9, 3, 13, 6},{6, 10, 9, 1},{7, 9, 0, 3},{5, 9, 7, 7},{0, 9, 4, 13},{0, 6, 7, 12},{1, 12, 2, 4},{2, 3, 5, 1},{6, 5, 13, 2},{11, 0, 6, 4},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z18_CNG19[19][4] = {{13, 17, 6, 7},{0, 0, 5, 1},{8, 7, 4, 4},{6, 4, 7, 0},{3, 16, 9, 10},{4, 4, 4, 6},{11, 4, 2, 17},{0, 9, 9, 5},{8, 1, 0, 0},{0, 15, 3, 3},{7, 0, 2, 0},{17, 8, 13, 7},{0, 14, 0, 8},{5, 3, 0, 3},{0, 12, 17, 0},{1, 11, 2, 5},{9, 0, 0, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z22_CNG19[19][4] = {{8, 11, 6, 9},{8, 5, 13, 6},{13, 8, 15, 5},{0, 8, 16, 15},{9, 4, 1, 7},{11, 2, 1, 12},{1, 16, 18, 3},{8, 6, 17, 18},{1, 13, 8, 4},{9, 11, 17, 15},{3, 4, 0, 5},{9, 0, 0, 9},{17, 15, 15, 7},{18, 1, 21, 17},{13, 9, 9, 11},{3, 16, 12, 11},{12, 0, 7, 11},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z26_CNG19[19][4] = {{0, 22, 2, 4},{0, 11, 11, 6},{0, 20, 21, 7},{0, 0, 24, 9},{0, 10, 4, 23},{0, 0, 19, 21},{0, 0, 22, 6},{0, 2, 12, 21},{0, 16, 18, 5},{0, 8, 13, 24},{0, 0, 25, 9},{0, 6, 2, 5},{0, 4, 7, 14},{0, 0, 21, 17},{0, 12, 23, 16},{0, 5, 16, 2},{0, 1, 14, 12},{0, 0, 0, 0},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z30_CNG19[19][4] = {{15, 6, 9, 8},{17, 26, 4, 23},{6, 16, 15, 12},{14, 11, 1, 10},{24, 8, 26, 13},{23, 2, 27, 6},{23, 22, 29, 6},{15, 26, 2, 1},{25, 11, 24, 6},{8, 9, 8, 22},{15, 5, 6, 24},{15, 25, 11, 17},{7, 3, 3, 20},{10, 27, 6, 2},{0, 13, 5, 25},{15, 6, 7, 22},{17, 0, 20, 9},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z8_CNG19[19][4] = {{2, 2, 2, 1},{5, 7, 7, 1},{2, 5, 1, 4},{7, 4, 7, 4},{4, 7, 5, 6},{2, 6, 5, 3},{3, 0, 5, 3},{5, 5, 1, 0},{6, 4, 7, 6},{7, 6, 7, 6},{1, 5, 6, 3},{3, 4, 1, 3},{7, 6, 1, 0},{6, 3, 5, 4},{3, 7, 5, 4},{7, 4, 3, 0},{7, 0, 5, 4},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z12_CNG19[19][4] = {{7, 4, 1, 0},{7, 4, 10, 3},{2, 1, 4, 0},{9, 0, 8, 11},{1, 0, 4, 7},{0, 7, 5, 9},{5, 7, 3, 8},{0, 10, 4, 0},{1, 7, 3, 5},{5, 6, 9, 3},{9, 1, 8, 5},{11, 3, 4, 8},{10, 6, 5, 4},{2, 6, 11, 0},{0, 7, 0, 7},{6, 4, 1, 3},{10, 0, 1, 9},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z20_CNG19[19][4] = {{13, 3, 8, 0},{15, 14, 7, 8},{3, 7, 0, 10},{9, 1, 0, 17},{0, 1, 18, 1},{19, 13, 7, 15},{15, 4, 2, 19},{2, 0, 0, 1},{15, 9, 11, 3},{4, 0, 6, 13},{13, 16, 15, 4},{18, 6, 3, 13},{10, 12, 1, 4},{13, 3, 4, 8},{16, 0, 6, 17},{9, 1, 10, 19},{12, 0, 16, 8},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z28_CNG19[19][4] = {{27, 1, 11, 5},{16, 17, 7, 18},{10, 11, 3, 25},{7, 18, 8, 5},{18, 7, 12, 17},{10, 17, 18, 2},{0, 21, 11, 16},{9, 3, 13, 6},{20, 10, 9, 15},{21, 9, 14, 17},{19, 23, 21, 7},{14, 9, 18, 13},{14, 6, 21, 12},{1, 26, 2, 18},{2, 3, 5, 15},{20, 19, 27, 2},{25, 0, 6, 18},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z36_CNG19[19][4] = {{31, 35, 6, 7},{18, 18, 23, 1},{8, 7, 4, 22},{6, 4, 25, 0},{3, 16, 27, 10},{4, 4, 22, 24},{29, 22, 2, 17},{0, 9, 27, 5},{8, 1, 0, 18},{0, 15, 3, 21},{7, 0, 2, 0},{17, 8, 13, 7},{0, 14, 0, 26},{23, 3, 0, 21},{0, 12, 17, 0},{1, 11, 20, 5},{9, 0, 18, 0},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z44_CNG19[19][4] = {{30, 33, 6, 9},{30, 5, 35, 6},{35, 8, 37, 5},{22, 30, 38, 15},{31, 4, 23, 7},{33, 24, 1, 34},{23, 38, 40, 3},{30, 6, 17, 18},{1, 35, 30, 26},{31, 33, 39, 37},{25, 26, 22, 5},{9, 22, 22, 9},{39, 37, 37, 29},{40, 1, 43, 39},{35, 9, 31, 11},{3, 38, 34, 33},{12, 0, 7, 33},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z52_CNG19[19][4] = {{0, 22, 28, 4},{0, 11, 37, 6},{0, 20, 21, 33},{0, 0, 24, 9},{0, 10, 4, 49},{0, 0, 45, 21},{0, 0, 48, 6},{0, 2, 38, 47},{0, 16, 18, 31},{0, 8, 39, 50},{0, 0, 51, 35},{0, 6, 28, 5},{0, 30, 33, 40},{0, 0, 47, 17},{0, 12, 23, 16},{0, 31, 42, 2},{0, 1, 14, 38},{0, 0, 0, 0},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z60_CNG19[19][4] = {{15, 36, 9, 8},{47, 56, 4, 23},{6, 16, 45, 42},{14, 41, 31, 40},{24, 8, 56, 43},{23, 32, 57, 6},{53, 52, 59, 36},{45, 56, 32, 1},{25, 11, 24, 36},{8, 9, 8, 22},{15, 35, 6, 24},{15, 25, 41, 47},{37, 33, 33, 20},{40, 27, 36, 32},{30, 43, 5, 55},{45, 36, 7, 52},{17, 0, 50, 39},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z16_CNG19[19][4] = {{10, 2, 10, 9},{5, 15, 15, 9},{2, 5, 9, 4},{15, 12, 15, 4},{4, 7, 5, 6},{10, 14, 13, 3},{11, 8, 5, 3},{5, 13, 1, 8},{14, 12, 15, 6},{15, 6, 7, 6},{9, 13, 14, 11},{3, 4, 1, 3},{7, 14, 1, 0},{14, 11, 5, 12},{3, 15, 13, 4},{15, 12, 11, 0},{15, 0, 5, 12},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z24_CNG19[19][4] = {{19, 4, 13, 12},{19, 4, 10, 15},{2, 1, 16, 0},{9, 0, 20, 11},{13, 0, 16, 7},{0, 19, 17, 9},{5, 19, 3, 8},{0, 10, 16, 12},{13, 7, 15, 17},{17, 6, 9, 15},{21, 1, 8, 5},{23, 3, 16, 20},{10, 18, 5, 16},{2, 18, 11, 12},{12, 19, 0, 7},{18, 16, 13, 15},{10, 0, 13, 21},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z40_CNG19[19][4] = {{33, 23, 28, 20},{15, 14, 7, 8},{23, 27, 0, 30},{9, 21, 0, 37},{0, 1, 38, 21},{39, 13, 27, 15},{15, 4, 2, 39},{2, 0, 0, 1},{15, 9, 31, 23},{4, 20, 26, 13},{13, 36, 15, 4},{18, 26, 3, 13},{30, 32, 21, 4},{33, 3, 24, 28},{16, 20, 6, 37},{29, 21, 30, 39},{32, 0, 36, 28},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z56_CNG19[19][4] = {{55, 29, 39, 33},{16, 45, 35, 18},{38, 39, 31, 53},{35, 46, 8, 5},{18, 7, 12, 45},{10, 45, 18, 30},{0, 21, 39, 16},{37, 31, 41, 34},{48, 38, 9, 43},{21, 37, 14, 45},{47, 23, 21, 35},{14, 9, 46, 13},{14, 6, 21, 40},{29, 26, 30, 18},{30, 31, 5, 43},{48, 19, 55, 30},{25, 0, 34, 46},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z72_CNG19[19][4] = {{67, 35, 42, 43},{54, 18, 23, 1},{44, 7, 4, 22},{42, 40, 61, 36},{3, 16, 27, 10},{4, 4, 58, 60},{29, 58, 2, 53},{0, 45, 63, 41},{44, 37, 0, 18},{0, 15, 3, 57},{43, 0, 2, 36},{17, 8, 13, 43},{0, 14, 0, 26},{23, 3, 0, 21},{0, 12, 53, 0},{1, 47, 56, 41},{45, 0, 18, 36},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z88_CNG19[19][4] = {{30, 77, 50, 9},{30, 49, 35, 6},{79, 8, 37, 49},{66, 74, 38, 15},{31, 4, 23, 51},{77, 24, 1, 78},{67, 38, 40, 3},{74, 50, 61, 18},{1, 79, 30, 70},{75, 77, 39, 81},{25, 70, 22, 5},{53, 66, 22, 9},{83, 81, 37, 73},{40, 45, 43, 39},{79, 9, 75, 55},{47, 38, 34, 33},{12, 0, 7, 33},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z104_CNG19[19][4] = {{0, 22, 28, 4},{0, 11, 37, 6},{0, 20, 21, 33},{0, 0, 76, 9},{0, 10, 4, 49},{0, 0, 45, 21},{0, 0, 48, 6},{0, 2, 38, 47},{0, 16, 18, 83},{0, 60, 91, 50},{0, 0, 51, 87},{0, 6, 28, 5},{0, 30, 85, 92},{0, 0, 47, 69},{0, 64, 75, 16},{0, 31, 42, 2},{0, 1, 66, 38},{0, 0, 0, 0},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z120_CNG19[19][4] = {{15, 96, 69, 8},{107, 116, 4, 23},{6, 16, 105, 42},{14, 101, 31, 100},{84, 8, 116, 43},{83, 92, 117, 66},{53, 52, 59, 96},{105, 56, 92, 1},{85, 11, 24, 96},{8, 69, 68, 22},{75, 95, 6, 24},{15, 85, 101, 47},{97, 33, 33, 80},{100, 87, 96, 32},{90, 43, 5, 115},{105, 96, 67, 52},{17, 0, 110, 99},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z32_CNG19[19][4] = {{26, 2, 10, 25},{5, 15, 15, 25},{2, 21, 25, 20},{31, 28, 31, 20},{4, 7, 21, 22},{10, 30, 29, 3},{27, 8, 5, 19},{5, 13, 17, 8},{14, 28, 31, 22},{31, 6, 7, 22},{9, 13, 14, 27},{3, 4, 1, 19},{23, 14, 1, 16},{30, 27, 21, 12},{3, 31, 13, 20},{15, 28, 27, 16},{31, 0, 21, 12},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z48_CNG19[19][4] = {{19, 28, 13, 36},{19, 28, 10, 39},{2, 25, 40, 0},{33, 0, 44, 35},{37, 0, 16, 7},{24, 43, 17, 9},{29, 43, 27, 8},{0, 34, 16, 36},{13, 7, 15, 17},{17, 6, 33, 39},{21, 25, 8, 5},{23, 3, 40, 20},{10, 18, 5, 16},{2, 18, 35, 12},{36, 43, 0, 31},{42, 16, 13, 39},{10, 0, 13, 21},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z80_CNG19[19][4] = {{73, 63, 68, 60},{15, 54, 7, 48},{23, 27, 0, 30},{49, 21, 40, 37},{0, 1, 38, 61},{39, 53, 67, 15},{15, 4, 42, 79},{2, 0, 40, 41},{55, 49, 71, 63},{4, 60, 26, 13},{53, 76, 55, 4},{58, 26, 43, 53},{30, 72, 61, 44},{33, 3, 24, 28},{16, 20, 6, 77},{29, 61, 70, 79},{32, 0, 36, 68},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z112_CNG19[19][4] = {{111, 29, 95, 89},{16, 45, 91, 18},{94, 39, 31, 53},{91, 46, 64, 5},{74, 7, 68, 45},{10, 45, 74, 30},{0, 21, 95, 16},{93, 87, 41, 34},{104, 94, 65, 43},{21, 93, 70, 101},{103, 79, 77, 35},{14, 9, 102, 69},{70, 6, 77, 96},{29, 82, 86, 74},{86, 31, 5, 99},{104, 75, 111, 30},{81, 0, 90, 46},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z144_CNG19[19][4] = {{67, 35, 114, 43},{54, 18, 23, 1},{44, 79, 76, 22},{42, 112, 133, 108},{75, 16, 99, 82},{4, 76, 58, 132},{29, 58, 74, 53},{0, 117, 63, 41},{116, 109, 0, 18},{72, 15, 3, 57},{115, 72, 74, 36},{89, 8, 85, 115},{0, 14, 0, 98},{95, 3, 72, 21},{72, 12, 125, 0},{73, 119, 56, 113},{117, 0, 90, 108},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z176_CNG19[19][4] = {{118, 77, 50, 97},{118, 49, 35, 94},{167, 96, 37, 49},{154, 162, 126, 103},{31, 92, 111, 139},{165, 112, 89, 166},{67, 126, 128, 91},{74, 50, 61, 106},{1, 167, 118, 70},{163, 77, 127, 169},{25, 158, 110, 93},{53, 66, 110, 9},{171, 81, 125, 73},{128, 133, 131, 39},{167, 9, 163, 143},{47, 126, 34, 121},{12, 0, 7, 121},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z208_CNG19[19][4] = {{0, 22, 132, 4},{0, 11, 37, 6},{0, 124, 21, 33},{0, 0, 180, 113},{0, 10, 4, 49},{0, 0, 149, 21},{0, 0, 48, 6},{0, 2, 38, 151},{0, 16, 122, 83},{0, 60, 195, 154},{0, 0, 155, 87},{0, 6, 28, 5},{0, 30, 85, 92},{0, 0, 47, 173},{0, 168, 179, 120},{0, 31, 42, 2},{0, 105, 66, 142},{0, 0, 0, 0},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z240_CNG19[19][4] = {{135, 96, 189, 128},{227, 236, 4, 23},{126, 136, 225, 162},{134, 221, 151, 220},{84, 128, 236, 43},{83, 92, 117, 186},{53, 172, 179, 96},{225, 56, 92, 1},{205, 11, 24, 216},{128, 189, 68, 22},{75, 95, 6, 24},{135, 85, 101, 167},{217, 153, 33, 200},{220, 87, 96, 32},{90, 163, 125, 235},{105, 216, 67, 172},{137, 0, 230, 219},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z64_CNG19[19][4] = {{58, 2, 42, 57},{5, 47, 47, 25},{34, 53, 57, 20},{31, 60, 63, 20},{36, 7, 53, 22},{10, 30, 29, 3},{59, 40, 37, 51},{37, 45, 49, 8},{46, 28, 31, 22},{63, 38, 39, 54},{9, 45, 14, 27},{3, 4, 33, 19},{23, 14, 33, 48},{62, 27, 53, 12},{35, 63, 13, 52},{47, 28, 59, 16},{31, 0, 53, 12},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z96_CNG19[19][4] = {{19, 76, 13, 84},{19, 76, 58, 87},{50, 73, 40, 0},{81, 0, 44, 83},{85, 48, 64, 7},{24, 43, 65, 57},{29, 43, 75, 56},{0, 82, 64, 36},{13, 7, 63, 17},{17, 54, 33, 39},{69, 25, 8, 53},{23, 3, 88, 20},{10, 66, 53, 16},{50, 18, 35, 12},{84, 43, 48, 79},{42, 16, 13, 39},{58, 0, 13, 69},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z160_CNG19[19][4] = {{73, 143, 68, 60},{15, 134, 7, 48},{103, 27, 80, 30},{49, 101, 120, 37},{80, 1, 38, 61},{39, 133, 67, 15},{15, 4, 42, 79},{2, 80, 40, 121},{55, 129, 71, 143},{4, 140, 106, 93},{133, 76, 135, 4},{138, 106, 123, 53},{110, 72, 141, 44},{113, 83, 24, 28},{16, 100, 86, 77},{29, 141, 70, 159},{32, 0, 116, 68},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z224_CNG19[19][4] = {{223, 141, 207, 201},{16, 45, 203, 18},{94, 151, 31, 165},{91, 46, 176, 5},{74, 119, 180, 45},{10, 157, 186, 142},{0, 133, 95, 16},{205, 87, 153, 34},{216, 206, 177, 155},{21, 93, 70, 213},{215, 79, 77, 147},{14, 9, 214, 69},{70, 118, 77, 96},{141, 194, 198, 74},{198, 31, 117, 99},{104, 187, 223, 30},{81, 0, 90, 158},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z288_CNG19[19][4] = {{211, 179, 258, 187},{198, 162, 167, 145},{188, 223, 220, 166},{186, 256, 133, 108},{219, 160, 243, 82},{4, 76, 202, 132},{29, 202, 218, 197},{144, 117, 63, 41},{116, 109, 0, 162},{216, 15, 3, 57},{115, 72, 74, 36},{233, 152, 229, 115},{144, 158, 0, 242},{95, 147, 216, 165},{216, 156, 269, 0},{73, 119, 200, 113},{261, 0, 234, 108},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z352_CNG19[19][4] = {{294, 77, 226, 97},{118, 225, 35, 94},{167, 96, 213, 49},{330, 338, 302, 279},{207, 268, 111, 139},{165, 112, 265, 166},{243, 302, 128, 91},{250, 50, 237, 106},{1, 167, 294, 246},{339, 253, 127, 345},{201, 334, 110, 269},{53, 242, 286, 185},{347, 257, 125, 249},{304, 133, 131, 215},{167, 9, 163, 143},{47, 302, 210, 121},{188, 0, 7, 121},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z128_CNG19[19][4] = {{122, 2, 106, 121},{69, 111, 111, 89},{98, 117, 57, 84},{31, 124, 63, 20},{100, 71, 117, 22},{10, 94, 93, 3},{59, 104, 101, 115},{101, 45, 49, 8},{110, 92, 95, 86},{63, 102, 39, 118},{9, 109, 14, 91},{67, 4, 97, 83},{23, 14, 97, 112},{62, 27, 117, 76},{35, 127, 77, 116},{111, 28, 123, 16},{31, 0, 117, 12},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z192_CNG19[19][4] = {{115, 76, 13, 84},{19, 76, 58, 87},{50, 73, 136, 0},{177, 96, 140, 83},{181, 144, 64, 7},{24, 139, 161, 153},{125, 139, 75, 56},{96, 178, 160, 132},{109, 103, 63, 113},{17, 150, 129, 39},{165, 25, 8, 149},{23, 99, 88, 20},{106, 162, 53, 112},{50, 114, 131, 108},{180, 139, 48, 79},{138, 112, 13, 39},{154, 0, 13, 165},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z320_CNG19[19][4] = {{73, 303, 68, 220},{15, 294, 7, 208},{103, 27, 80, 30},{49, 261, 280, 197},{240, 161, 38, 61},{39, 133, 227, 175},{15, 4, 202, 79},{162, 80, 200, 281},{215, 129, 71, 303},{164, 300, 106, 253},{133, 76, 295, 164},{298, 266, 283, 53},{110, 72, 301, 44},{113, 83, 184, 28},{16, 260, 246, 77},{189, 301, 230, 319},{32, 0, 276, 68},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z256_CNG19[19][4] = {{250, 2, 106, 121},{69, 239, 111, 89},{226, 117, 185, 84},{159, 124, 63, 20},{100, 71, 117, 150},{10, 222, 93, 131},{59, 104, 229, 243},{229, 173, 177, 136},{110, 220, 95, 86},{191, 102, 39, 246},{9, 109, 142, 219},{195, 132, 225, 211},{23, 142, 225, 240},{190, 155, 245, 76},{35, 255, 205, 244},{239, 28, 251, 144},{31, 0, 117, 12},{1, 0, 0, 1},{0, 0, 0, 0}};
static const uint16_t circShift_BG1_Z384_CNG19[19][4] = {{307, 76, 205, 276},{19, 76, 250, 87},{50, 73, 328, 0},{369, 288, 332, 275},{181, 144, 256, 199},{216, 331, 161, 153},{317, 331, 267, 56},{288, 178, 160, 132},{109, 295, 63, 305},{17, 342, 129, 231},{357, 217, 200, 341},{215, 99, 88, 212},{106, 354, 53, 304},{242, 114, 131, 300},{180, 331, 240, 271},{330, 112, 205, 39},{346, 0, 13, 357},{1, 0, 0, 1},{0, 0, 0, 0}};

// BG2
// CNG3
static const uint16_t circShift_BG2_Z2_CNG3[3][6] = {{0, 0, 0, 0, 0, 1},{1, 0, 1, 0, 1, 1},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z3_CNG3[3][6] = {{2, 0, 1, 2, 0, 1},{1, 0, 2, 2, 2, 1},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z4_CNG3[3][6] = {{2, 0, 0, 2, 2, 3},{3, 0, 3, 0, 1, 3},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z5_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 0, 2, 4, 0, 4},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z6_CNG3[3][6] = {{2, 3, 1, 2, 3, 1},{4, 3, 2, 5, 2, 1},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z7_CNG3[3][6] = {{0, 1, 6, 3, 0, 5},{1, 3, 6, 5, 0, 5},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z8_CNG3[3][6] = {{6, 4, 0, 2, 2, 3},{7, 4, 7, 4, 1, 7},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z9_CNG3[3][6] = {{0, 2, 4, 7, 8, 7},{6, 0, 1, 7, 4, 2},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z10_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 5, 2, 4, 0, 4},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z11_CNG3[3][6] = {{7, 6, 9, 7, 7, 2},{9, 4, 5, 7, 5, 5},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z12_CNG3[3][6] = {{8, 9, 7, 2, 3, 1},{4, 9, 2, 5, 2, 7},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z13_CNG3[3][6] = {{7, 2, 12, 11, 11, 12},{9, 12, 11, 1, 7, 11},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z14_CNG3[3][6] = {{7, 1, 13, 10, 7, 12},{1, 10, 6, 5, 0, 12},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z15_CNG3[3][6] = {{0, 6, 4, 10, 6, 4},{14, 5, 1, 12, 1, 9},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z16_CNG3[3][6] = {{14, 4, 8, 2, 10, 11},{15, 12, 7, 12, 1, 7},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z18_CNG3[3][6] = {{0, 2, 13, 7, 8, 7},{6, 9, 10, 7, 13, 2},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z20_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 5, 12, 14, 0, 4},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z22_CNG3[3][6] = {{18, 6, 20, 7, 7, 13},{9, 4, 16, 7, 16, 16},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z24_CNG3[3][6] = {{20, 21, 7, 14, 3, 13},{4, 21, 2, 17, 2, 7},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z26_CNG3[3][6] = {{20, 15, 12, 24, 11, 25},{22, 12, 11, 1, 7, 11},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z28_CNG3[3][6] = {{21, 15, 27, 24, 7, 12},{1, 10, 6, 5, 14, 12},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z30_CNG3[3][6] = {{15, 6, 4, 25, 21, 4},{14, 5, 1, 27, 16, 24},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z32_CNG3[3][6] = {{30, 4, 8, 18, 10, 27},{31, 28, 23, 28, 1, 23},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z36_CNG3[3][6] = {{18, 20, 13, 25, 8, 25},{24, 27, 10, 25, 31, 20},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z40_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 25, 32, 34, 20, 24},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z44_CNG3[3][6] = {{18, 28, 42, 7, 29, 35},{31, 4, 16, 29, 16, 38},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z48_CNG3[3][6] = {{20, 45, 7, 14, 3, 37},{4, 21, 2, 17, 26, 31},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z52_CNG3[3][6] = {{46, 41, 12, 50, 11, 25},{22, 38, 37, 27, 33, 37},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z56_CNG3[3][6] = {{49, 43, 27, 52, 35, 40},{1, 38, 6, 5, 14, 12},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z60_CNG3[3][6] = {{15, 6, 4, 25, 21, 34},{44, 35, 1, 57, 46, 54},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z64_CNG3[3][6] = {{30, 36, 8, 18, 42, 27},{63, 28, 23, 28, 1, 23},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z72_CNG3[3][6] = {{54, 56, 13, 61, 8, 25},{60, 63, 10, 25, 67, 56},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z80_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 65, 32, 74, 20, 64},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z88_CNG3[3][6] = {{18, 72, 42, 51, 29, 79},{75, 48, 16, 73, 60, 38},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z96_CNG3[3][6] = {{20, 45, 7, 14, 3, 37},{52, 21, 50, 17, 74, 31},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z104_CNG3[3][6] = {{98, 93, 64, 50, 11, 77},{22, 90, 89, 27, 85, 89},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z112_CNG3[3][6] = {{49, 99, 27, 108, 35, 40},{1, 94, 6, 61, 70, 12},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z120_CNG3[3][6] = {{75, 66, 64, 25, 81, 34},{44, 95, 61, 57, 46, 114},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z128_CNG3[3][6] = {{94, 100, 8, 18, 106, 91},{63, 28, 23, 28, 1, 23},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z144_CNG3[3][6] = {{54, 128, 13, 133, 80, 97},{132, 63, 10, 25, 139, 56},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z160_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 65, 32, 154, 20, 144},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z176_CNG3[3][6] = {{18, 72, 42, 139, 117, 167},{163, 136, 104, 161, 148, 38},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z192_CNG3[3][6] = {{20, 45, 103, 110, 3, 37},{52, 21, 50, 17, 170, 31},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z208_CNG3[3][6] = {{202, 197, 168, 50, 115, 181},{126, 194, 193, 27, 189, 193},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z224_CNG3[3][6] = {{49, 211, 27, 108, 147, 40},{1, 94, 118, 61, 182, 12},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z240_CNG3[3][6] = {{195, 66, 64, 25, 201, 154},{44, 95, 181, 57, 46, 114},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z256_CNG3[3][6] = {{222, 228, 8, 18, 106, 219},{63, 156, 151, 28, 1, 151},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z288_CNG3[3][6] = {{54, 128, 13, 133, 80, 97},{132, 63, 10, 25, 139, 56},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z320_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{4, 65, 32, 154, 20, 144},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z352_CNG3[3][6] = {{18, 72, 42, 139, 117, 167},{163, 136, 104, 161, 148, 38},{0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z384_CNG3[3][6] = {{20, 45, 103, 110, 3, 37},{52, 21, 50, 17, 170, 31},{0, 0, 0, 0, 0, 0}};
// CNG4
static const uint16_t circShift_BG2_Z2_CNG4[4][20] = {{1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1},{0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1},{1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z3_CNG4[4][20] = {{0, 1, 0, 2, 0, 1, 1, 1, 1, 2, 1, 0, 0, 2, 2, 1, 0, 0, 1, 0},{2, 1, 0, 0, 0, 0, 1, 1, 2, 0, 0, 2, 2, 0, 1, 1, 1, 0, 2, 1},{2, 2, 2, 0, 1, 0, 0, 1, 2, 1, 0, 2, 1, 0, 0, 2, 1, 0, 1, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z4_CNG4[4][20] = {{3, 2, 3, 3, 0, 3, 2, 0, 3, 2, 2, 2, 0, 3, 1, 0, 3, 3, 0, 1},{2, 2, 3, 3, 2, 0, 1, 2, 3, 3, 1, 0, 0, 1, 0, 2, 2, 0, 3, 1},{3, 2, 2, 1, 2, 1, 1, 2, 2, 0, 3, 2, 3, 0, 3, 2, 2, 2, 0, 2},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z5_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{1, 0, 3, 3, 3, 3, 3, 2, 0, 4, 1, 0, 3, 4, 2, 3, 3, 4, 1, 2},{2, 2, 3, 4, 1, 4, 4, 3, 3, 2, 0, 2, 3, 3, 1, 2, 4, 3, 3, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z6_CNG4[4][20] = {{0, 4, 3, 2, 0, 4, 4, 1, 4, 2, 4, 0, 3, 5, 5, 1, 0, 3, 1, 3},{2, 4, 3, 3, 0, 0, 1, 1, 2, 3, 3, 2, 5, 3, 4, 1, 1, 0, 5, 1},{5, 2, 5, 3, 4, 0, 3, 1, 5, 4, 0, 5, 4, 0, 0, 2, 4, 3, 1, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z7_CNG4[4][20] = {{4, 0, 4, 4, 5, 0, 6, 3, 2, 6, 6, 3, 1, 1, 0, 1, 2, 1, 0, 1},{2, 1, 0, 4, 2, 5, 6, 1, 5, 4, 2, 0, 5, 5, 4, 0, 6, 6, 0, 3},{3, 5, 4, 5, 2, 2, 1, 4, 1, 0, 4, 5, 4, 6, 6, 6, 4, 0, 1, 4},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z8_CNG4[4][20] = {{3, 6, 7, 3, 4, 7, 2, 4, 7, 6, 2, 2, 4, 3, 1, 4, 7, 7, 0, 1},{6, 6, 7, 7, 2, 4, 1, 2, 3, 3, 5, 4, 4, 5, 0, 6, 2, 4, 3, 5},{7, 6, 6, 5, 2, 1, 5, 2, 6, 0, 7, 6, 3, 4, 7, 2, 6, 2, 0, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z9_CNG4[4][20] = {{6, 7, 6, 4, 8, 7, 2, 1, 5, 3, 7, 5, 0, 1, 6, 4, 1, 2, 6, 3},{6, 6, 5, 6, 7, 1, 4, 3, 7, 6, 5, 8, 6, 7, 2, 3, 7, 5, 1, 2},{6, 7, 5, 2, 7, 5, 6, 0, 2, 2, 7, 8, 2, 6, 3, 8, 1, 7, 3, 1},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z10_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{6, 5, 3, 3, 8, 8, 8, 7, 5, 9, 6, 0, 8, 9, 7, 3, 3, 4, 6, 2},{7, 7, 8, 9, 6, 4, 4, 3, 8, 7, 0, 2, 3, 8, 6, 2, 9, 8, 3, 5},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z11_CNG4[4][20] = {{9, 9, 1, 5, 8, 2, 7, 2, 0, 3, 9, 6, 6, 0, 5, 7, 2, 10, 6, 0},{1, 9, 0, 4, 9, 3, 8, 1, 0, 9, 2, 7, 5, 8, 9, 0, 7, 6, 2, 6},{6, 7, 4, 7, 0, 2, 8, 7, 7, 6, 6, 10, 7, 8, 7, 8, 8, 6, 5, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z12_CNG4[4][20] = {{0, 10, 3, 8, 6, 10, 4, 1, 10, 2, 10, 0, 9, 5, 5, 1, 0, 9, 7, 3},{2, 10, 9, 3, 6, 6, 1, 7, 2, 9, 3, 8, 11, 9, 4, 7, 7, 0, 11, 7},{5, 8, 11, 9, 10, 0, 9, 7, 11, 4, 0, 5, 4, 0, 6, 2, 10, 9, 7, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z13_CNG4[4][20] = {{4, 10, 5, 5, 12, 6, 1, 10, 0, 9, 1, 6, 7, 2, 1, 2, 1, 12, 11, 9},{1, 8, 12, 4, 8, 7, 9, 5, 1, 5, 4, 0, 4, 9, 11, 11, 4, 1, 7, 2},{0, 9, 10, 11, 10, 0, 10, 10, 0, 10, 7, 7, 10, 11, 12, 10, 9, 4, 10, 11},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z14_CNG4[4][20] = {{4, 7, 4, 4, 12, 7, 6, 10, 2, 13, 6, 10, 1, 1, 7, 1, 9, 8, 0, 8},{2, 1, 7, 4, 2, 12, 6, 1, 12, 4, 2, 7, 12, 5, 11, 7, 13, 13, 7, 3},{3, 12, 11, 12, 2, 2, 1, 11, 8, 7, 11, 12, 11, 13, 13, 13, 4, 0, 8, 11},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z15_CNG4[4][20] = {{14, 11, 4, 8, 8, 9, 12, 13, 5, 6, 7, 14, 1, 4, 10, 13, 12, 2, 3, 8},{5, 4, 2, 7, 1, 9, 2, 13, 4, 4, 9, 14, 2, 0, 0, 7, 11, 0, 7, 5},{0, 0, 12, 7, 0, 13, 6, 11, 6, 10, 1, 11, 1, 6, 10, 1, 0, 9, 0, 5},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z16_CNG4[4][20] = {{3, 14, 15, 3, 12, 7, 10, 12, 7, 14, 2, 2, 4, 3, 9, 12, 15, 15, 0, 1},{6, 14, 15, 15, 2, 4, 9, 10, 11, 11, 5, 12, 4, 5, 8, 6, 2, 12, 11, 5},{7, 6, 14, 5, 2, 9, 13, 2, 14, 8, 7, 6, 11, 4, 15, 10, 6, 2, 8, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z18_CNG4[4][20] = {{6, 16, 15, 13, 17, 7, 2, 1, 14, 12, 16, 14, 9, 1, 6, 13, 1, 11, 6, 12},{6, 15, 14, 6, 16, 10, 13, 3, 7, 6, 5, 17, 6, 7, 11, 3, 16, 14, 1, 11},{15, 16, 5, 2, 16, 5, 6, 9, 2, 11, 7, 17, 2, 6, 3, 8, 1, 16, 12, 1},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z20_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{16, 5, 13, 13, 18, 18, 8, 17, 15, 9, 6, 0, 8, 19, 17, 3, 13, 4, 16, 2},{17, 7, 8, 19, 6, 14, 4, 13, 18, 7, 10, 2, 13, 18, 6, 2, 19, 18, 3, 15},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z22_CNG4[4][20] = {{20, 9, 12, 5, 19, 13, 18, 2, 0, 3, 20, 6, 17, 11, 16, 7, 2, 21, 6, 0},{1, 9, 11, 15, 9, 3, 8, 12, 0, 20, 2, 7, 5, 19, 20, 0, 7, 6, 2, 6},{17, 7, 4, 18, 0, 13, 19, 18, 18, 17, 17, 10, 7, 8, 18, 19, 19, 17, 16, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z24_CNG4[4][20] = {{0, 22, 15, 20, 18, 10, 4, 13, 10, 14, 22, 12, 21, 5, 5, 1, 12, 21, 7, 3},{2, 22, 21, 15, 6, 18, 13, 7, 14, 9, 15, 8, 11, 9, 16, 7, 7, 12, 11, 7},{5, 8, 11, 9, 22, 12, 9, 19, 23, 16, 0, 17, 4, 12, 18, 2, 22, 9, 19, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z26_CNG4[4][20] = {{17, 23, 18, 18, 25, 6, 14, 10, 0, 9, 14, 6, 7, 15, 1, 15, 1, 25, 11, 9},{1, 21, 25, 4, 21, 20, 9, 18, 14, 5, 4, 0, 17, 9, 11, 11, 17, 1, 7, 15},{13, 22, 23, 24, 10, 0, 10, 23, 13, 10, 20, 7, 23, 11, 25, 23, 9, 17, 23, 11},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z28_CNG4[4][20] = {{4, 7, 18, 4, 12, 7, 6, 24, 16, 13, 20, 24, 15, 1, 7, 1, 9, 22, 14, 8},{16, 15, 21, 4, 16, 26, 20, 15, 26, 4, 16, 21, 12, 5, 25, 7, 13, 13, 7, 17},{17, 12, 25, 26, 16, 2, 1, 25, 22, 7, 25, 26, 25, 13, 27, 27, 18, 14, 8, 25},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z30_CNG4[4][20] = {{29, 26, 4, 8, 8, 9, 27, 28, 5, 21, 7, 29, 16, 4, 25, 28, 12, 17, 18, 23},{20, 19, 2, 7, 1, 24, 17, 13, 4, 19, 24, 14, 2, 15, 15, 22, 11, 15, 7, 5},{0, 15, 12, 7, 0, 28, 6, 11, 21, 10, 16, 26, 16, 21, 25, 16, 15, 9, 0, 20},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z32_CNG4[4][20] = {{19, 14, 31, 19, 28, 23, 26, 12, 23, 14, 2, 18, 4, 19, 25, 12, 31, 15, 0, 1},{22, 30, 15, 15, 2, 20, 9, 10, 11, 11, 5, 12, 4, 21, 8, 6, 2, 12, 11, 5},{7, 6, 14, 21, 18, 25, 29, 18, 14, 8, 7, 6, 11, 4, 31, 26, 6, 2, 24, 22},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z36_CNG4[4][20] = {{6, 34, 33, 31, 17, 7, 2, 19, 32, 30, 34, 32, 27, 1, 24, 13, 1, 11, 6, 12},{24, 33, 14, 24, 34, 28, 31, 3, 7, 6, 5, 17, 6, 25, 29, 21, 34, 32, 1, 11},{15, 16, 23, 20, 34, 5, 6, 9, 20, 29, 7, 35, 2, 6, 21, 26, 1, 34, 30, 19},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z40_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{16, 25, 33, 33, 18, 38, 28, 17, 35, 29, 6, 20, 8, 19, 37, 23, 13, 24, 36, 2},{37, 7, 8, 19, 6, 34, 24, 33, 38, 7, 30, 2, 13, 38, 6, 2, 19, 18, 23, 15},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z44_CNG4[4][20] = {{42, 9, 34, 5, 41, 13, 40, 24, 22, 25, 20, 28, 17, 11, 38, 29, 24, 21, 28, 0},{23, 31, 11, 15, 31, 3, 8, 34, 0, 20, 24, 29, 5, 41, 20, 22, 7, 6, 24, 6},{39, 29, 4, 40, 22, 13, 41, 40, 18, 17, 17, 10, 29, 30, 40, 41, 19, 17, 38, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z48_CNG4[4][20] = {{24, 22, 39, 20, 42, 10, 28, 13, 10, 38, 22, 36, 21, 29, 29, 25, 36, 45, 7, 3},{26, 22, 45, 15, 6, 42, 13, 31, 38, 9, 15, 8, 35, 33, 40, 7, 7, 36, 11, 7},{29, 8, 11, 33, 46, 12, 9, 19, 47, 16, 24, 17, 28, 12, 18, 26, 46, 9, 19, 12},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z52_CNG4[4][20] = {{43, 49, 18, 18, 25, 6, 40, 10, 0, 9, 14, 6, 7, 41, 1, 41, 1, 25, 37, 35},{27, 21, 51, 4, 47, 20, 35, 18, 14, 5, 30, 0, 17, 35, 11, 11, 17, 1, 7, 41},{13, 22, 49, 50, 36, 0, 10, 23, 13, 36, 46, 7, 23, 37, 25, 23, 35, 17, 23, 11},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z56_CNG4[4][20] = {{32, 35, 46, 4, 12, 35, 6, 24, 44, 41, 48, 52, 15, 29, 35, 1, 37, 50, 42, 8},{16, 43, 49, 32, 16, 26, 20, 43, 54, 32, 44, 21, 12, 33, 53, 7, 41, 13, 35, 45},{45, 40, 53, 54, 44, 30, 29, 25, 22, 7, 25, 54, 53, 13, 55, 27, 46, 42, 36, 25},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z60_CNG4[4][20] = {{29, 56, 4, 38, 8, 39, 57, 58, 5, 21, 7, 59, 46, 4, 25, 58, 42, 47, 18, 53},{20, 49, 2, 37, 31, 24, 47, 13, 34, 19, 24, 14, 2, 15, 45, 52, 41, 45, 7, 35},{0, 45, 12, 37, 30, 28, 6, 11, 51, 10, 16, 56, 46, 21, 55, 46, 45, 9, 0, 50},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z64_CNG4[4][20] = {{51, 14, 63, 51, 28, 23, 26, 12, 23, 46, 34, 50, 4, 19, 57, 12, 31, 47, 0, 1},{22, 30, 47, 47, 2, 20, 41, 42, 43, 11, 37, 44, 36, 21, 40, 38, 2, 44, 11, 37},{7, 38, 14, 21, 50, 57, 29, 18, 46, 8, 7, 38, 43, 36, 63, 26, 38, 34, 56, 54},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z72_CNG4[4][20] = {{42, 70, 33, 67, 17, 7, 2, 19, 68, 30, 34, 32, 63, 37, 60, 49, 1, 47, 6, 48},{24, 69, 50, 24, 34, 28, 31, 3, 43, 42, 5, 17, 6, 25, 65, 57, 70, 32, 1, 47},{51, 16, 59, 56, 70, 41, 6, 9, 56, 29, 43, 71, 2, 42, 21, 26, 1, 70, 30, 19},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z80_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{56, 65, 33, 73, 18, 78, 68, 17, 75, 69, 46, 20, 8, 19, 77, 63, 13, 24, 36, 2},{77, 7, 48, 19, 6, 74, 24, 33, 78, 7, 30, 42, 13, 78, 6, 2, 19, 58, 63, 55},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z88_CNG4[4][20] = {{86, 53, 34, 49, 85, 13, 40, 68, 22, 25, 64, 28, 17, 11, 38, 73, 24, 21, 72, 44},{67, 31, 11, 15, 31, 47, 52, 78, 44, 20, 24, 73, 49, 41, 64, 66, 7, 6, 68, 6},{83, 73, 4, 40, 22, 57, 85, 40, 62, 61, 61, 54, 29, 74, 84, 41, 19, 17, 82, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z96_CNG4[4][20] = {{72, 22, 39, 68, 90, 58, 76, 61, 10, 86, 70, 84, 69, 77, 77, 25, 84, 93, 7, 51},{74, 70, 93, 63, 6, 42, 61, 79, 86, 57, 15, 8, 83, 81, 88, 55, 55, 36, 11, 7},{29, 56, 11, 81, 46, 60, 57, 67, 95, 64, 72, 17, 28, 12, 18, 74, 94, 57, 67, 60},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z104_CNG4[4][20] = {{43, 101, 18, 70, 25, 6, 92, 10, 52, 9, 14, 6, 59, 93, 53, 93, 53, 77, 89, 87},{27, 73, 51, 4, 99, 20, 35, 18, 66, 57, 82, 0, 69, 87, 63, 63, 69, 53, 59, 93},{13, 22, 49, 102, 36, 52, 10, 23, 13, 88, 46, 59, 75, 89, 77, 75, 87, 69, 75, 63},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z112_CNG4[4][20] = {{88, 35, 46, 4, 68, 35, 6, 80, 44, 41, 104, 108, 71, 29, 91, 1, 37, 106, 98, 8},{16, 43, 105, 88, 16, 26, 20, 43, 54, 88, 100, 21, 12, 89, 53, 63, 97, 69, 35, 101},{101, 40, 109, 110, 44, 86, 29, 81, 22, 63, 81, 110, 109, 69, 55, 83, 46, 42, 36, 81},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z120_CNG4[4][20] = {{29, 56, 4, 38, 8, 39, 117, 118, 5, 81, 7, 59, 46, 64, 85, 58, 42, 47, 78, 53},{20, 49, 2, 97, 91, 84, 107, 13, 94, 19, 24, 14, 2, 15, 105, 112, 41, 45, 67, 95},{60, 105, 72, 37, 90, 88, 6, 11, 111, 10, 16, 116, 106, 21, 55, 106, 105, 69, 60, 110},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z128_CNG4[4][20] = {{51, 14, 63, 51, 92, 87, 26, 76, 23, 46, 98, 114, 4, 19, 57, 12, 31, 111, 0, 1},{86, 94, 111, 47, 66, 20, 105, 42, 107, 11, 101, 44, 36, 85, 40, 38, 66, 44, 75, 101},{71, 102, 14, 85, 50, 57, 29, 82, 110, 8, 7, 38, 107, 36, 63, 26, 38, 34, 120, 118},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z144_CNG4[4][20] = {{42, 70, 33, 139, 17, 79, 2, 91, 68, 30, 106, 32, 135, 37, 60, 121, 1, 119, 6, 48},{24, 69, 122, 96, 106, 28, 103, 75, 115, 42, 77, 89, 6, 25, 137, 129, 70, 32, 73, 47},{51, 88, 131, 128, 142, 41, 78, 81, 56, 101, 43, 71, 2, 114, 93, 26, 1, 142, 102, 19},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z160_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{136, 65, 113, 73, 18, 158, 148, 17, 75, 69, 126, 20, 88, 19, 157, 63, 93, 24, 36, 2},{157, 87, 48, 99, 86, 154, 104, 33, 158, 87, 110, 122, 13, 78, 6, 82, 19, 138, 143, 55},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z176_CNG4[4][20] = {{86, 53, 122, 137, 173, 13, 128, 156, 110, 113, 64, 116, 105, 11, 126, 73, 112, 109, 160, 132},{67, 31, 11, 103, 31, 135, 52, 166, 132, 108, 24, 73, 137, 41, 152, 154, 7, 6, 156, 6},{83, 161, 4, 40, 22, 145, 173, 40, 150, 61, 149, 142, 29, 162, 172, 129, 19, 105, 82, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z192_CNG4[4][20] = {{72, 118, 39, 68, 186, 58, 76, 157, 106, 182, 70, 84, 165, 173, 77, 25, 84, 93, 103, 147},{74, 70, 93, 63, 6, 42, 61, 175, 86, 153, 111, 8, 179, 177, 184, 151, 151, 132, 107, 7},{29, 152, 11, 81, 46, 156, 153, 67, 95, 64, 168, 17, 124, 12, 18, 170, 190, 57, 163, 60},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z208_CNG4[4][20] = {{43, 101, 18, 174, 129, 110, 196, 10, 52, 113, 14, 110, 163, 197, 157, 197, 157, 181, 193, 191},{27, 177, 155, 108, 203, 124, 35, 122, 170, 161, 186, 0, 173, 191, 167, 167, 173, 157, 163, 197},{117, 22, 49, 102, 140, 52, 114, 23, 13, 88, 46, 163, 179, 193, 181, 179, 191, 173, 179, 167},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z224_CNG4[4][20] = {{200, 147, 46, 116, 68, 35, 6, 80, 156, 153, 216, 108, 71, 29, 91, 1, 37, 106, 98, 120},{16, 43, 217, 200, 16, 138, 20, 43, 54, 88, 212, 21, 12, 201, 165, 175, 97, 181, 35, 101},{101, 152, 109, 110, 156, 86, 141, 81, 134, 63, 193, 110, 109, 69, 55, 83, 46, 154, 36, 81},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z240_CNG4[4][20] = {{29, 176, 124, 38, 128, 39, 117, 238, 5, 81, 7, 179, 46, 184, 85, 178, 42, 167, 78, 53},{140, 169, 122, 217, 211, 84, 227, 13, 94, 19, 144, 14, 2, 135, 225, 112, 41, 45, 67, 215},{180, 225, 72, 157, 210, 88, 6, 11, 111, 130, 16, 116, 106, 141, 175, 106, 105, 189, 180, 230},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z256_CNG4[4][20] = {{179, 142, 63, 51, 220, 87, 26, 76, 23, 46, 98, 242, 132, 147, 57, 140, 31, 239, 0, 129},{214, 94, 111, 175, 194, 20, 105, 42, 235, 139, 101, 44, 164, 85, 40, 38, 66, 172, 75, 229},{71, 230, 14, 213, 50, 185, 29, 210, 238, 8, 135, 166, 235, 36, 63, 154, 38, 34, 120, 118},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z288_CNG4[4][20] = {{42, 70, 33, 139, 17, 79, 2, 91, 68, 30, 106, 32, 135, 37, 60, 121, 1, 119, 6, 48},{24, 69, 122, 96, 106, 28, 103, 75, 115, 42, 77, 89, 6, 25, 137, 129, 70, 32, 73, 47},{51, 88, 131, 128, 142, 41, 78, 81, 56, 101, 43, 71, 2, 114, 93, 26, 1, 142, 102, 19},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z320_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{136, 65, 113, 73, 18, 158, 148, 17, 75, 69, 126, 20, 88, 19, 157, 63, 93, 24, 36, 2},{157, 87, 48, 99, 86, 154, 104, 33, 158, 87, 110, 122, 13, 78, 6, 82, 19, 138, 143, 55},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z352_CNG4[4][20] = {{86, 53, 122, 137, 173, 13, 128, 156, 110, 113, 64, 116, 105, 11, 126, 73, 112, 109, 160, 132},{67, 31, 11, 103, 31, 135, 52, 166, 132, 108, 24, 73, 137, 41, 152, 154, 7, 6, 156, 6},{83, 161, 4, 40, 22, 145, 173, 40, 150, 61, 149, 142, 29, 162, 172, 129, 19, 105, 82, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z384_CNG4[4][20] = {{72, 118, 39, 68, 186, 58, 76, 157, 106, 182, 70, 84, 165, 173, 77, 25, 84, 93, 103, 147},{74, 70, 93, 63, 6, 42, 61, 175, 86, 153, 111, 8, 179, 177, 184, 151, 151, 132, 107, 7},{29, 152, 11, 81, 46, 156, 153, 67, 95, 64, 168, 17, 124, 12, 18, 170, 190, 57, 163, 60},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
// CNG5
static const uint16_t circShift_BG2_Z2_CNG5[5][9] = {{1, 1, 1, 1, 1, 1, 0, 1, 1},{1, 1, 0, 0, 1, 0, 0, 1, 0},{1, 0, 0, 0, 1, 0, 0, 0, 1},{1, 1, 0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z3_CNG5[5][9] = {{1, 2, 2, 1, 1, 0, 2, 1, 0},{0, 2, 2, 2, 1, 0, 2, 2, 1},{2, 1, 0, 2, 0, 0, 0, 1, 1},{1, 1, 1, 1, 1, 1, 0, 1, 2},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z4_CNG5[5][9] = {{3, 3, 3, 3, 3, 3, 2, 1, 3},{1, 1, 0, 2, 1, 2, 0, 3, 0},{1, 0, 2, 2, 3, 0, 2, 0, 1},{3, 1, 0, 2, 0, 2, 0, 2, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z5_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{2, 2, 2, 2, 3, 4, 4, 0, 0},{1, 1, 4, 2, 2, 1, 4, 3, 1},{0, 0, 2, 1, 2, 3, 3, 2, 4},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z6_CNG5[5][9] = {{4, 5, 2, 1, 1, 3, 2, 1, 0},{0, 2, 2, 5, 4, 3, 5, 5, 4},{5, 4, 0, 5, 3, 3, 3, 1, 4},{4, 4, 4, 4, 1, 4, 0, 1, 2},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z7_CNG5[5][9] = {{2, 6, 1, 2, 1, 5, 6, 6, 1},{2, 3, 5, 1, 4, 4, 6, 6, 2},{2, 1, 5, 3, 5, 1, 3, 4, 3},{6, 0, 1, 0, 4, 6, 2, 6, 1},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z8_CNG5[5][9] = {{3, 3, 3, 3, 3, 3, 6, 5, 7},{5, 1, 4, 2, 1, 6, 4, 7, 0},{5, 0, 2, 6, 3, 0, 2, 0, 1},{7, 5, 0, 6, 0, 2, 0, 2, 4},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z9_CNG5[5][9] = {{7, 1, 1, 4, 8, 3, 3, 7, 6},{4, 5, 3, 1, 6, 0, 7, 1, 2},{6, 2, 8, 8, 4, 1, 2, 1, 5},{4, 6, 1, 2, 7, 8, 6, 7, 7},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z10_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{7, 7, 7, 2, 8, 9, 4, 0, 5},{1, 6, 4, 2, 7, 1, 9, 3, 1},{5, 0, 2, 6, 7, 3, 8, 7, 4},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z11_CNG5[5][9] = {{5, 1, 3, 7, 0, 1, 2, 3, 7},{10, 3, 10, 3, 2, 4, 1, 5, 8},{0, 9, 2, 5, 8, 6, 7, 9, 5},{9, 1, 9, 6, 1, 0, 9, 2, 7},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z12_CNG5[5][9] = {{4, 11, 8, 1, 7, 3, 2, 7, 0},{0, 8, 8, 5, 10, 9, 11, 5, 10},{5, 10, 6, 11, 9, 3, 9, 7, 4},{10, 4, 10, 10, 7, 4, 6, 1, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z13_CNG5[5][9] = {{4, 8, 0, 6, 0, 8, 5, 8, 5},{1, 8, 3, 1, 7, 5, 6, 3, 4},{10, 8, 9, 4, 0, 2, 12, 10, 11},{3, 12, 8, 4, 5, 7, 9, 5, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z14_CNG5[5][9] = {{2, 6, 1, 9, 8, 5, 6, 6, 8},{2, 10, 12, 1, 11, 4, 6, 6, 2},{2, 8, 12, 3, 12, 8, 10, 11, 3},{13, 0, 1, 0, 4, 13, 2, 6, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z15_CNG5[5][9] = {{2, 8, 13, 3, 7, 5, 1, 11, 7},{13, 7, 4, 12, 7, 8, 8, 6, 4},{3, 13, 3, 2, 9, 10, 0, 10, 11},{8, 7, 6, 9, 12, 7, 8, 11, 2},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z16_CNG5[5][9] = {{11, 11, 11, 3, 3, 11, 14, 13, 7},{13, 9, 12, 2, 1, 14, 12, 15, 0},{13, 0, 2, 6, 3, 8, 2, 0, 9},{7, 5, 8, 14, 8, 2, 0, 10, 4},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z18_CNG5[5][9] = {{7, 10, 10, 4, 17, 12, 12, 16, 15},{4, 5, 12, 1, 15, 9, 7, 10, 2},{6, 11, 8, 8, 4, 10, 11, 10, 14},{13, 6, 10, 11, 7, 8, 6, 7, 16},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z20_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{17, 17, 7, 12, 18, 19, 4, 0, 15},{11, 16, 4, 2, 17, 11, 9, 13, 11},{5, 0, 2, 6, 7, 3, 18, 7, 14},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z22_CNG5[5][9] = {{16, 1, 3, 7, 11, 12, 2, 14, 18},{10, 3, 21, 3, 13, 4, 1, 16, 19},{11, 20, 2, 5, 8, 17, 18, 9, 5},{20, 1, 9, 17, 12, 11, 9, 13, 7},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z24_CNG5[5][9] = {{4, 11, 8, 1, 19, 15, 14, 19, 0},{12, 8, 20, 5, 22, 9, 23, 17, 10},{17, 22, 6, 11, 21, 15, 9, 7, 4},{10, 4, 10, 22, 19, 16, 6, 13, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z26_CNG5[5][9] = {{4, 21, 13, 6, 13, 21, 5, 8, 18},{1, 8, 3, 1, 20, 5, 19, 16, 17},{23, 21, 9, 17, 0, 2, 12, 23, 24},{3, 25, 8, 4, 5, 20, 9, 5, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z28_CNG5[5][9] = {{2, 6, 15, 9, 8, 19, 20, 6, 22},{2, 10, 26, 1, 11, 18, 20, 6, 16},{16, 8, 26, 3, 12, 22, 10, 25, 17},{27, 0, 15, 0, 4, 13, 2, 6, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z30_CNG5[5][9] = {{17, 8, 28, 18, 22, 20, 16, 26, 7},{28, 7, 4, 27, 22, 23, 23, 6, 19},{18, 28, 18, 17, 24, 25, 15, 10, 11},{8, 22, 21, 9, 12, 22, 8, 26, 17},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z32_CNG5[5][9] = {{11, 11, 11, 19, 19, 11, 30, 29, 7},{13, 25, 12, 2, 17, 14, 28, 15, 16},{29, 0, 18, 6, 3, 8, 18, 0, 9},{23, 21, 24, 30, 8, 18, 0, 26, 20},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z36_CNG5[5][9] = {{25, 10, 28, 4, 35, 12, 12, 34, 15},{4, 5, 30, 1, 15, 9, 7, 28, 20},{24, 29, 8, 26, 22, 28, 29, 28, 32},{13, 24, 28, 11, 25, 8, 6, 25, 34},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z40_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{17, 17, 7, 32, 18, 39, 24, 20, 35},{11, 36, 4, 22, 17, 31, 29, 13, 11},{5, 20, 2, 26, 27, 23, 18, 7, 14},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z44_CNG5[5][9] = {{16, 23, 3, 29, 11, 34, 2, 36, 40},{10, 25, 43, 3, 13, 26, 23, 38, 41},{11, 42, 24, 27, 8, 17, 18, 9, 5},{20, 23, 9, 39, 34, 33, 31, 13, 29},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z48_CNG5[5][9] = {{28, 11, 32, 1, 19, 39, 14, 19, 24},{36, 8, 44, 29, 22, 33, 23, 41, 10},{41, 22, 30, 35, 21, 39, 9, 7, 4},{34, 4, 10, 22, 19, 16, 6, 37, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z52_CNG5[5][9] = {{30, 21, 39, 32, 39, 21, 5, 8, 18},{27, 8, 29, 1, 20, 31, 45, 16, 17},{49, 21, 35, 43, 0, 2, 38, 49, 50},{29, 51, 8, 30, 5, 20, 35, 5, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z56_CNG5[5][9] = {{2, 6, 43, 37, 36, 19, 48, 34, 50},{30, 38, 26, 1, 39, 46, 20, 6, 44},{16, 8, 54, 31, 40, 22, 38, 53, 17},{27, 0, 43, 28, 4, 41, 2, 6, 8},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z60_CNG5[5][9] = {{47, 38, 58, 48, 22, 50, 16, 26, 37},{58, 37, 34, 57, 52, 23, 53, 6, 19},{48, 28, 48, 47, 24, 55, 15, 10, 41},{8, 52, 51, 39, 42, 22, 38, 26, 17},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z64_CNG5[5][9] = {{11, 11, 11, 19, 51, 11, 62, 29, 7},{13, 57, 44, 2, 17, 14, 60, 15, 48},{61, 0, 18, 38, 3, 8, 50, 32, 9},{55, 53, 56, 30, 40, 50, 0, 58, 20},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z72_CNG5[5][9] = {{25, 46, 28, 4, 71, 48, 48, 70, 15},{40, 41, 30, 37, 51, 9, 43, 28, 56},{24, 29, 44, 62, 58, 28, 65, 28, 32},{49, 24, 64, 47, 25, 8, 42, 61, 70},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z80_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{17, 17, 7, 32, 58, 79, 24, 20, 35},{51, 76, 4, 22, 57, 31, 29, 13, 51},{5, 20, 2, 26, 27, 63, 18, 7, 54},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z88_CNG5[5][9] = {{16, 23, 3, 29, 11, 78, 46, 36, 84},{54, 25, 87, 3, 57, 70, 23, 38, 85},{11, 86, 24, 27, 8, 17, 62, 53, 5},{64, 23, 53, 39, 78, 77, 75, 57, 29},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z96_CNG5[5][9] = {{28, 59, 32, 49, 19, 87, 62, 67, 24},{36, 8, 92, 29, 22, 81, 23, 41, 58},{89, 22, 78, 35, 21, 39, 9, 55, 52},{82, 52, 58, 70, 67, 64, 6, 85, 56},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z104_CNG5[5][9] = {{82, 21, 39, 32, 91, 21, 57, 60, 70},{27, 60, 29, 53, 20, 31, 97, 68, 17},{101, 73, 35, 95, 52, 54, 38, 49, 50},{81, 51, 8, 82, 5, 72, 35, 57, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z112_CNG5[5][9] = {{2, 62, 99, 37, 36, 75, 48, 90, 106},{30, 38, 26, 1, 95, 46, 20, 6, 44},{72, 8, 110, 31, 40, 22, 94, 109, 73},{83, 56, 99, 28, 4, 97, 2, 6, 64},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z120_CNG5[5][9] = {{47, 38, 58, 48, 82, 50, 76, 26, 37},{118, 97, 94, 57, 112, 23, 53, 66, 19},{48, 88, 48, 47, 84, 55, 75, 70, 101},{68, 112, 51, 99, 42, 82, 98, 86, 17},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z128_CNG5[5][9] = {{75, 11, 11, 83, 115, 75, 126, 29, 71},{77, 57, 108, 2, 17, 14, 124, 15, 112},{61, 0, 82, 38, 3, 8, 114, 32, 9},{119, 117, 56, 94, 104, 114, 64, 122, 84},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z144_CNG5[5][9] = {{97, 46, 28, 76, 143, 48, 120, 142, 87},{40, 41, 30, 37, 51, 9, 43, 28, 56},{24, 101, 116, 62, 130, 28, 65, 100, 104},{49, 96, 64, 47, 97, 8, 42, 133, 70},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z160_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{97, 17, 7, 112, 138, 79, 24, 100, 35},{51, 156, 4, 102, 57, 111, 109, 13, 51},{85, 20, 2, 26, 27, 143, 18, 7, 134},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z176_CNG5[5][9] = {{104, 111, 91, 29, 11, 78, 134, 36, 84},{142, 25, 175, 91, 145, 158, 23, 38, 173},{99, 174, 24, 27, 8, 17, 62, 53, 93},{64, 23, 141, 127, 166, 165, 163, 145, 29},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z192_CNG5[5][9] = {{28, 59, 32, 49, 19, 87, 158, 67, 120},{132, 104, 92, 125, 118, 177, 23, 137, 154},{185, 22, 174, 35, 21, 135, 9, 55, 52},{178, 52, 154, 166, 163, 64, 6, 85, 56},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z208_CNG5[5][9] = {{186, 125, 39, 32, 91, 125, 57, 164, 70},{27, 60, 29, 53, 20, 31, 201, 172, 17},{205, 177, 35, 95, 52, 54, 142, 49, 50},{81, 51, 8, 186, 109, 176, 35, 161, 6},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z224_CNG5[5][9] = {{2, 174, 99, 37, 36, 75, 48, 90, 106},{30, 150, 138, 113, 95, 158, 132, 6, 44},{184, 8, 110, 143, 40, 134, 206, 221, 185},{83, 56, 99, 140, 116, 97, 2, 6, 176},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z240_CNG5[5][9] = {{167, 38, 178, 48, 82, 170, 196, 146, 37},{238, 217, 214, 57, 232, 23, 173, 66, 139},{48, 208, 168, 167, 204, 175, 195, 190, 221},{68, 232, 51, 219, 162, 202, 218, 86, 17},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z256_CNG5[5][9] = {{203, 11, 11, 83, 115, 203, 254, 29, 71},{205, 185, 236, 2, 145, 142, 124, 143, 240},{61, 0, 210, 38, 3, 8, 114, 160, 9},{247, 117, 56, 222, 232, 242, 64, 122, 84},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z288_CNG5[5][9] = {{97, 46, 28, 76, 143, 48, 120, 142, 87},{40, 41, 30, 37, 51, 9, 43, 28, 56},{24, 101, 116, 62, 130, 28, 65, 100, 104},{49, 96, 64, 47, 97, 8, 42, 133, 70},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z320_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{97, 17, 7, 112, 138, 79, 24, 100, 35},{51, 156, 4, 102, 57, 111, 109, 13, 51},{85, 20, 2, 26, 27, 143, 18, 7, 134},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z352_CNG5[5][9] = {{104, 111, 91, 29, 11, 78, 134, 36, 84},{142, 25, 175, 91, 145, 158, 23, 38, 173},{99, 174, 24, 27, 8, 17, 62, 53, 93},{64, 23, 141, 127, 166, 165, 163, 145, 29},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint16_t circShift_BG2_Z384_CNG5[5][9] = {{28, 59, 32, 49, 19, 87, 158, 67, 120},{132, 104, 92, 125, 118, 177, 23, 137, 154},{185, 22, 174, 35, 21, 135, 9, 55, 52},{178, 52, 154, 166, 163, 64, 6, 85, 56},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
// CNG6
static const uint16_t circShift_BG2_Z2_CNG6[6][3] = {{1, 1, 1},{1, 0, 1},{0, 1, 0},{1, 0, 1},{1, 0, 0},{0, 0, 0}};
static const uint16_t circShift_BG2_Z3_CNG6[6][3] = {{1, 0, 2},{2, 2, 0},{1, 1, 1},{2, 1, 0},{0, 1, 2},{0, 0, 0}};
static const uint16_t circShift_BG2_Z4_CNG6[6][3] = {{3, 3, 1},{1, 0, 3},{2, 1, 0},{3, 0, 3},{3, 2, 0},{0, 0, 0}};
static const uint16_t circShift_BG2_Z5_CNG6[6][3] = {{0, 0, 0},{1, 4, 0},{2, 4, 3},{1, 0, 1},{4, 3, 3},{0, 0, 0}};
static const uint16_t circShift_BG2_Z6_CNG6[6][3] = {{4, 3, 2},{2, 2, 0},{1, 4, 4},{2, 1, 0},{0, 4, 5},{0, 0, 0}};
static const uint16_t circShift_BG2_Z7_CNG6[6][3] = {{3, 4, 5},{5, 6, 6},{2, 3, 0},{2, 5, 3},{4, 6, 6},{0, 0, 0}};
static const uint16_t circShift_BG2_Z8_CNG6[6][3] = {{7, 3, 1},{1, 4, 3},{2, 5, 4},{7, 4, 3},{7, 6, 4},{0, 0, 0}};
static const uint16_t circShift_BG2_Z9_CNG6[6][3] = {{4, 1, 7},{5, 6, 0},{3, 8, 8},{2, 7, 0},{8, 4, 2},{0, 0, 0}};
static const uint16_t circShift_BG2_Z10_CNG6[6][3] = {{0, 0, 0},{1, 4, 5},{2, 9, 8},{1, 5, 6},{4, 8, 8},{0, 0, 0}};
static const uint16_t circShift_BG2_Z11_CNG6[6][3] = {{2, 3, 4},{7, 0, 4},{2, 10, 2},{4, 1, 3},{5, 7, 0},{0, 0, 0}};
static const uint16_t circShift_BG2_Z12_CNG6[6][3] = {{10, 9, 8},{8, 8, 6},{1, 4, 4},{8, 1, 6},{0, 4, 11},{0, 0, 0}};
static const uint16_t circShift_BG2_Z13_CNG6[6][3] = {{6, 7, 7},{10, 8, 0},{10, 3, 0},{2, 12, 3},{10, 12, 6},{0, 0, 0}};
static const uint16_t circShift_BG2_Z14_CNG6[6][3] = {{3, 11, 5},{12, 13, 13},{2, 3, 7},{9, 12, 10},{11, 13, 13},{0, 0, 0}};
static const uint16_t circShift_BG2_Z15_CNG6[6][3] = {{1, 2, 11},{11, 12, 6},{4, 7, 12},{13, 4, 7},{12, 11, 4},{0, 0, 0}};
static const uint16_t circShift_BG2_Z16_CNG6[6][3] = {{7, 11, 1},{9, 4, 3},{2, 13, 12},{15, 12, 3},{7, 14, 4},{0, 0, 0}};
static const uint16_t circShift_BG2_Z18_CNG6[6][3] = {{4, 1, 7},{14, 15, 9},{12, 17, 17},{11, 7, 0},{17, 13, 11},{0, 0, 0}};
static const uint16_t circShift_BG2_Z20_CNG6[6][3] = {{0, 0, 0},{11, 4, 5},{2, 19, 8},{1, 5, 16},{4, 8, 18},{0, 0, 0}};
static const uint16_t circShift_BG2_Z22_CNG6[6][3] = {{13, 3, 4},{18, 0, 15},{13, 10, 2},{15, 1, 3},{16, 7, 11},{0, 0, 0}};
static const uint16_t circShift_BG2_Z24_CNG6[6][3] = {{10, 9, 8},{20, 20, 18},{1, 4, 16},{8, 1, 6},{0, 16, 23},{0, 0, 0}};
static const uint16_t circShift_BG2_Z26_CNG6[6][3] = {{6, 7, 7},{23, 8, 0},{10, 16, 13},{2, 12, 3},{10, 12, 6},{0, 0, 0}};
static const uint16_t circShift_BG2_Z28_CNG6[6][3] = {{17, 11, 19},{26, 27, 13},{2, 3, 21},{23, 26, 10},{25, 13, 13},{0, 0, 0}};
static const uint16_t circShift_BG2_Z30_CNG6[6][3] = {{1, 17, 26},{11, 12, 6},{19, 22, 27},{28, 4, 22},{27, 26, 4},{0, 0, 0}};
static const uint16_t circShift_BG2_Z32_CNG6[6][3] = {{7, 27, 1},{9, 4, 19},{2, 13, 12},{31, 28, 3},{7, 30, 20},{0, 0, 0}};
static const uint16_t circShift_BG2_Z36_CNG6[6][3] = {{4, 1, 25},{32, 15, 27},{12, 35, 35},{29, 25, 0},{35, 31, 29},{0, 0, 0}};
static const uint16_t circShift_BG2_Z40_CNG6[6][3] = {{0, 0, 0},{11, 4, 5},{22, 19, 28},{21, 5, 16},{24, 28, 38},{0, 0, 0}};
static const uint16_t circShift_BG2_Z44_CNG6[6][3] = {{35, 3, 4},{40, 22, 37},{35, 10, 24},{15, 23, 3},{16, 29, 11},{0, 0, 0}};
static const uint16_t circShift_BG2_Z48_CNG6[6][3] = {{10, 33, 32},{44, 44, 42},{25, 4, 16},{32, 1, 6},{0, 40, 47},{0, 0, 0}};
static const uint16_t circShift_BG2_Z52_CNG6[6][3] = {{32, 7, 7},{49, 34, 26},{36, 42, 39},{28, 12, 3},{10, 12, 6},{0, 0, 0}};
static const uint16_t circShift_BG2_Z56_CNG6[6][3] = {{17, 11, 47},{26, 55, 13},{2, 31, 49},{51, 54, 38},{25, 41, 13},{0, 0, 0}};
static const uint16_t circShift_BG2_Z60_CNG6[6][3] = {{1, 17, 26},{41, 12, 6},{49, 52, 27},{28, 4, 52},{27, 56, 34},{0, 0, 0}};
static const uint16_t circShift_BG2_Z64_CNG6[6][3] = {{39, 27, 1},{41, 36, 19},{2, 45, 12},{31, 28, 3},{39, 30, 52},{0, 0, 0}};
static const uint16_t circShift_BG2_Z72_CNG6[6][3] = {{40, 37, 25},{68, 15, 63},{12, 35, 35},{65, 61, 36},{71, 67, 65},{0, 0, 0}};
static const uint16_t circShift_BG2_Z80_CNG6[6][3] = {{0, 0, 0},{51, 44, 45},{62, 19, 68},{61, 45, 16},{64, 68, 78},{0, 0, 0}};
static const uint16_t circShift_BG2_Z88_CNG6[6][3] = {{79, 47, 48},{84, 66, 37},{35, 10, 24},{15, 67, 47},{60, 29, 55},{0, 0, 0}};
static const uint16_t circShift_BG2_Z96_CNG6[6][3] = {{10, 33, 80},{44, 92, 90},{25, 4, 16},{80, 49, 6},{48, 88, 47},{0, 0, 0}};
static const uint16_t circShift_BG2_Z104_CNG6[6][3] = {{32, 7, 59},{49, 34, 78},{36, 94, 39},{28, 64, 3},{62, 12, 58},{0, 0, 0}};
static const uint16_t circShift_BG2_Z112_CNG6[6][3] = {{73, 11, 103},{26, 55, 13},{58, 31, 105},{107, 110, 38},{81, 97, 69},{0, 0, 0}};
static const uint16_t circShift_BG2_Z120_CNG6[6][3] = {{1, 17, 86},{41, 72, 66},{49, 52, 87},{88, 4, 52},{87, 56, 34},{0, 0, 0}};
static const uint16_t circShift_BG2_Z128_CNG6[6][3] = {{103, 27, 1},{41, 100, 19},{66, 45, 12},{31, 28, 3},{103, 30, 116},{0, 0, 0}};
static const uint16_t circShift_BG2_Z144_CNG6[6][3] = {{40, 109, 97},{140, 87, 135},{84, 107, 35},{137, 133, 108},{71, 139, 65},{0, 0, 0}};
static const uint16_t circShift_BG2_Z160_CNG6[6][3] = {{0, 0, 0},{131, 124, 45},{142, 99, 148},{141, 45, 96},{64, 148, 78},{0, 0, 0}};
static const uint16_t circShift_BG2_Z176_CNG6[6][3] = {{79, 47, 48},{84, 154, 125},{35, 10, 24},{103, 155, 47},{60, 29, 55},{0, 0, 0}};
static const uint16_t circShift_BG2_Z192_CNG6[6][3] = {{10, 129, 80},{44, 92, 186},{121, 100, 16},{80, 49, 102},{48, 184, 143},{0, 0, 0}};
static const uint16_t circShift_BG2_Z208_CNG6[6][3] = {{136, 7, 163},{49, 34, 78},{36, 198, 143},{132, 168, 107},{62, 12, 58},{0, 0, 0}};
static const uint16_t circShift_BG2_Z224_CNG6[6][3] = {{185, 123, 103},{138, 55, 13},{170, 31, 105},{219, 222, 150},{193, 209, 181},{0, 0, 0}};
static const uint16_t circShift_BG2_Z240_CNG6[6][3] = {{121, 137, 86},{41, 72, 186},{169, 172, 87},{88, 124, 172},{207, 56, 154},{0, 0, 0}};
static const uint16_t circShift_BG2_Z256_CNG6[6][3] = {{231, 155, 129},{41, 228, 147},{194, 45, 140},{159, 28, 3},{103, 158, 116},{0, 0, 0}};
static const uint16_t circShift_BG2_Z288_CNG6[6][3] = {{40, 109, 97},{140, 87, 135},{84, 107, 35},{137, 133, 108},{71, 139, 65},{0, 0, 0}};
static const uint16_t circShift_BG2_Z320_CNG6[6][3] = {{0, 0, 0},{131, 124, 45},{142, 99, 148},{141, 45, 96},{64, 148, 78},{0, 0, 0}};
static const uint16_t circShift_BG2_Z352_CNG6[6][3] = {{79, 47, 48},{84, 154, 125},{35, 10, 24},{103, 155, 47},{60, 29, 55},{0, 0, 0}};
static const uint16_t circShift_BG2_Z384_CNG6[6][3] = {{10, 129, 80},{44, 92, 186},{121, 100, 16},{80, 49, 102},{48, 184, 143},{0, 0, 0}};
// CNG8
static const uint16_t circShift_BG2_Z2_CNG8[8][2] = {{1, 1},{1, 0},{0, 0},{0, 0},{1, 0},{1, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z3_CNG8[8][2] = {{0, 1},{1, 0},{1, 0},{0, 2},{2, 0},{1, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z4_CNG8[8][2] = {{1, 1},{1, 2},{0, 0},{2, 0},{1, 0},{1, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z5_CNG8[8][2] = {{0, 0},{0, 4},{0, 4},{0, 4},{0, 3},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z6_CNG8[8][2] = {{0, 1},{1, 0},{4, 3},{0, 2},{5, 0},{4, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z7_CNG8[8][2] = {{2, 5},{5, 5},{2, 4},{6, 2},{4, 0},{1, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z8_CNG8[8][2] = {{1, 1},{5, 2},{4, 4},{2, 4},{5, 0},{5, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z9_CNG8[8][2] = {{3, 5},{8, 7},{8, 2},{8, 2},{7, 3},{1, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z10_CNG8[8][2] = {{0, 0},{0, 4},{0, 9},{0, 9},{0, 8},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z11_CNG8[8][2] = {{2, 10},{0, 3},{3, 8},{3, 5},{7, 10},{2, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z12_CNG8[8][2] = {{6, 1},{1, 6},{10, 9},{6, 2},{11, 6},{4, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z13_CNG8[8][2] = {{0, 9},{6, 7},{7, 8},{9, 1},{1, 2},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z14_CNG8[8][2] = {{2, 12},{12, 5},{9, 4},{13, 9},{11, 7},{8, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z15_CNG8[8][2] = {{10, 14},{11, 1},{11, 3},{6, 8},{8, 5},{7, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z16_CNG8[8][2] = {{9, 1},{5, 2},{12, 12},{10, 4},{13, 0},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z18_CNG8[8][2] = {{3, 5},{8, 16},{17, 2},{17, 2},{7, 3},{1, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z20_CNG8[8][2] = {{0, 0},{0, 14},{0, 19},{0, 9},{0, 8},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z22_CNG8[8][2] = {{2, 10},{11, 14},{14, 19},{3, 16},{18, 10},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z24_CNG8[8][2] = {{6, 1},{1, 18},{22, 21},{18, 14},{23, 18},{4, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z26_CNG8[8][2] = {{13, 22},{19, 7},{20, 21},{9, 1},{14, 2},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z28_CNG8[8][2] = {{16, 12},{26, 19},{23, 18},{13, 23},{11, 7},{8, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z30_CNG8[8][2] = {{25, 14},{11, 1},{11, 3},{21, 23},{23, 5},{22, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z32_CNG8[8][2] = {{9, 17},{21, 18},{12, 12},{26, 20},{29, 16},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z36_CNG8[8][2] = {{3, 23},{26, 34},{17, 20},{35, 2},{7, 3},{19, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z40_CNG8[8][2] = {{0, 20},{0, 14},{0, 19},{0, 9},{0, 28},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z44_CNG8[8][2] = {{24, 10},{11, 36},{14, 19},{3, 38},{40, 10},{35, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z48_CNG8[8][2] = {{30, 25},{1, 18},{22, 21},{18, 14},{23, 18},{28, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z52_CNG8[8][2] = {{39, 22},{19, 7},{20, 47},{9, 27},{40, 28},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z56_CNG8[8][2] = {{16, 40},{54, 19},{23, 46},{13, 23},{39, 35},{8, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z60_CNG8[8][2] = {{25, 14},{11, 31},{11, 3},{21, 53},{23, 35},{52, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z64_CNG8[8][2] = {{9, 17},{53, 50},{12, 44},{26, 52},{61, 48},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z72_CNG8[8][2] = {{3, 23},{26, 34},{53, 20},{35, 38},{43, 39},{55, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z80_CNG8[8][2] = {{0, 20},{0, 14},{0, 19},{0, 9},{0, 28},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z88_CNG8[8][2] = {{68, 10},{55, 80},{14, 19},{3, 82},{40, 54},{35, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z96_CNG8[8][2] = {{78, 25},{1, 18},{70, 21},{66, 14},{71, 18},{76, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z104_CNG8[8][2] = {{39, 22},{19, 59},{72, 47},{61, 79},{92, 28},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z112_CNG8[8][2] = {{72, 40},{110, 19},{23, 46},{69, 79},{95, 91},{8, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z120_CNG8[8][2] = {{25, 74},{11, 31},{71, 3},{21, 53},{23, 35},{112, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z128_CNG8[8][2] = {{9, 81},{117, 114},{76, 44},{26, 52},{61, 112},{77, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z144_CNG8[8][2] = {{3, 95},{26, 106},{53, 92},{35, 110},{115, 111},{127, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z160_CNG8[8][2] = {{0, 20},{0, 94},{0, 99},{0, 9},{0, 108},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z176_CNG8[8][2] = {{156, 98},{143, 168},{14, 107},{3, 82},{40, 142},{123, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z192_CNG8[8][2] = {{174, 25},{97, 114},{166, 117},{66, 110},{71, 114},{172, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z208_CNG8[8][2] = {{143, 126},{19, 163},{176, 47},{165, 183},{196, 132},{13, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z224_CNG8[8][2] = {{72, 152},{110, 131},{23, 46},{181, 191},{95, 91},{8, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z240_CNG8[8][2] = {{145, 74},{131, 31},{71, 3},{21, 53},{23, 155},{112, 0},{1, 0},{0, 0}};
static const uint16_t circShift_BG2_Z256_CNG8[8][2] = {{9, 81},{117, 114},{204, 44},{26, 52},{189, 240},{205, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z288_CNG8[8][2] = {{3, 95},{26, 106},{53, 92},{35, 110},{115, 111},{127, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z320_CNG8[8][2] = {{0, 20},{0, 94},{0, 99},{0, 9},{0, 108},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z352_CNG8[8][2] = {{156, 98},{143, 168},{14, 107},{3, 82},{40, 142},{123, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z384_CNG8[8][2] = {{174, 25},{97, 114},{166, 117},{66, 110},{71, 114},{172, 1},{0, 0},{0, 0}};
// CNG10
static const uint16_t circShift_BG2_Z2_CNG10[10][2] = {{1, 0},{0, 0},{1, 0},{1, 0},{0, 1},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z3_CNG10[10][2] = {{0, 1},{0, 1},{0, 2},{2, 0},{1, 0},{1, 1},{2, 1},{0, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z4_CNG10[10][2] = {{3, 0},{2, 2},{1, 2},{1, 0},{2, 1},{0, 2},{0, 2},{0, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z5_CNG10[10][2] = {{2, 3},{4, 0},{0, 2},{0, 1},{3, 2},{0, 2},{0, 3},{0, 1},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z6_CNG10[10][2] = {{3, 4},{0, 1},{0, 5},{2, 0},{1, 3},{1, 4},{5, 4},{3, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z7_CNG10[10][2] = {{4, 3},{2, 6},{3, 1},{2, 5},{3, 5},{4, 5},{1, 2},{3, 0},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z8_CNG10[10][2] = {{7, 0},{6, 2},{5, 6},{5, 0},{2, 1},{4, 6},{0, 2},{4, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z9_CNG10[10][2] = {{1, 3},{4, 4},{5, 4},{3, 4},{3, 1},{8, 4},{6, 2},{5, 7},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z10_CNG10[10][2] = {{7, 8},{4, 5},{0, 2},{0, 6},{8, 2},{0, 7},{0, 3},{5, 6},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z11_CNG10[10][2] = {{6, 9},{10, 9},{8, 9},{1, 6},{0, 6},{4, 1},{6, 6},{1, 6},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z12_CNG10[10][2] = {{3, 4},{0, 7},{0, 5},{8, 0},{7, 3},{7, 10},{5, 4},{3, 6},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z13_CNG10[10][2] = {{5, 10},{1, 9},{3, 5},{11, 7},{3, 8},{4, 3},{1, 9},{11, 4},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z14_CNG10[10][2] = {{11, 3},{2, 6},{3, 8},{2, 12},{3, 12},{4, 12},{1, 2},{3, 7},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z15_CNG10[10][2] = {{7, 14},{9, 6},{3, 5},{12, 5},{6, 9},{8, 4},{9, 13},{2, 0},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z16_CNG10[10][2] = {{7, 8},{6, 10},{13, 14},{13, 8},{2, 1},{12, 6},{0, 2},{12, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z18_CNG10[10][2] = {{1, 12},{4, 13},{14, 4},{12, 4},{12, 1},{8, 13},{15, 2},{14, 7},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z20_CNG10[10][2] = {{17, 18},{4, 15},{0, 2},{0, 6},{8, 12},{0, 17},{0, 13},{15, 6},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z22_CNG10[10][2] = {{17, 9},{21, 20},{19, 20},{1, 17},{11, 17},{15, 1},{17, 17},{1, 17},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z24_CNG10[10][2] = {{3, 16},{12, 7},{0, 17},{20, 0},{7, 3},{19, 22},{17, 4},{3, 18},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z26_CNG10[10][2] = {{18, 10},{1, 22},{3, 18},{24, 7},{3, 21},{17, 3},{14, 9},{24, 4},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z28_CNG10[10][2] = {{25, 17},{16, 6},{3, 8},{16, 12},{3, 12},{4, 26},{1, 16},{3, 21},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z30_CNG10[10][2] = {{22, 29},{24, 21},{3, 5},{27, 20},{6, 9},{23, 19},{9, 13},{17, 15},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z32_CNG10[10][2] = {{7, 8},{6, 26},{29, 30},{29, 8},{2, 17},{28, 22},{0, 18},{28, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z36_CNG10[10][2] = {{19, 12},{22, 13},{32, 22},{30, 4},{12, 1},{26, 13},{33, 20},{14, 7},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z40_CNG10[10][2] = {{17, 38},{4, 15},{0, 22},{0, 26},{8, 12},{0, 17},{0, 13},{15, 6},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z44_CNG10[10][2] = {{17, 9},{21, 42},{19, 42},{1, 39},{11, 17},{37, 1},{39, 17},{1, 17},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z48_CNG10[10][2] = {{27, 40},{36, 31},{0, 17},{44, 24},{31, 27},{43, 22},{41, 28},{3, 42},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z52_CNG10[10][2] = {{18, 36},{27, 48},{3, 18},{50, 7},{29, 47},{17, 3},{14, 35},{24, 4},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z56_CNG10[10][2] = {{53, 17},{44, 6},{3, 36},{44, 12},{3, 12},{32, 54},{29, 44},{31, 21},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z60_CNG10[10][2] = {{22, 59},{54, 51},{3, 35},{27, 50},{36, 39},{23, 19},{9, 43},{47, 15},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z64_CNG10[10][2] = {{39, 8},{38, 58},{61, 30},{61, 40},{34, 17},{28, 54},{32, 18},{60, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z72_CNG10[10][2] = {{19, 48},{22, 49},{32, 22},{66, 4},{12, 1},{26, 49},{69, 56},{50, 7},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z80_CNG10[10][2] = {{57, 38},{44, 15},{0, 22},{0, 66},{8, 12},{0, 57},{0, 53},{55, 46},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z88_CNG10[10][2] = {{17, 53},{65, 86},{63, 86},{1, 39},{55, 17},{37, 1},{83, 17},{45, 17},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z96_CNG10[10][2] = {{27, 40},{36, 79},{48, 17},{92, 72},{31, 27},{91, 22},{89, 28},{3, 90},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z104_CNG10[10][2] = {{18, 36},{27, 48},{3, 18},{102, 7},{81, 99},{17, 3},{14, 87},{76, 56},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z112_CNG10[10][2] = {{53, 73},{44, 6},{3, 36},{44, 12},{3, 12},{88, 110},{29, 44},{31, 21},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z120_CNG10[10][2] = {{22, 119},{54, 51},{63, 95},{27, 110},{96, 39},{23, 79},{9, 43},{47, 75},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z128_CNG10[10][2] = {{39, 8},{38, 58},{125, 30},{125, 104},{98, 81},{28, 54},{96, 18},{124, 0},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z144_CNG10[10][2] = {{19, 120},{94, 121},{104, 22},{66, 4},{84, 73},{98, 49},{69, 128},{50, 79},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z160_CNG10[10][2] = {{137, 38},{124, 15},{0, 102},{0, 146},{88, 12},{0, 57},{0, 53},{55, 46},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z176_CNG10[10][2] = {{17, 53},{65, 174},{63, 174},{1, 127},{55, 17},{37, 89},{171, 17},{133, 105},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z192_CNG10[10][2] = {{27, 136},{36, 175},{48, 113},{92, 72},{31, 123},{187, 118},{185, 28},{3, 186},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z208_CNG10[10][2] = {{18, 36},{27, 48},{3, 18},{102, 111},{185, 203},{17, 3},{14, 191},{180, 160},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z224_CNG10[10][2] = {{53, 185},{156, 6},{115, 36},{156, 124},{115, 124},{200, 110},{29, 156},{31, 133},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z240_CNG10[10][2] = {{142, 239},{174, 171},{183, 95},{27, 110},{96, 159},{23, 199},{9, 43},{167, 75},{0, 1},{0, 0}};
static const uint16_t circShift_BG2_Z256_CNG10[10][2] = {{167, 8},{166, 58},{253, 158},{125, 104},{226, 209},{156, 54},{224, 18},{252, 128},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z288_CNG10[10][2] = {{19, 120},{94, 121},{104, 22},{66, 4},{84, 73},{98, 49},{69, 128},{50, 79},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z320_CNG10[10][2] = {{137, 38},{124, 15},{0, 102},{0, 146},{88, 12},{0, 57},{0, 53},{55, 46},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z352_CNG10[10][2] = {{17, 53},{65, 174},{63, 174},{1, 127},{55, 17},{37, 89},{171, 17},{133, 105},{0, 0},{0, 0}};
static const uint16_t circShift_BG2_Z384_CNG10[10][2] = {{27, 136},{36, 175},{48, 113},{92, 72},{31, 123},{187, 118},{185, 28},{3, 186},{0, 0},{0, 0}};

// Startaddressses in the BN buffer of the different CN groups
// BG1
// Group of CNs with 3 BNs (CNG3) / only this group is independent of Z
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG3[3][1] = {{111360},{100224},{0}};
// R23
static const uint32_t startAddrBnProcBuf_BG1_R23_CNG3[3][1] = {{52224},{47616},{0}};
// R89
static const uint32_t startAddrBnProcBuf_BG1_R89_CNG3[3][1] = {{29952},{28032},{0}};

// Group of CNs with 4 BNs (CNG4)
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG4[4][5] = {{105984, 107904, 120192, 120576, 109440},{40704, 74496, 43008, 47232, 43008},{41856, 19200, 61440, 23424, 92544},{0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG4[4][5] = {{0, 0, 0, 0, 0},{0, 1, 1, 0, 0},{1, 0, 3, 0, 1},{23, 33, 36, 38, 41}};

// Group of CNs with 5 BNs (CNG5)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG5[5][18] = {{116736, 105216, 105600, 117504, 117888, 106368, 118272, 106752, 118656, 107136, 119040, 107520, 119424, 119808, 108288, 108672, 109056, 120960},{87936, 30336, 39552, 31872, 46848, 58368, 89472, 87936, 89472, 33408, 89472, 41856, 61440, 30336, 73344, 74496, 61440, 92544},{72192, 87936, 86400, 46464, 31872, 97536, 73344, 89472, 59904, 61440, 31872, 91008, 33408, 91008, 91008, 31872, 98688, 33408},{58368, 97152, 56832, 30336, 73344, 21888, 21888, 22656, 22656, 74496, 59904, 91008, 97920, 92544, 33408, 98304, 23424, 92544},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG5[5][18] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{2, 0, 0, 0, 0, 1, 1, 0, 2, 0, 0, 0, 1, 1, 0, 0, 2, 0},{1, 1, 0, 0, 3, 0, 1, 3, 1, 0, 2, 2, 2, 1, 0, 1, 0, 1},{3, 0, 1, 2, 2, 1, 0, 1, 0, 2, 3, 3, 0, 2, 3, 0, 1, 3},{18, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 37, 39, 40}};

// Group of CNs with 6 BNs (CNG6)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG6[6][8] = {{114432, 103680, 115584, 104064, 115968, 116352, 104832, 117120},{68736, 69888, 55296, 86400, 104448, 71040, 17280, 72192},{83328, 56832, 58368, 71040, 84864, 28800, 59904, 46080},{40704, 41856, 56832, 96768, 40704, 58368, 43008, 59904},{18816, 84864, 71040, 30336, 86400, 86400, 72192, 87936},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG6[6][8] = {{0, 0, 0, 0, 0, 0, 0, 0},{0, 0, 1, 2, 0, 0, 0, 0},{0, 0, 2, 1, 0, 1, 2, 0},{2, 2, 3, 0, 1, 0, 2, 0},{0, 3, 2, 3, 1, 3, 2, 3},{9, 12, 13, 14, 15, 16, 17, 20}};

// Group of CNs with 7 BNs (CNG7)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG7[7][5] = {{112512, 102144, 114048, 114816, 115200},{100992, 28800, 102912, 84864, 103296},{45312, 45696, 83328, 28800, 84864},{80256, 81792, 55296, 56832, 69888},{38400, 39552, 68736, 55296, 96384},{52224, 53760, 96000, 69888, 21120},{0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG7[7][5] = {{0, 0, 0, 0, 0},{0, 0, 0, 2, 0},{0, 0, 1, 2, 1},{0, 0, 0, 2, 1},{1, 1, 1, 3, 0},{1, 1, 0, 2, 1},{3, 6, 8, 10, 11}};
// R23
static const uint32_t startAddrBnProcBuf_BG1_R23_CNG7[7][3] = {{53376, 49536, 54912},{48384, 13440, 50304},{22656, 25344, 43392},{22656, 25344, 43392},{22656, 25344, 43392},{22656, 25344, 43392},{0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R23_CNG7[7][3] = {{0, 0, 0},{0, 0, 0},{1, 1, 0},{2, 2, 1},{3, 3, 3},{4, 4, 5},{3, 6, 8}};

// Group of CNs with 8 BNs (CNG8)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG8[8][2] = {{111744, 113664},{100608, 102528},{66432, 83328},{80256, 55296},{52224, 68736},{66432, 83328},{80256, 18432},{0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG8[8][2] = {{0, 0},{0, 0},{0, 2},{2, 2},{2, 2},{2, 3},{3, 0},{1, 7}};
// R23
static const uint32_t startAddrBnProcBuf_BG1_R23_CNG8[8][2] = {{52608, 54528},{48000, 49920},{22656, 43392},{37248, 43392},{37248, 43392},{37248, 43392},{37248, 8064},{0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R23_CNG8[8][2] = {{0, 0},{0, 0},{0, 2},{2, 4},{4, 6},{6, 7},{7, 3},{1, 7}};

// Group of CNs with 9 BNs (CNG9)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG9[9][2] = {{112128, 113280},{38400, 101760},{80256, 81792},{52224, 53760},{66432, 67584},{52224, 53760},{95232, 95616},{38400, 39552},{0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG9[9][2] = {{0, 0},{0, 0},{1, 1},{0, 0},{1, 1},{3, 3},{0, 0},{2, 2},{2, 5}};
// R23
static const uint32_t startAddrBnProcBuf_BG1_R23_CNG9[9][2] = {{52992, 54144},{13440, 49152},{37248, 40320},{37248, 40320},{37248, 40320},{22656, 25344},{37248, 40320},{22656, 25344},{0, 0}};
static const uint8_t bnPosBnProcBuf_BG1_R23_CNG9[9][2] = {{0, 0},{1, 0},{0, 0},{1, 1},{3, 3},{5, 5},{5, 5},{6, 6},{2, 5}};

// Group of CNs with 10 BNs (CNG10)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG10[10][1] = {{112896},{101376},{67584},{81792},{53760},{28800},{67584},{81792},{21120},{0}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG10[10][1] = {{0},{0},{0},{2},{2},{3},{2},{3},{0},{4}};
// R23
static const uint32_t startAddrBnProcBuf_BG1_R23_CNG10[10][1] = {{53760},{48768},{25344},{40320},{40320},{13440},{40320},{40320},{8064},{0}};
static const uint8_t bnPosBnProcBuf_BG1_R23_CNG10[10][1] = {{0},{0},{0},{2},{4},{2},{6},{7},{4},{4}};

// Group of CNs with 19 BNs (CNG19)
// R13
static const uint32_t startAddrBnProcBuf_BG1_R13_CNG19[19][4] = {{109824, 110208, 110592, 110976},{99072, 25728, 99456, 99840},{24192, 64128, 27264, 65280},{62976, 44160, 44544, 44928},{16128, 16512, 16896, 37248},{34944, 75648, 36096, 78720},{24192, 34944, 77184, 37248},{75648, 25728, 36096, 78720},{47616, 49152, 27264, 50688},{75648, 77184, 77184, 78720},{62976, 47616, 64128, 65280},{24192, 25728, 49152, 50688},{47616, 49152, 27264, 50688},{94080, 47616, 49152, 50688},{24192, 25728, 94464, 94848},{34944, 64128, 27264, 37248},{62976, 77184, 36096, 65280},{75648, 18048, 20352, 78720},{17664, 19584, 19584, 20352}};
static const uint8_t bnPosBnProcBuf_BG1_R13_CNG19[19][4] = {{0, 0, 0, 0},{0, 0, 0, 0},{0, 0, 0, 0},{0, 0, 0, 0},{0, 0, 0, 0},{0, 0, 0, 0},{1, 1, 0, 1},{1, 1, 1, 1},{0, 0, 1, 0},{2, 2, 1, 2},{1, 1, 1, 1},{2, 2, 1, 1},{2, 2, 2, 2},{0, 3, 3, 3},{3, 3, 0, 0},{2, 2, 3, 2},{2, 3, 2, 2},{3, 0, 0, 3},{0, 0, 1, 1}};
// R23
static const uint32_t startAddrBnProcBuf_BG1_R23_CNG19[19][4] = {{50688, 51072, 51456, 51840},{46464, 11136, 46848, 47232},{9984, 17280, 12288, 19968},{14592, 14592, 17280, 19968},{4224, 6144, 8064, 12288},{9984, 14592, 11136, 19968},{4224, 14592, 17280, 19968},{28032, 6144, 17280, 34176},{28032, 31104, 8064, 34176},{28032, 31104, 31104, 34176},{28032, 14592, 31104, 34176},{4224, 6144, 17280, 19968},{28032, 31104, 8064, 34176},{28032, 14592, 17280, 19968},{9984, 11136, 31104, 34176},{14592, 31104, 12288, 19968},{28032, 31104, 17280, 34176},{28032, 6144, 6144, 34176},{4224, 4224, 3456, 3840}};
static const uint8_t bnPosBnProcBuf_BG1_R23_CNG19[19][4] = {{0, 0, 0, 0},{0, 0, 0, 0},{0, 0, 0, 0},{0, 1, 1, 1},{0, 0, 0, 1},{1, 2, 1, 2},{1, 3, 2, 3},{0, 1, 3, 0},{1, 1, 1, 1},{2, 2, 0, 2},{3, 4, 3, 3},{2, 2, 4, 4},{4, 4, 2, 4},{5, 5, 5, 5},{2, 2, 5, 5},{6, 6, 2, 6},{6, 7, 6, 6},{7, 3, 4, 7},{3, 4, 0, 0}};
// R89
static const uint32_t startAddrBnProcBuf_BG1_R89_CNG19[19][4] = {{28416, 28800, 29184, 29568},{26880, 10752, 27264, 27648},{2688, 10752, 18816, 18816},{2688, 2688, 10752, 18816},{2688, 10752, 18816, 18816},{2688, 2688, 10752, 18816},{2688, 2688, 10752, 18816},{2688, 10752, 10752, 18816},{2688, 10752, 18816, 18816},{2688, 10752, 10752, 18816},{2688, 2688, 10752, 18816},{2688, 10752, 10752, 18816},{2688, 10752, 18816, 18816},{2688, 2688, 10752, 18816},{2688, 10752, 10752, 18816},{2688, 10752, 18816, 18816},{2688, 10752, 10752, 18816},{2688, 1536, 1536, 18816},{384, 384, 384, 1536}};
static const uint8_t bnPosBnProcBuf_BG1_R89_CNG19[19][4] = {{0, 0, 0, 0},{0, 0, 0, 0},{0, 1, 0, 1},{1, 2, 2, 2},{3, 3, 3, 4},{4, 5, 4, 5},{7, 6, 5, 6},{8, 7, 6, 8},{9, 9, 7, 9},{10, 10, 8, 10},{11, 12, 11, 11},{13, 13, 12, 12},{14, 14, 13, 14},{16, 15, 15, 15},{17, 17, 16, 16},{18, 19, 17, 18},{19, 20, 18, 19},{20, 0, 1, 20},{0, 1, 2, 2}};

// BG2
// CNG3
static const uint32_t startAddrBnProcBuf_BG2_R15_CNG3[3][6] = {{72960, 64128, 64512, 64896, 74112, 31872},{34176, 49536, 23040, 17664, 40320, 41088},{0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R15_CNG3[3][6] = {{0, 0, 0, 0, 0, 0},{0, 0, 0, 1, 0, 0},{18, 21, 23, 25, 27, 33}};
// CNG4
// R15
static const uint32_t startAddrBnProcBuf_BG2_R15_CNG4[4][20] = {{59520, 60672, 70272, 62208, 62592, 62976, 72576, 63360, 63744, 73344, 73728, 65280, 36096, 65664, 74496, 66048, 74880, 66432, 36864, 75264},{67968, 69120, 16896, 29568, 22656, 72192, 16896, 20352, 17664, 34560, 35328, 50688, 45696, 31872, 51072, 36480, 51456, 46464, 32640, 51840},{52992, 28032, 54912, 55680, 44544, 30336, 56832, 39552, 49152, 25728, 49920, 31104, 31104, 40704, 57216, 46080, 57600, 32640, 41472, 57984},{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R15_CNG4[4][20] = {{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0},{0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0},{0, 4, 8, 11, 14, 15, 16, 17, 19, 20, 24, 28, 29, 30, 31, 32, 34, 35, 36, 37}};
// R13
static const uint32_t startAddrBnProcBuf_BG2_R13_CNG4[4][8] = {{36096, 37248, 43776, 38784, 39168, 39552, 46080, 39936},{41472, 42624, 9984, 20352, 22272, 45696, 9984, 22272},{30720, 11520, 32640, 33408, 29568, 22272, 34560, 26496},{0, 0, 0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R13_CNG4[4][8] = {{0, 0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 4, 1, 0, 1, 2},{0, 0, 0, 0, 0, 4, 0, 0},{0, 4, 8, 11, 14, 15, 16, 17}};
// R23
static const uint32_t startAddrBnProcBuf_BG2_R23_CNG4[4][1] = {{18816},{16128},{15360},{0}};
static const uint8_t bnPosBnProcBuf_BG2_R23_CNG4[4][1] = {{0},{0},{1},{0}};
// CNG5
// R15
static const uint32_t startAddrBnProcBuf_BG2_R15_CNG5[5][9] = {{69504, 61056, 61440, 61824, 71040, 71424, 71808, 34944, 35712},{19584, 69888, 44160, 70656, 22272, 25344, 48768, 44928, 50304},{28800, 21888, 24960, 19968, 55296, 56064, 56448, 30336, 45312},{54528, 43776, 38400, 38784, 39168, 28800, 29568, 39936, 26112},{0, 0, 0, 0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R15_CNG5[5][9] = {{0, 0, 0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0, 1, 0},{0, 0, 0, 0, 0, 1, 1, 0, 0},{5, 6, 7, 9, 10, 12, 13, 22, 26}};
// R13
static const uint32_t startAddrBnProcBuf_BG2_R13_CNG5[5][7] = {{43008, 37632, 38016, 38400, 44544, 44928, 45312},{18432, 43392, 29184, 44160, 20352, 22272, 22272},{18432, 18432, 20352, 20352, 33024, 33792, 34176},{32256, 28800, 25344, 25728, 26112, 11904, 12288},{0, 0, 0, 0, 0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R13_CNG5[5][7] = {{0, 0, 0, 0, 0, 0, 0},{2, 0, 0, 0, 1, 3, 0},{4, 1, 3, 2, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0},{5, 6, 7, 9, 10, 12, 13}};
// R23
// none
// CNG6
// R15
static const uint32_t startAddrBnProcBuf_BG2_R15_CNG6[6][3] = {{59904, 60288, 68736},{68352, 48000, 48384},{47616, 43008, 43392},{42624, 24576, 54144},{53376, 53760, 38016},{0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R15_CNG6[6][3] = {{0, 0, 0},{0, 0, 0},{0, 0, 0},{0, 0, 0},{0, 0, 0},{1, 2, 3}};
// R13
static const uint32_t startAddrBnProcBuf_BG2_R13_CNG6[6][3] = {{36480, 36864, 42240},{41856, 18432, 20352},{16512, 28032, 28416},{27648, 18432, 31872},{31104, 31488, 24960},{0, 0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R13_CNG6[6][3] = {{0, 0, 0},{0, 0, 0},{0, 0, 0},{0, 3, 0},{0, 0, 0},{1, 2, 3}};
// R23
static const uint32_t startAddrBnProcBuf_BG2_R23_CNG6[6][2] = {{19200, 19584},{16896, 12672},{11520, 12672},{11520, 12672},{16128, 16896},{0, 0}};
static const uint8_t bnPosBnProcBuf_BG2_R23_CNG6[6][2] = {{0, 0},{0, 0},{0, 1},{1, 2},{1, 1},{1, 2}};
// CNG8
// R15
static const uint32_t startAddrBnProcBuf_BG2_R15_CNG8[8][2] = {{58368, 59136},{66816, 67200},{33408, 16128},{14592, 15360},{20736, 18816},{23424, 27264},{26496, 27264},{52224, 37248}};
static const uint8_t bnPosBnProcBuf_BG2_R15_CNG8[8][2] = {{0, 0},{0, 0},{0, 0},{0, 1},{0, 0},{0, 0},{0, 1},{0, 0}};
// R13
static const uint32_t startAddrBnProcBuf_BG2_R13_CNG8[8][2] = {{34944, 35712},{40320, 40704},{6912, 9216},{7680, 8448},{12672, 14592},{12672, 14592},{12672, 11136},{29952, 24192}};
static const uint8_t bnPosBnProcBuf_BG2_R13_CNG8[8][2] = {{0, 0},{0, 0},{0, 0},{0, 1},{1, 2},{3, 4},{4, 0},{0, 0}};
// R23
static const uint32_t startAddrBnProcBuf_BG2_R23_CNG8[8][2] = {{17664, 18432},{13824, 14592},{1152, 7296},{3456, 5376},{3456, 5376},{9216, 5376},{3456, 2304},{13824, 1152}};
static const uint8_t bnPosBnProcBuf_BG2_R23_CNG8[8][2] = {{0, 0},{0, 0},{0, 0},{0, 1},{2, 3},{2, 4},{4, 1},{1, 2}};
// CNG10
// R15
static const uint32_t startAddrBnProcBuf_BG2_R15_CNG10[10][2] = {{58752, 67584},{15360, 33792},{14592, 16128},{46848, 47232},{21120, 21504},{41856, 42240},{18432, 19200},{23808, 24192},{52608, 28032},{26496, 37632}};
static const uint8_t bnPosBnProcBuf_BG2_R15_CNG10[10][2] = {{0, 0},{0, 0},{1, 1},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{0, 0},{1, 0}};
// R13
static const uint32_t startAddrBnProcBuf_BG2_R13_CNG10[10][2] = {{35328, 41088},{8448, 7296},{7680, 9216},{12672, 14592},{14592, 16512},{26880, 27264},{12672, 16512},{14592, 16512},{30336, 16512},{10752, 24576}};
static const uint8_t bnPosBnProcBuf_BG2_R13_CNG10[10][2] = {{0, 0},{0, 0},{1, 1},{0, 0},{1, 1},{0, 0},{2, 2},{3, 3},{0, 4},{0, 0}};
// R23
static const uint32_t startAddrBnProcBuf_BG2_R23_CNG10[10][2] = {{18048, 15360},{5376, 2304},{3456, 7296},{9216, 10368},{5376, 7296},{9216, 10368},{3456, 7296},{10368, 11520},{14592, 7296},{1152, 2304}};
static const uint8_t bnPosBnProcBuf_BG2_R23_CNG10[10][2] = {{0, 0},{0, 0},{1, 1},{0, 0},{2, 2},{1, 1},{3, 3},{2, 2},{1, 4},{1, 2}};

// LUT for llr2llrProcBuf
// BG1
// R13
static const uint16_t llr2llrProcBufAddr_BG1_R13[26] = {25728,25344,17664,22272,20352,16128,19200,23424,19200,17664,23424,20736,23424,22272,20736,17664,20736,20736,24960,17664,19200,22272,23424,16512,16896,16896};
static const uint8_t llr2llrProcBufBnPos_BG1_R13[26] = {0,0,0,0,0,0,0,0,1,1,1,0,2,1,1,2,2,3,0,3,2,2,3,0,0,1};
// R23
static const uint16_t llr2llrProcBufAddr_BG1_R23[26] = {13056,12672,5760,6912,6912,3840,5760,6912,6912,3840,9600,9600,9600,9600,6912,3840,9600,6912,9600,5760,6912,9600,9600,3840,3840,3456};
static const uint8_t llr2llrProcBufBnPos_BG1_R23[26] = {0,0,0,0,1,0,1,2,3,1,0,1,2,3,4,2,4,5,5,2,6,6,7,3,4,0};
// R89
static const uint16_t llr2llrProcBufAddr_BG1_R89[26] = {9984,9600,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,1536,384,384,384};
static const uint8_t llr2llrProcBufBnPos_BG1_R89[26] = {0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,0,1,2};

// BG2
// R15
static const uint16_t llr2llrProcBufAddr_BG2_R15[14] = {19200,19584,17280,14592,14592,18432,15744,18048,15360,16128,16512,18816,16512,17664};
static const uint8_t llr2llrProcBufBnPos_BG2_R15[14] = {0,0,0,0,1,0,0,0,0,0,0,0,1,0};
// R13
static const uint16_t llr2llrProcBufAddr_BG2_R13[14] = {11520,11904,6912,7296,7296,8448,8448,10752,8448,8448,8448,11136,8064,10368};
static const uint8_t llr2llrProcBufBnPos_BG2_R13[14] = {0,0,0,0,1,0,1,0,2,3,4,0,0,0};
// R23
static const uint16_t llr2llrProcBufAddr_BG2_R23[14] = {6144,5376,1152,2304,2304,4224,2304,4224,2304,4224,2304,5376,1152,1152};
static const uint8_t llr2llrProcBufBnPos_BG2_R23[14] = {0,0,0,0,1,0,2,1,3,2,4,1,1,2};

// LUT for llr2cnProcBuf
// LUTs are not rate dependent, however the number of CN in a CNG varies with rate
// CNG3
// BG1
static const uint8_t posBnInCnProcBuf_BG1_CNG3[3][1] = {{0},{1},{26}};
// CNG4
static const uint8_t posBnInCnProcBuf_BG1_CNG4[4][5] = {{1, 1, 0, 0, 1},{6, 13, 8, 4, 6},{8, 23, 17, 24, 10},{49, 59, 62, 64, 67}};
// CNG5
static const uint8_t posBnInCnProcBuf_BG1_CNG5[5][18] = {{0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0},{12, 2, 6, 2, 4, 14, 10, 7, 12, 2, 7, 6, 14, 9, 3, 3, 16, 7},{13, 10, 7, 4, 19, 18, 13, 22, 14, 11, 15, 12, 15, 10, 7, 9, 18, 9},{17, 18, 14, 15, 21, 25, 24, 25, 24, 21, 17, 22, 18, 12, 19, 18, 25, 22},{44, 45, 47, 48, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 63, 65, 66}};
// CNG6
static const uint8_t posBnInCnProcBuf_BG1_CNG6[6][8] = {{0, 1, 0, 1, 0, 0, 1, 0},{3, 3, 14, 12, 1, 3, 5, 3},{7, 11, 16, 13, 7, 9, 16, 4},{20, 20, 17, 18, 8, 11, 20, 11},{23, 22, 21, 19, 10, 22, 21, 22},{35, 38, 39, 40, 41, 42, 43, 46}};
// CNG7
static const uint8_t posBnInCnProcBuf_BG1_CNG7[7][5] = {{0, 1, 0, 0, 0},{1, 2, 1, 12, 1},{4, 4, 10, 15, 10},{7, 7, 11, 16, 13},{8, 8, 13, 17, 18},{14, 14, 18, 21, 25},{29, 32, 34, 36, 37}};
// CNG8
static const uint8_t posBnInCnProcBuf_BG1_CNG8[8][2] = {{0, 0},{1, 1},{3, 12},{12, 16},{16, 21},{21, 22},{22, 23},{27, 33}};
// CNG9
static const uint8_t posBnInCnProcBuf_BG1_CNG9[9][2] = {{0, 0},{6, 1},{10, 10},{11, 11},{13, 13},{17, 17},{18, 18},{20, 20},{28, 31}};
// CNG10
static const uint8_t posBnInCnProcBuf_BG1_CNG10[10][1] = {{0},{1},{3},{12},{16},{19},{21},{22},{24},{30}};
// CNG19
static const uint8_t posBnInCnProcBuf_BG1_CNG19[19][4] = {{0, 0, 0, 0},{1, 2, 1, 1},{2, 3, 2, 3},{3, 4, 4, 4},{5, 5, 5, 6},{6, 7, 6, 7},{9, 8, 7, 8},{10, 9, 8, 10},{11, 11, 9, 11},{12, 12, 10, 12},{13, 14, 13, 13},{15, 15, 14, 14},{16, 16, 15, 16},{18, 17, 17, 17},{19, 19, 18, 18},{20, 21, 19, 20},{21, 22, 20, 21},{22, 23, 24, 22},{23, 24, 25, 25}};

// BG2
static const uint8_t posBnInCnProcBuf_BG2_CNG3[3][6] = {{1, 0, 0, 0, 1, 10},{2, 5, 6, 4, 13, 13},{32, 35, 37, 39, 41, 47}};
static const uint8_t posBnInCnProcBuf_BG2_CNG4[4][20] = {{0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 2, 0, 1, 0, 1, 0, 2, 1},{1, 1, 3, 10, 6, 1, 4, 8, 3, 2, 2, 5, 7, 12, 5, 2, 5, 7, 10, 5},{11, 12, 11, 11, 7, 10, 11, 13, 5, 9, 5, 12, 10, 13, 11, 7, 11, 12, 13, 11},{14, 18, 22, 25, 28, 29, 30, 31, 33, 34, 38, 42, 43, 44, 45, 46, 48, 49, 50, 51}};
static const uint8_t posBnInCnProcBuf_BG2_CNG5[5][9] = {{1, 0, 0, 0, 1, 1, 1, 2, 2},{8, 1, 7, 1, 6, 9, 5, 7, 5},{10, 6, 9, 8, 11, 11, 11, 12, 7},{11, 7, 13, 13, 13, 12, 12, 13, 9},{19, 20, 21, 23, 24, 26, 27, 36, 40}};
static const uint8_t posBnInCnProcBuf_BG2_CNG6[6][3] = {{0, 0, 1},{1, 5, 5},{5, 7, 7},{7, 9, 11},{11, 11, 13},{15, 16, 17}};
static const uint8_t posBnInCnProcBuf_BG2_CNG8[8][2] = {{0, 0},{1, 1},{2, 3},{3, 4},{6, 8},{9, 10},{10, 12},{11, 13}};
static const uint8_t posBnInCnProcBuf_BG2_CNG10[10][2] = {{0, 1},{3, 2},{4, 4},{5, 5},{6, 6},{7, 7},{8, 8},{9, 9},{11, 10},{12, 13}};

#endif
