/**
 * Namf_Communication
 * AMF Communication Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "N1N2IndividualSubscriptionDocumentApi.h"
#include "Helpers.h"
#include "amf_config.hpp"

extern config::amf_config amf_cfg;

namespace oai {
namespace amf {
namespace api {

using namespace org::openapitools::server::helpers;

N1N2IndividualSubscriptionDocumentApi::N1N2IndividualSubscriptionDocumentApi(
    std::shared_ptr<Pistache::Rest::Router> rtr) {
  router = rtr;
}

void N1N2IndividualSubscriptionDocumentApi::init() {
  setupRoutes();
}

void N1N2IndividualSubscriptionDocumentApi::setupRoutes() {
  using namespace Pistache::Rest;

  Routes::Delete(
      *router,
      base + amf_cfg.sbi_api_version +
          "/ue-contexts/:ueContextId/n1-n2-messages/subscriptions/"
          ":subscriptionId",
      Routes::bind(
          &N1N2IndividualSubscriptionDocumentApi::
              n1_n2_message_un_subscribe_handler,
          this));

  // Default handler, called when a route is not found
  router->addCustomHandler(Routes::bind(
      &N1N2IndividualSubscriptionDocumentApi::
          n1_n2_individual_subscription_document_api_default_handler,
      this));
}

void N1N2IndividualSubscriptionDocumentApi::n1_n2_message_un_subscribe_handler(
    const Pistache::Rest::Request& request,
    Pistache::Http::ResponseWriter response) {
  // Getting the path params
  auto ueContextId    = request.param(":ueContextId").as<std::string>();
  auto subscriptionId = request.param(":subscriptionId").as<std::string>();

  try {
    this->n1_n2_message_un_subscribe(ueContextId, subscriptionId, response);
  } catch (nlohmann::detail::exception& e) {
    // send a 400 error
    response.send(Pistache::Http::Code::Bad_Request, e.what());
    return;
  } catch (std::exception& e) {
    // send a 500 error
    response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    return;
  }
}

void N1N2IndividualSubscriptionDocumentApi::
    n1_n2_individual_subscription_document_api_default_handler(
        const Pistache::Rest::Request&,
        Pistache::Http::ResponseWriter response) {
  response.send(
      Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

}  // namespace api
}  // namespace amf
}  // namespace oai
