/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * IndividualPDUSessionHSMFApi.h
 *
 *
 */

#ifndef OAI_SMF_API_IndividualPDUSessionHSMFApi_H_
#define OAI_SMF_API_IndividualPDUSessionHSMFApi_H_

#include "../ApiClient.h"

#include "HsmfUpdateData.h"
#include "HsmfUpdateError.h"
#include "HsmfUpdatedData.h"
#include "ProblemDetails.h"
#include "ReleaseData.h"
#include <cpprest/details/basic_types.h>

#include <boost/optional.hpp>

namespace oai {
namespace smf {
namespace api {

using namespace oai::smf::model;

class IndividualPDUSessionHSMFApi {
 public:
  explicit IndividualPDUSessionHSMFApi(std::shared_ptr<ApiClient> apiClient);

  virtual ~IndividualPDUSessionHSMFApi();

  /// <summary>
  /// Release
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="pduSessionRef">PDU session reference</param>
  /// <param name="releaseData">representation of the data to be sent to H-SMF
  /// when releasing the PDU session (optional)</param>
  pplx::task<void> releasePduSession(
      utility::string_t pduSessionRef,
      boost::optional<std::shared_ptr<ReleaseData>> releaseData);
  /// <summary>
  /// Update (initiated by V-SMF)
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="pduSessionRef">PDU session reference</param>
  /// <param name="hsmfUpdateData">representation of the updates to apply to the
  /// PDU session</param>
  pplx::task<std::shared_ptr<HsmfUpdatedData>> updatePduSession(
      utility::string_t pduSessionRef,
      std::shared_ptr<HsmfUpdateData> hsmfUpdateData);

 protected:
  std::shared_ptr<ApiClient> m_ApiClient;
};

}  // namespace api
}  // namespace smf
}  // namespace oai

#endif /* OAI_SMF_API_IndividualPDUSessionHSMFApi_H_ */
