/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "CmState_anyOf.h"
#include "Helpers.h"
#include <stdexcept>
#include <sstream>

namespace oai::amf::model {

CmState_anyOf::CmState_anyOf() {}

void CmState_anyOf::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool CmState_anyOf::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool CmState_anyOf::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success = true;
  const std::string _pathPrefix =
      pathPrefix.empty() ? "CmState_anyOf" : pathPrefix;

  if (m_value ==
      CmState_anyOf::eCmState_anyOf::INVALID_VALUE_OPENAPI_GENERATED) {
    success = false;
    msg << _pathPrefix << ": has no value;";
  }

  return success;
}

bool CmState_anyOf::operator==(const CmState_anyOf& rhs) const {
  return getValue() == rhs.getValue()

      ;
}

bool CmState_anyOf::operator!=(const CmState_anyOf& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const CmState_anyOf& o) {
  j = nlohmann::json();

  switch (o.getValue()) {
    case CmState_anyOf::eCmState_anyOf::INVALID_VALUE_OPENAPI_GENERATED:
      j = "INVALID_VALUE_OPENAPI_GENERATED";
      break;
    case CmState_anyOf::eCmState_anyOf::IDLE:
      j = "IDLE";
      break;
    case CmState_anyOf::eCmState_anyOf::CONNECTED:
      j = "CONNECTED";
      break;
  }
}

void from_json(const nlohmann::json& j, CmState_anyOf& o) {
  auto s = j.get<std::string>();
  if (s == "IDLE") {
    o.setValue(CmState_anyOf::eCmState_anyOf::IDLE);
  } else if (s == "CONNECTED") {
    o.setValue(CmState_anyOf::eCmState_anyOf::CONNECTED);
  } else {
    std::stringstream ss;
    ss << "Unexpected value " << s << " in json"
       << " cannot be converted to enum of type"
       << " CmState_anyOf::eCmState_anyOf";
    throw std::invalid_argument(ss.str());
  }
}

CmState_anyOf::eCmState_anyOf CmState_anyOf::getValue() const {
  return m_value;
}
void CmState_anyOf::setValue(CmState_anyOf::eCmState_anyOf value) {
  m_value = value;
}

}  // namespace oai::amf::model
