/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "PlmnId.h"
#include "Helpers.h"

#include <sstream>

namespace oai::amf::model {

PlmnId::PlmnId() {
  m_Mcc = "";
  m_Mnc = "";
}

void PlmnId::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool PlmnId::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool PlmnId::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success                  = true;
  const std::string _pathPrefix = pathPrefix.empty() ? "PlmnId" : pathPrefix;

  /* Mcc */ {
    const std::string& value           = m_Mcc;
    const std::string currentValuePath = _pathPrefix + ".mcc";
  }

  /* Mnc */ {
    const std::string& value           = m_Mnc;
    const std::string currentValuePath = _pathPrefix + ".mnc";
  }

  return success;
}

bool PlmnId::operator==(const PlmnId& rhs) const {
  return

      (getMcc() == rhs.getMcc()) &&

      (getMnc() == rhs.getMnc())

          ;
}

bool PlmnId::operator!=(const PlmnId& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const PlmnId& o) {
  j        = nlohmann::json();
  j["mcc"] = o.m_Mcc;
  j["mnc"] = o.m_Mnc;
}

void from_json(const nlohmann::json& j, PlmnId& o) {
  j.at("mcc").get_to(o.m_Mcc);
  j.at("mnc").get_to(o.m_Mnc);
}

std::string PlmnId::getMcc() const {
  return m_Mcc;
}
void PlmnId::setMcc(std::string const& value) {
  m_Mcc = value;
}
std::string PlmnId::getMnc() const {
  return m_Mnc;
}
void PlmnId::setMnc(std::string const& value) {
  m_Mnc = value;
}

}  // namespace oai::amf::model
