/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "SmContextUpdateError.h"

namespace oai {
namespace smf {
namespace model {

SmContextUpdateError::SmContextUpdateError() {
  m_N1SmMsgIsSet      = false;
  m_N2SmInfoIsSet     = false;
  m_N2SmInfoTypeIsSet = false;
  m_UpCnxStateIsSet   = false;
  m_RecoveryTime      = utility::datetime();
  m_RecoveryTimeIsSet = false;
}

SmContextUpdateError::~SmContextUpdateError() {}

void SmContextUpdateError::validate() {
  // TODO: implement validation
}

web::json::value SmContextUpdateError::toJson() const {
  web::json::value val = web::json::value::object();

  val[utility::conversions::to_string_t("error")] = ModelBase::toJson(m_Error);
  if (m_N1SmMsgIsSet) {
    val[utility::conversions::to_string_t("n1SmMsg")] =
        ModelBase::toJson(m_N1SmMsg);
  }
  if (m_N2SmInfoIsSet) {
    val[utility::conversions::to_string_t("n2SmInfo")] =
        ModelBase::toJson(m_N2SmInfo);
  }
  if (m_N2SmInfoTypeIsSet) {
    val[utility::conversions::to_string_t("n2SmInfoType")] =
        ModelBase::toJson(m_N2SmInfoType);
  }
  if (m_UpCnxStateIsSet) {
    val[utility::conversions::to_string_t("upCnxState")] =
        ModelBase::toJson(m_UpCnxState);
  }
  if (m_RecoveryTimeIsSet) {
    val[utility::conversions::to_string_t("recoveryTime")] =
        ModelBase::toJson(m_RecoveryTime);
  }

  return val;
}

void SmContextUpdateError::fromJson(const web::json::value& val) {
  std::shared_ptr<ProblemDetails_2> newError(new ProblemDetails_2());
  newError->fromJson(val.at(utility::conversions::to_string_t("error")));
  setError(newError);
  if (val.has_field(utility::conversions::to_string_t("n1SmMsg"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n1SmMsg"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN1SmMsg(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN2SmInfo(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfoType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfoType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
      newItem->fromJson(fieldValue);
      setN2SmInfoType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("upCnxState"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("upCnxState"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UpCnxState> newItem(new UpCnxState());
      newItem->fromJson(fieldValue);
      setUpCnxState(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("recoveryTime"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("recoveryTime"));
    if (!fieldValue.is_null()) {
      setRecoveryTime(ModelBase::dateFromJson(fieldValue));
    }
  }
}

void SmContextUpdateError::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  m_Error->toMultipart(multipart, utility::conversions::to_string_t("error."));
  if (m_N1SmMsgIsSet) {
    if (m_N1SmMsg.get()) {
      m_N1SmMsg->toMultipart(
          multipart, utility::conversions::to_string_t("n1SmMsg."));
    }
  }
  if (m_N2SmInfoIsSet) {
    if (m_N2SmInfo.get()) {
      m_N2SmInfo->toMultipart(
          multipart, utility::conversions::to_string_t("n2SmInfo."));
    }
  }
  if (m_N2SmInfoTypeIsSet) {
    if (m_N2SmInfoType.get()) {
      m_N2SmInfoType->toMultipart(
          multipart, utility::conversions::to_string_t("n2SmInfoType."));
    }
  }
  if (m_UpCnxStateIsSet) {
    if (m_UpCnxState.get()) {
      m_UpCnxState->toMultipart(
          multipart, utility::conversions::to_string_t("upCnxState."));
    }
  }
  if (m_RecoveryTimeIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("recoveryTime"),
        m_RecoveryTime));
  }
}

void SmContextUpdateError::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  std::shared_ptr<ProblemDetails_2> newError(new ProblemDetails_2());
  newError->fromMultiPart(
      multipart, utility::conversions::to_string_t("error."));
  setError(newError);
  if (multipart->hasContent(utility::conversions::to_string_t("n1SmMsg"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("n1SmMsg"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n1SmMsg."));
      setN1SmMsg(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("n2SmInfo"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("n2SmInfo"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfo."));
      setN2SmInfo(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("n2SmInfoType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("n2SmInfoType"))) {
      std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfoType."));
      setN2SmInfoType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("upCnxState"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("upCnxState"))) {
      std::shared_ptr<UpCnxState> newItem(new UpCnxState());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("upCnxState."));
      setUpCnxState(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("recoveryTime"))) {
    setRecoveryTime(ModelBase::dateFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("recoveryTime"))));
  }
}

std::shared_ptr<ProblemDetails_2> SmContextUpdateError::getError() const {
  return m_Error;
}

void SmContextUpdateError::setError(
    const std::shared_ptr<ProblemDetails_2>& value) {
  m_Error = value;
}

std::shared_ptr<RefToBinaryData> SmContextUpdateError::getN1SmMsg() const {
  return m_N1SmMsg;
}

void SmContextUpdateError::setN1SmMsg(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N1SmMsg      = value;
  m_N1SmMsgIsSet = true;
}

bool SmContextUpdateError::n1SmMsgIsSet() const {
  return m_N1SmMsgIsSet;
}

void SmContextUpdateError::unsetN1SmMsg() {
  m_N1SmMsgIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextUpdateError::getN2SmInfo() const {
  return m_N2SmInfo;
}

void SmContextUpdateError::setN2SmInfo(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N2SmInfo      = value;
  m_N2SmInfoIsSet = true;
}

bool SmContextUpdateError::n2SmInfoIsSet() const {
  return m_N2SmInfoIsSet;
}

void SmContextUpdateError::unsetN2SmInfo() {
  m_N2SmInfoIsSet = false;
}

std::shared_ptr<N2SmInfoType> SmContextUpdateError::getN2SmInfoType() const {
  return m_N2SmInfoType;
}

void SmContextUpdateError::setN2SmInfoType(
    const std::shared_ptr<N2SmInfoType>& value) {
  m_N2SmInfoType      = value;
  m_N2SmInfoTypeIsSet = true;
}

bool SmContextUpdateError::n2SmInfoTypeIsSet() const {
  return m_N2SmInfoTypeIsSet;
}

void SmContextUpdateError::unsetN2SmInfoType() {
  m_N2SmInfoTypeIsSet = false;
}

std::shared_ptr<UpCnxState> SmContextUpdateError::getUpCnxState() const {
  return m_UpCnxState;
}

void SmContextUpdateError::setUpCnxState(
    const std::shared_ptr<UpCnxState>& value) {
  m_UpCnxState      = value;
  m_UpCnxStateIsSet = true;
}

bool SmContextUpdateError::upCnxStateIsSet() const {
  return m_UpCnxStateIsSet;
}

void SmContextUpdateError::unsetUpCnxState() {
  m_UpCnxStateIsSet = false;
}

utility::datetime SmContextUpdateError::getRecoveryTime() const {
  return m_RecoveryTime;
}

void SmContextUpdateError::setRecoveryTime(const utility::datetime& value) {
  m_RecoveryTime      = value;
  m_RecoveryTimeIsSet = true;
}

bool SmContextUpdateError::recoveryTimeIsSet() const {
  return m_RecoveryTimeIsSet;
}

void SmContextUpdateError::unsetRecoveryTime() {
  m_RecoveryTimeIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
