/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "StatusInfo.h"

namespace oai {
namespace smf {
namespace model {

StatusInfo::StatusInfo() {
  m_CauseIsSet = false;
}

StatusInfo::~StatusInfo() {}

void StatusInfo::validate() {
  // TODO: implement validation
}

web::json::value StatusInfo::toJson() const {
  web::json::value val = web::json::value::object();

  val[utility::conversions::to_string_t("resourceStatus")] =
      ModelBase::toJson(m_ResourceStatus);
  if (m_CauseIsSet) {
    val[utility::conversions::to_string_t("cause")] =
        ModelBase::toJson(m_Cause);
  }

  return val;
}

void StatusInfo::fromJson(const web::json::value& val) {
  std::shared_ptr<ResourceStatus> newResourceStatus(new ResourceStatus());
  newResourceStatus->fromJson(
      val.at(utility::conversions::to_string_t("resourceStatus")));
  setResourceStatus(newResourceStatus);
  if (val.has_field(utility::conversions::to_string_t("cause"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("cause"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Cause> newItem(new Cause());
      newItem->fromJson(fieldValue);
      setCause(newItem);
    }
  }
}

void StatusInfo::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  m_ResourceStatus->toMultipart(
      multipart, utility::conversions::to_string_t("resourceStatus."));
  if (m_CauseIsSet) {
    if (m_Cause.get()) {
      m_Cause->toMultipart(
          multipart, utility::conversions::to_string_t("cause."));
    }
  }
}

void StatusInfo::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  std::shared_ptr<ResourceStatus> newResourceStatus(new ResourceStatus());
  newResourceStatus->fromMultiPart(
      multipart, utility::conversions::to_string_t("resourceStatus."));
  setResourceStatus(newResourceStatus);
  if (multipart->hasContent(utility::conversions::to_string_t("cause"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("cause"))) {
      std::shared_ptr<Cause> newItem(new Cause());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("cause."));
      setCause(newItem);
    }
  }
}

std::shared_ptr<ResourceStatus> StatusInfo::getResourceStatus() const {
  return m_ResourceStatus;
}

void StatusInfo::setResourceStatus(
    const std::shared_ptr<ResourceStatus>& value) {
  m_ResourceStatus = value;
}

std::shared_ptr<Cause> StatusInfo::getCause() const {
  return m_Cause;
}

void StatusInfo::setCause(const std::shared_ptr<Cause>& value) {
  m_Cause      = value;
  m_CauseIsSet = true;
}

bool StatusInfo::causeIsSet() const {
  return m_CauseIsSet;
}

void StatusInfo::unsetCause() {
  m_CauseIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
