/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * VsmfUpdateData.h
 *
 *
 */

#ifndef OAI_SMF_MODEL_VsmfUpdateData_H_
#define OAI_SMF_MODEL_VsmfUpdateData_H_

#include "../ModelBase.h"

#include "Ambr.h"
#include "RequestIndication.h"
#include "EpsBearerInfo.h"
#include "MaReleaseIndication.h"
#include "EbiArpMapping.h"
#include "QosFlowReleaseRequestItem.h"
#include "Cause.h"
#include "RefToBinaryData.h"
#include "QosFlowAddModifyRequestItem.h"
#include <cpprest/details/basic_types.h>
#include <vector>

namespace oai {
namespace smf {
namespace model {

/// <summary>
///
/// </summary>
class VsmfUpdateData : public ModelBase {
 public:
  VsmfUpdateData();
  virtual ~VsmfUpdateData();

  /////////////////////////////////////////////
  /// ModelBase overrides

  void validate() override;

  web::json::value toJson() const override;
  void fromJson(const web::json::value& json) override;

  void toMultipart(
      std::shared_ptr<MultipartFormData> multipart,
      const utility::string_t& namePrefix) const override;
  void fromMultiPart(
      std::shared_ptr<MultipartFormData> multipart,
      const utility::string_t& namePrefix) override;

  /////////////////////////////////////////////
  /// VsmfUpdateData members

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RequestIndication> getRequestIndication() const;

  void setRequestIndication(const std::shared_ptr<RequestIndication>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<Ambr> getSessionAmbr() const;
  bool sessionAmbrIsSet() const;
  void unsetSessionAmbr();

  void setSessionAmbr(const std::shared_ptr<Ambr>& value);

  /// <summary>
  ///
  /// </summary>
  std::vector<std::shared_ptr<QosFlowAddModifyRequestItem>>&
  getQosFlowsAddModRequestList();
  bool qosFlowsAddModRequestListIsSet() const;
  void unsetQosFlowsAddModRequestList();

  void setQosFlowsAddModRequestList(
      const std::vector<std::shared_ptr<QosFlowAddModifyRequestItem>>& value);

  /// <summary>
  ///
  /// </summary>
  std::vector<std::shared_ptr<QosFlowReleaseRequestItem>>&
  getQosFlowsRelRequestList();
  bool qosFlowsRelRequestListIsSet() const;
  void unsetQosFlowsRelRequestList();

  void setQosFlowsRelRequestList(
      const std::vector<std::shared_ptr<QosFlowReleaseRequestItem>>& value);

  /// <summary>
  ///
  /// </summary>
  std::vector<std::shared_ptr<EpsBearerInfo>>& getEpsBearerInfo();
  bool epsBearerInfoIsSet() const;
  void unsetEpsBearerInfo();

  void setEpsBearerInfo(
      const std::vector<std::shared_ptr<EpsBearerInfo>>& value);

  /// <summary>
  ///
  /// </summary>
  std::vector<int32_t>& getAssignEbiList();
  bool assignEbiListIsSet() const;
  void unsetAssignEbiList();

  void setAssignEbiList(std::vector<int32_t> value);

  /// <summary>
  ///
  /// </summary>
  std::vector<int32_t>& getRevokeEbiList();
  bool revokeEbiListIsSet() const;
  void unsetRevokeEbiList();

  void setRevokeEbiList(std::vector<int32_t> value);

  /// <summary>
  ///
  /// </summary>
  std::vector<std::shared_ptr<EbiArpMapping>>& getModifiedEbiList();
  bool modifiedEbiListIsSet() const;
  void unsetModifiedEbiList();

  void setModifiedEbiList(
      const std::vector<std::shared_ptr<EbiArpMapping>>& value);

  /// <summary>
  ///
  /// </summary>
  int32_t getPti() const;
  bool ptiIsSet() const;
  void unsetPti();

  void setPti(int32_t value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RefToBinaryData> getN1SmInfoToUe() const;
  bool n1SmInfoToUeIsSet() const;
  void unsetN1SmInfoToUe();

  void setN1SmInfoToUe(const std::shared_ptr<RefToBinaryData>& value);

  /// <summary>
  ///
  /// </summary>
  bool isAlwaysOnGranted() const;
  bool alwaysOnGrantedIsSet() const;
  void unsetAlwaysOnGranted();

  void setAlwaysOnGranted(bool value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getHsmfPduSessionUri() const;
  bool hsmfPduSessionUriIsSet() const;
  void unsetHsmfPduSessionUri();

  void setHsmfPduSessionUri(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getSupportedFeatures() const;
  bool supportedFeaturesIsSet() const;
  void unsetSupportedFeatures();

  void setSupportedFeatures(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<Cause> getCause() const;
  bool causeIsSet() const;
  void unsetCause();

  void setCause(const std::shared_ptr<Cause>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getN1smCause() const;
  bool n1smCauseIsSet() const;
  void unsetN1smCause();

  void setN1smCause(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  int32_t getBackOffTimer() const;
  bool backOffTimerIsSet() const;
  void unsetBackOffTimer();

  void setBackOffTimer(int32_t value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<MaReleaseIndication> getMaReleaseInd() const;
  bool maReleaseIndIsSet() const;
  void unsetMaReleaseInd();

  void setMaReleaseInd(const std::shared_ptr<MaReleaseIndication>& value);

 protected:
  std::shared_ptr<RequestIndication> m_RequestIndication;
  std::shared_ptr<Ambr> m_SessionAmbr;
  bool m_SessionAmbrIsSet;
  std::vector<std::shared_ptr<QosFlowAddModifyRequestItem>>
      m_QosFlowsAddModRequestList;
  bool m_QosFlowsAddModRequestListIsSet;
  std::vector<std::shared_ptr<QosFlowReleaseRequestItem>>
      m_QosFlowsRelRequestList;
  bool m_QosFlowsRelRequestListIsSet;
  std::vector<std::shared_ptr<EpsBearerInfo>> m_EpsBearerInfo;
  bool m_EpsBearerInfoIsSet;
  std::vector<int32_t> m_AssignEbiList;
  bool m_AssignEbiListIsSet;
  std::vector<int32_t> m_RevokeEbiList;
  bool m_RevokeEbiListIsSet;
  std::vector<std::shared_ptr<EbiArpMapping>> m_ModifiedEbiList;
  bool m_ModifiedEbiListIsSet;
  int32_t m_Pti;
  bool m_PtiIsSet;
  std::shared_ptr<RefToBinaryData> m_N1SmInfoToUe;
  bool m_N1SmInfoToUeIsSet;
  bool m_AlwaysOnGranted;
  bool m_AlwaysOnGrantedIsSet;
  utility::string_t m_HsmfPduSessionUri;
  bool m_HsmfPduSessionUriIsSet;
  utility::string_t m_SupportedFeatures;
  bool m_SupportedFeaturesIsSet;
  std::shared_ptr<Cause> m_Cause;
  bool m_CauseIsSet;
  utility::string_t m_N1smCause;
  bool m_N1smCauseIsSet;
  int32_t m_BackOffTimer;
  bool m_BackOffTimerIsSet;
  std::shared_ptr<MaReleaseIndication> m_MaReleaseInd;
  bool m_MaReleaseIndIsSet;
};

}  // namespace model
}  // namespace smf
}  // namespace oai

#endif /* OAI_SMF_MODEL_VsmfUpdateData_H_ */
