/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this
 * file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/*! \file
 \brief
 \author  Keliang DU, BUPT
 \date 2020
 \email: contact@openairinterface.org
 */

#include "Pre-emptionVulnerability.hpp"

#include <iostream>
using namespace std;

namespace ngap {

//------------------------------------------------------------------------------
Pre_emptionVulnerability::Pre_emptionVulnerability() {
  vulnerability = 0;
}

//------------------------------------------------------------------------------
Pre_emptionVulnerability::~Pre_emptionVulnerability() {}

//------------------------------------------------------------------------------
void Pre_emptionVulnerability::setPre_emptionVulnerability(
    e_Ngap_Pre_emptionVulnerability value) {
  vulnerability = value;
}

//------------------------------------------------------------------------------
bool Pre_emptionVulnerability::getPre_emptionVulnerability(
    e_Ngap_Pre_emptionVulnerability& value) {
  if ((vulnerability == 0) || (vulnerability == 1))
    value = (e_Ngap_Pre_emptionVulnerability) vulnerability;
  else
    return false;

  return true;
}

//------------------------------------------------------------------------------
bool Pre_emptionVulnerability::encode2Pre_emptionVulnerability(
    Ngap_Pre_emptionVulnerability_t* pre_emptionVulnerability) {
  *pre_emptionVulnerability = vulnerability;

  return true;
}

//------------------------------------------------------------------------------
bool Pre_emptionVulnerability::decodefromPre_emptionVulnerability(
    Ngap_Pre_emptionVulnerability_t* pre_emptionVulnerability) {
  vulnerability = *pre_emptionVulnerability;

  return true;
}
}  // namespace ngap
