/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "GNbId.h"
#include "Helpers.h"

#include <sstream>

namespace oai::amf::model {

GNbId::GNbId() {
  m_BitLength = 0;
  m_GNBValue  = "";
}

void GNbId::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool GNbId::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool GNbId::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success                  = true;
  const std::string _pathPrefix = pathPrefix.empty() ? "GNbId" : pathPrefix;

  /* BitLength */ {
    const int32_t& value               = m_BitLength;
    const std::string currentValuePath = _pathPrefix + ".bitLength";

    if (value < 22) {
      success = false;
      msg << currentValuePath << ": must be greater than or equal to 22;";
    }
    if (value > 32) {
      success = false;
      msg << currentValuePath << ": must be less than or equal to 32;";
    }
  }

  /* GNBValue */ {
    const std::string& value           = m_GNBValue;
    const std::string currentValuePath = _pathPrefix + ".gNBValue";
  }

  return success;
}

bool GNbId::operator==(const GNbId& rhs) const {
  return

      (getBitLength() == rhs.getBitLength()) &&

      (getGNBValue() == rhs.getGNBValue())

          ;
}

bool GNbId::operator!=(const GNbId& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const GNbId& o) {
  j              = nlohmann::json();
  j["bitLength"] = o.m_BitLength;
  j["gNBValue"]  = o.m_GNBValue;
}

void from_json(const nlohmann::json& j, GNbId& o) {
  j.at("bitLength").get_to(o.m_BitLength);
  j.at("gNBValue").get_to(o.m_GNBValue);
}

int32_t GNbId::getBitLength() const {
  return m_BitLength;
}
void GNbId::setBitLength(int32_t const value) {
  m_BitLength = value;
}
std::string GNbId::getGNBValue() const {
  return m_GNBValue;
}
void GNbId::setGNBValue(std::string const& value) {
  m_GNBValue = value;
}

}  // namespace oai::amf::model
