/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "SmContextUpdateData.h"

namespace oai {
namespace smf {
namespace model {

SmContextUpdateData::SmContextUpdateData() {
  m_Pei                     = utility::conversions::to_string_t("");
  m_PeiIsSet                = false;
  m_ServingNfId             = utility::conversions::to_string_t("");
  m_ServingNfIdIsSet        = false;
  m_GuamiIsSet              = false;
  m_ServingNetworkIsSet     = false;
  m_BackupAmfInfoIsSet      = false;
  m_AnTypeIsSet             = false;
  m_SecondAnTypeIsSet       = false;
  m_RatTypeIsSet            = false;
  m_PresenceInLadnIsSet     = false;
  m_UeLocationIsSet         = false;
  m_UeTimeZone              = utility::conversions::to_string_t("");
  m_UeTimeZoneIsSet         = false;
  m_AddUeLocationIsSet      = false;
  m_UpCnxStateIsSet         = false;
  m_HoStateIsSet            = false;
  m_ToBeSwitched            = false;
  m_ToBeSwitchedIsSet       = false;
  m_FailedToBeSwitched      = false;
  m_FailedToBeSwitchedIsSet = false;
  m_N1SmMsgIsSet            = false;
  m_N2SmInfoIsSet           = false;
  m_N2SmInfoTypeIsSet       = false;
  m_TargetIdIsSet           = false;
  m_TargetServingNfId       = utility::conversions::to_string_t("");
  m_TargetServingNfIdIsSet  = false;
  m_SmContextStatusUri      = utility::conversions::to_string_t("");
  m_SmContextStatusUriIsSet = false;
  m_DataForwarding          = false;
  m_DataForwardingIsSet     = false;
  m_EpsBearerSetupIsSet     = false;
  m_RevokeEbiListIsSet      = false;
  m_Release                 = false;
  m_ReleaseIsSet            = false;
  m_CauseIsSet              = false;
  m_NgApCauseIsSet          = false;
  m__5gMmCauseValue         = 0;
  m__5gMmCauseValueIsSet    = false;
  m_SNssaiIsSet             = false;
  m_TraceDataIsSet          = false;
  m_EpsInterworkingIndIsSet = false;
  m_AnTypeCanBeChanged      = false;
  m_AnTypeCanBeChangedIsSet = false;
  m_N2SmInfoExt1IsSet       = false;
  m_N2SmInfoTypeExt1IsSet   = false;
  m_MaReleaseIndIsSet       = false;
  m_ExemptionIndIsSet       = false;
}

SmContextUpdateData::~SmContextUpdateData() {}

void SmContextUpdateData::validate() {
  // TODO: implement validation
}

web::json::value SmContextUpdateData::toJson() const {
  web::json::value val = web::json::value::object();

  if (m_PeiIsSet) {
    val[utility::conversions::to_string_t("pei")] = ModelBase::toJson(m_Pei);
  }
  if (m_ServingNfIdIsSet) {
    val[utility::conversions::to_string_t("servingNfId")] =
        ModelBase::toJson(m_ServingNfId);
  }
  if (m_GuamiIsSet) {
    val[utility::conversions::to_string_t("guami")] =
        ModelBase::toJson(m_Guami);
  }
  if (m_ServingNetworkIsSet) {
    val[utility::conversions::to_string_t("servingNetwork")] =
        ModelBase::toJson(m_ServingNetwork);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_BackupAmfInfo) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("backupAmfInfo")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_AnTypeIsSet) {
    val[utility::conversions::to_string_t("anType")] =
        ModelBase::toJson(m_AnType);
  }
  if (m_SecondAnTypeIsSet) {
    val[utility::conversions::to_string_t("secondAnType")] =
        ModelBase::toJson(m_SecondAnType);
  }
  if (m_RatTypeIsSet) {
    val[utility::conversions::to_string_t("ratType")] =
        ModelBase::toJson(m_RatType);
  }
  if (m_PresenceInLadnIsSet) {
    val[utility::conversions::to_string_t("presenceInLadn")] =
        ModelBase::toJson(m_PresenceInLadn);
  }
  if (m_UeLocationIsSet) {
    val[utility::conversions::to_string_t("ueLocation")] =
        ModelBase::toJson(m_UeLocation);
  }
  if (m_UeTimeZoneIsSet) {
    val[utility::conversions::to_string_t("ueTimeZone")] =
        ModelBase::toJson(m_UeTimeZone);
  }
  if (m_AddUeLocationIsSet) {
    val[utility::conversions::to_string_t("addUeLocation")] =
        ModelBase::toJson(m_AddUeLocation);
  }
  if (m_UpCnxStateIsSet) {
    val[utility::conversions::to_string_t("upCnxState")] =
        ModelBase::toJson(m_UpCnxState);
  }
  if (m_HoStateIsSet) {
    val[utility::conversions::to_string_t("hoState")] =
        ModelBase::toJson(m_HoState);
  }
  if (m_ToBeSwitchedIsSet) {
    val[utility::conversions::to_string_t("toBeSwitched")] =
        ModelBase::toJson(m_ToBeSwitched);
  }
  if (m_FailedToBeSwitchedIsSet) {
    val[utility::conversions::to_string_t("failedToBeSwitched")] =
        ModelBase::toJson(m_FailedToBeSwitched);
  }
  if (m_N1SmMsgIsSet) {
    val[utility::conversions::to_string_t("n1SmMsg")] =
        ModelBase::toJson(m_N1SmMsg);
  }
  if (m_N2SmInfoIsSet) {
    val[utility::conversions::to_string_t("n2SmInfo")] =
        ModelBase::toJson(m_N2SmInfo);
  }
  if (m_N2SmInfoTypeIsSet) {
    val[utility::conversions::to_string_t("n2SmInfoType")] =
        ModelBase::toJson(m_N2SmInfoType);
  }
  if (m_TargetIdIsSet) {
    val[utility::conversions::to_string_t("targetId")] =
        ModelBase::toJson(m_TargetId);
  }
  if (m_TargetServingNfIdIsSet) {
    val[utility::conversions::to_string_t("targetServingNfId")] =
        ModelBase::toJson(m_TargetServingNfId);
  }
  if (m_SmContextStatusUriIsSet) {
    val[utility::conversions::to_string_t("smContextStatusUri")] =
        ModelBase::toJson(m_SmContextStatusUri);
  }
  if (m_DataForwardingIsSet) {
    val[utility::conversions::to_string_t("dataForwarding")] =
        ModelBase::toJson(m_DataForwarding);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_EpsBearerSetup) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("epsBearerSetup")] =
          web::json::value::array(jsonArray);
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_RevokeEbiList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("revokeEbiList")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_ReleaseIsSet) {
    val[utility::conversions::to_string_t("release")] =
        ModelBase::toJson(m_Release);
  }
  if (m_CauseIsSet) {
    val[utility::conversions::to_string_t("cause")] =
        ModelBase::toJson(m_Cause);
  }
  if (m_NgApCauseIsSet) {
    val[utility::conversions::to_string_t("ngApCause")] =
        ModelBase::toJson(m_NgApCause);
  }
  if (m__5gMmCauseValueIsSet) {
    val[utility::conversions::to_string_t("5gMmCauseValue")] =
        ModelBase::toJson(m__5gMmCauseValue);
  }
  if (m_SNssaiIsSet) {
    val[utility::conversions::to_string_t("sNssai")] =
        ModelBase::toJson(m_SNssai);
  }
  if (m_TraceDataIsSet) {
    val[utility::conversions::to_string_t("traceData")] =
        ModelBase::toJson(m_TraceData);
  }
  if (m_EpsInterworkingIndIsSet) {
    val[utility::conversions::to_string_t("epsInterworkingInd")] =
        ModelBase::toJson(m_EpsInterworkingInd);
  }
  if (m_AnTypeCanBeChangedIsSet) {
    val[utility::conversions::to_string_t("anTypeCanBeChanged")] =
        ModelBase::toJson(m_AnTypeCanBeChanged);
  }
  if (m_N2SmInfoExt1IsSet) {
    val[utility::conversions::to_string_t("n2SmInfoExt1")] =
        ModelBase::toJson(m_N2SmInfoExt1);
  }
  if (m_N2SmInfoTypeExt1IsSet) {
    val[utility::conversions::to_string_t("n2SmInfoTypeExt1")] =
        ModelBase::toJson(m_N2SmInfoTypeExt1);
  }
  if (m_MaReleaseIndIsSet) {
    val[utility::conversions::to_string_t("maReleaseInd")] =
        ModelBase::toJson(m_MaReleaseInd);
  }
  if (m_ExemptionIndIsSet) {
    val[utility::conversions::to_string_t("exemptionInd")] =
        ModelBase::toJson(m_ExemptionInd);
  }

  return val;
}

void SmContextUpdateData::fromJson(const web::json::value& val) {
  if (val.has_field(utility::conversions::to_string_t("pei"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pei"));
    if (!fieldValue.is_null()) {
      setPei(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("servingNfId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("servingNfId"));
    if (!fieldValue.is_null()) {
      setServingNfId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("guami"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("guami"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Guami> newItem(new Guami());
      newItem->fromJson(fieldValue);
      setGuami(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("servingNetwork"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("servingNetwork"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<PlmnId> newItem(new PlmnId());
      newItem->fromJson(fieldValue);
      setServingNetwork(newItem);
    }
  }
  {
    m_BackupAmfInfo.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("backupAmfInfo"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("backupAmfInfo"))
               .as_array()) {
        if (item.is_null()) {
          m_BackupAmfInfo.push_back(std::shared_ptr<BackupAmfInfo>(nullptr));
        } else {
          std::shared_ptr<BackupAmfInfo> newItem(new BackupAmfInfo());
          newItem->fromJson(item);
          m_BackupAmfInfo.push_back(newItem);
        }
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("anType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("anType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromJson(fieldValue);
      setAnType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("secondAnType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("secondAnType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromJson(fieldValue);
      setSecondAnType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ratType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ratType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromJson(fieldValue);
      setRatType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("presenceInLadn"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("presenceInLadn"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<PresenceState> newItem(new PresenceState());
      newItem->fromJson(fieldValue);
      setPresenceInLadn(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueTimeZone"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueTimeZone"));
    if (!fieldValue.is_null()) {
      setUeTimeZone(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("addUeLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("addUeLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setAddUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("upCnxState"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("upCnxState"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UpCnxState> newItem(new UpCnxState());
      newItem->fromJson(fieldValue);
      setUpCnxState(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("hoState"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hoState"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<HoState> newItem(new HoState());
      newItem->fromJson(fieldValue);
      setHoState(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("toBeSwitched"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("toBeSwitched"));
    if (!fieldValue.is_null()) {
      setToBeSwitched(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("failedToBeSwitched"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("failedToBeSwitched"));
    if (!fieldValue.is_null()) {
      setFailedToBeSwitched(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n1SmMsg"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n1SmMsg"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN1SmMsg(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN2SmInfo(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfoType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfoType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
      newItem->fromJson(fieldValue);
      setN2SmInfoType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("targetId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("targetId"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<NgRanTargetId> newItem(new NgRanTargetId());
      newItem->fromJson(fieldValue);
      setTargetId(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("targetServingNfId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("targetServingNfId"));
    if (!fieldValue.is_null()) {
      setTargetServingNfId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("smContextStatusUri"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("smContextStatusUri"));
    if (!fieldValue.is_null()) {
      setSmContextStatusUri(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("dataForwarding"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("dataForwarding"));
    if (!fieldValue.is_null()) {
      setDataForwarding(ModelBase::boolFromJson(fieldValue));
    }
  }
  {
    m_EpsBearerSetup.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("epsBearerSetup"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("epsBearerSetup"))
               .as_array()) {
        m_EpsBearerSetup.push_back(ModelBase::stringFromJson(item));
      }
    }
  }
  {
    m_RevokeEbiList.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("revokeEbiList"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("revokeEbiList"))
               .as_array()) {
        m_RevokeEbiList.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("release"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("release"));
    if (!fieldValue.is_null()) {
      setRelease(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("cause"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("cause"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Cause> newItem(new Cause());
      newItem->fromJson(fieldValue);
      setCause(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ngApCause"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ngApCause"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<NgApCause> newItem(new NgApCause());
      newItem->fromJson(fieldValue);
      setNgApCause(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("5gMmCauseValue"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("5gMmCauseValue"));
    if (!fieldValue.is_null()) {
      set5gMmCauseValue(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("sNssai"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("sNssai"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromJson(fieldValue);
      setSNssai(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("traceData"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("traceData"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<TraceData> newItem(new TraceData());
      newItem->fromJson(fieldValue);
      setTraceData(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("epsInterworkingInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("epsInterworkingInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromJson(fieldValue);
      setEpsInterworkingInd(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("anTypeCanBeChanged"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("anTypeCanBeChanged"));
    if (!fieldValue.is_null()) {
      setAnTypeCanBeChanged(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfoExt1"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfoExt1"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN2SmInfoExt1(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfoTypeExt1"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfoTypeExt1"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
      newItem->fromJson(fieldValue);
      setN2SmInfoTypeExt1(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("maReleaseInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("maReleaseInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<MaReleaseIndication> newItem(new MaReleaseIndication());
      newItem->fromJson(fieldValue);
      setMaReleaseInd(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("exemptionInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("exemptionInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<ExemptionInd> newItem(new ExemptionInd());
      newItem->fromJson(fieldValue);
      setExemptionInd(newItem);
    }
  }
}

void SmContextUpdateData::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  if (m_PeiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pei"), m_Pei));
  }
  if (m_ServingNfIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("servingNfId"),
        m_ServingNfId));
  }
  if (m_GuamiIsSet) {
    if (m_Guami.get()) {
      m_Guami->toMultipart(
          multipart, utility::conversions::to_string_t("guami."));
    }
  }
  if (m_ServingNetworkIsSet) {
    if (m_ServingNetwork.get()) {
      m_ServingNetwork->toMultipart(
          multipart, utility::conversions::to_string_t("servingNetwork."));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_BackupAmfInfo) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("backupAmfInfo"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_AnTypeIsSet) {
    if (m_AnType.get()) {
      m_AnType->toMultipart(
          multipart, utility::conversions::to_string_t("anType."));
    }
  }
  if (m_SecondAnTypeIsSet) {
    if (m_SecondAnType.get()) {
      m_SecondAnType->toMultipart(
          multipart, utility::conversions::to_string_t("secondAnType."));
    }
  }
  if (m_RatTypeIsSet) {
    if (m_RatType.get()) {
      m_RatType->toMultipart(
          multipart, utility::conversions::to_string_t("ratType."));
    }
  }
  if (m_PresenceInLadnIsSet) {
    if (m_PresenceInLadn.get()) {
      m_PresenceInLadn->toMultipart(
          multipart, utility::conversions::to_string_t("presenceInLadn."));
    }
  }
  if (m_UeLocationIsSet) {
    if (m_UeLocation.get()) {
      m_UeLocation->toMultipart(
          multipart, utility::conversions::to_string_t("ueLocation."));
    }
  }
  if (m_UeTimeZoneIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("ueTimeZone"),
        m_UeTimeZone));
  }
  if (m_AddUeLocationIsSet) {
    if (m_AddUeLocation.get()) {
      m_AddUeLocation->toMultipart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
    }
  }
  if (m_UpCnxStateIsSet) {
    if (m_UpCnxState.get()) {
      m_UpCnxState->toMultipart(
          multipart, utility::conversions::to_string_t("upCnxState."));
    }
  }
  if (m_HoStateIsSet) {
    if (m_HoState.get()) {
      m_HoState->toMultipart(
          multipart, utility::conversions::to_string_t("hoState."));
    }
  }
  if (m_ToBeSwitchedIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("toBeSwitched"),
        m_ToBeSwitched));
  }
  if (m_FailedToBeSwitchedIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("failedToBeSwitched"),
        m_FailedToBeSwitched));
  }
  if (m_N1SmMsgIsSet) {
    if (m_N1SmMsg.get()) {
      m_N1SmMsg->toMultipart(
          multipart, utility::conversions::to_string_t("n1SmMsg."));
    }
  }
  if (m_N2SmInfoIsSet) {
    if (m_N2SmInfo.get()) {
      m_N2SmInfo->toMultipart(
          multipart, utility::conversions::to_string_t("n2SmInfo."));
    }
  }
  if (m_N2SmInfoTypeIsSet) {
    if (m_N2SmInfoType.get()) {
      m_N2SmInfoType->toMultipart(
          multipart, utility::conversions::to_string_t("n2SmInfoType."));
    }
  }
  if (m_TargetIdIsSet) {
    if (m_TargetId.get()) {
      m_TargetId->toMultipart(
          multipart, utility::conversions::to_string_t("targetId."));
    }
  }
  if (m_TargetServingNfIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("targetServingNfId"),
        m_TargetServingNfId));
  }
  if (m_SmContextStatusUriIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("smContextStatusUri"),
        m_SmContextStatusUri));
  }
  if (m_DataForwardingIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("dataForwarding"),
        m_DataForwarding));
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_EpsBearerSetup) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("epsBearerSetup"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_RevokeEbiList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("revokeEbiList"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_ReleaseIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("release"), m_Release));
  }
  if (m_CauseIsSet) {
    if (m_Cause.get()) {
      m_Cause->toMultipart(
          multipart, utility::conversions::to_string_t("cause."));
    }
  }
  if (m_NgApCauseIsSet) {
    if (m_NgApCause.get()) {
      m_NgApCause->toMultipart(
          multipart, utility::conversions::to_string_t("ngApCause."));
    }
  }
  if (m__5gMmCauseValueIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("5gMmCauseValue"),
        m__5gMmCauseValue));
  }
  if (m_SNssaiIsSet) {
    if (m_SNssai.get()) {
      m_SNssai->toMultipart(
          multipart, utility::conversions::to_string_t("sNssai."));
    }
  }
  if (m_TraceDataIsSet) {
    if (m_TraceData.get()) {
      m_TraceData->toMultipart(
          multipart, utility::conversions::to_string_t("traceData."));
    }
  }
  if (m_EpsInterworkingIndIsSet) {
    if (m_EpsInterworkingInd.get()) {
      m_EpsInterworkingInd->toMultipart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
    }
  }
  if (m_AnTypeCanBeChangedIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("anTypeCanBeChanged"),
        m_AnTypeCanBeChanged));
  }
  if (m_N2SmInfoExt1IsSet) {
    if (m_N2SmInfoExt1.get()) {
      m_N2SmInfoExt1->toMultipart(
          multipart, utility::conversions::to_string_t("n2SmInfoExt1."));
    }
  }
  if (m_N2SmInfoTypeExt1IsSet) {
    if (m_N2SmInfoTypeExt1.get()) {
      m_N2SmInfoTypeExt1->toMultipart(
          multipart, utility::conversions::to_string_t("n2SmInfoTypeExt1."));
    }
  }
  if (m_MaReleaseIndIsSet) {
    if (m_MaReleaseInd.get()) {
      m_MaReleaseInd->toMultipart(
          multipart, utility::conversions::to_string_t("maReleaseInd."));
    }
  }
  if (m_ExemptionIndIsSet) {
    if (m_ExemptionInd.get()) {
      m_ExemptionInd->toMultipart(
          multipart, utility::conversions::to_string_t("exemptionInd."));
    }
  }
}

void SmContextUpdateData::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  if (multipart->hasContent(utility::conversions::to_string_t("pei"))) {
    setPei(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("pei"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("servingNfId"))) {
    setServingNfId(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("servingNfId"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("guami"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("guami"))) {
      std::shared_ptr<Guami> newItem(new Guami());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("guami."));
      setGuami(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("servingNetwork"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("servingNetwork"))) {
      std::shared_ptr<PlmnId> newItem(new PlmnId());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("servingNetwork."));
      setServingNetwork(newItem);
    }
  }
  {
    m_BackupAmfInfo.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("backupAmfInfo"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("backupAmfInfo"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_BackupAmfInfo.push_back(std::shared_ptr<BackupAmfInfo>(nullptr));
        } else {
          std::shared_ptr<BackupAmfInfo> newItem(new BackupAmfInfo());
          newItem->fromJson(item);
          m_BackupAmfInfo.push_back(newItem);
        }
      }
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("anType"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("anType"))) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("anType."));
      setAnType(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("secondAnType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("secondAnType"))) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("secondAnType."));
      setSecondAnType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ratType."));
      setRatType(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("presenceInLadn"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("presenceInLadn"))) {
      std::shared_ptr<PresenceState> newItem(new PresenceState());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("presenceInLadn."));
      setPresenceInLadn(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("ueLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ueLocation."));
      setUeLocation(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueTimeZone"))) {
    setUeTimeZone(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("ueTimeZone"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("addUeLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("addUeLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
      setAddUeLocation(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("upCnxState"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("upCnxState"))) {
      std::shared_ptr<UpCnxState> newItem(new UpCnxState());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("upCnxState."));
      setUpCnxState(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("hoState"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("hoState"))) {
      std::shared_ptr<HoState> newItem(new HoState());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("hoState."));
      setHoState(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("toBeSwitched"))) {
    setToBeSwitched(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("toBeSwitched"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("failedToBeSwitched"))) {
    setFailedToBeSwitched(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("failedToBeSwitched"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("n1SmMsg"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("n1SmMsg"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n1SmMsg."));
      setN1SmMsg(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("n2SmInfo"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("n2SmInfo"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfo."));
      setN2SmInfo(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("n2SmInfoType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("n2SmInfoType"))) {
      std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfoType."));
      setN2SmInfoType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("targetId"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("targetId"))) {
      std::shared_ptr<NgRanTargetId> newItem(new NgRanTargetId());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("targetId."));
      setTargetId(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("targetServingNfId"))) {
    setTargetServingNfId(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("targetServingNfId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("smContextStatusUri"))) {
    setSmContextStatusUri(
        ModelBase::stringFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("smContextStatusUri"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("dataForwarding"))) {
    setDataForwarding(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("dataForwarding"))));
  }
  {
    m_EpsBearerSetup.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsBearerSetup"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("epsBearerSetup"))));
      for (auto& item : jsonArray.as_array()) {
        m_EpsBearerSetup.push_back(ModelBase::stringFromJson(item));
      }
    }
  }
  {
    m_RevokeEbiList.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("revokeEbiList"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("revokeEbiList"))));
      for (auto& item : jsonArray.as_array()) {
        m_RevokeEbiList.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("release"))) {
    setRelease(ModelBase::boolFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("release"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("cause"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("cause"))) {
      std::shared_ptr<Cause> newItem(new Cause());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("cause."));
      setCause(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ngApCause"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("ngApCause"))) {
      std::shared_ptr<NgApCause> newItem(new NgApCause());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ngApCause."));
      setNgApCause(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("5gMmCauseValue"))) {
    set5gMmCauseValue(ModelBase::int32_tFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("5gMmCauseValue"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("sNssai"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("sNssai"))) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("sNssai."));
      setSNssai(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("traceData"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("traceData"))) {
      std::shared_ptr<TraceData> newItem(new TraceData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("traceData."));
      setTraceData(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("epsInterworkingInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsInterworkingInd"))) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
      setEpsInterworkingInd(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("anTypeCanBeChanged"))) {
    setAnTypeCanBeChanged(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("anTypeCanBeChanged"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("n2SmInfoExt1"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("n2SmInfoExt1"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfoExt1."));
      setN2SmInfoExt1(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("n2SmInfoTypeExt1"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("n2SmInfoTypeExt1"))) {
      std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfoTypeExt1."));
      setN2SmInfoTypeExt1(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("maReleaseInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("maReleaseInd"))) {
      std::shared_ptr<MaReleaseIndication> newItem(new MaReleaseIndication());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("maReleaseInd."));
      setMaReleaseInd(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("exemptionInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("exemptionInd"))) {
      std::shared_ptr<ExemptionInd> newItem(new ExemptionInd());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("exemptionInd."));
      setExemptionInd(newItem);
    }
  }
}

utility::string_t SmContextUpdateData::getPei() const {
  return m_Pei;
}

void SmContextUpdateData::setPei(const utility::string_t& value) {
  m_Pei      = value;
  m_PeiIsSet = true;
}

bool SmContextUpdateData::peiIsSet() const {
  return m_PeiIsSet;
}

void SmContextUpdateData::unsetPei() {
  m_PeiIsSet = false;
}

utility::string_t SmContextUpdateData::getServingNfId() const {
  return m_ServingNfId;
}

void SmContextUpdateData::setServingNfId(const utility::string_t& value) {
  m_ServingNfId      = value;
  m_ServingNfIdIsSet = true;
}

bool SmContextUpdateData::servingNfIdIsSet() const {
  return m_ServingNfIdIsSet;
}

void SmContextUpdateData::unsetServingNfId() {
  m_ServingNfIdIsSet = false;
}

std::shared_ptr<Guami> SmContextUpdateData::getGuami() const {
  return m_Guami;
}

void SmContextUpdateData::setGuami(const std::shared_ptr<Guami>& value) {
  m_Guami      = value;
  m_GuamiIsSet = true;
}

bool SmContextUpdateData::guamiIsSet() const {
  return m_GuamiIsSet;
}

void SmContextUpdateData::unsetGuami() {
  m_GuamiIsSet = false;
}

std::shared_ptr<PlmnId> SmContextUpdateData::getServingNetwork() const {
  return m_ServingNetwork;
}

void SmContextUpdateData::setServingNetwork(
    const std::shared_ptr<PlmnId>& value) {
  m_ServingNetwork      = value;
  m_ServingNetworkIsSet = true;
}

bool SmContextUpdateData::servingNetworkIsSet() const {
  return m_ServingNetworkIsSet;
}

void SmContextUpdateData::unsetServingNetwork() {
  m_ServingNetworkIsSet = false;
}

std::vector<std::shared_ptr<BackupAmfInfo>>&
SmContextUpdateData::getBackupAmfInfo() {
  return m_BackupAmfInfo;
}

void SmContextUpdateData::setBackupAmfInfo(
    const std::vector<std::shared_ptr<BackupAmfInfo>>& value) {
  m_BackupAmfInfo      = value;
  m_BackupAmfInfoIsSet = true;
}

bool SmContextUpdateData::backupAmfInfoIsSet() const {
  return m_BackupAmfInfoIsSet;
}

void SmContextUpdateData::unsetBackupAmfInfo() {
  m_BackupAmfInfoIsSet = false;
}

std::shared_ptr<AccessType> SmContextUpdateData::getAnType() const {
  return m_AnType;
}

void SmContextUpdateData::setAnType(const std::shared_ptr<AccessType>& value) {
  m_AnType      = value;
  m_AnTypeIsSet = true;
}

bool SmContextUpdateData::anTypeIsSet() const {
  return m_AnTypeIsSet;
}

void SmContextUpdateData::unsetAnType() {
  m_AnTypeIsSet = false;
}

std::shared_ptr<AccessType> SmContextUpdateData::getSecondAnType() const {
  return m_SecondAnType;
}

void SmContextUpdateData::setSecondAnType(
    const std::shared_ptr<AccessType>& value) {
  m_SecondAnType      = value;
  m_SecondAnTypeIsSet = true;
}

bool SmContextUpdateData::secondAnTypeIsSet() const {
  return m_SecondAnTypeIsSet;
}

void SmContextUpdateData::unsetSecondAnType() {
  m_SecondAnTypeIsSet = false;
}

std::shared_ptr<RatType> SmContextUpdateData::getRatType() const {
  return m_RatType;
}

void SmContextUpdateData::setRatType(const std::shared_ptr<RatType>& value) {
  m_RatType      = value;
  m_RatTypeIsSet = true;
}

bool SmContextUpdateData::ratTypeIsSet() const {
  return m_RatTypeIsSet;
}

void SmContextUpdateData::unsetRatType() {
  m_RatTypeIsSet = false;
}

std::shared_ptr<PresenceState> SmContextUpdateData::getPresenceInLadn() const {
  return m_PresenceInLadn;
}

void SmContextUpdateData::setPresenceInLadn(
    const std::shared_ptr<PresenceState>& value) {
  m_PresenceInLadn      = value;
  m_PresenceInLadnIsSet = true;
}

bool SmContextUpdateData::presenceInLadnIsSet() const {
  return m_PresenceInLadnIsSet;
}

void SmContextUpdateData::unsetPresenceInLadn() {
  m_PresenceInLadnIsSet = false;
}

std::shared_ptr<UserLocation> SmContextUpdateData::getUeLocation() const {
  return m_UeLocation;
}

void SmContextUpdateData::setUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_UeLocation      = value;
  m_UeLocationIsSet = true;
}

bool SmContextUpdateData::ueLocationIsSet() const {
  return m_UeLocationIsSet;
}

void SmContextUpdateData::unsetUeLocation() {
  m_UeLocationIsSet = false;
}

utility::string_t SmContextUpdateData::getUeTimeZone() const {
  return m_UeTimeZone;
}

void SmContextUpdateData::setUeTimeZone(const utility::string_t& value) {
  m_UeTimeZone      = value;
  m_UeTimeZoneIsSet = true;
}

bool SmContextUpdateData::ueTimeZoneIsSet() const {
  return m_UeTimeZoneIsSet;
}

void SmContextUpdateData::unsetUeTimeZone() {
  m_UeTimeZoneIsSet = false;
}

std::shared_ptr<UserLocation> SmContextUpdateData::getAddUeLocation() const {
  return m_AddUeLocation;
}

void SmContextUpdateData::setAddUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_AddUeLocation      = value;
  m_AddUeLocationIsSet = true;
}

bool SmContextUpdateData::addUeLocationIsSet() const {
  return m_AddUeLocationIsSet;
}

void SmContextUpdateData::unsetAddUeLocation() {
  m_AddUeLocationIsSet = false;
}

std::shared_ptr<UpCnxState> SmContextUpdateData::getUpCnxState() const {
  return m_UpCnxState;
}

void SmContextUpdateData::setUpCnxState(
    const std::shared_ptr<UpCnxState>& value) {
  m_UpCnxState      = value;
  m_UpCnxStateIsSet = true;
}

bool SmContextUpdateData::upCnxStateIsSet() const {
  return m_UpCnxStateIsSet;
}

void SmContextUpdateData::unsetUpCnxState() {
  m_UpCnxStateIsSet = false;
}

std::shared_ptr<HoState> SmContextUpdateData::getHoState() const {
  return m_HoState;
}

void SmContextUpdateData::setHoState(const std::shared_ptr<HoState>& value) {
  m_HoState      = value;
  m_HoStateIsSet = true;
}

bool SmContextUpdateData::hoStateIsSet() const {
  return m_HoStateIsSet;
}

void SmContextUpdateData::unsetHoState() {
  m_HoStateIsSet = false;
}

bool SmContextUpdateData::isToBeSwitched() const {
  return m_ToBeSwitched;
}

void SmContextUpdateData::setToBeSwitched(bool value) {
  m_ToBeSwitched      = value;
  m_ToBeSwitchedIsSet = true;
}

bool SmContextUpdateData::toBeSwitchedIsSet() const {
  return m_ToBeSwitchedIsSet;
}

void SmContextUpdateData::unsetToBeSwitched() {
  m_ToBeSwitchedIsSet = false;
}

bool SmContextUpdateData::isFailedToBeSwitched() const {
  return m_FailedToBeSwitched;
}

void SmContextUpdateData::setFailedToBeSwitched(bool value) {
  m_FailedToBeSwitched      = value;
  m_FailedToBeSwitchedIsSet = true;
}

bool SmContextUpdateData::failedToBeSwitchedIsSet() const {
  return m_FailedToBeSwitchedIsSet;
}

void SmContextUpdateData::unsetFailedToBeSwitched() {
  m_FailedToBeSwitchedIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextUpdateData::getN1SmMsg() const {
  return m_N1SmMsg;
}

void SmContextUpdateData::setN1SmMsg(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N1SmMsg      = value;
  m_N1SmMsgIsSet = true;
}

bool SmContextUpdateData::n1SmMsgIsSet() const {
  return m_N1SmMsgIsSet;
}

void SmContextUpdateData::unsetN1SmMsg() {
  m_N1SmMsgIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextUpdateData::getN2SmInfo() const {
  return m_N2SmInfo;
}

void SmContextUpdateData::setN2SmInfo(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N2SmInfo      = value;
  m_N2SmInfoIsSet = true;
}

bool SmContextUpdateData::n2SmInfoIsSet() const {
  return m_N2SmInfoIsSet;
}

void SmContextUpdateData::unsetN2SmInfo() {
  m_N2SmInfoIsSet = false;
}

std::shared_ptr<N2SmInfoType> SmContextUpdateData::getN2SmInfoType() const {
  return m_N2SmInfoType;
}

void SmContextUpdateData::setN2SmInfoType(
    const std::shared_ptr<N2SmInfoType>& value) {
  m_N2SmInfoType      = value;
  m_N2SmInfoTypeIsSet = true;
}

bool SmContextUpdateData::n2SmInfoTypeIsSet() const {
  return m_N2SmInfoTypeIsSet;
}

void SmContextUpdateData::unsetN2SmInfoType() {
  m_N2SmInfoTypeIsSet = false;
}

std::shared_ptr<NgRanTargetId> SmContextUpdateData::getTargetId() const {
  return m_TargetId;
}

void SmContextUpdateData::setTargetId(
    const std::shared_ptr<NgRanTargetId>& value) {
  m_TargetId      = value;
  m_TargetIdIsSet = true;
}

bool SmContextUpdateData::targetIdIsSet() const {
  return m_TargetIdIsSet;
}

void SmContextUpdateData::unsetTargetId() {
  m_TargetIdIsSet = false;
}

utility::string_t SmContextUpdateData::getTargetServingNfId() const {
  return m_TargetServingNfId;
}

void SmContextUpdateData::setTargetServingNfId(const utility::string_t& value) {
  m_TargetServingNfId      = value;
  m_TargetServingNfIdIsSet = true;
}

bool SmContextUpdateData::targetServingNfIdIsSet() const {
  return m_TargetServingNfIdIsSet;
}

void SmContextUpdateData::unsetTargetServingNfId() {
  m_TargetServingNfIdIsSet = false;
}

utility::string_t SmContextUpdateData::getSmContextStatusUri() const {
  return m_SmContextStatusUri;
}

void SmContextUpdateData::setSmContextStatusUri(
    const utility::string_t& value) {
  m_SmContextStatusUri      = value;
  m_SmContextStatusUriIsSet = true;
}

bool SmContextUpdateData::smContextStatusUriIsSet() const {
  return m_SmContextStatusUriIsSet;
}

void SmContextUpdateData::unsetSmContextStatusUri() {
  m_SmContextStatusUriIsSet = false;
}

bool SmContextUpdateData::isDataForwarding() const {
  return m_DataForwarding;
}

void SmContextUpdateData::setDataForwarding(bool value) {
  m_DataForwarding      = value;
  m_DataForwardingIsSet = true;
}

bool SmContextUpdateData::dataForwardingIsSet() const {
  return m_DataForwardingIsSet;
}

void SmContextUpdateData::unsetDataForwarding() {
  m_DataForwardingIsSet = false;
}

std::vector<utility::string_t>& SmContextUpdateData::getEpsBearerSetup() {
  return m_EpsBearerSetup;
}

void SmContextUpdateData::setEpsBearerSetup(
    const std::vector<utility::string_t>& value) {
  m_EpsBearerSetup      = value;
  m_EpsBearerSetupIsSet = true;
}

bool SmContextUpdateData::epsBearerSetupIsSet() const {
  return m_EpsBearerSetupIsSet;
}

void SmContextUpdateData::unsetEpsBearerSetup() {
  m_EpsBearerSetupIsSet = false;
}

std::vector<int32_t>& SmContextUpdateData::getRevokeEbiList() {
  return m_RevokeEbiList;
}

void SmContextUpdateData::setRevokeEbiList(std::vector<int32_t> value) {
  m_RevokeEbiList      = value;
  m_RevokeEbiListIsSet = true;
}

bool SmContextUpdateData::revokeEbiListIsSet() const {
  return m_RevokeEbiListIsSet;
}

void SmContextUpdateData::unsetRevokeEbiList() {
  m_RevokeEbiListIsSet = false;
}

bool SmContextUpdateData::isRelease() const {
  return m_Release;
}

void SmContextUpdateData::setRelease(bool value) {
  m_Release      = value;
  m_ReleaseIsSet = true;
}

bool SmContextUpdateData::releaseIsSet() const {
  return m_ReleaseIsSet;
}

void SmContextUpdateData::unsetRelease() {
  m_ReleaseIsSet = false;
}

std::shared_ptr<Cause> SmContextUpdateData::getCause() const {
  return m_Cause;
}

void SmContextUpdateData::setCause(const std::shared_ptr<Cause>& value) {
  m_Cause      = value;
  m_CauseIsSet = true;
}

bool SmContextUpdateData::causeIsSet() const {
  return m_CauseIsSet;
}

void SmContextUpdateData::unsetCause() {
  m_CauseIsSet = false;
}

std::shared_ptr<NgApCause> SmContextUpdateData::getNgApCause() const {
  return m_NgApCause;
}

void SmContextUpdateData::setNgApCause(
    const std::shared_ptr<NgApCause>& value) {
  m_NgApCause      = value;
  m_NgApCauseIsSet = true;
}

bool SmContextUpdateData::ngApCauseIsSet() const {
  return m_NgApCauseIsSet;
}

void SmContextUpdateData::unsetNgApCause() {
  m_NgApCauseIsSet = false;
}

int32_t SmContextUpdateData::get5gMmCauseValue() const {
  return m__5gMmCauseValue;
}

void SmContextUpdateData::set5gMmCauseValue(int32_t value) {
  m__5gMmCauseValue      = value;
  m__5gMmCauseValueIsSet = true;
}

bool SmContextUpdateData::_5gMmCauseValueIsSet() const {
  return m__5gMmCauseValueIsSet;
}

void SmContextUpdateData::unset_5gMmCauseValue() {
  m__5gMmCauseValueIsSet = false;
}

std::shared_ptr<Snssai> SmContextUpdateData::getSNssai() const {
  return m_SNssai;
}

void SmContextUpdateData::setSNssai(const std::shared_ptr<Snssai>& value) {
  m_SNssai      = value;
  m_SNssaiIsSet = true;
}

bool SmContextUpdateData::sNssaiIsSet() const {
  return m_SNssaiIsSet;
}

void SmContextUpdateData::unsetSNssai() {
  m_SNssaiIsSet = false;
}

std::shared_ptr<TraceData> SmContextUpdateData::getTraceData() const {
  return m_TraceData;
}

void SmContextUpdateData::setTraceData(
    const std::shared_ptr<TraceData>& value) {
  m_TraceData      = value;
  m_TraceDataIsSet = true;
}

bool SmContextUpdateData::traceDataIsSet() const {
  return m_TraceDataIsSet;
}

void SmContextUpdateData::unsetTraceData() {
  m_TraceDataIsSet = false;
}

std::shared_ptr<EpsInterworkingIndication>
SmContextUpdateData::getEpsInterworkingInd() const {
  return m_EpsInterworkingInd;
}

void SmContextUpdateData::setEpsInterworkingInd(
    const std::shared_ptr<EpsInterworkingIndication>& value) {
  m_EpsInterworkingInd      = value;
  m_EpsInterworkingIndIsSet = true;
}

bool SmContextUpdateData::epsInterworkingIndIsSet() const {
  return m_EpsInterworkingIndIsSet;
}

void SmContextUpdateData::unsetEpsInterworkingInd() {
  m_EpsInterworkingIndIsSet = false;
}

bool SmContextUpdateData::isAnTypeCanBeChanged() const {
  return m_AnTypeCanBeChanged;
}

void SmContextUpdateData::setAnTypeCanBeChanged(bool value) {
  m_AnTypeCanBeChanged      = value;
  m_AnTypeCanBeChangedIsSet = true;
}

bool SmContextUpdateData::anTypeCanBeChangedIsSet() const {
  return m_AnTypeCanBeChangedIsSet;
}

void SmContextUpdateData::unsetAnTypeCanBeChanged() {
  m_AnTypeCanBeChangedIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextUpdateData::getN2SmInfoExt1() const {
  return m_N2SmInfoExt1;
}

void SmContextUpdateData::setN2SmInfoExt1(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N2SmInfoExt1      = value;
  m_N2SmInfoExt1IsSet = true;
}

bool SmContextUpdateData::n2SmInfoExt1IsSet() const {
  return m_N2SmInfoExt1IsSet;
}

void SmContextUpdateData::unsetN2SmInfoExt1() {
  m_N2SmInfoExt1IsSet = false;
}

std::shared_ptr<N2SmInfoType> SmContextUpdateData::getN2SmInfoTypeExt1() const {
  return m_N2SmInfoTypeExt1;
}

void SmContextUpdateData::setN2SmInfoTypeExt1(
    const std::shared_ptr<N2SmInfoType>& value) {
  m_N2SmInfoTypeExt1      = value;
  m_N2SmInfoTypeExt1IsSet = true;
}

bool SmContextUpdateData::n2SmInfoTypeExt1IsSet() const {
  return m_N2SmInfoTypeExt1IsSet;
}

void SmContextUpdateData::unsetN2SmInfoTypeExt1() {
  m_N2SmInfoTypeExt1IsSet = false;
}

std::shared_ptr<MaReleaseIndication> SmContextUpdateData::getMaReleaseInd()
    const {
  return m_MaReleaseInd;
}

void SmContextUpdateData::setMaReleaseInd(
    const std::shared_ptr<MaReleaseIndication>& value) {
  m_MaReleaseInd      = value;
  m_MaReleaseIndIsSet = true;
}

bool SmContextUpdateData::maReleaseIndIsSet() const {
  return m_MaReleaseIndIsSet;
}

void SmContextUpdateData::unsetMaReleaseInd() {
  m_MaReleaseIndIsSet = false;
}

std::shared_ptr<ExemptionInd> SmContextUpdateData::getExemptionInd() const {
  return m_ExemptionInd;
}

void SmContextUpdateData::setExemptionInd(
    const std::shared_ptr<ExemptionInd>& value) {
  m_ExemptionInd      = value;
  m_ExemptionIndIsSet = true;
}

bool SmContextUpdateData::exemptionIndIsSet() const {
  return m_ExemptionIndIsSet;
}

void SmContextUpdateData::unsetExemptionInd() {
  m_ExemptionIndIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
