/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "VolumeTimedReport.h"

namespace oai {
namespace smf {
namespace model {

VolumeTimedReport::VolumeTimedReport() {
  m_StartTimeStamp = utility::datetime();
  m_EndTimeStamp   = utility::datetime();
  m_DownlinkVolume = 0L;
  m_UplinkVolume   = 0L;
}

VolumeTimedReport::~VolumeTimedReport() {}

void VolumeTimedReport::validate() {
  // TODO: implement validation
}

web::json::value VolumeTimedReport::toJson() const {
  web::json::value val = web::json::value::object();

  val[utility::conversions::to_string_t("startTimeStamp")] =
      ModelBase::toJson(m_StartTimeStamp);
  val[utility::conversions::to_string_t("endTimeStamp")] =
      ModelBase::toJson(m_EndTimeStamp);
  val[utility::conversions::to_string_t("downlinkVolume")] =
      ModelBase::toJson(m_DownlinkVolume);
  val[utility::conversions::to_string_t("uplinkVolume")] =
      ModelBase::toJson(m_UplinkVolume);

  return val;
}

void VolumeTimedReport::fromJson(const web::json::value& val) {
  setStartTimeStamp(ModelBase::dateFromJson(
      val.at(utility::conversions::to_string_t("startTimeStamp"))));
  setEndTimeStamp(ModelBase::dateFromJson(
      val.at(utility::conversions::to_string_t("endTimeStamp"))));
  setDownlinkVolume(ModelBase::int64_tFromJson(
      val.at(utility::conversions::to_string_t("downlinkVolume"))));
  setUplinkVolume(ModelBase::int64_tFromJson(
      val.at(utility::conversions::to_string_t("uplinkVolume"))));
}

void VolumeTimedReport::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("startTimeStamp"),
      m_StartTimeStamp));
  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("endTimeStamp"),
      m_EndTimeStamp));
  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("downlinkVolume"),
      m_DownlinkVolume));
  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("uplinkVolume"),
      m_UplinkVolume));
}

void VolumeTimedReport::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  setStartTimeStamp(ModelBase::dateFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("startTimeStamp"))));
  setEndTimeStamp(ModelBase::dateFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("endTimeStamp"))));
  setDownlinkVolume(ModelBase::int64_tFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("downlinkVolume"))));
  setUplinkVolume(ModelBase::int64_tFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("uplinkVolume"))));
}

utility::datetime VolumeTimedReport::getStartTimeStamp() const {
  return m_StartTimeStamp;
}

void VolumeTimedReport::setStartTimeStamp(const utility::datetime& value) {
  m_StartTimeStamp = value;
}

utility::datetime VolumeTimedReport::getEndTimeStamp() const {
  return m_EndTimeStamp;
}

void VolumeTimedReport::setEndTimeStamp(const utility::datetime& value) {
  m_EndTimeStamp = value;
}

int64_t VolumeTimedReport::getDownlinkVolume() const {
  return m_DownlinkVolume;
}

void VolumeTimedReport::setDownlinkVolume(int64_t value) {
  m_DownlinkVolume = value;
}

int64_t VolumeTimedReport::getUplinkVolume() const {
  return m_UplinkVolume;
}

void VolumeTimedReport::setUplinkVolume(int64_t value) {
  m_UplinkVolume = value;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
