/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "AmfCreateEventSubscription.h"
#include "Helpers.h"

#include <sstream>

namespace oai::amf::model {

AmfCreateEventSubscription::AmfCreateEventSubscription() {
  m_SupportedFeatures      = "";
  m_SupportedFeaturesIsSet = false;
  m_OldGuamiIsSet          = false;
}

void AmfCreateEventSubscription::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool AmfCreateEventSubscription::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool AmfCreateEventSubscription::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success = true;
  const std::string _pathPrefix =
      pathPrefix.empty() ? "AmfCreateEventSubscription" : pathPrefix;

  if (supportedFeaturesIsSet()) {
    const std::string& value           = m_SupportedFeatures;
    const std::string currentValuePath = _pathPrefix + ".supportedFeatures";
  }

  return success;
}

bool AmfCreateEventSubscription::operator==(
    const AmfCreateEventSubscription& rhs) const {
  return

      (getSubscription() == rhs.getSubscription()) &&

      ((!supportedFeaturesIsSet() && !rhs.supportedFeaturesIsSet()) ||
       (supportedFeaturesIsSet() && rhs.supportedFeaturesIsSet() &&
        getSupportedFeatures() == rhs.getSupportedFeatures())) &&

      ((!oldGuamiIsSet() && !rhs.oldGuamiIsSet()) ||
       (oldGuamiIsSet() && rhs.oldGuamiIsSet() &&
        getOldGuami() == rhs.getOldGuami()))

          ;
}

bool AmfCreateEventSubscription::operator!=(
    const AmfCreateEventSubscription& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const AmfCreateEventSubscription& o) {
  j                 = nlohmann::json();
  j["subscription"] = o.m_Subscription;
  if (o.supportedFeaturesIsSet())
    j["supportedFeatures"] = o.m_SupportedFeatures;
  if (o.oldGuamiIsSet()) j["oldGuami"] = o.m_OldGuami;
}

void from_json(const nlohmann::json& j, AmfCreateEventSubscription& o) {
  j.at("subscription").get_to(o.m_Subscription);
  if (j.find("supportedFeatures") != j.end()) {
    j.at("supportedFeatures").get_to(o.m_SupportedFeatures);
    o.m_SupportedFeaturesIsSet = true;
  }
  if (j.find("oldGuami") != j.end()) {
    j.at("oldGuami").get_to(o.m_OldGuami);
    o.m_OldGuamiIsSet = true;
  }
}

AmfEventSubscription AmfCreateEventSubscription::getSubscription() const {
  return m_Subscription;
}
void AmfCreateEventSubscription::setSubscription(
    AmfEventSubscription const& value) {
  m_Subscription = value;
}
std::string AmfCreateEventSubscription::getSupportedFeatures() const {
  return m_SupportedFeatures;
}
void AmfCreateEventSubscription::setSupportedFeatures(
    std::string const& value) {
  m_SupportedFeatures      = value;
  m_SupportedFeaturesIsSet = true;
}
bool AmfCreateEventSubscription::supportedFeaturesIsSet() const {
  return m_SupportedFeaturesIsSet;
}
void AmfCreateEventSubscription::unsetSupportedFeatures() {
  m_SupportedFeaturesIsSet = false;
}
Guami AmfCreateEventSubscription::getOldGuami() const {
  return m_OldGuami;
}
void AmfCreateEventSubscription::setOldGuami(Guami const& value) {
  m_OldGuami      = value;
  m_OldGuamiIsSet = true;
}
bool AmfCreateEventSubscription::oldGuamiIsSet() const {
  return m_OldGuamiIsSet;
}
void AmfCreateEventSubscription::unsetOldGuami() {
  m_OldGuamiIsSet = false;
}

}  // namespace oai::amf::model
