/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "LadnInfo.h"
#include "Helpers.h"

#include <sstream>

namespace oai::amf::model {

LadnInfo::LadnInfo() {
  m_Ladn          = "";
  m_PresenceIsSet = false;
}

void LadnInfo::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool LadnInfo::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool LadnInfo::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success                  = true;
  const std::string _pathPrefix = pathPrefix.empty() ? "LadnInfo" : pathPrefix;

  return success;
}

bool LadnInfo::operator==(const LadnInfo& rhs) const {
  return

      (getLadn() == rhs.getLadn()) &&

      ((!presenceIsSet() && !rhs.presenceIsSet()) ||
       (presenceIsSet() && rhs.presenceIsSet() &&
        getPresence() == rhs.getPresence()))

          ;
}

bool LadnInfo::operator!=(const LadnInfo& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const LadnInfo& o) {
  j         = nlohmann::json();
  j["ladn"] = o.m_Ladn;
  if (o.presenceIsSet()) j["presence"] = o.m_Presence;
}

void from_json(const nlohmann::json& j, LadnInfo& o) {
  j.at("ladn").get_to(o.m_Ladn);
  if (j.find("presence") != j.end()) {
    j.at("presence").get_to(o.m_Presence);
    o.m_PresenceIsSet = true;
  }
}

std::string LadnInfo::getLadn() const {
  return m_Ladn;
}
void LadnInfo::setLadn(std::string const& value) {
  m_Ladn = value;
}
PresenceState LadnInfo::getPresence() const {
  return m_Presence;
}
void LadnInfo::setPresence(PresenceState const& value) {
  m_Presence      = value;
  m_PresenceIsSet = true;
}
bool LadnInfo::presenceIsSet() const {
  return m_PresenceIsSet;
}
void LadnInfo::unsetPresence() {
  m_PresenceIsSet = false;
}

}  // namespace oai::amf::model
