/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/*! \file conversions.hpp
  \brief
  \author Sebastien ROUX, Lionel Gauthier
  \company Eurecom
  \email: lionel.gauthier@eurecom.fr
*/

#ifndef FILE_CONVERSIONS_HPP_SEEN
#define FILE_CONVERSIONS_HPP_SEEN
#include <stdint.h>
#include <string>
#include <netinet/in.h>


/* Used to format an uint32_t containing an ipv4 address */
#define IN_ADDR_FMT    "%u.%u.%u.%u"
#define PRI_IN_ADDR(aDDRESS)               \
    (uint8_t)((aDDRESS.s_addr)  & 0x000000ff),         \
    (uint8_t)(((aDDRESS.s_addr) & 0x0000ff00) >> 8 ),  \
    (uint8_t)(((aDDRESS.s_addr) & 0x00ff0000) >> 16),  \
    (uint8_t)(((aDDRESS.s_addr) & 0xff000000) >> 24)

#define IPV4_ADDR_DISPLAY_8(aDDRESS)            \
    (aDDRESS)[0], (aDDRESS)[1], (aDDRESS)[2], (aDDRESS)[3]


class conv {
  public:
    static void hexa_to_ascii(uint8_t *from, char *to, size_t length);
    static int ascii_to_hex(uint8_t *dst, const char *h);
    static struct in_addr fromString(const std::string addr4);
    static std::string toString(const struct in_addr& inaddr);
    static std::string toString(const struct in6_addr& in6addr);
    static std::string mccToString(const uint8_t digit1, const uint8_t digit2, const uint8_t digit3);
    static std::string mncToString(const uint8_t digit1, const uint8_t digit2, const uint8_t digit3);
};
#endif /* FILE_CONVERSIONS_HPP_SEEN */
