/**
* Namf_Communication
* AMF Communication Service © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
*
* The version of the OpenAPI document: 1.1.0.alpha-1
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/

#include "IndividualUeContextDocumentApi.h"
#include "Helpers.h"

namespace oai {
namespace amf {
namespace api {

using namespace org::openapitools::server::helpers;
using namespace oai::amf::model;

IndividualUeContextDocumentApi::IndividualUeContextDocumentApi(std::shared_ptr<Pistache::Rest::Router> rtr) { 
    router = rtr;
}

void IndividualUeContextDocumentApi::init() {
    setupRoutes();
}

void IndividualUeContextDocumentApi::setupRoutes() {
    using namespace Pistache::Rest;

    Routes::Put(*router, base + "/ue-contexts/:ueContextId", Routes::bind(&IndividualUeContextDocumentApi::create_ue_context_handler, this));
    Routes::Post(*router, base + "/ue-contexts/:ueContextId/assign-ebi", Routes::bind(&IndividualUeContextDocumentApi::e_bi_assignment_handler, this));
    Routes::Post(*router, base + "/ue-contexts/:ueContextId/transfer-update", Routes::bind(&IndividualUeContextDocumentApi::registration_status_update_handler, this));
    Routes::Post(*router, base + "/ue-contexts/:ueContextId/release", Routes::bind(&IndividualUeContextDocumentApi::release_ue_context_handler, this));
    Routes::Post(*router, base + "/ue-contexts/:ueContextId/transfer", Routes::bind(&IndividualUeContextDocumentApi::u_e_context_transfer_handler, this));

    // Default handler, called when a route is not found
    router->addCustomHandler(Routes::bind(&IndividualUeContextDocumentApi::individual_ue_context_document_api_default_handler, this));
}

void IndividualUeContextDocumentApi::create_ue_context_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response) {
    // Getting the path params
    auto ueContextId = request.param(":ueContextId").as<std::string>();
    
    // Getting the body param
    
    Inline_object inlineObject;
    
    try {
      nlohmann::json::parse(request.body()).get_to(inlineObject);
      this->create_ue_context(ueContextId, inlineObject, response);
    } catch (nlohmann::detail::exception &e) {
        //send a 400 error
        response.send(Pistache::Http::Code::Bad_Request, e.what());
        return;
    } catch (std::exception &e) {
        //send a 500 error
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
        return;
    }

}
void IndividualUeContextDocumentApi::e_bi_assignment_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response) {
    // Getting the path params
    auto ueContextId = request.param(":ueContextId").as<std::string>();
    
    // Getting the body param
    
    AssignEbiData assignEbiData;
    
    try {
      nlohmann::json::parse(request.body()).get_to(assignEbiData);
      this->e_bi_assignment(ueContextId, assignEbiData, response);
    } catch (nlohmann::detail::exception &e) {
        //send a 400 error
        response.send(Pistache::Http::Code::Bad_Request, e.what());
        return;
    } catch (std::exception &e) {
        //send a 500 error
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
        return;
    }

}
void IndividualUeContextDocumentApi::registration_status_update_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response) {
    // Getting the path params
    auto ueContextId = request.param(":ueContextId").as<std::string>();
    
    // Getting the body param
    
    UeRegStatusUpdateReqData ueRegStatusUpdateReqData;
    
    try {
      nlohmann::json::parse(request.body()).get_to(ueRegStatusUpdateReqData);
      this->registration_status_update(ueContextId, ueRegStatusUpdateReqData, response);
    } catch (nlohmann::detail::exception &e) {
        //send a 400 error
        response.send(Pistache::Http::Code::Bad_Request, e.what());
        return;
    } catch (std::exception &e) {
        //send a 500 error
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
        return;
    }

}
void IndividualUeContextDocumentApi::release_ue_context_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response) {
    // Getting the path params
    auto ueContextId = request.param(":ueContextId").as<std::string>();
    
    // Getting the body param
    
    UEContextRelease uEContextRelease;
    
    try {
      nlohmann::json::parse(request.body()).get_to(uEContextRelease);
      this->release_ue_context(ueContextId, uEContextRelease, response);
    } catch (nlohmann::detail::exception &e) {
        //send a 400 error
        response.send(Pistache::Http::Code::Bad_Request, e.what());
        return;
    } catch (std::exception &e) {
        //send a 500 error
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
        return;
    }

}
void IndividualUeContextDocumentApi::u_e_context_transfer_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response) {
    // Getting the path params
    auto ueContextId = request.param(":ueContextId").as<std::string>();
    
    // Getting the body param
    
    UeContextTransferReqData ueContextTransferReqData;
    
    try {
      nlohmann::json::parse(request.body()).get_to(ueContextTransferReqData);
      this->u_e_context_transfer(ueContextId, ueContextTransferReqData, response);
    } catch (nlohmann::detail::exception &e) {
        //send a 400 error
        response.send(Pistache::Http::Code::Bad_Request, e.what());
        return;
    } catch (std::exception &e) {
        //send a 500 error
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
        return;
    }

}

void IndividualUeContextDocumentApi::individual_ue_context_document_api_default_handler(const Pistache::Rest::Request &, Pistache::Http::ResponseWriter response) {
    response.send(Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

}
}
}

