/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */



#include "PduSessionCreatedData.h"

namespace oai {
namespace smf {
namespace model {




PduSessionCreatedData::PduSessionCreatedData()
{
    m_SscMode = utility::conversions::to_string_t("");
    m_HcnTunnelInfoIsSet = false;
    m_SessionAmbrIsSet = false;
    m_QosFlowsSetupListIsSet = false;
    m_HSmfInstanceId = utility::conversions::to_string_t("");
    m_PduSessionId = 0;
    m_PduSessionIdIsSet = false;
    m_SNssaiIsSet = false;
    m_EnablePauseCharging = false;
    m_EnablePauseChargingIsSet = false;
    m_UeIpv4Address = utility::conversions::to_string_t("");
    m_UeIpv4AddressIsSet = false;
    m_UeIpv6PrefixIsSet = false;
    m_N1SmInfoToUeIsSet = false;
    m_EpsPdnCnxInfoIsSet = false;
    m_EpsBearerInfoIsSet = false;
    m_SupportedFeatures = utility::conversions::to_string_t("");
    m_SupportedFeaturesIsSet = false;
    m_MaxIntegrityProtectedDataRateIsSet = false;
    m_AlwaysOnGranted = false;
    m_AlwaysOnGrantedIsSet = false;
    m_Gpsi = utility::conversions::to_string_t("");
    m_GpsiIsSet = false;
    m_UpSecurityIsSet = false;
    m_RoamingChargingProfileIsSet = false;
    m_HSmfServiceInstanceId = utility::conversions::to_string_t("");
    m_HSmfServiceInstanceIdIsSet = false;
    m_RecoveryTime = utility::datetime();
    m_RecoveryTimeIsSet = false;
}

PduSessionCreatedData::~PduSessionCreatedData()
{
}

void PduSessionCreatedData::validate()
{
    // TODO: implement validation
}

web::json::value PduSessionCreatedData::toJson() const
{
    web::json::value val = web::json::value::object();

    val[utility::conversions::to_string_t("pduSessionType")] = ModelBase::toJson(m_PduSessionType);
    val[utility::conversions::to_string_t("sscMode")] = ModelBase::toJson(m_SscMode);
    if(m_HcnTunnelInfoIsSet)
    {
        val[utility::conversions::to_string_t("hcnTunnelInfo")] = ModelBase::toJson(m_HcnTunnelInfo);
    }
    if(m_SessionAmbrIsSet)
    {
        val[utility::conversions::to_string_t("sessionAmbr")] = ModelBase::toJson(m_SessionAmbr);
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_QosFlowsSetupList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("qosFlowsSetupList")] = web::json::value::array(jsonArray);
        }
    }
    val[utility::conversions::to_string_t("hSmfInstanceId")] = ModelBase::toJson(m_HSmfInstanceId);
    if(m_PduSessionIdIsSet)
    {
        val[utility::conversions::to_string_t("pduSessionId")] = ModelBase::toJson(m_PduSessionId);
    }
    if(m_SNssaiIsSet)
    {
        val[utility::conversions::to_string_t("sNssai")] = ModelBase::toJson(m_SNssai);
    }
    if(m_EnablePauseChargingIsSet)
    {
        val[utility::conversions::to_string_t("enablePauseCharging")] = ModelBase::toJson(m_EnablePauseCharging);
    }
    if(m_UeIpv4AddressIsSet)
    {
        val[utility::conversions::to_string_t("ueIpv4Address")] = ModelBase::toJson(m_UeIpv4Address);
    }
    if(m_UeIpv6PrefixIsSet)
    {
        val[utility::conversions::to_string_t("ueIpv6Prefix")] = ModelBase::toJson(m_UeIpv6Prefix);
    }
    if(m_N1SmInfoToUeIsSet)
    {
        val[utility::conversions::to_string_t("n1SmInfoToUe")] = ModelBase::toJson(m_N1SmInfoToUe);
    }
    if(m_EpsPdnCnxInfoIsSet)
    {
        val[utility::conversions::to_string_t("epsPdnCnxInfo")] = ModelBase::toJson(m_EpsPdnCnxInfo);
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_EpsBearerInfo )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("epsBearerInfo")] = web::json::value::array(jsonArray);
        }
    }
    if(m_SupportedFeaturesIsSet)
    {
        val[utility::conversions::to_string_t("supportedFeatures")] = ModelBase::toJson(m_SupportedFeatures);
    }
    if(m_MaxIntegrityProtectedDataRateIsSet)
    {
        val[utility::conversions::to_string_t("maxIntegrityProtectedDataRate")] = ModelBase::toJson(m_MaxIntegrityProtectedDataRate);
    }
    if(m_AlwaysOnGrantedIsSet)
    {
        val[utility::conversions::to_string_t("alwaysOnGranted")] = ModelBase::toJson(m_AlwaysOnGranted);
    }
    if(m_GpsiIsSet)
    {
        val[utility::conversions::to_string_t("gpsi")] = ModelBase::toJson(m_Gpsi);
    }
    if(m_UpSecurityIsSet)
    {
        val[utility::conversions::to_string_t("upSecurity")] = ModelBase::toJson(m_UpSecurity);
    }
    if(m_RoamingChargingProfileIsSet)
    {
        val[utility::conversions::to_string_t("roamingChargingProfile")] = ModelBase::toJson(m_RoamingChargingProfile);
    }
    if(m_HSmfServiceInstanceIdIsSet)
    {
        val[utility::conversions::to_string_t("hSmfServiceInstanceId")] = ModelBase::toJson(m_HSmfServiceInstanceId);
    }
    if(m_RecoveryTimeIsSet)
    {
        val[utility::conversions::to_string_t("recoveryTime")] = ModelBase::toJson(m_RecoveryTime);
    }

    return val;
}

void PduSessionCreatedData::fromJson(const web::json::value& val)
{
    std::shared_ptr<PduSessionType> newPduSessionType(new PduSessionType());
    newPduSessionType->fromJson(val.at(utility::conversions::to_string_t("pduSessionType")));
    setPduSessionType( newPduSessionType );
    setSscMode(ModelBase::stringFromJson(val.at(utility::conversions::to_string_t("sscMode"))));
    if(val.has_field(utility::conversions::to_string_t("hcnTunnelInfo")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("hcnTunnelInfo"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<TunnelInfo> newItem(new TunnelInfo());
            newItem->fromJson(fieldValue);
            setHcnTunnelInfo( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("sessionAmbr")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("sessionAmbr"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<Ambr> newItem(new Ambr());
            newItem->fromJson(fieldValue);
            setSessionAmbr( newItem );
        }
    }
    {
        m_QosFlowsSetupList.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("qosFlowsSetupList")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("qosFlowsSetupList")).as_array() )
        {
            if(item.is_null())
            {
                m_QosFlowsSetupList.push_back( std::shared_ptr<QosFlowSetupItem>(nullptr) );
            }
            else
            {
                std::shared_ptr<QosFlowSetupItem> newItem(new QosFlowSetupItem());
                newItem->fromJson(item);
                m_QosFlowsSetupList.push_back( newItem );
            }
        }
        }
    }
    setHSmfInstanceId(ModelBase::stringFromJson(val.at(utility::conversions::to_string_t("hSmfInstanceId"))));
    if(val.has_field(utility::conversions::to_string_t("pduSessionId")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("pduSessionId"));
        if(!fieldValue.is_null())
        {
            setPduSessionId(ModelBase::int32_tFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("sNssai")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("sNssai"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<Snssai> newItem(new Snssai());
            newItem->fromJson(fieldValue);
            setSNssai( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("enablePauseCharging")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("enablePauseCharging"));
        if(!fieldValue.is_null())
        {
            setEnablePauseCharging(ModelBase::boolFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("ueIpv4Address")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("ueIpv4Address"));
        if(!fieldValue.is_null())
        {
            setUeIpv4Address(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("ueIpv6Prefix")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("ueIpv6Prefix"));
        if(!fieldValue.is_null())
        {
            //std::shared_ptr<utility::string_t> newItem(new Ipv6Prefix());
            //newItem->fromJson(fieldValue);
            setUeIpv6Prefix( ModelBase::stringFromJson(fieldValue) );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n1SmInfoToUe")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n1SmInfoToUe"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromJson(fieldValue);
            setN1SmInfoToUe( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("epsPdnCnxInfo")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("epsPdnCnxInfo"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<EpsPdnCnxInfo> newItem(new EpsPdnCnxInfo());
            newItem->fromJson(fieldValue);
            setEpsPdnCnxInfo( newItem );
        }
    }
    {
        m_EpsBearerInfo.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("epsBearerInfo")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("epsBearerInfo")).as_array() )
        {
            if(item.is_null())
            {
                m_EpsBearerInfo.push_back( std::shared_ptr<EpsBearerInfo>(nullptr) );
            }
            else
            {
                std::shared_ptr<EpsBearerInfo> newItem(new EpsBearerInfo());
                newItem->fromJson(item);
                m_EpsBearerInfo.push_back( newItem );
            }
        }
        }
    }
    if(val.has_field(utility::conversions::to_string_t("supportedFeatures")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("supportedFeatures"));
        if(!fieldValue.is_null())
        {
            setSupportedFeatures(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("maxIntegrityProtectedDataRate")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("maxIntegrityProtectedDataRate"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<MaxIntegrityProtectedDataRate> newItem(new MaxIntegrityProtectedDataRate());
            newItem->fromJson(fieldValue);
            setMaxIntegrityProtectedDataRate( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("alwaysOnGranted")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("alwaysOnGranted"));
        if(!fieldValue.is_null())
        {
            setAlwaysOnGranted(ModelBase::boolFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("gpsi")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("gpsi"));
        if(!fieldValue.is_null())
        {
            setGpsi(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("upSecurity")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("upSecurity"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<UpSecurity> newItem(new UpSecurity());
            newItem->fromJson(fieldValue);
            setUpSecurity( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("roamingChargingProfile")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("roamingChargingProfile"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<RoamingChargingProfile> newItem(new RoamingChargingProfile());
            newItem->fromJson(fieldValue);
            setRoamingChargingProfile( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("hSmfServiceInstanceId")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("hSmfServiceInstanceId"));
        if(!fieldValue.is_null())
        {
            setHSmfServiceInstanceId(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("recoveryTime")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("recoveryTime"));
        if(!fieldValue.is_null())
        {
            setRecoveryTime(ModelBase::dateFromJson(fieldValue));
        }
    }
}

void PduSessionCreatedData::toMultipart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix) const
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    m_PduSessionType->toMultipart(multipart, utility::conversions::to_string_t("pduSessionType."));
    multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("sscMode"), m_SscMode));
    if(m_HcnTunnelInfoIsSet)
    {
        if (m_HcnTunnelInfo.get())
        {
            m_HcnTunnelInfo->toMultipart(multipart, utility::conversions::to_string_t("hcnTunnelInfo."));
        }
    }
    if(m_SessionAmbrIsSet)
    {
        if (m_SessionAmbr.get())
        {
            m_SessionAmbr->toMultipart(multipart, utility::conversions::to_string_t("sessionAmbr."));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_QosFlowsSetupList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("qosFlowsSetupList"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("hSmfInstanceId"), m_HSmfInstanceId));
    if(m_PduSessionIdIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("pduSessionId"), m_PduSessionId));
    }
    if(m_SNssaiIsSet)
    {
        if (m_SNssai.get())
        {
            m_SNssai->toMultipart(multipart, utility::conversions::to_string_t("sNssai."));
        }
    }
    if(m_EnablePauseChargingIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("enablePauseCharging"), m_EnablePauseCharging));
    }
    if(m_UeIpv4AddressIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("ueIpv4Address"), m_UeIpv4Address));
    }
    if(m_UeIpv6PrefixIsSet)
    {
        //if (m_UeIpv6Prefix.get())
       // {
           // m_UeIpv6Prefix->toMultipart(multipart, utility::conversions::to_string_t("ueIpv6Prefix."));
           multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("ueIpv6Prefix"), m_UeIpv6Prefix));
        //}
    }
    if(m_N1SmInfoToUeIsSet)
    {
        if (m_N1SmInfoToUe.get())
        {
            m_N1SmInfoToUe->toMultipart(multipart, utility::conversions::to_string_t("n1SmInfoToUe."));
        }
    }
    if(m_EpsPdnCnxInfoIsSet)
    {
        if (m_EpsPdnCnxInfo.get())
        {
            m_EpsPdnCnxInfo->toMultipart(multipart, utility::conversions::to_string_t("epsPdnCnxInfo."));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_EpsBearerInfo )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("epsBearerInfo"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    if(m_SupportedFeaturesIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("supportedFeatures"), m_SupportedFeatures));
    }
    if(m_MaxIntegrityProtectedDataRateIsSet)
    {
        if (m_MaxIntegrityProtectedDataRate.get())
        {
            m_MaxIntegrityProtectedDataRate->toMultipart(multipart, utility::conversions::to_string_t("maxIntegrityProtectedDataRate."));
        }
    }
    if(m_AlwaysOnGrantedIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("alwaysOnGranted"), m_AlwaysOnGranted));
    }
    if(m_GpsiIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("gpsi"), m_Gpsi));
    }
    if(m_UpSecurityIsSet)
    {
        if (m_UpSecurity.get())
        {
            m_UpSecurity->toMultipart(multipart, utility::conversions::to_string_t("upSecurity."));
        }
    }
    if(m_RoamingChargingProfileIsSet)
    {
        if (m_RoamingChargingProfile.get())
        {
            m_RoamingChargingProfile->toMultipart(multipart, utility::conversions::to_string_t("roamingChargingProfile."));
        }
    }
    if(m_HSmfServiceInstanceIdIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("hSmfServiceInstanceId"), m_HSmfServiceInstanceId));
    }
    if(m_RecoveryTimeIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("recoveryTime"), m_RecoveryTime));
    }
}

void PduSessionCreatedData::fromMultiPart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix)
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    std::shared_ptr<PduSessionType> newPduSessionType(new PduSessionType());
    newPduSessionType->fromMultiPart(multipart, utility::conversions::to_string_t("pduSessionType."));
    setPduSessionType( newPduSessionType );
    setSscMode(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("sscMode"))));
    if(multipart->hasContent(utility::conversions::to_string_t("hcnTunnelInfo")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("hcnTunnelInfo")))
        {
            std::shared_ptr<TunnelInfo> newItem(new TunnelInfo());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("hcnTunnelInfo."));
            setHcnTunnelInfo( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("sessionAmbr")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("sessionAmbr")))
        {
            std::shared_ptr<Ambr> newItem(new Ambr());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("sessionAmbr."));
            setSessionAmbr( newItem );
        }
    }
    {
        m_QosFlowsSetupList.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("qosFlowsSetupList")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("qosFlowsSetupList"))));
        for( auto& item : jsonArray.as_array() )
        {
            if(item.is_null())
            {
                m_QosFlowsSetupList.push_back( std::shared_ptr<QosFlowSetupItem>(nullptr) );
            }
            else
            {
                std::shared_ptr<QosFlowSetupItem> newItem(new QosFlowSetupItem());
                newItem->fromJson(item);
                m_QosFlowsSetupList.push_back( newItem );
            }
        }
        }
    }
    setHSmfInstanceId(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("hSmfInstanceId"))));
    if(multipart->hasContent(utility::conversions::to_string_t("pduSessionId")))
    {
        setPduSessionId(ModelBase::int32_tFromHttpContent(multipart->getContent(utility::conversions::to_string_t("pduSessionId"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("sNssai")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("sNssai")))
        {
            std::shared_ptr<Snssai> newItem(new Snssai());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("sNssai."));
            setSNssai( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("enablePauseCharging")))
    {
        setEnablePauseCharging(ModelBase::boolFromHttpContent(multipart->getContent(utility::conversions::to_string_t("enablePauseCharging"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("ueIpv4Address")))
    {
        setUeIpv4Address(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("ueIpv4Address"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("ueIpv6Prefix")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("ueIpv6Prefix")))
        {
           // std::shared_ptr<utility::string_t> newItem(new Ipv6Prefix());
           // newItem->fromMultiPart(multipart, utility::conversions::to_string_t("ueIpv6Prefix."));
            setUeIpv6Prefix( ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("ueIpv6Prefix"))));
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n1SmInfoToUe")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("n1SmInfoToUe")))
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("n1SmInfoToUe."));
            setN1SmInfoToUe( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("epsPdnCnxInfo")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("epsPdnCnxInfo")))
        {
            std::shared_ptr<EpsPdnCnxInfo> newItem(new EpsPdnCnxInfo());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("epsPdnCnxInfo."));
            setEpsPdnCnxInfo( newItem );
        }
    }
    {
        m_EpsBearerInfo.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("epsBearerInfo")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("epsBearerInfo"))));
        for( auto& item : jsonArray.as_array() )
        {
            if(item.is_null())
            {
                m_EpsBearerInfo.push_back( std::shared_ptr<EpsBearerInfo>(nullptr) );
            }
            else
            {
                std::shared_ptr<EpsBearerInfo> newItem(new EpsBearerInfo());
                newItem->fromJson(item);
                m_EpsBearerInfo.push_back( newItem );
            }
        }
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("supportedFeatures")))
    {
        setSupportedFeatures(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("supportedFeatures"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("maxIntegrityProtectedDataRate")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("maxIntegrityProtectedDataRate")))
        {
            std::shared_ptr<MaxIntegrityProtectedDataRate> newItem(new MaxIntegrityProtectedDataRate());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("maxIntegrityProtectedDataRate."));
            setMaxIntegrityProtectedDataRate( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("alwaysOnGranted")))
    {
        setAlwaysOnGranted(ModelBase::boolFromHttpContent(multipart->getContent(utility::conversions::to_string_t("alwaysOnGranted"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("gpsi")))
    {
        setGpsi(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("gpsi"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("upSecurity")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("upSecurity")))
        {
            std::shared_ptr<UpSecurity> newItem(new UpSecurity());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("upSecurity."));
            setUpSecurity( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("roamingChargingProfile")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("roamingChargingProfile")))
        {
            std::shared_ptr<RoamingChargingProfile> newItem(new RoamingChargingProfile());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("roamingChargingProfile."));
            setRoamingChargingProfile( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("hSmfServiceInstanceId")))
    {
        setHSmfServiceInstanceId(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("hSmfServiceInstanceId"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("recoveryTime")))
    {
        setRecoveryTime(ModelBase::dateFromHttpContent(multipart->getContent(utility::conversions::to_string_t("recoveryTime"))));
    }
}

std::shared_ptr<PduSessionType> PduSessionCreatedData::getPduSessionType() const
{
    return m_PduSessionType;
}

void PduSessionCreatedData::setPduSessionType(const std::shared_ptr<PduSessionType>& value)
{
    m_PduSessionType = value;
    
}

utility::string_t PduSessionCreatedData::getSscMode() const
{
    return m_SscMode;
}

void PduSessionCreatedData::setSscMode(const utility::string_t& value)
{
    m_SscMode = value;
    
}

std::shared_ptr<TunnelInfo> PduSessionCreatedData::getHcnTunnelInfo() const
{
    return m_HcnTunnelInfo;
}

void PduSessionCreatedData::setHcnTunnelInfo(const std::shared_ptr<TunnelInfo>& value)
{
    m_HcnTunnelInfo = value;
    m_HcnTunnelInfoIsSet = true;
}

bool PduSessionCreatedData::hcnTunnelInfoIsSet() const
{
    return m_HcnTunnelInfoIsSet;
}

void PduSessionCreatedData::unsetHcnTunnelInfo()
{
    m_HcnTunnelInfoIsSet = false;
}

std::shared_ptr<Ambr> PduSessionCreatedData::getSessionAmbr() const
{
    return m_SessionAmbr;
}

void PduSessionCreatedData::setSessionAmbr(const std::shared_ptr<Ambr>& value)
{
    m_SessionAmbr = value;
    m_SessionAmbrIsSet = true;
}

bool PduSessionCreatedData::sessionAmbrIsSet() const
{
    return m_SessionAmbrIsSet;
}

void PduSessionCreatedData::unsetSessionAmbr()
{
    m_SessionAmbrIsSet = false;
}

std::vector<std::shared_ptr<QosFlowSetupItem>>& PduSessionCreatedData::getQosFlowsSetupList()
{
    return m_QosFlowsSetupList;
}

void PduSessionCreatedData::setQosFlowsSetupList(const std::vector<std::shared_ptr<QosFlowSetupItem>>& value)
{
    m_QosFlowsSetupList = value;
    m_QosFlowsSetupListIsSet = true;
}

bool PduSessionCreatedData::qosFlowsSetupListIsSet() const
{
    return m_QosFlowsSetupListIsSet;
}

void PduSessionCreatedData::unsetQosFlowsSetupList()
{
    m_QosFlowsSetupListIsSet = false;
}

utility::string_t PduSessionCreatedData::getHSmfInstanceId() const
{
    return m_HSmfInstanceId;
}

void PduSessionCreatedData::setHSmfInstanceId(const utility::string_t& value)
{
    m_HSmfInstanceId = value;
    
}

int32_t PduSessionCreatedData::getPduSessionId() const
{
    return m_PduSessionId;
}

void PduSessionCreatedData::setPduSessionId(int32_t value)
{
    m_PduSessionId = value;
    m_PduSessionIdIsSet = true;
}

bool PduSessionCreatedData::pduSessionIdIsSet() const
{
    return m_PduSessionIdIsSet;
}

void PduSessionCreatedData::unsetPduSessionId()
{
    m_PduSessionIdIsSet = false;
}

std::shared_ptr<Snssai> PduSessionCreatedData::getSNssai() const
{
    return m_SNssai;
}

void PduSessionCreatedData::setSNssai(const std::shared_ptr<Snssai>& value)
{
    m_SNssai = value;
    m_SNssaiIsSet = true;
}

bool PduSessionCreatedData::sNssaiIsSet() const
{
    return m_SNssaiIsSet;
}

void PduSessionCreatedData::unsetSNssai()
{
    m_SNssaiIsSet = false;
}

bool PduSessionCreatedData::isEnablePauseCharging() const
{
    return m_EnablePauseCharging;
}

void PduSessionCreatedData::setEnablePauseCharging(bool value)
{
    m_EnablePauseCharging = value;
    m_EnablePauseChargingIsSet = true;
}

bool PduSessionCreatedData::enablePauseChargingIsSet() const
{
    return m_EnablePauseChargingIsSet;
}

void PduSessionCreatedData::unsetEnablePauseCharging()
{
    m_EnablePauseChargingIsSet = false;
}

utility::string_t PduSessionCreatedData::getUeIpv4Address() const
{
    return m_UeIpv4Address;
}

void PduSessionCreatedData::setUeIpv4Address(const utility::string_t& value)
{
    m_UeIpv4Address = value;
    m_UeIpv4AddressIsSet = true;
}

bool PduSessionCreatedData::ueIpv4AddressIsSet() const
{
    return m_UeIpv4AddressIsSet;
}

void PduSessionCreatedData::unsetUeIpv4Address()
{
    m_UeIpv4AddressIsSet = false;
}

utility::string_t PduSessionCreatedData::getUeIpv6Prefix() const
{
    return m_UeIpv6Prefix;
}

void PduSessionCreatedData::setUeIpv6Prefix(const utility::string_t& value)
{
    m_UeIpv6Prefix = value;
    m_UeIpv6PrefixIsSet = true;
}

bool PduSessionCreatedData::ueIpv6PrefixIsSet() const
{
    return m_UeIpv6PrefixIsSet;
}

void PduSessionCreatedData::unsetUeIpv6Prefix()
{
    m_UeIpv6PrefixIsSet = false;
}

std::shared_ptr<RefToBinaryData> PduSessionCreatedData::getN1SmInfoToUe() const
{
    return m_N1SmInfoToUe;
}

void PduSessionCreatedData::setN1SmInfoToUe(const std::shared_ptr<RefToBinaryData>& value)
{
    m_N1SmInfoToUe = value;
    m_N1SmInfoToUeIsSet = true;
}

bool PduSessionCreatedData::n1SmInfoToUeIsSet() const
{
    return m_N1SmInfoToUeIsSet;
}

void PduSessionCreatedData::unsetN1SmInfoToUe()
{
    m_N1SmInfoToUeIsSet = false;
}

std::shared_ptr<EpsPdnCnxInfo> PduSessionCreatedData::getEpsPdnCnxInfo() const
{
    return m_EpsPdnCnxInfo;
}

void PduSessionCreatedData::setEpsPdnCnxInfo(const std::shared_ptr<EpsPdnCnxInfo>& value)
{
    m_EpsPdnCnxInfo = value;
    m_EpsPdnCnxInfoIsSet = true;
}

bool PduSessionCreatedData::epsPdnCnxInfoIsSet() const
{
    return m_EpsPdnCnxInfoIsSet;
}

void PduSessionCreatedData::unsetEpsPdnCnxInfo()
{
    m_EpsPdnCnxInfoIsSet = false;
}

std::vector<std::shared_ptr<EpsBearerInfo>>& PduSessionCreatedData::getEpsBearerInfo()
{
    return m_EpsBearerInfo;
}

void PduSessionCreatedData::setEpsBearerInfo(const std::vector<std::shared_ptr<EpsBearerInfo>>& value)
{
    m_EpsBearerInfo = value;
    m_EpsBearerInfoIsSet = true;
}

bool PduSessionCreatedData::epsBearerInfoIsSet() const
{
    return m_EpsBearerInfoIsSet;
}

void PduSessionCreatedData::unsetEpsBearerInfo()
{
    m_EpsBearerInfoIsSet = false;
}

utility::string_t PduSessionCreatedData::getSupportedFeatures() const
{
    return m_SupportedFeatures;
}

void PduSessionCreatedData::setSupportedFeatures(const utility::string_t& value)
{
    m_SupportedFeatures = value;
    m_SupportedFeaturesIsSet = true;
}

bool PduSessionCreatedData::supportedFeaturesIsSet() const
{
    return m_SupportedFeaturesIsSet;
}

void PduSessionCreatedData::unsetSupportedFeatures()
{
    m_SupportedFeaturesIsSet = false;
}

std::shared_ptr<MaxIntegrityProtectedDataRate> PduSessionCreatedData::getMaxIntegrityProtectedDataRate() const
{
    return m_MaxIntegrityProtectedDataRate;
}

void PduSessionCreatedData::setMaxIntegrityProtectedDataRate(const std::shared_ptr<MaxIntegrityProtectedDataRate>& value)
{
    m_MaxIntegrityProtectedDataRate = value;
    m_MaxIntegrityProtectedDataRateIsSet = true;
}

bool PduSessionCreatedData::maxIntegrityProtectedDataRateIsSet() const
{
    return m_MaxIntegrityProtectedDataRateIsSet;
}

void PduSessionCreatedData::unsetMaxIntegrityProtectedDataRate()
{
    m_MaxIntegrityProtectedDataRateIsSet = false;
}

bool PduSessionCreatedData::isAlwaysOnGranted() const
{
    return m_AlwaysOnGranted;
}

void PduSessionCreatedData::setAlwaysOnGranted(bool value)
{
    m_AlwaysOnGranted = value;
    m_AlwaysOnGrantedIsSet = true;
}

bool PduSessionCreatedData::alwaysOnGrantedIsSet() const
{
    return m_AlwaysOnGrantedIsSet;
}

void PduSessionCreatedData::unsetAlwaysOnGranted()
{
    m_AlwaysOnGrantedIsSet = false;
}

utility::string_t PduSessionCreatedData::getGpsi() const
{
    return m_Gpsi;
}

void PduSessionCreatedData::setGpsi(const utility::string_t& value)
{
    m_Gpsi = value;
    m_GpsiIsSet = true;
}

bool PduSessionCreatedData::gpsiIsSet() const
{
    return m_GpsiIsSet;
}

void PduSessionCreatedData::unsetGpsi()
{
    m_GpsiIsSet = false;
}

std::shared_ptr<UpSecurity> PduSessionCreatedData::getUpSecurity() const
{
    return m_UpSecurity;
}

void PduSessionCreatedData::setUpSecurity(const std::shared_ptr<UpSecurity>& value)
{
    m_UpSecurity = value;
    m_UpSecurityIsSet = true;
}

bool PduSessionCreatedData::upSecurityIsSet() const
{
    return m_UpSecurityIsSet;
}

void PduSessionCreatedData::unsetUpSecurity()
{
    m_UpSecurityIsSet = false;
}

std::shared_ptr<RoamingChargingProfile> PduSessionCreatedData::getRoamingChargingProfile() const
{
    return m_RoamingChargingProfile;
}

void PduSessionCreatedData::setRoamingChargingProfile(const std::shared_ptr<RoamingChargingProfile>& value)
{
    m_RoamingChargingProfile = value;
    m_RoamingChargingProfileIsSet = true;
}

bool PduSessionCreatedData::roamingChargingProfileIsSet() const
{
    return m_RoamingChargingProfileIsSet;
}

void PduSessionCreatedData::unsetRoamingChargingProfile()
{
    m_RoamingChargingProfileIsSet = false;
}

utility::string_t PduSessionCreatedData::getHSmfServiceInstanceId() const
{
    return m_HSmfServiceInstanceId;
}

void PduSessionCreatedData::setHSmfServiceInstanceId(const utility::string_t& value)
{
    m_HSmfServiceInstanceId = value;
    m_HSmfServiceInstanceIdIsSet = true;
}

bool PduSessionCreatedData::hSmfServiceInstanceIdIsSet() const
{
    return m_HSmfServiceInstanceIdIsSet;
}

void PduSessionCreatedData::unsetHSmfServiceInstanceId()
{
    m_HSmfServiceInstanceIdIsSet = false;
}

utility::datetime PduSessionCreatedData::getRecoveryTime() const
{
    return m_RecoveryTime;
}

void PduSessionCreatedData::setRecoveryTime(const utility::datetime& value)
{
    m_RecoveryTime = value;
    m_RecoveryTimeIsSet = true;
}

bool PduSessionCreatedData::recoveryTimeIsSet() const
{
    return m_RecoveryTimeIsSet;
}

void PduSessionCreatedData::unsetRecoveryTime()
{
    m_RecoveryTimeIsSet = false;
}

}
}
}


