/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * PduSessionCreatedData.h
 *
 * 
 */

#ifndef OAI_SMF_MODEL_PduSessionCreatedData_H_
#define OAI_SMF_MODEL_PduSessionCreatedData_H_


#include "../ModelBase.h"

#include "Ambr.h"
#include "MaxIntegrityProtectedDataRate.h"
#include "RefToBinaryData.h"
#include "UpSecurity.h"
#include "QosFlowSetupItem.h"
#include "Snssai.h"
#include <vector>
#include "EpsPdnCnxInfo.h"
#include "EpsBearerInfo.h"
#include "PduSessionType.h"
#include "RoamingChargingProfile.h"
#include <cpprest/details/basic_types.h>
#include "TunnelInfo.h"

namespace oai {
namespace smf {
namespace model {


/// <summary>
/// 
/// </summary>
class  PduSessionCreatedData
    : public ModelBase
{
public:
    PduSessionCreatedData();
    virtual ~PduSessionCreatedData();

    /////////////////////////////////////////////
    /// ModelBase overrides

    void validate() override;

    web::json::value toJson() const override;
    void fromJson(const web::json::value& json) override;

    void toMultipart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& namePrefix) const override;
    void fromMultiPart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& namePrefix) override;

    /////////////////////////////////////////////
    /// PduSessionCreatedData members

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<PduSessionType> getPduSessionType() const;
    
    void setPduSessionType(const std::shared_ptr<PduSessionType>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getSscMode() const;
    
    void setSscMode(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<TunnelInfo> getHcnTunnelInfo() const;
    bool hcnTunnelInfoIsSet() const;
    void unsetHcnTunnelInfo();

    void setHcnTunnelInfo(const std::shared_ptr<TunnelInfo>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<Ambr> getSessionAmbr() const;
    bool sessionAmbrIsSet() const;
    void unsetSessionAmbr();

    void setSessionAmbr(const std::shared_ptr<Ambr>& value);

    /// <summary>
    /// 
    /// </summary>
    std::vector<std::shared_ptr<QosFlowSetupItem>>& getQosFlowsSetupList();
    bool qosFlowsSetupListIsSet() const;
    void unsetQosFlowsSetupList();

    void setQosFlowsSetupList(const std::vector<std::shared_ptr<QosFlowSetupItem>>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getHSmfInstanceId() const;
    
    void setHSmfInstanceId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    int32_t getPduSessionId() const;
    bool pduSessionIdIsSet() const;
    void unsetPduSessionId();

    void setPduSessionId(int32_t value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<Snssai> getSNssai() const;
    bool sNssaiIsSet() const;
    void unsetSNssai();

    void setSNssai(const std::shared_ptr<Snssai>& value);

    /// <summary>
    /// 
    /// </summary>
    bool isEnablePauseCharging() const;
    bool enablePauseChargingIsSet() const;
    void unsetEnablePauseCharging();

    void setEnablePauseCharging(bool value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getUeIpv4Address() const;
    bool ueIpv4AddressIsSet() const;
    void unsetUeIpv4Address();

    void setUeIpv4Address(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getUeIpv6Prefix() const;
    bool ueIpv6PrefixIsSet() const;
    void unsetUeIpv6Prefix();

    void setUeIpv6Prefix(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<RefToBinaryData> getN1SmInfoToUe() const;
    bool n1SmInfoToUeIsSet() const;
    void unsetN1SmInfoToUe();

    void setN1SmInfoToUe(const std::shared_ptr<RefToBinaryData>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<EpsPdnCnxInfo> getEpsPdnCnxInfo() const;
    bool epsPdnCnxInfoIsSet() const;
    void unsetEpsPdnCnxInfo();

    void setEpsPdnCnxInfo(const std::shared_ptr<EpsPdnCnxInfo>& value);

    /// <summary>
    /// 
    /// </summary>
    std::vector<std::shared_ptr<EpsBearerInfo>>& getEpsBearerInfo();
    bool epsBearerInfoIsSet() const;
    void unsetEpsBearerInfo();

    void setEpsBearerInfo(const std::vector<std::shared_ptr<EpsBearerInfo>>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getSupportedFeatures() const;
    bool supportedFeaturesIsSet() const;
    void unsetSupportedFeatures();

    void setSupportedFeatures(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<MaxIntegrityProtectedDataRate> getMaxIntegrityProtectedDataRate() const;
    bool maxIntegrityProtectedDataRateIsSet() const;
    void unsetMaxIntegrityProtectedDataRate();

    void setMaxIntegrityProtectedDataRate(const std::shared_ptr<MaxIntegrityProtectedDataRate>& value);

    /// <summary>
    /// 
    /// </summary>
    bool isAlwaysOnGranted() const;
    bool alwaysOnGrantedIsSet() const;
    void unsetAlwaysOnGranted();

    void setAlwaysOnGranted(bool value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getGpsi() const;
    bool gpsiIsSet() const;
    void unsetGpsi();

    void setGpsi(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<UpSecurity> getUpSecurity() const;
    bool upSecurityIsSet() const;
    void unsetUpSecurity();

    void setUpSecurity(const std::shared_ptr<UpSecurity>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<RoamingChargingProfile> getRoamingChargingProfile() const;
    bool roamingChargingProfileIsSet() const;
    void unsetRoamingChargingProfile();

    void setRoamingChargingProfile(const std::shared_ptr<RoamingChargingProfile>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getHSmfServiceInstanceId() const;
    bool hSmfServiceInstanceIdIsSet() const;
    void unsetHSmfServiceInstanceId();

    void setHSmfServiceInstanceId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::datetime getRecoveryTime() const;
    bool recoveryTimeIsSet() const;
    void unsetRecoveryTime();

    void setRecoveryTime(const utility::datetime& value);


protected:
    std::shared_ptr<PduSessionType> m_PduSessionType;
        utility::string_t m_SscMode;
        std::shared_ptr<TunnelInfo> m_HcnTunnelInfo;
    bool m_HcnTunnelInfoIsSet;
    std::shared_ptr<Ambr> m_SessionAmbr;
    bool m_SessionAmbrIsSet;
    std::vector<std::shared_ptr<QosFlowSetupItem>> m_QosFlowsSetupList;
    bool m_QosFlowsSetupListIsSet;
    utility::string_t m_HSmfInstanceId;
        int32_t m_PduSessionId;
    bool m_PduSessionIdIsSet;
    std::shared_ptr<Snssai> m_SNssai;
    bool m_SNssaiIsSet;
    bool m_EnablePauseCharging;
    bool m_EnablePauseChargingIsSet;
    utility::string_t m_UeIpv4Address;
    bool m_UeIpv4AddressIsSet;
    utility::string_t m_UeIpv6Prefix;
    bool m_UeIpv6PrefixIsSet;
    std::shared_ptr<RefToBinaryData> m_N1SmInfoToUe;
    bool m_N1SmInfoToUeIsSet;
    std::shared_ptr<EpsPdnCnxInfo> m_EpsPdnCnxInfo;
    bool m_EpsPdnCnxInfoIsSet;
    std::vector<std::shared_ptr<EpsBearerInfo>> m_EpsBearerInfo;
    bool m_EpsBearerInfoIsSet;
    utility::string_t m_SupportedFeatures;
    bool m_SupportedFeaturesIsSet;
    std::shared_ptr<MaxIntegrityProtectedDataRate> m_MaxIntegrityProtectedDataRate;
    bool m_MaxIntegrityProtectedDataRateIsSet;
    bool m_AlwaysOnGranted;
    bool m_AlwaysOnGrantedIsSet;
    utility::string_t m_Gpsi;
    bool m_GpsiIsSet;
    std::shared_ptr<UpSecurity> m_UpSecurity;
    bool m_UpSecurityIsSet;
    std::shared_ptr<RoamingChargingProfile> m_RoamingChargingProfile;
    bool m_RoamingChargingProfileIsSet;
    utility::string_t m_HSmfServiceInstanceId;
    bool m_HSmfServiceInstanceIdIsSet;
    utility::datetime m_RecoveryTime;
    bool m_RecoveryTimeIsSet;
};


}
}
}

#endif /* OAI_SMF_MODEL_PduSessionCreatedData_H_ */
