/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * SmContext.h
 *
 * 
 */

#ifndef OAI_SMF_MODEL_SmContext_H_
#define OAI_SMF_MODEL_SmContext_H_


#include "../ModelBase.h"

#include "Ambr.h"
#include "MaxIntegrityProtectedDataRate.h"
#include "RatType.h"
#include "UpSecurity.h"
#include "QosFlowSetupItem.h"
#include "PlmnId.h"
#include "Snssai.h"
#include "TraceData.h"
#include <vector>
#include "AccessType.h"
#include "DnnSelectionMode.h"
#include "EpsPdnCnxInfo.h"
#include "EpsBearerInfo.h"
#include "EpsInterworkingIndication.h"
#include "ServiceName.h"
#include "PduSessionType.h"
#include <cpprest/details/basic_types.h>
#include "Guami.h"

namespace oai {
namespace smf {
namespace model {


/// <summary>
/// 
/// </summary>
class  SmContext
    : public ModelBase
{
public:
    SmContext();
    virtual ~SmContext();

    /////////////////////////////////////////////
    /// ModelBase overrides

    void validate() override;

    web::json::value toJson() const override;
    void fromJson(const web::json::value& json) override;

    void toMultipart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& namePrefix) const override;
    void fromMultiPart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& namePrefix) override;

    /////////////////////////////////////////////
    /// SmContext members

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getSupi() const;
    bool supiIsSet() const;
    void unsetSupi();

    void setSupi(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    bool isUnauthenticatedSupi() const;
    bool unauthenticatedSupiIsSet() const;
    void unsetUnauthenticatedSupi();

    void setUnauthenticatedSupi(bool value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getPei() const;
    bool peiIsSet() const;
    void unsetPei();

    void setPei(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getGpsi() const;
    bool gpsiIsSet() const;
    void unsetGpsi();

    void setGpsi(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    int32_t getPduSessionId() const;
    
    void setPduSessionId(int32_t value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getDnn() const;
    
    void setDnn(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<Snssai> getSNssai() const;
    
    void setSNssai(const std::shared_ptr<Snssai>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<Snssai> getHplmnSnssai() const;
    bool hplmnSnssaiIsSet() const;
    void unsetHplmnSnssai();

    void setHplmnSnssai(const std::shared_ptr<Snssai>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getServingNfId() const;
    
    void setServingNfId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<Guami> getGuami() const;
    bool guamiIsSet() const;
    void unsetGuami();

    void setGuami(const std::shared_ptr<Guami>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<ServiceName> getServiceName() const;
    bool serviceNameIsSet() const;
    void unsetServiceName();

    void setServiceName(const std::shared_ptr<ServiceName>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<PlmnId> getServingNetwork() const;
    
    void setServingNetwork(const std::shared_ptr<PlmnId>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<AccessType> getAnType() const;
    
    void setAnType(const std::shared_ptr<AccessType>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<RatType> getRatType() const;
    bool ratTypeIsSet() const;
    void unsetRatType();

    void setRatType(const std::shared_ptr<RatType>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getSmContextStatusUri() const;
    
    void setSmContextStatusUri(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getHSmfUri() const;
    bool hSmfUriIsSet() const;
    void unsetHSmfUri();

    void setHSmfUri(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getPcfId() const;
    bool pcfIdIsSet() const;
    void unsetPcfId();

    void setPcfId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<DnnSelectionMode> getSelMode() const;
    bool selModeIsSet() const;
    void unsetSelMode();

    void setSelMode(const std::shared_ptr<DnnSelectionMode>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<TraceData> getTraceData() const;
    bool traceDataIsSet() const;
    void unsetTraceData();

    void setTraceData(const std::shared_ptr<TraceData>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getUdmGroupId() const;
    bool udmGroupIdIsSet() const;
    void unsetUdmGroupId();

    void setUdmGroupId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getRoutingIndicator() const;
    bool routingIndicatorIsSet() const;
    void unsetRoutingIndicator();

    void setRoutingIndicator(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<EpsInterworkingIndication> getEpsInterworkingInd() const;
    bool epsInterworkingIndIsSet() const;
    void unsetEpsInterworkingInd();

    void setEpsInterworkingInd(const std::shared_ptr<EpsInterworkingIndication>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<PduSessionType> getPduSessionType() const;
    
    void setPduSessionType(const std::shared_ptr<PduSessionType>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getSscMode() const;
    
    void setSscMode(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<Ambr> getSessionAmbr() const;
    
    void setSessionAmbr(const std::shared_ptr<Ambr>& value);

    /// <summary>
    /// 
    /// </summary>
    std::vector<std::shared_ptr<QosFlowSetupItem>>& getQosFlowsSetupList();
    
    void setQosFlowsSetupList(const std::vector<std::shared_ptr<QosFlowSetupItem>>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getHSmfInstanceId() const;
    bool hSmfInstanceIdIsSet() const;
    void unsetHSmfInstanceId();

    void setHSmfInstanceId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    bool isEnablePauseCharging() const;
    bool enablePauseChargingIsSet() const;
    void unsetEnablePauseCharging();

    void setEnablePauseCharging(bool value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getUeIpv4Address() const;
    bool ueIpv4AddressIsSet() const;
    void unsetUeIpv4Address();

    void setUeIpv4Address(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getUeIpv6Prefix() const;
    bool ueIpv6PrefixIsSet() const;
    void unsetUeIpv6Prefix();

    void setUeIpv6Prefix(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<EpsPdnCnxInfo> getEpsPdnCnxInfo() const;
    bool epsPdnCnxInfoIsSet() const;
    void unsetEpsPdnCnxInfo();

    void setEpsPdnCnxInfo(const std::shared_ptr<EpsPdnCnxInfo>& value);

    /// <summary>
    /// 
    /// </summary>
    std::vector<std::shared_ptr<EpsBearerInfo>>& getEpsBearerInfo();
    bool epsBearerInfoIsSet() const;
    void unsetEpsBearerInfo();

    void setEpsBearerInfo(const std::vector<std::shared_ptr<EpsBearerInfo>>& value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<MaxIntegrityProtectedDataRate> getMaxIntegrityProtectedDataRate() const;
    bool maxIntegrityProtectedDataRateIsSet() const;
    void unsetMaxIntegrityProtectedDataRate();

    void setMaxIntegrityProtectedDataRate(const std::shared_ptr<MaxIntegrityProtectedDataRate>& value);

    /// <summary>
    /// 
    /// </summary>
    bool isAlwaysOnGranted() const;
    bool alwaysOnGrantedIsSet() const;
    void unsetAlwaysOnGranted();

    void setAlwaysOnGranted(bool value);

    /// <summary>
    /// 
    /// </summary>
    std::shared_ptr<UpSecurity> getUpSecurity() const;
    bool upSecurityIsSet() const;
    void unsetUpSecurity();

    void setUpSecurity(const std::shared_ptr<UpSecurity>& value);

    /// <summary>
    /// 
    /// </summary>
    utility::string_t getHSmfServiceInstanceId() const;
    bool hSmfServiceInstanceIdIsSet() const;
    void unsetHSmfServiceInstanceId();

    void setHSmfServiceInstanceId(const utility::string_t& value);

    /// <summary>
    /// 
    /// </summary>
    utility::datetime getRecoveryTime() const;
    bool recoveryTimeIsSet() const;
    void unsetRecoveryTime();

    void setRecoveryTime(const utility::datetime& value);


protected:
    utility::string_t m_Supi;
    bool m_SupiIsSet;
    bool m_UnauthenticatedSupi;
    bool m_UnauthenticatedSupiIsSet;
    utility::string_t m_Pei;
    bool m_PeiIsSet;
    utility::string_t m_Gpsi;
    bool m_GpsiIsSet;
    int32_t m_PduSessionId;
        utility::string_t m_Dnn;
        std::shared_ptr<Snssai> m_SNssai;
        std::shared_ptr<Snssai> m_HplmnSnssai;
    bool m_HplmnSnssaiIsSet;
    utility::string_t m_ServingNfId;
        std::shared_ptr<Guami> m_Guami;
    bool m_GuamiIsSet;
    std::shared_ptr<ServiceName> m_ServiceName;
    bool m_ServiceNameIsSet;
    std::shared_ptr<PlmnId> m_ServingNetwork;
        std::shared_ptr<AccessType> m_AnType;
        std::shared_ptr<RatType> m_RatType;
    bool m_RatTypeIsSet;
    utility::string_t m_SmContextStatusUri;
        utility::string_t m_HSmfUri;
    bool m_HSmfUriIsSet;
    utility::string_t m_PcfId;
    bool m_PcfIdIsSet;
    std::shared_ptr<DnnSelectionMode> m_SelMode;
    bool m_SelModeIsSet;
    std::shared_ptr<TraceData> m_TraceData;
    bool m_TraceDataIsSet;
    utility::string_t m_UdmGroupId;
    bool m_UdmGroupIdIsSet;
    utility::string_t m_RoutingIndicator;
    bool m_RoutingIndicatorIsSet;
    std::shared_ptr<EpsInterworkingIndication> m_EpsInterworkingInd;
    bool m_EpsInterworkingIndIsSet;
    std::shared_ptr<PduSessionType> m_PduSessionType;
        utility::string_t m_SscMode;
        std::shared_ptr<Ambr> m_SessionAmbr;
        std::vector<std::shared_ptr<QosFlowSetupItem>> m_QosFlowsSetupList;
        utility::string_t m_HSmfInstanceId;
    bool m_HSmfInstanceIdIsSet;
    bool m_EnablePauseCharging;
    bool m_EnablePauseChargingIsSet;
    utility::string_t m_UeIpv4Address;
    bool m_UeIpv4AddressIsSet;
    utility::string_t m_UeIpv6Prefix;
    bool m_UeIpv6PrefixIsSet;
    std::shared_ptr<EpsPdnCnxInfo> m_EpsPdnCnxInfo;
    bool m_EpsPdnCnxInfoIsSet;
    std::vector<std::shared_ptr<EpsBearerInfo>> m_EpsBearerInfo;
    bool m_EpsBearerInfoIsSet;
    std::shared_ptr<MaxIntegrityProtectedDataRate> m_MaxIntegrityProtectedDataRate;
    bool m_MaxIntegrityProtectedDataRateIsSet;
    bool m_AlwaysOnGranted;
    bool m_AlwaysOnGrantedIsSet;
    std::shared_ptr<UpSecurity> m_UpSecurity;
    bool m_UpSecurityIsSet;
    utility::string_t m_HSmfServiceInstanceId;
    bool m_HSmfServiceInstanceIdIsSet;
    utility::datetime m_RecoveryTime;
    bool m_RecoveryTimeIsSet;
};


}
}
}

#endif /* OAI_SMF_MODEL_SmContext_H_ */
