/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */



#include "VsmfUpdateError.h"

namespace oai {
namespace smf {
namespace model {




VsmfUpdateError::VsmfUpdateError()
{
    m_Pti = 0;
    m_PtiIsSet = false;
    m_N1smCause = utility::conversions::to_string_t("");
    m_N1smCauseIsSet = false;
    m_N1SmInfoFromUeIsSet = false;
    m_UnknownN1SmInfoIsSet = false;
    m_FailedToAssignEbiListIsSet = false;
    m_NgApCauseIsSet = false;
    m__5gMmCauseValue = 0;
    m__5gMmCauseValueIsSet = false;
    m_RecoveryTime = utility::datetime();
    m_RecoveryTimeIsSet = false;
}

VsmfUpdateError::~VsmfUpdateError()
{
}

void VsmfUpdateError::validate()
{
    // TODO: implement validation
}

web::json::value VsmfUpdateError::toJson() const
{
    web::json::value val = web::json::value::object();

    val[utility::conversions::to_string_t("error")] = ModelBase::toJson(m_Error);
    if(m_PtiIsSet)
    {
        val[utility::conversions::to_string_t("pti")] = ModelBase::toJson(m_Pti);
    }
    if(m_N1smCauseIsSet)
    {
        val[utility::conversions::to_string_t("n1smCause")] = ModelBase::toJson(m_N1smCause);
    }
    if(m_N1SmInfoFromUeIsSet)
    {
        val[utility::conversions::to_string_t("n1SmInfoFromUe")] = ModelBase::toJson(m_N1SmInfoFromUe);
    }
    if(m_UnknownN1SmInfoIsSet)
    {
        val[utility::conversions::to_string_t("unknownN1SmInfo")] = ModelBase::toJson(m_UnknownN1SmInfo);
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_FailedToAssignEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("failedToAssignEbiList")] = web::json::value::array(jsonArray);
        }
    }
    if(m_NgApCauseIsSet)
    {
        val[utility::conversions::to_string_t("ngApCause")] = ModelBase::toJson(m_NgApCause);
    }
    if(m__5gMmCauseValueIsSet)
    {
        val[utility::conversions::to_string_t("5gMmCauseValue")] = ModelBase::toJson(m__5gMmCauseValue);
    }
    if(m_RecoveryTimeIsSet)
    {
        val[utility::conversions::to_string_t("recoveryTime")] = ModelBase::toJson(m_RecoveryTime);
    }

    return val;
}

void VsmfUpdateError::fromJson(const web::json::value& val)
{
    std::shared_ptr<ProblemDetails_2> newError(new ProblemDetails_2());
    newError->fromJson(val.at(utility::conversions::to_string_t("error")));
    setError( newError );
    if(val.has_field(utility::conversions::to_string_t("pti")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("pti"));
        if(!fieldValue.is_null())
        {
            setPti(ModelBase::int32_tFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n1smCause")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n1smCause"));
        if(!fieldValue.is_null())
        {
            setN1smCause(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n1SmInfoFromUe")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n1SmInfoFromUe"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromJson(fieldValue);
            setN1SmInfoFromUe( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("unknownN1SmInfo")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("unknownN1SmInfo"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromJson(fieldValue);
            setUnknownN1SmInfo( newItem );
        }
    }
    {
        m_FailedToAssignEbiList.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("failedToAssignEbiList")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("failedToAssignEbiList")).as_array() )
        {
            m_FailedToAssignEbiList.push_back(ModelBase::int32_tFromJson(item));
        }
        }
    }
    if(val.has_field(utility::conversions::to_string_t("ngApCause")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("ngApCause"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<NgApCause> newItem(new NgApCause());
            newItem->fromJson(fieldValue);
            setNgApCause( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("5gMmCauseValue")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("5gMmCauseValue"));
        if(!fieldValue.is_null())
        {
            set5gMmCauseValue(ModelBase::int32_tFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("recoveryTime")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("recoveryTime"));
        if(!fieldValue.is_null())
        {
            setRecoveryTime(ModelBase::dateFromJson(fieldValue));
        }
    }
}

void VsmfUpdateError::toMultipart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix) const
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    m_Error->toMultipart(multipart, utility::conversions::to_string_t("error."));
    if(m_PtiIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("pti"), m_Pti));
    }
    if(m_N1smCauseIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("n1smCause"), m_N1smCause));
    }
    if(m_N1SmInfoFromUeIsSet)
    {
        if (m_N1SmInfoFromUe.get())
        {
            m_N1SmInfoFromUe->toMultipart(multipart, utility::conversions::to_string_t("n1SmInfoFromUe."));
        }
    }
    if(m_UnknownN1SmInfoIsSet)
    {
        if (m_UnknownN1SmInfo.get())
        {
            m_UnknownN1SmInfo->toMultipart(multipart, utility::conversions::to_string_t("unknownN1SmInfo."));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_FailedToAssignEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("failedToAssignEbiList"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    if(m_NgApCauseIsSet)
    {
        if (m_NgApCause.get())
        {
            m_NgApCause->toMultipart(multipart, utility::conversions::to_string_t("ngApCause."));
        }
    }
    if(m__5gMmCauseValueIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("5gMmCauseValue"), m__5gMmCauseValue));
    }
    if(m_RecoveryTimeIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("recoveryTime"), m_RecoveryTime));
    }
}

void VsmfUpdateError::fromMultiPart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix)
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    std::shared_ptr<ProblemDetails_2> newError(new ProblemDetails_2());
    newError->fromMultiPart(multipart, utility::conversions::to_string_t("error."));
    setError( newError );
    if(multipart->hasContent(utility::conversions::to_string_t("pti")))
    {
        setPti(ModelBase::int32_tFromHttpContent(multipart->getContent(utility::conversions::to_string_t("pti"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n1smCause")))
    {
        setN1smCause(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("n1smCause"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n1SmInfoFromUe")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("n1SmInfoFromUe")))
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("n1SmInfoFromUe."));
            setN1SmInfoFromUe( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("unknownN1SmInfo")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("unknownN1SmInfo")))
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("unknownN1SmInfo."));
            setUnknownN1SmInfo( newItem );
        }
    }
    {
        m_FailedToAssignEbiList.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("failedToAssignEbiList")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("failedToAssignEbiList"))));
        for( auto& item : jsonArray.as_array() )
        {
            m_FailedToAssignEbiList.push_back(ModelBase::int32_tFromJson(item));
        }
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("ngApCause")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("ngApCause")))
        {
            std::shared_ptr<NgApCause> newItem(new NgApCause());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("ngApCause."));
            setNgApCause( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("5gMmCauseValue")))
    {
        set5gMmCauseValue(ModelBase::int32_tFromHttpContent(multipart->getContent(utility::conversions::to_string_t("5gMmCauseValue"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("recoveryTime")))
    {
        setRecoveryTime(ModelBase::dateFromHttpContent(multipart->getContent(utility::conversions::to_string_t("recoveryTime"))));
    }
}

std::shared_ptr<ProblemDetails_2> VsmfUpdateError::getError() const
{
    return m_Error;
}

void VsmfUpdateError::setError(const std::shared_ptr<ProblemDetails_2>& value)
{
    m_Error = value;
    
}

int32_t VsmfUpdateError::getPti() const
{
    return m_Pti;
}

void VsmfUpdateError::setPti(int32_t value)
{
    m_Pti = value;
    m_PtiIsSet = true;
}

bool VsmfUpdateError::ptiIsSet() const
{
    return m_PtiIsSet;
}

void VsmfUpdateError::unsetPti()
{
    m_PtiIsSet = false;
}

utility::string_t VsmfUpdateError::getN1smCause() const
{
    return m_N1smCause;
}

void VsmfUpdateError::setN1smCause(const utility::string_t& value)
{
    m_N1smCause = value;
    m_N1smCauseIsSet = true;
}

bool VsmfUpdateError::n1smCauseIsSet() const
{
    return m_N1smCauseIsSet;
}

void VsmfUpdateError::unsetN1smCause()
{
    m_N1smCauseIsSet = false;
}

std::shared_ptr<RefToBinaryData> VsmfUpdateError::getN1SmInfoFromUe() const
{
    return m_N1SmInfoFromUe;
}

void VsmfUpdateError::setN1SmInfoFromUe(const std::shared_ptr<RefToBinaryData>& value)
{
    m_N1SmInfoFromUe = value;
    m_N1SmInfoFromUeIsSet = true;
}

bool VsmfUpdateError::n1SmInfoFromUeIsSet() const
{
    return m_N1SmInfoFromUeIsSet;
}

void VsmfUpdateError::unsetN1SmInfoFromUe()
{
    m_N1SmInfoFromUeIsSet = false;
}

std::shared_ptr<RefToBinaryData> VsmfUpdateError::getUnknownN1SmInfo() const
{
    return m_UnknownN1SmInfo;
}

void VsmfUpdateError::setUnknownN1SmInfo(const std::shared_ptr<RefToBinaryData>& value)
{
    m_UnknownN1SmInfo = value;
    m_UnknownN1SmInfoIsSet = true;
}

bool VsmfUpdateError::unknownN1SmInfoIsSet() const
{
    return m_UnknownN1SmInfoIsSet;
}

void VsmfUpdateError::unsetUnknownN1SmInfo()
{
    m_UnknownN1SmInfoIsSet = false;
}

std::vector<int32_t>& VsmfUpdateError::getFailedToAssignEbiList()
{
    return m_FailedToAssignEbiList;
}

void VsmfUpdateError::setFailedToAssignEbiList(std::vector<int32_t> value)
{
    m_FailedToAssignEbiList = value;
    m_FailedToAssignEbiListIsSet = true;
}

bool VsmfUpdateError::failedToAssignEbiListIsSet() const
{
    return m_FailedToAssignEbiListIsSet;
}

void VsmfUpdateError::unsetFailedToAssignEbiList()
{
    m_FailedToAssignEbiListIsSet = false;
}

std::shared_ptr<NgApCause> VsmfUpdateError::getNgApCause() const
{
    return m_NgApCause;
}

void VsmfUpdateError::setNgApCause(const std::shared_ptr<NgApCause>& value)
{
    m_NgApCause = value;
    m_NgApCauseIsSet = true;
}

bool VsmfUpdateError::ngApCauseIsSet() const
{
    return m_NgApCauseIsSet;
}

void VsmfUpdateError::unsetNgApCause()
{
    m_NgApCauseIsSet = false;
}

int32_t VsmfUpdateError::get5gMmCauseValue() const
{
    return m__5gMmCauseValue;
}

void VsmfUpdateError::set5gMmCauseValue(int32_t value)
{
    m__5gMmCauseValue = value;
    m__5gMmCauseValueIsSet = true;
}

bool VsmfUpdateError::_5gMmCauseValueIsSet() const
{
    return m__5gMmCauseValueIsSet;
}

void VsmfUpdateError::unset_5gMmCauseValue()
{
    m__5gMmCauseValueIsSet = false;
}

utility::datetime VsmfUpdateError::getRecoveryTime() const
{
    return m_RecoveryTime;
}

void VsmfUpdateError::setRecoveryTime(const utility::datetime& value)
{
    m_RecoveryTime = value;
    m_RecoveryTimeIsSet = true;
}

bool VsmfUpdateError::recoveryTimeIsSet() const
{
    return m_RecoveryTimeIsSet;
}

void VsmfUpdateError::unsetRecoveryTime()
{
    m_RecoveryTimeIsSet = false;
}

}
}
}


