/**
 * Namf_Communication
 * AMF Communication Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */
/*
 * IndividualUeContextDocumentApi.h
 *
 *
 */

#ifndef IndividualUeContextDocumentApi_H_
#define IndividualUeContextDocumentApi_H_

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>

#include "AssignEbiData.h"
#include "AssignEbiError.h"
#include "AssignedEbiData.h"
#include "Inline_object.h"
#include "ProblemDetails.h"
#include "UEContextRelease.h"
#include "UeContextCreateError.h"
#include "UeContextCreatedData.h"
#include "UeContextTransferReqData.h"
#include "UeContextTransferRspData.h"
#include "UeRegStatusUpdateReqData.h"
#include "UeRegStatusUpdateRspData.h"
#include <string>

namespace oai {
namespace amf {
namespace api {

using namespace oai::amf::model;

class IndividualUeContextDocumentApi {
 public:
  IndividualUeContextDocumentApi(std::shared_ptr<Pistache::Rest::Router>);
  virtual ~IndividualUeContextDocumentApi() {}
  void init();

  const std::string base = "/namf-comm/v1";

 private:
  void setupRoutes();

  void create_ue_context_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void e_bi_assignment_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void registration_status_update_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void release_ue_context_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void u_e_context_transfer_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void individual_ue_context_document_api_default_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);

  std::shared_ptr<Pistache::Rest::Router> router;

  /// <summary>
  /// Namf_Communication CreateUEContext service Operation
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="ueContextId">UE Context Identifier</param>
  /// <param name="inlineObject"></param>
  virtual void create_ue_context(
      const std::string& ueContextId, const Inline_object& inlineObject,
      Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Namf_Communication EBI Assignment service Operation
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="ueContextId">UE Context Identifier</param>
  /// <param name="assignEbiData"></param>
  virtual void e_bi_assignment(
      const std::string& ueContextId, const AssignEbiData& assignEbiData,
      Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Namf_Communication RegistrationStatusUpdate service Operation
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="ueContextId">UE Context Identifier</param>
  /// <param name="ueRegStatusUpdateReqData"></param>
  virtual void registration_status_update(
      const std::string& ueContextId,
      const UeRegStatusUpdateReqData& ueRegStatusUpdateReqData,
      Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Namf_Communication ReleaseUEContext service Operation
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="ueContextId">UE Context Identifier</param>
  /// <param name="uEContextRelease"></param>
  virtual void release_ue_context(
      const std::string& ueContextId, const UEContextRelease& uEContextRelease,
      Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Namf_Communication UEContextTransfer service Operation
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="ueContextId">UE Context Identifier</param>
  /// <param name="ueContextTransferReqData"></param>
  virtual void u_e_context_transfer(
      const std::string& ueContextId,
      const UeContextTransferReqData& ueContextTransferReqData,
      Pistache::Http::ResponseWriter& response) = 0;
};

}  // namespace api
}  // namespace amf
}  // namespace oai

#endif /* IndividualUeContextDocumentApi_H_ */
