/**
 * Namf_Communication
 * AMF Communication Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

/*
 * IndividualUeContextDocumentApiImpl.h
 *
 *
 */

#ifndef INDIVIDUAL_UE_CONTEXT_DOCUMENT_API_IMPL_H_
#define INDIVIDUAL_UE_CONTEXT_DOCUMENT_API_IMPL_H_

#include <pistache/endpoint.h>
#include <pistache/http.h>
#include <pistache/router.h>
#include <memory>

#include <IndividualUeContextDocumentApi.h>

#include <pistache/optional.h>

#include "AssignEbiData.h"
#include "AssignEbiError.h"
#include "AssignedEbiData.h"
#include "Inline_object.h"
#include "ProblemDetails.h"
#include "UEContextRelease.h"
#include "UeContextCreateError.h"
#include "UeContextCreatedData.h"
#include "UeContextTransferReqData.h"
#include "UeContextTransferRspData.h"
#include "UeRegStatusUpdateReqData.h"
#include "UeRegStatusUpdateRspData.h"
#include <string>

#include "amf_app.hpp"

namespace oai {
namespace amf {
namespace api {

using namespace oai::amf::model;

class IndividualUeContextDocumentApiImpl
    : public oai::amf::api::IndividualUeContextDocumentApi {
 public:
  IndividualUeContextDocumentApiImpl(
      std::shared_ptr<Pistache::Rest::Router>,
      amf_application::amf_app* amf_app_inst);
  ~IndividualUeContextDocumentApiImpl() {}

  void create_ue_context(
      const std::string& ueContextId, const Inline_object& inlineObject,
      Pistache::Http::ResponseWriter& response);
  void e_bi_assignment(
      const std::string& ueContextId, const AssignEbiData& assignEbiData,
      Pistache::Http::ResponseWriter& response);
  void registration_status_update(
      const std::string& ueContextId,
      const UeRegStatusUpdateReqData& ueRegStatusUpdateReqData,
      Pistache::Http::ResponseWriter& response);
  void release_ue_context(
      const std::string& ueContextId, const UEContextRelease& uEContextRelease,
      Pistache::Http::ResponseWriter& response);
  void u_e_context_transfer(
      const std::string& ueContextId,
      const UeContextTransferReqData& ueContextTransferReqData,
      Pistache::Http::ResponseWriter& response);

 private:
  amf_application::amf_app* m_amf_app;
};

}  // namespace api
}  // namespace amf
}  // namespace oai

#endif
