/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "Arp.h"

namespace oai {
namespace smf {
namespace model {

Arp::Arp() {
  m_PriorityLevel = 0;
}

Arp::~Arp() {}

void Arp::validate() {
  // TODO: implement validation
}

web::json::value Arp::toJson() const {
  web::json::value val = web::json::value::object();

  val[utility::conversions::to_string_t("priorityLevel")] =
      ModelBase::toJson(m_PriorityLevel);
  val[utility::conversions::to_string_t("preemptCap")] =
      ModelBase::toJson(m_PreemptCap);
  val[utility::conversions::to_string_t("preemptVuln")] =
      ModelBase::toJson(m_PreemptVuln);

  return val;
}

void Arp::fromJson(const web::json::value& val) {
  setPriorityLevel(ModelBase::int32_tFromJson(
      val.at(utility::conversions::to_string_t("priorityLevel"))));
  std::shared_ptr<PreemptionCapability> newPreemptCap(
      new PreemptionCapability());
  newPreemptCap->fromJson(
      val.at(utility::conversions::to_string_t("preemptCap")));
  setPreemptCap(newPreemptCap);
  std::shared_ptr<PreemptionVulnerability> newPreemptVuln(
      new PreemptionVulnerability());
  newPreemptVuln->fromJson(
      val.at(utility::conversions::to_string_t("preemptVuln")));
  setPreemptVuln(newPreemptVuln);
}

void Arp::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("priorityLevel"),
      m_PriorityLevel));
  m_PreemptCap->toMultipart(
      multipart, utility::conversions::to_string_t("preemptCap."));
  m_PreemptVuln->toMultipart(
      multipart, utility::conversions::to_string_t("preemptVuln."));
}

void Arp::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  setPriorityLevel(ModelBase::int32_tFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("priorityLevel"))));
  std::shared_ptr<PreemptionCapability> newPreemptCap(
      new PreemptionCapability());
  newPreemptCap->fromMultiPart(
      multipart, utility::conversions::to_string_t("preemptCap."));
  setPreemptCap(newPreemptCap);
  std::shared_ptr<PreemptionVulnerability> newPreemptVuln(
      new PreemptionVulnerability());
  newPreemptVuln->fromMultiPart(
      multipart, utility::conversions::to_string_t("preemptVuln."));
  setPreemptVuln(newPreemptVuln);
}

int32_t Arp::getPriorityLevel() const {
  return m_PriorityLevel;
}

void Arp::setPriorityLevel(int32_t value) {
  m_PriorityLevel = value;
}

std::shared_ptr<PreemptionCapability> Arp::getPreemptCap() const {
  return m_PreemptCap;
}

void Arp::setPreemptCap(const std::shared_ptr<PreemptionCapability>& value) {
  m_PreemptCap = value;
}

std::shared_ptr<PreemptionVulnerability> Arp::getPreemptVuln() const {
  return m_PreemptVuln;
}

void Arp::setPreemptVuln(
    const std::shared_ptr<PreemptionVulnerability>& value) {
  m_PreemptVuln = value;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
